/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.topic;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import kafka.durability.DurabilityTestUtilConstants$;
import kafka.durability.DurabilityTestUtils$;
import kafka.durability.Utils$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.broker.DeleteRecordsEvent;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.broker.OffsetChangeEvent;
import kafka.durability.events.broker.OffsetChangeEvent$;
import kafka.durability.events.broker.RetentionChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.events.controller.kraft.KRaftHWMChangeEvent;
import kafka.durability.events.controller.kraft.KRaftLeaderChangeEvent;
import kafka.durability.events.controller.kraft.KRaftLogSnapshotGenerationEvent;
import kafka.durability.events.controller.kraft.KRaftLogStartOffsetChangeEvent;
import kafka.durability.events.controller.kraft.KRaftNodeStartUpEvent;
import kafka.durability.topic.DurabilityTopicMessageFormatter;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001\u0002\u0011\"\u0001!BQa\f\u0001\u0005\u0002AB\u0011b\r\u0001A\u0002\u0003\u0007I\u0011\u0001\u001b\t\u0013a\u0002\u0001\u0019!a\u0001\n\u0003I\u0004\"C \u0001\u0001\u0004\u0005\t\u0015)\u00036\u0011%\u0001\u0005\u00011AA\u0002\u0013\u0005\u0011\tC\u0005N\u0001\u0001\u0007\t\u0019!C\u0001\u001d\"I\u0001\u000b\u0001a\u0001\u0002\u0003\u0006KA\u0011\u0005\n#\u0002\u0001\r\u00111A\u0005\u0002IC\u0011B\u0016\u0001A\u0002\u0003\u0007I\u0011A,\t\u0013e\u0003\u0001\u0019!A!B\u0013\u0019\u0006\"\u0003.\u0001\u0001\u0004\u0005\r\u0011\"\u0001S\u0011%Y\u0006\u00011AA\u0002\u0013\u0005A\fC\u0005_\u0001\u0001\u0007\t\u0011)Q\u0005'\"Iq\f\u0001a\u0001\u0002\u0004%\t\u0001\u0019\u0005\nS\u0002\u0001\r\u00111A\u0005\u0002)D\u0011\u0002\u001c\u0001A\u0002\u0003\u0005\u000b\u0015B1\t\u00135\u0004\u0001\u0019!a\u0001\n\u0003q\u0007\"\u0003:\u0001\u0001\u0004\u0005\r\u0011\"\u0001t\u0011%)\b\u00011A\u0001B\u0003&q\u000eC\u0003w\u0001\u0011\u0005q\u000f\u0003\u0004\u0002\b\u0001!\ta\u001e\u0005\u0007\u0003#\u0001A\u0011A<\t\r\u0005U\u0001\u0001\"\u0001x\u0011\u0019\tI\u0002\u0001C\u0001o\"1\u0011Q\u0004\u0001\u0005\u0002]Da!!\t\u0001\t\u00039\bBBA\u0013\u0001\u0011\u0005q\u000f\u0003\u0004\u0002*\u0001!\ta\u001e\u0005\u0007\u0003[\u0001A\u0011A<\t\r\u0005E\u0002\u0001\"\u0001x\u0011\u0019\t)\u0004\u0001C\u0001o\n\u0019C)\u001e:bE&d\u0017\u000e^=U_BL7-T3tg\u0006<WMR8s[\u0006$H/\u001a:UKN$(B\u0001\u0012$\u0003\u0015!x\u000e]5d\u0015\t!S%\u0001\u0006ekJ\f'-\u001b7jifT\u0011AJ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0002\"A\r\u0001\u000e\u0003\u0005\n\u0011BZ8s[\u0006$H/\u001a:\u0016\u0003U\u0002\"A\r\u001c\n\u0005]\n#a\b#ve\u0006\u0014\u0017\u000e\\5usR{\u0007/[2NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e;fe\u0006iam\u001c:nCR$XM]0%KF$\"AO\u001f\u0011\u0005)Z\u0014B\u0001\u001f,\u0005\u0011)f.\u001b;\t\u000fy\u001a\u0011\u0011!a\u0001k\u0005\u0019\u0001\u0010J\u0019\u0002\u0015\u0019|'/\\1ui\u0016\u0014\b%\u0001\u0003ua&$W#\u0001\"\u0011\u0005\r[U\"\u0001#\u000b\u0005\u00153\u0015AB2p[6|gN\u0003\u0002'\u000f*\u0011\u0001*S\u0001\u0007CB\f7\r[3\u000b\u0003)\u000b1a\u001c:h\u0013\taEI\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006AA\u000f]5e?\u0012*\u0017\u000f\u0006\u0002;\u001f\"9aHBA\u0001\u0002\u0004\u0011\u0015!\u0002;qS\u0012\u0004\u0013!B3q_\u000eDW#A*\u0011\u0005)\"\u0016BA+,\u0005\rIe\u000e^\u0001\nKB|7\r[0%KF$\"A\u000f-\t\u000fyJ\u0011\u0011!a\u0001'\u00061Q\r]8dQ\u0002\nqA^3sg&|g.A\u0006wKJ\u001c\u0018n\u001c8`I\u0015\fHC\u0001\u001e^\u0011\u001dqD\"!AA\u0002M\u000b\u0001B^3sg&|g\u000eI\u0001\u0005E\u0006|7/F\u0001b!\t\u0011w-D\u0001d\u0015\t!W-\u0001\u0002j_*\ta-\u0001\u0003kCZ\f\u0017B\u00015d\u0005U\u0011\u0015\u0010^3BeJ\f\u0017pT;uaV$8\u000b\u001e:fC6\f\u0001BY1pg~#S-\u001d\u000b\u0003u-DqAP\b\u0002\u0002\u0003\u0007\u0011-A\u0003cC>\u001c\b%\u0001\u0002qgV\tq\u000e\u0005\u0002ca&\u0011\u0011o\u0019\u0002\f!JLg\u000e^*ue\u0016\fW.\u0001\u0004qg~#S-\u001d\u000b\u0003uQDqA\u0010\n\u0002\u0002\u0003\u0007q.A\u0002qg\u0002\nQa]3u+B$\u0012A\u000f\u0015\u0003)e\u00042A_A\u0002\u001b\u0005Y(B\u0001?~\u0003\r\t\u0007/\u001b\u0006\u0003}~\fqA[;qSR,'OC\u0002\u0002\u0002%\u000bQA[;oSRL1!!\u0002|\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u001cM>\u0014X.\u0019;PM\u001a\u001cX\r^\"iC:<W-\u0012<f]R$Vm\u001d;)\u0007U\tY\u0001E\u0002{\u0003\u001bI1!a\u0004|\u0005\u0011!Vm\u001d;\u00029\u0019|'/\\1u\t\u0016dW\r^3SK\u000e|'\u000fZ:Fm\u0016tG\u000fV3ti\"\u001aa#a\u0003\u00025\u0019|'/\\1u\u000bB|7\r[\"iC:<W-\u0012<f]R$Vm\u001d;)\u0007]\tY!\u0001\rg_Jl\u0017\r^%te\u0016C\b/\u00198e\u000bZ,g\u000e\u001e+fgRD3\u0001GA\u0006\u0003y1wN]7biJ+G/\u001a8uS>t7\t[1oO\u0016,e/\u001a8u)\u0016\u001cH\u000fK\u0002\u001a\u0003\u0017\t\u0001EZ8s[\u0006$8\u000b^1si>3gm]3u\u0007\"\fgnZ3Fm\u0016tG\u000fV3ti\"\u001a!$a\u0003\u0002A\u0019|'/\\1u\u0017J\u000bg\r\u001e'fC\u0012,'o\u00115b]\u001e,WI^3oiR+7\u000f\u001e\u0015\u00047\u0005-\u0011!\b4pe6\fGo\u0013*bMRDu+T\"iC:<W-\u0012<f]R$Vm\u001d;)\u0007q\tY!A\u0010g_Jl\u0017\r^&SC\u001a$hj\u001c3f'R\f'\u000f^+q\u000bZ,g\u000e\u001e+fgRD3!HA\u0006\u0003!2wN]7bi.\u0013\u0016M\u001a;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;DQ\u0006tw-Z#wK:$H+Z:uQ\rq\u00121B\u0001*M>\u0014X.\u0019;L%\u00064G\u000fT8h':\f\u0007o\u001d5pi\u001e+g.\u001a:bi&|g.\u0012<f]R$Vm\u001d;)\u0007}\tY\u0001")
public class DurabilityTopicMessageFormatterTest {
    private DurabilityTopicMessageFormatter formatter;
    private TopicIdPartition tpid;
    private int epoch;
    private int version;
    private ByteArrayOutputStream baos;
    private PrintStream ps;

    public DurabilityTopicMessageFormatter formatter() {
        return this.formatter;
    }

    public void formatter_$eq(DurabilityTopicMessageFormatter x$1) {
        this.formatter = x$1;
    }

    public TopicIdPartition tpid() {
        return this.tpid;
    }

    public void tpid_$eq(TopicIdPartition x$1) {
        this.tpid = x$1;
    }

    public int epoch() {
        return this.epoch;
    }

    public void epoch_$eq(int x$1) {
        this.epoch = x$1;
    }

    public int version() {
        return this.version;
    }

    public void version_$eq(int x$1) {
        this.version = x$1;
    }

    public ByteArrayOutputStream baos() {
        return this.baos;
    }

    public void baos_$eq(ByteArrayOutputStream x$1) {
        this.baos = x$1;
    }

    public PrintStream ps() {
        return this.ps;
    }

    public void ps_$eq(PrintStream x$1) {
        this.ps = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.formatter_$eq(new DurabilityTopicMessageFormatter());
        this.tpid_$eq(new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("test", 0)));
        this.epoch_$eq(0);
        this.version_$eq(1);
        this.baos_$eq(new ByteArrayOutputStream());
        this.ps_$eq(new PrintStream(this.baos()));
    }

    @Test
    public void formatOffsetChangeEventTest() {
        OffsetChangeEvent obj = OffsetChangeEvent$.MODULE$.apply(this.tpid(), this.epoch(), 100L, 0L, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID());
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(20).append("OffsetChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatDeleteRecordsEventTest() {
        void apply_nodeId;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_trimmedOffset;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        long l3 = 100L;
        TopicIdPartition apply_id = this.tpid();
        Object var4_7 = null;
        set = null;
        DeleteRecordsEvent obj = new DeleteRecordsEvent(apply_id, (long)apply_trimmedOffset, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (int)apply_nodeId);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(21).append("DeleteRecordsEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatEpochChangeEventTest() {
        void apply_nodeId;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_firstOffset;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        long l3 = 50L;
        TopicIdPartition apply_id = this.tpid();
        Object var4_7 = null;
        set = null;
        EpochChangeEvent obj = new EpochChangeEvent(apply_id, (long)apply_firstOffset, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (int)apply_nodeId);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(19).append("EpochChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatIsrExpandEventTest() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_expandBrokerId;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        int n3 = 5;
        TopicIdPartition apply_id = this.tpid();
        Object var4_6 = null;
        IsrExpandEvent obj = new IsrExpandEvent(apply_id, (int)apply_expandBrokerId, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(17).append("IsrExpandEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatRetentionChangeEventTest() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_size;
        void apply_timeMs;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        long l3 = 1000L;
        long l4 = 50L;
        TopicIdPartition apply_id = this.tpid();
        Object var4_7 = null;
        RetentionChangeEvent obj = new RetentionChangeEvent(apply_id, (long)apply_timeMs, (long)apply_size, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, false);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(23).append("RetentionChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatStartOffsetChangeEventTest() {
        void apply_nodeId;
        void apply_isr;
        void apply_retentionValue;
        void apply_retentionType;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        long l = 0L;
        byte by = (byte)RetentionType$.MODULE$.SizeBasedRetention().id();
        long l2 = 21L;
        long l3 = 100L;
        int n2 = this.epoch();
        TopicIdPartition apply_id = this.tpid();
        Object var4_8 = null;
        set = null;
        StartOffsetChangeEvent obj = new StartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (byte)apply_retentionType, (long)apply_retentionValue, (Set)apply_isr, (int)apply_nodeId);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(25).append("StartOffsetChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatKRaftLeaderChangeEventTest() {
        void apply_epochChainOpt;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_version;
        long logStartOffset = 0L;
        long logEndOffset = 21L;
        int newLeaderId = 0;
        HashMap epochChain = new HashMap();
        epochChain.put((Object)BoxesRunTime.boxToInteger((int)this.epoch()), (Object)BoxesRunTime.boxToLong((long)logStartOffset));
        epochChain.put((Object)BoxesRunTime.boxToInteger((int)(this.epoch() + 1)), (Object)BoxesRunTime.boxToLong((long)(logEndOffset + 1L)));
        Set currentVoters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Set yesVoters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        Some some = new Some((Object)epochChain);
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
        int n = this.epoch() + 1;
        int n2 = this.version();
        TopicIdPartition apply_id = this.tpid();
        Object var12_11 = null;
        some2 = null;
        some = null;
        KRaftLeaderChangeEvent obj = new KRaftLeaderChangeEvent(apply_id, logEndOffset, (int)apply_version, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, logStartOffset, newLeaderId, (Option)apply_epochChainOpt, currentVoters, yesVoters);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(25).append("KRaftLeaderChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatKRaftHWMChangeEventTest() {
        void apply_epoch;
        void apply_version;
        long logStartOffset = 0L;
        long highWatermark = 21L;
        int nodeId = 0;
        HashMap quorumFetchOffsets = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        quorumFetchOffsets.put((Object)BoxesRunTime.boxToInteger((int)nodeId), (Object)BoxesRunTime.boxToLong((long)22L));
        quorumFetchOffsets.put((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)21L));
        quorumFetchOffsets.put((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)20L));
        Set currentVoters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        int n = this.epoch();
        int n2 = this.version();
        TopicIdPartition apply_id = this.tpid();
        Object var11_8 = null;
        KRaftHWMChangeEvent obj = new KRaftHWMChangeEvent(apply_id, (int)apply_version, (int)apply_epoch, highWatermark, logStartOffset, nodeId, (Map)quorumFetchOffsets, currentVoters);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(22).append("KRaftHWMChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatKRaftNodeStartUpEventTest() {
        void apply_leaderIdOpt;
        void apply_latestSnapshotId;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_version;
        long logStartOffset = 5L;
        long logEndOffset = 10L;
        OffsetAndEpoch latestSnapshotId = new OffsetAndEpoch(5L, this.epoch());
        int nodeId = 1;
        None$ none$ = None$.MODULE$;
        Some some = new Some((Object)latestSnapshotId);
        None$ none$2 = None$.MODULE$;
        int n = this.epoch() + 1;
        int n2 = this.version();
        TopicIdPartition apply_id = this.tpid();
        Object var10_10 = null;
        none$2 = null;
        some = null;
        none$ = null;
        KRaftNodeStartUpEvent obj = new KRaftNodeStartUpEvent(apply_id, (int)apply_version, (int)apply_epoch, (Option)apply_highWatermarkOpt, logStartOffset, logEndOffset, (Option)apply_latestSnapshotId, nodeId, (Option)apply_leaderIdOpt);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(24).append("KRaftNodeStartUpEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatKRaftLogStartOffsetChangeEventTest() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_version;
        long logStartOffset = 0L;
        long logEndOffset = 21L;
        long highWatermark = 21L;
        int nodeId = 1;
        int leaderId = 0;
        Some some = new Some((Object)new OffsetAndEpoch(highWatermark, this.epoch()));
        Some some2 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)highWatermark));
        int n = this.epoch();
        int n2 = this.version();
        TopicIdPartition apply_id = this.tpid();
        Object var12_11 = null;
        some3 = null;
        some2 = null;
        some = null;
        KRaftLogStartOffsetChangeEvent obj = new KRaftLogStartOffsetChangeEvent(apply_id, (int)apply_version, (int)apply_epoch, (Option)apply_highWatermarkOpt, logStartOffset, logEndOffset, nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(33).append("KRaftLogStartOffsetChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatKRaftLogSnapshotGenerationEventTest() {
        void apply_leaderIdOpt;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_version;
        long logStartOffset = 2L;
        long logEndOffset = 21L;
        long highWatermark = 20L;
        OffsetAndEpoch newSnapshotId = new OffsetAndEpoch(2L, 1);
        int nodeId = 0;
        int leaderId = 1;
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)highWatermark));
        int n = this.epoch();
        int n2 = this.version();
        TopicIdPartition apply_id = this.tpid();
        Object var13_11 = null;
        some2 = null;
        some = null;
        KRaftLogSnapshotGenerationEvent obj = new KRaftLogSnapshotGenerationEvent(apply_id, (int)apply_version, (int)apply_epoch, (Option)apply_highWatermarkOpt, logStartOffset, logEndOffset, newSnapshotId, nodeId, (Option)apply_leaderIdOpt);
        ConsumerRecord<byte[], byte[]> record = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)obj, this.tpid());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(34).append("KRaftLogSnapshotGenerationEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }
}

