/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.topic;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.durability.DurabilityTestUtilConstants$;
import kafka.durability.DurabilityTestUtils$;
import kafka.durability.Utils$;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.broker.OffsetChangeEvent$;
import kafka.durability.materialization.AbstractDurabilityEventsMaterialize;
import kafka.durability.materialization.BrokerDurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicConfig;
import kafka.durability.topic.DurabilityTopicConsumer;
import kafka.durability.topic.DurabilityTopicManager;
import kafka.durability.topic.DurabilityTopicProducer;
import kafka.server.InternalAdmin;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005u3AAD\b\u0001-!)Q\u0004\u0001C\u0001=!9\u0001\u0003\u0001b\u0001\n\u0003\t\u0003B\u0002\u0016\u0001A\u0003%!\u0005C\u0004,\u0001\t\u0007I\u0011\u0001\u0017\t\rA\u0002\u0001\u0015!\u0003.\u0011%\t\u0004\u00011AA\u0002\u0013\u0005!\u0007C\u00059\u0001\u0001\u0007\t\u0019!C\u0001s!Iq\b\u0001a\u0001\u0002\u0003\u0006Ka\r\u0005\u0006\u0001\u0002!\t!\u0011\u0005\u0006\u001f\u0002!\t!\u0011\u0005\u0006)\u0002!\t!\u0011\u0005\u00063\u0002!\t!\u0011\u0005\u00067\u0002!\t!\u0011\u0002\u001b\tV\u0014\u0018MY5mSRLHk\u001c9jG6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003!E\tQ\u0001^8qS\u000eT!AE\n\u0002\u0015\u0011,(/\u00192jY&$\u0018PC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\tq\"F\u0001#!\t\u0019\u0003&D\u0001%\u0015\t)c%\u0001\u0003mC:<'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\u0011\u0012aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%A\u0005qCJ$\u0018\u000e^5p]V\tQ\u0006\u0005\u0002\u0019]%\u0011q&\u0007\u0002\u0004\u0013:$\u0018A\u00039beRLG/[8oA\u0005\u0011AMY\u000b\u0002gA\u0011AGN\u0007\u0002k)\u0011\u0011'E\u0005\u0003oU\u0012A\u0002R;sC\nLG.\u001b;z\t\n\u000ba\u0001\u001a2`I\u0015\fHC\u0001\u001e>!\tA2(\u0003\u0002=3\t!QK\\5u\u0011\u001dqt!!AA\u0002M\n1\u0001\u001f\u00132\u0003\r!'\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002u!\u0012\u0011b\u0011\t\u0003\t6k\u0011!\u0012\u0006\u0003\r\u001e\u000b1!\u00199j\u0015\tA\u0015*A\u0004kkBLG/\u001a:\u000b\u0005)[\u0015!\u00026v]&$(\"\u0001'\u0002\u0007=\u0014x-\u0003\u0002O\u000b\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#AC)\u0011\u0005\u0011\u0013\u0016BA*F\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0010CCNL7\rR;sC\nLG.\u001b;z)>\u0004\u0018nY'b]\u0006<WM\u001d+fgRD#a\u0003,\u0011\u0005\u0011;\u0016B\u0001-F\u0005\u0011!Vm\u001d;\u0002AQ{\u0007/[2NC:\fw-\u001a:Qe>$WoY3s\u0007>t7/^7feR+7\u000f\u001e\u0015\u0003\u0019Y\u000bA\u0006^3ti\u0012+(/\u00192jY&$\u0018\u0010V8qS\u000e\u001cuN\u001c4jOB\u000b'\u000f^5uS>t7\u000fV8N_:LGo\u001c:)\u000551\u0006")
public class DurabilityTopicManagerTest {
    private final String topic;
    private final int partition;
    private DurabilityDB db;

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public DurabilityDB db() {
        return this.db;
    }

    public void db_$eq(DurabilityDB x$1) {
        this.db = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.db_$eq(DbTestUtils$.MODULE$.getDbInstance());
    }

    @AfterEach
    public void tearDown() {
        DbTestUtils$.MODULE$.cleanup(this.db());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void BasicDurabilityTopicManagerTest() {
        void getDurabilityTopicManager_resultQueue;
        None$ none$ = None$.MODULE$;
        BlockingQueue<ConsumerRecords<byte[], byte[]>> getDurabilityTopicManager_topicPartitionQueue = DurabilityTestUtils$.MODULE$.getDurabilityTopicManager$default$2();
        DurabilityDB getDurabilityTopicManager_db = this.db();
        Object var2_3 = null;
        Object var3_2 = null;
        none$ = null;
        DurabilityTopicManager manager = new DurabilityTopicManager(getDurabilityTopicManager_db, getDurabilityTopicManager_topicPartitionQueue, (Option)getDurabilityTopicManager_resultQueue){
            private DurabilityTopicConsumer consumerProvider;
            private DurabilityTopicProducer producerProvider;
            private volatile byte bitmap$0;
            private final BlockingQueue topicPartitionQueue$1;
            private DurabilityDB db$1;
            private Option resultQueue$1;

            /*
             * WARNING - void declaration
             */
            private DurabilityTopicConsumer consumerProvider$lzycompute() {
                synchronized (this) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        void getDurabilityConsumer_resultQueue;
                        Option option = this.resultQueue$1;
                        DurabilityDB getDurabilityConsumer_db = this.db$1;
                        BlockingQueue getDurabilityConsumer_topicPartitionQueue = this.topicPartitionQueue$1;
                        Object var1_3 = null;
                        Object var2_2 = null;
                        option = null;
                        this.consumerProvider = new DurabilityTopicConsumer(getDurabilityConsumer_db, getDurabilityConsumer_topicPartitionQueue, (Option)getDurabilityConsumer_resultQueue){
                            private KafkaConsumer<byte[], byte[]> consumer;
                            private volatile boolean bitmap$0;
                            public final BlockingQueue topicPartitionQueue$2;
                            private final Option resultQueue$2;

                            private KafkaConsumer<byte[], byte[]> consumer$lzycompute() {
                                synchronized (this) {
                                    if (!this.bitmap$0) {
                                        this.consumer = new KafkaConsumer<byte[], byte[]>(this){
                                            private final /* synthetic */ DurabilityTestUtils$.anon.3 $outer;

                                            public ConsumerRecords<byte[], byte[]> poll(Duration timeout) {
                                                return (ConsumerRecords)this.$outer.topicPartitionQueue$2.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
                                            }

                                            public void seek(TopicPartition partition, long offset) {
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                super(DurabilityTestUtils$.MODULE$.getDurabilityConfig().toConsumerProperties("dummy"));
                                            }
                                        };
                                        this.bitmap$0 = true;
                                    }
                                }
                                return this.consumer;
                            }

                            public KafkaConsumer<byte[], byte[]> consumer() {
                                if (!this.bitmap$0) {
                                    return this.consumer$lzycompute();
                                }
                                return this.consumer;
                            }

                            public void processRecords(ConsumerRecords<byte[], byte[]> records) {
                                Option option = this.resultQueue$2;
                                if (option instanceof Some) {
                                    BlockingQueue queue = (BlockingQueue)((Some)option).value();
                                    if (records != null) {
                                        queue.put(records);
                                        return;
                                    }
                                    return;
                                }
                            }
                            {
                                this.topicPartitionQueue$2 = topicPartitionQueue$2;
                                this.resultQueue$2 = resultQueue$2;
                                super(DurabilityTestUtils$.MODULE$.getDurabilityConfig(), db$2, (AbstractDurabilityEventsMaterialize)Mockito.mock(BrokerDurabilityEventsMaterialize.class));
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                this.db$1 = null;
                this.resultQueue$1 = null;
                return this.consumerProvider;
            }

            public DurabilityTopicConsumer consumerProvider() {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    return this.consumerProvider$lzycompute();
                }
                return this.consumerProvider;
            }

            private DurabilityTopicProducer producerProvider$lzycompute() {
                synchronized (this) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        BlockingQueue getDurabilityProducer_queue = this.topicPartitionQueue$1;
                        DurabilityTopicConfig getDurabilityProducer_config = DurabilityTestUtils$.MODULE$.getDurabilityConfig();
                        Object var1_2 = null;
                        Object var2_1 = null;
                        this.producerProvider = new DurabilityTopicProducer(getDurabilityProducer_config, getDurabilityProducer_queue){
                            private KafkaProducer<byte[], byte[]> get;
                            private KafkaProducer<byte[], byte[]> producer;
                            private volatile boolean bitmap$0;
                            public final BlockingQueue queue$1;

                            private KafkaProducer<byte[], byte[]> producer() {
                                return this.producer;
                            }

                            private KafkaProducer<byte[], byte[]> get$lzycompute() {
                                synchronized (this) {
                                    if (!this.bitmap$0) {
                                        this.get = this.producer();
                                        this.bitmap$0 = true;
                                    }
                                }
                                this.producer = null;
                                return this.get;
                            }

                            public KafkaProducer<byte[], byte[]> get() {
                                if (!this.bitmap$0) {
                                    return this.get$lzycompute();
                                }
                                return this.get;
                            }
                            {
                                this.queue$1 = queue$1;
                                super(config$1);
                                this.producer = new KafkaProducer<byte[], byte[]>(this){
                                    private final /* synthetic */ DurabilityTestUtils$.anon.5 $outer;

                                    public Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> record) {
                                        this.$outer.queue$1.add(DurabilityTestUtils$.MODULE$.kafka$durability$DurabilityTestUtils$$toConsumerRecord(record));
                                        return (Future)Mockito.mock(Future.class);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        super(DurabilityTestUtils$.MODULE$.getDurabilityConfig().toProducerProperties("dummy"));
                                    }
                                };
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.producerProvider;
            }

            public DurabilityTopicProducer producerProvider() {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    return this.producerProvider$lzycompute();
                }
                return this.producerProvider;
            }
            {
                this.topicPartitionQueue$1 = topicPartitionQueue$1;
                this.db$1 = db$1;
                this.resultQueue$1 = resultQueue$1;
                DurabilityTopicConfig x$1 = DurabilityTestUtils$.MODULE$.getDurabilityConfig();
                BrokerDurabilityEventsMaterialize x$3 = (BrokerDurabilityEventsMaterialize)Mockito.mock(BrokerDurabilityEventsMaterialize.class);
                Supplier<InternalAdmin> x$4 = DurabilityTestUtils$.MODULE$.internalAdminSupplier();
                Time x$6 = Time.SYSTEM;
                super(x$1, db$1, (AbstractDurabilityEventsMaterialize)x$3, x$4, x$6, true);
            }
        };
        Assertions.assertFalse((boolean)manager.isReady());
        manager.start();
        Assertions.assertTrue((boolean)manager.consumerProvider().isReady());
        Assertions.assertTrue((boolean)manager.isReady());
        manager.shutdown();
        Assertions.assertTrue((boolean)manager.isShutdown());
        Assertions.assertFalse((boolean)manager.consumerProvider().isReady());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void TopicManagerProducerConsumerTest() {
        TopicIdPartition tpid = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("test", 50));
        int epoch = 0;
        ArrayBlockingQueue resultQueue = new ArrayBlockingQueue(32);
        DurabilityDB x$1 = this.db();
        Some x$2 = new Some(resultQueue);
        BlockingQueue<ConsumerRecords<byte[], byte[]>> x$3 = DurabilityTestUtils$.MODULE$.getDurabilityTopicManager$default$2();
        DurabilityTopicManager manager = new /* invalid duplicate definition of identical inner class */;
        manager.database().addPartition(tpid.topicPartition(), PartitionState$.MODULE$.apply(tpid.topicPartition().partition(), 0L));
        manager.start();
        manager.addDurabilityEvent((AbstractDurabilityEvent)OffsetChangeEvent$.MODULE$.apply(tpid, epoch, 100L, 0L, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID()));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityTopicManagerTest.$anonfun$TopicManagerProducerConsumerTest$1(resultQueue)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        manager.shutdown();
    }

    @Test
    public void testDurabilityTopicConfigPartitionsToMonitor() {
        DurabilityTopicConfig configWithoutPartitionsToMonitor = new DurabilityTopicConfig(() -> new HashMap(), DurabilityAuditConstants$.MODULE$.TOPIC_NAME(), (short)this.partition(), 3, 0, "lkc-12345", (long)DurabilityAuditConstants$.MODULE$.DURABILITY_CONSUMER_POLL_DURATION_MS(), Predef$.MODULE$.int2Integer(DurabilityAuditConstants$.MODULE$.DURABILITY_PRODUCER_REQUEST_TIMEOUT_MS()), DurabilityAuditConstants$.MODULE$.DURABILITY_TOPIC_RETENTION_MS(), false, (Option)None$.MODULE$);
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.partition()).map((Function1 & Serializable)x -> BoxesRunTime.boxToShort((short)DurabilityTopicManagerTest.$anonfun$testDurabilityTopicConfigPartitionsToMonitor$2(BoxesRunTime.unboxToInt((Object)x)))).toSet(), (Object)configWithoutPartitionsToMonitor.partitionsToMonitor());
        Set durabilityPartitionsToMonitor = new .colon.colon((Object)new TopicIdPartition(Uuid.METADATA_TOPIC_ID, Topic.CLUSTER_METADATA_TOPIC_PARTITION), (List)Nil$.MODULE$).map((Function1 & Serializable)x -> BoxesRunTime.boxToShort((short)DurabilityTopicManagerTest.$anonfun$testDurabilityTopicConfigPartitionsToMonitor$3(this, x))).toSet();
        Supplier<Map> x$1 = () -> new HashMap();
        String x$2 = DurabilityAuditConstants$.MODULE$.TOPIC_NAME();
        short x$3 = (short)this.partition();
        long x$7 = DurabilityAuditConstants$.MODULE$.DURABILITY_CONSUMER_POLL_DURATION_MS();
        Integer x$8 = Predef$.MODULE$.int2Integer(DurabilityAuditConstants$.MODULE$.DURABILITY_PRODUCER_REQUEST_TIMEOUT_MS());
        long x$9 = DurabilityAuditConstants$.MODULE$.DURABILITY_TOPIC_RETENTION_MS();
        Some x$10 = new Some((Object)durabilityPartitionsToMonitor);
        boolean x$11 = false;
        DurabilityTopicConfig configWithPartitionsToMonitor = new DurabilityTopicConfig(x$1, x$2, x$3, 3, 0, "lkc-12345", x$7, x$8, x$9, x$11, (Option)x$10);
        Assertions.assertEquals((Object)durabilityPartitionsToMonitor, (Object)configWithPartitionsToMonitor.partitionsToMonitor());
    }

    public static final /* synthetic */ boolean $anonfun$TopicManagerProducerConsumerTest$1(ArrayBlockingQueue resultQueue$1) {
        return resultQueue$1.size() == 1;
    }

    public static final /* synthetic */ String $anonfun$TopicManagerProducerConsumerTest$2() {
        return "";
    }

    public static final /* synthetic */ short $anonfun$testDurabilityTopicConfigPartitionsToMonitor$2(int x) {
        return (short)x;
    }

    public static final /* synthetic */ short $anonfun$testDurabilityTopicConfigPartitionsToMonitor$3(DurabilityTopicManagerTest $this, TopicIdPartition x) {
        return (short)Utils$.MODULE$.toPartition(x.topicPartition(), $this.partition());
    }

    public DurabilityTopicManagerTest() {
        this.topic = "test-topic";
        this.partition = 50;
    }
}

