/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import java.io.Serializable;
import kafka.durability.DurabilityTestUtilConstants$;
import kafka.durability.DurabilityTestUtils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.kraft.KRaftPartitionState;
import kafka.durability.db.kraft.KRaftQuorumState;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.controller.kraft.KRaftHWMChangeEvent;
import kafka.durability.events.controller.kraft.KRaftLeaderChangeEvent;
import kafka.durability.events.controller.kraft.KRaftLogSnapshotGenerationEvent;
import kafka.durability.events.controller.kraft.KRaftLogStartOffsetChangeEvent;
import kafka.durability.events.controller.kraft.KRaftNodeStartUpEvent;
import kafka.durability.materialization.ControllerDurabilityEventsMaterialize;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.utils.MockTime;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rEa\u0001\u0002*T\u0001iCQ!\u0019\u0001\u0005\u0002\tD\u0011\"\u001a\u0001A\u0002\u0003\u0007I\u0011\u00024\t\u00135\u0004\u0001\u0019!a\u0001\n\u0013q\u0007\"\u0003;\u0001\u0001\u0004\u0005\t\u0015)\u0003h\u0011%)\b\u00011AA\u0002\u0013%a\u000fC\u0006\u0002\n\u0001\u0001\r\u00111A\u0005\n\u0005-\u0001BCA\b\u0001\u0001\u0007\t\u0011)Q\u0005o\"Y\u0011\u0011\u0003\u0001A\u0002\u0003\u0007I\u0011BA\n\u0011-\ty\u0002\u0001a\u0001\u0002\u0004%I!!\t\t\u0017\u0005\u0015\u0002\u00011A\u0001B\u0003&\u0011Q\u0003\u0005\f\u0003O\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0003C\u0006\u00022\u0001\u0001\r\u00111A\u0005\n\u0005M\u0002bCA\u001c\u0001\u0001\u0007\t\u0011)Q\u0005\u0003WA\u0011\"!\u000f\u0001\u0001\u0004%I!a\u000f\t\u0013\u0005u\u0003\u00011A\u0005\n\u0005}\u0003\u0002CA2\u0001\u0001\u0006K!!\u0010\t\u0013\u0005\u0015\u0004A1A\u0005\n\u0005\u001d\u0004\u0002CA9\u0001\u0001\u0006I!!\u001b\t\u0013\u0005M\u0004A1A\u0005\n\u0005U\u0004\u0002CAG\u0001\u0001\u0006I!a\u001e\t\u0013\u0005=\u0005A1A\u0005\n\u0005E\u0005\u0002CAJ\u0001\u0001\u0006I!a\"\t\u0013\u0005U\u0005A1A\u0005\n\u0005]\u0005\u0002CAP\u0001\u0001\u0006I!!'\t\u0013\u0005\u0005\u0006A1A\u0005\n\u0005]\u0005\u0002CAR\u0001\u0001\u0006I!!'\t\u0013\u0005\u0015\u0006A1A\u0005\n\u0005E\u0005\u0002CAT\u0001\u0001\u0006I!a\"\t\u0013\u0005%\u0006A1A\u0005\n\u0005]\u0005\u0002CAV\u0001\u0001\u0006I!!'\t\u0013\u00055\u0006A1A\u0005\n\u0005]\u0005\u0002CAX\u0001\u0001\u0006I!!'\t\u0013\u0005E\u0006A1A\u0005\n\u0005M\u0006\u0002CAd\u0001\u0001\u0006I!!.\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"9\u00111\u001d\u0001\u0005\u0002\u0005-\u0007bBAw\u0001\u0011\u0005\u00111\u001a\u0005\b\u0003o\u0004A\u0011AAf\u0011\u001d\tY\u0010\u0001C\u0001\u0003\u0017Dq!a@\u0001\t\u0003\tY\rC\u0004\u0003\u0004\u0001!\t!a3\t\u000f\t\u001d\u0001\u0001\"\u0001\u0002L\"9!1\u0002\u0001\u0005\u0002\u0005-\u0007b\u0002B\b\u0001\u0011\u0005\u00111\u001a\u0005\b\u0005'\u0001A\u0011AAf\u0011\u001d\u00119\u0002\u0001C\u0001\u0003\u0017DqAa\u0007\u0001\t\u0013\u0011i\u0002C\u0004\u0003B\u0001!\t!a3\t\u000f\t\u0015\u0003\u0001\"\u0001\u0002L\"9!\u0011\n\u0001\u0005\u0002\u0005-\u0007b\u0002B'\u0001\u0011\u0005\u00111\u001a\u0005\b\u0005#\u0002A\u0011AAf\u0011\u001d\u0011)\u0006\u0001C\u0001\u0003\u0017DqA!\u0017\u0001\t\u0013\u0011Y\u0006C\u0004\u0003f\u0001!\t!a3\t\u000f\t%\u0004\u0001\"\u0001\u0002L\"9!Q\u000e\u0001\u0005\u0002\u0005-\u0007b\u0002B9\u0001\u0011\u0005\u00111\u001a\u0005\b\u0005k\u0002A\u0011AAf\u0011\u001d\u0011I\b\u0001C\u0001\u0003\u0017DqA! \u0001\t\u0013\u0011y\bC\u0004\u0003\n\u0002!\t!a3\t\u000f\t5\u0005\u0001\"\u0001\u0002L\"9!\u0011\u0013\u0001\u0005\u0002\u0005-\u0007b\u0002BK\u0001\u0011\u0005\u00111\u001a\u0005\b\u00053\u0003A\u0011AAf\u0011\u001d\u0011i\n\u0001C\u0001\u0003\u0017DqA!)\u0001\t\u0003\tY\rC\u0004\u0003&\u0002!IAa*\t\u000f\tE\u0006\u0001\"\u0001\u0002L\"9!Q\u0017\u0001\u0005\u0002\u0005-\u0007b\u0002B]\u0001\u0011\u0005\u00111\u001a\u0005\b\u0005{\u0003A\u0011AAf\u0011\u001d\u0011\t\r\u0001C\u0001\u0003\u0017DqA!2\u0001\t\u0003\tY\rC\u0004\u0003J\u0002!\t!a3\t\u000f\t5\u0007\u0001\"\u0003\u0003P\"9!\u0011\u001c\u0001\u0005\n\tm\u0007\"\u0003Bv\u0001E\u0005I\u0011\u0002Bw\u0011%\u0019\u0019\u0001AI\u0001\n\u0013\u0019)\u0001C\u0004\u0004\n\u0001!Iaa\u0003\u0003S\r{g\u000e\u001e:pY2,'\u000fR;sC\nLG.\u001b;z\u000bZ,g\u000e^:NCR,'/[1mSj,G+Z:u\u0015\t!V+A\bnCR,'/[1mSj\fG/[8o\u0015\t1v+\u0001\u0006ekJ\f'-\u001b7jifT\u0011\u0001W\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\f\u0005\u0002]?6\tQLC\u0001_\u0003\u0015\u00198-\u00197b\u0013\t\u0001WL\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0004\"\u0001\u001a\u0001\u000e\u0003M\u000b\u0001B]3q_J$XM]\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\u0011!.V\u0001\u0006CV$\u0017\u000e^\u0005\u0003Y&\u0014Q\"Q;eSR\u0014V\r]8si\u0016\u0014\u0018\u0001\u0004:fa>\u0014H/\u001a:`I\u0015\fHCA8s!\ta\u0006/\u0003\u0002r;\n!QK\\5u\u0011\u001d\u00198!!AA\u0002\u001d\f1\u0001\u001f\u00132\u0003%\u0011X\r]8si\u0016\u0014\b%\u0001\u0003uS6,W#A<\u0011\u0007a\f)!D\u0001z\u0015\tQ80A\u0003vi&d7O\u0003\u0002}{\u000611m\\7n_:T!\u0001\u0017@\u000b\u0007}\f\t!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0007\t1a\u001c:h\u0013\r\t9!\u001f\u0002\u0005)&lW-\u0001\u0005uS6,w\fJ3r)\ry\u0017Q\u0002\u0005\bg\u001a\t\t\u00111\u0001x\u0003\u0015!\u0018.\\3!\u0003\t!'-\u0006\u0002\u0002\u0016A!\u0011qCA\u000e\u001b\t\tIBC\u0002\u0002\u0012UKA!!\b\u0002\u001a\taA)\u001e:bE&d\u0017\u000e^=E\u0005\u00061AMY0%KF$2a\\A\u0012\u0011!\u0019\u0018\"!AA\u0002\u0005U\u0011a\u00013cA\u0005YQ.\u0019;fe&\fG.\u001b>f+\t\tY\u0003E\u0002e\u0003[I1!a\fT\u0005\u0015\u001auN\u001c;s_2dWM\u001d#ve\u0006\u0014\u0017\u000e\\5us\u00163XM\u001c;t\u001b\u0006$XM]5bY&TX-A\bnCR,'/[1mSj,w\fJ3r)\ry\u0017Q\u0007\u0005\tg2\t\t\u00111\u0001\u0002,\u0005aQ.\u0019;fe&\fG.\u001b>fA\u0005IA.\u00199tKRK\b/Z\u000b\u0003\u0003{\u0001B!a\u0010\u0002X9!\u0011\u0011IA*\u001d\u0011\t\u0019%!\u0015\u000f\t\u0005\u0015\u0013q\n\b\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111J-\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0016B\u0001,X\u0013\t!V+C\u0002\u0002VM\u000b1\u0003R;sC\nLG.\u001b;z\u0019\u0006\u00048/\u001a+za\u0016LA!!\u0017\u0002\\\t\u0019B)\u001e:bE&d\u0017\u000e^=MCB\u001cX\rV=qK*\u0019\u0011QK*\u0002\u001b1\f\u0007o]3UsB,w\fJ3r)\ry\u0017\u0011\r\u0005\tg>\t\t\u00111\u0001\u0002>\u0005QA.\u00199tKRK\b/\u001a\u0011\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>tWCAA5!\u0011\tY'!\u001c\u000e\u0003mL1!a\u001c|\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.A\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\u0002\naA^8uKJ\u001cXCAA<!\u0019\tI(a!\u0002\b6\u0011\u00111\u0010\u0006\u0005\u0003{\ny(A\u0005j[6,H/\u00192mK*\u0019\u0011\u0011Q/\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0006\u0006m$aA*fiB\u0019A,!#\n\u0007\u0005-ULA\u0002J]R\fqA^8uKJ\u001c\b%A\u0006m_\u000e\fGNT8eK&#WCAAD\u00031awnY1m\u001d>$W-\u00133!\u0003IIg.\u001b;jC2$%\rT3bI\u0016\u0014\bj^7\u0016\u0005\u0005e\u0005c\u0001/\u0002\u001c&\u0019\u0011QT/\u0003\t1{gnZ\u0001\u0014S:LG/[1m\t\ndU-\u00193fe\";X\u000eI\u0001\u0012S:LG/[1m\t\ndunY1m\u0011^l\u0017AE5oSRL\u0017\r\u001c#c\u0019>\u001c\u0017\r\u001c%x[\u0002\na\"\u001b8ji&\fG\u000e\u00122Fa>\u001c\u0007.A\bj]&$\u0018.\u00197EE\u0016\u0003xn\u00195!\u0003]Ig.\u001b;jC2$%\rT8h'R\f'\u000f^(gMN,G/\u0001\rj]&$\u0018.\u00197EE2{wm\u0015;beR|eMZ:fi\u0002\nQ$\u001b8ji&\fG\u000e\u00122MCN$8J\\8x]\u001a+Go\u00195PM\u001a\u001cX\r^\u0001\u001fS:LG/[1m\t\nd\u0015m\u001d;L]><hNR3uG\"|eMZ:fi\u0002\n\u0011$\u001b8ji&\fG\u000e\u00122MCR,7\u000f^*oCB\u001c\bn\u001c;JIV\u0011\u0011Q\u0017\t\u00069\u0006]\u00161X\u0005\u0004\u0003sk&\u0001B*p[\u0016\u0004B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003l\u0018\u0001\u0002:bMRLA!!2\u0002@\nqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0017AG5oSRL\u0017\r\u001c#c\u0019\u0006$Xm\u001d;T]\u0006\u00048\u000f[8u\u0013\u0012\u0004\u0013!B:fiV\u0003H#A8)\u0007\r\ny\r\u0005\u0003\u0002R\u0006}WBAAj\u0015\u0011\t).a6\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002Z\u0006m\u0017a\u00026va&$XM\u001d\u0006\u0005\u0003;\f\t!A\u0003kk:LG/\u0003\u0003\u0002b\u0006M'A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002%\u0003O\u0004B!!5\u0002j&!\u00111^Aj\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u001duKN$XI^3oi6\u000bG/\u001a:jC2L'0\u0019;j_:\u0014VM[3di\u0016$\u0017J\u001a)beRLG/[8o\u001d>$(+Z4jgR,'/\u001a3)\u0007\u0015\n\t\u0010\u0005\u0003\u0002R\u0006M\u0018\u0002BA{\u0003'\u0014A\u0001V3ti\u0006!D/Z:u\u000bZ,g\u000e^'bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8SK*,7\r^3e\u0013\u001a,e/\u001a8u)f\u0004X-S:J]Z\fG.\u001b3)\u0007\u0019\n\t0\u0001\u0016uKN$X*\u0019;fe&\fG.\u001b>f-\u0006d\u0017\u000eZ&SC\u001a$H*Z1eKJ\u001c\u0005.\u00198hK\u00163XM\u001c;)\u0007\u001d\n\t0A\u001cuKN$\u0018J\u001c<bY&$7JU1gi2+\u0017\rZ3s\u0007\"\fgnZ3Fm\u0016tGoV5uQ2+\u0017\rZ3s\u0019><w*\u001e;PM\u0012\u000bG/\u001a\u0015\u0004Q\u0005E\u0018a\r;fgRLeN^1mS\u0012\\%+\u00194u\u0019\u0016\fG-\u001a:DQ\u0006tw-Z#wK:$x+\u001b;i\u001d>$XI\\8vO\"4v\u000e^3tQ\rI\u0013\u0011_\u00016i\u0016\u001cH/\u00138wC2LGm\u0013*bMRdU-\u00193fe\u000eC\u0017M\\4f\u000bZ,g\u000e^,ji\"tuN\\\"veJ,g\u000e\u001e,pi\u0016\u00148\u000fK\u0002+\u0003c\fA\u0007^3ti&sg/\u00197jI.\u0013\u0016M\u001a;MK\u0006$WM]\"iC:<W-\u0012<f]R<\u0016\u000e\u001e5EkBd\u0017nY1uK2+\u0017\rZ3sQ\rY\u0013\u0011_\u00017i\u0016\u001cH/\u00138wC2LGm\u0013*bMRdU-\u00193fe\u000eC\u0017M\\4f\u000bZ,g\u000e^,ji\"LeN^1mS\u0012,\u0005o\\2i\u0007\"\f\u0017N\u001c\u0015\u0004Y\u0005E\u0018a\u000f;fgRLeN^1mS\u0012\\%+\u00194u\u0019\u0016\fG-\u001a:DQ\u0006tw-Z#wK:$x+\u001b;i\u0019><7\u000b^1si>3gm]3u\t\u0016\u001c'/Z1tK\"\u001aQ&!=\u0002kQ,7\u000f^%om\u0006d\u0017\u000eZ&SC\u001a$H*Z1eKJ\u001c\u0005.\u00198hK\u00163XM\u001c;XSRDGj\\2bY\";V\nR3de\u0016\f7/\u001a\u0015\u0004]\u0005E\u0018AJ4fi\u0016C\b/Z2uK\u0012\\%+\u00194u'R\fG/Z!gi\u0016\u0014H*Z1eKJ\u001c\u0005.\u00198hKR!!q\u0004B\u0016!\u0011\u0011\tCa\n\u000e\u0005\t\r\"\u0002\u0002B\u0013\u00033\tQa\u001b:bMRLAA!\u000b\u0003$\t\u00012JU1giF+xN];n'R\fG/\u001a\u0005\b\u0005[y\u0003\u0019\u0001B\u0018\u0003\u0015)g/\u001a8u!\u0011\u0011\tD!\u0010\u000e\u0005\tM\"\u0002\u0002B\u0013\u0005kQAAa\u000e\u0003:\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0007\tmR+\u0001\u0004fm\u0016tGo]\u0005\u0005\u0005\u007f\u0011\u0019D\u0001\fL%\u00064G\u000fT3bI\u0016\u00148\t[1oO\u0016,e/\u001a8u\u0003\u001d\"Xm\u001d;NCR,'/[1mSj,g+\u00197jI.\u0013\u0016M\u001a;I/6\u001b\u0005.\u00198hK\u00163XM\u001c;)\u0007A\n\t0A\u0019uKN$\u0018J\u001c<bY&$7JU1gi\";Vj\u00115b]\u001e,WI^3oi^KG\u000f\u001b#va2L7-\u0019;f\u0019\u0016\fG-\u001a:)\u0007E\n\t0\u0001\u001duKN$\u0018J\u001c<bY&$7JU1gi\";Vj\u00115b]\u001e,WI^3oi^KG\u000f\u001b'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e#fGJ,\u0017m]3)\u0007I\n\t0A\u0017uKN$\u0018J\u001c<bY&$7JU1gi\";Vj\u00115b]\u001e,WI^3oi^KG\u000f\u001b%X\u001b\u0012+7M]3bg\u0016D3aMAy\u0003M\"Xm\u001d;J]Z\fG.\u001b3L%\u00064G\u000fS,N\u0007\"\fgnZ3Fm\u0016tGoV5uQ\";V*T5tG\u0006d7-\u001e7bi&|g\u000eK\u00025\u0003c\fq\u0007^3ti&sg/\u00197jI.\u0013\u0016M\u001a;I/6\u001b\u0005.\u00198hK\u00163XM\u001c;XSRDw*\u001e;PM\u0012\u000bG/Z)v_J,XNV8uKJ\u001c\bfA\u001b\u0002r\u0006\u0019s-\u001a;FqB,7\r^3e\u0017J\u000bg\r^*uCR,\u0017I\u001a;fe\";Vj\u00115b]\u001e,G\u0003\u0002B\u0010\u0005;BqA!\f7\u0001\u0004\u0011y\u0006\u0005\u0003\u00032\t\u0005\u0014\u0002\u0002B2\u0005g\u00111c\u0013*bMRDu+T\"iC:<W-\u0012<f]R\f!\u0007^3ti6\u000bG/\u001a:jC2L'0\u001a,bY&$7JU1gi2{wm\u0015;beR|eMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0015\u0004o\u0005E\u0018a\u000e;fgRLeN^1mS\u0012\\%+\u00194u\u0019><7\u000b^1si>3gm]3u\u0007\"\fgnZ3Fm\u0016tGo\u00148O_:dunY1m\u001d>$W\rK\u00029\u0003c\f1\t^3ti&sg/\u00197jI.\u0013\u0016M\u001a;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;DQ\u0006tw-Z#wK:$x+\u001b;i\u0019><7\u000b^1si>3gm]3u\t\u0016\u001c'/Z1tK\"\u001a\u0011(!=\u0002yQ,7\u000f^%om\u0006d\u0017\u000eZ&SC\u001a$Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u/&$\b\u000eR;qY&\u001c\u0017\r^3MK\u0006$WM\u001d\u0015\u0004u\u0005E\u0018A\u0011;fgRLeN^1mS\u0012\\%+\u00194u\u0019><7\u000b^1si>3gm]3u\u0007\"\fgnZ3Fm\u0016tGoV5uQ\";V\nR3de\u0016\f7/\u001a$s_6dU-\u00193fe\"\u001a1(!=\u0002\u000bR,7\u000f^%om\u0006d\u0017\u000eZ&SC\u001a$Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u/&$\b\u000eS,N\t\u0016\u001c'/Z1tK\u001a\u0013x.\u001c(p]2+\u0017\rZ3sQ\ra\u0014\u0011_\u0001/O\u0016$X\t\u001f9fGR,Gm\u0013*bMR\u001cF/\u0019;f\u0003\u001a$XM\u001d'pON#\u0018M\u001d;PM\u001a\u001cX\r^\"iC:<W\r\u0006\u0003\u0003 \t\u0005\u0005b\u0002B\u0017{\u0001\u0007!1\u0011\t\u0005\u0005c\u0011))\u0003\u0003\u0003\b\nM\"AH&SC\u001a$Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u\u0003M\"Xm\u001d;NCR,'/[1mSj,g+\u00197jI.\u0013\u0016M\u001a;M_\u001e\u001cf.\u00199tQ>$x)\u001a8fe\u0006$\u0018n\u001c8Fm\u0016tG\u000fK\u0002?\u0003c\f\u0001\b^3ti&sg/\u00197jI.\u0013\u0016M\u001a;M_\u001e\u001cf.\u00199tQ>$x)\u001a8fe\u0006$\u0018n\u001c8Fm\u0016tGo\u00148O_:dunY1m\u001d>$W\rK\u0002@\u0003c\fA\t^3ti&sg/\u00197jI.\u0013\u0016M\u001a;M_\u001e\u001cf.\u00199tQ>$x)\u001a8fe\u0006$\u0018n\u001c8Fm\u0016tGoV5uQ2{wm\u0015;beR|eMZ:fi\u0012+7M]3bg\u0016D3\u0001QAy\u0003u\"Xm\u001d;J]Z\fG.\u001b3L%\u00064G\u000fT8h':\f\u0007o\u001d5pi\u001e+g.\u001a:bi&|g.\u0012<f]R<\u0016\u000e\u001e5EkBd\u0017nY1uK2+\u0017\rZ3sQ\r\t\u0015\u0011_\u0001Di\u0016\u001cH/\u00138wC2LGm\u0013*bMRdunZ*oCB\u001c\bn\u001c;HK:,'/\u0019;j_:,e/\u001a8u/&$\b\u000eS,N\t\u0016\u001c'/Z1tK\u001a\u0013x.\u001c'fC\u0012,'\u000fK\u0002C\u0003c\fa\t^3ti&sg/\u00197jI.\u0013\u0016M\u001a;M_\u001e\u001cf.\u00199tQ>$x)\u001a8fe\u0006$\u0018n\u001c8Fm\u0016tGoV5uQ\";V\nR3de\u0016\f7/\u001a$s_6tuN\u001c'fC\u0012,'\u000fK\u0002D\u0003c\f\u0001\t^3ti&sg/\u00197jI.\u0013\u0016M\u001a;M_\u001e\u001cf.\u00199tQ>$x)\u001a8fe\u0006$\u0018n\u001c8Fm\u0016tGoV5uQ&sg/\u00197jI2{wm\u00158baNDw\u000e\u001e\u0015\u0004\t\u0006E\u0018aL4fi\u0016C\b/Z2uK\u0012\\%+\u00194u'R\fG/Z!gi\u0016\u0014Hj\\4T]\u0006\u00048\u000f[8u\u000f\u0016tWM]1uS>tG\u0003\u0002B\u0010\u0005SCqA!\fF\u0001\u0004\u0011Y\u000b\u0005\u0003\u00032\t5\u0016\u0002\u0002BX\u0005g\u0011qd\u0013*bMRdunZ*oCB\u001c\bn\u001c;HK:,'/\u0019;j_:,e/\u001a8u\u0003%\"Xm\u001d;NCR,'/[1mSj,g+\u00197jI.\u0013\u0016M\u001a;O_\u0012,7\u000b^1siV\u0003XI^3oi\"\u001aa)!=\u0002]Q,7\u000f^%om\u0006d\u0017\u000eZ&SC\u001a$hj\u001c3f'R\f'\u000f^+q\u000bZ,g\u000e^(o\u001d>tGj\\2bY:{G-\u001a\u0015\u0004\u000f\u0006E\u0018\u0001\u000f;fgR4\u0016\r\\5e\u0017J\u000bg\r\u001e(pI\u0016\u001cF/\u0019:u+B,e/\u001a8u/&$\b\u000eT8h'R\f'\u000f^(gMN,G\u000fR3de\u0016\f7/\u001a\u0015\u0004\u0011\u0006E\u0018a\r;fgRLeN^1mS\u0012\\%+\u00194u\u001d>$Wm\u0015;beR,\u0006/\u0012<f]R<\u0016\u000e\u001e5EkBd\u0017nY1uK2+\u0017\rZ3sQ\rI\u0015\u0011_\u0001:i\u0016\u001cH/\u00138wC2LGm\u0013*bMRtu\u000eZ3Ti\u0006\u0014H/\u00169Fm\u0016tGoV5uQ\";V\nR3de\u0016\f7/\u001a$s_6dU-\u00193fe\"\u001a!*!=\u0002yQ,7\u000f^%om\u0006d\u0017\u000eZ&SC\u001a$hj\u001c3f'R\f'\u000f^+q\u000bZ,g\u000e^,ji\"Du+\u0014#fGJ,\u0017m]3Ge>lgj\u001c8MK\u0006$WM\u001d\u0015\u0004\u0017\u0006E\u0018A\u000e;fgRLeN^1mS\u0012\\%+\u00194u\u001d>$Wm\u0015;beR,\u0006/\u0012<f]R<\u0016\u000e\u001e5J]Z\fG.\u001b3M_\u001e\u001cf.\u00199tQ>$\bf\u0001'\u0002r\u0006)s-\u001a;FqB,7\r^3e\u0017J\u000bg\r^*uCR,\u0017I\u001a;fe:{G-Z*uCJ$X\u000b\u001d\u000b\u0005\u0005?\u0011\t\u000eC\u0004\u0003.5\u0003\rAa5\u0011\t\tE\"Q[\u0005\u0005\u0005/\u0014\u0019DA\u000bL%\u00064GOT8eKN#\u0018M\u001d;Va\u00163XM\u001c;\u0002\u0017%t\u0017\u000e\u001e#c'R\fG/\u001a\u000b\u0006_\nu'\u0011\u001d\u0005\n\u0005?t\u0005\u0013!a\u0001\u0003\u000f\u000bq\"\u001b8ji&\fG\u000eT3bI\u0016\u0014\u0018\n\u001a\u0005\n\u0005Gt\u0005\u0013!a\u0001\u0005K\f\u0011#\u001b8ji&\fGn\u00158baNDw\u000e^%e!\u0015a&q]A^\u0013\r\u0011I/\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0002+%t\u0017\u000e\u001e#c'R\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\u001e\u0016\u0005\u0003\u000f\u0013\tp\u000b\u0002\u0003tB!!Q\u001fB\u0000\u001b\t\u00119P\u0003\u0003\u0003z\nm\u0018!C;oG\",7m[3e\u0015\r\u0011i0X\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0001\u0005o\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003UIg.\u001b;EEN#\u0018\r^3%I\u00164\u0017-\u001e7uII*\"aa\u0002+\t\t\u0015(\u0011_\u0001\u001fG>tg-\u001b:n\tV\u0014\u0018MY5mSRLH*\u00199tKJ+\u0007o\u001c:uK\u0012$2a\\B\u0007\u0011\u001d\u0019y!\u0015a\u0001\u0003{\t\u0011#\u001a=qK\u000e$X\r\u001a'baN,G+\u001f9f\u0001")
public class ControllerDurabilityEventsMaterializeTest {
    private AuditReporter reporter;
    private Time time;
    private DurabilityDB db;
    private ControllerDurabilityEventsMaterialize materialize;
    private Enumeration.Value lapseType = DurabilityLapseType$.MODULE$.NonCustomerFacing();
    private final TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.METADATA_TOPIC_ID, Topic.CLUSTER_METADATA_TOPIC_PARTITION);
    private final Set<Object> voters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
    private final int localNodeId;
    private final long initialDbLeaderHwm;
    private final long initialDbLocalHwm;
    private final int initialDbEpoch;
    private final long initialDbLogStartOffset;
    private final long initialDbLastKnownFetchOffset = this.initialDbLeaderHwm();
    private final Some<OffsetAndEpoch> initialDbLatestSnapshotId = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset(), this.initialDbEpoch()));

    private AuditReporter reporter() {
        return this.reporter;
    }

    private void reporter_$eq(AuditReporter x$1) {
        this.reporter = x$1;
    }

    private Time time() {
        return this.time;
    }

    private void time_$eq(Time x$1) {
        this.time = x$1;
    }

    private DurabilityDB db() {
        return this.db;
    }

    private void db_$eq(DurabilityDB x$1) {
        this.db = x$1;
    }

    private ControllerDurabilityEventsMaterialize materialize() {
        return this.materialize;
    }

    private void materialize_$eq(ControllerDurabilityEventsMaterialize x$1) {
        this.materialize = x$1;
    }

    private Enumeration.Value lapseType() {
        return this.lapseType;
    }

    private void lapseType_$eq(Enumeration.Value x$1) {
        this.lapseType = x$1;
    }

    private TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    private Set<Object> voters() {
        return this.voters;
    }

    private int localNodeId() {
        return this.localNodeId;
    }

    private long initialDbLeaderHwm() {
        return this.initialDbLeaderHwm;
    }

    private long initialDbLocalHwm() {
        return this.initialDbLocalHwm;
    }

    private int initialDbEpoch() {
        return this.initialDbEpoch;
    }

    private long initialDbLogStartOffset() {
        return this.initialDbLogStartOffset;
    }

    private long initialDbLastKnownFetchOffset() {
        return this.initialDbLastKnownFetchOffset;
    }

    private Some<OffsetAndEpoch> initialDbLatestSnapshotId() {
        return this.initialDbLatestSnapshotId;
    }

    @BeforeEach
    public void setUp() {
        this.lapseType_$eq(DurabilityLapseType$.MODULE$.NonCustomerFacing());
        this.time_$eq((Time)new MockTime(0L, 0L));
        this.reporter_$eq((AuditReporter)Mockito.mock(AuditReporter.class));
        this.reporter().reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            this.lapseType_$eq((Enumeration.Value)invocation.getArgument(3));
            return BoxedUnit.UNIT;
        });
        this.db_$eq(DbTestUtils$.MODULE$.getDbInstance());
        this.db().setKRaftLocalNodeId(this.localNodeId());
        this.materialize_$eq(new ControllerDurabilityEventsMaterialize(this.db(), this.reporter(), this.time()));
    }

    @AfterEach
    public void tearDown() {
        DbTestUtils$.MODULE$.cleanup(this.db());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEventMaterializationRejectedIfPartitionNotRegistered() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
        boolean bl = true;
        long l = 0L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)20L));
        int n = 2;
        long l2 = 21L;
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var3_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertFalse((boolean)this.materialize().materialize(consumerRecord));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEventMaterializationRejectedIfEventTypeIsInvalid() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_expandBrokerId;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l = 0L;
        long l2 = 20L;
        int n2 = 2;
        boolean bl = false;
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var3_6 = null;
        IsrExpandEvent invalidEvent = new IsrExpandEvent(apply_id, (int)apply_expandBrokerId, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)invalidEvent, this.topicIdPartition());
        Assertions.assertFalse((boolean)this.materialize().materialize(consumerRecord));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaterializeValidKRaftLeaderChangeEvent() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        void apply_yesVoters2;
        void apply_currentVoters2;
        void apply_epochChainOpt2;
        void apply_newLeaderId2;
        void apply_logStartOffset2;
        void apply_highWatermarkOpt2;
        void apply_newEpoch2;
        void apply_logEnd2;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var5_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent validLeaderChangeEventLocal = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd2, 2, (int)apply_newEpoch2, (Option)apply_highWatermarkOpt2, (long)apply_logStartOffset2, (int)apply_newLeaderId2, (Option)apply_epochChainOpt2, (Set)apply_currentVoters2, (Set)apply_yesVoters2);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(validLeaderChangeEventLocal);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validLeaderChangeEventLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        Set<Object> set3 = this.voters();
        Set<Object> set4 = this.voters();
        Some some3 = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToLong((long)31L))})));
        int n3 = this.localNodeId() + 1;
        long l3 = this.initialDbLogStartOffset() + 2L;
        Some some4 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n4 = this.initialDbEpoch() + 2;
        long l4 = this.initialDbLeaderHwm() + 1L;
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var16_21 = null;
        some4 = null;
        some3 = null;
        set4 = null;
        set3 = null;
        KRaftLeaderChangeEvent validLeaderChangeEventNonLocal = new KRaftLeaderChangeEvent(apply_id2, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(validLeaderChangeEventNonLocal);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validLeaderChangeEventNonLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithLeaderLogOutOfDate() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm() - 1L;
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLeaderLogOutOfDate());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithNotEnoughVotes() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Set set2 = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftInvalidVotesForLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithNonCurrentVoters() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Set set2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1000, 1002}));
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftInvalidVotesForLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithDuplicateLeader() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        this.db().addKRaftEpochLeader(this.initialDbEpoch() + 1, this.localNodeId() + 1);
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftDoubleLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithInvalidEpochChain() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        ((KRaftPartitionState)this.db().kraftQuorumState().kRaftPartitionStates().apply((Object)this.topicIdPartition())).epochChain().put((Object)BoxesRunTime.boxToInteger((int)1000), (Object)BoxesRunTime.boxToLong((long)5000L));
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftInvalidEpochChain());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithLogStartOffsetDecrease() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() - 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogStartOffsetDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLeaderChangeEventWithLocalHWMDecrease() {
        void apply_yesVoters;
        void apply_currentVoters;
        void apply_epochChainOpt;
        void apply_newLeaderId;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_newEpoch;
        void apply_logEnd;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Set<Object> set2 = this.voters();
        Some some = new Some(HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))})));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset();
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() - 1L)));
        int n2 = this.initialDbEpoch() + 1;
        long l2 = this.initialDbLeaderHwm();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_9 = null;
        some2 = null;
        some = null;
        set2 = null;
        set = null;
        KRaftLeaderChangeEvent leaderChangeEvent = new KRaftLeaderChangeEvent(apply_id, (long)apply_logEnd, 2, (int)apply_newEpoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (int)apply_newLeaderId, (Option)apply_epochChainOpt, (Set)apply_currentVoters, (Set)apply_yesVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLeaderChange(leaderChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)leaderChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    private KRaftQuorumState getExpectedKRaftStateAfterLeaderChange(KRaftLeaderChangeEvent event) {
        void apply_latestSnapshotId;
        void apply_hasFetchOffsetIncreasedInCurrentEpoch;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochLeaderIds;
        void apply_epochChain;
        void apply_localHighWatermark;
        void apply_leaderHighWatermark;
        boolean hasLogEndOffsetIncreasedInCurrentEpoch;
        KRaftQuorumState quorumState = this.db().kraftQuorumState().clone();
        boolean eventFromLocalNode = event.newLeaderId() == quorumState.localNodeId();
        quorumState.epochLeaderIds().put((Object)BoxesRunTime.boxToInteger((int)event.epoch()), (Object)BoxesRunTime.boxToInteger((int)event.newLeaderId()));
        quorumState.epochLeaderIds_$eq((HashMap)quorumState.epochLeaderIds().filter((Function1 & Serializable)epochAndLeader -> BoxesRunTime.boxToBoolean((boolean)ControllerDurabilityEventsMaterializeTest.$anonfun$getExpectedKRaftStateAfterLeaderChange$1(event, epochAndLeader))));
        boolean isCurrentLeader = event.epoch() >= BoxesRunTime.unboxToInt((Object)quorumState.epochLeaderIds().keys().max((Ordering)Ordering.Int$.MODULE$));
        KRaftPartitionState partitionState = (KRaftPartitionState)this.db().fetchKRaftPartitionState(event.topicIdPartition()).get();
        Map newEpochChain = (Map)((scala.collection.mutable.MapOps)event.epochChainOpt().getOrElse((Function0 & Serializable)() -> new HashMap())).clone();
        if (event.epochChainOpt().isDefined() && BoxesRunTime.unboxToLong((Object)event.highWatermarkOpt().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)) < BoxesRunTime.unboxToLong((Object)((MapOps)event.epochChainOpt().get()).apply((Object)BoxesRunTime.boxToInteger((int)event.epoch())))) {
            newEpochChain.remove((Object)BoxesRunTime.boxToInteger((int)event.epoch()));
        }
        HashMap mergedEpochChain = (HashMap)partitionState.epochChain().filter((Function1 & Serializable)epochAndStartOffset -> BoxesRunTime.boxToBoolean((boolean)ControllerDurabilityEventsMaterializeTest.$anonfun$getExpectedKRaftStateAfterLeaderChange$4(event, epochAndStartOffset)));
        if (isCurrentLeader) {
            ((IterableOnceOps)newEpochChain.filter((Function1 & Serializable)epochAndStartOffset -> BoxesRunTime.boxToBoolean((boolean)ControllerDurabilityEventsMaterializeTest.$anonfun$getExpectedKRaftStateAfterLeaderChange$5(event, epochAndStartOffset)))).foreach((Function1 & Serializable)epochAndStartOffset -> mergedEpochChain.put((Object)BoxesRunTime.boxToInteger((int)epochAndStartOffset._1$mcI$sp()), (Object)BoxesRunTime.boxToLong((long)epochAndStartOffset._2$mcJ$sp())));
        }
        boolean bl = hasLogEndOffsetIncreasedInCurrentEpoch = quorumState.epoch() == event.epoch() && (event.logEndOffset() > partitionState.lastKnownFetchOffset() || partitionState.hasFetchOffsetIncreasedInCurrentEpoch());
        if (eventFromLocalNode || event.yesVoters().contains((Object)BoxesRunTime.boxToInteger((int)this.localNodeId())) && event.epoch() > quorumState.epoch()) {
            quorumState.epoch_$eq(event.epoch());
        }
        Option option = partitionState.localLatestSnapshotId();
        boolean bl2 = eventFromLocalNode ? hasLogEndOffsetIncreasedInCurrentEpoch : partitionState.hasFetchOffsetIncreasedInCurrentEpoch();
        long l = eventFromLocalNode ? event.logEndOffset() : partitionState.lastKnownFetchOffset();
        long l2 = eventFromLocalNode ? event.logStartOffset() : partitionState.localLogStartOffset();
        HashMap hashMap = quorumState.epochLeaderIds();
        HashMap hashMap2 = isCurrentLeader ? mergedEpochChain : partitionState.epochChain();
        Option option2 = eventFromLocalNode && event.highWatermarkOpt().isDefined() ? event.highWatermarkOpt() : partitionState.localHighWatermark();
        Option option3 = partitionState.leaderHighWatermark();
        TopicIdPartition apply_topicIdPartition = this.topicIdPartition();
        Object var10_17 = null;
        option3 = null;
        option2 = null;
        hashMap2 = null;
        hashMap = null;
        option = null;
        KRaftPartitionState newPartitionState = new KRaftPartitionState(apply_topicIdPartition, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, (HashMap)apply_epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, (boolean)apply_hasFetchOffsetIncreasedInCurrentEpoch, (Option)apply_latestSnapshotId);
        quorumState.kRaftPartitionStates().put((Object)this.topicIdPartition(), (Object)newPartitionState);
        return quorumState;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaterializeValidKRaftHWMChangeEvent() {
        void apply_currentVoters;
        void apply_quorumFetchOffsets;
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_currentVoters2;
        void apply_quorumFetchOffsets2;
        void apply_nodeId2;
        void apply_logStartOffset2;
        void apply_highWatermark2;
        void apply_epoch2;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Map map = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L)))}));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        long l2 = this.initialDbLeaderHwm() + 1L;
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var5_7 = null;
        map = null;
        set = null;
        KRaftHWMChangeEvent validHWMChangeEventLocal = new KRaftHWMChangeEvent(apply_id, 2, (int)apply_epoch2, (long)apply_highWatermark2, (long)apply_logStartOffset2, (int)apply_nodeId2, (Map)apply_quorumFetchOffsets2, (Set)apply_currentVoters2);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(validHWMChangeEventLocal);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validHWMChangeEventLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        Set<Object> set2 = this.voters();
        Map map2 = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L)))}));
        int n3 = this.localNodeId() + 1;
        long l3 = this.initialDbLogStartOffset() + 2L;
        long l4 = this.initialDbLeaderHwm() + 2L;
        int n4 = this.initialDbEpoch() + 1;
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var14_17 = null;
        map2 = null;
        set2 = null;
        KRaftHWMChangeEvent validHWMChangeEventNonLocal = new KRaftHWMChangeEvent(apply_id2, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, (Map)apply_quorumFetchOffsets, (Set)apply_currentVoters);
        expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(validHWMChangeEventNonLocal);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validHWMChangeEventNonLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftHWMChangeEventWithDuplicateLeader() {
        void apply_currentVoters;
        void apply_quorumFetchOffsets;
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        this.db().addKRaftEpochLeader(this.initialDbEpoch(), this.localNodeId() + 1);
        Set<Object> set = this.voters();
        Map map = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L)))}));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        long l2 = this.initialDbLeaderHwm() + 1L;
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_7 = null;
        map = null;
        set = null;
        KRaftHWMChangeEvent hWMChangeEvent = new KRaftHWMChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, (Map)apply_quorumFetchOffsets, (Set)apply_currentVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(hWMChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)hWMChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftDoubleLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftHWMChangeEventWithLogStartOffsetDecrease() {
        void apply_currentVoters;
        void apply_quorumFetchOffsets;
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Map map = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L)))}));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() - 1L;
        long l2 = this.initialDbLeaderHwm() + 1L;
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_7 = null;
        map = null;
        set = null;
        KRaftHWMChangeEvent hWMChangeEvent = new KRaftHWMChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, (Map)apply_quorumFetchOffsets, (Set)apply_currentVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(hWMChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)hWMChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogStartOffsetDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftHWMChangeEventWithHWMDecrease() {
        void apply_currentVoters;
        void apply_quorumFetchOffsets;
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Map map = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)this.initialDbLeaderHwm())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)))}));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        long l2 = this.initialDbLeaderHwm() - 1L;
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_7 = null;
        map = null;
        set = null;
        KRaftHWMChangeEvent hWMChangeEvent = new KRaftHWMChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, (Map)apply_quorumFetchOffsets, (Set)apply_currentVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(hWMChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)hWMChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftHWMChangeEventWithHWMMiscalculation() {
        void apply_currentVoters;
        void apply_quorumFetchOffsets;
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Map map = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)this.initialDbLeaderHwm())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L)))}));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        long l2 = this.initialDbLeaderHwm() + 1L;
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_7 = null;
        map = null;
        set = null;
        KRaftHWMChangeEvent hWMChangeEvent = new KRaftHWMChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, (Map)apply_quorumFetchOffsets, (Set)apply_currentVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(hWMChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)hWMChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMMiscalculation());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftHWMChangeEventWithOutOfDateQuorumVoters() {
        void apply_currentVoters;
        void apply_quorumFetchOffsets;
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Set<Object> set = this.voters();
        Map map = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)100)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 2L)))}));
        int n = this.localNodeId();
        long l = this.initialDbLogStartOffset() + 1L;
        long l2 = this.initialDbLeaderHwm() + 1L;
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_7 = null;
        map = null;
        set = null;
        KRaftHWMChangeEvent hWMChangeEvent = new KRaftHWMChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, (Map)apply_quorumFetchOffsets, (Set)apply_currentVoters);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterHWMChange(hWMChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)hWMChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMMiscalculation());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    private KRaftQuorumState getExpectedKRaftStateAfterHWMChange(KRaftHWMChangeEvent event) {
        void apply_latestSnapshotId;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochLeaderIds;
        void apply_epochChain;
        void apply_localHighWatermark;
        void apply_leaderHighWatermark;
        boolean hasFetchOffsetIncreasedInCurrentEpoch;
        KRaftQuorumState quorumState = this.db().kraftQuorumState().clone();
        boolean eventFromLocalNode = event.nodeId() == quorumState.localNodeId();
        quorumState.epochLeaderIds().put((Object)BoxesRunTime.boxToInteger((int)event.epoch()), (Object)BoxesRunTime.boxToInteger((int)event.nodeId()));
        KRaftPartitionState partitionState = (KRaftPartitionState)this.db().fetchKRaftPartitionState(event.topicIdPartition()).get();
        boolean bl = hasFetchOffsetIncreasedInCurrentEpoch = quorumState.epoch() == event.epoch() && (BoxesRunTime.unboxToLong((Object)event.quorumFetchOffsets().getOrElse((Object)BoxesRunTime.boxToInteger((int)quorumState.localNodeId()), (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)) > partitionState.lastKnownFetchOffset() || partitionState.hasFetchOffsetIncreasedInCurrentEpoch());
        if (eventFromLocalNode || event.quorumFetchOffsets().contains((Object)BoxesRunTime.boxToInteger((int)this.localNodeId())) && BoxesRunTime.unboxToLong((Object)event.quorumFetchOffsets().apply((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()))) > -1L && event.epoch() > quorumState.epoch()) {
            quorumState.epoch_$eq(event.epoch());
        }
        Option option = partitionState.localLatestSnapshotId();
        long l = BoxesRunTime.unboxToLong((Object)event.quorumFetchOffsets().getOrElse((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()), (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)) != -1L ? BoxesRunTime.unboxToLong((Object)event.quorumFetchOffsets().getOrElse((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()), (Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)) : partitionState.lastKnownFetchOffset();
        long l2 = eventFromLocalNode ? event.logStartOffset() : partitionState.localLogStartOffset();
        HashMap hashMap = quorumState.epochLeaderIds();
        HashMap hashMap2 = partitionState.epochChain();
        Some some = eventFromLocalNode ? new Some((Object)BoxesRunTime.boxToLong((long)event.highWatermark())) : partitionState.localHighWatermark();
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)event.highWatermark()));
        TopicIdPartition apply_topicIdPartition = this.topicIdPartition();
        Object var7_13 = null;
        some2 = null;
        some = null;
        hashMap2 = null;
        hashMap = null;
        option = null;
        KRaftPartitionState newPartitionState = new KRaftPartitionState(apply_topicIdPartition, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, (HashMap)apply_epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, hasFetchOffsetIncreasedInCurrentEpoch, (Option)apply_latestSnapshotId);
        quorumState.kRaftPartitionStates().put((Object)this.topicIdPartition(), (Object)newPartitionState);
        return quorumState;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaterializeValidKRaftLogStartOffsetChangeEvent() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_latestSnapshotId2;
        void apply_leaderIdOpt2;
        void apply_nodeId2;
        void apply_logEndOffset2;
        void apply_logStartOffset2;
        void apply_highWatermarkOpt2;
        void apply_epoch2;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch() + 1));
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch() + 1;
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var5_8 = null;
        some2 = null;
        none$ = null;
        some = null;
        KRaftLogStartOffsetChangeEvent validLogStartOffsetChangeEventLocal = new KRaftLogStartOffsetChangeEvent(apply_id, 2, (int)apply_epoch2, (Option)apply_highWatermarkOpt2, (long)apply_logStartOffset2, (long)apply_logEndOffset2, (int)apply_nodeId2, (Option)apply_leaderIdOpt2, (Option)apply_latestSnapshotId2);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(validLogStartOffsetChangeEventLocal);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validLogStartOffsetChangeEventLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        None$ none$2 = None$.MODULE$;
        None$ none$3 = None$.MODULE$;
        int n3 = this.localNodeId() + 1;
        long l3 = this.initialDbLastKnownFetchOffset() + 1L;
        long l4 = this.initialDbLogStartOffset() + 2L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 2L)));
        int n4 = this.initialDbEpoch() + 2;
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var15_19 = null;
        some3 = null;
        none$3 = null;
        none$2 = null;
        KRaftLogStartOffsetChangeEvent validLogStartOffsetChangeEventNonLocal = new KRaftLogStartOffsetChangeEvent(apply_id2, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (int)apply_nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(validLogStartOffsetChangeEventNonLocal);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validLogStartOffsetChangeEventNonLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogStartOffsetChangeEventOnNonLocalNode() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        None$ none$2 = None$.MODULE$;
        int n = this.localNodeId() + 1;
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() - 1L;
        Some some = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some = null;
        none$2 = null;
        none$ = null;
        KRaftLogStartOffsetChangeEvent logStartOffsetChangeEvent = new KRaftLogStartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (int)apply_nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(logStartOffsetChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logStartOffsetChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogStartOffsetChangeEventWithLogStartOffsetDecrease() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Some<OffsetAndEpoch> some = this.initialDbLatestSnapshotId();
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() - 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch() + 1;
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        none$ = null;
        some = null;
        KRaftLogStartOffsetChangeEvent logStartOffsetChangeEvent = new KRaftLogStartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (int)apply_nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(logStartOffsetChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logStartOffsetChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogStartOffsetDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogStartOffsetChangeEventWithDuplicateLeader() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        this.db().addKRaftEpochLeader(this.initialDbEpoch(), this.localNodeId() + 1);
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        Some some2 = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some3 = null;
        some2 = null;
        some = null;
        KRaftLogStartOffsetChangeEvent logStartOffsetChangeEvent = new KRaftLogStartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (int)apply_nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(logStartOffsetChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logStartOffsetChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftDoubleLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogStartOffsetChangeEventWithHWMDecreaseFromLeader() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        Some some2 = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some3 = null;
        some2 = null;
        some = null;
        KRaftLogStartOffsetChangeEvent logStartOffsetChangeEvent = new KRaftLogStartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (int)apply_nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(logStartOffsetChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logStartOffsetChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogStartOffsetChangeEventWithHWMDecreaseFromNonLeader() {
        void apply_latestSnapshotId;
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        Some some2 = new Some((Object)BoxesRunTime.boxToInteger((int)(this.localNodeId() + 1)));
        int n = this.localNodeId();
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some3 = null;
        some2 = null;
        some = null;
        KRaftLogStartOffsetChangeEvent logStartOffsetChangeEvent = new KRaftLogStartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (int)apply_nodeId, (Option)apply_leaderIdOpt, (Option)apply_latestSnapshotId);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogStartOffsetChange(logStartOffsetChangeEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logStartOffsetChangeEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    private KRaftQuorumState getExpectedKRaftStateAfterLogStartOffsetChange(KRaftLogStartOffsetChangeEvent event) {
        void apply_latestSnapshotId;
        void apply_hasFetchOffsetIncreasedInCurrentEpoch;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochLeaderIds;
        void apply_epochChain;
        void apply_localHighWatermark;
        void apply_leaderHighWatermark;
        boolean hasFetchOffsetIncreasedInCurrentEpoch;
        KRaftQuorumState quorumState = this.db().kraftQuorumState().clone();
        boolean eventFromLocalNode = event.nodeId() == quorumState.localNodeId();
        KRaftPartitionState partitionState = (KRaftPartitionState)this.db().fetchKRaftPartitionState(event.topicIdPartition()).get();
        boolean isLeader = event.isFromLeader();
        if (isLeader && !quorumState.epochLeaderIds().contains((Object)BoxesRunTime.boxToInteger((int)event.epoch()))) {
            quorumState.epochLeaderIds().put((Object)BoxesRunTime.boxToInteger((int)event.epoch()), event.leaderIdOpt().get());
        }
        boolean bl = hasFetchOffsetIncreasedInCurrentEpoch = quorumState.epoch() == event.epoch() && isLeader && (event.logEndOffset() > partitionState.lastKnownFetchOffset() || partitionState.hasFetchOffsetIncreasedInCurrentEpoch());
        if (eventFromLocalNode) {
            quorumState.epoch_$eq(event.epoch());
        }
        Option option = eventFromLocalNode ? event.latestSnapshotId() : partitionState.localLatestSnapshotId();
        boolean bl2 = eventFromLocalNode ? hasFetchOffsetIncreasedInCurrentEpoch : partitionState.hasFetchOffsetIncreasedInCurrentEpoch();
        long l = isLeader && eventFromLocalNode ? event.logEndOffset() : partitionState.lastKnownFetchOffset();
        long l2 = eventFromLocalNode ? event.logStartOffset() : partitionState.localLogStartOffset();
        HashMap hashMap = quorumState.epochLeaderIds();
        HashMap hashMap2 = partitionState.epochChain();
        Option option2 = eventFromLocalNode ? event.highWatermarkOpt() : partitionState.localHighWatermark();
        Option option3 = event.isFromLeader() ? event.highWatermarkOpt() : partitionState.leaderHighWatermark();
        TopicIdPartition apply_topicIdPartition = this.topicIdPartition();
        Object var8_15 = null;
        option3 = null;
        option2 = null;
        hashMap2 = null;
        hashMap = null;
        option = null;
        KRaftPartitionState newPartitionState = new KRaftPartitionState(apply_topicIdPartition, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, (HashMap)apply_epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, (boolean)apply_hasFetchOffsetIncreasedInCurrentEpoch, (Option)apply_latestSnapshotId);
        quorumState.kRaftPartitionStates().put((Object)this.topicIdPartition(), (Object)newPartitionState);
        return quorumState;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaterializeValidKRaftLogSnapshotGenerationEvent() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_leaderIdOpt2;
        void apply_nodeId2;
        void apply_newSnapshotId2;
        void apply_logEndOffset2;
        void apply_logStartOffset2;
        void apply_highWatermarkOpt2;
        void apply_epoch2;
        this.initDbState(this.localNodeId() + 2, this.initDbState$default$2());
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)(this.localNodeId() + 2)));
        int n = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var5_8 = null;
        some2 = null;
        offsetAndEpoch = null;
        some = null;
        KRaftLogSnapshotGenerationEvent validLogSnapshotGenerationEventLocal = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch2, (Option)apply_highWatermarkOpt2, (long)apply_logStartOffset2, (long)apply_logEndOffset2, (OffsetAndEpoch)apply_newSnapshotId2, (int)apply_nodeId2, (Option)apply_leaderIdOpt2);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(validLogSnapshotGenerationEventLocal);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validLogSnapshotGenerationEventLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        None$ none$ = None$.MODULE$;
        int n3 = this.localNodeId() + 1;
        OffsetAndEpoch offsetAndEpoch2 = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l3 = this.initialDbLastKnownFetchOffset() + 1L;
        long l4 = this.initialDbLogStartOffset() + 1L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n4 = this.initialDbEpoch();
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var15_19 = null;
        some3 = null;
        offsetAndEpoch2 = null;
        none$ = null;
        KRaftLogSnapshotGenerationEvent validLogSnapshotGenerationEventNonLocal = new KRaftLogSnapshotGenerationEvent(apply_id2, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(validLogSnapshotGenerationEventNonLocal);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validLogSnapshotGenerationEventNonLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogSnapshotGenerationEventOnNonLocalNode() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId() + 1;
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some = null;
        offsetAndEpoch = null;
        none$ = null;
        KRaftLogSnapshotGenerationEvent logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogSnapshotGenerationEventWithLogStartOffsetDecrease() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        None$ x$1 = None$.MODULE$;
        int x$2 = this.initDbState$default$1();
        this.initDbState(x$2, (Option<OffsetAndEpoch>)x$1);
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() - 1L, this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() - 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var6_10 = null;
        some2 = null;
        offsetAndEpoch = null;
        some = null;
        KRaftLogSnapshotGenerationEvent logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogStartOffsetDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogSnapshotGenerationEventWithDuplicateLeader() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        this.db().addKRaftEpochLeader(this.initialDbEpoch(), this.localNodeId() + 1);
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        offsetAndEpoch = null;
        some = null;
        KRaftLogSnapshotGenerationEvent logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftDoubleLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogSnapshotGenerationEventWithHWMDecreaseFromLeader() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        offsetAndEpoch = null;
        some = null;
        KRaftLogSnapshotGenerationEvent logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogSnapshotGenerationEventWithHWMDecreaseFromNonLeader() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some = null;
        offsetAndEpoch = null;
        none$ = null;
        KRaftLogSnapshotGenerationEvent logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftLogSnapshotGenerationEventWithInvalidLogSnapshot() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_newSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_leaderIdOpt2;
        void apply_nodeId2;
        void apply_newSnapshotId2;
        void apply_logEndOffset2;
        void apply_logStartOffset2;
        void apply_highWatermarkOpt2;
        void apply_epoch2;
        void apply_leaderIdOpt3;
        void apply_nodeId3;
        void apply_newSnapshotId3;
        void apply_logEndOffset3;
        void apply_logStartOffset3;
        void apply_highWatermarkOpt3;
        void apply_epoch3;
        void apply_leaderIdOpt4;
        void apply_nodeId4;
        void apply_newSnapshotId4;
        void apply_logEndOffset4;
        void apply_logStartOffset4;
        void apply_highWatermarkOpt4;
        void apply_epoch4;
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset(), this.initialDbEpoch());
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some = null;
        offsetAndEpoch = null;
        none$ = null;
        KRaftLogSnapshotGenerationEvent logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id, 2, (int)apply_epoch4, (Option)apply_highWatermarkOpt4, (long)apply_logStartOffset4, (long)apply_logEndOffset4, (OffsetAndEpoch)apply_newSnapshotId4, (int)apply_nodeId4, (Option)apply_leaderIdOpt4);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogSnapshotGap());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        this.setUp();
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$2 = None$.MODULE$;
        int n3 = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch2 = new OffsetAndEpoch(this.initialDbLocalHwm() + 2L, this.initialDbEpoch());
        long l3 = this.initialDbLastKnownFetchOffset() + 1L;
        long l4 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n4 = this.initialDbEpoch();
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var14_19 = null;
        some2 = null;
        offsetAndEpoch2 = null;
        none$2 = null;
        logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id2, 2, (int)apply_epoch3, (Option)apply_highWatermarkOpt3, (long)apply_logStartOffset3, (long)apply_logEndOffset3, (OffsetAndEpoch)apply_newSnapshotId3, (int)apply_nodeId3, (Option)apply_leaderIdOpt3);
        expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogSnapshotExceedsHWM());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        this.setUp();
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$3 = None$.MODULE$;
        int n5 = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch3 = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l5 = this.initialDbLastKnownFetchOffset() + 1L;
        long l6 = this.initialDbLogStartOffset();
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n6 = this.initialDbEpoch();
        TopicIdPartition apply_id3 = this.topicIdPartition();
        Object var24_27 = null;
        some3 = null;
        offsetAndEpoch3 = null;
        none$3 = null;
        this.materialize().materialize(DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)new KRaftLogSnapshotGenerationEvent(apply_id3, 2, (int)apply_epoch2, (Option)apply_highWatermarkOpt2, (long)apply_logStartOffset2, (long)apply_logEndOffset2, (OffsetAndEpoch)apply_newSnapshotId2, (int)apply_nodeId2, (Option)apply_leaderIdOpt2), this.topicIdPartition()));
        None$ none$4 = None$.MODULE$;
        int n7 = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch4 = new OffsetAndEpoch(this.initialDbLogStartOffset(), this.initialDbEpoch());
        long l7 = this.initialDbLastKnownFetchOffset() + 1L;
        long l8 = this.initialDbLogStartOffset();
        Some some4 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n8 = this.initialDbEpoch();
        TopicIdPartition apply_id4 = this.topicIdPartition();
        Object var34_35 = null;
        some4 = null;
        offsetAndEpoch4 = null;
        none$4 = null;
        logSnapshotGenerationEvent = new KRaftLogSnapshotGenerationEvent(apply_id4, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        expectedKRaftState = this.getExpectedKRaftStateAfterLogSnapshotGeneration(logSnapshotGenerationEvent);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)logSnapshotGenerationEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogSnapshotDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    private KRaftQuorumState getExpectedKRaftStateAfterLogSnapshotGeneration(KRaftLogSnapshotGenerationEvent event) {
        void apply_latestSnapshotId;
        void apply_hasFetchOffsetIncreasedInCurrentEpoch;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochLeaderIds;
        void apply_epochChain;
        void apply_localHighWatermark;
        void apply_leaderHighWatermark;
        boolean hasFetchOffsetIncreasedInCurrentEpoch;
        KRaftQuorumState quorumState = this.db().kraftQuorumState().clone();
        boolean eventFromLocalNode = event.nodeId() == quorumState.localNodeId();
        KRaftPartitionState partitionState = (KRaftPartitionState)this.db().fetchKRaftPartitionState(event.topicIdPartition()).get();
        boolean isLeader = event.isFromLeader();
        if (isLeader && !quorumState.epochLeaderIds().contains((Object)BoxesRunTime.boxToInteger((int)event.epoch()))) {
            quorumState.epochLeaderIds().put((Object)BoxesRunTime.boxToInteger((int)event.epoch()), event.leaderIdOpt().get());
        }
        boolean bl = hasFetchOffsetIncreasedInCurrentEpoch = quorumState.epoch() == event.epoch() && isLeader && (event.logEndOffset() > partitionState.lastKnownFetchOffset() || partitionState.hasFetchOffsetIncreasedInCurrentEpoch());
        if (eventFromLocalNode) {
            quorumState.epoch_$eq(event.epoch());
        }
        Some some = eventFromLocalNode ? new Some((Object)event.newSnapshotId()) : partitionState.localLatestSnapshotId();
        boolean bl2 = eventFromLocalNode ? hasFetchOffsetIncreasedInCurrentEpoch : partitionState.hasFetchOffsetIncreasedInCurrentEpoch();
        long l = isLeader && eventFromLocalNode ? event.logEndOffset() : partitionState.lastKnownFetchOffset();
        long l2 = eventFromLocalNode ? event.logStartOffset() : partitionState.localLogStartOffset();
        HashMap hashMap = quorumState.epochLeaderIds();
        HashMap hashMap2 = partitionState.epochChain();
        Option option = eventFromLocalNode && event.highWatermarkOpt().isDefined() ? event.highWatermarkOpt() : partitionState.localHighWatermark();
        Option option2 = event.isFromLeader() ? event.highWatermarkOpt() : partitionState.leaderHighWatermark();
        TopicIdPartition apply_topicIdPartition = this.topicIdPartition();
        Object var8_15 = null;
        option2 = null;
        option = null;
        hashMap2 = null;
        hashMap = null;
        some = null;
        KRaftPartitionState newPartitionState = new KRaftPartitionState(apply_topicIdPartition, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, (HashMap)apply_epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, (boolean)apply_hasFetchOffsetIncreasedInCurrentEpoch, (Option)apply_latestSnapshotId);
        quorumState.kRaftPartitionStates().put((Object)this.topicIdPartition(), (Object)newPartitionState);
        return quorumState;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaterializeValidKRaftNodeStartUpEvent() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_leaderIdOpt2;
        void apply_nodeId2;
        void apply_latestSnapshotId2;
        void apply_logEndOffset2;
        void apply_logStartOffset2;
        void apply_highWatermarkOpt2;
        void apply_epoch2;
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var5_8 = null;
        some2 = null;
        some = null;
        none$ = null;
        KRaftNodeStartUpEvent validNodeStartUpEventLocal = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch2, (Option)apply_highWatermarkOpt2, (long)apply_logStartOffset2, (long)apply_logEndOffset2, (Option)apply_latestSnapshotId2, (int)apply_nodeId2, (Option)apply_leaderIdOpt2);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(validNodeStartUpEventLocal);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validNodeStartUpEventLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        None$ none$2 = None$.MODULE$;
        int n3 = this.localNodeId() + 1;
        Some some3 = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        long l3 = this.initialDbLastKnownFetchOffset() + 1L;
        long l4 = this.initialDbLogStartOffset() + 1L;
        Some some4 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n4 = this.initialDbEpoch();
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var15_19 = null;
        some4 = null;
        some3 = null;
        none$2 = null;
        KRaftNodeStartUpEvent validNodeStartUpEventNonLocal = new KRaftNodeStartUpEvent(apply_id2, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(validNodeStartUpEventNonLocal);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)validNodeStartUpEventNonLocal, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftNodeStartUpEventOnNonLocalNode() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId() + 1;
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset();
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        some = null;
        none$ = null;
        KRaftNodeStartUpEvent nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidKRaftNodeStartUpEventWithLogStartOffsetDecrease() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.localNodeId() + 1, (Option<OffsetAndEpoch>)None$.MODULE$);
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() - 1L, this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset();
        long l2 = this.initialDbLogStartOffset() - 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        some = null;
        none$ = null;
        KRaftNodeStartUpEvent nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.never())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftNodeStartUpEventWithDuplicateLeader() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        this.db().addKRaftEpochLeader(this.initialDbEpoch(), this.localNodeId() + 1);
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        Some some2 = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some3 = null;
        some2 = null;
        some = null;
        KRaftNodeStartUpEvent nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftDoubleLeader());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftNodeStartUpEventWithHWMDecreaseFromLeader() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.initDbState$default$1(), this.initDbState$default$2());
        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)this.localNodeId()));
        int n = this.localNodeId();
        Some some2 = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLeaderHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some3 = null;
        some2 = null;
        some = null;
        KRaftNodeStartUpEvent nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftNodeStartUpEventWithHWMDecreaseFromNonLeader() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() - 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        some = null;
        none$ = null;
        KRaftNodeStartUpEvent nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftHWMDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidKRaftNodeStartUpEventWithInvalidLogSnapshot() {
        void apply_leaderIdOpt;
        void apply_nodeId;
        void apply_latestSnapshotId;
        void apply_logEndOffset;
        void apply_logStartOffset;
        void apply_highWatermarkOpt;
        void apply_epoch;
        void apply_leaderIdOpt2;
        void apply_nodeId2;
        void apply_newSnapshotId;
        void apply_logEndOffset2;
        void apply_logStartOffset2;
        void apply_highWatermarkOpt2;
        void apply_epoch2;
        void apply_leaderIdOpt3;
        void apply_nodeId3;
        void apply_latestSnapshotId2;
        void apply_logEndOffset3;
        void apply_logStartOffset3;
        void apply_highWatermarkOpt3;
        void apply_epoch3;
        void apply_leaderIdOpt4;
        void apply_nodeId4;
        void apply_newSnapshotId2;
        void apply_logEndOffset4;
        void apply_logStartOffset4;
        void apply_highWatermarkOpt4;
        void apply_epoch4;
        void apply_leaderIdOpt5;
        void apply_nodeId5;
        void apply_latestSnapshotId3;
        void apply_logEndOffset5;
        void apply_logStartOffset5;
        void apply_highWatermarkOpt5;
        void apply_epoch5;
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$ = None$.MODULE$;
        int n = this.localNodeId();
        Some some = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset(), this.initialDbEpoch()));
        long l = this.initialDbLastKnownFetchOffset() + 1L;
        long l2 = this.initialDbLogStartOffset() + 1L;
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n2 = this.initialDbEpoch();
        TopicIdPartition apply_id = this.topicIdPartition();
        Object var4_8 = null;
        some2 = null;
        some = null;
        none$ = null;
        KRaftNodeStartUpEvent nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id, 2, (int)apply_epoch5, (Option)apply_highWatermarkOpt5, (long)apply_logStartOffset5, (long)apply_logEndOffset5, (Option)apply_latestSnapshotId3, (int)apply_nodeId5, (Option)apply_leaderIdOpt5);
        KRaftQuorumState expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        ConsumerRecord<byte[], byte[]> consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogSnapshotGap());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        this.setUp();
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$2 = None$.MODULE$;
        int n3 = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l3 = this.initialDbLastKnownFetchOffset() + 1L;
        long l4 = this.initialDbLogStartOffset();
        Some some3 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n4 = this.initialDbEpoch();
        TopicIdPartition apply_id2 = this.topicIdPartition();
        Object var14_19 = null;
        some3 = null;
        offsetAndEpoch = null;
        none$2 = null;
        this.materialize().materialize(DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)new KRaftLogSnapshotGenerationEvent(apply_id2, 2, (int)apply_epoch4, (Option)apply_highWatermarkOpt4, (long)apply_logStartOffset4, (long)apply_logEndOffset4, (OffsetAndEpoch)apply_newSnapshotId2, (int)apply_nodeId4, (Option)apply_leaderIdOpt4), this.topicIdPartition()));
        None$ none$3 = None$.MODULE$;
        int n5 = this.localNodeId();
        Some some4 = new Some((Object)new OffsetAndEpoch(this.initialDbLogStartOffset(), this.initialDbEpoch()));
        long l5 = this.initialDbLastKnownFetchOffset() + 1L;
        long l6 = this.initialDbLogStartOffset();
        Some some5 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n6 = this.initialDbEpoch();
        TopicIdPartition apply_id3 = this.topicIdPartition();
        Object var24_27 = null;
        some5 = null;
        some4 = null;
        none$3 = null;
        nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id3, 2, (int)apply_epoch3, (Option)apply_highWatermarkOpt3, (long)apply_logStartOffset3, (long)apply_logEndOffset3, (Option)apply_latestSnapshotId2, (int)apply_nodeId3, (Option)apply_leaderIdOpt3);
        expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogSnapshotDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
        this.setUp();
        this.initDbState(this.localNodeId() + 1, this.initDbState$default$2());
        None$ none$4 = None$.MODULE$;
        int n7 = this.localNodeId();
        OffsetAndEpoch offsetAndEpoch2 = new OffsetAndEpoch(this.initialDbLogStartOffset() + 1L, this.initialDbEpoch());
        long l7 = this.initialDbLastKnownFetchOffset() + 1L;
        long l8 = this.initialDbLogStartOffset();
        Some some6 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n8 = this.initialDbEpoch();
        TopicIdPartition apply_id4 = this.topicIdPartition();
        Object var34_35 = null;
        some6 = null;
        offsetAndEpoch2 = null;
        none$4 = null;
        this.materialize().materialize(DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)new KRaftLogSnapshotGenerationEvent(apply_id4, 2, (int)apply_epoch2, (Option)apply_highWatermarkOpt2, (long)apply_logStartOffset2, (long)apply_logEndOffset2, (OffsetAndEpoch)apply_newSnapshotId, (int)apply_nodeId2, (Option)apply_leaderIdOpt2), this.topicIdPartition()));
        None$ none$5 = None$.MODULE$;
        int n9 = this.localNodeId();
        None$ none$6 = None$.MODULE$;
        long l9 = this.initialDbLastKnownFetchOffset() + 1L;
        long l10 = this.initialDbLogStartOffset();
        Some some7 = new Some((Object)BoxesRunTime.boxToLong((long)(this.initialDbLocalHwm() + 1L)));
        int n10 = this.initialDbEpoch();
        TopicIdPartition apply_id5 = this.topicIdPartition();
        Object var44_43 = null;
        some7 = null;
        none$6 = null;
        none$5 = null;
        nodeStartUpEvent = new KRaftNodeStartUpEvent(apply_id5, 2, (int)apply_epoch, (Option)apply_highWatermarkOpt, (long)apply_logStartOffset, (long)apply_logEndOffset, (Option)apply_latestSnapshotId, (int)apply_nodeId, (Option)apply_leaderIdOpt);
        expectedKRaftState = this.getExpectedKRaftStateAfterNodeStartUp(nodeStartUpEvent);
        consumerRecord = DurabilityTestUtils$.MODULE$.createDurabilityEventConsumerRecord((AbstractDurabilityEvent)nodeStartUpEvent, this.topicIdPartition());
        Assertions.assertTrue((boolean)this.materialize().materialize(consumerRecord));
        this.confirmDurabilityLapseReported(DurabilityLapseType$.MODULE$.KRaftLogSnapshotDecrease());
        Assertions.assertEquals((Object)expectedKRaftState, (Object)this.db().kraftQuorumState());
    }

    /*
     * WARNING - void declaration
     */
    private KRaftQuorumState getExpectedKRaftStateAfterNodeStartUp(KRaftNodeStartUpEvent event) {
        void apply_latestSnapshotId;
        void apply_hasFetchOffsetIncreasedInCurrentEpoch;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochLeaderIds;
        void apply_epochChain;
        void apply_localHighWatermark;
        void apply_leaderHighWatermark;
        boolean hasFetchOffsetIncreasedInCurrentEpoch;
        KRaftQuorumState quorumState = this.db().kraftQuorumState().clone();
        boolean eventFromLocalNode = event.nodeId() == quorumState.localNodeId();
        KRaftPartitionState partitionState = (KRaftPartitionState)this.db().fetchKRaftPartitionState(event.topicIdPartition()).get();
        boolean isLeader = event.isFromLeader();
        if (isLeader && !quorumState.epochLeaderIds().contains((Object)BoxesRunTime.boxToInteger((int)event.epoch()))) {
            quorumState.epochLeaderIds().put((Object)BoxesRunTime.boxToInteger((int)event.epoch()), event.leaderIdOpt().get());
        }
        boolean bl = hasFetchOffsetIncreasedInCurrentEpoch = quorumState.epoch() == event.epoch() && isLeader && (event.logEndOffset() > partitionState.lastKnownFetchOffset() || partitionState.hasFetchOffsetIncreasedInCurrentEpoch());
        if (eventFromLocalNode) {
            quorumState.epoch_$eq(event.epoch());
        }
        Option option = eventFromLocalNode ? event.latestSnapshotId() : partitionState.localLatestSnapshotId();
        boolean bl2 = eventFromLocalNode ? hasFetchOffsetIncreasedInCurrentEpoch : partitionState.hasFetchOffsetIncreasedInCurrentEpoch();
        long l = isLeader && eventFromLocalNode ? event.logEndOffset() : partitionState.lastKnownFetchOffset();
        long l2 = eventFromLocalNode ? event.logStartOffset() : partitionState.localLogStartOffset();
        HashMap hashMap = quorumState.epochLeaderIds();
        HashMap hashMap2 = partitionState.epochChain();
        Option option2 = eventFromLocalNode && event.highWatermarkOpt().isDefined() ? event.highWatermarkOpt() : partitionState.localHighWatermark();
        Option option3 = event.isFromLeader() ? event.highWatermarkOpt() : partitionState.leaderHighWatermark();
        TopicIdPartition apply_topicIdPartition = this.topicIdPartition();
        Object var8_15 = null;
        option3 = null;
        option2 = null;
        hashMap2 = null;
        hashMap = null;
        option = null;
        KRaftPartitionState newPartitionState = new KRaftPartitionState(apply_topicIdPartition, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, (HashMap)apply_epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, (boolean)apply_hasFetchOffsetIncreasedInCurrentEpoch, (Option)apply_latestSnapshotId);
        quorumState.kRaftPartitionStates().put((Object)this.topicIdPartition(), (Object)newPartitionState);
        return quorumState;
    }

    /*
     * WARNING - void declaration
     */
    private void initDbState(int initialLeaderId, Option<OffsetAndEpoch> initialSnapshotId) {
        void apply_hasFetchOffsetIncreasedInCurrentEpoch;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochLeaderIds;
        void apply_epochChain;
        void apply_localHighWatermark;
        void apply_leaderHighWatermark;
        boolean bl = false;
        long l = this.initialDbLastKnownFetchOffset();
        long l2 = this.initialDbLogStartOffset();
        HashMap hashMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        HashMap hashMap2 = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Some some = new Some((Object)BoxesRunTime.boxToLong((long)this.initialDbLocalHwm()));
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)this.initialDbLeaderHwm()));
        TopicIdPartition apply_topicIdPartition = this.topicIdPartition();
        Object var4_10 = null;
        some2 = null;
        some = null;
        hashMap2 = null;
        hashMap = null;
        KRaftPartitionState kRaftPartitionState = new KRaftPartitionState(apply_topicIdPartition, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, (HashMap)apply_epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, (boolean)apply_hasFetchOffsetIncreasedInCurrentEpoch, initialSnapshotId);
        this.db().addKRaftEpochLeader(this.initialDbEpoch(), initialLeaderId);
        this.db().addKRaftPartitionState(kRaftPartitionState);
        this.db().setKRaftLocalEpoch(this.initialDbEpoch());
    }

    private int initDbState$default$1() {
        return this.localNodeId();
    }

    private Option<OffsetAndEpoch> initDbState$default$2() {
        return this.initialDbLatestSnapshotId();
    }

    private void confirmDurabilityLapseReported(Enumeration.Value expectedLapseType) {
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.atLeastOnce())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        ((AuditReporter)Mockito.verify((Object)this.reporter(), (VerificationMode)Mockito.atMostOnce())).reportDurabilityLapse((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (Enumeration.Value)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Assertions.assertEquals((Object)expectedLapseType, (Object)this.lapseType());
    }

    public static final /* synthetic */ boolean $anonfun$getExpectedKRaftStateAfterLeaderChange$1(KRaftLeaderChangeEvent event$1, Tuple2 epochAndLeader) {
        return epochAndLeader._1$mcI$sp() >= event$1.epoch() - 100;
    }

    public static final /* synthetic */ boolean $anonfun$getExpectedKRaftStateAfterLeaderChange$4(KRaftLeaderChangeEvent event$1, Tuple2 epochAndStartOffset) {
        return epochAndStartOffset._1$mcI$sp() >= event$1.epoch() - 100;
    }

    public static final /* synthetic */ boolean $anonfun$getExpectedKRaftStateAfterLeaderChange$5(KRaftLeaderChangeEvent event$1, Tuple2 epochAndStartOffset) {
        return epochAndStartOffset._1$mcI$sp() >= event$1.epoch() - 100;
    }

    public ControllerDurabilityEventsMaterializeTest() {
        this.localNodeId = 0;
        this.initialDbLeaderHwm = 20L;
        this.initialDbLocalHwm = 3L;
        this.initialDbEpoch = 1;
        this.initialDbLogStartOffset = 1L;
    }
}

