/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityTestUtilConstants$;
import kafka.durability.DurabilityTestUtils$;
import kafka.durability.TestBrokerAuditManager;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.OffsetCount;
import kafka.durability.audit.request.AuditManagerRequest;
import kafka.durability.audit.request.RegisterPartitionRequest;
import kafka.durability.db.AuditRunState;
import kafka.durability.db.AuditRunState$;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.broker.DeletePartitionEvent;
import kafka.durability.events.broker.DeleteRecordsEvent;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.broker.RetentionChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.materialization.BrokerDurabilityEventsMaterialize;
import kafka.durability.materialization.validation.BrokerValidator;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.TierLogSegment;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t5e\u0001\u0002!B\u0001!CQa\u0014\u0001\u0005\u0002AC\u0011b\u0015\u0001A\u0002\u0003\u0007I\u0011\u0002+\t\u0013\u0005\u0004\u0001\u0019!a\u0001\n\u0013\u0011\u0007\"\u00035\u0001\u0001\u0004\u0005\t\u0015)\u0003V\u0011%I\u0007\u00011AA\u0002\u0013%!\u000eC\u0005r\u0001\u0001\u0007\t\u0019!C\u0005e\"IA\u000f\u0001a\u0001\u0002\u0003\u0006Ka\u001b\u0005\nk\u0002\u0001\r\u00111A\u0005\nYD\u0011b\u001f\u0001A\u0002\u0003\u0007I\u0011\u0002?\t\u0013y\u0004\u0001\u0019!A!B\u00139\bBC@\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0002!Y\u0011q\u0002\u0001A\u0002\u0003\u0007I\u0011BA\t\u0011-\t)\u0002\u0001a\u0001\u0002\u0003\u0006K!a\u0001\t\u0017\u0005]\u0001\u00011AA\u0002\u0013%\u0011\u0011\u0004\u0005\f\u0003K\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0003C\u0006\u0002,\u0001\u0001\r\u0011!Q!\n\u0005m\u0001bCA\u0017\u0001\u0001\u0007\t\u0019!C\u0005\u0003_A1\"!\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002D!Y\u0011q\t\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0019\u0011-\tI\u0005\u0001a\u0001\u0002\u0004%I!a\u0013\t\u0017\u0005u\u0003\u00011AA\u0002\u0013%\u0011q\f\u0005\f\u0003G\u0002\u0001\u0019!A!B\u0013\ti\u0005C\u0005\u0002f\u0001\u0011\r\u0011\"\u0003\u0002h!A\u0011q\u000e\u0001!\u0002\u0013\tI\u0007C\u0005\u0002r\u0001\u0011\r\u0011\"\u0003\u0002t!A\u0011Q\u0010\u0001!\u0002\u0013\t)\bC\u0005\u0002\u0000\u0001\u0011\r\u0011\"\u0003\u0002t!A\u0011\u0011\u0011\u0001!\u0002\u0013\t)\bC\u0005\u0002\u0004\u0002\u0011\r\u0011\"\u0003\u0002\u0006\"A\u0011Q\u0012\u0001!\u0002\u0013\t9\tC\u0005\u0002\u0010\u0002\u0011\r\u0011\"\u0003\u0002\u0012\"A\u0011\u0011\u0016\u0001!\u0002\u0013\t\u0019\nC\u0005\u0002,\u0002\u0011\r\u0011\"\u0003\u0002.\"A\u0011Q\u0017\u0001!\u0002\u0013\ty\u000bC\u0005\u00028\u0002\u0011\r\u0011\"\u0003\u0002:\"A\u0011\u0011\u0019\u0001!\u0002\u0013\tY\fC\u0005\u0002D\u0002\u0011\r\u0011\"\u0001\u0002F\"A\u0011Q\u001a\u0001!\u0002\u0013\t9\rC\u0005\u0002P\u0002\u0011\r\u0011\"\u0001\u0002R\"A\u0011\u0011\u001f\u0001!\u0002\u0013\t\u0019\u000eC\u0006\u0002t\u0002\u0001\r\u00111A\u0005\u0002\u0005U\bb\u0003B\u0001\u0001\u0001\u0007\t\u0019!C\u0001\u0005\u0007A1Ba\u0002\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002x\"Y!\u0011\u0002\u0001A\u0002\u0003\u0007I\u0011\u0001B\u0006\u0011-\u0011\u0019\u0002\u0001a\u0001\u0002\u0004%\tA!\u0006\t\u0017\te\u0001\u00011A\u0001B\u0003&!Q\u0002\u0005\f\u00057\u0001\u0001\u0019!a\u0001\n\u0003\u0011i\u0002C\u0006\u0003,\u0001\u0001\r\u00111A\u0005\u0002\t5\u0002b\u0003B\u0019\u0001\u0001\u0007\t\u0011)Q\u0005\u0005?AqAa\r\u0001\t\u0003\u0011)\u0004C\u0004\u0003N\u0001!\tA!\u000e\t\u000f\t]\u0003\u0001\"\u0001\u00036!9!\u0011\r\u0001\u0005\u0002\tU\u0002b\u0002B3\u0001\u0011\u0005!Q\u0007\u0005\b\u0005S\u0002A\u0011\u0001B\u001b\u0011\u001d\u0011i\u0007\u0001C\u0001\u0005kAqA!\u001d\u0001\t\u0003\u0011)\u0004C\u0004\u0003v\u0001!\tA!\u000e\t\u000f\te\u0004\u0001\"\u0001\u00036!9!Q\u0010\u0001\u0005\u0002\tU\u0002b\u0002BA\u0001\u0011\u0005!Q\u0007\u0005\b\u0005\u000b\u0003A\u0011\u0001B\u001b\u0011\u001d\u0011I\t\u0001C\u0001\u0005k\u0011QE\u0011:pW\u0016\u0014H)\u001e:bE&d\u0017\u000e^=Fm\u0016tGo]'bi\u0016\u0014\u0018.\u00197ju\u0016$Vm\u001d;\u000b\u0005\t\u001b\u0015aD7bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005\u0011+\u0015A\u00033ve\u0006\u0014\u0017\u000e\\5us*\ta)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001I\u0005C\u0001&N\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002#B\u0011!\u000bA\u0007\u0002\u0003\u00069Q.\u001a;sS\u000e\u001cX#A+\u0011\u0005Y{V\"A,\u000b\u0005MC&BA-[\u0003\u0019\u0019w.\\7p]*\u0011ai\u0017\u0006\u00039v\u000ba!\u00199bG\",'\"\u00010\u0002\u0007=\u0014x-\u0003\u0002a/\n9Q*\u001a;sS\u000e\u001c\u0018aC7fiJL7m]0%KF$\"a\u00194\u0011\u0005)#\u0017BA3L\u0005\u0011)f.\u001b;\t\u000f\u001d\u001c\u0011\u0011!a\u0001+\u0006\u0019\u0001\u0010J\u0019\u0002\u00115,GO]5dg\u0002\n\u0001B]3q_J$XM]\u000b\u0002WB\u0011An\\\u0007\u0002[*\u0011anQ\u0001\u0006CV$\u0017\u000e^\u0005\u0003a6\u0014Q\"Q;eSR\u0014V\r]8si\u0016\u0014\u0018\u0001\u0004:fa>\u0014H/\u001a:`I\u0015\fHCA2t\u0011\u001d9g!!AA\u0002-\f\u0011B]3q_J$XM\u001d\u0011\u0002\u00115l\u0015M\\1hKJ,\u0012a\u001e\t\u0003qfl\u0011aQ\u0005\u0003u\u000e\u0013\u0001\u0004R;sC\nLG.\u001b;z\u001b\u0016$(/[2t\u001b\u0006t\u0017mZ3s\u00031iW*\u00198bO\u0016\u0014x\fJ3r)\t\u0019W\u0010C\u0004h\u0013\u0005\u0005\t\u0019A<\u0002\u00135l\u0015M\\1hKJ\u0004\u0013\u0001\u0002;j[\u0016,\"!a\u0001\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003Y\u0003\u0015)H/\u001b7t\u0013\u0011\ti!a\u0002\u0003\tQKW.Z\u0001\ti&lWm\u0018\u0013fcR\u00191-a\u0005\t\u0011\u001dd\u0011\u0011!a\u0001\u0003\u0007\tQ\u0001^5nK\u0002\n!\u0001\u001a2\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Ci!!a\b\u000b\u0007\u0005]1)\u0003\u0003\u0002$\u0005}!\u0001\u0004#ve\u0006\u0014\u0017\u000e\\5us\u0012\u0013\u0015A\u00023c?\u0012*\u0017\u000fF\u0002d\u0003SA\u0001bZ\b\u0002\u0002\u0003\u0007\u00111D\u0001\u0004I\n\u0004\u0013A\u0002;na\u0012K'/\u0006\u0002\u00022A!\u00111GA\u001f\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012AA5p\u0015\t\tY$\u0001\u0003kCZ\f\u0017\u0002BA \u0003k\u0011AAR5mK\u0006QA/\u001c9ESJ|F%Z9\u0015\u0007\r\f)\u0005\u0003\u0005h%\u0005\u0005\t\u0019AA\u0019\u0003\u001d!X\u000e\u001d#je\u0002\nA\u0002^5fe>\u0013'n\u0015;pe\u0016,\"!!\u0014\u0011\t\u0005=\u0013\u0011L\u0007\u0003\u0003#RA!a\u0015\u0002V\u0005)1\u000f^8sK*\u0019\u0011qK#\u0002\tQLWM]\u0005\u0005\u00037\n\tFA\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0003A!\u0018.\u001a:PE*\u001cFo\u001c:f?\u0012*\u0017\u000fF\u0002d\u0003CB\u0001bZ\u000b\u0002\u0002\u0003\u0007\u0011QJ\u0001\u000ei&,'o\u00142k'R|'/\u001a\u0011\u0002%\u0011,g-Y;miJ+G/\u001a8uS>tWj]\u000b\u0003\u0003S\u00022ASA6\u0013\r\tig\u0013\u0002\u0004\u0013:$\u0018a\u00053fM\u0006,H\u000e\u001e*fi\u0016tG/[8o\u001bN\u0004\u0013a\u0002;pa&\u001c\u0017\nZ\u000b\u0003\u0003k\u0002B!a\u001e\u0002z5\t\u0001,C\u0002\u0002|a\u0013A!V;jI\u0006AAo\u001c9jG&#\u0007%A\u0006{KJ|Gk\u001c9jG&#\u0017\u0001\u0004>fe>$v\u000e]5d\u0013\u0012\u0004\u0013a\u0001;qcU\u0011\u0011q\u0011\t\u0005\u0003o\nI)C\u0002\u0002\fb\u0013\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002\tQ\u0004\u0018\u0007I\u0001\u000bKB|7\r[\"iC&tWCAAJ!!\t)*a(\u0002j\u0005\rVBAAL\u0015\u0011\tI*a'\u0002\u000f5,H/\u00192mK*\u0019\u0011QT&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\"\u0006]%a\u0002%bg\"l\u0015\r\u001d\t\u0004\u0015\u0006\u0015\u0016bAAT\u0017\n!Aj\u001c8h\u0003-)\u0007o\\2i\u0007\"\f\u0017N\u001c\u0011\u0002\u0005\u0005\u001cXCAAX!\u0011\ti\"!-\n\t\u0005M\u0016q\u0004\u0002\u000e\u0003V$\u0017\u000e\u001e*v]N#\u0018\r^3\u0002\u0007\u0005\u001c\b%\u0001\u0002qgV\u0011\u00111\u0018\t\u0005\u0003;\ti,\u0003\u0003\u0002@\u0006}!A\u0004)beRLG/[8o'R\fG/Z\u0001\u0004aN\u0004\u0013\u0001\u0002;q\u0013\u0012,\"!a2\u0011\t\u0005%\u00171Z\u0007\u0003\u0003+JA!a#\u0002V\u0005)A\u000f]%eA\u0005aAn\\2bY>3gm]3ugV\u0011\u00111\u001b\t\u0007\u0003+\f)/a;\u000f\t\u0005]\u0017\u0011\u001d\b\u0005\u00033\fy.\u0004\u0002\u0002\\*\u0019\u0011Q\\$\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0015bAAr\u0017\u00069\u0001/Y2lC\u001e,\u0017\u0002BAt\u0003S\u00141aU3r\u0015\r\t\u0019o\u0013\t\b\u0015\u00065\u00181UAR\u0013\r\tyo\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u001b1|7-\u00197PM\u001a\u001cX\r^:!\u0003\rawnZ\u000b\u0003\u0003o\u0004B!!?\u0002~6\u0011\u00111 \u0006\u0004\u0003g,\u0015\u0002BA\u0000\u0003w\u00141\"\u00112tiJ\f7\r\u001e'pO\u00069An\\4`I\u0015\fHcA2\u0003\u0006!AqMKA\u0001\u0002\u0004\t90\u0001\u0003m_\u001e\u0004\u0013A\u00037pO6\u000bg.Y4feV\u0011!Q\u0002\t\u0005\u0003s\u0014y!\u0003\u0003\u0003\u0012\u0005m(A\u0003'pO6\u000bg.Y4fe\u0006qAn\\4NC:\fw-\u001a:`I\u0015\fHcA2\u0003\u0018!Aq-LA\u0001\u0002\u0004\u0011i!A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0005?\u0001BA!\t\u0003(5\u0011!1\u0005\u0006\u0004\u0005K)\u0015AB:feZ,'/\u0003\u0003\u0003*\t\r\"A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002d\u0005_A\u0001b\u001a\u0019\u0002\u0002\u0003\u0007!qD\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005)1/\u001a;VaR\t1\rK\u00023\u0005s\u0001BAa\u000f\u0003J5\u0011!Q\b\u0006\u0005\u0005\u007f\u0011\t%A\u0002ba&TAAa\u0011\u0003F\u00059!.\u001e9ji\u0016\u0014(b\u0001B$;\u0006)!.\u001e8ji&!!1\nB\u001f\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a1G!\u0015\u0011\t\tm\"1K\u0005\u0005\u0005+\u0012iDA\u0005BMR,'/R1dQ\u0006yB/Z:u'6\fG\u000e\\3s\u0011&<\u0007nV1uKJl\u0017M]6DQ\u0006tw-Z:)\u0007Q\u0012Y\u0006\u0005\u0003\u0003<\tu\u0013\u0002\u0002B0\u0005{\u0011A\u0001V3ti\u0006qB/Z:u\u0019\u0006\u0014x-\u001a:IS\u001eDw+\u0019;fe6\f'o[\"iC:<Wm\u001d\u0015\u0004k\tm\u0013a\u0007;fgR\u0014VM[3di&|gn\u00144Ti\u0006dWMU3d_J$7\u000fK\u00027\u00057\nA\u0004^3ti\"\u000bg\u000e\u001a7f'R\fG.\u001a#fY\u0016$XMU3d_J$7\u000fK\u00028\u00057\n1\u0003^3ti\u0012+G.\u001a;f!\u0006\u0014H/\u001b;j_:D3\u0001\u000fB.\u0003\t\"Xm\u001d;NSN\u001c\u0018N\\4EK2,G/\u001a)beRLG/[8o%\u0016\u001cwN^3ss\"\u001a\u0011Ha\u0017\u00021Q,7\u000f^#q_\u000eD7\t[1j]Z\u000bG.\u001b3bi&|g\u000eK\u0002;\u00057\n\u0001\u0005^3tiRKW.\u001a\"bg\u0016$'+\u001a;f]RLwN\u001c,bY&$\u0017\r^5p]\"\u001a1Ha\u0017\u0002yQ,7\u000f\u001e+j[\u0016\u0014\u0015m]3e%\u0016$XM\u001c;j_:4\u0016\r\\5eCRLwN\\,ji\"tu\u000eR3mKR,GmU3h[\u0016tG/T3uC\u0012\fG/\u0019\u0015\u0004y\tm\u0013\u0001\r;fgR$\u0016.\\3CCN,GMU3uK:$\u0018n\u001c8WC2LG-\u0019;j_:<\u0016\u000e\u001e5Vg\u0016\u0014H)\u001a7fi&|g\u000eK\u0002>\u00057\n!\u0004^3ti6K7o]5oO\u0012+G.\u001a;f!\u0006\u0014H/\u001b;j_:D3A\u0010B.\u0003q!Xm\u001d;Ti\u0006dW-\u0012<f]R<\u0016\u000e\u001e5pkR$v\u000e]5d\u0013\u0012D3a\u0010B.\u0001")
public class BrokerDurabilityEventsMaterializeTest {
    private Metrics metrics;
    private AuditReporter kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter;
    private DurabilityMetricsManager mManager;
    private Time kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time;
    private DurabilityDB kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$db;
    private File tmpDir;
    private TierObjectStore tierObjStore;
    private final int defaultRetentionMs;
    private final Uuid topicId = Uuid.randomUuid();
    private final Uuid zeroTopicId = Uuid.ZERO_UUID;
    private final TopicIdPartition tp1 = new TopicIdPartition(this.topicId(), new TopicPartition("t1", 1));
    private final HashMap<Object, Object> epochChain = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))}));
    private final AuditRunState as = AuditRunState$.MODULE$.apply();
    private final PartitionState ps;
    private final kafka.tier.TopicIdPartition tpId;
    private final scala.collection.immutable.Seq<Tuple2<Object, Object>> localOffsets;
    private AbstractLog log;
    private LogManager logManager;
    private ReplicaManager replicaManager;

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public AuditReporter kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter() {
        return this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter;
    }

    private void reporter_$eq(AuditReporter x$1) {
        this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter = x$1;
    }

    private DurabilityMetricsManager mManager() {
        return this.mManager;
    }

    private void mManager_$eq(DurabilityMetricsManager x$1) {
        this.mManager = x$1;
    }

    public Time kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time() {
        return this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time;
    }

    private void time_$eq(Time x$1) {
        this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time = x$1;
    }

    public DurabilityDB kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$db() {
        return this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$db;
    }

    private void db_$eq(DurabilityDB x$1) {
        this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$db = x$1;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    private TierObjectStore tierObjStore() {
        return this.tierObjStore;
    }

    private void tierObjStore_$eq(TierObjectStore x$1) {
        this.tierObjStore = x$1;
    }

    private int defaultRetentionMs() {
        return this.defaultRetentionMs;
    }

    private Uuid topicId() {
        return this.topicId;
    }

    private Uuid zeroTopicId() {
        return this.zeroTopicId;
    }

    private TopicIdPartition tp1() {
        return this.tp1;
    }

    private HashMap<Object, Object> epochChain() {
        return this.epochChain;
    }

    private AuditRunState as() {
        return this.as;
    }

    private PartitionState ps() {
        return this.ps;
    }

    public kafka.tier.TopicIdPartition tpId() {
        return this.tpId;
    }

    public scala.collection.immutable.Seq<Tuple2<Object, Object>> localOffsets() {
        return this.localOffsets;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq((Time)new MockTime(0L, 0L));
        this.metrics_$eq(new Metrics(new MetricConfig(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava(), this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time()));
        Metrics x$2 = this.metrics();
        Time x$3 = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time();
        long x$5 = DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS();
        this.mManager_$eq(new DurabilityMetricsManager("0", x$2, x$3, x$5, false));
        DurabilityMetricsManager apply_metricManager = this.mManager();
        Object var5_4 = null;
        this.reporter_$eq(new AuditReporter(apply_metricManager));
        this.db_$eq(DbTestUtils$.MODULE$.getDbInstance());
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.tierObjStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig()));
        this.log_$eq(DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(this.tpId(), this.localOffsets(), this.tmpDir(), this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time(), (scala.collection.immutable.Seq<Tuple2<Object, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (Option<TierObjectStore>)None$.MODULE$));
        this.logManager_$eq(DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)this.log())})))));
        this.replicaManager_$eq(DurabilityTestUtils$.MODULE$.mockReplicaManager(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        DbTestUtils$.MODULE$.cleanup(this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$db());
        Utils.delete((File)this.tmpDir(), (boolean)false);
        this.tierObjStore().close();
    }

    @Test
    public void testSmallerHighWatermarkChanges() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        BrokerValidator validatorInst = new BrokerValidator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        BrokerDurabilityEventsMaterialize materialize = new BrokerDurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final BrokerValidator validator;

            public BrokerValidator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$1;
            }
        };
        materialize.materializeHighWatermarkChanges(this.tp1().topicPartition(), 2, 30L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        OffsetCount offsetCount = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (offsetCount == null) {
            throw new MatchError(null);
        }
        long lapse = offsetCount.loss();
        Assertions.assertEquals((long)10L, (long)lapse);
        Assertions.assertEquals((long)10L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testLargerHighWatermarkChanges() {
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
        File tmpDir = TestUtils.tempDirectory(null, null);
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp = new TopicIdPartition(topicId, new TopicPartition("t2", 2));
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(tp.topicPartition().topic(), UUID.randomUUID(), tp.topicPartition().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (scala.collection.immutable.Seq<Tuple2<Object, Object>>)localOffsets, tmpDir, this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time(), (scala.collection.immutable.Seq<Tuple2<Object, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (Option<TierObjectStore>)None$.MODULE$);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        BrokerValidator validatorInst = new BrokerValidator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        BrokerDurabilityEventsMaterialize materialize = new BrokerDurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final BrokerValidator validator;

            public BrokerValidator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$2;
            }
        };
        this.ps().latestLocalEpoch_$eq(this.ps().latestEpoch());
        materialize.materializeHighWatermarkChanges(tp.topicPartition(), 2, 100L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        Assertions.assertEquals((Object)new OffsetCount(0L, 0L), (Object)this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(tp.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRejectionOfStaleRecords() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_size;
        void apply_timeMs;
        void apply_nodeId2;
        void apply_logStartOffset2;
        void apply_highWatermark2;
        void apply_epoch2;
        void apply_size2;
        void apply_timeMs2;
        void apply_nodeId3;
        void apply_logStartOffset3;
        void apply_highWatermark3;
        void apply_epoch3;
        void apply_size3;
        void apply_timeMs3;
        void apply_auditState;
        void apply_config;
        void apply_topicId;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark4;
        void apply_startOffset;
        HashMap epochChain = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
        AuditRunState auditRunState = this.as();
        long l = 0L;
        Uuid uuid = this.topicId();
        long l2 = 1024L;
        long l3 = 3600L;
        long l4 = 100L;
        long l5 = 2L;
        long l6 = 0L;
        long l7 = 100L;
        long l8 = 1L;
        int apply_partition = this.tp1().topicPartition().partition();
        uuid = null;
        auditRunState = null;
        PartitionState ps1 = new PartitionState(apply_partition, (long)apply_startOffset, (long)apply_highWatermark4, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, epochChain, (Uuid)apply_topicId, (long)apply_config, (AuditRunState)apply_auditState);
        ps1.latestTimestamp_$eq(1000L);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        BrokerValidator validatorInst = new BrokerValidator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$db().addPartition(this.tp1().topicPartition(), ps1);
        BrokerDurabilityEventsMaterialize materialize = new BrokerDurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final BrokerValidator validator;

            public BrokerValidator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$3;
            }
        };
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l9 = -1L;
        long l10 = -1L;
        boolean bl = true;
        long l11 = -1L;
        long l12 = 500L;
        TopicIdPartition apply_id = this.tp1();
        Object var31_23 = null;
        RetentionChangeEvent event1 = new RetentionChangeEvent(apply_id, (long)apply_timeMs3, (long)apply_size3, 2, (int)apply_epoch3, (long)apply_highWatermark3, (long)apply_logStartOffset3, (int)apply_nodeId3, false);
        ConsumerRecord record1 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 10000L, TimestampType.CREATE_TIME, -1, -1, (Object)event1.serializeKey(), (Object)event1.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertFalse((boolean)materialize.materialize(record1));
        Assertions.assertTrue((ps1.latestTimestamp() == 1000L ? 1 : 0) != 0);
        int n2 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l13 = -1L;
        long l14 = -1L;
        int n3 = 2;
        long l15 = -1L;
        long l16 = 1000L;
        TopicIdPartition apply_id2 = this.tp1();
        Object var42_32 = null;
        RetentionChangeEvent event2 = new RetentionChangeEvent(apply_id2, (long)apply_timeMs2, (long)apply_size2, 2, (int)apply_epoch2, (long)apply_highWatermark2, (long)apply_logStartOffset2, (int)apply_nodeId2, false);
        ConsumerRecord record2 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 200L, TimestampType.CREATE_TIME, -1, -1, (Object)event2.serializeKey(), (Object)event2.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertFalse((boolean)materialize.materialize(record2));
        Assertions.assertTrue((ps1.latestTimestamp() == 1000L ? 1 : 0) != 0);
        int n4 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l17 = -1L;
        long l18 = -1L;
        int n5 = 3;
        long l19 = -1L;
        long l20 = 1000L;
        TopicIdPartition apply_id3 = this.tp1();
        Object var53_41 = null;
        RetentionChangeEvent event3 = new RetentionChangeEvent(apply_id3, (long)apply_timeMs, (long)apply_size, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, false);
        ConsumerRecord record3 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 5000L, TimestampType.CREATE_TIME, -1, -1, (Object)event3.serializeKey(), (Object)event3.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertTrue((boolean)materialize.materialize(record3));
        Assertions.assertTrue((ps1.latestTimestamp() == 5000L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandleStaleDeleteRecords() {
        void apply_nodeId;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_trimmedOffset;
        void apply_auditState;
        void apply_config;
        void apply_topicId;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark2;
        void apply_startOffset;
        HashMap epochChain = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
        AuditRunState auditRunState = this.as();
        long l = 0L;
        Uuid uuid = this.tp1().topicId();
        long l2 = 1024L;
        long l3 = 3600L;
        long l4 = 100L;
        long l5 = 2L;
        long l6 = 0L;
        long l7 = 100L;
        long l8 = 5L;
        int apply_partition = this.tp1().partition();
        uuid = null;
        auditRunState = null;
        PartitionState ps1 = new PartitionState(apply_partition, (long)apply_startOffset, (long)apply_highWatermark2, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, epochChain, (Uuid)apply_topicId, (long)apply_config, (AuditRunState)apply_auditState);
        ps1.latestTimestamp_$eq(1000L);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        BrokerValidator validatorInst = new BrokerValidator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$db().addPartition(this.tp1().topicPartition(), ps1);
        BrokerDurabilityEventsMaterialize materialize = new BrokerDurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final BrokerValidator validator;

            public BrokerValidator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$4;
            }
        };
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        long l9 = 1L;
        long l10 = 60L;
        boolean bl = true;
        long l11 = 15L;
        TopicIdPartition apply_id = this.tp1();
        Object var27_23 = null;
        set = null;
        DeleteRecordsEvent event = new DeleteRecordsEvent(apply_id, (long)apply_trimmedOffset, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (int)apply_nodeId);
        ConsumerRecord record = new ConsumerRecord(this.tp1().topic(), this.tp1().partition(), 0L, 10000L, TimestampType.CREATE_TIME, -1, -1, (Object)event.serializeKey(), (Object)event.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertTrue((boolean)materialize.materialize(record));
        Predef$.MODULE$.assert(ps1.committedStartOffset() == 15L);
        Predef$.MODULE$.assert(ps1.highWatermark() == 100L);
        Predef$.MODULE$.assert(ps1.latestEpoch() == 2);
        Predef$.MODULE$.assert(ps1.startOffset() == 5L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletePartition() {
        void apply_nodeId;
        void apply_epoch;
        TestBrokerAuditManager testAuditManager = new TestBrokerAuditManager();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(testAuditManager, this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        testAuditManager.startAuditManager();
        Assertions.assertEquals((int)testAuditManager.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManager.submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerDurabilityEventsMaterializeTest.$anonfun$testDeletePartition$1(testAuditManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotEquals((Object)testAuditManager.instance().db().fetchPartitionState(this.tp1().topicPartition()), (Object)None$.MODULE$, (String)"Register partition failed");
        BrokerDurabilityEventsMaterialize materialize = new BrokerDurabilityEventsMaterialize(this.replicaManager(), testAuditManager.instance().db(), this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter(), this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time());
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        int n2 = 3;
        TopicIdPartition apply_id = this.tp1();
        Object var10_8 = null;
        DeletePartitionEvent evt = new DeletePartitionEvent(apply_id, 2, (int)apply_epoch, (int)apply_nodeId);
        materialize.materializeDeletePartition(evt);
        Assertions.assertEquals((Object)testAuditManager.instance().db().fetchPartitionState(this.tp1().topicPartition()), (Object)None$.MODULE$, (String)"Deleted partition before fetch");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMissingDeletePartitionRecovery() {
        void apply_nodeId;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_version;
        void apply_nodeId2;
        void apply_isr2;
        void apply_logStartOffset2;
        void apply_highWatermark2;
        void apply_epoch2;
        void apply_version2;
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
        File tmpDir = TestUtils.tempDirectory(null, null);
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp = new TopicIdPartition(topicId, new TopicPartition("t2", 2));
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(tp.topicPartition().topic(), UUID.randomUUID(), tp.topicPartition().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (scala.collection.immutable.Seq<Tuple2<Object, Object>>)localOffsets, tmpDir, this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time(), (scala.collection.immutable.Seq<Tuple2<Object, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (Option<TierObjectStore>)None$.MODULE$);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        BrokerValidator validatorInst = new BrokerValidator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        BrokerDurabilityEventsMaterialize materialize = new BrokerDurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final BrokerValidator validator;

            public BrokerValidator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$5;
            }
        };
        this.ps().latestLocalEpoch_$eq(this.ps().latestEpoch());
        materialize.materializeHighWatermarkChanges(tp.topicPartition(), 2, 100L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        Assertions.assertEquals((Object)new OffsetCount(0L, 0L), (Object)this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(tp.topicPartition()));
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        boolean bl2 = false;
        long apply_firstOffset = 0L;
        set = null;
        EpochChangeEvent epochChangeEvent = new EpochChangeEvent(tp, apply_firstOffset, (int)apply_version2, (int)apply_epoch2, (long)apply_highWatermark2, (long)apply_logStartOffset2, (Set)apply_isr2, (int)apply_nodeId2);
        materialize.checkMissingTopicDeletion((AbstractDurabilityEvent)epochChangeEvent, this.ps());
        materialize.materializeEpochChangeEvent(epochChangeEvent, this.ps(), materialize.materializeEpochChangeEvent$default$3());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        materialize.materializeHighWatermarkChanges(tp.topicPartition(), 0, 100L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Assertions.assertEquals((long)2L, (long)this.mManager().totalLostMessages());
        int n2 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set2 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l3 = 0L;
        long l4 = 80L;
        boolean bl3 = false;
        boolean bl4 = false;
        long apply_firstOffset2 = 0L;
        set2 = null;
        materialize.materializeEpochChangeEvent(new EpochChangeEvent(tp, apply_firstOffset2, (int)apply_version, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (int)apply_nodeId), this.ps(), materialize.materializeEpochChangeEvent$default$3());
        Assertions.assertEquals((long)102L, (long)this.mManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEpochChainValidation() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
        File tmpDir = TestUtils.tempDirectory(null, null);
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp = new TopicIdPartition(topicId, new TopicPartition("t2", 2));
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(tp.topicPartition().topic(), UUID.randomUUID(), tp.topicPartition().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (scala.collection.immutable.Seq<Tuple2<Object, Object>>)localOffsets, tmpDir, this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time(), (scala.collection.immutable.Seq<Tuple2<Object, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (Option<TierObjectStore>)None$.MODULE$);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)log)}))));
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var42_16 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var43_19 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var44_22 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((Map)props, apply_doLog);
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(config, logManager);
        BrokerDurabilityEventsMaterialize materialize = new BrokerDurabilityEventsMaterialize(replicaManager, this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$db(), this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter(), this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time());
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l = this.ps().committedStartOffset();
        long l2 = this.ps().highWatermark();
        int n2 = 3;
        int apply_expandBrokerId = 1;
        IsrExpandEvent evt = new IsrExpandEvent(tp, apply_expandBrokerId, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId);
        LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
            private scala.collection.immutable.Seq<EpochEntry> epochs;
            private final File file;

            private scala.collection.immutable.Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(scala.collection.immutable.Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public File file() {
                return this.file;
            }

            public void write(Collection<EpochEntry> epochs) {
                this.epochs_$eq((scala.collection.immutable.Seq<EpochEntry>)CollectionConverters$.MODULE$.CollectionHasAsScala(epochs).asScala().toSeq());
            }

            public byte[] toByteArray(java.util.List<EpochEntry> epochs) {
                throw new UnsupportedOperationException();
            }

            public java.util.List<EpochEntry> read() {
                return CollectionConverters$.MODULE$.SeqHasAsJava(this.epochs()).asJava();
            }
            {
                this.epochs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
                this.file = TestUtils.tempFile((String)"kafka", (String)".tmp");
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(tp.topicPartition(), checkpoint);
        cache.assign(0, 0L);
        cache.assign(1, 11L);
        cache.assign(2, 21L);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)Option$.MODULE$.apply((Object)cache));
        materialize.materializeISRExpandEvent(evt, this.ps(), materialize.materializeISRExpandEvent$default$3());
        Assertions.assertEquals((long)0L, (long)this.mManager().totalLostMessages());
        cache.assign(2, 15L);
        materialize.materializeISRExpandEvent(evt, this.ps(), materialize.materializeISRExpandEvent$default$3());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTimeBasedRetentionValidation() {
        void apply_nodeId;
        void apply_isr;
        void apply_retentionValue;
        void apply_retentionType;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_nodeId2;
        void apply_isr2;
        void apply_retentionValue2;
        void apply_retentionType2;
        void apply_logStartOffset2;
        void apply_highWatermark2;
        void apply_epoch;
        void apply_nodeId3;
        void apply_logStartOffset3;
        void apply_highWatermark3;
        void apply_epoch2;
        void apply_size;
        void apply_timeMs;
        void apply_nodeId4;
        void apply_isr3;
        void apply_retentionValue3;
        void apply_retentionType3;
        void apply_logStartOffset4;
        void apply_highWatermark4;
        void apply_epoch3;
        void apply_isCompacted;
        void apply_nodeId5;
        void apply_logStartOffset5;
        void apply_highWatermark5;
        void apply_epoch4;
        void apply_size2;
        void apply_timeMs2;
        void apply_nodeId6;
        void apply_isr4;
        void apply_retentionValue4;
        void apply_retentionType4;
        void apply_logStartOffset6;
        void apply_highWatermark6;
        void apply_epoch5;
        void apply_nodeId7;
        void apply_isr5;
        void apply_retentionValue5;
        void apply_retentionType5;
        void apply_logStartOffset7;
        void apply_highWatermark7;
        void apply_epoch6;
        void apply_nodeId8;
        void apply_isr6;
        void apply_retentionValue6;
        void apply_retentionType6;
        void apply_logStartOffset8;
        void apply_highWatermark8;
        void apply_epoch7;
        void apply_nodeId9;
        void apply_isr7;
        void apply_retentionValue7;
        void apply_retentionType7;
        void apply_logStartOffset9;
        void apply_highWatermark9;
        void apply_epoch8;
        scala.collection.immutable.Seq localSegments = (scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(201L, 300L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(301L, 400L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(401L, 500L), (List)Nil$.MODULE$))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long start = x0$1._1$mcJ$sp();
                long end = x0$1._2$mcJ$sp();
                File x$3 = this.tmpDir();
                Time x$4 = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time();
                long x$5 = end * 1000L * 1000L * 1000L;
                int x$6 = 10;
                return LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, x$6, x$4, x$5);
            }
            throw new MatchError(null);
        });
        scala.collection.immutable.Seq tierSegments = (scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 100L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(101L, 150L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(151L, 200L), (List)Nil$.MODULE$))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                long start = x0$2._1$mcJ$sp();
                long end = x0$2._2$mcJ$sp();
                kafka.tier.TopicIdPartition x$7 = this.tpId();
                TierObjectStore x$10 = this.tierObjStore();
                long x$11 = end * 1000L * 1000L * 1000L;
                long x$12 = start * 1000L * 1000L * 1000L;
                TierObjectMetadata.State x$13 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
                TierObjectMetadata.State x$14 = TierObjectMetadata.State.INVALID;
                TierUploadType x$15 = TierUploadType.Archive;
                return LogTestUtils$.MODULE$.createTierLogSegment(x$7, start, end, x$10, x$13, x$11, x$12, x$14, x$15);
            }
            throw new MatchError(null);
        });
        TopicPartition x$16 = this.tp1().topicPartition();
        Some x$19 = new Some((Object)this.tp1().topicId());
        Option<scala.collection.immutable.Seq<TierLogSegment>> x$20 = DurabilityTestUtils$.MODULE$.mockLog$default$4();
        Option<Object> x$21 = DurabilityTestUtils$.MODULE$.mockLog$default$5();
        Option<Object> x$22 = DurabilityTestUtils$.MODULE$.mockLog$default$6();
        boolean x$23 = DurabilityTestUtils$.MODULE$.mockLog$default$7();
        boolean x$24 = DurabilityTestUtils$.MODULE$.mockLog$default$8();
        Option<TierPartitionState> x$25 = DurabilityTestUtils$.MODULE$.mockLog$default$9();
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(x$16, (scala.collection.immutable.Seq<LogSegment>)localSegments, (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, x$20, x$21, x$22, x$23, x$24, x$25, (Option<Uuid>)x$19);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        BrokerValidator validatorInst = new BrokerValidator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        BrokerDurabilityEventsMaterialize materialize = new BrokerDurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final BrokerValidator validator;

            public BrokerValidator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$6;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        long earliestBatchTimestamp = ((TierLogSegment)tierSegments.head()).firstBatchTimestamp();
        UUID objectId = UUID.fromString("7eaf8e12-6055-4e95-984a-6e0398ef2faf");
        Mockito.when((Object)log.tierPartitionState().previousMetadataBeforeOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.of(new SegmentState(1, objectId, 1L, 1L, 1L, earliestMaxTimestamp, earliestBatchTimestamp, 1, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, 1L)));
        this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp + this.ps().retentionMs() - (long)validatorInst.RetentionTimeMarginOfErrorMs() - 1L);
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l = this.ps().retentionMs();
        byte by = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l2 = 5L;
        long l3 = this.ps().highWatermark();
        int n2 = this.ps().latestEpoch();
        TopicIdPartition apply_id = this.tp1();
        Object var52_26 = null;
        set = null;
        StartOffsetChangeEvent evt = new StartOffsetChangeEvent(apply_id, 2, (int)apply_epoch8, (long)apply_highWatermark9, (long)apply_logStartOffset9, (byte)apply_retentionType7, (long)apply_retentionValue7, (Set)apply_isr7, (int)apply_nodeId9);
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        OffsetCount offsetCount = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (offsetCount == null) {
            throw new MatchError(null);
        }
        long lapse = offsetCount.loss();
        Assertions.assertEquals((long)0L, (long)lapse);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)5L);
        int n3 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set2 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l4 = this.ps().retentionMs();
        byte by2 = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l5 = 20L;
        long l6 = this.ps().highWatermark();
        int n4 = this.ps().latestEpoch();
        TopicIdPartition apply_id2 = this.tp1();
        Object var63_37 = null;
        set2 = null;
        evt = new StartOffsetChangeEvent(apply_id2, 2, (int)apply_epoch7, (long)apply_highWatermark8, (long)apply_logStartOffset8, (byte)apply_retentionType6, (long)apply_retentionValue6, (Set)apply_isr6, (int)apply_nodeId8);
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        OffsetCount offsetCount2 = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (offsetCount2 == null) {
            throw new MatchError(null);
        }
        long lapse2 = offsetCount2.loss();
        Assertions.assertEquals((long)15L, (long)lapse2);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)20L);
        int n5 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set3 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l7 = this.ps().retentionMs();
        byte by3 = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l8 = 21L;
        long l9 = this.ps().highWatermark();
        int n6 = this.ps().latestEpoch();
        TopicIdPartition apply_id3 = this.tp1();
        Object var74_47 = null;
        set3 = null;
        evt = new StartOffsetChangeEvent(apply_id3, 2, (int)apply_epoch6, (long)apply_highWatermark7, (long)apply_logStartOffset7, (byte)apply_retentionType5, (long)apply_retentionValue5, (Set)apply_isr5, (int)apply_nodeId7);
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        OffsetCount offsetCount3 = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (offsetCount3 == null) {
            throw new MatchError(null);
        }
        long lapse3 = offsetCount3.loss();
        Assertions.assertEquals((long)16L, (long)lapse3);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)21L);
        int n7 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set4 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l10 = this.ps().retentionMs() / 2L;
        byte by4 = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l11 = 25L;
        long l12 = this.ps().highWatermark();
        int n8 = this.ps().latestEpoch();
        TopicIdPartition apply_id4 = this.tp1();
        Object var85_57 = null;
        set4 = null;
        evt = new StartOffsetChangeEvent(apply_id4, 2, (int)apply_epoch5, (long)apply_highWatermark6, (long)apply_logStartOffset6, (byte)apply_retentionType4, (long)apply_retentionValue4, (Set)apply_isr4, (int)apply_nodeId6);
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)25L);
        OffsetCount offsetCount4 = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (offsetCount4 == null) {
            throw new MatchError(null);
        }
        long lapse4 = offsetCount4.loss();
        Assertions.assertEquals((long)16L, (long)lapse4);
        boolean bl = true;
        int n9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l13 = -1L;
        long l14 = -1L;
        int n10 = this.ps().latestEpoch();
        long l15 = -1L;
        long l16 = 1000L;
        TopicIdPartition apply_id5 = this.tp1();
        Object var96_67 = null;
        RetentionChangeEvent evt2 = new RetentionChangeEvent(apply_id5, (long)apply_timeMs2, (long)apply_size2, 2, (int)apply_epoch4, (long)apply_highWatermark5, (long)apply_logStartOffset5, (int)apply_nodeId5, (boolean)apply_isCompacted);
        materialize.materializeRetentionChangeEvent(evt2, this.ps());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)25L);
        Assertions.assertEquals((long)this.ps().config(), (long)ConfigFlag$.MODULE$.OnceCompacted().id());
        OffsetCount offsetCount5 = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (offsetCount5 == null) {
            throw new MatchError(null);
        }
        long lapse5 = offsetCount5.loss();
        Assertions.assertEquals((long)16L, (long)lapse5);
        int n11 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set5 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l17 = this.ps().retentionMs() / 2L;
        byte by5 = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l18 = 30L;
        long l19 = this.ps().highWatermark();
        int n12 = this.ps().latestEpoch();
        TopicIdPartition apply_id6 = this.tp1();
        Object var108_78 = null;
        set5 = null;
        evt = new StartOffsetChangeEvent(apply_id6, 2, (int)apply_epoch3, (long)apply_highWatermark4, (long)apply_logStartOffset4, (byte)apply_retentionType3, (long)apply_retentionValue3, (Set)apply_isr3, (int)apply_nodeId4);
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)30L);
        OffsetCount offsetCount6 = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (offsetCount6 == null) {
            throw new MatchError(null);
        }
        long lapse6 = offsetCount6.loss();
        Assertions.assertEquals((long)16L, (long)lapse6);
        int n13 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l20 = -1L;
        long l21 = -1L;
        int n14 = this.ps().latestEpoch();
        long l22 = -1L;
        long l23 = this.defaultRetentionMs();
        TopicIdPartition apply_id7 = this.tp1();
        Object var119_87 = null;
        RetentionChangeEvent evt3 = new RetentionChangeEvent(apply_id7, (long)apply_timeMs, (long)apply_size, 2, (int)apply_epoch2, (long)apply_highWatermark3, (long)apply_logStartOffset3, (int)apply_nodeId3, false);
        materialize.materializeRetentionChangeEvent(evt3, this.ps());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)30L);
        OffsetCount offsetCount7 = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (offsetCount7 == null) {
            throw new MatchError(null);
        }
        long lapse7 = offsetCount7.loss();
        Assertions.assertEquals((long)16L, (long)lapse7);
        int n15 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set6 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l24 = this.defaultRetentionMs();
        byte by6 = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l25 = 32L;
        long l26 = this.ps().highWatermark();
        int n16 = this.ps().latestEpoch();
        TopicIdPartition apply_id8 = this.tp1();
        Object var130_98 = null;
        set6 = null;
        evt = new StartOffsetChangeEvent(apply_id8, 2, (int)apply_epoch, (long)apply_highWatermark2, (long)apply_logStartOffset2, (byte)apply_retentionType2, (long)apply_retentionValue2, (Set)apply_isr2, (int)apply_nodeId2);
        materialize.checkMissingTopicDeletion((AbstractDurabilityEvent)evt, this.ps());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)32L);
        OffsetCount offsetCount8 = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (offsetCount8 == null) {
            throw new MatchError(null);
        }
        long lapse8 = offsetCount8.loss();
        Assertions.assertEquals((long)18L, (long)lapse8);
        TopicIdPartition tp2 = new TopicIdPartition(Uuid.randomUuid(), this.tp1().partition(), this.tp1().topic());
        int n17 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set7 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l27 = this.defaultRetentionMs();
        byte by7 = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l28 = 34L;
        long l29 = this.ps().highWatermark();
        int apply_epoch9 = this.ps().latestEpoch();
        set7 = null;
        evt = new StartOffsetChangeEvent(tp2, 2, apply_epoch9, (long)apply_highWatermark, (long)apply_logStartOffset, (byte)apply_retentionType, (long)apply_retentionValue, (Set)apply_isr, (int)apply_nodeId);
        materialize.checkMissingTopicDeletion((AbstractDurabilityEvent)evt, this.ps());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)34L);
        OffsetCount offsetCount9 = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (offsetCount9 != null) {
            long lapse9 = offsetCount9.loss();
            Assertions.assertEquals((long)0L, (long)lapse9);
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTimeBasedRetentionValidationWithNoDeletedSegmentMetadata() {
        void apply_nodeId;
        void apply_isr;
        void apply_retentionValue;
        void apply_retentionType;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        scala.collection.immutable.Seq localSegments = (scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(201L, 300L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(301L, 400L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(401L, 500L), (List)Nil$.MODULE$))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long start = x0$1._1$mcJ$sp();
                long end = x0$1._2$mcJ$sp();
                File x$3 = this.tmpDir();
                Time x$4 = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time();
                long x$5 = end * 1000L * 1000L * 1000L;
                int x$6 = 10;
                return LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, x$6, x$4, x$5);
            }
            throw new MatchError(null);
        });
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        scala.collection.immutable.Seq tierSegments = (scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(151L, 200L), (List)Nil$.MODULE$).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                long start = x0$2._1$mcJ$sp();
                long end = x0$2._2$mcJ$sp();
                TierObjectStore x$10 = this.tierObjStore();
                long x$11 = end * 1000L * 1000L * 1000L;
                TierObjectMetadata.State x$12 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
                long x$13 = 1L;
                TierObjectMetadata.State x$14 = TierObjectMetadata.State.INVALID;
                TierUploadType x$15 = TierUploadType.Archive;
                return LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11, x$13, x$14, x$15);
            }
            throw new MatchError(null);
        });
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1().topicPartition(), (scala.collection.immutable.Seq<LogSegment>)localSegments, (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        BrokerValidator validatorInst = new BrokerValidator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        BrokerDurabilityEventsMaterialize materialize = new BrokerDurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final BrokerValidator validator;

            public BrokerValidator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$7;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp);
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l = this.ps().retentionMs();
        byte by = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l2 = 221L;
        long l3 = this.ps().highWatermark();
        int n2 = this.ps().latestEpoch();
        TopicIdPartition apply_id = this.tp1();
        Object var15_17 = null;
        set = null;
        StartOffsetChangeEvent evt = new StartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (byte)apply_retentionType, (long)apply_retentionValue, (Set)apply_isr, (int)apply_nodeId);
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        OffsetCount offsetCount = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (offsetCount == null) {
            throw new MatchError(null);
        }
        long lapse = offsetCount.loss();
        Assertions.assertEquals((long)0L, (long)lapse);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)221L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTimeBasedRetentionValidationWithUserDeletion() {
        void apply_nodeId;
        void apply_isr;
        void apply_retentionValue;
        void apply_retentionType;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_nodeId2;
        void apply_isr2;
        void apply_logStartOffset2;
        void apply_highWatermark2;
        void apply_epoch2;
        void apply_trimmedOffset;
        scala.collection.immutable.Seq localSegments = (scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(201L, 300L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(301L, 400L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(401L, 500L), (List)Nil$.MODULE$))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long start = x0$1._1$mcJ$sp();
                long end = x0$1._2$mcJ$sp();
                File x$3 = this.tmpDir();
                Time x$4 = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time();
                long x$5 = end * 1000L * 1000L * 1000L;
                int x$6 = 10;
                return LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, x$6, x$4, x$5);
            }
            throw new MatchError(null);
        });
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        scala.collection.immutable.Seq tierSegments = (scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 100L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(101L, 150L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(151L, 200L), (List)Nil$.MODULE$))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                long start = x0$2._1$mcJ$sp();
                long end = x0$2._2$mcJ$sp();
                TierObjectStore x$10 = this.tierObjStore();
                long x$11 = end * 1000L * 1000L * 1000L;
                TierObjectMetadata.State x$12 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
                long x$13 = 1L;
                TierObjectMetadata.State x$14 = TierObjectMetadata.State.INVALID;
                TierUploadType x$15 = TierUploadType.Archive;
                return LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11, x$13, x$14, x$15);
            }
            throw new MatchError(null);
        });
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1().topicPartition(), (scala.collection.immutable.Seq<LogSegment>)localSegments, (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        DurabilityDB db = (DurabilityDB)Mockito.mock(DurabilityDB.class);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        BrokerValidator validatorInst = new BrokerValidator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        BrokerDurabilityEventsMaterialize materialize = new BrokerDurabilityEventsMaterialize(this, replicaManager, db, validatorInst){
            private final BrokerValidator validator;

            public BrokerValidator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$8;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        long earliestBatchTimestamp = ((TierLogSegment)tierSegments.head()).firstBatchTimestamp();
        UUID objectId = UUID.fromString("7eaf8e12-6055-4e95-984a-6e0398ef2faf");
        Mockito.when((Object)log.tierPartitionState().previousMetadataBeforeOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.of(new SegmentState(1, objectId, 1L, 1L, 1L, earliestMaxTimestamp, earliestBatchTimestamp, 1, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, 1L)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.ps().highWatermark()));
        this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp + this.ps().retentionMs() - (long)validatorInst.RetentionTimeMarginOfErrorMs() - 1L);
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l = 0L;
        long l2 = this.ps().highWatermark();
        int n2 = this.ps().latestEpoch();
        long l3 = 5L;
        TopicIdPartition apply_id = this.tp1();
        Object var20_19 = null;
        set = null;
        DeleteRecordsEvent delEvent = new DeleteRecordsEvent(apply_id, (long)apply_trimmedOffset, 2, (int)apply_epoch2, (long)apply_highWatermark2, (long)apply_logStartOffset2, (Set)apply_isr2, (int)apply_nodeId2);
        materialize.materializeDeleteRecordEvent(delEvent, this.ps(), materialize.materializeDeleteRecordEvent$default$3(), materialize.materializeDeleteRecordEvent$default$4());
        int n3 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set2 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        long l4 = this.ps().retentionMs();
        byte by = (byte)RetentionType$.MODULE$.TimeBasedRetention().id();
        long l5 = 5L;
        long l6 = this.ps().highWatermark();
        int n4 = this.ps().latestEpoch();
        TopicIdPartition apply_id2 = this.tp1();
        Object var30_28 = null;
        set2 = null;
        StartOffsetChangeEvent evt = new StartOffsetChangeEvent(apply_id2, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (byte)apply_retentionType, (long)apply_retentionValue, (Set)apply_isr, (int)apply_nodeId);
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        OffsetCount offsetCount = this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (offsetCount != null) {
            long lapse = offsetCount.loss();
            Assertions.assertEquals((long)0L, (long)lapse);
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMissingDeletePartition() {
        Uuid exclusiveRandomUUID1 = Uuid.randomUuid();
        Uuid exclusiveRandomUUID2 = Uuid.randomUuid();
        while (true) {
            Uuid uuid = exclusiveRandomUUID1;
            if (uuid != null ? !uuid.equals(exclusiveRandomUUID2) : exclusiveRandomUUID2 != null) break;
            exclusiveRandomUUID2 = Uuid.randomUuid();
        }
        TopicIdPartition tt1 = new TopicIdPartition(exclusiveRandomUUID1, new TopicPartition("test-topic", 0));
        TopicIdPartition tt2 = new TopicIdPartition(exclusiveRandomUUID2, new TopicPartition("test-topic", 0));
        TestBrokerAuditManager testAuditManager = new TestBrokerAuditManager();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(testAuditManager, this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        testAuditManager.startAuditManager();
        Assertions.assertEquals((int)testAuditManager.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManager.submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(tt1, 1, true));
        testAuditManager.instance().doWork();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerDurabilityEventsMaterializeTest.$anonfun$testMissingDeletePartition$1(testAuditManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotEquals((Object)testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition()), (Object)None$.MODULE$, (String)"Register partition failed");
        Option option = testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition());
        if (option instanceof Some) {
            PartitionState value = (PartitionState)((Some)option).value();
            Assertions.assertEquals((int)1, (int)value.latestLocalEpoch());
            Assertions.assertEquals((Object)exclusiveRandomUUID1, (Object)value.topicId());
        } else {
            Predef$.MODULE$.assert(false);
        }
        testAuditManager.submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(tt2, 2, true));
        testAuditManager.instance().doWork();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerDurabilityEventsMaterializeTest.$anonfun$testMissingDeletePartition$3(testAuditManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotEquals((Object)testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition()), (Object)None$.MODULE$, (String)"Deleted partition before fetch");
        Option option2 = testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition());
        if (option2 instanceof Some) {
            PartitionState value = (PartitionState)((Some)option2).value();
            Assertions.assertEquals((int)2, (int)value.latestLocalEpoch());
            Assertions.assertEquals((Object)exclusiveRandomUUID2, (Object)value.topicId());
            return;
        }
        Predef$.MODULE$.assert(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStaleEventWithoutTopicId() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_size;
        void apply_nodeId2;
        void apply_logStartOffset2;
        void apply_highWatermark2;
        void apply_epoch2;
        void apply_size2;
        void apply_timeMs;
        void apply_auditState;
        void apply_config;
        void apply_topicId;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark3;
        void apply_startOffset;
        TopicIdPartition zeroTp1 = new TopicIdPartition(this.zeroTopicId(), new TopicPartition(this.tp1().topic(), this.tp1().partition()));
        HashMap epochChain = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
        AuditRunState auditRunState = this.as();
        long l = 0L;
        Uuid uuid = this.topicId();
        long l2 = 1024L;
        long l3 = 3600L;
        long l4 = 100L;
        long l5 = 2L;
        long l6 = 0L;
        long l7 = 100L;
        long l8 = 1L;
        int apply_partition = this.tp1().topicPartition().partition();
        uuid = null;
        auditRunState = null;
        PartitionState ps1 = new PartitionState(apply_partition, (long)apply_startOffset, (long)apply_highWatermark3, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, epochChain, (Uuid)apply_topicId, (long)apply_config, (AuditRunState)apply_auditState);
        ps1.latestTimestamp_$eq(1000L);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        BrokerValidator validatorInst = new BrokerValidator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        this.kafka$durability$materialization$BrokerDurabilityEventsMaterializeTest$$db().addPartition(this.tp1().topicPartition(), ps1);
        BrokerDurabilityEventsMaterialize materialize = new BrokerDurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final BrokerValidator validator;

            public BrokerValidator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$9;
            }
        };
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l9 = -1L;
        long l10 = -1L;
        int n2 = 3;
        long l11 = -1L;
        long l12 = 1000L;
        TopicIdPartition apply_id = this.tp1();
        Object var30_24 = null;
        RetentionChangeEvent event1 = new RetentionChangeEvent(apply_id, (long)apply_timeMs, (long)apply_size2, 2, (int)apply_epoch2, (long)apply_highWatermark2, (long)apply_logStartOffset2, (int)apply_nodeId2, false);
        ConsumerRecord record1 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 5000L, TimestampType.CREATE_TIME, -1, -1, (Object)event1.serializeKey(), (Object)event1.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertTrue((boolean)materialize.materialize(record1));
        Assertions.assertTrue((ps1.latestTimestamp() == 5000L ? 1 : 0) != 0);
        int n3 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l13 = -1L;
        long l14 = -1L;
        int n4 = 4;
        long l15 = -1L;
        long apply_timeMs2 = 1000L;
        RetentionChangeEvent event2 = new RetentionChangeEvent(zeroTp1, apply_timeMs2, (long)apply_size, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, false);
        ConsumerRecord record2 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 10000L, TimestampType.CREATE_TIME, -1, -1, (Object)event2.serializeKey(), (Object)event2.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertFalse((boolean)materialize.materialize(record2));
        Assertions.assertTrue((ps1.latestTimestamp() == 5000L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testDeletePartition$1(TestBrokerAuditManager testAuditManager$1) {
        return testAuditManager$1.instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testDeletePartition$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testMissingDeletePartition$1(TestBrokerAuditManager testAuditManager$2) {
        return testAuditManager$2.instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testMissingDeletePartition$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testMissingDeletePartition$3(TestBrokerAuditManager testAuditManager$2) {
        return testAuditManager$2.instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testMissingDeletePartition$4() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public BrokerDurabilityEventsMaterializeTest() {
        void apply_auditState;
        void apply_config;
        void apply_topicId;
        void apply_epochChain;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark;
        this.defaultRetentionMs = 36000000;
        AuditRunState auditRunState = this.as();
        long l = 0L;
        Uuid uuid = this.topicId();
        HashMap<Object, Object> hashMap = this.epochChain();
        long l2 = 1024L;
        long l3 = this.defaultRetentionMs();
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 40L;
        long apply_startOffset = 0L;
        int apply_partition = this.tp1().topicPartition().partition();
        hashMap = null;
        uuid = null;
        auditRunState = null;
        this.ps = new PartitionState(apply_partition, apply_startOffset, (long)apply_highWatermark, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, (HashMap)apply_epochChain, (Uuid)apply_topicId, (long)apply_config, (AuditRunState)apply_auditState);
        this.tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), new UUID(this.ps().topicId().getMostSignificantBits(), this.ps().topicId().getLeastSignificantBits()), this.tp1().topicPartition().partition());
        this.localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
    }
}

