/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.events;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.durability.DurabilityTestUtilConstants$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.DeserializerTrait;
import kafka.durability.events.DurabilityEventType$;
import kafka.durability.events.broker.DeletePartitionEvent;
import kafka.durability.events.broker.DeleteRecordsEvent;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.InjectStateEvent;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.broker.OffsetChangeEvent;
import kafka.durability.events.broker.OffsetChangeEvent$;
import kafka.durability.events.broker.RetentionChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.events.broker.serdes.OffsetChange;
import kafka.durability.events.broker.serdes.RetentionChange;
import kafka.durability.events.serdes.BaseInfo;
import kafka.durability.events.serdes.EventKey;
import kafka.durability.exceptions.DurabilityMetadataDeserializationException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000594Aa\u0006\r\u0001?!)a\u0005\u0001C\u0001O!9!\u0006\u0001b\u0001\n\u0003Y\u0003BB\u001c\u0001A\u0003%A\u0006C\u00049\u0001\t\u0007I\u0011A\u001d\t\ru\u0002\u0001\u0015!\u0003;\u0011\u001dq\u0004A1A\u0005\u0002eBaa\u0010\u0001!\u0002\u0013Q\u0004b\u0002!\u0001\u0005\u0004%\t!\u0011\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002\"\t\u000b\u0019\u0003A\u0011A$\t\u000bY\u0003A\u0011A$\t\u000ba\u0003A\u0011A$\t\u000bi\u0003A\u0011A$\t\u000bq\u0003A\u0011A$\t\u000by\u0003A\u0011A$\t\u000b\u0001\u0004A\u0011A$\t\u000b\t\u0004A\u0011A$\t\u000b\u0011\u0004A\u0011A$\t\u000b\u0019\u0004A\u0011A$\t\u000b!\u0004A\u0011A$\t\u000b)\u0004A\u0011A$\t\u000b1\u0004A\u0011A$\u00037\u0005\u00137\u000f\u001e:bGR$UO]1cS2LG/_#wK:$H+Z:u\u0015\tI\"$\u0001\u0004fm\u0016tGo\u001d\u0006\u00037q\t!\u0002Z;sC\nLG.\u001b;z\u0015\u0005i\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u0019\u0003\u0011!\b/\u001b3\u0016\u00031\u0002\"!L\u001b\u000e\u00039R!a\f\u0019\u0002\r\r|W.\\8o\u0015\ti\u0012G\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<\u0017B\u0001\u001c/\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.A\u0003ua&$\u0007%A\u0003fa>\u001c\u0007.F\u0001;!\t\t3(\u0003\u0002=E\t\u0019\u0011J\u001c;\u0002\r\u0015\u0004xn\u00195!\u0003\u001d1XM]:j_:\f\u0001B^3sg&|g\u000eI\u0001\b_JLw-S:s+\u0005\u0011\u0005cA\u0011Du%\u0011AI\t\u0002\u0006\u0003J\u0014\u0018-_\u0001\t_JLw-S:sA\u0005\ttJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;TKJL\u0017\r\\5{CRLwN\u001c#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8UKN$H#\u0001%\u0011\u0005\u0005J\u0015B\u0001&#\u0005\u0011)f.\u001b;)\u0005)a\u0005CA'U\u001b\u0005q%BA(Q\u0003\r\t\u0007/\u001b\u0006\u0003#J\u000bqA[;qSR,'O\u0003\u0002Tg\u0005)!.\u001e8ji&\u0011QK\u0014\u0002\u0005)\u0016\u001cH/\u0001\u001dPM\u001a\u001cX\r^\"iC:<W-\u0012<f]R<\u0016\u000e\u001e5J'J\u001bVM]5bY&T\u0018\r^5p]\u0012+7/\u001a:jC2L'0\u0019;j_:$Vm\u001d;)\u0005-a\u0015aK#q_\u000eD7\t[1oO\u0016\u001cVM]5bY&T\u0018\r^5p]\u0012+7/\u001a:jC2L'0\u0019;j_:$Vm\u001d;)\u00051a\u0015!\f#fY\u0016$XMU3d_J$7oU3sS\u0006d\u0017N_1uS>tG)Z:fe&\fG.\u001b>bi&|g\u000eV3ti\"\u0012Q\u0002T\u00010%\u0016$XM\u001c;j_:\u001c\u0005.\u00198hKN+'/[1mSj\fG/[8o\t\u0016\u001cXM]5bY&T\u0018\r^5p]R+7\u000f\u001e\u0015\u0003\u001d1\u000b!g\u00147e%\u0016$XM\u001c;j_:\u001c\u0005.\u00198hKN+'/[1mSj\fG/[8o\t\u0016\u001cXM]5bY&T\u0018\r^5p]R+7\u000f\u001e\u0015\u0003\u001f1\u000b\u0011&S*S\u000bb\u0004\u0018M\u001c3TKJL\u0017\r\\5{CRLwN\u001c#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8UKN$\bF\u0001\tM\u0003E\u001aF/\u0019:u\u001f\u001a47/\u001a;DQ\u0006tw-Z*fe&\fG.\u001b>bi&|g\u000eR3tKJL\u0017\r\\5{CRLwN\u001c+fgRD#!\u0005'\u0002_\u0011+G.\u001a;f!\u0006\u0014H/\u001b;j_:\u001cVM]5bY&T\u0018\r^5p]\u0012+7/\u001a:jC2L'0\u0019;j_:$Vm\u001d;)\u0005Ia\u0015aK%oU\u0016\u001cGo\u0015;bi\u0016\u001cVM]5bY&T\u0018\r^5p]\u0012+7/\u001a:jC2L'0\u0019;j_:$Vm\u001d;)\u0005Ma\u0015AH#yG\u0016\u0004H/[8o\u0013:$Um]3sS\u0006d\u0017N_1uS>tG+Z:uQ\t!B*A\u000ePY\u0012,e/\u001a8u\t\u0016\u001cXM]5bY&T\u0018\r^5p]R+7\u000f\u001e\u0015\u0003+1\u000b1DT3x\u000bZ,g\u000e\u001e#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8UKN$\bF\u0001\fM\u0001")
public class AbstractDurabilityEventTest {
    private final TopicIdPartition tpid = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("test", 0));
    private final int epoch;
    private final int version;
    private final int[] origIsr = new int[]{1, 3, 5};

    public TopicIdPartition tpid() {
        return this.tpid;
    }

    public int epoch() {
        return this.epoch;
    }

    public int version() {
        return this.version;
    }

    public int[] origIsr() {
        return this.origIsr;
    }

    @Test
    public void OffsetChangeEventSerializationDeserializationTest() {
        OffsetChangeEvent obj = OffsetChangeEvent$.MODULE$.apply(this.tpid(), this.epoch(), 100L, 0L, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID());
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var5_4 = null;
        AbstractDurabilityEvent deserialize = DeserializerTrait.deserialize$((DeserializerTrait)deserialize_this, (byte[])keyBB, (byte[])bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize OffsetChangeEvent");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void OffsetChangeEventWithISRSerializationDeserializationTest() {
        void apply_nodeId;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        TopicIdPartition apply_id = this.tpid();
        Object var6_6 = null;
        set = null;
        OffsetChangeEvent obj = new OffsetChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (int)apply_nodeId);
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var5_10 = null;
        AbstractDurabilityEvent deserialize = DeserializerTrait.deserialize$((DeserializerTrait)deserialize_this, (byte[])keyBB, (byte[])bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize OffsetChangeEvent");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void EpochChangeSerializationDeserializationTest() {
        void apply_nodeId;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_firstOffset;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        long l3 = 50L;
        TopicIdPartition apply_id = this.tpid();
        Object var6_7 = null;
        set = null;
        EpochChangeEvent obj = new EpochChangeEvent(apply_id, (long)apply_firstOffset, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (int)apply_nodeId);
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var5_11 = null;
        AbstractDurabilityEvent deserialize = DeserializerTrait.deserialize$((DeserializerTrait)deserialize_this, (byte[])keyBB, (byte[])bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize EpochChangeEvent");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void DeleteRecordsSerializationDeserializationTest() {
        void apply_nodeId;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_trimmedOffset;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        long l3 = 100L;
        TopicIdPartition apply_id = this.tpid();
        Object var6_7 = null;
        set = null;
        DeleteRecordsEvent obj = new DeleteRecordsEvent(apply_id, (long)apply_trimmedOffset, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (int)apply_nodeId);
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var5_11 = null;
        AbstractDurabilityEvent deserialize = DeserializerTrait.deserialize$((DeserializerTrait)deserialize_this, (byte[])keyBB, (byte[])bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize DeleteRecordsEvent");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void RetentionChangeSerializationDeserializationTest() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_size;
        void apply_timeMs;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        long l3 = 1000L;
        long l4 = 50L;
        TopicIdPartition apply_id = this.tpid();
        Object var6_7 = null;
        RetentionChangeEvent obj = new RetentionChangeEvent(apply_id, (long)apply_timeMs, (long)apply_size, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, false);
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var5_11 = null;
        AbstractDurabilityEvent deserialize = DeserializerTrait.deserialize$((DeserializerTrait)deserialize_this, (byte[])keyBB, (byte[])bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize RetentionChangeEvent");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void OldRetentionChangeSerializationDeserializationTest() {
        void deserialize_value;
        void var27_16;
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_version;
        void apply_size;
        void apply_timeMs;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        int n3 = this.version();
        long l3 = 1000L;
        long l4 = 50L;
        TopicIdPartition apply_id = this.tpid();
        Object var10_8 = null;
        RetentionChangeEvent obj = new RetentionChangeEvent(apply_id, (long)apply_timeMs, (long)apply_size, (int)apply_version, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId, false);
        byte[] keyBB = obj.serializeKey();
        FlatBufferBuilder builder = new FlatBufferBuilder(Deserializer$.MODULE$.KEY_INITIAL_LENGTH()).forceDefaults(true);
        builder.startTable(5);
        long addTimeMs_timeMs = obj.timeMs();
        builder.addLong(0, addTimeMs_timeMs, 0L);
        long addSize_size = obj.size();
        builder.addLong(1, addSize_size, 0L);
        int addNodeId_nodeId = obj.nodeId();
        builder.addInt(3, addNodeId_nodeId, -1);
        int infoOffset = BaseInfo.createBaseInfo((FlatBufferBuilder)builder, (int)this.version(), (int)this.epoch(), (long)obj.highWatermark(), (long)obj.logStartOffset());
        builder.addStruct(2, infoOffset, 0);
        int endRetentionChange_o = builder.endTable();
        builder.finish((int)var27_16);
        ByteBuffer payload = RetentionChange.getRootAsRetentionChange((ByteBuffer)builder.dataBuffer()).getByteBuffer().duplicate();
        ByteBuffer buf = ByteBuffer.allocate(payload.remaining() + Deserializer$.MODULE$.EVENT_TYPE_LENGTH());
        buf.put((byte)DurabilityEventType$.MODULE$.RetentionChangeType().id());
        buf.put(payload);
        byte[] byArray = buf.array();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var8_20 = null;
        byArray = null;
        AbstractDurabilityEvent deserialize = DeserializerTrait.deserialize$((DeserializerTrait)deserialize_this, (byte[])keyBB, (byte[])deserialize_value);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize RetentionChangeEvent");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void ISRExpandSerializationDeserializationTest() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_expandBrokerId;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l = 0L;
        long l2 = 100L;
        int n2 = this.epoch();
        int n3 = 5;
        TopicIdPartition apply_id = this.tpid();
        Object var6_6 = null;
        IsrExpandEvent obj = new IsrExpandEvent(apply_id, (int)apply_expandBrokerId, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId);
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var5_10 = null;
        AbstractDurabilityEvent deserialize = DeserializerTrait.deserialize$((DeserializerTrait)deserialize_this, (byte[])keyBB, (byte[])bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize ISRExpandEvent");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void StartOffsetChangeSerializationDeserializationTest() {
        void apply_nodeId;
        void apply_isr;
        void apply_retentionValue;
        void apply_retentionType;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        long l = 0L;
        byte by = (byte)RetentionType$.MODULE$.SizeBasedRetention().id();
        long l2 = 21L;
        long l3 = 100L;
        int n2 = this.epoch();
        TopicIdPartition apply_id = this.tpid();
        Object var6_8 = null;
        set = null;
        StartOffsetChangeEvent obj = new StartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (byte)apply_retentionType, (long)apply_retentionValue, (Set)apply_isr, (int)apply_nodeId);
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var5_12 = null;
        AbstractDurabilityEvent deserialize = DeserializerTrait.deserialize$((DeserializerTrait)deserialize_this, (byte[])keyBB, (byte[])bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize StartOffsetChangeEvent");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void DeletePartitionSerializationDeserializationTest() {
        void apply_nodeId;
        void apply_epoch;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        int n2 = this.epoch();
        TopicIdPartition apply_id = this.tpid();
        Object var6_3 = null;
        DeletePartitionEvent obj = new DeletePartitionEvent(apply_id, 2, (int)apply_epoch, (int)apply_nodeId);
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var5_7 = null;
        AbstractDurabilityEvent deserialize = DeserializerTrait.deserialize$((DeserializerTrait)deserialize_this, (byte[])keyBB, (byte[])bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize DeletePartitionEvent");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void InjectStateSerializationDeserializationTest() {
        void apply_nodeId;
        void apply_removePartition;
        void apply_config;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        boolean bl = true;
        long l = 1L;
        long l2 = 10L;
        long l3 = 50L;
        int n2 = this.epoch();
        TopicIdPartition apply_id = this.tpid();
        Object var6_7 = null;
        InjectStateEvent obj = new InjectStateEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (long)apply_config, (boolean)apply_removePartition, (int)apply_nodeId);
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var5_11 = null;
        AbstractDurabilityEvent deserialize = DeserializerTrait.deserialize$((DeserializerTrait)deserialize_this, (byte[])keyBB, (byte[])bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize InjectStateEvent");
    }

    @Test
    public void ExceptionInDeserializationTest() {
        byte[] garbage = new byte[]{1, 2, 3, 4};
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> Deserializer$.MODULE$.deserialize(garbage, garbage), ClassTag$.MODULE$.apply(DurabilityMetadataDeserializationException.class), new Position("AbstractDurabilityEventTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void OldEventDeserializationTest() {
        void var6_8;
        void var11_6;
        TopicIdPartition tpid = new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("test", 0));
        OffsetChangeEvent obj = OffsetChangeEvent$.MODULE$.apply(tpid, this.epoch(), 100L, 0L, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID());
        FlatBufferBuilder builder = new FlatBufferBuilder(Deserializer$.MODULE$.KEY_INITIAL_LENGTH()).forceDefaults(true);
        int topicNameOffset = builder.createString((CharSequence)tpid.topicPartition().topic());
        builder.startTable(3);
        builder.addOffset(0, topicNameOffset, 0);
        int addPartition_partition = tpid.topicPartition().partition();
        builder.addInt(1, addPartition_partition, 0);
        int endEventKey_o = builder.endTable();
        builder.finish((int)var11_6);
        ByteBuffer buffer = builder.dataBuffer();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        byte[] bb = obj.serializeValue();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var9_10 = null;
        AbstractDurabilityEvent deserialize = DeserializerTrait.deserialize$((DeserializerTrait)deserialize_this, (byte[])var6_8, (byte[])bb);
        Assertions.assertEquals((Object)obj, (Object)deserialize, (String)"Failed to deserialize OffsetChangeEvent");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void NewEventDeserializationTest() {
        void deserializeEventType_value;
        void apply_nodeId;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = Predef$.MODULE$.wrapIntArray(this.origIsr()).toSet();
        long l = 20L;
        long l2 = 100L;
        int n2 = this.epoch();
        TopicIdPartition apply_id = this.tpid();
        Object var11_6 = null;
        set = null;
        OffsetChangeEvent obj = new OffsetChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (int)apply_nodeId);
        byte[] keyBB = obj.serializeKey();
        byte[] bb = obj.serializeValue();
        ByteBuffer keyBuffer = ByteBuffer.wrap(keyBB);
        ByteBuffer valBuffer = ByteBuffer.wrap(bb);
        EventKey key = EventKey.getRootAsEventKey((ByteBuffer)keyBuffer);
        Assertions.assertEquals((Object)this.tpid().topicPartition().topic(), (Object)key.topicName());
        Assertions.assertEquals((int)this.tpid().topicPartition().partition(), (int)key.partition());
        byte by = valBuffer.get();
        Deserializer$ deserializeEventType_this = Deserializer$.MODULE$;
        Object var9_14 = null;
        Enumeration.Value eventType = DeserializerTrait.deserializeEventType$((DeserializerTrait)deserializeEventType_this, (byte)deserializeEventType_value);
        Assertions.assertEquals((Object)DurabilityEventType$.MODULE$.OffsetChangeType(), (Object)eventType);
        OffsetChange data = OffsetChange.getRootAsOffsetChange((ByteBuffer)valBuffer, (OffsetChange)new OffsetChange());
        Assertions.assertEquals((int)this.epoch(), (int)data.info().epoch());
        Assertions.assertEquals((long)100L, (long)data.info().highWatermark());
        Assertions.assertEquals((long)20L, (long)data.info().logStartOffset());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), data.isrLength() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ii -> Assertions.assertEquals((int)this.origIsr()[ii], (int)data.isr(ii)));
    }

    public AbstractDurabilityEventTest() {
        this.epoch = 0;
        this.version = 1;
    }
}

