/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import kafka.cluster.Partition;
import kafka.durability.DurabilityTestUtilConstants$;
import kafka.durability.DurabilityTestUtils$;
import kafka.durability.TestBrokerAuditManager;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.manager.AbstractAuditManager;
import kafka.durability.audit.manager.BrokerAuditManager;
import kafka.durability.audit.request.AuditManagerRequest;
import kafka.durability.audit.request.DeletePartitionRequest;
import kafka.durability.audit.request.EpochChangeRequest;
import kafka.durability.audit.request.HealthCheckRequest;
import kafka.durability.audit.request.HighWatermarkUpdateRequest;
import kafka.durability.audit.request.HighWatermarkUpdateRequest$;
import kafka.durability.audit.request.ISRExpandRequest;
import kafka.durability.audit.request.RegisterPartitionRequest;
import kafka.durability.audit.request.StartOffsetChangeRequest;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.DeserializerTrait;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.HostedPartition;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.MockTime;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001\u0002\u001a4\u0001iBQ!\u0011\u0001\u0005\u0002\tCq!\u0012\u0001C\u0002\u0013\u0005a\t\u0003\u0004S\u0001\u0001\u0006Ia\u0012\u0005\b'\u0002\u0011\r\u0011\"\u0001G\u0011\u0019!\u0006\u0001)A\u0005\u000f\"9Q\u000b\u0001b\u0001\n\u00031\u0006B\u0002/\u0001A\u0003%q\u000bC\u0005^\u0001\u0001\u0007\t\u0019!C\u0001=\"IQ\r\u0001a\u0001\u0002\u0004%\tA\u001a\u0005\nY\u0002\u0001\r\u0011!Q!\n}C\u0011\"\u001c\u0001A\u0002\u0003\u0007I\u0011\u00018\t\u0013U\u0004\u0001\u0019!a\u0001\n\u00031\b\"\u0003=\u0001\u0001\u0004\u0005\t\u0015)\u0003p\u0011\u001dI\b\u00011A\u0005\u0002iD\u0011\"!\u0003\u0001\u0001\u0004%\t!a\u0003\t\u000f\u0005=\u0001\u0001)Q\u0005w\"Y\u0011\u0011\u0003\u0001A\u0002\u0003\u0007I\u0011AA\n\u0011-\t)\u0003\u0001a\u0001\u0002\u0004%\t!a\n\t\u0017\u0005-\u0002\u00011A\u0001B\u0003&\u0011Q\u0003\u0005\f\u0003[\u0001\u0001\u0019!a\u0001\n\u0003\ty\u0003C\u0006\u0002:\u0001\u0001\r\u00111A\u0005\u0002\u0005m\u0002bCA \u0001\u0001\u0007\t\u0011)Q\u0005\u0003cA\u0011\"!\u0011\u0001\u0005\u0004%\t!a\u0011\t\u0011\u0005%\u0004\u0001)A\u0005\u0003\u000bB1\"a\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002n!Y\u0011\u0011\u0010\u0001A\u0002\u0003\u0007I\u0011AA>\u0011-\ty\b\u0001a\u0001\u0002\u0003\u0006K!a\u001c\t\u0017\u0005\u0005\u0005\u00011AA\u0002\u0013\u0005\u00111\u0011\u0005\f\u0003\u0017\u0003\u0001\u0019!a\u0001\n\u0003\ti\tC\u0006\u0002\u0012\u0002\u0001\r\u0011!Q!\n\u0005\u0015\u0005bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003[\u0003A\u0011AAK\u0011\u001d\t9\f\u0001C\u0001\u0003+Cq!!1\u0001\t\u0003\t)\nC\u0004\u0002F\u0002!\t!!&\t\u000f\u0005%\u0007\u0001\"\u0001\u0002\u0016\"9\u0011Q\u001a\u0001\u0005\u0002\u0005U\u0005bBAi\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003+\u0004A\u0011AAK\u0011\u001d\tI\u000e\u0001C\u0001\u0003+Cq!!8\u0001\t\u0003\t)\nC\u0004\u0002b\u0002!\t!!&\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002\u0016\"9\u0011\u0011\u001e\u0001\u0005\u0002\u0005U\u0005bBAw\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003c\u0004A\u0011AAK\u0011\u001d\t)\u0010\u0001C\u0001\u0003+Cq!!?\u0001\t\u0003\t)\nC\u0004\u0002~\u0002!\t!!&\u0003-\t\u0013xn[3s\u0003V$\u0017\u000e^'b]\u0006<WM\u001d+fgRT!\u0001N\u001b\u0002\u000b\u0005,H-\u001b;\u000b\u0005Y:\u0014A\u00033ve\u0006\u0014\u0017\u000e\\5us*\t\u0001(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Y\u0004C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0007B\u0011A\tA\u0007\u0002g\u0005\u0019A\u000f]\u0019\u0016\u0003\u001d\u0003\"\u0001\u0013)\u000e\u0003%S!AS&\u0002\r\r|W.\\8o\u0015\tADJ\u0003\u0002N\u001d\u00061\u0011\r]1dQ\u0016T\u0011aT\u0001\u0004_J<\u0017BA)J\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0001\u0003uaF\u0002\u0013a\u0001;qe\u0005!A\u000f\u001d\u001a!\u0003\u0011!\b/\u00133\u0016\u0003]\u0003\"\u0001W.\u000e\u0003eS!AW\u001c\u0002\tQLWM]\u0005\u0003#f\u000bQ\u0001\u001e9JI\u0002\nA\u0001^5nKV\tq\f\u0005\u0002aG6\t\u0011M\u0003\u0002c\u0013\u0006)Q\u000f^5mg&\u0011A-\u0019\u0002\u0005)&lW-\u0001\u0005uS6,w\fJ3r)\t9'\u000e\u0005\u0002=Q&\u0011\u0011.\u0010\u0002\u0005+:LG\u000fC\u0004l\u0013\u0005\u0005\t\u0019A0\u0002\u0007a$\u0013'A\u0003uS6,\u0007%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0003=\u0004\"\u0001]:\u000e\u0003ET!A]\u001c\u0002\rM,'O^3s\u0013\t!\u0018O\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0003O^Dqa\u001b\u0007\u0002\u0002\u0003\u0007q.A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003=!\u0018.\u001a:PE*\u001cFo\u001c:f\u001fB$X#A>\u0011\u0007qbh0\u0003\u0002~{\t1q\n\u001d;j_:\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004e\u000bQa\u001d;pe\u0016LA!a\u0002\u0002\u0002\tyA+[3s\u001f\nTWm\u0019;Ti>\u0014X-A\nuS\u0016\u0014xJ\u00196Ti>\u0014Xm\u00149u?\u0012*\u0017\u000fF\u0002h\u0003\u001bAqa[\b\u0002\u0002\u0003\u000710\u0001\tuS\u0016\u0014xJ\u00196Ti>\u0014Xm\u00149uA\u00051A/\u001c9ESJ,\"!!\u0006\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005\u0011\u0011n\u001c\u0006\u0003\u0003?\tAA[1wC&!\u00111EA\r\u0005\u00111\u0015\u000e\\3\u0002\u0015Ql\u0007\u000fR5s?\u0012*\u0017\u000fF\u0002h\u0003SA\u0001b\u001b\n\u0002\u0002\u0003\u0007\u0011QC\u0001\bi6\u0004H)\u001b:!\u0003A!Xm\u001d;Bk\u0012LG/T1oC\u001e,'/\u0006\u0002\u00022A!\u00111GA\u001b\u001b\u0005)\u0014bAA\u001ck\t1B+Z:u\u0005J|7.\u001a:Bk\u0012LG/T1oC\u001e,'/\u0001\u000buKN$\u0018)\u001e3ji6\u000bg.Y4fe~#S-\u001d\u000b\u0004O\u0006u\u0002\u0002C6\u0016\u0003\u0003\u0005\r!!\r\u0002#Q,7\u000f^!vI&$X*\u00198bO\u0016\u0014\b%\u0001\u0007m_\u000e\fGn\u00144gg\u0016$8/\u0006\u0002\u0002FA1\u0011qIA,\u0003;rA!!\u0013\u0002T9!\u00111JA)\u001b\t\tiEC\u0002\u0002Pe\na\u0001\u0010:p_Rt\u0014\"\u0001 \n\u0007\u0005US(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00131\f\u0002\u0004'\u0016\f(bAA+{A9A(a\u0018\u0002d\u0005\r\u0014bAA1{\t1A+\u001e9mKJ\u00022\u0001PA3\u0013\r\t9'\u0010\u0002\u0005\u0019>tw-A\u0007m_\u000e\fGn\u00144gg\u0016$8\u000fI\u0001\u0004Y><WCAA8!\u0011\t\t(!\u001e\u000e\u0005\u0005M$bAA6o%!\u0011qOA:\u0005-\t%m\u001d;sC\u000e$Hj\\4\u0002\u000f1|wm\u0018\u0013fcR\u0019q-! \t\u0011-T\u0012\u0011!a\u0001\u0003_\nA\u0001\\8hA\u0005QAn\\4NC:\fw-\u001a:\u0016\u0005\u0005\u0015\u0005\u0003BA9\u0003\u000fKA!!#\u0002t\tQAj\\4NC:\fw-\u001a:\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR\u0019q-a$\t\u0011-l\u0012\u0011!a\u0001\u0003\u000b\u000b1\u0002\\8h\u001b\u0006t\u0017mZ3sA\u0005)1/\u001a;VaR\tq\rK\u0002 \u00033\u0003B!a'\u0002*6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+A\u0002ba&TA!a)\u0002&\u00069!.\u001e9ji\u0016\u0014(bAAT\u001d\u0006)!.\u001e8ji&!\u00111VAO\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0001%!-\u0011\t\u0005m\u00151W\u0005\u0005\u0003k\u000biJA\u0005BMR,'/R1dQ\u0006\u0011#)Y:jG\u0006+H-\u001b;NC:\fw-\u001a:J]N$\u0018M\u001c;jCRLwN\u001c+fgRD3!IA^!\u0011\tY*!0\n\t\u0005}\u0016Q\u0014\u0002\u0005)\u0016\u001cH/A\u000eCCNL7-Q;eSRl\u0015M\\1hKJ,e/\u001a8ugR+7\u000f\u001e\u0015\u0004E\u0005m\u0016A\u0007+fgR|%\u000fZ3s\t\u0016d\u0017N^3ss>3W*Z:tC\u001e,\u0007fA\u0012\u0002<\u0006iC+Z:u\tV\u0014\u0018MY5mSRL\u0018)\u001e3jiJ+7\u000f^8sK6K7o]5oOJ+w-[:ue\u0006$\u0018n\u001c8)\u0007\u0011\nY,\u0001\u0012CCNL7-\u00128ee\u0015sG-Q;eSRl\u0015M\\1hKJ,e/\u001a8ugR+7\u000f\u001e\u0015\u0004K\u0005m\u0016aF\"mkN$XM\u001d'j].$\u0015n]1cY\u0016$G+Z:uQ\r1\u00131X\u0001\u0013\u0013N\u0013V\t\u001f9b]\u0012,e/\u001a8u)\u0016\u001cH\u000fK\u0002(\u0003w\u000bA\u0003S3bYRD7\t[3dW\u00163XM\u001c;UKN$\bf\u0001\u0015\u0002<\u0006\trJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;)\u0007%\nY,A\fuKN$\u0018\t\u001c7po\u0016$WI^3oiN4\u0015\u000e\u001c;fe\"\u001a!&a/\u0002IQ,7\u000f^!vI&$(j\u001c2F[&$8/T3ue&\u001c7oV5uQ:{WI^3oiND3aKA^\u0003!\"Xm\u001d;TG\",G-\u001e7f\u0003V$\u0017\u000e\u001e&pEJ+7\u000f]3diNLe.\u001b;jC2$U\r\\1zQ\ra\u00131X\u0001&i\u0016\u001cHoU2iK\u0012,H.Z!vI&$(j\u001c2SKN\u0004Xm\u0019;t\t\u0006LxJZ-fCJD3!LA^\u0003%\"Xm\u001d;TG\",G-\u001e7f\u0003V$\u0017\u000e\u001e&pEJ+7\u000f]3diNd\u0015m\u001d;ECf|e-W3be\"\u001aa&a/\u0002\u000fR,7\u000f^*dQ\u0016$W\u000f\\3Bk\u0012LGOS8c%\u0016\u001c\b/Z2ug2\u000b7\u000f\u001e#bs>3\u0017,Z1s/&$\bNS8c\tV\u0014\u0018\r^5p]\u001e\u0013X-\u0019;feRC\u0017M\\!ECfD3aLA^\u00039\tU\u000fZ5u#V,W/\u001a+fgRD3\u0001MA^\u00031\"Xm\u001d;E\u0005N#\u0018\r^3Qe\u0016\u001cXM\u001d<fI\u00063G/\u001a:Bk\u0012LG/T1oC\u001e,'OU3ti\u0006\u0014H\u000fK\u00022\u0003w\u0003")
public class BrokerAuditManagerTest {
    private final org.apache.kafka.common.TopicIdPartition tp1 = new org.apache.kafka.common.TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t1", 1));
    private final org.apache.kafka.common.TopicIdPartition tp2 = new org.apache.kafka.common.TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t2", 2));
    private final TopicIdPartition tpId = new TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
    private Time time;
    private ReplicaManager replicaManager;
    private Option<TierObjectStore> tierObjStoreOpt = None$.MODULE$;
    private File tmpDir;
    private TestBrokerAuditManager testAuditManager;
    private final Seq<Tuple2<Object, Object>> localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
    private AbstractLog log;
    private LogManager logManager;

    public org.apache.kafka.common.TopicIdPartition tp1() {
        return this.tp1;
    }

    public org.apache.kafka.common.TopicIdPartition tp2() {
        return this.tp2;
    }

    public TopicIdPartition tpId() {
        return this.tpId;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public Option<TierObjectStore> tierObjStoreOpt() {
        return this.tierObjStoreOpt;
    }

    public void tierObjStoreOpt_$eq(Option<TierObjectStore> x$1) {
        this.tierObjStoreOpt = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public TestBrokerAuditManager testAuditManager() {
        return this.testAuditManager;
    }

    public void testAuditManager_$eq(TestBrokerAuditManager x$1) {
        this.testAuditManager = x$1;
    }

    public Seq<Tuple2<Object, Object>> localOffsets() {
        return this.localOffsets;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq((Time)new MockTime(0L, 0L));
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.tierObjStoreOpt_$eq((Option<TierObjectStore>)new Some((Object)TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig())));
        this.testAuditManager_$eq(new TestBrokerAuditManager());
        this.log_$eq(DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(this.tpId(), this.localOffsets(), this.tmpDir(), this.time(), (Seq<Tuple2<Object, Object>>)((Seq)package$.MODULE$.Seq().empty()), (Option<TierObjectStore>)None$.MODULE$));
        this.logManager_$eq(DurabilityTestUtils$.MODULE$.mockLogManager((Map<TopicPartition, AbstractLog>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)this.log())})))));
        this.replicaManager_$eq(DurabilityTestUtils$.MODULE$.mockReplicaManager(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        this.testAuditManager().cleanUp();
        this.tierObjStoreOpt().foreach((Function1 & Serializable)x$7 -> {
            x$7.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir(), (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void BasicAuditManagerInstantiationTest() {
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, false));
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)1);
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().startAuditManager();
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"AuditManager didn't start within timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$3(this)) {
            void waitUntilTrue_pause2;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"AuditManager didn't flush within timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause2));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 0, false));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$BasicAuditManagerInstantiationTest$5(this)) {
            void waitUntilTrue_pause3;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause3));
        }
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void BasicAuditManagerEventsTest() {
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 1, true));
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().startAuditManager();
        Assertions.assertEquals((int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$BasicAuditManagerEventsTest$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)1, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 101L, 101L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$BasicAuditManagerEventsTest$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new DeletePartitionRequest(this.tp1(), 0));
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        Assertions.assertNotEquals((Object)this.testAuditManager().instance().db().fetchPartitionState(this.tp1().topicPartition()), (Object)None$.MODULE$, (String)"Deleted partition reported before fetch");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void TestOrderDeliveryOfMessage() {
        Assertions.assertEquals((int)this.testAuditManager().pendingRegistration().size(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().startAuditManager();
        Assertions.assertEquals((int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$TestOrderDeliveryOfMessage$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)1, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 1, true));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 101L, 101L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        long l = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$TestOrderDeliveryOfMessage$3(this)) {
            void waitUntilTrue_pause2;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause2));
        }
    }

    @Test
    public void TestDurabilityAuditRestoreMissingRegistration() {
        TestBrokerAuditManager testAuditManagerMock = new TestBrokerAuditManager(null){

            public int fetchEpochIfLeaderLog(TopicPartition topicPartition) {
                return 1;
            }
        };
        Assertions.assertEquals((int)testAuditManagerMock.pendingRegistration().size(), (int)0);
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(testAuditManagerMock, this.time(), (ReplicaManager)Mockito.mock(ReplicaManager.class), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        testAuditManagerMock.startAuditManager();
        Assertions.assertEquals((int)testAuditManagerMock.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManagerMock.submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)testAuditManagerMock.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManagerMock.submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 100L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)testAuditManagerMock.instance().db().getTopicPartitionsForAudit().length(), (int)0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void BasicEnd2EndAuditManagerEventsTest() {
        void apply_nodeId;
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_firstOffset;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().startAuditManager();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (int)0);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 110L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        Assertions.assertEquals((int)1, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 111L, 111L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), -1, 111L, 10L, RetentionType$.MODULE$.Other(), -1L, -1L));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$7(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$BasicEnd2EndAuditManagerEventsTest$9(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
        Assertions.assertNotNull(events);
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        events.forEach(record -> eventList.append((Object)DeserializerTrait.deserialize$((DeserializerTrait)Deserializer$.MODULE$, (byte[])((byte[])record.key()), (byte[])((byte[])record.value()))));
        Assertions.assertEquals((int)1, (int)eventList.length());
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        long l6 = 5L;
        long l7 = 111L;
        boolean bl = true;
        long l8 = 111L;
        org.apache.kafka.common.TopicIdPartition apply_id = this.tp1();
        Object var37_28 = null;
        set = null;
        Assertions.assertEquals((Object)eventList.head(), (Object)new EpochChangeEvent(apply_id, (long)apply_firstOffset, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr, (int)apply_nodeId));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void ClusterLinkDisabledTest() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_expandBrokerId;
        Partition partitionMock = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partitionMock.isActiveLinkDestinationLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.replicaManager().getPartition(this.tp1().topicPartition())).thenReturn((Object)new HostedPartition.Online(partitionMock));
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 0, true));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$ClusterLinkDisabledTest$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new ISRExpandRequest(this.tp1(), 0, 3));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new ISRExpandRequest(this.tp2(), 0, 3));
        Assertions.assertEquals((int)2, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$ClusterLinkDisabledTest$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
        Assertions.assertNotNull(events);
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        events.forEach(record -> eventList.append((Object)DeserializerTrait.deserialize$((DeserializerTrait)Deserializer$.MODULE$, (byte[])((byte[])record.key()), (byte[])((byte[])record.value()))));
        Assertions.assertEquals((int)1, (int)eventList.length());
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l3 = -1L;
        long l4 = -1L;
        boolean bl = false;
        int n2 = 3;
        org.apache.kafka.common.TopicIdPartition apply_id = this.tp2();
        Object var24_23 = null;
        Assertions.assertEquals((Object)eventList.head(), (Object)new IsrExpandEvent(apply_id, (int)apply_expandBrokerId, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)((BrokerAuditManager)this.testAuditManager().instance()).isMirrorPartition(this.tp1().topicPartition())));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)((BrokerAuditManager)this.testAuditManager().instance()).isMirrorPartition(this.tp2().topicPartition())));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void ISRExpandEventTest() {
        void apply_nodeId;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_expandBrokerId;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().startAuditManager();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$ISRExpandEventTest$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new ISRExpandRequest(this.tp1(), 0, 3));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$ISRExpandEventTest$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$ISRExpandEventTest$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$ISRExpandEventTest$7(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
        Assertions.assertNotNull(events);
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        events.forEach(record -> eventList.append((Object)DeserializerTrait.deserialize$((DeserializerTrait)Deserializer$.MODULE$, (byte[])((byte[])record.key()), (byte[])((byte[])record.value()))));
        Assertions.assertEquals((int)1, (int)eventList.length());
        int n = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        long l5 = -1L;
        long l6 = -1L;
        boolean bl = false;
        int n2 = 3;
        org.apache.kafka.common.TopicIdPartition apply_id = this.tp1();
        Object var35_28 = null;
        Assertions.assertEquals((Object)eventList.head(), (Object)new IsrExpandEvent(apply_id, (int)apply_expandBrokerId, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (int)apply_nodeId));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void HealthCheckEventTest() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), (ReplicaManager)Mockito.mock(ReplicaManager.class), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        org.apache.kafka.common.TopicIdPartition tp = new org.apache.kafka.common.TopicIdPartition(Uuid.randomUuid(), new TopicPartition("durability-health-check", 0));
        this.time().sleep(5L);
        long produceTime = this.time().milliseconds();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HealthCheckRequest(tp, -1, 0, produceTime));
        this.time().sleep(20L);
        long produceTimeDelayed = this.time().milliseconds();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HealthCheckRequest(tp, -1, 1, produceTimeDelayed));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HealthCheckRequest(tp, -1, 2, produceTimeDelayed));
        Assertions.assertEquals((int)3, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$HealthCheckEventTest$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ArrayBuffer eventList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (!this.testAuditManager().queue().isEmpty()) {
            ConsumerRecords<byte[], byte[]> events = this.testAuditManager().queue().poll();
            Assertions.assertNotNull(events);
            events.forEach(record -> eventList.append((Object)DeserializerTrait.deserialize$((DeserializerTrait)Deserializer$.MODULE$, (byte[])((byte[])record.key()), (byte[])((byte[])record.value()))));
        }
        Assertions.assertEquals((int)3, (int)eventList.length());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void OffsetChangeEvent() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 1, true));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length(), (int)1);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 10L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (int)1);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), 1, 10L, 7L, RetentionType$.MODULE$.SizeBasedRetention(), -1L, -1L));
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$5 = qual$2.doWorkActual$default$1();
        boolean x$6 = qual$2.doWorkActual$default$2();
        qual$2.doWorkActual(x$5, x$6, false);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$OffsetChangeEvent$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"event not received at consumer");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 8L, 4L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (int)1, (String)"batched event count is not 1");
        BrokerAuditManager qual$3 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$8 = qual$3.doWorkActual$default$1();
        boolean x$9 = qual$3.doWorkActual$default$3();
        qual$3.doWorkActual(x$8, true, x$9);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().queue().size(), (String)"event received at consumer should not have changed from 1");
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 8L, 4L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (int)1, (String)"batched event count is not 1");
        BrokerAuditManager qual$4 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$11 = qual$4.doWorkActual$default$1();
        boolean x$12 = qual$4.doWorkActual$default$3();
        qual$4.doWorkActual(x$11, true, x$12);
        Assertions.assertEquals((int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (int)0, (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$OffsetChangeEvent$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"event not received at consumer");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new StartOffsetChangeRequest(this.tp1(), 0, 8L, 4L, RetentionType$.MODULE$.SizeBasedRetention(), -1L, -1L));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 1, 11L, 4L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        BrokerAuditManager qual$5 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$13 = qual$5.doWorkActual$default$1();
        boolean x$14 = qual$5.doWorkActual$default$2();
        boolean x$15 = qual$5.doWorkActual$default$3();
        qual$5.doWorkActual(x$13, x$14, x$15);
        Assertions.assertEquals((int)1, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (String)"batched event count is not 1");
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        Assertions.assertEquals((int)this.testAuditManager().queue().size(), (int)2, (String)"event not received at consumer");
        BrokerAuditManager qual$6 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$17 = qual$6.doWorkActual$default$1();
        boolean x$18 = qual$6.doWorkActual$default$3();
        qual$6.doWorkActual(x$17, true, x$18);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$OffsetChangeEvent$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"event not received at consumer");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp2(), 1, false));
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp2(), 1, 10L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        BrokerAuditManager qual$7 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$20 = qual$7.doWorkActual$default$1();
        boolean x$21 = qual$7.doWorkActual$default$3();
        qual$7.doWorkActual(x$20, true, x$21);
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).highWatermarkUpdateRequests().size(), (String)"batched event count is not 0");
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size(), (String)"event count in immediate produce queue is not 0");
        Assertions.assertEquals((int)3, (int)this.testAuditManager().queue().size(), (String)"event not received at consumer");
    }

    @Test
    public void testAllowedEventsFilter() {
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        ReplicaManager x$3 = this.replicaManager();
        Set x$4 = Predef$.MODULE$.Set().empty();
        None$ x$5 = None$.MODULE$;
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        None$ x$8 = None$.MODULE$;
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$3, (Option<TierObjectStore>)x$5, x$6, x$7, (Set<Enumeration.Value>)x$4, (Option<TopicPartition>)x$8, x$9, (Option<File>)x$10);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$11 = qual$1.doWorkActual$default$1();
        boolean x$12 = qual$1.doWorkActual$default$2();
        boolean x$13 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$11, x$12, x$13);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        Assertions.assertEquals((Object)this.tp1().topicPartition(), (Object)((Tuple2)this.testAuditManager().instance().db().getTopicPartitionsForAudit().head())._1());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 100L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new HighWatermarkUpdateRequest(this.tp1(), 0, 110L, 5L, -1L, HighWatermarkUpdateRequest$.MODULE$.apply$default$6()));
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), 1, 111L, 110L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        Assertions.assertEquals((int)0, (int)((BrokerAuditManager)this.testAuditManager().instance()).auditRequestsQueue().size());
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$14 = qual$2.doWorkActual$default$1();
        boolean x$15 = qual$2.doWorkActual$default$2();
        boolean x$16 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$14, x$15, x$16);
        Assertions.assertEquals((int)0, (int)this.testAuditManager().queue().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuditJobEmitsMetricsWithNoEvents() {
        TopicIdPartition tpId1 = new TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        .colon.colon tieredOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(11L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(25L, 38L), (List)Nil$.MODULE$));
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(39L, 152L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(160L, 168L), (List)Nil$.MODULE$));
        AbstractLog tp1Log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId1, (Seq<Tuple2<Object, Object>>)localOffsets, this.tmpDir(), this.time(), (Seq<Tuple2<Object, Object>>)tieredOffsets, this.tierObjStoreOpt());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((Map<TopicPartition, AbstractLog>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)tp1Log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Option<TierObjectStore> x$4 = this.tierObjStoreOpt();
        Set x$5 = Predef$.MODULE$.Set().empty();
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        None$ x$8 = None$.MODULE$;
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, replicaManager, x$4, x$6, x$7, (Set<Enumeration.Value>)x$5, (Option<TopicPartition>)x$8, x$9, (Option<File>)x$10);
        Assertions.assertNotNull((Object)this.testAuditManager().instance());
        Metrics metrics = this.testAuditManager().instance().config().metrics();
        Assertions.assertEquals((int)22, (int)metrics.metrics().size());
        Assertions.assertEquals((long)0L, (long)this.testAuditManager().instance().metricsManager().totalLostMessages());
        MetricName name = DurabilityTestUtils$.MODULE$.metricName("total_lost_messages", metrics);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)metrics.metric(name).metricValue());
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$11 = qual$1.doWorkActual$default$1();
        boolean x$12 = qual$1.doWorkActual$default$2();
        boolean x$13 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$11, x$12, x$13);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().getTopicPartitionsForAudit().length());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$15 = qual$2.doWorkActual$default$2();
        boolean x$16 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(true, x$15, x$16);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$testAuditJobEmitsMetricsWithNoEvents$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"AuditJob didn't complete within timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)23, (int)metrics.metrics().size());
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)11L), (Object)metrics.metric(DurabilityTestUtils$.MODULE$.metricName("total_lost_messages", metrics)).metricValue());
    }

    @Test
    public void testScheduleAuditJobRespectsInitialDelay() {
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1().topicPartition());
        ReplicaManager x$4 = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        Set<Enumeration.Value> x$8 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, (Option<TierObjectStore>)x$5, x$6, x$7, x$8, (Option<TopicPartition>)x$3, x$9, (Option<File>)x$10);
        AbstractAuditManager manager = this.testAuditManager().instance();
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    @Test
    public void testScheduleAuditJobRespectsDayOfYear() {
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1().topicPartition());
        ReplicaManager x$4 = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        Set<Enumeration.Value> x$8 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, (Option<TierObjectStore>)x$5, x$6, x$7, x$8, (Option<TopicPartition>)x$3, x$9, (Option<File>)x$10);
        AbstractAuditManager manager = this.testAuditManager().instance();
        Instant now = Instant.parse("2020-01-30T00:00:00.00Z");
        this.time().sleep(now.toEpochMilli());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        manager.currentJobId_$eq(30);
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(Duration.ofDays(1L).toMillis());
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    @Test
    public void testScheduleAuditJobRespectsLastDayOfYear() {
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1().topicPartition());
        ReplicaManager x$4 = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        Set<Enumeration.Value> x$8 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, (Option<TierObjectStore>)x$5, x$6, x$7, x$8, (Option<TopicPartition>)x$3, x$9, (Option<File>)x$10);
        AbstractAuditManager manager = this.testAuditManager().instance();
        Instant now = Instant.parse("2020-12-31T00:00:00.00Z");
        this.time().sleep(now.toEpochMilli());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        manager.currentJobId_$eq(366);
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(Duration.ofDays(1L).toMillis());
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    @Test
    public void testScheduleAuditJobRespectsLastDayOfYearWithJobDurationGreaterThanADay() {
        TestBrokerAuditManager x$1 = this.testAuditManager();
        Time x$2 = this.time();
        Some x$3 = new Some((Object)this.tp1().topicPartition());
        ReplicaManager x$4 = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = true;
        Set<Enumeration.Value> x$7 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        Set<Enumeration.Value> x$8 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7();
        int x$9 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        None$ x$10 = None$.MODULE$;
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$1, x$2, x$4, (Option<TierObjectStore>)x$5, x$6, x$7, x$8, (Option<TopicPartition>)x$3, x$9, (Option<File>)x$10);
        AbstractAuditManager manager = this.testAuditManager().instance();
        Instant now = Instant.parse("2021-12-31T00:00:00.00Z");
        this.time().sleep(now.toEpochMilli());
        this.time().sleep(this.testAuditManager().instance().config().initialAuditJobDelayMs() + 1L);
        manager.currentJobId_$eq(365);
        Assertions.assertFalse((boolean)manager.shouldScheduleNewAuditJob());
        this.time().sleep(Duration.ofDays(2L).toMillis());
        Assertions.assertTrue((boolean)manager.shouldScheduleNewAuditJob());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void AuditQueueTest() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().instance().topicManager().start();
        this.testAuditManager().startAuditManager();
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$AuditQueueTest$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int maxEvents = DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() + 1;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), maxEvents).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)epoch -> this.testAuditManager().submitAuditRequest((AuditManagerRequest)new EpochChangeRequest(this.tp1(), epoch, 101L, 101L, 5L, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))));
        BrokerAuditManager qual$2 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$4 = qual$2.doWorkActual$default$1();
        boolean x$5 = qual$2.doWorkActual$default$2();
        boolean x$6 = qual$2.doWorkActual$default$3();
        qual$2.doWorkActual(x$4, x$5, x$6);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$AuditQueueTest$4(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)BrokerAuditManagerTest.$anonfun$AuditQueueTest$5(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 30000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!BrokerAuditManagerTest.$anonfun$AuditQueueTest$6(this, maxEvents)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)BrokerAuditManagerTest.$anonfun$AuditQueueTest$7(this, maxEvents));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testDBStatePreservedAfterAuditManagerRestart() {
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(this.testAuditManager(), this.time(), this.replicaManager(), (Option<TierObjectStore>)None$.MODULE$, true, DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), (Option<TopicPartition>)None$.MODULE$, DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID(), (Option<File>)None$.MODULE$);
        this.testAuditManager().submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        BrokerAuditManager qual$1 = (BrokerAuditManager)this.testAuditManager().instance();
        boolean x$1 = qual$1.doWorkActual$default$1();
        boolean x$2 = qual$1.doWorkActual$default$2();
        boolean x$3 = qual$1.doWorkActual$default$3();
        qual$1.doWorkActual(x$1, x$2, x$3);
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().fetchTopicStates().size());
        File dbPath = this.testAuditManager().instance().config().dbPath();
        TestBrokerAuditManager qual$2 = this.testAuditManager();
        boolean x$4 = qual$2.stopAuditManager$default$1();
        qual$2.stopAuditManager(x$4);
        Assertions.assertNull((Object)this.testAuditManager().instance(), (String)"Test audit manager did not shut down fully after call to stopAuditManager");
        TestBrokerAuditManager x$5 = this.testAuditManager();
        Time x$6 = this.time();
        ReplicaManager x$7 = this.replicaManager();
        Set x$8 = Predef$.MODULE$.Set().empty();
        Some x$9 = new Some((Object)dbPath);
        None$ x$10 = None$.MODULE$;
        boolean x$11 = true;
        Set<Enumeration.Value> x$12 = DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6();
        None$ x$13 = None$.MODULE$;
        int x$14 = DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(x$5, x$6, x$7, (Option<TierObjectStore>)x$10, x$11, x$12, (Set<Enumeration.Value>)x$8, (Option<TopicPartition>)x$13, x$14, (Option<File>)x$9);
        Assertions.assertNotNull((Object)this.testAuditManager().instance(), (String)"Test audit manager did not start up properly after call to initializeTestAuditManager");
        Assertions.assertEquals((int)1, (int)this.testAuditManager().instance().db().fetchTopicStates().size(), (String)"Database state was not properly preserved after shutdown / reinitialization of AuditManager");
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerInstantiationTest$1(BrokerAuditManagerTest $this) {
        return $this.testAuditManager().pendingRegistration().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerInstantiationTest$2() {
        return "AuditManager didn't start within timeout";
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerInstantiationTest$3(BrokerAuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerInstantiationTest$4() {
        return "AuditManager didn't flush within timeout";
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerInstantiationTest$5(BrokerAuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 2;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerInstantiationTest$6() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerEventsTest$1(BrokerAuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerEventsTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicAuditManagerEventsTest$3(BrokerAuditManagerTest $this) {
        return ((BrokerAuditManager)$this.testAuditManager().instance()).highWatermarkUpdateRequests().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$BasicAuditManagerEventsTest$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$TestOrderDeliveryOfMessage$1(BrokerAuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$TestOrderDeliveryOfMessage$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$TestOrderDeliveryOfMessage$3(BrokerAuditManagerTest $this) {
        return ((BrokerAuditManager)$this.testAuditManager().instance()).highWatermarkUpdateRequests().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$TestOrderDeliveryOfMessage$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$1(BrokerAuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$3(BrokerAuditManagerTest $this) {
        return ((BrokerAuditManager)$this.testAuditManager().instance()).auditRequestsQueue().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$5(BrokerAuditManagerTest $this) {
        return 0 == ((BrokerAuditManager)$this.testAuditManager().instance()).highWatermarkUpdateRequests().size();
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$6() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$7(BrokerAuditManagerTest $this) {
        return 0 == ((BrokerAuditManager)$this.testAuditManager().instance()).auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$8() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$BasicEnd2EndAuditManagerEventsTest$9(BrokerAuditManagerTest $this) {
        return $this.testAuditManager().queue().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$BasicEnd2EndAuditManagerEventsTest$10() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ClusterLinkDisabledTest$1(BrokerAuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 2;
    }

    public static final /* synthetic */ String $anonfun$ClusterLinkDisabledTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ClusterLinkDisabledTest$3(BrokerAuditManagerTest $this) {
        return 1 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$ClusterLinkDisabledTest$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ISRExpandEventTest$1(BrokerAuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$ISRExpandEventTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ISRExpandEventTest$3(BrokerAuditManagerTest $this) {
        return 1 == ((BrokerAuditManager)$this.testAuditManager().instance()).auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$ISRExpandEventTest$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ISRExpandEventTest$5(BrokerAuditManagerTest $this) {
        return 0 == ((BrokerAuditManager)$this.testAuditManager().instance()).auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$ISRExpandEventTest$6() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$ISRExpandEventTest$7(BrokerAuditManagerTest $this) {
        return 1 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$ISRExpandEventTest$8() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$HealthCheckEventTest$1(BrokerAuditManagerTest $this) {
        return 3 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$HealthCheckEventTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$OffsetChangeEvent$1(BrokerAuditManagerTest $this) {
        return 1 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$OffsetChangeEvent$2() {
        return "event not received at consumer";
    }

    public static final /* synthetic */ boolean $anonfun$OffsetChangeEvent$3(BrokerAuditManagerTest $this) {
        return 2 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$OffsetChangeEvent$4() {
        return "event not received at consumer";
    }

    public static final /* synthetic */ boolean $anonfun$OffsetChangeEvent$5(BrokerAuditManagerTest $this) {
        return 3 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$OffsetChangeEvent$6() {
        return "event not received at consumer";
    }

    public static final /* synthetic */ boolean $anonfun$testAuditJobEmitsMetricsWithNoEvents$1(BrokerAuditManagerTest $this) {
        return 0L == $this.testAuditManager().instance().auditJobCountdownLatch().getCount();
    }

    public static final /* synthetic */ String $anonfun$testAuditJobEmitsMetricsWithNoEvents$2() {
        return "AuditJob didn't complete within timeout";
    }

    public static final /* synthetic */ boolean $anonfun$AuditQueueTest$1(BrokerAuditManagerTest $this) {
        return $this.testAuditManager().instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$AuditQueueTest$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$AuditQueueTest$4(BrokerAuditManagerTest $this) {
        return 0 == ((BrokerAuditManager)$this.testAuditManager().instance()).auditRequestsQueue().size();
    }

    public static final /* synthetic */ String $anonfun$AuditQueueTest$5(BrokerAuditManagerTest $this) {
        return new StringBuilder(56).append("auditRequestsQueue size expect to be: 0, but actual is: ").append(((BrokerAuditManager)$this.testAuditManager().instance()).auditRequestsQueue().size()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$AuditQueueTest$6(BrokerAuditManagerTest $this, int maxEvents$1) {
        return maxEvents$1 == $this.testAuditManager().queue().size();
    }

    public static final /* synthetic */ String $anonfun$AuditQueueTest$7(BrokerAuditManagerTest $this, int maxEvents$1) {
        return new StringBuilder(59).append("testAuditManager queue size expect to be: ").append(maxEvents$1).append(", but actual is: ").append($this.testAuditManager().queue().size()).toString();
    }
}

