/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityTestUtilConstants$;
import kafka.durability.DurabilityTestUtils$;
import kafka.durability.audit.AuditJobSummary;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.OffsetCount;
import kafka.durability.audit.job.AuditJobResult;
import kafka.durability.audit.job.BrokerAuditJob;
import kafka.durability.audit.job.BrokerAuditJob$;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.events.DurabilityEventType$;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.durability.utils.CommitAndSwapEvent;
import kafka.durability.utils.DurabilityOffsetMapUtils$;
import kafka.durability.utils.DurabilityTierTopicReader;
import kafka.durability.utils.OffsetInfo;
import kafka.durability.utils.TierTopicEvents;
import kafka.durability.utils.UploadCompleteEvent;
import kafka.durability.utils.UploadInitiateEvent;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.TierLogSegment;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierMetadataValidator;
import kafka.tier.tools.TierMetadataValidatorTest;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.SortedMap;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005e\u0001\u00020`\u0001\u0019DQ!\u001c\u0001\u0005\u00029D\u0011\"\u001d\u0001A\u0002\u0003\u0007I\u0011\u0001:\t\u0013m\u0004\u0001\u0019!a\u0001\n\u0003a\bBCA\u0003\u0001\u0001\u0007\t\u0011)Q\u0005g\"Y\u0011q\u0001\u0001A\u0002\u0003\u0007I\u0011AA\u0005\u0011-\t9\u0002\u0001a\u0001\u0002\u0004%\t!!\u0007\t\u0017\u0005u\u0001\u00011A\u0001B\u0003&\u00111\u0002\u0005\f\u0003?\u0001\u0001\u0019!a\u0001\n\u0003\t\t\u0003C\u0006\u00020\u0001\u0001\r\u00111A\u0005\u0002\u0005E\u0002bCA\u001b\u0001\u0001\u0007\t\u0011)Q\u0005\u0003GA1\"a\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002:!Y\u0011q\t\u0001A\u0002\u0003\u0007I\u0011AA%\u0011-\ti\u0005\u0001a\u0001\u0002\u0003\u0006K!a\u000f\t\u0013\u0005=\u0003\u00011A\u0005\u0002\u0005E\u0003\"CAA\u0001\u0001\u0007I\u0011AAB\u0011!\t9\t\u0001Q!\n\u0005M\u0003\"CAE\u0001\u0001\u0007I\u0011AAF\u0011%\tY\n\u0001a\u0001\n\u0003\ti\n\u0003\u0005\u0002\"\u0002\u0001\u000b\u0015BAG\u0011%\t\u0019\u000b\u0001a\u0001\n\u0003\t)\u000bC\u0005\u00028\u0002\u0001\r\u0011\"\u0001\u0002:\"A\u0011Q\u0018\u0001!B\u0013\t9\u000bC\u0005\u0002@\u0002\u0011\r\u0011\"\u0001\u0002B\"A\u0011\u0011\u001a\u0001!\u0002\u0013\t\u0019\rC\u0006\u0002L\u0002\u0001\r\u00111A\u0005\u0002\u00055\u0007bCAm\u0001\u0001\u0007\t\u0019!C\u0001\u00037D1\"a8\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002P\"Y\u0011\u0011\u001d\u0001A\u0002\u0003\u0007I\u0011AAr\u0011-\tY\u000f\u0001a\u0001\u0002\u0004%\t!!<\t\u0017\u0005E\b\u00011A\u0001B\u0003&\u0011Q\u001d\u0005\f\u0003g\u0004\u0001\u0019!a\u0001\n\u0003\t)\u0010C\u0006\u0002~\u0002\u0001\r\u00111A\u0005\u0002\u0005}\bb\u0003B\u0002\u0001\u0001\u0007\t\u0011)Q\u0005\u0003oD1B!\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003\b!Y!\u0011\u0003\u0001A\u0002\u0003\u0007I\u0011\u0001B\n\u0011-\u00119\u0002\u0001a\u0001\u0002\u0003\u0006KA!\u0003\t\u0013\te\u0001A1A\u0005\u0002\tm\u0001\u0002\u0003B\"\u0001\u0001\u0006IA!\b\t\u0013\t\u0015\u0003A1A\u0005\u0002\t\u001d\u0003\u0002\u0003B-\u0001\u0001\u0006IA!\u0013\t\u0017\tm\u0003\u00011AA\u0002\u0013\u0005!Q\f\u0005\f\u0005?\u0002\u0001\u0019!a\u0001\n\u0003\u0011\t\u0007C\u0006\u0003f\u0001\u0001\r\u0011!Q!\n\u0005-\u0004\"\u0003B4\u0001\u0001\u0007I\u0011\u0001B5\u0011%\u0011Y\u0007\u0001a\u0001\n\u0003\u0011i\u0007\u0003\u0005\u0003r\u0001\u0001\u000b\u0015BAK\u0011%\u0011\u0019\b\u0001a\u0001\n\u0003\u0011)\bC\u0005\u0003\u0002\u0002\u0001\r\u0011\"\u0001\u0003\u0004\"A!q\u0011\u0001!B\u0013\u00119\bC\u0005\u0003\n\u0002\u0001\r\u0011\"\u0001\u0003\f\"I!1\u0013\u0001A\u0002\u0013\u0005!Q\u0013\u0005\t\u00053\u0003\u0001\u0015)\u0003\u0003\u000e\"9!1\u0014\u0001\u0005\u0002\tu\u0005b\u0002B[\u0001\u0011\u0005!Q\u0014\u0005\b\u0005\u007f\u0003A\u0011\u0001BO\u0011\u001d\u0011I\r\u0001C\u0001\u0005;CqA!4\u0001\t\u0003\u0011i\nC\u0004\u0003R\u0002!\tA!(\t\u000f\tU\u0007\u0001\"\u0003\u0003X\"9!\u0011 \u0001\u0005\u0002\tu\u0005b\u0002B\u007f\u0001\u0011\u0005!Q\u0014\u0005\b\u0007\u0003\u0001A\u0011\u0001BO\u0011\u001d\u0019)\u0001\u0001C\u0001\u0005;Cqa!\u0003\u0001\t\u0003\u0011i\nC\u0004\u0004\u000e\u0001!\tA!(\t\u000f\rE\u0001\u0001\"\u0001\u0003\u001e\"91Q\u0003\u0001\u0005\u0002\tu\u0005bBB\r\u0001\u0011\u0005!Q\u0014\u0005\b\u0007;\u0001A\u0011\u0001BO\u0011\u001d\u0019\t\u0003\u0001C\u0001\u0005;Cqa!\n\u0001\t\u0003\u0011i\nC\u0004\u0004*\u0001!\tA!(\t\u000f\r5\u0002\u0001\"\u0001\u0003\u001e\"91\u0011\u0007\u0001\u0005\u0002\tu\u0005bBB\u001b\u0001\u0011\u0005!Q\u0014\u0005\b\u0007s\u0001A\u0011\u0001BO\u0011\u001d\u0019i\u0004\u0001C\u0001\u0005;Cqa!\u0011\u0001\t\u0003\u0011i\nC\u0004\u0004F\u0001!\tA!(\t\u000f\r%\u0003\u0001\"\u0001\u0003\u001e\"91Q\n\u0001\u0005\u0002\tu\u0005bBB)\u0001\u0011\u0005!Q\u0014\u0005\b\u0007+\u0002A\u0011\u0001BO\u0011\u001d\u0019I\u0006\u0001C\u0001\u0005;Cqa!\u0018\u0001\t\u0003\u0011i\nC\u0004\u0004b\u0001!\tA!(\t\u000f\r\u0015\u0004\u0001\"\u0001\u0003\u001e\"91\u0011\u000e\u0001\u0005\u0002\tu\u0005bBB7\u0001\u0011\u0005!Q\u0014\u0005\b\u0007c\u0002A\u0011\u0001BO\u0011\u001d\u0019)\b\u0001C\u0001\u0005;Cqa!\u001f\u0001\t\u0003\u0011i\nC\u0004\u0004~\u0001!\tA!(\u0003%\t\u0013xn[3s\u0003V$\u0017\u000e\u001e&pER+7\u000f\u001e\u0006\u0003A\u0006\fQ!Y;eSRT!AY2\u0002\u0015\u0011,(/\u00192jY&$\u0018PC\u0001e\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A4\u0011\u0005!\\W\"A5\u000b\u0003)\fQa]2bY\u0006L!\u0001\\5\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u000e\u0005\u0002q\u00015\tq,\u0001\u0004m_\u001e$\u0015N]\u000b\u0002gB\u0011A/_\u0007\u0002k*\u0011ao^\u0001\u0003S>T\u0011\u0001_\u0001\u0005U\u00064\u0018-\u0003\u0002{k\n!a)\u001b7f\u0003)awn\u001a#je~#S-\u001d\u000b\u0004{\u0006\u0005\u0001C\u00015\u007f\u0013\ty\u0018N\u0001\u0003V]&$\b\u0002CA\u0002\u0007\u0005\u0005\t\u0019A:\u0002\u0007a$\u0013'A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u00151|w-T1oC\u001e,'/\u0006\u0002\u0002\fA!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012\r\f1\u0001\\8h\u0013\u0011\t)\"a\u0004\u0003\u00151{w-T1oC\u001e,'/\u0001\bm_\u001el\u0015M\\1hKJ|F%Z9\u0015\u0007u\fY\u0002C\u0005\u0002\u0004\u0019\t\t\u00111\u0001\u0002\f\u0005YAn\\4NC:\fw-\u001a:!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%2-A\u0003vi&d7/\u0003\u0003\u0002.\u0005\u001d\"\u0001C'pG.$\u0016.\\3\u0002\u0011QLW.Z0%KF$2!`A\u001a\u0011%\t\u0019!CA\u0001\u0002\u0004\t\u0019#A\u0003uS6,\u0007%\u0001\u0005bk\u0012LGOS8c+\t\tY\u0004\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\teX\u0001\u0004U>\u0014\u0017\u0002BA#\u0003\u007f\u0011aB\u0011:pW\u0016\u0014\u0018)\u001e3ji*{'-\u0001\u0007bk\u0012LGOS8c?\u0012*\u0017\u000fF\u0002~\u0003\u0017B\u0011\"a\u0001\r\u0003\u0003\u0005\r!a\u000f\u0002\u0013\u0005,H-\u001b;K_\n\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005M\u0003CBA+\u0003K\nYG\u0004\u0003\u0002X\u0005\u0005d\u0002BA-\u0003?j!!a\u0017\u000b\u0007\u0005uS-\u0001\u0004=e>|GOP\u0005\u0002U&\u0019\u00111M5\u0002\u000fA\f7m[1hK&!\u0011qMA5\u0005\r\u0019V-\u001d\u0006\u0004\u0003GJ\u0007\u0003BA7\u0003{j!!a\u001c\u000b\t\u0005E\u00141O\u0001\u0007G>lWn\u001c8\u000b\u0007\u0011\f)H\u0003\u0003\u0002x\u0005e\u0014AB1qC\u000eDWM\u0003\u0002\u0002|\u0005\u0019qN]4\n\t\u0005}\u0014q\u000e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003M!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cx\fJ3r)\ri\u0018Q\u0011\u0005\n\u0003\u0007y\u0011\u0011!a\u0001\u0003'\n\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u001dA\f'\u000f^5uS>tG+\u001e9mKV\u0011\u0011Q\u0012\t\u0007\u0003+\n)'a$\u0011\u000f!\f\t*a\u001b\u0002\u0016&\u0019\u00111S5\u0003\rQ+\b\u000f\\33!\rA\u0017qS\u0005\u0004\u00033K'\u0001\u0002'p]\u001e\f!\u0003]1si&$\u0018n\u001c8UkBdWm\u0018\u0013fcR\u0019Q0a(\t\u0013\u0005\r!#!AA\u0002\u00055\u0015a\u00049beRLG/[8o)V\u0004H.\u001a\u0011\u0002\u0011=\u0014'n\u0015;pe\u0016,\"!a*\u0011\t\u0005%\u00161W\u0007\u0003\u0003WSA!!,\u00020\u0006)1\u000f^8sK*\u0019\u0011\u0011W2\u0002\tQLWM]\u0005\u0005\u0003k\u000bYKA\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u00031y'M[*u_J,w\fJ3r)\ri\u00181\u0018\u0005\n\u0003\u0007)\u0012\u0011!a\u0001\u0003O\u000b\u0011b\u001c2k'R|'/\u001a\u0011\u0002\u000b)|'-\u00133\u0016\u0005\u0005\r\u0007c\u00015\u0002F&\u0019\u0011qY5\u0003\u0007%sG/\u0001\u0004k_\nLE\rI\u0001\b[\u0016$(/[2t+\t\ty\r\u0005\u0003\u0002R\u0006UWBAAj\u0015\u0011\tY-a\u001c\n\t\u0005]\u00171\u001b\u0002\b\u001b\u0016$(/[2t\u0003-iW\r\u001e:jGN|F%Z9\u0015\u0007u\fi\u000eC\u0005\u0002\u0004i\t\t\u00111\u0001\u0002P\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\btS6\u0004H.\u001a*fa>\u0014H/\u001a:\u0016\u0005\u0005\u0015\bc\u00019\u0002h&\u0019\u0011\u0011^0\u0003\u001b\u0005+H-\u001b;SKB|'\u000f^3s\u0003I\u0019\u0018.\u001c9mKJ+\u0007o\u001c:uKJ|F%Z9\u0015\u0007u\fy\u000fC\u0005\u0002\u0004u\t\t\u00111\u0001\u0002f\u0006y1/[7qY\u0016\u0014V\r]8si\u0016\u0014\b%\u0001\ntS6\u0004H.Z!vI&$8+^7nCJLXCAA|!\r\u0001\u0018\u0011`\u0005\u0004\u0003w|&aD!vI&$(j\u001c2Tk6l\u0017M]=\u0002-MLW\u000e\u001d7f\u0003V$\u0017\u000e^*v[6\f'/_0%KF$2! B\u0001\u0011%\t\u0019\u0001IA\u0001\u0002\u0004\t90A\ntS6\u0004H.Z!vI&$8+^7nCJL\b%A\nekJ\f'-\u001b7jiflU\r\u001e:jG6;'/\u0006\u0002\u0003\nA!!1\u0002B\u0007\u001b\u0005\t\u0017b\u0001B\bC\nAB)\u001e:bE&d\u0017\u000e^=NKR\u0014\u0018nY:NC:\fw-\u001a:\u0002/\u0011,(/\u00192jY&$\u00180T3ue&\u001cWj\u001a:`I\u0015\fHcA?\u0003\u0016!I\u00111A\u0012\u0002\u0002\u0003\u0007!\u0011B\u0001\u0015IV\u0014\u0018MY5mSRLX*\u001a;sS\u000eluM\u001d\u0011\u0002\u001b\u0005,H-\u001b;t\u00032dwn^3e+\t\u0011i\u0002\u0005\u0004\u0003 \t%\"QF\u0007\u0003\u0005CQAAa\t\u0003&\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0005OI\u0017AC2pY2,7\r^5p]&!!1\u0006B\u0011\u0005\r\u0019V\r\u001e\t\u0005\u0005_\u0011YD\u0004\u0003\u00032\t]RB\u0001B\u001a\u0015\r\u0011)dX\u0001\b[\u0006t\u0017mZ3s\u0013\u0011\u0011IDa\r\u0002)\u0011+(/\u00192jY&$\u00180Q;eSR\u001c\u0005.Z2l\u0013\u0011\u0011iDa\u0010\u0003\u000bY\u000bG.^3\n\u0007\t\u0005\u0013NA\u0006F]VlWM]1uS>t\u0017AD1vI&$8/\u00117m_^,G\rI\u0001\u000eC2dwn^3e\u000bZ,g\u000e^:\u0016\u0005\t%\u0003C\u0002B\u0010\u0005S\u0011Y\u0005\u0005\u0003\u0003N\tmb\u0002\u0002B(\u0005+j!A!\u0015\u000b\u0007\tM\u0013-\u0001\u0004fm\u0016tGo]\u0005\u0005\u0005/\u0012\t&A\nEkJ\f'-\u001b7jif,e/\u001a8u)f\u0004X-\u0001\bbY2|w/\u001a3Fm\u0016tGo\u001d\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011\u00111N\u0001\u0013i>\u0004\u0018n\u0019)beRLG/[8o?\u0012*\u0017\u000fF\u0002~\u0005GB\u0011\"a\u0001+\u0003\u0003\u0005\r!a\u001b\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\n\u0001\u0002\u001a2D_:4\u0017nZ\u000b\u0003\u0003+\u000bA\u0002\u001a2D_:4\u0017nZ0%KF$2! B8\u0011%\t\u0019!LA\u0001\u0002\u0004\t)*A\u0005eE\u000e{gNZ5hA\u0005\u0011AMY\u000b\u0003\u0005o\u0002BA!\u001f\u0003~5\u0011!1\u0010\u0006\u0004\u0005g\n\u0017\u0002\u0002B@\u0005w\u0012A\u0002R;sC\nLG.\u001b;z\t\n\u000ba\u0001\u001a2`I\u0015\fHcA?\u0003\u0006\"I\u00111\u0001\u0019\u0002\u0002\u0003\u0007!qO\u0001\u0004I\n\u0004\u0013aC1vI&$8i\u001c8gS\u001e,\"A!$\u0011\u0007A\u0014y)C\u0002\u0003\u0012~\u0013Q\u0003R;sC\nLG.\u001b;z\u0003V$\u0017\u000e^\"p]\u001aLw-A\bbk\u0012LGoQ8oM&<w\fJ3r)\ri(q\u0013\u0005\n\u0003\u0007\u0019\u0014\u0011!a\u0001\u0005\u001b\u000bA\"Y;eSR\u001cuN\u001c4jO\u0002\nQa]3u+B$\u0012! \u0015\u0004k\t\u0005\u0006\u0003\u0002BR\u0005ck!A!*\u000b\t\t\u001d&\u0011V\u0001\u0004CBL'\u0002\u0002BV\u0005[\u000bqA[;qSR,'O\u0003\u0003\u00030\u0006e\u0014!\u00026v]&$\u0018\u0002\u0002BZ\u0005K\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u001c\u0003:B!!1\u0015B^\u0013\u0011\u0011iL!*\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\u0006;fgR\u001c\u0016.\u001c9mK>3gm]3u'\u000e\fg\u000eK\u00028\u0005\u0007\u0004BAa)\u0003F&!!q\u0019BS\u0005\u0011!Vm\u001d;\u0002]Q,7\u000f^*j[BdWm\u00144gg\u0016$8kY1o/&$\bn\u0014<fe2\f\u0007oV5uQRKWM\u001d)peRLwN\u001c\u0015\u0004q\t\r\u0017A\u0007;fgR\u001c\u0016.\u001c9mKRKWM]3e\u001f\u001a47/\u001a;TG\u0006t\u0007fA\u001d\u0003D\u0006aC/Z:u\u000f\u0006\u0004()\u001a;xK\u0016tG+[3sK\u0012,e\u000eZ(gMN,G/\u00118e\u0019><WI\u001c3PM\u001a\u001cX\r\u001e\u0015\u0004u\t\r\u0017\u0001F5oSRL\u0017\r\\5{K2{w-T1oC\u001e,'\u000f\u0006\u0003\u0003Z\nU\bC\u0002Bn\u0005K\u0014I/\u0004\u0002\u0003^*!!q\u001cBq\u0003!\u0019H/\u001e2cS:<'\u0002\u0002Br\u0003s\nq!\\8dW&$x.\u0003\u0003\u0003h\nu'aD(oO>LgnZ*uk\n\u0014\u0017N\\4\u0011\u000b!\u0014YOa<\n\u0007\t5\u0018N\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u001b\u0011\t0\u0003\u0003\u0003t\u0006=!aC!cgR\u0014\u0018m\u0019;M_\u001eDqAa><\u0001\u0004\u0011y/\u0001\u0003n\u0019><\u0017A\u0007;fgR|%M[3diN#xN]3TK\u001elWM\u001c;M_N\u001c\bf\u0001\u001f\u0003D\u0006YB/Z:u)&,'oQ8na\u0006\u001cG/\u001a3PE*,7\r\u001e'pgND3!\u0010Bb\u0003}!Xm\u001d;US\u0016\u00148i\\7qC\u000e$X\r\u001a+pa&\u001cg+\u00197jI\u0006$Xm\u001d\u0015\u0004}\t\r\u0017a\b;fgRl\u0015n]:j]\u001e\u001cVmZ7f]RLen\u00142kK\u000e$8\u000b^8sK\"\u001aqHa1\u0002;Q,7\u000f\u001e'bO\u001eLgn\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016D3\u0001\u0011Bb\u0003=!Xm\u001d;F]\u0012$v.\u00128e%Vt\u0007fA!\u0003D\u0006\u0019C/Z:u\u001f\u001a47/\u001a;HCB\u0014U\r^<fK:$\u0016.\u001a:B]\u0012dunY1m\u0019><\u0007f\u0001\"\u0003D\u0006AB/Z:u)&,'o\u00144gg\u0016$x)\u00199SKR\u0014\u0018.Z:)\u0007\r\u0013\u0019-\u0001\fuKN$hj\u001c8BY&<g.\u001a3TK\u001elWM\u001c;tQ\r!%1Y\u0001\u001ci\u0016\u001cHoQ8na\u0006\u001cG/\u001a3U_BL7-S:Bm>LG-\u001a3)\u0007\u0015\u0013\u0019-A\u0011uKN$8i\\7qC\u000e$X\r\u001a+pa&\u001c7\t[1oO\u0016$Gk\u001c#fY\u0016$X\rK\u0002G\u0005\u0007\f\u0011\u0005^3ti2\u000bGo\u00195D_VtG\u000fZ8x]RC'o\\<t\u000bb\u001cW\r\u001d;j_:D3a\u0012Bb\u0003\u0015\"Xm\u001d;Bk\u0012LGOS8c'2,W\r]:G_J$\u0016.\u001a:WKJLg-[2bi&|g\u000eK\u0002I\u0005\u0007\f\u0001\u0006^3tiRKWM\u001d'pON+w-\\3oi\u000e{gN^3sg&|gNR8s-\u0006d\u0017\u000eZ1u_JD3!\u0013Bb\u0003]!Xm\u001d;DQ\u0016\u001c7n];n\t&\u001c\u0018M\u00197f)\u0016\u001cH\u000fK\u0002K\u0005\u0007\f\u0001\u0003^3tiNK'0Z'jg6\fGo\u00195)\u0007-\u0013\u0019-A\fuKN$\u0018J\u001c<bY&$7+\u001b>f\u001b&\u001cX.\u0019;dQ\"\u001aAJa1\u0002=Q,7\u000f^*j[BdWmQ8na\u0006\u001cG/[8o-\u0006d\u0017\u000eZ1uS>t\u0007fA'\u0003D\u0006AC/Z:u'&l\u0007\u000f\\3D_6\u0004\u0018m\u0019;j_:4\u0016\r\\5eCRLwN\\0TG\u0016t\u0017M]5pc!\u001aaJa1\u0002QQ,7\u000f^*j[BdWmQ8na\u0006\u001cG/[8o-\u0006d\u0017\u000eZ1uS>twlU2f]\u0006\u0014\u0018n\u001c\u001a)\u0007=\u0013\u0019-\u0001\u0015uKN$8+[7qY\u0016\u001cu.\u001c9bGRLwN\u001c,bY&$\u0017\r^5p]~\u001b6-\u001a8be&|7\u0007K\u0002Q\u0005\u0007\fa\u0004^3ti6K7o]5oON+w-\\3oi&s7i\\7qC\u000e$\u0018n\u001c8)\u0007E\u0013\u0019-\u0001\nuKN$8i\u001c8heV,g\u000e\u001e$jY\u0016\u001c\bf\u0001*\u0003D\u0006\u0011B/Z:u\u001f\u001a47/\u001a;NCB4\u0015\u000e\\3tQ\r\u0019&1Y\u0001\u0018i\u0016\u001cH\u000fT1sO\u0016|eMZ:fi6\u000b\u0007OR5mKND3\u0001\u0016Bb\u0003E!Xm\u001d;NSNl\u0015\r^2i\r&dWm\u001d\u0015\u0004+\n\r\u0017a\u0006;fgRl\u0015n]'bi\u000eD7+\u001b>f\u0013:4\u0015\u000e\\3tQ\r1&1Y\u0001\u0013i\u0016\u001cH\u000fV8nEN$xN\\3GS2,7\u000fK\u0002X\u0005\u0007\f!\u0006^3tiR{WNY:u_:,WI\u001c;ssB\u0013Xm]3oi>sG._%o\t\u0016\u001cH/\u001b8bi&|g\u000eK\u0002Y\u0005\u0007\fq\u0005^3tiRKWM]3e-\u0006d\u0017\u000eZ1uS>t7oU6jaB,Gm\u00148G_2dwn^3sg\"\u001a\u0011La1\u0002OQ,7\u000f\u001e'pG\u0006dGj\\4Ti\u0006\u0014HoR1q\t\u0016$Xm\u0019;fI>sgi\u001c7m_^,'o\u001d\u0015\u00045\n\r\u0017\u0001\t;fgR|%M[3diN#xN]3D_6\u0004\u0018m\u0019;fIN+w-\\3oiND3a\u0017Bb\u0003a!Xm\u001d;US\u0016\u0014Hj\\2bYN+w-\\3oiN<\u0015\r\u001d\u0015\u00049\n\r\u0017A\u0005;fgR4UM\\2fI6+7o]1hKND3!\u0018Bb\u0001")
public class BrokerAuditJobTest {
    private File logDir;
    private LogManager logManager;
    private MockTime time;
    private BrokerAuditJob auditJob;
    private scala.collection.immutable.Seq<TopicPartition> topicPartitions = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    private scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>> partitionTuple = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    private TierObjectStore objStore = null;
    private final int jobId;
    private Metrics metrics;
    private AuditReporter simpleReporter;
    private AuditJobSummary simpleAuditSummary;
    private DurabilityMetricsManager durabilityMetricMgr;
    private final Set<Enumeration.Value> auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit()}));
    private final Set<Enumeration.Value> allowedEvents = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityEventType$.MODULE$.DeleteRecordsType(), DurabilityEventType$.MODULE$.IsrExpandType(), DurabilityEventType$.MODULE$.EpochChangeType(), DurabilityEventType$.MODULE$.RetentionChangeType(), DurabilityEventType$.MODULE$.StartOffsetChangeType(), DurabilityEventType$.MODULE$.OffsetChangeType(), DurabilityEventType$.MODULE$.DeletePartitionType(), DurabilityEventType$.MODULE$.HealthCheckType()}));
    private TopicPartition topicPartition;
    private long dbConfig = 0L;
    private DurabilityDB db = null;
    private DurabilityAuditConfig auditConfig = null;

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public BrokerAuditJob auditJob() {
        return this.auditJob;
    }

    public void auditJob_$eq(BrokerAuditJob x$1) {
        this.auditJob = x$1;
    }

    public scala.collection.immutable.Seq<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public void topicPartitions_$eq(scala.collection.immutable.Seq<TopicPartition> x$1) {
        this.topicPartitions = x$1;
    }

    public scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>> partitionTuple() {
        return this.partitionTuple;
    }

    public void partitionTuple_$eq(scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>> x$1) {
        this.partitionTuple = x$1;
    }

    public TierObjectStore objStore() {
        return this.objStore;
    }

    public void objStore_$eq(TierObjectStore x$1) {
        this.objStore = x$1;
    }

    public int jobId() {
        return this.jobId;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public AuditReporter simpleReporter() {
        return this.simpleReporter;
    }

    public void simpleReporter_$eq(AuditReporter x$1) {
        this.simpleReporter = x$1;
    }

    public AuditJobSummary simpleAuditSummary() {
        return this.simpleAuditSummary;
    }

    public void simpleAuditSummary_$eq(AuditJobSummary x$1) {
        this.simpleAuditSummary = x$1;
    }

    public DurabilityMetricsManager durabilityMetricMgr() {
        return this.durabilityMetricMgr;
    }

    public void durabilityMetricMgr_$eq(DurabilityMetricsManager x$1) {
        this.durabilityMetricMgr = x$1;
    }

    public Set<Enumeration.Value> auditsAllowed() {
        return this.auditsAllowed;
    }

    public Set<Enumeration.Value> allowedEvents() {
        return this.allowedEvents;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public void topicPartition_$eq(TopicPartition x$1) {
        this.topicPartition = x$1;
    }

    public long dbConfig() {
        return this.dbConfig;
    }

    public void dbConfig_$eq(long x$1) {
        this.dbConfig = x$1;
    }

    public DurabilityDB db() {
        return this.db;
    }

    public void db_$eq(DurabilityDB x$1) {
        this.db = x$1;
    }

    public DurabilityAuditConfig auditConfig() {
        return this.auditConfig;
    }

    public void auditConfig_$eq(DurabilityAuditConfig x$1) {
        this.auditConfig = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.time_$eq(new MockTime());
        this.objStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig()));
        this.metrics_$eq(new Metrics(new MetricConfig(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava(), (Time)this.time()));
        Metrics x$2 = this.metrics();
        MockTime x$3 = this.time();
        long x$5 = DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS();
        this.durabilityMetricMgr_$eq(new DurabilityMetricsManager("0", x$2, (Time)x$3, x$5, false));
        DurabilityMetricsManager apply_metricManager = this.durabilityMetricMgr();
        Object var6_4 = null;
        this.simpleReporter_$eq(new AuditReporter(apply_metricManager));
        this.simpleAuditSummary_$eq(new AuditJobSummary());
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        this.topicPartition_$eq(new TopicPartition("some-topic", 1));
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)this.topicPartition(), (List)Nil$.MODULE$));
        this.partitionTuple_$eq((scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>>)new .colon.colon((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)0L)), (List)Nil$.MODULE$));
        this.db_$eq(DbTestUtils$.MODULE$.getDbInstance());
        PartitionState partitionState = PartitionState$.MODULE$.apply(this.topicPartition().partition(), 0L);
        partitionState.isLeader_$eq(true);
        this.db().addPartition(this.topicPartition(), partitionState);
        this.auditConfig_$eq(DurabilityTestUtils$.MODULE$.durabilityAuditConfig((Time)this.time(), true, this.auditsAllowed(), this.allowedEvents(), this.logDir(), Predef$.MODULE$.Long2long(ConfluentConfigs.DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DEFAULT), DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID()));
    }

    @AfterEach
    public void tearDown() {
        if (this.objStore() != null) {
            this.objStore().close();
        }
        this.logManager_$eq(null);
        Utils.delete((File)this.logDir(), (boolean)false);
    }

    @Test
    public void testSimpleOffsetScan() {
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        scala.collection.immutable.Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 10L, 0L, 1);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), segments, (scala.collection.immutable.Seq<TierLogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)4L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)10L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)10L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSimpleOffsetScanWithOverlapWithTierPortion() {
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        TierPartitionState tierPartitionMock = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        File x$1 = this.logDir();
        long x$4 = 0L;
        scala.collection.immutable.Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(x$1, 10L, x$4, 10);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionMock.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        TopicPartition x$5 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$7 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Some x$8 = new Some((Object)tierPartitionMock);
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        None$ x$11 = None$.MODULE$;
        boolean x$12 = false;
        boolean x$13 = false;
        None$ x$14 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$5, segments, (scala.collection.immutable.Seq<TierLogSegment>)x$7, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$9, (Option<Object>)x$10, (Option<Object>)x$11, x$12, x$13, (Option<TierPartitionState>)x$8, (Option<Uuid>)x$14);
        this.initializeLogManager(mLog);
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)22L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSimpleTieredOffsetScan() {
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testSimpleTieredOffsetScan$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        boolean x$7 = false;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, (scala.collection.immutable.Seq<LogSegment>)x$2, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$4, (Option<Object>)x$6, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)3000L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)10L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)10L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testGapBetweenTieredEndOffsetAndLogEndOffset() {
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testGapBetweenTieredEndOffsetAndLogEndOffset$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        Some x$5 = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
        None$ x$6 = None$.MODULE$;
        boolean x$7 = false;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, (scala.collection.immutable.Seq<LogSegment>)x$2, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$6, (Option<Object>)x$4, (Option<Object>)x$5, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)999L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)999L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    private OngoingStubbing<Option<AbstractLog>> initializeLogManager(AbstractLog mLog) {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        boolean x$2 = qual$1.getLog$default$2();
        return Mockito.when((Object)qual$1.getLog(x$1, x$2)).thenReturn((Object)new Some((Object)mLog));
    }

    @Test
    public void testObjectStoreSegmentLoss() {
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testObjectStoreSegmentLoss$1(this, segment);
            return BoxedUnit.UNIT;
        });
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)3000L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.objStore().deleteSegment(((TierLogSegment)tierSegments.head()).metadata());
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1000L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)1000L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierCompactedObjectLoss() {
        int localLogStartOffset = 2042;
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testTierCompactedObjectLoss$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, localLogStartOffset, 1);
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$1, localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$6, (Option<Object>)x$7, (Option<Object>)x$8, true, true, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        this.initializeLogManager(mlog);
        this.objStore().deleteSegment(((TierLogSegment)tierSegments.head()).metadata());
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1000L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierCompactedTopicValidates() {
        int localLogStartOffset = 2042;
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testTierCompactedTopicValidates$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, localLogStartOffset, 1);
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$1, localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$6, (Option<Object>)x$7, (Option<Object>)x$8, true, true, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testMissingSegmentInObjectStore() {
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)3000L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this){

            public boolean shouldCountLapse(TierMetadataValidator.OffsetValidationResult tierValidationResult) {
                return true;
            }
        });
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata((TierLogSegment)tierSegments.head()), this.objStore());
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1010L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)1010L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testLaggingTierPartitionState() {
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L, 0L);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)3000L)), (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)3001L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this){

            public boolean shouldCountLapse(TierMetadataValidator.OffsetValidationResult tierValidationResult) {
                return true;
            }
        });
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testEndToEndRun() {
        long expectedTotalMsgCount = 2004L;
        long expectedGapCount = 0L;
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)new .colon.colon((Object)new TopicPartition("some-topic", 2), (List)Nil$.MODULE$)));
        this.objStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig()));
        scala.collection.immutable.Map logMap = ((IterableOnceOps)this.topicPartitions().map((Function1 & Serializable)topicPartition -> {
            File logDir = TestUtils.tempDirectory(null, null);
            scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)topicPartition, this.objStore(), 0L, 0L);
            tierSegments.foreach((Function1 & Serializable)tierSegment -> {
                BrokerAuditJobTest.$anonfun$testEndToEndRun$2(this, tierSegment);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(logDir, 0L, 2000L, 1);
            Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)2003L));
            None$ x$5 = None$.MODULE$;
            None$ x$6 = None$.MODULE$;
            boolean x$7 = false;
            boolean x$8 = false;
            None$ x$9 = None$.MODULE$;
            None$ x$10 = None$.MODULE$;
            return new Tuple2(topicPartition, (Object)DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)topicPartition, localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$6, (Option<Object>)x$4, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.logManager_$eq(DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)logMap));
        CountDownLatch countdown = new CountDownLatch(1);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), countdown, this.simpleReporter(), this.simpleAuditSummary(), 0, (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.auditJob().run();
        this.partitionTuple().foreach((Function1 & Serializable)x0$1 -> {
            BrokerAuditJobTest.$anonfun$testEndToEndRun$3(this, expectedGapCount, expectedTotalMsgCount, x0$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
        Assertions.assertEquals((long)0L, (long)countdown.getCount());
    }

    @Test
    public void testOffsetGapBetweenTierAndLocalLog() {
        int localLogStartOffset = 2042;
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testOffsetGapBetweenTierAndLocalLog$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, localLogStartOffset, 1);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.localLogStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(localLogStartOffset)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)2045L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)42L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)42L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierOffsetGapRetries() {
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, 0L);
        scala.collection.immutable.Seq<TierLogSegment> secondaryTierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L, 2000L);
        ((IterableOnceOps)tierSegments.$plus$plus(secondaryTierSegments)).foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testTierOffsetGapRetries$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 0L, 4000L, 1);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)new Some(tierSegments.$plus$plus(secondaryTierSegments)), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)4003L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)4004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testNonAlignedSegments() {
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        AbstractLog mLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        boolean x$2 = qual$1.getLog$default$2();
        Mockito.when((Object)qual$1.getLog(x$1, x$2)).thenReturn((Object)new Some((Object)mLog));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)mLog.config()).thenReturn((Object)new LogConfig(new HashMap()));
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        .colon.colon tierSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 11L, 20L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 18L, 31L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive), (List)Nil$.MODULE$)));
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testNonAlignedSegments$1(this, segment);
            return BoxedUnit.UNIT;
        });
        .colon.colon localSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(20L, 30L, this.logDir(), 10, Time.SYSTEM, -1L), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(31L, 40L, this.logDir(), 10, Time.SYSTEM, -1L), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(41L, 50L, this.logDir(), 10, Time.SYSTEM, -1L), (List)Nil$.MODULE$)));
        TopicPartition x$3 = (TopicPartition)this.topicPartitions().head();
        Some x$6 = new Some((Object)BoxesRunTime.boxToLong((long)50L));
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = false;
        boolean x$10 = false;
        None$ x$11 = None$.MODULE$;
        None$ x$12 = None$.MODULE$;
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$3, (scala.collection.immutable.Seq<LogSegment>)localSegments, (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$7, (Option<Object>)x$8, (Option<Object>)x$6, x$9, x$10, (Option<TierPartitionState>)x$11, (Option<Uuid>)x$12);
        LogManager qual$2 = this.logManager();
        TopicPartition x$13 = (TopicPartition)this.topicPartitions().head();
        boolean x$14 = qual$2.getLog$default$2();
        Mockito.when((Object)qual$2.getLog(x$13, x$14)).thenReturn((Object)new Some((Object)mlog));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)66L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testCompactedTopicIsAvoided() {
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        scala.collection.immutable.Seq<LogSegment> segments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 10L, 0L, 1);
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$3 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog(x$1, segments, (scala.collection.immutable.Seq<TierLogSegment>)x$3, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$6, (Option<Object>)x$7, true, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)0L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertFalse((boolean)auditResult.errorOpt().isEmpty());
        Predef$.MODULE$.assert(auditResult.errorOpt().get() instanceof UnsupportedOperationException);
        Assertions.assertTrue((boolean)((Throwable)auditResult.errorOpt().get()).getMessage().contains("is not audited"));
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testCompactedTopicChangedToDelete() {
        this.partitionTuple_$eq((scala.collection.immutable.Seq<Tuple2<TopicPartition, Object>>)new .colon.colon((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)ConfigFlag$.MODULE$.OnceCompacted().id())), (List)Nil$.MODULE$));
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 1000L, 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testCompactedTopicChangedToDelete$1(this, segment);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithGap(this.logDir(), 1000L, 4000L, 1);
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, true, true, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, (long)ConfigFlag$.MODULE$.OnceCompacted().id());
        Assertions.assertEquals((long)2004L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.config().compact())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.isTierCompactable())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)mLog.tieredLogSegments()).thenReturn((Object)tierSegments.iterator());
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult2 = this.auditJob().doAuditSafely(mLog, (long)ConfigFlag$.MODULE$.OnceCompacted().id());
        Assertions.assertEquals((long)2004L, (long)auditResult2.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult2.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult2.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testLatchCountdownThrowsException() {
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        .colon.colon tierSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive), (List)Nil$.MODULE$);
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(0), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        Assertions.assertThrows(InterruptedException.class, () -> this.auditJob().doAuditSafely(mlog, this.dbConfig()), () -> "Expected InterruptedException to be thrown");
    }

    @Test
    public void testAuditJobSleepsForTierVerification() {
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        scala.collection.immutable.Seq tierSegments = (scala.collection.immutable.Seq)package$.MODULE$.Seq().fill(BrokerAuditJob$.MODULE$.TIER_SEGMENT_BATCH_SIZE() + 1, (Function0 & Serializable)() -> LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, this.objStore(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive));
        long beforeAccessTimestamp = this.time().milliseconds();
        this.logManager_$eq((LogManager)Mockito.mock(LogManager.class));
        AbstractLog mlog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mlog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)None$.MODULE$, (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.auditJob().doAuditSafely(mlog, this.dbConfig());
        Assertions.assertEquals((long)(BrokerAuditJob$.MODULE$.SLEEP_TIME_MS() * 2L), (long)(this.time().milliseconds() - beforeAccessTimestamp));
    }

    @Test
    public void testTierLogSegmentConversionForValidator() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("my-topic", UUID.randomUUID(), 0);
        int keyBaseOffset = 44;
        int virtualBaseOffset = 43;
        int endOffset = 55;
        int maxTimestamp = 100;
        int size = 33;
        int firstBatchTimestamp = 30;
        SegmentState segmentState = new SegmentState(0, UUID.randomUUID(), (long)virtualBaseOffset, (long)keyBaseOffset, (long)endOffset, (long)maxTimestamp, (long)firstBatchTimestamp, size, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, true, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, 99L);
        TierLogSegment tierLogSegmentOverlapping = new TierLogSegment(topicIdPartition, segmentState);
        TierObjectMetadata overlappingMetadata = BrokerAuditJob$.MODULE$.getTierObjectMetadata(tierLogSegmentOverlapping);
        Assertions.assertEquals((long)keyBaseOffset, (long)overlappingMetadata.baseOffset(), (String)"tier log segment with virtually bounded base offset should return true key base offset in metadata");
        Assertions.assertEquals((long)55L, (long)overlappingMetadata.endOffset());
        Assertions.assertEquals((long)100L, (long)overlappingMetadata.maxTimestamp());
        Assertions.assertEquals((int)33, (int)size);
    }

    @Test
    public void testChecksumDisableTest() {
        this.topicPartitions_$eq((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("some-topic", 1), (List)Nil$.MODULE$));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testChecksumDisableTest$1(this, segment);
            return BoxedUnit.UNIT;
        });
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.tierPartitionState().mayContainTieredData())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mLog.tierPartitionState().validateChecksum())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.PeriodicalAudit()})), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.ChecksumValidation())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSizeMismatch() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        TierObjectStore objectStoreSpy = (TierObjectStore)Mockito.spy((Object)this.objStore());
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), objectStoreSpy, 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testSizeMismatch$1(objectStoreSpy, segment);
            return BoxedUnit.UNIT;
        });
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        boolean x$7 = false;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, (scala.collection.immutable.Seq<LogSegment>)x$2, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$4, (Option<Object>)x$6, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)3000L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        TierObjectStore.ObjectMetadata firstSegMetadata = ((TierLogSegment)tierSegments.head()).metadata();
        Mockito.when((Object)objectStoreSpy.objectExists(new TierObjectStore.ObjectMetadata(firstSegMetadata.topicIdPartition(), firstSegMetadata.objectId(), firstSegMetadata.tierEpoch(), firstSegMetadata.baseOffset(), firstSegMetadata.hasAbortedTxns(), firstSegMetadata.hasProducerState(), firstSegMetadata.hasEpochState(), firstSegMetadata.opaqueData()), TierObjectStore.FileType.SEGMENT)).thenReturn((Object)new TierObjectAttribute(false, 1L));
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)objectStoreSpy), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)1000L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)1000L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testInvalidSizeMismatch() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        TierObjectStore objectStoreSpy = (TierObjectStore)Mockito.spy((Object)this.objStore());
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), objectStoreSpy, 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testInvalidSizeMismatch$1(objectStoreSpy, segment);
            return BoxedUnit.UNIT;
        });
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        scala.collection.immutable.Seq x$2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        boolean x$7 = false;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, (scala.collection.immutable.Seq<LogSegment>)x$2, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$4, (Option<Object>)x$6, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)3000L));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        TierObjectStore.ObjectMetadata firstSegMetadata = ((TierLogSegment)tierSegments.head()).metadata();
        Mockito.when((Object)objectStoreSpy.objectExists(new TierObjectStore.ObjectMetadata(firstSegMetadata.topicIdPartition(), firstSegMetadata.objectId(), firstSegMetadata.tierEpoch(), firstSegMetadata.baseOffset(), firstSegMetadata.hasAbortedTxns(), firstSegMetadata.hasProducerState(), firstSegMetadata.hasEpochState(), firstSegMetadata.opaqueData()), TierObjectStore.FileType.SEGMENT)).thenReturn((Object)new TierObjectAttribute(true, -1L));
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)objectStoreSpy), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)2000L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testSimpleCompactionValidation() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testSimpleCompactionValidation$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 1000L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 1999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1, objectID2})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID3})), 1999L, 1999L, true);
        TierTopicEvents events = new TierTopicEvents((scala.collection.immutable.Seq)new .colon.colon((Object)commitSwapEvent, (List)Nil$.MODULE$), (scala.collection.immutable.Seq)((IterableOps)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$)));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.auditJob().verifyCompactedPartition(topicIdPartition, events);
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.CompactionValidation())).count());
    }

    @Test
    public void testSimpleCompactionValidation_Scenario1() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testSimpleCompactionValidation_Scenario1$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 50L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID3})), 1999L, 1999L, true);
        TierTopicEvents events = new TierTopicEvents((scala.collection.immutable.Seq)new .colon.colon((Object)commitSwapEvent, (List)Nil$.MODULE$), (scala.collection.immutable.Seq)((IterableOps)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$)));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.auditJob().verifyCompactedPartition(topicIdPartition, events);
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.CompactionValidation())).count());
    }

    @Test
    public void testSimpleCompactionValidation_Scenario2() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testSimpleCompactionValidation_Scenario2$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 1000L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 1999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent1 = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1})), Predef$.MODULE$.Set().empty(), 0L, 999L, false);
        CommitAndSwapEvent commitSwapEvent2 = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID2})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID3})), 1L, 1999L, true);
        TierTopicEvents events = new TierTopicEvents((scala.collection.immutable.Seq)new .colon.colon((Object)commitSwapEvent1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)commitSwapEvent2, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)((IterableOps)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$)));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.auditJob().verifyCompactedPartition(topicIdPartition, events);
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.CompactionValidation())).count());
    }

    @Test
    public void testSimpleCompactionValidation_Scenario3() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testSimpleCompactionValidation_Scenario3$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 1000L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 1999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent1 = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1})), Predef$.MODULE$.Set().empty(), 0L, 999L, false);
        TierTopicEvents events = new TierTopicEvents((scala.collection.immutable.Seq)new .colon.colon((Object)commitSwapEvent1, (List)Nil$.MODULE$), (scala.collection.immutable.Seq)((IterableOps)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$)));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        Assertions.assertTrue((boolean)this.auditJob().trimCommitAndSwapEvent((scala.collection.immutable.Seq)new .colon.colon((Object)commitSwapEvent1, (List)Nil$.MODULE$)).isEmpty());
        this.auditJob().verifyCompactedPartition(topicIdPartition, events);
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.CompactionValidation())).count());
    }

    @Test
    public void testMissingSegmentInCompaction() {
        Set auditsAllowed = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 0L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testMissingSegmentInCompaction$1(this, segment);
            return BoxedUnit.UNIT;
        });
        TopicIdPartition topicIdPartition = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), 1);
        UUID objectID1 = UUID.randomUUID();
        UUID objectID2 = UUID.randomUUID();
        UUID objectID3 = UUID.randomUUID();
        UploadCompleteEvent uploadSegment1 = new UploadCompleteEvent(objectID1);
        UploadCompleteEvent uploadSegment2 = new UploadCompleteEvent(objectID2);
        TierSegmentUploadInitiate msg1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID1, Optional.empty(), 0L, 999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID2, Optional.empty(), 1000L, 1999L, 50L, 50L, 1000, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadInitiate msg3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectID3, Optional.empty(), 0L, 1999L, 50L, 50L, 2000, false, false, false, TierUploadType.Compaction, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        UploadInitiateEvent uploadInitiate1 = new UploadInitiateEvent(objectID1, msg1);
        UploadInitiateEvent uploadInitiate2 = new UploadInitiateEvent(objectID2, msg2);
        UploadInitiateEvent uploadInitiate3 = new UploadInitiateEvent(objectID3, msg3);
        CommitAndSwapEvent commitSwapEvent = new CommitAndSwapEvent((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID1})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectID3})), 1999L, 1999L, true);
        TierTopicEvents events = new TierTopicEvents((scala.collection.immutable.Seq)new .colon.colon((Object)commitSwapEvent, (List)Nil$.MODULE$), (scala.collection.immutable.Seq)((IterableOps)new .colon.colon((Object)uploadInitiate1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)uploadInitiate3, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)new .colon.colon((Object)uploadSegment1, (List)Nil$.MODULE$).$plus$plus((IterableOnce)new .colon.colon((Object)uploadSegment2, (List)Nil$.MODULE$)));
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog((TopicPartition)this.topicPartitions().head(), (scala.collection.immutable.Seq<LogSegment>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false, false, (Option<TierPartitionState>)None$.MODULE$, (Option<Uuid>)None$.MODULE$);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), auditsAllowed, this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.auditJob().verifyCompactedPartition(topicIdPartition, events);
        Assertions.assertEquals((long)1000L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.CompactionValidation())).count());
    }

    @Test
    public void testCongruentFiles() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap = DurabilityTestUtils$.MODULE$.getOffsetMap(500, false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap, Paths.get(".", "File1").toFile(), false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap, Paths.get(".", "File2").toFile(), false);
        int mismatches = DurabilityOffsetMapUtils$.MODULE$.checkCongruentOffsetMapFile(new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), CoreUtils$.MODULE$.toJavaUUID(Uuid.randomUuid()), ((TopicPartition)this.topicPartitions().head()).partition()), new File("./File1"), new File("./File2"));
        Assertions.assertEquals((int)0, (int)mismatches);
        new File("./File1").delete();
        new File("./File2").delete();
    }

    @Test
    public void testOffsetMapFiles() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap1 = DurabilityTestUtils$.MODULE$.getOffsetMap(50, false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap1, Paths.get(".", "File1").toFile(), false);
        scala.collection.SortedMap offsetMap2 = DurabilityOffsetMapUtils$.MODULE$.retrieveOffsetMapInFile(new File("."), "File1");
        Assertions.assertTrue((boolean)offsetMap1.equals((Object)offsetMap2));
        new File("./File2").delete();
    }

    @Test
    public void testLargeOffsetMapFiles() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap1 = DurabilityTestUtils$.MODULE$.getOffsetMap(200000, false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap1, Paths.get(".", "File1").toFile(), false);
        scala.collection.SortedMap offsetMap2 = DurabilityOffsetMapUtils$.MODULE$.retrieveOffsetMapInFile(new File("."), "File1");
        Assertions.assertTrue((boolean)offsetMap1.equals((Object)offsetMap2));
        new File("./File2").delete();
    }

    @Test
    public void testMisMatchFiles() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap1 = DurabilityTestUtils$.MODULE$.getOffsetMap(500, false);
        SortedMap<ByteBuffer, OffsetInfo> offsetMap2 = DurabilityTestUtils$.MODULE$.getOffsetMap(500, false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap1, Paths.get(".", "File1").toFile(), false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap2, Paths.get(".", "File2").toFile(), false);
        int memMismatches = 0;
        Iterator iter1 = offsetMap1.iterator();
        Iterator iter2 = offsetMap2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            Tuple2 firstObj = (Tuple2)iter1.next();
            Tuple2 secondObj = (Tuple2)iter2.next();
            if (BoxesRunTime.equals((Object)firstObj._1(), (Object)secondObj._1()) && ((OffsetInfo)firstObj._2()).offset() == ((OffsetInfo)secondObj._2()).offset()) continue;
            ++memMismatches;
        }
        int mismatches = DurabilityOffsetMapUtils$.MODULE$.checkCongruentOffsetMapFile(new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), CoreUtils$.MODULE$.toJavaUUID(Uuid.randomUuid()), ((TopicPartition)this.topicPartitions().head()).partition()), new File("./File1"), new File("./File2"));
        Assertions.assertEquals((int)memMismatches, (int)mismatches);
        new File("./File1").delete();
        new File("./File2").delete();
    }

    @Test
    public void testMisMatchSizeInFiles() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap = DurabilityTestUtils$.MODULE$.getOffsetMap(500, false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap, Paths.get(".", "File1").toFile(), false);
        SortedMap updatedMap = (SortedMap)offsetMap.dropRight(1);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile((scala.collection.SortedMap)updatedMap, Paths.get(".", "File2").toFile(), false);
        int mismatches = DurabilityOffsetMapUtils$.MODULE$.checkCongruentOffsetMapFile(new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), CoreUtils$.MODULE$.toJavaUUID(Uuid.randomUuid()), ((TopicPartition)this.topicPartitions().head()).partition()), new File("./File1"), new File("./File2"));
        Assertions.assertEquals((int)1, (int)mismatches);
        new File("./File1").delete();
        new File("./File2").delete();
    }

    @Test
    public void testTombstoneFiles() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap1 = DurabilityTestUtils$.MODULE$.getOffsetMap(20, true);
        SortedMap<ByteBuffer, OffsetInfo> offsetMap2 = DurabilityTestUtils$.MODULE$.getOffsetMap(10, true);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap1, Paths.get(".", "File1").toFile(), false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap2, Paths.get(".", "File2").toFile(), false);
        int mismatches = DurabilityOffsetMapUtils$.MODULE$.checkCongruentOffsetMapFile(new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), CoreUtils$.MODULE$.toJavaUUID(Uuid.randomUuid()), ((TopicPartition)this.topicPartitions().head()).partition()), new File("./File1"), new File("./File2"));
        Assertions.assertEquals((int)0, (int)mismatches);
        new File("./File1").delete();
        new File("./File2").delete();
    }

    @Test
    public void testTombstoneEntryPresentOnlyInDestination() {
        SortedMap<ByteBuffer, OffsetInfo> offsetMap1 = DurabilityTestUtils$.MODULE$.getOffsetMap(0, true);
        SortedMap<ByteBuffer, OffsetInfo> offsetMap2 = DurabilityTestUtils$.MODULE$.getOffsetMap(20, true);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap1, Paths.get(".", "File1").toFile(), false);
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile(offsetMap2, Paths.get(".", "File2").toFile(), false);
        int mismatches = DurabilityOffsetMapUtils$.MODULE$.checkCongruentOffsetMapFile(new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), CoreUtils$.MODULE$.toJavaUUID(Uuid.randomUuid()), ((TopicPartition)this.topicPartitions().head()).partition()), new File("./File1"), new File("./File2"));
        Assertions.assertEquals((int)2, (int)mismatches);
        new File("./File1").delete();
        new File("./File2").delete();
    }

    @Test
    public void testTieredValidationsSkippedOnFollowers() {
        ((PartitionState)this.db().fetchPartitionState(this.topicPartition()).get()).isLeader_$eq(false);
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testTieredValidationsSkippedOnFollowers$1(this, segment);
            return BoxedUnit.UNIT;
        });
        long localLogStartOffset = ((TierLogSegment)tierSegments.last()).endOffset() + 1L;
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithoutGap(this.logDir(), localLogStartOffset);
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)((TierLogSegment)tierSegments.head()).baseOffset()));
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        boolean x$7 = false;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$4, (Option<Object>)x$6, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)(localLogStartOffset + 3L)));
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        this.objStore().deleteSegment(((TierLogSegment)tierSegments.last()).metadata());
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)(((LogSegment)localSegments.last()).readNextOffset() - ((TierLogSegment)tierSegments.last()).baseOffset()), (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)auditResult.errorOpt().isEmpty());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testLocalLogStartGapDetectedOnFollowers() {
        ((PartitionState)this.db().fetchPartitionState(this.topicPartition()).get()).isLeader_$eq(false);
        scala.collection.immutable.Seq<TierLogSegment> tierSegments = DurabilityTestUtils$.MODULE$.getTieredSegmentsWithoutGap((TopicPartition)this.topicPartitions().head(), this.objStore(), 10L);
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testLocalLogStartGapDetectedOnFollowers$1(this, segment);
            return BoxedUnit.UNIT;
        });
        int localLogStartOffsetGapCount = 4;
        long localLogStartOffset = ((TierLogSegment)tierSegments.last()).endOffset() + 1L + (long)localLogStartOffsetGapCount;
        scala.collection.immutable.Seq<LogSegment> localSegments = DurabilityTestUtils$.MODULE$.getLocalSegmentsWithoutGap(this.logDir(), localLogStartOffset);
        TopicPartition x$1 = (TopicPartition)this.topicPartitions().head();
        Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)((TierLogSegment)tierSegments.head()).baseOffset()));
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        boolean x$7 = false;
        boolean x$8 = false;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$1, localSegments, tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$5, (Option<Object>)x$4, (Option<Object>)x$6, x$7, x$8, (Option<TierPartitionState>)x$9, (Option<Uuid>)x$10);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)mLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)(localLogStartOffset + 3L)));
        Predef$.MODULE$.assert(mLog.logStartOffset() == 10L);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)(((LogSegment)localSegments.last()).readNextOffset() - ((TierLogSegment)tierSegments.last()).baseOffset() - (long)localLogStartOffsetGapCount), (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)localLogStartOffsetGapCount, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)localLogStartOffsetGapCount, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testObjectStoreCompactedSegments() {
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        TierObjectStore x$4 = this.objStore();
        TierObjectMetadata.State x$6 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
        long x$7 = 1L;
        long x$8 = 1L;
        TierObjectMetadata.State x$9 = TierObjectMetadata.State.INVALID;
        TierObjectStore x$13 = this.objStore();
        TierObjectMetadata.State x$15 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
        long x$16 = 1L;
        long x$17 = 1L;
        TierObjectMetadata.State x$18 = TierObjectMetadata.State.INVALID;
        TierObjectStore x$22 = this.objStore();
        TierObjectMetadata.State x$24 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
        long x$25 = 1L;
        long x$26 = 1L;
        TierObjectMetadata.State x$27 = TierObjectMetadata.State.INVALID;
        .colon.colon tierSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, x$4, x$6, x$7, x$8, x$9, TierUploadType.Compaction), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 12L, 20L, x$13, x$15, x$16, x$17, x$18, TierUploadType.Compaction), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 22L, 31L, x$22, x$24, x$25, x$26, x$27, TierUploadType.Archive), (List)Nil$.MODULE$)));
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testObjectStoreCompactedSegments$1(this, segment);
            return BoxedUnit.UNIT;
        });
        .colon.colon localSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(24L, 32L, this.logDir(), 10, Time.SYSTEM, -1L), (List)Nil$.MODULE$);
        TopicPartition x$28 = (TopicPartition)this.topicPartitions().head();
        Some x$31 = new Some((Object)BoxesRunTime.boxToLong((long)32L));
        None$ x$32 = None$.MODULE$;
        None$ x$33 = None$.MODULE$;
        boolean x$34 = false;
        boolean x$35 = false;
        None$ x$36 = None$.MODULE$;
        None$ x$37 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$28, (scala.collection.immutable.Seq<LogSegment>)localSegments, (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$32, (Option<Object>)x$33, (Option<Object>)x$31, x$34, x$35, (Option<TierPartitionState>)x$36, (Option<Uuid>)x$37);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)39L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    @Test
    public void testTierLocalSegmentsGap() {
        TopicIdPartition tid = new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), UUID.randomUUID(), ((TopicPartition)this.topicPartitions().head()).partition());
        TierObjectStore x$4 = this.objStore();
        TierObjectMetadata.State x$6 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
        long x$7 = 1L;
        long x$8 = 1L;
        TierObjectMetadata.State x$9 = TierObjectMetadata.State.INVALID;
        TierObjectStore x$13 = this.objStore();
        TierObjectMetadata.State x$15 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
        long x$16 = 1L;
        long x$17 = 1L;
        TierObjectMetadata.State x$18 = TierObjectMetadata.State.INVALID;
        TierObjectStore x$22 = this.objStore();
        TierObjectMetadata.State x$24 = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
        long x$25 = 1L;
        long x$26 = 1L;
        TierObjectMetadata.State x$27 = TierObjectMetadata.State.INVALID;
        .colon.colon tierSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 0L, 10L, x$4, x$6, x$7, x$8, x$9, TierUploadType.Compaction), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 12L, 20L, x$13, x$15, x$16, x$17, x$18, TierUploadType.Compaction), (List)new .colon.colon((Object)LogTestUtils$.MODULE$.createTierLogSegment(tid, 22L, 31L, x$22, x$24, x$25, x$26, x$27, TierUploadType.Compaction), (List)Nil$.MODULE$)));
        tierSegments.foreach((Function1 & Serializable)segment -> {
            BrokerAuditJobTest.$anonfun$testTierLocalSegmentsGap$1(this, segment);
            return BoxedUnit.UNIT;
        });
        .colon.colon localSegments = new .colon.colon((Object)LogTestUtils$.MODULE$.createLocalLogSegment(35L, 40L, this.logDir(), 10, Time.SYSTEM, -1L), (List)Nil$.MODULE$);
        TopicPartition x$28 = (TopicPartition)this.topicPartitions().head();
        Some x$31 = new Some((Object)BoxesRunTime.boxToLong((long)40L));
        None$ x$32 = None$.MODULE$;
        None$ x$33 = None$.MODULE$;
        boolean x$34 = false;
        boolean x$35 = false;
        None$ x$36 = None$.MODULE$;
        None$ x$37 = None$.MODULE$;
        AbstractLog mLog = DurabilityTestUtils$.MODULE$.mockLog(x$28, (scala.collection.immutable.Seq<LogSegment>)localSegments, (scala.collection.immutable.Seq<TierLogSegment>)tierSegments, (Option<scala.collection.immutable.Seq<TierLogSegment>>)x$32, (Option<Object>)x$33, (Option<Object>)x$31, x$34, x$35, (Option<TierPartitionState>)x$36, (Option<Uuid>)x$37);
        this.initializeLogManager(mLog);
        this.auditJob_$eq(new BrokerAuditJob(this.partitionTuple(), this.logManager(), new CountDownLatch(1), this.simpleReporter(), this.simpleAuditSummary(), this.jobId(), (Option)new Some((Object)this.objStore()), (Time)this.time(), this.auditsAllowed(), this.auditConfig(), this.db(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        AuditJobResult auditResult = this.auditJob().doAuditSafely(mLog, this.dbConfig());
        Assertions.assertEquals((long)36L, (long)auditResult.totalOffsetCount());
        Assertions.assertEquals((long)0L, (long)auditResult.totalGapCount());
        Assertions.assertEquals((long)0L, (long)((DurabilityMetricsManager.LostMessage)this.durabilityMetricMgr().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.PeriodicalAudit())).count());
        Assertions.assertTrue((boolean)this.auditJob().isComplete());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencedMessages() {
        void apply_topicPartitionsMap;
        void apply_onCompleteSignaller;
        TopicIdPartition topicIdPartition = new TopicIdPartition("test-topic", UUID.randomUUID(), 0);
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitEvent1 = new TierSegmentUploadInitiate(topicIdPartition, 1, objectId1, 0L, 100L, 10L, 2L, 100, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        ConsumerRecord record1_1 = new ConsumerRecord("_confluent-tier-state", 0, 0L, (Object)uploadInitEvent1.serializeKey(), (Object)uploadInitEvent1.serializeValue());
        TierSegmentUploadComplete uploadCompleteEvent1 = new TierSegmentUploadComplete(uploadInitEvent1);
        ConsumerRecord record1_2 = new ConsumerRecord("_confluent-tier-state", 0, 0L, (Object)uploadCompleteEvent1.serializeKey(), (Object)uploadCompleteEvent1.serializeValue());
        TierSegmentUploadInitiate uploadInitEvent2 = new TierSegmentUploadInitiate(topicIdPartition, 1, objectId2, 100L, 200L, 10L, 2L, 100, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        ConsumerRecord record2_1 = new ConsumerRecord("_confluent-tier-state", 0, 0L, (Object)uploadInitEvent2.serializeKey(), (Object)uploadInitEvent2.serializeValue());
        TierTopicInitLeader tierInitEvent = new TierTopicInitLeader(topicIdPartition, 2, UUID.randomUUID(), 0);
        ConsumerRecord record3 = new ConsumerRecord("_confluent-tier-state", 0, 0L, (Object)tierInitEvent.serializeKey(), (Object)tierInitEvent.serializeValue());
        TierSegmentUploadComplete uploadCompleteEvent2 = new TierSegmentUploadComplete(uploadInitEvent2);
        ConsumerRecord record2_2 = new ConsumerRecord("_confluent-tier-state", 0, 0L, (Object)uploadCompleteEvent2.serializeKey(), (Object)uploadCompleteEvent2.serializeValue());
        Map tierEpochMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)BoxesRunTime.boxToLong((long)DurabilityAuditConstants$.MODULE$.TIER_TOPIC_INITIAL_SEEK()))}));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        DurabilityAuditConfig apply_config = this.auditConfig();
        Object var19_17 = null;
        countDownLatch = null;
        map = null;
        DurabilityTierTopicReader reader = new DurabilityTierTopicReader(apply_config, (CountDownLatch)apply_onCompleteSignaller, (scala.collection.immutable.Map)apply_topicPartitionsMap);
        HashMap<TopicPartition, java.util.List<ConsumerRecord>> records = new HashMap<TopicPartition, java.util.List<ConsumerRecord>>();
        ConsumerRecords consumerRecords = new ConsumerRecords(records);
        records.put(this.topicPartition(), Arrays.asList(record1_1, record1_2, record2_1, record3, record2_2));
        Map events = reader.filterCompactionMessage(consumerRecords, tierEpochMap);
        Assertions.assertEquals((int)1, (int)((TierTopicEvents)events.get((Object)topicIdPartition).get()).uploadMessages().size());
        Assertions.assertEquals((int)2, (int)((TierTopicEvents)events.get((Object)topicIdPartition).get()).uploadInitMessages().size());
        Assertions.assertEquals((int)0, (int)((TierTopicEvents)events.get((Object)topicIdPartition).get()).commitAndSwapMessages().size());
    }

    public static final /* synthetic */ void $anonfun$testSimpleTieredOffsetScan$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testGapBetweenTieredEndOffsetAndLogEndOffset$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testObjectStoreSegmentLoss$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierCompactedObjectLoss$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierCompactedTopicValidates$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testEndToEndRun$2(BrokerAuditJobTest $this, TierLogSegment tierSegment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(tierSegment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testEndToEndRun$3(BrokerAuditJobTest $this, long expectedGapCount$1, long expectedTotalMsgCount$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            OffsetCount offsetCount = $this.simpleReporter().getDurabilityCounters(topicPartition);
            Assertions.assertEquals((long)expectedGapCount$1, (long)offsetCount.loss(), (String)new StringBuilder(19).append("Incorrect gap for: ").append(topicPartition).toString());
            Assertions.assertEquals((long)expectedTotalMsgCount$1, (long)offsetCount.total(), (String)new StringBuilder(21).append("Incorrect total for: ").append(topicPartition).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testOffsetGapBetweenTierAndLocalLog$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierOffsetGapRetries$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testNonAlignedSegments$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testCompactedTopicChangedToDelete$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testChecksumDisableTest$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testSizeMismatch$1(TierObjectStore objectStoreSpy$1, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), objectStoreSpy$1);
    }

    public static final /* synthetic */ void $anonfun$testInvalidSizeMismatch$1(TierObjectStore objectStoreSpy$2, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), objectStoreSpy$2);
    }

    public static final /* synthetic */ void $anonfun$testSimpleCompactionValidation$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testSimpleCompactionValidation_Scenario1$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testSimpleCompactionValidation_Scenario2$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testSimpleCompactionValidation_Scenario3$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testMissingSegmentInCompaction$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTieredValidationsSkippedOnFollowers$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testLocalLogStartGapDetectedOnFollowers$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testObjectStoreCompactedSegments$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public static final /* synthetic */ void $anonfun$testTierLocalSegmentsGap$1(BrokerAuditJobTest $this, TierLogSegment segment) {
        TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(segment), $this.objStore());
    }

    public BrokerAuditJobTest() {
        this.jobId = 0;
    }
}

