/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability;

import java.io.Serializable;
import java.util.Collections;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityStats;
import kafka.durability.DurabilityTestUtils$;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.utils.MockTime;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001B\u000f\u001f\u0001\rBQA\u000b\u0001\u0005\u0002-B\u0011B\f\u0001A\u0002\u0003\u0007I\u0011B\u0018\t\u0013u\u0002\u0001\u0019!a\u0001\n\u0013q\u0004\"\u0003#\u0001\u0001\u0004\u0005\t\u0015)\u00031\u0011%)\u0005\u00011AA\u0002\u0013%a\tC\u0005M\u0001\u0001\u0007\t\u0019!C\u0005\u001b\"Iq\n\u0001a\u0001\u0002\u0003\u0006Ka\u0012\u0005\n!\u0002\u0001\r\u00111A\u0005\nEC\u0011\"\u0016\u0001A\u0002\u0003\u0007I\u0011\u0002,\t\u0013a\u0003\u0001\u0019!A!B\u0013\u0011\u0006\"C-\u0001\u0001\u0004\u0005\r\u0011\"\u0003[\u0011%y\u0006\u00011AA\u0002\u0013%\u0001\rC\u0005c\u0001\u0001\u0007\t\u0011)Q\u00057\"I1\r\u0001a\u0001\u0002\u0004%I\u0001\u001a\u0005\nQ\u0002\u0001\r\u00111A\u0005\n%D\u0011b\u001b\u0001A\u0002\u0003\u0005\u000b\u0015B3\t\u000f1\u0004!\u0019!C\u0005[\"1\u0011\u0010\u0001Q\u0001\n9DQA\u001f\u0001\u0005\u0002mDa!a\u0004\u0001\t\u0003Y\bBBA\r\u0001\u0011\u00051\u0010\u0003\u0004\u0002\u001e\u0001!\ta\u001f\u0005\u0007\u0003C\u0001A\u0011A>\t\r\u0005\u0015\u0002\u0001\"\u0001|\u0011\u0019\tI\u0003\u0001C\u0001w\"1\u0011Q\u0006\u0001\u0005\u0002mDq!!\r\u0001\t\u0013\t\u0019\u0004C\u0004\u0002<\u0001!I!!\u0010\u00039\u0011+(/\u00192jY&$\u00180T3ue&\u001c7/T1oC\u001e,'\u000fV3ti*\u0011q\u0004I\u0001\u000bIV\u0014\u0018MY5mSRL(\"A\u0011\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\n\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0003CA\u0017\u0001\u001b\u0005q\u0012\u0001\u0002;j[\u0016,\u0012\u0001\r\t\u0003cmj\u0011A\r\u0006\u0003gQ\nQ!\u001e;jYNT!!\u000e\u001c\u0002\r\r|W.\\8o\u0015\t\tsG\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<\u0017B\u0001\u001f3\u0005\u0011!\u0016.\\3\u0002\u0011QLW.Z0%KF$\"a\u0010\"\u0011\u0005\u0015\u0002\u0015BA!'\u0005\u0011)f.\u001b;\t\u000f\r\u001b\u0011\u0011!a\u0001a\u0005\u0019\u0001\u0010J\u0019\u0002\u000bQLW.\u001a\u0011\u0002\u000f5,GO]5dgV\tq\t\u0005\u0002I\u00156\t\u0011J\u0003\u0002Fi%\u00111*\u0013\u0002\b\u001b\u0016$(/[2t\u0003-iW\r\u001e:jGN|F%Z9\u0015\u0005}r\u0005bB\"\u0007\u0003\u0003\u0005\raR\u0001\t[\u0016$(/[2tA\u0005\u0011Q.\\\u000b\u0002%B\u0011QfU\u0005\u0003)z\u0011\u0001\u0004R;sC\nLG.\u001b;z\u001b\u0016$(/[2t\u001b\u0006t\u0017mZ3s\u0003\u0019iWn\u0018\u0013fcR\u0011qh\u0016\u0005\b\u0007&\t\t\u00111\u0001S\u0003\riW\u000eI\u0001\u0003iB,\u0012a\u0017\t\u00039vk\u0011\u0001N\u0005\u0003=R\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0004ua~#S-\u001d\u000b\u0003\u007f\u0005Dqa\u0011\u0007\u0002\u0002\u0003\u00071,A\u0002ua\u0002\nq\u0003^8uC2dun\u001d;NKN\u001c\u0018mZ3t\u001b\u0016$(/[2\u0016\u0003\u0015\u0004\"\u0001\u00184\n\u0005\u001d$$AC'fiJL7MT1nK\u0006YBo\u001c;bY2{7\u000f^'fgN\fw-Z:NKR\u0014\u0018nY0%KF$\"a\u00106\t\u000f\r{\u0011\u0011!a\u0001K\u0006ABo\u001c;bY2{7\u000f^'fgN\fw-Z:NKR\u0014\u0018n\u0019\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012A\u001c\t\u0003_Zt!\u0001\u001d;\u0011\u0005E4S\"\u0001:\u000b\u0005M\u0014\u0013A\u0002\u001fs_>$h(\u0003\u0002vM\u00051\u0001K]3eK\u001aL!a\u001e=\u0003\rM#(/\u001b8h\u0015\t)h%A\u0005ce>\\WM]%eA\u0005)1/\u001a;VaR\tq\b\u000b\u0002\u0014{B\u0019a0a\u0003\u000e\u0003}TA!!\u0001\u0002\u0004\u0005\u0019\u0011\r]5\u000b\t\u0005\u0015\u0011qA\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tI!O\u0001\u0006UVt\u0017\u000e^\u0005\u0004\u0003\u001by(A\u0003\"fM>\u0014X-R1dQ\u0006\u00113/\u001e2DCR,wm\u001c:z\u0019>\u001cH/T3tg\u0006<Wm]'fiJL7m\u001d+fgRD3\u0001FA\n!\rq\u0018QC\u0005\u0004\u0003/y(\u0001\u0002+fgR\f1\"\\3ue&\u001c7\u000fV3ti\"\u001aQ#a\u0005\u0002-5,GO]5dg\u0016C\bo\\:f\t\u0016d\u0017-\u001f+fgRD3AFA\n\u0003YiW\r\u001e:jGNDU-\u00197uQ\u000eCWmY6UKN$\bfA\f\u0002\u0014\u0005\tC/Z:u\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7.\u00168iK\u0006dG\u000f[=Ge>l7\u000b^1si\"\u001a\u0001$a\u0005\u0002UQ,7\u000f\u001e%fC2$\bn\u00115fG.lU\r\u001e:jG^C\u0017\u000e\\3DYV\u001cH/\u001a:Jg\"+\u0017\r\u001c;is\"\u001a\u0011$a\u0005\u0002YQ,7\u000f\u001e%fC2$\bn\u00115fG.lU\r\u001e:jG^C\u0017\u000e\\3DYV\u001cH/\u001a:JgVs\u0007.Z1mi\"L\bf\u0001\u000e\u0002\u0014\u0005Ac-\u001a;dQ>;h\u000eS\"NKR\u0014\u0018nY!oI\u0006\u001b8/\u001a:u\u001f:d\u0017p\u00148f\u0011\u000ekU\r\u001e:jGR\u0011\u0011Q\u0007\t\u0004\u0011\u0006]\u0012bAA\u001d\u0013\nY1*\u00194lC6+GO]5d\u0003=1\u0017\u000e\u001c;fe\"\u001bU*\u001a;sS\u000e\u001cH\u0003BA \u0003\u000b\u0002B!JA!K&\u0019\u00111\t\u0014\u0003\u000b\u0005\u0013(/Y=\t\u000b\u0015c\u0002\u0019A$")
public class DurabilityMetricsManagerTest {
    private Time time;
    private Metrics metrics;
    private DurabilityMetricsManager mm;
    private TopicPartition tp;
    private MetricName totalLostMessagesMetric;
    private final String brokerId;

    private Time time() {
        return this.time;
    }

    private void time_$eq(Time x$1) {
        this.time = x$1;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private DurabilityMetricsManager mm() {
        return this.mm;
    }

    private void mm_$eq(DurabilityMetricsManager x$1) {
        this.mm = x$1;
    }

    private TopicPartition tp() {
        return this.tp;
    }

    private void tp_$eq(TopicPartition x$1) {
        this.tp = x$1;
    }

    private MetricName totalLostMessagesMetric() {
        return this.totalLostMessagesMetric;
    }

    private void totalLostMessagesMetric_$eq(MetricName x$1) {
        this.totalLostMessagesMetric = x$1;
    }

    private String brokerId() {
        return this.brokerId;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq((Time)new MockTime());
        this.metrics_$eq(new Metrics(new MetricConfig(), Collections.emptyList(), this.time()));
        String x$1 = this.brokerId();
        Metrics x$2 = this.metrics();
        Time x$3 = this.time();
        long x$5 = DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS();
        boolean apply_controllerMode = false;
        this.mm_$eq(new DurabilityMetricsManager(x$1, x$2, x$3, x$5, apply_controllerMode));
        this.tp_$eq(new TopicPartition("test", 0));
        this.totalLostMessagesMetric_$eq(DurabilityTestUtils$.MODULE$.metricName(DurabilityMetricsManager.MetricNames$.MODULE$.TotalBrokerLostMessages(), this.metrics()));
    }

    @Test
    public void subCategoryLostMessagesMetricsTest() {
        MetricName hwMetrics = DurabilityTestUtils$.MODULE$.metricNameWithTag(DurabilityMetricsManager.MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics());
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.HighWatermark(), 15L);
        Assertions.assertEquals((long)this.mm().totalLostMessages(), (long)15L, (String)"Variable totalLostMessages not set to 15");
        Assertions.assertEquals((long)((DurabilityMetricsManager.LostMessage)this.mm().lostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.HighWatermark())).count(), (long)15L, (String)"Variable highWatermarkLostMessages not set to 15");
        Assertions.assertEquals((Object)this.metrics().metric(hwMetrics).metricValue(), (Object)BoxesRunTime.boxToLong((long)15L), (String)"Metrics value is not 15, same as totalLostMessages");
        this.mm().resetDurabilityRunSpan(10);
        this.mm().totalLostMessages_$eq(0L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.HighWatermark(), 1L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.StartOffset(), 10L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.EpochChange(), 100L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.NonCustomerFacing(), 1000L);
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(DurabilityMetricsManager.MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(DurabilityMetricsManager.MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.StartOffset().toString(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)10L));
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(DurabilityMetricsManager.MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.EpochChange().toString(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)100L));
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(DurabilityMetricsManager.MetricNames$.MODULE$.TotalBrokerLostMessages(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)0L));
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(DurabilityMetricsManager.MetricNames$.MODULE$.TotalBrokerLostMessages(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)1111L));
        Assertions.assertEquals((int)2, (int)DurabilityTestUtils$.MODULE$.metricNameWithTag(DurabilityMetricsManager.MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics()).tags().size(), (String)"Tag count for 'high_watermark_lost_messages' metrics is not 2");
        Assertions.assertEquals(DurabilityTestUtils$.MODULE$.metricNameWithTag(DurabilityMetricsManager.MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics()).tags().get("durability_run_counter"), (Object)"10", (String)"Metrics 'high_watermark_lost_messages' should have a tag 'durability_run_counter' with a value of '10'");
        Assertions.assertEquals(DurabilityTestUtils$.MODULE$.metricNameWithTag(DurabilityMetricsManager.MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics()).tags().get("durability_lapse_type"), (Object)DurabilityLapseType$.MODULE$.HighWatermark().toString(), (String)"Metrics 'high_watermark_lost_messages' should have a tag 'durability_lapse_type' with a value of 'HighWatermark'");
    }

    @Test
    public void metricsTest() {
        Assertions.assertEquals((int)22, (int)this.metrics().metrics().size(), (String)"Expected metrics count is 22");
        Assertions.assertEquals((int)0, (int)DurabilityTestUtils$.MODULE$.metricName("total_lost_messages", this.metrics()).tags().size(), (String)"Metrics 'total_lost_messages' should not have any tags");
        this.mm().reportDurabilityLoss(15L);
        Assertions.assertEquals((long)15L, (long)this.mm().totalLostMessages(), (String)"Variable totalLostMessages not set to 15");
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)15L), (Object)this.metrics().metric(this.totalLostMessagesMetric()).metricValue(), (String)"Metrics value is not 15, same as totalLostMessages");
        this.mm().reportDurabilityLoss(20L);
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS() * 1L / 4L);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)15L), (Object)this.metrics().metric(this.totalLostMessagesMetric()).metricValue(), (String)"Metrics value is not 15, same as totalLostMessages");
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS() * 3L / 4L);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)35L), (Object)this.metrics().metric(this.totalLostMessagesMetric()).metricValue(), (String)"Metrics value is not 35, same as totalLostMessages");
        this.mm().resetDurabilityRunSpan(5);
        Assertions.assertEquals((int)(17 + this.mm().lostMessageMetricsMap().size()), (int)this.metrics().metrics().size(), (String)new StringBuilder(32).append("Total registered metrics is not ").append(17 + this.mm().lostMessageMetricsMap().size()).toString());
        Assertions.assertEquals((int)1, (int)DurabilityTestUtils$.MODULE$.metricName(DurabilityMetricsManager.MetricNames$.MODULE$.TotalMessages(), this.metrics()).tags().size(), (String)"Tag count for 'total_messages' metrics is not 1");
        Assertions.assertEquals((int)2, (int)DurabilityTestUtils$.MODULE$.metricName(DurabilityMetricsManager.MetricNames$.MODULE$.ExternalLostMessages(), this.metrics()).tags().size(), (String)"Tag count for 'external_lost_messages' metrics is not 2");
        this.mm().updateStats(this.tp(), new DurabilityStats(1000L, 50L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(DurabilityMetricsManager.MetricNames$.MODULE$.TotalMessages(), this.metrics())).metricValue(), (String)"Metrics value for 'total_messages' should not be updated before job completion");
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(DurabilityMetricsManager.MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.PeriodicalAudit().toString(), this.metrics())).metricValue(), (String)"Metrics value for 'external_lost_messages' should not be updated before job completion");
        this.mm().resetDurabilityRunSpan(10);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1000L), (Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(DurabilityMetricsManager.MetricNames$.MODULE$.TotalMessages(), this.metrics())).metricValue(), (String)"Metrics value for 'total_messages' is not 1000");
        this.mm().resetDurabilityRunSpan(15);
        this.mm().updateStats(this.tp(), new DurabilityStats(2000L, 25L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(DurabilityMetricsManager.MetricNames$.MODULE$.TotalMessages(), this.metrics())).metricValue(), (String)"Metrics value for 'total_messages' has not reset to 0");
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(DurabilityMetricsManager.MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.PeriodicalAudit().toString(), this.metrics())).metricValue(), (String)"Metrics value for 'external_lost_messages' should not be updated before job completion");
        this.mm().resetDurabilityRunSpan(30);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)2000L), (Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(DurabilityMetricsManager.MetricNames$.MODULE$.TotalMessages(), this.metrics())).metricValue(), (String)"Metrics value for 'total_messages' is not 2000 after job completion.");
    }

    @Test
    public void metricsExposeDelayTest() {
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)this.metrics().metric(this.totalLostMessagesMetric()).metricValue(), (String)"Metrics value is not 0, same as totalLostMessages");
        this.mm().reportDurabilityLoss(10L);
        this.mm().reportDurabilityLoss(20L);
        this.mm().reportDurabilityLoss(30L);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)this.metrics().metric(this.totalLostMessagesMetric()).metricValue(), (String)"Metrics value is not 0, same as totalLostMessages");
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)60L), (Object)this.metrics().metric(this.totalLostMessagesMetric()).metricValue(), (String)"Metrics value is not 60, same as totalLostMessages");
    }

    @Test
    public void metricsHealthCheckTest() {
        String brokerId2 = "3";
        Assertions.assertEquals((int)1, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])this.filterHCMetrics(this.metrics()))), (String)"DurabilityMetricManager should instantiate health check for host broker");
        long t0 = this.time().milliseconds();
        this.mm().updateHealthCheck(this.brokerId(), t0);
        KafkaMetric hcMetrics = this.metrics().metric(this.filterHCMetrics(this.metrics())[0]);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)this.brokerId(), hcMetrics.metricName().tags().get("broker_src"));
        this.time().sleep(5L);
        long t1 = this.time().milliseconds();
        this.mm().updateHealthCheck(brokerId2, t1);
        hcMetrics = this.metrics().metric(this.filterHCMetrics(this.metrics())[1]);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)brokerId2, hcMetrics.metricName().tags().get("broker_src"));
        this.time().sleep(10L);
        long t2 = this.time().milliseconds();
        this.mm().updateHealthCheck(brokerId2, t2);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)brokerId2, hcMetrics.metricName().tags().get("broker_src"));
        this.mm().updateHealthCheck(this.brokerId(), t2);
        this.mm().updateHealthCheck(brokerId2, t1);
        hcMetrics = this.metrics().metric(this.filterHCMetrics(this.metrics())[0]);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)this.brokerId(), hcMetrics.metricName().tags().get("broker_src"));
        hcMetrics = this.metrics().metric(this.filterHCMetrics(this.metrics())[1]);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)brokerId2, hcMetrics.metricName().tags().get("broker_src"));
    }

    @Test
    public void testHealthCheckUnhealthyFromStart() {
        KafkaMetric ownHCMetric = this.fetchOwnHCMetricAndAssertOnlyOneHCMetric();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)ownHCMetric.metricValue(), (String)"updateHealthCheck has not yet been called, but broker's own health check metric does not return 0.");
    }

    @Test
    public void testHealthCheckMetricWhileClusterIsHealthy() {
        this.mm().updateHealthCheck(this.brokerId(), this.time().milliseconds());
        KafkaMetric ownHCMetric = this.fetchOwnHCMetricAndAssertOnlyOneHCMetric();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)ownHCMetric.metricValue(), (String)"updateHealthCheck was called 0 ms ago, but broker's own health check does not return 1.");
        this.time().sleep(DurabilityAuditConstants$.MODULE$.HEALTH_CHECK_UPDATE_TIME_MS());
        this.time().sleep(DurabilityAuditConstants$.MODULE$.HEALTH_CHECK_ALERT_BUFFER_TIME_MS() / 2L);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)ownHCMetric.metricValue(), (String)"updateHealthCheck was called within the past HEALTH_CHECK_UPDATE_TIME + HEALTH_CHECK_ALERT_BUFFER_TIME milliseconds, but does not return 1.");
        this.mm().updateHealthCheck(this.brokerId(), this.time().milliseconds());
        this.time().sleep(DurabilityAuditConstants$.MODULE$.HEALTH_CHECK_ALERT_BUFFER_TIME_MS());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)ownHCMetric.metricValue(), (String)"updateHealthCheck was called within the past HEALTH_CHECK_UPDATE_TIME + HEALTH_CHECK_ALERT_BUFFER_TIME milliseconds, but does not return 1.");
    }

    @Test
    public void testHealthCheckMetricWhileClusterIsUnhealthy() {
        this.mm().updateHealthCheck(this.brokerId(), this.time().milliseconds());
        KafkaMetric ownHCMetric = this.fetchOwnHCMetricAndAssertOnlyOneHCMetric();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)ownHCMetric.metricValue(), (String)"updateHealthCheck was called 0 ms ago, but broker's own health check does not return 1.");
        this.time().sleep(DurabilityAuditConstants$.MODULE$.HEALTH_CHECK_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)ownHCMetric.metricValue(), (String)"updateHealthCheck was called HEALTH_CHECK_UPDATE_TIME ago, but broker's own health check does not return 1 (health check is not allowing for alert buffer).");
        this.time().sleep(DurabilityAuditConstants$.MODULE$.HEALTH_CHECK_ALERT_BUFFER_TIME_MS() + 1L);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)ownHCMetric.metricValue(), (String)"updateHealthCheck was last called more than HEALTH_CHECK_UPDATE_TIME + HEALTH_CHECK_ALERT_BUFFER_TIME milliseconds ago, but broker's own health check does not return 0.");
    }

    private KafkaMetric fetchOwnHCMetricAndAssertOnlyOneHCMetric() {
        Assertions.assertEquals((int)1, (int)this.filterHCMetrics(this.metrics()).length, (String)"number of health check metrics is not 1");
        MetricName ownHCMetricName = this.filterHCMetrics(this.metrics())[0];
        Assertions.assertTrue((boolean)((String)ownHCMetricName.tags().get("broker_src")).equals(this.brokerId()), (String)new StringBuilder(70).append("The one health check metric ").append("present is not for our own broker, broker ").append(this.brokerId()).toString());
        return this.metrics().metric(ownHCMetricName);
    }

    private MetricName[] filterHCMetrics(Metrics metrics) {
        return (MetricName[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(metrics.metrics().keySet().toArray()), (Function1 & Serializable)x$6 -> (MetricName)x$6, ClassTag$.MODULE$.apply(MetricName.class))), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DurabilityMetricsManagerTest.$anonfun$filterHCMetrics$2(x$7)));
    }

    public static final /* synthetic */ boolean $anonfun$filterHCMetrics$2(MetricName x$7) {
        return x$7.name().equals(DurabilityMetricsManager.MetricNames$.MODULE$.HealthCheck());
    }

    public DurabilityMetricsManagerTest() {
        this.brokerId = "0";
    }
}

