/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaConfig$;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.$less$colon$less$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001\u0002\u0005\n\u0001AAQa\u0006\u0001\u0005\u0002aAQa\u0007\u0001\u0005\u0002qAQ!\u000e\u0001\u0005\u0002YBQ!\u001b\u0001\u0005\u0002)DQa\u001d\u0001\u0005\u0002QDQ! \u0001\u0005\nyDq!!\u0001\u0001\t\u0013\t\u0019A\u0001\u000eQe>$WoY3s\u0013\u0012\u001c\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u000b\u0017\u0005YAO]1og\u0006\u001cG/[8o\u0015\taQ\"A\u0006d_>\u0014H-\u001b8bi>\u0014(\"\u0001\b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005I\u0011!B:fiV\u0004HCA\u000f!!\t\u0011b$\u0003\u0002 '\t!QK\\5u\u0011\u0015\t#\u00011\u0001#\u00035\u0019G.^:uKJ\u001cuN\u001c4jOB\u00111EJ\u0007\u0002I)\u0011Q%D\u0001\u0005i\u0016\u001cH/\u0003\u0002(I\ti1\t\\;ti\u0016\u00148i\u001c8gS\u001eD#AA\u0015\u0011\u0005)\u001aT\"A\u0016\u000b\u00051j\u0013aA1qS*\u0011afL\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0001\u0014'A\u0003kk:LGOC\u00013\u0003\ry'oZ\u0005\u0003i-\u0012!BQ3g_J,W)Y2i\u0003U!Xm\u001d;V]&\fX/\u001a)s_\u0012,8-\u001a:JIN$\"!H\u001c\t\u000ba\u001a\u0001\u0019A\u001d\u0002\u001f\rdWo\u001d;fe&s7\u000f^1oG\u0016\u0004\"a\t\u001e\n\u0005m\"#aD\"mkN$XM]%ogR\fgnY3)\t\ri4\t\u0012\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u0012\n!\"\u00198o_R\fG/[8o\u0013\t\u0011uH\u0001\u0007DYV\u001cH/\u001a:UKN$8/A\u0003wC2,X\rL\u0002F=\n\\sAR%K\u001fB\u000b&\u000b\u0005\u0002?\u000f&\u0011\u0001j\u0010\u0002\f\u00072,8\u000f^3s)\u0016\u001cH/A\u0006dYV\u001cH/\u001a:UsB,G%A&\n\u00051k\u0015A\u0001.L\u0015\tqu(\u0001\u0003UsB,\u0017a\u00022s_.,'o]\u000f\u0002\u0007\u0005yQ.\u001a;bI\u0006$\u0018MV3sg&|g\u000eJ\u0001T\u0013\t!V+A\u0006J\u0005B{&g\u0018\u001d`\u0013Z\u000b$B\u0001,X\u0003=iU\r^1eCR\fg+\u001a:tS>t'B\u0001-Z\u0003\u0019\u0019w.\\7p]*\u0011!lW\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00059a&BA/2\u0003\u0019\t\u0007/Y2iK.:a)\u0013&P!F{F%\u00011\n\u0005\u0005,\u0016aC%C!~\u001bt\fM0J-BZsAR%d\u001fB\u000bf\rJ\u0001e\u0013\t)W*A\u0003L%\u00063E\u000bJ\u0001h\u0013\tAW+A\u0006J\u0005B{6gX\u001a`\u0013Z\u0003\u0014\u0001\b;fgR,f.[9vKB\u0013x\u000eZ;dKJLEm\u001d\"v[BL%\t\u0015\u000b\u0003;-DQ\u0001\u000f\u0003A\u0002eB\u0003\u0002\u0002$J\u0015>\u0003VN\\\u0001\nCV$xn\u0015;beR$\u0013a\\\u0005\u0003aF\f!AT(\u000b\u0005I|\u0014!C!vi>\u001cF/\u0019:u\u0003]\"Xm\u001d;IC:$G.Z!mY>\u001c\u0017\r^3Qe>$WoY3s\u0013\u0012\u001c8+\u001b8hY\u0016\u0014V-];fgRD\u0015M\u001c3mKJ$\u0006N]3bIR\u0011Q$\u001e\u0005\u0006q\u0015\u0001\r!\u000f\u0015\u0005\u000b]\u001c%\u0010\u0005\u0002+q&\u0011\u0011p\u000b\u0002\b)&lWm\\;u=\u0005!\u0002\u0006C\u0003G\u0013*{E0\u001c8\u001e\u0003\u0005\tqB^3sS\u001aLXK\\5rk\u0016LEm\u001d\u000b\u0003;}DQ\u0001\u000f\u0004A\u0002e\naB\\3yiB\u0013x\u000eZ;dKJLE\r\u0006\u0004\u0002\u0006\u0005-\u00111\u0004\t\u0004%\u0005\u001d\u0011bAA\u0005'\t!Aj\u001c8h\u0011\u001d\tia\u0002a\u0001\u0003\u001f\taA\u0019:pW\u0016\u0014\b\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005UQ\"A\u0004oKR<xN]6\n\t\u0005e\u00111\u0003\u0002\r'>\u001c7.\u001a;TKJ4XM\u001d\u0005\b\u0003;9\u0001\u0019AA\u0010\u0003!a\u0017n\u001d;f]\u0016\u0014\b\u0003BA\u0011\u0003Oi!!a\t\u000b\t\u0005U\u0011Q\u0005\u0006\u00031nKA!!\u000b\u0002$\taA*[:uK:,'OT1nK\"2\u0001!!\fD\u0003s\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003gY\u0013!C3yi\u0016t7/[8o\u0013\u0011\t9$!\r\u0003\u0015\u0015CH/\u001a8e/&$\b\u000e\f\u0002\u0002<\r\u0012\u0011Q\b\t\u0005\u0003\u007f\t\u0019%\u0004\u0002\u0002B)\u0011\u0001\u0007J\u0005\u0005\u0003\u000b\n\tEA\u000bDYV\u001cH/\u001a:UKN$X\t\u001f;f]NLwN\\:")
public class ProducerIdsIntegrationTest {
    @BeforeEach
    public void setup(ClusterConfig clusterConfig) {
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), "1");
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "3");
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_2_8_IV1), @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_0_IV0), @ClusterTest(clusterType=Type.KRAFT, brokers=3, metadataVersion=MetadataVersion.IBP_3_3_IV0)})
    public void testUniqueProducerIds(ClusterInstance clusterInstance) {
        this.verifyUniqueIds(clusterInstance);
    }

    @ClusterTest(clusterType=Type.ZK, brokers=3, autoStart=AutoStart.NO)
    public void testUniqueProducerIdsBumpIBP(ClusterInstance clusterInstance) {
        clusterInstance.config().serverProperties().put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.8");
        clusterInstance.config().brokerServerProperties(0).put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "3.0-IV0");
        clusterInstance.start();
        this.verifyUniqueIds(clusterInstance);
        clusterInstance.stop();
    }

    @ClusterTest(clusterType=Type.ZK, brokers=1, autoStart=AutoStart.NO)
    @Timeout(value=20L)
    public void testHandleAllocateProducerIdsSingleRequestHandlerThread(ClusterInstance clusterInstance) {
        clusterInstance.config().serverProperties().put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "1");
        clusterInstance.start();
        this.verifyUniqueIds(clusterInstance);
        clusterInstance.stop();
    }

    private void verifyUniqueIds(ClusterInstance clusterInstance) {
        Seq ids = CollectionConverters$.MODULE$.ListHasAsScala(clusterInstance.brokerSocketServers().stream().flatMap(broker -> IntStream.range(0, 1001).parallel().mapToObj(x$1 -> BoxesRunTime.boxToLong((long)this.nextProducerId(broker, clusterInstance.clientListener())))).collect(Collectors.toList())).asScala().toSeq();
        int brokerCount = clusterInstance.brokerIds().size();
        int expectedTotalCount = 1001 * brokerCount;
        Assertions.assertEquals((int)expectedTotalCount, (int)ids.size(), (String)new StringBuilder(21).append("Expected exactly ").append(expectedTotalCount).append(" IDs").toString());
        Assertions.assertEquals((int)expectedTotalCount, (int)((SeqOps)ids.distinct()).size(), (String)"Found duplicate producer IDs");
    }

    private long nextProducerId(SocketServer broker, ListenerName listener) {
        Deadline deadline = new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds().fromNow();
        boolean shouldRetry = true;
        InitProducerIdResponse response = null;
        while (shouldRetry && deadline.hasTimeLeft()) {
            InitProducerIdRequestData data = new InitProducerIdRequestData().setProducerEpoch((short)-1).setProducerId(-1L).setTransactionalId(null).setTransactionTimeoutMs(10);
            InitProducerIdRequest request = (InitProducerIdRequest)new InitProducerIdRequest.Builder(data).build();
            response = (InitProducerIdResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, broker, listener, ClassTag$.MODULE$.apply(InitProducerIdResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            shouldRetry = response.data().errorCode() == Errors.COORDINATOR_LOAD_IN_PROGRESS.code();
        }
        Assertions.assertTrue((boolean)deadline.hasTimeLeft());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode());
        return response.data().producerId();
    }
}

