/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.ProducerIdManagerTest$MockProducerIdManager$;
import kafka.coordinator.transaction.RPCProducerIdManager;
import kafka.coordinator.transaction.ZkProducerIdManager;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.CoordinatorLoadInProgressException;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dg\u0001\u0002\u0012$\u0001)BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004>\u0001\u0001\u0006Ia\u000e\u0004\u0005}\u0001\u0001q\b\u0003\u0005D\t\t\u0015\r\u0011\"\u0001E\u0011!AEA!A!\u0002\u0013)\u0005\u0002C%\u0005\u0005\u0003\u0007I\u0011\u0001&\t\u00119#!\u00111A\u0005\u0002=C\u0001\"\u0016\u0003\u0003\u0002\u0003\u0006Ka\u0013\u0005\t-\u0012\u0011)\u0019!C\u0001\t\"Aq\u000b\u0002B\u0001B\u0003%Q\t\u0003\u0005Y\t\t\u0005\r\u0011\"\u0001Z\u0011!9GA!a\u0001\n\u0003A\u0007\u0002\u00036\u0005\u0005\u0003\u0005\u000b\u0015\u0002.\t\u0011-$!\u00111A\u0005\u00021D\u0001\"\u001f\u0003\u0003\u0002\u0004%\tA\u001f\u0005\ty\u0012\u0011\t\u0011)Q\u0005[\")\u0011\u0007\u0002C\u0001{\"I\u00111\u0002\u0003C\u0002\u0013%\u0011Q\u0002\u0005\t\u0003/!\u0001\u0015!\u0003\u0002\u0010!A\u0011\u0011\u0004\u0003\u0005B\r\nYbB\u0005\u0002\u001e\u0001\t\t\u0011#\u0001\u0002 \u0019Aa\bAA\u0001\u0012\u0003\t\t\u0003\u0003\u00042/\u0011\u0005\u00111\u0005\u0005\n\u0003K9\u0012\u0013!C\u0001\u0003OA\u0011\"!\u0010\u0018#\u0003%\t!a\u0010\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002\u001c!9\u00111\f\u0001\u0005\u0002\u0005m\u0001bBA0\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\ti\u000b\u0001C\u0001\u00037Aq!!-\u0001\t\u0003\tY\u0002C\u0004\u00026\u0002!I!a.\u0003+A\u0013x\u000eZ;dKJLE-T1oC\u001e,'\u000fV3ti*\u0011A%J\u0001\fiJ\fgn]1di&|gN\u0003\u0002'O\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005A\u0013!B6bM.\f7\u0001A\n\u0003\u0001-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00014!\t!\u0004!D\u0001$\u0003!Q8n\u00117jK:$X#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005i:\u0013A\u0001>l\u0013\ta\u0014HA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\nu.\u001cE.[3oi\u0002\u0012Q#T8dWB\u0013x\u000eZ;dKJLE-T1oC\u001e,'o\u0005\u0002\u0005\u0001B\u0011A'Q\u0005\u0003\u0005\u000e\u0012AC\u0015)D!J|G-^2fe&#W*\u00198bO\u0016\u0014\u0018\u0001\u00032s_.,'/\u00133\u0016\u0003\u0015\u0003\"\u0001\f$\n\u0005\u001dk#aA%oi\u0006I!M]8lKJLE\rI\u0001\bS\u0012\u001cF/\u0019:u+\u0005Y\u0005C\u0001\u0017M\u0013\tiUF\u0001\u0003M_:<\u0017aC5e'R\f'\u000f^0%KF$\"\u0001U*\u0011\u00051\n\u0016B\u0001*.\u0005\u0011)f.\u001b;\t\u000fQC\u0011\u0011!a\u0001\u0017\u0006\u0019\u0001\u0010J\u0019\u0002\u0011%$7\u000b^1si\u0002\nQ!\u001b3MK:\fa!\u001b3MK:\u0004\u0013!B3se>\u0014X#\u0001.\u0011\u0005m+W\"\u0001/\u000b\u0005us\u0016\u0001\u00039s_R|7m\u001c7\u000b\u0005}\u0003\u0017AB2p[6|gN\u0003\u0002)C*\u0011!mY\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\f1a\u001c:h\u0013\t1GL\u0001\u0004FeJ|'o]\u0001\nKJ\u0014xN]0%KF$\"\u0001U5\t\u000fQk\u0011\u0011!a\u00015\u00061QM\u001d:pe\u0002\nQ\u0002^5nK>,HoU5h]\u0006dW#A7\u0011\u00059<X\"A8\u000b\u0005A\f\u0018AB1u_6L7M\u0003\u0002sg\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Q,\u0018\u0001B;uS2T\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u0002y_\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0011\u0003^5nK>,HoU5h]\u0006dw\fJ3r)\t\u00016\u0010C\u0004U!\u0005\u0005\t\u0019A7\u0002\u001dQLW.Z8viNKwM\\1mAQYa0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005!\tyH!D\u0001\u0001\u0011\u0015\u0019%\u00031\u0001F\u0011\u0015I%\u00031\u0001L\u0011\u00151&\u00031\u0001F\u0011\u001dA&\u0003%AA\u0002iCqa\u001b\n\u0011\u0002\u0003\u0007Q.\u0001\nce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014XCAA\b!\u0011\t\t\"a\u0005\u000e\u0003EL1!!\u0006r\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017a\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ\u0004\u0013aC:f]\u0012\u0014V-];fgR$\u0012\u0001U\u0001\u0016\u001b>\u001c7\u000e\u0015:pIV\u001cWM]%e\u001b\u0006t\u0017mZ3s!\tyxc\u0005\u0002\u0018WQ\u0011\u0011qD\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005%\"f\u0001.\u0002,-\u0012\u0011Q\u0006\t\u0005\u0003_\tI$\u0004\u0002\u00022)!\u00111GA\u001b\u0003%)hn\u00195fG.,GMC\u0002\u000285\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY$!\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003\u0003R3!\\A\u0016\u0003M!Xm\u001d;HKR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a.lQ\rY\u0012q\t\t\u0005\u0003\u0013\n9&\u0004\u0002\u0002L)!\u0011QJA(\u0003\r\t\u0007/\u001b\u0006\u0005\u0003#\n\u0019&A\u0004kkBLG/\u001a:\u000b\u0007\u0005U3-A\u0003kk:LG/\u0003\u0003\u0002Z\u0005-#\u0001\u0002+fgR\f1\u0004^3ti\u0016C8-Z3e!J|G-^2fe&#G*[7jij[\u0007f\u0001\u000f\u0002H\u0005\tB/Z:u\u0007>tG/[4v_V\u001c\u0018\nZ:\u0015\u0007A\u000b\u0019\u0007\u0003\u0004\u0002fu\u0001\r!R\u0001\u000bS\u0012\u0014En\\2l\u0019\u0016t\u0007fB\u000f\u0002j\u0005e\u00141\u0010\t\u0005\u0003W\n)(\u0004\u0002\u0002n)!\u0011qNA9\u0003!\u0001(o\u001c<jI\u0016\u0014(\u0002BA:\u0003\u001f\na\u0001]1sC6\u001c\u0018\u0002BA<\u0003[\u00121BV1mk\u0016\u001cv.\u001e:dK\u0006!\u0011N\u001c;tY\u0019\ti(a \u0002\u0002v\t\u0011!H\u0001\u0003;\u0005Q\u0001fA\u000f\u0002\u0006B!\u0011qQAE\u001b\t\t\t(\u0003\u0003\u0002\f\u0006E$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u00069B/Z:u+:\u0014XmY8wKJ\f'\r\\3FeJ|'o\u001d\u000b\u0004!\u0006E\u0005\"\u0002-\u001f\u0001\u0004Q\u0006f\u0003\u0010\u0002\u0016\u0006m\u0015QTAP\u0003C\u0003B!a\u001b\u0002\u0018&!\u0011\u0011TA7\u0005))e.^7T_V\u00148-Z\u0001\u0006m\u0006dW/Z\u0012\u00025\u0006)a.Y7fg2\"\u00111UATC\t\t)+\u0001\u000bV\u001d.suj\u0016(`'\u0016\u0013f+\u0012*`\u000bJ\u0013vJU\u0011\u0003\u0003S\u000bq\"\u0013(W\u00032KEi\u0018*F#V+5\u000b\u0016\u0015\u0004=\u0005\u0015\u0015!\u0005;fgRLeN^1mS\u0012\u0014\u0016M\\4fg\"\u001aq$a\u0012\u00029Q,7\u000f\u001e(fo\ncwnY6SKN,Go\u001d)s_\u0012,8-\u001a:JI\"\u001a\u0001%a\u0012\u00023Y,'/\u001b4z\u000f\u0016tWM]1uK\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\u0006!\u0006e\u00161\u0019\u0005\b\u0003w\u000b\u0003\u0019AA_\u0003\u001di\u0017M\\1hKJ\u00042\u0001NA`\u0013\r\t\tm\t\u0002\u0012!J|G-^2fe&#W*\u00198bO\u0016\u0014\bBBAcC\u0001\u00071*A\u0006fqB,7\r^3e!&$\u0007")
public class ProducerIdManagerTest {
    private volatile ProducerIdManagerTest$MockProducerIdManager$ MockProducerIdManager$module;
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);

    public ProducerIdManagerTest$MockProducerIdManager$ MockProducerIdManager() {
        if (this.MockProducerIdManager$module == null) {
            this.MockProducerIdManager$lzycompute$1();
        }
        return this.MockProducerIdManager$module;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    @Test
    public void testGetProducerIdZk() {
        ObjectRef zkVersion = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef data = ObjectRef.create(null);
        Mockito.when((Object)this.zkClient().getDataAndVersion(ArgumentMatchers.anyString())).thenAnswer(x$1 -> (Tuple2)((Option)zkVersion$1.elem).map((Function1 & Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)((byte[])data.elem))), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$2)))).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0))));
        ArgumentCaptor capturedVersion = ArgumentCaptor.forClass(Integer.TYPE);
        ArgumentCaptor capturedData = ArgumentCaptor.forClass(byte[].class);
        Mockito.when((Object)this.zkClient().conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])capturedData.capture(), BoxesRunTime.unboxToInt((Object)capturedVersion.capture()), (Option)ArgumentMatchers.any())).thenAnswer(x$3 -> {
            int newZkVersion = BoxesRunTime.unboxToInt((Object)capturedVersion.getValue()) + 1;
            zkVersion$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)newZkVersion));
            data$1.elem = (byte[])capturedData.getValue();
            return new Tuple2.mcZI.sp(true, newZkVersion);
        });
        ZkProducerIdManager manager1 = new ZkProducerIdManager(0, this.zkClient());
        ZkProducerIdManager manager2 = new ZkProducerIdManager(1, this.zkClient());
        long pid1 = manager1.generateProducerId();
        long pid2 = manager2.generateProducerId();
        Assertions.assertEquals((long)0L, (long)pid1);
        Assertions.assertEquals((long)1000L, (long)pid2);
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)1000L)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)i -> Assertions.assertEquals((long)(pid1 + i), (long)manager1.generateProducerId()));
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)1000L)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)i -> Assertions.assertEquals((long)(pid2 + i), (long)manager2.generateProducerId()));
        Assertions.assertEquals((long)(pid2 + 1000L), (long)manager1.generateProducerId());
        Assertions.assertEquals((long)(pid2 + 2000L), (long)manager2.generateProducerId());
    }

    @Test
    public void testExceedProducerIdLimitZk() {
        Mockito.when((Object)this.zkClient().getDataAndVersion(ArgumentMatchers.anyString())).thenAnswer(x$4 -> {
            byte[] json = ProducerIdBlockZNode$.MODULE$.generateProducerIdBlockJson(new ProducerIdsBlock(0, 9223372036854774807L, 1000));
            return new Tuple2((Object)new Some((Object)json), (Object)BoxesRunTime.boxToInteger((int)0));
        });
        Assertions.assertThrows(KafkaException.class, () -> new ZkProducerIdManager(0, this.zkClient()));
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 10})
    public void testContiguousIds(int idBlockLen) {
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, idBlockLen, Errors.NONE, null);
        IntStream.range(0, idBlockLen * 3).forEach(i -> this.verifyGeneratedProducerId((ProducerIdManager)manager, i));
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"UNKNOWN_SERVER_ERROR", "INVALID_REQUEST"})
    public void testUnrecoverableErrors(Errors error) {
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, 1, Errors.NONE, null);
        this.verifyGeneratedProducerId((ProducerIdManager)manager, 0L);
        manager.error_$eq(error);
        Assertions.assertThrows(Throwable.class, () -> manager.generateProducerId());
        manager.error_$eq(Errors.NONE);
        this.verifyGeneratedProducerId((ProducerIdManager)manager, 1L);
    }

    @Test
    public void testInvalidRanges() {
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        ObjectRef manager = ObjectRef.create((Object)((Object)new MockProducerIdManager(this, 0, -1L, 10, Errors.NONE, null)));
        Assertions.assertThrows(KafkaException.class, () -> ((MockProducerIdManager)((Object)((Object)manager$3.elem))).generateProducerId());
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        manager.elem = new MockProducerIdManager(this, 0, 0L, -1, Errors.NONE, null);
        Assertions.assertThrows(KafkaException.class, () -> ((MockProducerIdManager)((Object)((Object)manager$3.elem))).generateProducerId());
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        manager.elem = new MockProducerIdManager(this, 0, 0x7FFFFFFFFFFFFFFEL, 10, Errors.NONE, null);
        Assertions.assertThrows(KafkaException.class, () -> ((MockProducerIdManager)((Object)((Object)manager$3.elem))).generateProducerId());
    }

    @Test
    public void testNewBlockResetsProducerId() {
        AtomicBoolean timeoutSignal = new AtomicBoolean(false);
        if (this.MockProducerIdManager() == null) {
            throw null;
        }
        Errors x$52 = Errors.NONE;
        MockProducerIdManager manager = new MockProducerIdManager(this, 0, 0L, 10, x$52, timeoutSignal);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 12).foreach((Function1 & Serializable)x$5 -> ProducerIdManagerTest.$anonfun$testNewBlockResetsProducerId$1(manager, BoxesRunTime.unboxToInt((Object)x$5)));
        Assertions.assertEquals((long)11L, (long)manager.nextProducerId());
        timeoutSignal.set(true);
        this.verifyGeneratedProducerId((ProducerIdManager)manager, 0L);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyGeneratedProducerId(ProducerIdManager manager, long expectedPid) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProducerIdManagerTest.$anonfun$verifyGeneratedProducerId$1(manager, expectedPid)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ProducerIdManagerTest.$anonfun$verifyGeneratedProducerId$2(expectedPid));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private final void MockProducerIdManager$lzycompute$1() {
        synchronized (this) {
            if (this.MockProducerIdManager$module == null) {
                this.MockProducerIdManager$module = new ProducerIdManagerTest$MockProducerIdManager$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ CoordinatorLoadInProgressException $anonfun$testNewBlockResetsProducerId$1(MockProducerIdManager manager$4, int x$5) {
        return (CoordinatorLoadInProgressException)Assertions.assertThrows(CoordinatorLoadInProgressException.class, () -> manager$4.generateProducerId());
    }

    public static final /* synthetic */ boolean $anonfun$verifyGeneratedProducerId$1(ProducerIdManager manager$5, long expectedPid$1) {
        boolean bl;
        try {
            if (manager$5.generateProducerId() != expectedPid$1) {
                return false;
            }
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ String $anonfun$verifyGeneratedProducerId$2(long expectedPid$1) {
        return new StringBuilder(31).append("Failed to generate producer id ").append(expectedPid$1).toString();
    }

    public class MockProducerIdManager
    extends RPCProducerIdManager {
        private final int brokerId;
        private long idStart;
        private final int idLen;
        private Errors error;
        private AtomicBoolean timeoutSignal;
        private final ExecutorService brokerToController;
        public final /* synthetic */ ProducerIdManagerTest $outer;

        public int brokerId() {
            return this.brokerId;
        }

        public long idStart() {
            return this.idStart;
        }

        public void idStart_$eq(long x$1) {
            this.idStart = x$1;
        }

        public int idLen() {
            return this.idLen;
        }

        public Errors error() {
            return this.error;
        }

        public void error_$eq(Errors x$1) {
            this.error = x$1;
        }

        public AtomicBoolean timeoutSignal() {
            return this.timeoutSignal;
        }

        public void timeoutSignal_$eq(AtomicBoolean x$1) {
            this.timeoutSignal = x$1;
        }

        private ExecutorService brokerToController() {
            return this.brokerToController;
        }

        public void sendRequest() {
            Object object = new Object();
            try {
                this.brokerToController().submit(() -> {
                    if (this.timeoutSignal() != null && !this.timeoutSignal().get()) {
                        while (!this.timeoutSignal().get()) {
                            Thread.sleep(100L);
                        }
                        this.handleTimeout();
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    Errors errors = this.error();
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        this.handleAllocateProducerIdsResponse(new AllocateProducerIdsResponse(new AllocateProducerIdsResponseData().setProducerIdStart(this.idStart()).setProducerIdLen(this.idLen())));
                        this.idStart_$eq(this.idStart() + (long)this.idLen());
                        return;
                    }
                    this.handleAllocateProducerIdsResponse(new AllocateProducerIdsResponse(new AllocateProducerIdsResponseData().setErrorCode(this.error().code())));
                }, BoxesRunTime.boxToInteger((int)0));
                return;
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    ex.value$mcV$sp();
                    return;
                }
                throw ex;
            }
        }

        public /* synthetic */ ProducerIdManagerTest kafka$coordinator$transaction$ProducerIdManagerTest$MockProducerIdManager$$$outer() {
            return this.$outer;
        }

        public MockProducerIdManager(ProducerIdManagerTest $outer, int brokerId, long idStart, int idLen, Errors error, AtomicBoolean timeoutSignal) {
            this.brokerId = brokerId;
            this.idStart = idStart;
            this.idLen = idLen;
            this.error = error;
            this.timeoutSignal = timeoutSignal;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(brokerId, (Function0)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final long apply() {
                    return 1L;
                }

                public long apply$mcJ$sp() {
                    return 1L;
                }
            }, null, 100);
            this.brokerToController = Executors.newSingleThreadExecutor();
        }
    }
}

