/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import kafka.cluster.Partition;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaCoordinatorConfig$;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.QuotaStateManager$;
import kafka.coordinator.quota.QuotaStateManagerTest$;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.QuotaValue$;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t%h\u0001\u0002!B\u0001!CQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001C\u0002\u0013\u0005A\u000b\u0003\u0004Y\u0001\u0001\u0006I!\u0016\u0005\b3\u0002\u0011\r\u0011\"\u0001U\u0011\u0019Q\u0006\u0001)A\u0005+\"91\f\u0001b\u0001\n\u0003a\u0006B\u00029\u0001A\u0003%Q\fC\u0004r\u0001\t\u0007I\u0011\u0001:\t\rm\u0004\u0001\u0015!\u0003t\u0011\u001da\bA1A\u0005\u0002uDaa \u0001!\u0002\u0013q\b\u0002CA\u0001\u0001\t\u0007I\u0011\u0001:\t\u000f\u0005\r\u0001\u0001)A\u0005g\"A!\t\u0001b\u0001\n\u0003\t)\u0001\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0004\u0011%\ty\u0001\u0001b\u0001\n\u0003\t)\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0004\u0011%\t\u0019\u0002\u0001b\u0001\n\u0003\t)\u0002\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\f\u0011-\ti\u0003\u0001a\u0001\u0002\u0004%\t!a\f\t\u0017\u0005u\u0002\u00011AA\u0002\u0013\u0005\u0011q\b\u0005\f\u0003\u0017\u0002\u0001\u0019!A!B\u0013\t\t\u0004C\u0006\u0002N\u0001\u0001\r\u00111A\u0005\u0002\u0005=\u0003bCA/\u0001\u0001\u0007\t\u0019!C\u0001\u0003?B1\"a\u0019\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002R!Y\u0011Q\r\u0001A\u0002\u0003\u0007I\u0011AA4\u0011-\t\u0019\b\u0001a\u0001\u0002\u0004%\t!!\u001e\t\u0017\u0005e\u0004\u00011A\u0001B\u0003&\u0011\u0011\u000e\u0005\f\u0003w\u0002\u0001\u0019!a\u0001\n\u0003\ti\bC\u0006\u0002\u0006\u0002\u0001\r\u00111A\u0005\u0002\u0005\u001d\u0005bCAF\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u007fB1\"!$\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0010\"Y\u0011Q\u0014\u0001A\u0002\u0003\u0007I\u0011AAP\u0011-\t\u0019\u000b\u0001a\u0001\u0002\u0003\u0006K!!%\t\u0017\u0005\u0015\u0006\u00011AA\u0002\u0013\u0005\u0011q\u0015\u0005\f\u0003g\u0003\u0001\u0019!a\u0001\n\u0003\t)\fC\u0006\u0002:\u0002\u0001\r\u0011!Q!\n\u0005%\u0006bCA^\u0001\u0001\u0007\t\u0019!C\u0001\u0003{C1\"a7\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002^\"Y\u0011\u0011\u001d\u0001A\u0002\u0003\u0005\u000b\u0015BA`\u0011-\t\u0019\u000f\u0001a\u0001\u0002\u0004%\t!!:\t\u0017\u00055\b\u00011AA\u0002\u0013\u0005\u0011q\u001e\u0005\f\u0003g\u0004\u0001\u0019!A!B\u0013\t9\u000fC\u0005\u0002v\u0002\u0001\r\u0011\"\u0001\u0002x\"I!1\u0003\u0001A\u0002\u0013\u0005!Q\u0003\u0005\t\u00053\u0001\u0001\u0015)\u0003\u0002z\"Y!1\u0004\u0001A\u0002\u0003\u0007I\u0011\u0001B\u000f\u0011-\u00119\u0003\u0001a\u0001\u0002\u0004%\tA!\u000b\t\u0017\t5\u0002\u00011A\u0001B\u0003&!q\u0004\u0005\n\u0005_\u0001!\u0019!C\u0005\u0005cA\u0001B!\u000f\u0001A\u0003%!1\u0007\u0005\b\u0005w\u0001A\u0011\u0001B\u001f\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005{AqAa\u0018\u0001\t\u0003\u0011i\u0004C\u0004\u0003j\u0001!\tA!\u0010\t\u000f\t5\u0004\u0001\"\u0001\u0003>!9!\u0011\u000f\u0001\u0005\u0002\tu\u0002b\u0002B;\u0001\u0011\u0005!Q\b\u0005\b\u0005s\u0002A\u0011\u0001B\u001f\u0011\u001d\u0011i\b\u0001C\u0005\u0005\u007fBqA! \u0001\t\u0013\u0011y\nC\u0004\u00030\u0002!IA!-\t\u000f\t\u0005\u0007\u0001\"\u0003\u0003D\n)\u0012+^8uCN#\u0018\r^3NC:\fw-\u001a:UKN$(B\u0001\"D\u0003\u0015\tXo\u001c;b\u0015\t!U)A\u0006d_>\u0014H-\u001b8bi>\u0014(\"\u0001$\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0002\u0019\u0006)1oY1mC&\u0011aj\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\t\u0006C\u0001*\u0001\u001b\u0005\t\u0015a\u00058v[F+x\u000e^1t!\u0006\u0014H/\u001b;j_:\u001cX#A+\u0011\u0005)3\u0016BA,L\u0005\rIe\u000e^\u0001\u0015]Vl\u0017+^8uCN\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002)E,x\u000e^1U_BL7\rU1si&$\u0018n\u001c8t+\u0005i\u0006c\u00010dK6\tqL\u0003\u0002aC\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003E.\u000b!bY8mY\u0016\u001cG/[8o\u0013\t!wLA\u0002TKF\u0004\"A\u001a8\u000e\u0003\u001dT!\u0001[5\u0002\r\r|W.\\8o\u0015\t1%N\u0003\u0002lY\u00061\u0011\r]1dQ\u0016T\u0011!\\\u0001\u0004_J<\u0017BA8h\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQ#];pi\u0006$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0006f]RLG/\u001f+za\u0016,\u0012a\u001d\t\u0003ifl\u0011!\u001e\u0006\u0003m^\fA\u0001\\1oO*\t\u00010\u0001\u0003kCZ\f\u0017B\u0001>v\u0005\u0019\u0019FO]5oO\u0006YQM\u001c;jif$\u0016\u0010]3!\u0003-)g\u000e^5us:\u000bW.Z:\u0016\u0003y\u00042AX2t\u00031)g\u000e^5us:\u000bW.Z:!\u0003%\tXo\u001c;b)f\u0004X-\u0001\u0006rk>$\u0018\rV=qK\u0002*\"!a\u0002\u0011\u0007)\u000bI!C\u0002\u0002\f-\u0013a\u0001R8vE2,\u0017AB9v_R\f\u0007%A\u0003vg\u0006<W-\u0001\u0004vg\u0006<W\rI\u0001\nY><7i\u001c8gS\u001e,\"!a\u0006\u0011\t\u0005e\u0011qE\u0007\u0003\u00037QA!!\b\u0002 \u0005\u0019An\\4\u000b\t\u0005\u0005\u00121E\u0001\nS:$XM\u001d8bYNT1!!\nj\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!\u000b\u0002\u001c\tIAj\\4D_:4\u0017nZ\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0013\u0001\u0002;j[\u0016,\"!!\r\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000eF\u0003\u0015)H/\u001b7t\u0013\u0011\tY$!\u000e\u0003\u00115{7m\u001b+j[\u0016\f\u0001\u0002^5nK~#S-\u001d\u000b\u0005\u0003\u0003\n9\u0005E\u0002K\u0003\u0007J1!!\u0012L\u0005\u0011)f.\u001b;\t\u0013\u0005%S#!AA\u0002\u0005E\u0012a\u0001=%c\u0005)A/[7fA\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA)!\u0011\t\u0019&!\u0017\u000e\u0005\u0005U#bAA,\u000b\u000611/\u001a:wKJLA!a\u0017\u0002V\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$B!!\u0011\u0002b!I\u0011\u0011\n\r\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005QAn\\4NC:\fw-\u001a:\u0016\u0005\u0005%\u0004\u0003BA6\u0003_j!!!\u001c\u000b\u0007\u0005uQ)\u0003\u0003\u0002r\u00055$A\u0003'pO6\u000bg.Y4fe\u0006qAn\\4NC:\fw-\u001a:`I\u0015\fH\u0003BA!\u0003oB\u0011\"!\u0013\u001c\u0003\u0003\u0005\r!!\u001b\u0002\u00171|w-T1oC\u001e,'\u000fI\u0001\u0012cV|G/Y*uCR,W*\u00198bO\u0016\u0014XCAA@!\r\u0011\u0016\u0011Q\u0005\u0004\u0003\u0007\u000b%!E)v_R\f7\u000b^1uK6\u000bg.Y4fe\u0006)\u0012/^8uCN#\u0018\r^3NC:\fw-\u001a:`I\u0015\fH\u0003BA!\u0003\u0013C\u0011\"!\u0013\u001f\u0003\u0003\u0005\r!a \u0002%E,x\u000e^1Ti\u0006$X-T1oC\u001e,'\u000fI\u0001\na\u0006\u0014H/\u001b;j_:,\"!!%\u0011\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&F\u0003\u001d\u0019G.^:uKJLA!a'\u0002\u0016\nI\u0001+\u0019:uSRLwN\\\u0001\u000ea\u0006\u0014H/\u001b;j_:|F%Z9\u0015\t\u0005\u0005\u0013\u0011\u0015\u0005\n\u0003\u0013\n\u0013\u0011!a\u0001\u0003#\u000b!\u0002]1si&$\u0018n\u001c8!\u0003\u001diW\r\u001e:jGN,\"!!+\u0011\t\u0005-\u0016qV\u0007\u0003\u0003[S1!!*h\u0013\u0011\t\t,!,\u0003\u000f5+GO]5dg\u0006YQ.\u001a;sS\u000e\u001cx\fJ3r)\u0011\t\t%a.\t\u0013\u0005%C%!AA\u0002\u0005%\u0016\u0001C7fiJL7m\u001d\u0011\u0002\u001bE,x\u000e^1F]RLG/[3t+\t\ty\f\u0005\u0004\u0002B\u0006E\u0017Q\u001b\b\u0005\u0003\u0007\fiM\u0004\u0003\u0002F\u0006-WBAAd\u0015\r\tImR\u0001\u0007yI|w\u000e\u001e \n\u00031K1!a4L\u0003\u001d\u0001\u0018mY6bO\u0016L1\u0001ZAj\u0015\r\tym\u0013\t\u0004%\u0006]\u0017bAAm\u0003\nY\u0011+^8uC\u0016sG/\u001b;z\u0003E\tXo\u001c;b\u000b:$\u0018\u000e^5fg~#S-\u001d\u000b\u0005\u0003\u0003\ny\u000eC\u0005\u0002J\u001d\n\t\u00111\u0001\u0002@\u0006q\u0011/^8uC\u0016sG/\u001b;jKN\u0004\u0013AC9v_R\fg+\u00197vKV\u0011\u0011q\u001d\t\u0004%\u0006%\u0018bAAv\u0003\nQ\u0011+^8uCZ\u000bG.^3\u0002\u001dE,x\u000e^1WC2,Xm\u0018\u0013fcR!\u0011\u0011IAy\u0011%\tIEKA\u0001\u0002\u0004\t9/A\u0006rk>$\u0018MV1mk\u0016\u0004\u0013!D9v_R\fg+\u00197vK6\u000b\u0007/\u0006\u0002\u0002zBA\u00111 B\u0001\u0005\u000b\t9/\u0004\u0002\u0002~*\u0019\u0011q`1\u0002\u000f5,H/\u00192mK&!!1AA\u007f\u0005\ri\u0015\r\u001d\t\u0005\u0005\u000f\u0011yA\u0004\u0003\u0003\n\t-\u0001cAAc\u0017&\u0019!QB&\u0002\rA\u0013X\rZ3g\u0013\rQ(\u0011\u0003\u0006\u0004\u0005\u001bY\u0015!E9v_R\fg+\u00197vK6\u000b\u0007o\u0018\u0013fcR!\u0011\u0011\tB\f\u0011%\tI%LA\u0001\u0002\u0004\tI0\u0001\brk>$\u0018MV1mk\u0016l\u0015\r\u001d\u0011\u0002\u0019E,x\u000e^1F]R\u0014\u0018.Z:\u0016\u0005\t}\u0001CBAa\u0003#\u0014\t\u0003E\u0002S\u0005GI1A!\nB\u0005)\tVo\u001c;b\u000b:$(/_\u0001\u0011cV|G/Y#oiJLWm]0%KF$B!!\u0011\u0003,!I\u0011\u0011\n\u0019\u0002\u0002\u0003\u0007!qD\u0001\u000ecV|G/Y#oiJLWm\u001d\u0011\u0002\u0017E,x\u000e^1D_:4\u0017nZ\u000b\u0003\u0005g\u00012A\u0015B\u001b\u0013\r\u00119$\u0011\u0002\u0017#V|G/Y\"p_J$\u0017N\\1u_J\u001cuN\u001c4jO\u0006a\u0011/^8uC\u000e{gNZ5hA\u0005)1/\u001a;VaR\u0011\u0011\u0011\t\u0015\u0004i\t\u0005\u0003\u0003\u0002B\"\u0005#j!A!\u0012\u000b\t\t\u001d#\u0011J\u0001\u0004CBL'\u0002\u0002B&\u0005\u001b\nqA[;qSR,'OC\u0002\u0003P1\fQA[;oSRLAAa\u0015\u0003F\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3!\u000eB-!\u0011\u0011\u0019Ea\u0017\n\t\tu#Q\t\u0002\n\u0003\u001a$XM]#bG\"\fA\u0003^3ti2{\u0017\rZ)v_R\f'+Z2pe\u0012\u001c\bf\u0001\u001c\u0003dA!!1\tB3\u0013\u0011\u00119G!\u0012\u0003\tQ+7\u000f^\u0001\u0010i\u0016\u001cHo\u0015;pe\u0016\fVo\u001c;bg\"\u001aqGa\u0019\u0002!Q,7\u000f^#ya&\u0014X-U;pi\u0006\u001c\bf\u0001\u001d\u0003d\u0005\u0001C/Z:u\u000bb\u0004\u0018N]3Rk>$\u0018m],ji\"<&/\u001b;f\r\u0006LG.\u001e:fQ\rI$1M\u0001\u0016i\u0016\u001cH/U;pi\u0006,e\u000e\u001e:z!\u0006\u00148/\u001b8hQ\rQ$1M\u0001\u001ai\u0016\u001cH/U;pi\u0006$v.\u001c2ti>tW\rU1sg&tw\rK\u0002<\u0005G\na#\u001a=qK\u000e$\u0018+^8uCJ+7m\u001c:eg2{\u0017\r\u001a\u000b\t\u0003\u0003\u0012\tI!\"\u0003\u0010\"1!1\u0011\u001fA\u0002\u0015\f1d\u001a:pkBlU\r^1eCR\fGk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002BDy\u0001\u0007!\u0011R\u0001\fgR\f'\u000f^(gMN,G\u000fE\u0002K\u0005\u0017K1A!$L\u0005\u0011auN\\4\t\u000f\tEE\b1\u0001\u0003\u0014\u00069!/Z2pe\u0012\u001c\b\u0003\u0002BK\u00057k!Aa&\u000b\u0007\teu-\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0005;\u00139JA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u000b\t\u0005\u0013\u0013\tKa+\u0003.\"9!1U\u001fA\u0002\t\u0015\u0016a\u00027pO6{7m\u001b\t\u0005\u0003W\u00129+\u0003\u0003\u0003*\u00065$aC!cgR\u0014\u0018m\u0019;M_\u001eDqAa\">\u0001\u0004\u0011I\tC\u0004\u0003\u0012v\u0002\rAa%\u0002#\r\u0014X-\u0019;f#V|G/\u0019*fG>\u0014H\r\u0006\u0004\u00034\ne&Q\u0018\t\u0005\u0005+\u0013),\u0003\u0003\u00038\n]%\u0001D*j[BdWMU3d_J$\u0007b\u0002B^}\u0001\u0007\u0011Q[\u0001\fcV|G/Y#oi&$\u0018\u0010C\u0004\u0003@z\u0002\rA!\t\u0002\u0015E,x\u000e^1F]R\u0014\u00180\u0001\u000bfqB,7\r^!qa\u0016tG-T3tg\u0006<Wm\u001d\u000b\u0005\u0005\u000b\u00149\u000e\u0005\u0004\u0003H\n5'\u0011[\u0007\u0003\u0005\u0013T1Aa3m\u0003!)\u0017m]=n_\u000e\\\u0017\u0002\u0002Bh\u0005\u0013\u0014qaQ1qiV\u0014X\rE\u0004\u0003T\nUWMa%\u000e\u0003\u0005L1Aa\u0001b\u0011\u001d\u0011In\u0010a\u0001\u00057\fa!\u001a:s_J\u001c\bCBAa\u0003#\u0014i\u000e\u0005\u0003\u0003`\n\u0015XB\u0001Bq\u0015\r\u0011\u0019oZ\u0001\taJ|Go\\2pY&!!q\u001dBq\u0005\u0019)%O]8sg\u0002")
public class QuotaStateManagerTest {
    private final int numQuotasPartitions;
    private final int brokerId;
    private final Seq<TopicPartition> quotaTopicPartitions = new .colon.colon((Object)new TopicPartition("_confluent-quotas", 0), (List)new .colon.colon((Object)new TopicPartition("_confluent-quotas", 1), (List)Nil$.MODULE$));
    private final String entityType;
    private final Seq<String> entityNames = new .colon.colon((Object)"entityName0", (List)new .colon.colon((Object)"entityName1", (List)Nil$.MODULE$));
    private final String quotaType;
    private final double quota;
    private final double usage;
    private final LogConfig logConfig = new LogConfig(Collections.emptyMap());
    private MockTime time;
    private ReplicaManager replicaManager;
    private LogManager logManager;
    private QuotaStateManager quotaStateManager;
    private Partition partition;
    private Metrics metrics;
    private Seq<QuotaEntity> quotaEntities;
    private QuotaValue quotaValue;
    private scala.collection.mutable.Map<String, QuotaValue> quotaValueMap = new HashMap();
    private Seq<QuotaEntry> quotaEntries;
    private final QuotaCoordinatorConfig quotaConfig;

    public int numQuotasPartitions() {
        return this.numQuotasPartitions;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Seq<TopicPartition> quotaTopicPartitions() {
        return this.quotaTopicPartitions;
    }

    public String entityType() {
        return this.entityType;
    }

    public Seq<String> entityNames() {
        return this.entityNames;
    }

    public String quotaType() {
        return this.quotaType;
    }

    public double quota() {
        return this.quota;
    }

    public double usage() {
        return this.usage;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public void quotaStateManager_$eq(QuotaStateManager x$1) {
        this.quotaStateManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public Seq<QuotaEntity> quotaEntities() {
        return this.quotaEntities;
    }

    public void quotaEntities_$eq(Seq<QuotaEntity> x$1) {
        this.quotaEntities = x$1;
    }

    public QuotaValue quotaValue() {
        return this.quotaValue;
    }

    public void quotaValue_$eq(QuotaValue x$1) {
        this.quotaValue = x$1;
    }

    public scala.collection.mutable.Map<String, QuotaValue> quotaValueMap() {
        return this.quotaValueMap;
    }

    public void quotaValueMap_$eq(scala.collection.mutable.Map<String, QuotaValue> x$1) {
        this.quotaValueMap = x$1;
    }

    public Seq<QuotaEntry> quotaEntries() {
        return this.quotaEntries;
    }

    public void quotaEntries_$eq(Seq<QuotaEntry> x$1) {
        this.quotaEntries = x$1;
    }

    private QuotaCoordinatorConfig quotaConfig() {
        return this.quotaConfig;
    }

    @BeforeEach
    public void setUp() {
        this.metrics_$eq(new Metrics());
        this.time_$eq(new MockTime());
        this.replicaManager_$eq((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class));
        this.logManager_$eq((LogManager)EasyMock.createNiceMock(LogManager.class));
        this.quotaStateManager_$eq(new QuotaStateManager(this.quotaConfig(), (Scheduler)this.time().scheduler(), this.replicaManager(), this.metrics(), (Time)this.time()));
        this.quotaStateManager().startup((Function0)(JFunction0.mcI.sp & Serializable)() -> this.numQuotasPartitions(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {});
        this.partition_$eq((Partition)EasyMock.niceMock(Partition.class));
        this.quotaEntities_$eq((Seq<QuotaEntity>)((Seq)this.entityNames().map((Function1 & Serializable)name -> new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.entityType()), name)}))))));
        this.quotaValue_$eq(QuotaValue$.MODULE$.loadValue(this.usage(), false, this.quota(), this.time().milliseconds()));
        this.quotaValueMap().update((Object)this.quotaType(), (Object)this.quotaValue());
        this.quotaEntries_$eq((Seq<QuotaEntry>)((Seq)this.quotaEntities().map((Function1 & Serializable)entity -> new QuotaEntry(entity, this.time().milliseconds()))));
        this.quotaEntries().foreach((Function1 & Serializable)quotaEntry -> {
            quotaEntry.putQuotaValue(this.brokerId(), this.quotaType(), this.quotaValue());
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)this.replicaManager().getLogConfig((TopicPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.logConfig())).anyTimes();
    }

    @AfterEach
    public void tearDown() {
        this.quotaStateManager().shutdown();
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoadQuotaRecords() {
        void withRecords_records;
        long startOffset = 10L;
        SimpleRecord quotaRecord = this.createQuotaRecord((QuotaEntity)this.quotaEntities().head(), (QuotaEntry)this.quotaEntries().head());
        TopicPartition quotaTopicPartition = (TopicPartition)this.quotaTopicPartitions().apply(this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().head()));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{quotaRecord};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var11_6 = null;
        Object var9_5 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        this.expectQuotaRecordsLoad(quotaTopicPartition, startOffset, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.quotaStateManager().loadQuotaState(quotaTopicPartition.partition(), 0);
        this.time().sleep(5L);
        QuotaEntry loadedQuota = this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().head());
        Assertions.assertEquals((Object)this.quotaEntities().head(), (Object)loadedQuota.quotaEntity());
        int loadedBroker = ((Tuple2)loadedQuota.computedQuotas().head())._1$mcI$sp();
        Assertions.assertEquals((int)this.brokerId(), (int)loadedBroker);
        scala.collection.mutable.Map loadedQuotaValues = (scala.collection.mutable.Map)((Tuple2)loadedQuota.computedQuotas().head())._2();
        Assertions.assertEquals(this.quotaValueMap(), (Object)loadedQuotaValues);
        EasyMock.verify((Object[])new Object[]{this.replicaManager(), this.logManager()});
    }

    @Test
    public void testStoreQuotas() {
        .colon.colon expectedErrors = new .colon.colon((Object)Errors.NONE, (List)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$));
        Capture<Map<TopicPartition, MemoryRecords>> capturedRecords = this.expectAppendMessages((Seq<Errors>)expectedErrors);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeErrors = ObjectRef.create((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numQuotasPartitions()).map((Function1 & Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$10))), (Object)None$.MODULE$)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        QuotaStateManager qual$1 = this.quotaStateManager();
        scala.collection.immutable.Map x$1 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numQuotasPartitions()).map((Function1 & Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.quotaTopicPartitions().apply(BoxesRunTime.unboxToInt((Object)i))), (Object)new .colon.colon((Object)((QuotaEntry)this.quotaEntries().apply(BoxesRunTime.unboxToInt((Object)i))), (List)Nil$.MODULE$))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Function1 & Serializable x$2 = (Function1 & Serializable)errors -> {
            QuotaStateManagerTest.callback$1(errors, maybeErrors);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$3 = qual$1.storeQuotas$default$3();
        qual$1.storeQuotas((Map)x$1, (Function1)x$2, x$3);
        ((Map)maybeErrors.elem).foreach(arg_0 -> QuotaStateManagerTest.$anonfun$testStoreQuotas$5$adapted((Seq)expectedErrors, arg_0));
        Assertions.assertTrue((boolean)capturedRecords.hasCaptured());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numQuotasPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            List records = CollectionConverters$.MODULE$.IterableHasAsScala(((AbstractRecords)((MapOps)capturedRecords.getValue()).apply(this.quotaTopicPartitions().apply(partition))).records()).asScala().toList();
            Assertions.assertEquals((int)1, (int)records.size());
            Record record = (Record)records.head();
            QuotaEntity capturedQuotaKey = QuotaStateManager$.MODULE$.readMessageKey(record.key());
            Assertions.assertEquals((Object)this.quotaEntities().apply(partition), (Object)capturedQuotaKey);
            Option capturedQuotaValue = QuotaStateManager$.MODULE$.readMessageValue((QuotaEntity)this.quotaEntities().apply(partition), record.value());
            int capturedBrokerId = ((Tuple2)((QuotaEntry)capturedQuotaValue.get()).computedQuotas().head())._1$mcI$sp();
            Assertions.assertEquals((int)this.brokerId(), (int)capturedBrokerId);
            scala.collection.mutable.Map capturedQuotaValues = (scala.collection.mutable.Map)((Tuple2)((QuotaEntry)capturedQuotaValue.get()).computedQuotas().head())._2();
            Assertions.assertEquals(this.quotaValueMap(), (Object)capturedQuotaValues);
        });
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testExpireQuotas() {
        Capture recordsCapture = EasyMock.newCapture();
        Capture callbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.COORDINATOR), (Map)EasyMock.capture((Capture)recordsCapture), (Function1)EasyMock.capture((Capture)callbackCapture), (Function0)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, callbackCapture){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture callbackCapture$1;

            public void answer() {
                ((Function1)this.callbackCapture$1.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("_confluent-quotas", this.$outer.quotaStateManager().partitionFor((QuotaEntity)this.$outer.quotaEntities().apply(1)))), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.callbackCapture$1 = callbackCapture$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.quotaEntities().foreach(arg_0 -> QuotaStateManagerTest.$anonfun$testExpireQuotas$1(this.quotaStateManager(), arg_0));
        this.time().sleep(2 * (this.quotaConfig().quotasExpirationTimeMs() / 3));
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().head()).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 1000.0, false), 100000.0, (double)Integer.MAX_VALUE, this.time().milliseconds(), Long.MAX_VALUE, 0L, 0.0);
        this.time().sleep(2 * (this.quotaConfig().quotasExpirationTimeMs() / 3));
        Assertions.assertEquals((int)1, (int)((MapOps)recordsCapture.getValue()).keySet().size());
        Assertions.assertEquals((Object)new TopicPartition("_confluent-quotas", this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().apply(1))), (Object)((MapOps)recordsCapture.getValue()).keySet().head());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((AbstractRecords)((MapOps)recordsCapture.getValue()).values().head()).records()).asScala().size());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().head()).isDefined());
        Assertions.assertFalse((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().apply(1)).isDefined());
    }

    @Test
    public void testExpireQuotasWithWriteFailure() {
        Capture firstRecordsCapture = EasyMock.newCapture();
        Capture firstCallbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.COORDINATOR), (Map)EasyMock.capture((Capture)firstRecordsCapture), (Function1)EasyMock.capture((Capture)firstCallbackCapture), (Function0)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, firstCallbackCapture){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture firstCallbackCapture$1;

            public void answer() {
                ((Function1)this.firstCallbackCapture$1.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("_confluent-quotas", this.$outer.quotaStateManager().partitionFor((QuotaEntity)this.$outer.quotaEntities().apply(1)))), (Object)new ProduceResponse.PartitionResponse(Errors.NOT_ENOUGH_REPLICAS, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.firstCallbackCapture$1 = firstCallbackCapture$1;
            }
        }).once();
        Capture secondRecordsCapture = EasyMock.newCapture();
        Capture secondCallbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.COORDINATOR), (Map)EasyMock.capture((Capture)secondRecordsCapture), (Function1)EasyMock.capture((Capture)secondCallbackCapture), (Function0)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, secondCallbackCapture){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture secondCallbackCapture$1;

            public void answer() {
                ((Function1)this.secondCallbackCapture$1.getValue()).apply(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("_confluent-quotas", this.$outer.quotaStateManager().partitionFor((QuotaEntity)this.$outer.quotaEntities().apply(1)))), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.secondCallbackCapture$1 = secondCallbackCapture$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.quotaEntities().foreach(arg_0 -> QuotaStateManagerTest.$anonfun$testExpireQuotasWithWriteFailure$1(this.quotaStateManager(), arg_0));
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().apply(1)).lastUpdatedTimestamp_$eq(this.time().milliseconds() - (long)(this.quotaConfig().quotasExpirationTimeMs() * 2));
        this.time().sleep(this.quotaConfig().quotasExpirationIntervalMs());
        Assertions.assertEquals((int)1, (int)((MapOps)firstRecordsCapture.getValue()).keySet().size());
        Assertions.assertEquals((Object)new TopicPartition("_confluent-quotas", this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().apply(1))), (Object)((MapOps)firstRecordsCapture.getValue()).keySet().head());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((AbstractRecords)((MapOps)firstRecordsCapture.getValue()).values().head()).records()).asScala().size());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().head()).isDefined());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().apply(1)).isDefined());
        this.time().sleep(this.quotaConfig().quotasExpirationIntervalMs());
        Assertions.assertEquals((int)1, (int)((MapOps)secondRecordsCapture.getValue()).keySet().size());
        Assertions.assertEquals((Object)new TopicPartition("_confluent-quotas", this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().apply(1))), (Object)((MapOps)secondRecordsCapture.getValue()).keySet().head());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(((AbstractRecords)((MapOps)secondRecordsCapture.getValue()).values().head()).records()).asScala().size());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().head()).isDefined());
        Assertions.assertFalse((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().apply(1)).isDefined());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaEntryParsing() {
        void var8_8;
        void var7_7;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.entityType()), this.entityNames().head())})));
        QuotaEntry quotaEntry = new QuotaEntry(quotaEntity, this.time().milliseconds());
        quotaEntry.putQuotaValue(0, this.quotaType(), this.quotaValue());
        byte[] keyBytes = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        byte[] valueBytes = QuotaStateManager$.MODULE$.quotaEntryValue(quotaEntry);
        Record quotaRecord = (Record)CollectionConverters$.MODULE$.IterableHasAsScala(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(keyBytes, valueBytes), (List)Nil$.MODULE$), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1).records()).asScala().head();
        Tuple2 tuple2 = QuotaStateManager$.MODULE$.formatRecordKeyAndValue(quotaRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(26).append("quota_entity::entityTypes=").append(quotaEntity.entityTypes()).toString()), (Object)var7_7);
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(37).append("computedQuotas:").append(quotaEntry.computedQuotasString()).append(",lastUpdatedTimestamp:").append(this.time().milliseconds()).toString()), (Object)var8_8);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaTombstoneParsing() {
        void var6_6;
        void var5_5;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.entityType()), this.entityNames().head())})));
        byte[] keyBytes = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        Record quotaRecord = (Record)CollectionConverters$.MODULE$.IterableHasAsScala(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(keyBytes, null), (List)Nil$.MODULE$), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1).records()).asScala().head();
        Tuple2 tuple2 = QuotaStateManager$.MODULE$.formatRecordKeyAndValue(quotaRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(26).append("quota_entity::entityTypes=").append(quotaEntity.entityTypes()).toString()), (Object)var5_5);
        Assertions.assertEquals((Object)new Some((Object)"<DELETE>"), (Object)var6_6);
    }

    private void expectQuotaRecordsLoad(TopicPartition groupMetadataTopicPartition, long startOffset, MemoryRecords records) {
        AbstractLog logMock = (AbstractLog)EasyMock.mock(AbstractLog.class);
        EasyMock.expect((Object)this.replicaManager().getLog(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)logMock));
        long endOffset = this.expectQuotaRecordsLoad(logMock, startOffset, records);
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.replay((Object[])new Object[]{logMock});
        EasyMock.expect((Object)this.replicaManager().logManager()).andStubReturn((Object)this.logManager());
        this.logManager().abortAndPauseCleaning(groupMetadataTopicPartition);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.logManager().resumeCleaning(groupMetadataTopicPartition);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.logManager()});
    }

    private long expectQuotaRecordsLoad(AbstractLog logMock, long startOffset, MemoryRecords records) {
        long endOffset = startOffset + (long)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size();
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchIsolation.LOG_END), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecordsMock));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, bufferCapture, records){
            private final Capture bufferCapture$1;
            private final MemoryRecords records$1;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.bufferCapture$1 = bufferCapture$1;
                this.records$1 = records$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{fileRecordsMock});
        return endOffset;
    }

    private SimpleRecord createQuotaRecord(QuotaEntity quotaEntity, QuotaEntry quotaEntry) {
        byte[] quotaRecordKey = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        byte[] quotaRecordValue = QuotaStateManager$.MODULE$.quotaEntryValue(quotaEntry);
        return new SimpleRecord(quotaRecordKey, quotaRecordValue);
    }

    private Capture<Map<TopicPartition, MemoryRecords>> expectAppendMessages(Seq<Errors> errors) {
        Capture capturedCallback = EasyMock.newCapture();
        Capture capturedRecords = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.COORDINATOR), (Map)EasyMock.capture((Capture)capturedRecords), (Function1)EasyMock.capture((Capture)capturedCallback), (Function0)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, capturedCallback, errors){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture capturedCallback$1;
            private final Seq errors$1;

            public void answer() {
                ((Function1)this.capturedCallback$1.getValue()).apply((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.$outer.numQuotasPartitions()).map((Function1 & Serializable)i -> $anon$5.$anonfun$answer$1(this, BoxesRunTime.unboxToInt((Object)i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }

            public static final /* synthetic */ Tuple2 $anonfun$answer$1($anon$5 $this, int i) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc($this.$outer.quotaTopicPartitions().apply(i)), (Object)new ProduceResponse.PartitionResponse((Errors)$this.errors$1.apply(i), 0L, -1L, 0L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.capturedCallback$1 = capturedCallback$1;
                this.errors$1 = errors$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$1$adapted(kafka.coordinator.quota.QuotaStateManagerTest$$anon$5 java.lang.Object )}, serializedLambda);
            }
        });
        return capturedRecords;
    }

    private static final void callback$1(Map errors, ObjectRef maybeErrors$1) {
        maybeErrors$1.elem = (Map)errors.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partition = x0$1._1$mcI$sp();
                Errors error = (Errors)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)new Some((Object)error));
            }
            throw new MatchError(null);
        });
    }

    public static final /* synthetic */ void $anonfun$testStoreQuotas$5(Seq expectedErrors$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int i = x0$1._1$mcI$sp();
            Option errorOpt = (Option)x0$1._2();
            if (errorOpt instanceof Some) {
                Errors error = (Errors)((Some)errorOpt).value();
                Assertions.assertEquals((Object)expectedErrors$1.apply(i), (Object)error);
                return;
            }
            if (None$.MODULE$.equals(errorOpt)) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(51).append("Partition ").append(i).append(" was not processed by the append callback").toString());
                return;
            }
            throw new MatchError((Object)errorOpt);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ QuotaEntry $anonfun$testExpireQuotas$1(QuotaStateManager eta$0$1$1, QuotaEntity quotaEntity) {
        return eta$0$1$1.getAndMaybePutQuota(quotaEntity);
    }

    public static final /* synthetic */ QuotaEntry $anonfun$testExpireQuotasWithWriteFailure$1(QuotaStateManager eta$0$1$2, QuotaEntity quotaEntity) {
        return eta$0$1$2.getAndMaybePutQuota(quotaEntity);
    }

    public QuotaStateManagerTest() {
        this.numQuotasPartitions = 2;
        this.brokerId = 0;
        this.entityType = "entityType";
        this.quotaType = "quotaType";
        this.quota = 60000.0;
        this.usage = 3000.0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        int x$1 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasLoadBufferSize());
        int x$2 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicPartitions());
        int x$3 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicSegmentBytes());
        short x$4 = Predef$.MODULE$.Short2short(config.confluentConfig().quotasTopicReplicationFactor());
        CompressionType x$5 = config.confluentConfig().quotasTopicCompressionType();
        int x$6 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicAppendTimeoutMs());
        String x$7 = config.confluentConfig().quotasTopicPlacementConstraints();
        int x$8 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationTimeMs());
        int x$9 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationIntervalMs());
        QuotaCoordinatorConfig$ apply$default$10_this = QuotaCoordinatorConfig$.MODULE$;
        Object var20_11 = null;
        int x$10 = apply$default$10_this.DefaultQuotasConsumptionExpirationTimeMs();
        QuotaCoordinatorConfig$ apply$default$11_this = QuotaCoordinatorConfig$.MODULE$;
        Object var21_13 = null;
        long x$11 = apply$default$11_this.DefaultBrokerLimitProducer();
        QuotaCoordinatorConfig$ apply$default$12_this = QuotaCoordinatorConfig$.MODULE$;
        Object var22_15 = null;
        long x$12 = apply$default$12_this.DefaultBrokerLimitProducer();
        QuotaCoordinatorConfig$ apply$default$13_this = QuotaCoordinatorConfig$.MODULE$;
        Object var23_17 = null;
        long x$13 = apply$default$13_this.DefaultQuotasRecomputeIntervalMs();
        QuotaCoordinatorConfig$ apply$default$14_this = QuotaCoordinatorConfig$.MODULE$;
        Object var24_19 = null;
        double x$14 = apply$default$14_this.DefaultQuotasLazyEvaluationThreshold();
        this.quotaConfig = new QuotaCoordinatorConfig(x$2, x$4, x$3, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14);
    }

    public static final /* synthetic */ Object $anonfun$testStoreQuotas$5$adapted(Seq expectedErrors$1, Tuple2 x0$1) {
        QuotaStateManagerTest.$anonfun$testStoreQuotas$5(expectedErrors$1, x0$1);
        return BoxedUnit.UNIT;
    }
}

