/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.coordinator.group.NonBlockingSynchronizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Predef$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005-2A\u0001B\u0003\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011\tYbj\u001c8CY>\u001c7.\u001b8h'ft7\r\u001b:p]&TXM\u001d+fgRT!AB\u0004\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0005!I\u0011aC2p_J$\u0017N\\1u_JT\u0011AC\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\u0015\t\u0001\u0003^3tiNKhn\u00195s_:L'0\u001a:\u0015\u0003e\u0001\"A\u0004\u000e\n\u0005my!\u0001B+oSRD#AA\u000f\u0011\u0005y9S\"A\u0010\u000b\u0005\u0001\n\u0013aA1qS*\u0011!eI\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!S%A\u0003kk:LGOC\u0001'\u0003\ry'oZ\u0005\u0003Q}\u0011A\u0001V3ti\u0006YA/Z:u\rV$XO]3tQ\t\u0019Q\u0004")
public class NonBlockingSynchronizerTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testSynchronizer() {
        NonBlockingSynchronizer synchronizer = new NonBlockingSynchronizer();
        CountDownLatch latch = new CountDownLatch(1);
        VolatileBooleanRef longRunningOpStarted = VolatileBooleanRef.create((boolean)false);
        CompletableFuture.runAsync(() -> synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)42), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            longRunningOpStarted$1.elem = true;
            latch.await();
        }));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!longRunningOpStarted.elem) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Long running operation failed to start");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        BooleanRef done75 = BooleanRef.create((boolean)false);
        synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)75), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            done75$1.elem = true;
        });
        Assertions.assertTrue((boolean)done75.elem, (String)"Operation on a different partition should complete");
        VolatileBooleanRef done42 = VolatileBooleanRef.create((boolean)false);
        synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)42), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            done42$1.elem = true;
        });
        Assertions.assertFalse((boolean)done42.elem, (String)"Operation on the same partition should get queued");
        latch.countDown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!done42.elem) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Operation on the same partition is still blocked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFutures() {
        NonBlockingSynchronizer synchronizer = new NonBlockingSynchronizer();
        BooleanRef done = BooleanRef.create((boolean)false);
        ObjectRef future = ObjectRef.create((Object)synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)42), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            done$1.elem = true;
        }));
        Assertions.assertTrue((boolean)done.elem, (String)"Operation should complete");
        Assertions.assertTrue((boolean)((Future)future.elem).isCompleted(), (String)"Future should be completed");
        Await$.MODULE$.result((Awaitable)((Future)future.elem), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS));
        future.elem = synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)42), (Function0 & Serializable)() -> {
            throw new NullPointerException();
        });
        Assertions.assertTrue((boolean)((Future)future.elem).isCompleted(), (String)"Future should be completed");
        Assertions.assertThrows(NullPointerException.class, () -> Await$.MODULE$.result((Awaitable)((Future)future$1.elem), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS)));
        CountDownLatch latch = new CountDownLatch(1);
        VolatileBooleanRef longRunningOpStarted = VolatileBooleanRef.create((boolean)false);
        VolatileObjectRef longRunningOpFuture = VolatileObjectRef.create(null);
        VolatileBooleanRef longRunningOpDone = VolatileBooleanRef.create((boolean)false);
        CompletableFuture.runAsync(() -> {
            longRunningOpFuture$1.elem = synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)42), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                longRunningOpStarted$2.elem = true;
                latch.await();
                longRunningOpDone$1.elem = true;
            });
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!longRunningOpStarted.elem) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Long running operation failed to start");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertFalse((boolean)longRunningOpDone.elem, (String)"Long running op shouldn't be done");
        future.elem = synchronizer.synchronize((Object)BoxesRunTime.boxToInteger((int)42), (Function0 & Serializable)() -> {
            throw new NullPointerException();
        });
        Assertions.assertFalse((boolean)((Future)future.elem).isCompleted(), (String)"Future shouldn't be completed");
        latch.countDown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!((Future)longRunningOpFuture.elem != null)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Long running operation failed to complete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Await$.MODULE$.result((Awaitable)((Future)longRunningOpFuture.elem), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)longRunningOpDone.elem, (String)"Long running operation should complete");
        Assertions.assertThrows(NullPointerException.class, () -> Await$.MODULE$.result((Awaitable)((Future)future$1.elem), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS)));
    }

    public static final /* synthetic */ boolean $anonfun$testSynchronizer$3(VolatileBooleanRef longRunningOpStarted$1) {
        return longRunningOpStarted$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testSynchronizer$4() {
        return "Long running operation failed to start";
    }

    public static final /* synthetic */ boolean $anonfun$testSynchronizer$7(VolatileBooleanRef done42$1) {
        return done42$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testSynchronizer$8() {
        return "Operation on the same partition is still blocked";
    }

    public static final /* synthetic */ boolean $anonfun$testFutures$6(VolatileBooleanRef longRunningOpStarted$2) {
        return longRunningOpStarted$2.elem;
    }

    public static final /* synthetic */ String $anonfun$testFutures$7() {
        return "Long running operation failed to start";
    }

    public static final /* synthetic */ boolean $anonfun$testFutures$9(VolatileObjectRef longRunningOpFuture$1) {
        return (Future)longRunningOpFuture$1.elem != null;
    }

    public static final /* synthetic */ String $anonfun$testFutures$10() {
        return "Long running operation failed to complete";
    }
}

