/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.controller.ControllerContext;
import kafka.controller.PartitionLeaderElectionAlgorithms$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005m4A!\b\u0010\u0001G!)!\u0006\u0001C\u0001W!Ia\u0006\u0001a\u0001\u0002\u0004%Ia\f\u0005\ng\u0001\u0001\r\u00111A\u0005\nQB\u0011B\u000f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0019\t\u000bm\u0002A\u0011\u0001\u001f\t\u000b)\u0003A\u0011\u0001\u001f\t\u000b=\u0003A\u0011\u0001\u001f\t\u000bE\u0003A\u0011\u0001\u001f\t\u000bM\u0003A\u0011\u0001\u001f\t\u000bU\u0003A\u0011\u0001\u001f\t\u000b]\u0003A\u0011\u0001\u001f\t\u000be\u0003A\u0011\u0001\u001f\t\u000bm\u0003A\u0011\u0001\u001f\t\u000bu\u0003A\u0011\u0001\u001f\t\u000b}\u0003A\u0011\u0001\u001f\t\u000b\u0005\u0004A\u0011\u0001\u001f\t\u000b\r\u0004A\u0011\u0001\u001f\t\u000b\u0015\u0004A\u0011\u0001\u001f\t\u000b\u001d\u0004A\u0011\u0001\u001f\t\u000b%\u0004A\u0011\u0001\u001f\t\u000b-\u0004A\u0011\u0001\u001f\t\u000b5\u0004A\u0011\u0001\u001f\t\u000b=\u0004A\u0011\u0001\u001f\t\u000bE\u0004A\u0011\u0001\u001f\t\u000bM\u0004A\u0011\u0001\u001f\t\u000bU\u0004A\u0011\u0001\u001f\t\u000b]\u0004A\u0011\u0001\u001f\t\u000be\u0004A\u0011\u0001\u001f\u0003KA\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0017\t\\4pe&$\b.\\:UKN$(BA\u0010!\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002C\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001%!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\f\t\u0003[\u0001i\u0011AH\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#\u0001\u0019\u0011\u00055\n\u0014B\u0001\u001a\u001f\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\u0016G>tGO]8mY\u0016\u00148i\u001c8uKb$x\fJ3r)\t)\u0004\b\u0005\u0002&m%\u0011qG\n\u0002\u0005+:LG\u000fC\u0004:\u0007\u0005\u0005\t\u0019\u0001\u0019\u0002\u0007a$\u0013'\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0013!B:fiV\u0003H#A\u001b)\u0005\u0015q\u0004CA I\u001b\u0005\u0001%BA!C\u0003\r\t\u0007/\u001b\u0006\u0003\u0007\u0012\u000bqA[;qSR,'O\u0003\u0002F\r\u0006)!.\u001e8ji*\tq)A\u0002pe\u001eL!!\u0013!\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0012uKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u0003\r1\u0003\"aP'\n\u00059\u0003%\u0001\u0002+fgR\fA\u0007^3ti>3g\r\\5oKB\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>tw+\u001b;i\t\u0016lw\u000e^3e\u0005J|7.\u001a:tQ\t9A*A'uKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c'bgRL5O](gM2Lg.Z+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c#jg\u0006\u0014G.\u001a3)\u0005!a\u0015\u0001\u0014;fgR|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eT1ti&\u001b(o\u00144gY&tW-\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g.\u00128bE2,G\r\u000b\u0002\n\u0019\u0006qF/Z:u\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016cWm\u0019;j_:d\u0015m\u001d;JgJ|eM\u001a7j]\u0016,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\u0012<\u0016\u000e\u001e5EK6|G/\u001a3Ce>\\WM]:)\u0005)a\u0015a\t;fgR\u0014V-Y:tS\u001et\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u0003\u00171\u000bQ\u0007^3tiJ+\u0017m]:jO:\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|gnV5uQ\u0012+Wn\u001c;fI\n\u0013xn[3sg\"\u0012A\u0002T\u00011i\u0016\u001cHOU3bgNLwM\u001c)beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o/&$\bNT8MSZ,\u0017j\u001d:)\u00055a\u0015A\u0011;fgR\u0014V-Y:tS\u001et\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\,ji\"tu\u000eT5wK&\u001b(oV5uQ\u0012+Wn\u001c;fI\n\u0013xn[3sg\"\u0012a\u0002T\u00010i\u0016\u001cHOU3bgNLwM\u001c)beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o/&$\b.R7qifL5O\u001d\u0015\u0003\u001f1\u000b1\u0006^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u0003!1\u000bA\b^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\,ji\"$U-\\8uK\u0012\u0014%o\\6fe\"\u0012\u0011\u0003T\u0001Hi\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]B\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0017J\\%te:{G\u000fT5wK\"\u0012!\u0003T\u0001Hi\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]B\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fgj\u001c;J]&\u001b(\u000fT5wK\"\u00121\u0003T\u0001Yi\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]B\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fgj\u001c;J]&\u001b(\u000fT5wK^KG\u000f\u001b#f[>$X\r\u001a\"s_.,'\u000f\u000b\u0002\u0015\u0019\u0006QE/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|g\u000e\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1O_RLe.S:s\u001d>$H*\u001b<fQ\t)B*A\u0017uKN$8i\u001c8ue>dG.\u001a3TQV$Hm\\<o!\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016cWm\u0019;j_:D#A\u0006'\u0002}Q,7\u000f^\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|gnV5uQ\u0012+Wn\u001c;fI\n\u0013xn[3sQ\t9B*\u0001!uKN$8i\u001c8ue>dG.\u001a3TQV$Hm\\<o!\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016cWm\u0019;j_:d\u0015m\u001d;JgJ\u001c\u0006.\u001e;uS:<Gi\\<oQ\tAB*A%uKN$8i\u001c8ue>dG.\u001a3TQV$Hm\\<o!\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016cWm\u0019;j_:\fE\u000e\\%teNKW.\u001e7uC:,w.^:msNCW\u000f\u001e3po:D#!\u0007'\u0002GQ,7\u000f\u001e'fC\u0012,'/\u00127fGRLwN\\!mY\n\u0013xn[3sg\u0012+Wn\u001c;fI\"\u0012!\u0004T\u0001+i\u0016\u001cHo\u00144gY&tW\rT3bI\u0016\u0014X\t\\3di&|g.\u00117m\u0005J|7.\u001a:t\t\u0016lw\u000e^3eQ\tYB*A1uKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c'bgRL5O](gM2Lg.Z+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\\#oC\ndW\rZ,ji\"\fE\u000e\u001c#f[>$X\r\u001a\"s_.,'o\u001d\u0015\u000391\u0003")
public class PartitionLeaderElectionAlgorithmsTest {
    private ControllerContext controllerContext;

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().stats().removeMetric("UncleanLeaderElectionsPerSec");
    }

    @Test
    public void testOfflinePartitionLeaderElection() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}));
        Set demotedBrokerIds = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds, false, this.controllerContext());
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testOfflinePartitionLeaderElectionWithDemotedBrokers() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 6}));
        Set demotedBrokerIds = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds, false, this.controllerContext());
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)6)), (Object)leaderOpt);
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionDisabled() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}));
        Set demotedBrokerIds = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds, false, this.controllerContext());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
        Assertions.assertEquals((long)0L, (long)this.controllerContext().stats().uncleanLeaderElectionRate().count());
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionEnabled() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 6}));
        Set demotedBrokerIds = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds, true, this.controllerContext());
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
        Assertions.assertEquals((long)1L, (long)this.controllerContext().stats().uncleanLeaderElectionRate().count());
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionEnabledWithDemotedBrokers() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 6}));
        Set demotedBrokerIds = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds, true, this.controllerContext());
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)6)), (Object)leaderOpt);
        Assertions.assertEquals((long)1L, (long)this.controllerContext().stats().uncleanLeaderElectionRate().count());
    }

    @Test
    public void testReassignPartitionLeaderElection() {
        scala.collection.immutable.Seq reassignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}));
        Set demotedBrokerIds = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection((Seq)reassignment, (Seq)isr, liveReplicas, demotedBrokerIds);
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithDemotedBrokers() {
        scala.collection.immutable.Seq reassignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 6}));
        Set demotedBrokerIds = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection((Seq)reassignment, (Seq)isr, liveReplicas, demotedBrokerIds);
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)6)), (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithNoLiveIsr() {
        scala.collection.immutable.Seq reassignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Set demotedBrokerIds = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection((Seq)reassignment, (Seq)isr, liveReplicas, demotedBrokerIds);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithNoLiveIsrWithDemotedBrokers() {
        scala.collection.immutable.Seq reassignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Set demotedBrokerIds = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 6}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection((Seq)reassignment, (Seq)isr, liveReplicas, demotedBrokerIds);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithEmptyIsr() {
        scala.collection.immutable.Seq reassignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Set demotedBrokerIds = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection((Seq)reassignment, (Seq)isr, liveReplicas, demotedBrokerIds);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElection() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set demotedBrokerIds = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds);
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionWithDemotedBroker() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        Set demotedBrokerIds = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaInIsrNotLive() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Set demotedBrokerIds = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaNotInIsrLive() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set demotedBrokerIds = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaNotInIsrLiveWithDemotedBroker() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 6}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        Set demotedBrokerIds = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaNotInIsrNotLive() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Set demotedBrokerIds = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElection() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Set demotedBrokerIds = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds, shuttingDownBrokers);
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElectionWithDemotedBroker() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Set demotedBrokerIds = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds, shuttingDownBrokers);
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)6)), (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElectionLastIsrShuttingDown() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Set demotedBrokerIds = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds, shuttingDownBrokers);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElectionAllIsrSimultaneouslyShutdown() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set demotedBrokerIds = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds, shuttingDownBrokers);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testLeaderElectionAllBrokersDemoted() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Set demotedBrokerIds = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option controlledShutdownLeaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds, shuttingDownBrokers);
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)controlledShutdownLeaderOpt);
        Option preferredLeaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)preferredLeaderOpt);
        Option reassignmentLeaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds);
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (Object)reassignmentLeaderOpt);
    }

    @Test
    public void testOfflineLeaderElectionAllBrokersDemoted() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 6}));
        Set demotedBrokerIds = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds, false, this.controllerContext());
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionEnabledWithAllDemotedBrokers() {
        scala.collection.immutable.Seq assignment = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}));
        scala.collection.immutable.Seq isr = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 6}));
        Set demotedBrokerIds = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 6}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection((Seq)assignment, (Seq)isr, liveReplicas, demotedBrokerIds, true, this.controllerContext());
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
        Assertions.assertEquals((long)1L, (long)this.controllerContext().stats().uncleanLeaderElectionRate().count());
    }
}

