/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.common.AliveBrokersMetadata;
import kafka.common.AliveBrokersSnapshot;
import kafka.common.AlterReplicaExclusionsResult;
import kafka.common.BrokerReplicaExclusion;
import kafka.common.ReplicaExclusionCache;
import kafka.controller.BrokerChange$;
import kafka.controller.ClusterBalanceManager;
import kafka.controller.ControllerEvent;
import kafka.controller.DataBalanceManager;
import kafka.controller.KafkaController;
import kafka.controller.KafkaControllerTest$SuccessfulAlterBrokerHealthScenario$;
import kafka.controller.KafkaControllerTest$SuccessfulExclusionScenario$;
import kafka.server.BrokerFeatures;
import kafka.server.DelegationTokenManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ZkFinalizedFeatureCache;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.zk.BrokerInfo;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.apache.kafka.server.common.BrokerReplicaExclusionResult;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0011-a\u0001\u0002*T\u0001aCQa\u0018\u0001\u0005\u0002\u0001Dqa\u0019\u0001C\u0002\u0013\u0005A\r\u0003\u0004i\u0001\u0001\u0006I!\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0001k\u0011\u0019A\b\u0001)A\u0005W\"9\u0011\u0010\u0001b\u0001\n\u0003Q\bbBA\u0007\u0001\u0001\u0006Ia\u001f\u0005\n\u0003\u001f\u0001!\u0019!C\u0001\u0003#A\u0001\"!\u0007\u0001A\u0003%\u00111\u0003\u0005\n\u00037\u0001\u0001\u0019!C\u0001\u0003;A\u0011\"a\u000b\u0001\u0001\u0004%\t!!\f\t\u0011\u0005e\u0002\u0001)Q\u0005\u0003?A\u0011\"a\u000f\u0001\u0001\u0004%\t!!\u0010\t\u0013\u0005-\u0003\u00011A\u0005\u0002\u00055\u0003\u0002CA)\u0001\u0001\u0006K!a\u0010\t\u0013\u0005M\u0003\u00011A\u0005\u0002\u0005U\u0003\"CA1\u0001\u0001\u0007I\u0011AA2\u0011!\t9\u0007\u0001Q!\n\u0005]\u0003\"CA5\u0001\u0001\u0007I\u0011AA6\u0011%\t\u0019\b\u0001a\u0001\n\u0003\t)\b\u0003\u0005\u0002z\u0001\u0001\u000b\u0015BA7\u0011%\tY\b\u0001a\u0001\n\u0003\ti\bC\u0005\u0002\u0006\u0002\u0001\r\u0011\"\u0001\u0002\b\"A\u00111\u0012\u0001!B\u0013\ty\bC\u0005\u0002\u000e\u0002\u0001\r\u0011\"\u0001\u0002\u0010\"I\u0011Q\u0017\u0001A\u0002\u0013\u0005\u0011q\u0017\u0005\t\u0003w\u0003\u0001\u0015)\u0003\u0002\u0012\"I\u0011Q\u0018\u0001A\u0002\u0013\u0005\u0011q\u0018\u0005\n\u0003\u000f\u0004\u0001\u0019!C\u0001\u0003\u0013D\u0001\"!4\u0001A\u0003&\u0011\u0011\u0019\u0005\n\u0003\u001f\u0004\u0001\u0019!C\u0001\u0003#D\u0011\"a8\u0001\u0001\u0004%\t!!9\t\u0011\u0005\u0015\b\u0001)Q\u0005\u0003'D\u0011\"a:\u0001\u0001\u0004%\t!!;\t\u0013\u0005E\b\u00011A\u0005\u0002\u0005M\b\u0002CA|\u0001\u0001\u0006K!a;\t\u0017\u0005e\b\u00011AA\u0002\u0013\u0005\u00111 \u0005\f\u0005\u0007\u0001\u0001\u0019!a\u0001\n\u0003\u0011)\u0001C\u0006\u0003\n\u0001\u0001\r\u0011!Q!\n\u0005u\b\"\u0003B\u0006\u0001\t\u0007I\u0011\u0001B\u0007\u0011!\u0011)\u0002\u0001Q\u0001\n\t=\u0001b\u0003B\f\u0001\u0001\u0007\t\u0019!C\u0001\u00053A1B!\n\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003(!Y!1\u0006\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B\u000e\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005_AqAa\u0012\u0001\t\u0003\u0011y\u0003C\u0004\u0003R\u0001!\tAa\f\t\u000f\tm\u0003\u0001\"\u0001\u00030!9!q\f\u0001\u0005\u0002\t=\u0002b\u0002B2\u0001\u0011\u0005!q\u0006\u0005\b\u0005O\u0002A\u0011\u0001B\u0018\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005_AqA!\u001c\u0001\t\u0003\u0011y\u0007C\u0005\u0003\u0006\u0002\t\n\u0011\"\u0001\u0003\b\"9!Q\u0014\u0001\u0005\u0002\t=\u0002b\u0002BQ\u0001\u0011\u0005!q\u0006\u0005\b\u0005K\u0003A\u0011\u0001B\u0018\u0011\u001d\u0011I\u000b\u0001C\u0001\u0005_AqA!,\u0001\t\u0003\u0011y\u0003C\u0004\u00032\u0002!\tAa\f\b\u000f\tU\u0006\u0001#\u0001\u00038\u001a9!1\u0018\u0001\t\u0002\tu\u0006BB0?\t\u0003\u0011y\fC\u0004\u0003Bz\"\tAa1\b\u000f\r\r\u0003\u0001#\u0001\u0004F\u001991q\t\u0001\t\u0002\r%\u0003BB0C\t\u0003\u0019Y\u0005C\u0005\u0004N\t\u0013\r\u0011\"\u0001\u0004P!A1q\f\"!\u0002\u0013\u0019\t\u0006C\u0004\u0004b\t#\tAa\f\t\u000f\r\r$\t\"\u0001\u0004f!911\u0011\u0001\u0005\u0002\t=\u0002bBBD\u0001\u0011%1\u0011\u0012\u0005\b\u0007[\u0003A\u0011BBX\u0011\u001d\u0019i\u000b\u0001C\u0005\u00073Dqa!9\u0001\t\u0013\u0019\u0019oB\u0004\u0004pNC\ta!=\u0007\rI\u001b\u0006\u0012ABz\u0011\u0019yf\n\"\u0001\u0004v\"91q\u001f(\u0005\u0002\t=\u0002b\u0002C\u0001\u001d\u0012\u0005!q\u0006\u0002\u0014\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7feR+7\u000f\u001e\u0006\u0003)V\u000b!bY8oiJ|G\u000e\\3s\u0015\u00051\u0016!B6bM.\f7\u0001A\n\u0003\u0001e\u0003\"AW/\u000e\u0003mS\u0011\u0001X\u0001\u0006g\u000e\fG.Y\u0005\u0003=n\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001b!\t\u0011\u0007!D\u0001T\u0003}\tG\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f\u001b*fcV,7\u000f\u001e,feNLwN\\\u000b\u0002KB\u0011!LZ\u0005\u0003On\u0013Qa\u00155peR\f\u0001%\u00197uKJ\u0014%o\\6fe\"+\u0017\r\u001c;i%\u0016\fX/Z:u-\u0016\u00148/[8oA\u0005!A/[7f+\u0005Y\u0007C\u00017w\u001b\u0005i'B\u00018p\u0003\u0015)H/\u001b7t\u0015\t\u0001\u0018/\u0001\u0004d_6lwN\u001c\u0006\u0003-JT!a\u001d;\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0018aA8sO&\u0011q/\u001c\u0002\u0005)&lW-A\u0003uS6,\u0007%A\nuS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe>\u0003H/F\u0001|!\rQFP`\u0005\u0003{n\u0013aa\u00149uS>t\u0007cA@\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!A\u0003u_BL7MC\u0002\u0002\bU\u000bA\u0001^5fe&!\u00111BA\u0001\u0005A!\u0016.\u001a:U_BL7-T1oC\u001e,'/\u0001\u000buS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe>\u0003H\u000fI\u0001\u0013S:LG/[1m\u0005J|7.\u001a:Fa>\u001c\u0007.\u0006\u0002\u0002\u0014A\u0019!,!\u0006\n\u0007\u0005]1L\u0001\u0003M_:<\u0017aE5oSRL\u0017\r\u001c\"s_.,'/\u00129pG\"\u0004\u0013AB2p]\u001aLw-\u0006\u0002\u0002 A!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&U\u000baa]3sm\u0016\u0014\u0018\u0002BA\u0015\u0003G\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\t\u0005=\u0012Q\u0007\t\u00045\u0006E\u0012bAA\u001a7\n!QK\\5u\u0011%\t9dCA\u0001\u0002\u0004\ty\"A\u0002yIE\nqaY8oM&<\u0007%\u0001\u0005{W\u000ec\u0017.\u001a8u+\t\ty\u0004\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)%V\u0001\u0003u.LA!!\u0013\u0002D\ti1*\u00194lCj[7\t\\5f]R\fAB_6DY&,g\u000e^0%KF$B!a\f\u0002P!I\u0011q\u0007\b\u0002\u0002\u0003\u0007\u0011qH\u0001\nu.\u001cE.[3oi\u0002\nq!\\3ue&\u001c7/\u0006\u0002\u0002XA!\u0011\u0011LA/\u001b\t\tYFC\u0002\u0002T=LA!a\u0018\u0002\\\t9Q*\u001a;sS\u000e\u001c\u0018aC7fiJL7m]0%KF$B!a\f\u0002f!I\u0011qG\t\u0002\u0002\u0003\u0007\u0011qK\u0001\t[\u0016$(/[2tA\u0005\t\u0012N\\5uS\u0006d'I]8lKJLeNZ8\u0016\u0005\u00055\u0004\u0003BA!\u0003_JA!!\u001d\u0002D\tQ!I]8lKJLeNZ8\u0002+%t\u0017\u000e^5bY\n\u0013xn[3s\u0013:4wn\u0018\u0013fcR!\u0011qFA<\u0011%\t9\u0004FA\u0001\u0002\u0004\ti'\u0001\nj]&$\u0018.\u00197Ce>\\WM]%oM>\u0004\u0013\u0001\u0004;pW\u0016tW*\u00198bO\u0016\u0014XCAA@!\u0011\t\t#!!\n\t\u0005\r\u00151\u0005\u0002\u0017\t\u0016dWmZ1uS>tGk\\6f]6\u000bg.Y4fe\u0006\u0001Bo\\6f]6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003_\tI\tC\u0005\u00028]\t\t\u00111\u0001\u0002\u0000\u0005iAo\\6f]6\u000bg.Y4fe\u0002\n!c\u00197vgR,'\u000fT5oW6\u000bg.Y4feV\u0011\u0011\u0011\u0013\t\u0005\u0003'\u000byK\u0004\u0003\u0002\u0016\u0006%f\u0002BAL\u0003KsA!!'\u0002$:!\u00111TAQ\u001b\t\tiJC\u0002\u0002 ^\u000ba\u0001\u0010:p_Rt\u0014\"\u0001,\n\u0007\u0005\u0015R+\u0003\u0003\u0002(\u0006\r\u0012\u0001\u00027j].LA!a+\u0002.\u0006\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0015\u0011\t9+a\t\n\t\u0005E\u00161\u0017\u0002\f\u0019&t7.T1oC\u001e,'O\u0003\u0003\u0002,\u00065\u0016AF2mkN$XM\u001d'j].l\u0015M\\1hKJ|F%Z9\u0015\t\u0005=\u0012\u0011\u0018\u0005\n\u0003oQ\u0012\u0011!a\u0001\u0003#\u000b1c\u00197vgR,'\u000fT5oW6\u000bg.Y4fe\u0002\naB\u0019:pW\u0016\u0014h)Z1ukJ,7/\u0006\u0002\u0002BB!\u0011\u0011EAb\u0013\u0011\t)-a\t\u0003\u001d\t\u0013xn[3s\r\u0016\fG/\u001e:fg\u0006\u0011\"M]8lKJ4U-\u0019;ve\u0016\u001cx\fJ3r)\u0011\ty#a3\t\u0013\u0005]R$!AA\u0002\u0005\u0005\u0017a\u00042s_.,'OR3biV\u0014Xm\u001d\u0011\u0002\u0019\u0019,\u0017\r^;sK\u000e\u000b7\r[3\u0016\u0005\u0005M\u0007\u0003BAk\u00037l!!a6\u000b\t\u0005e\u00171E\u0001\t[\u0016$\u0018\rZ1uC&!\u0011Q\\Al\u0005]Q6NR5oC2L'0\u001a3GK\u0006$XO]3DC\u000eDW-\u0001\tgK\u0006$XO]3DC\u000eDWm\u0018\u0013fcR!\u0011qFAr\u0011%\t9\u0004IA\u0001\u0002\u0004\t\u0019.A\u0007gK\u0006$XO]3DC\u000eDW\rI\u0001\u0010W\u000647.Y\"p]R\u0014x\u000e\u001c7feV\u0011\u00111\u001e\t\u0004E\u00065\u0018bAAx'\ny1*\u00194lC\u000e{g\u000e\u001e:pY2,'/A\nlC\u001a\\\u0017mQ8oiJ|G\u000e\\3s?\u0012*\u0017\u000f\u0006\u0003\u00020\u0005U\b\"CA\u001cG\u0005\u0005\t\u0019AAv\u0003AY\u0017MZ6b\u0007>tGO]8mY\u0016\u0014\b%A\ncC2\fgnY3s\u001b\u0006t\u0017mZ3s\u001b>\u001c7.\u0006\u0002\u0002~B\u0019!-a@\n\u0007\t\u00051K\u0001\nECR\f')\u00197b]\u000e,W*\u00198bO\u0016\u0014\u0018a\u00062bY\u0006t7-\u001a:NC:\fw-\u001a:N_\u000e\\w\fJ3r)\u0011\tyCa\u0002\t\u0013\u0005]b%!AA\u0002\u0005u\u0018\u0001\u00062bY\u0006t7-\u001a:NC:\fw-\u001a:N_\u000e\\\u0007%\u0001\bfa>\u001c\u0007NW6WKJ\u001c\u0018n\u001c8\u0016\u0005\t=\u0001c\u0001.\u0003\u0012%\u0019!1C.\u0003\u0007%sG/A\bfa>\u001c\u0007NW6WKJ\u001c\u0018n\u001c8!\u00039)\u0007p\u00197vg&|gnQ1dQ\u0016,\"Aa\u0007\u0011\t\tu!\u0011E\u0007\u0003\u0005?Q!\u0001]+\n\t\t\r\"q\u0004\u0002\u0016%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u001c\u0015m\u00195f\u0003I)\u0007p\u00197vg&|gnQ1dQ\u0016|F%Z9\u0015\t\u0005=\"\u0011\u0006\u0005\n\u0003oY\u0013\u0011!a\u0001\u00057\tq\"\u001a=dYV\u001c\u0018n\u001c8DC\u000eDW\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003_A3!\fB\u001a!\u0011\u0011)Da\u0011\u000e\u0005\t]\"\u0002\u0002B\u001d\u0005w\t1!\u00199j\u0015\u0011\u0011iDa\u0010\u0002\u000f),\b/\u001b;fe*\u0019!\u0011\t;\u0002\u000b),h.\u001b;\n\t\t\u0015#q\u0007\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u00079\u0012Y\u0005\u0005\u0003\u00036\t5\u0013\u0002\u0002B(\u0005o\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002%R,7\u000f^!mi\u0016\u0014(+\u001a9mS\u000e\fW\t_2mkNLwN\\:D_6\u0004H.\u001a;fg\u000e\u000bG\u000e\u001c2bG.<\u0016\u000e\u001e5V].twn\u001e8TKJ4XM]#yG\u0016\u0004H/[8o\u001f:T6*\u0012=dKB$\u0018n\u001c8)\u0007=\u0012)\u0006\u0005\u0003\u00036\t]\u0013\u0002\u0002B-\u0005o\u0011A\u0001V3ti\u0006\u0011E/Z:u\u00032$XM\u001d*fa2L7-Y#yG2,8/[8ogJ+G/\u001e:og&sg/\u00197jI\u0016C8\r\\;tS>twJ\\+oQ\u0006tG\r\\3e\u001fB$\u0016\u0010]3)\u0007A\u0012)&\u0001\u000euKN$\u0018\t\u001c;feJ+\u0007\u000f\\5dC\u0016C8\r\\;tS>t7\u000fK\u00022\u0005+\n1\b^3ti\u0006cG/\u001a:SKBd\u0017nY1Fq\u000edWo]5p]N$u.Z:oiB+'o]5ti>sG)\u001e9mS\u000e\fG/Z#yG2,8/[8oQ\r\u0011$QK\u0001Bi\u0016\u001cH/\u00117uKJ\u0014V\r\u001d7jG\u0006,\u0005p\u00197vg&|gn],pe.\u001c\u0018J\u001a#bi\u0006\u0014\u0015\r\\1oG\u0016\u0014H\u000b\u001b:poN|eNT8uS\u001aL7-\u0019;j_:D3a\rB+\u0003=\u0019H/\u0019:u\u0007>tGO]8mY\u0016\u0014\u0018aL:uCJ$8i\u001c8ue>dG.\u001a:XSRD\u0017I\u0011:pW\u0016\u0014x+\u001b;i\t\u0016<'/\u00193fI\u000e{W\u000e]8oK:$H\u0003\u0002B\b\u0005cB\u0011Ba\u001d6!\u0003\u0005\rA!\u001e\u0002\u001f\t\u0014xn[3s\u0007>l\u0007o\u001c8f]R\u0004BAa\u001e\u0003\u00026\u0011!\u0011\u0010\u0006\u0005\u0005w\u0012i(A\u0003bI6LgNC\u0002\u0003\u0000E\fqa\u00197jK:$8/\u0003\u0003\u0003\u0004\ne$a\u0004\"s_.,'oQ8na>tWM\u001c;\u0002sM$\u0018M\u001d;D_:$(o\u001c7mKJ<\u0016\u000e\u001e5B\u0005J|7.\u001a:XSRDG)Z4sC\u0012,GmQ8na>tWM\u001c;%I\u00164\u0017-\u001e7uIE*\"A!#+\t\tU$1R\u0016\u0003\u0005\u001b\u0003BAa$\u0003\u001a6\u0011!\u0011\u0013\u0006\u0005\u0005'\u0013)*A\u0005v]\u000eDWmY6fI*\u0019!qS.\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u001c\nE%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)B/Z:u\u00032$XM\u001d\"s_.,'\u000fS3bYRD\u0007fA\u001c\u0003V\u0005YD/Z:u\u00032$XM\u001d\"s_.,'\u000fS3bYRDw+\u001b;i\u001bVdG/\u001b9mK\u0012+wM]1eK\u0012\u001cu.\u001c9p]\u0016tGo](o\u0005J|7.\u001a:)\u0007a\u0012)&\u0001\u001duKN$\u0018\t\u001c;fe\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5XSRDW*\u001e7uSBdWMU3bg>t7o\u00148EK\u001e\u0014\u0018\rZ3e\u0005J|7.\u001a:)\u0007e\u0012)&A\u0015uKN$\u0018\t\u001c;fe\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5JM\u0012\u000bG/\u00192bY\u0006t7-\u001a:UQJ|wo\u001d\u0015\u0004u\tU\u0013\u0001\f;fgR\fE\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f[,iK:$U-\\8uS:<')Z=p]\u0012d\u0015.\\5uQ\rY$QK\u0001\u001ai\u0016\u001cH/S7qY&\u001c\u0017\u000e^\"fY2\u001c%/Z1uS>t7\u000fK\u0002=\u0005+\n1eU;dG\u0016\u001c8OZ;m\u00032$XM\u001d\"s_.,'\u000fS3bYRD7kY3oCJLw\u000eE\u0002\u0003:zj\u0011\u0001\u0001\u0002$'V\u001c7-Z:tMVd\u0017\t\u001c;fe\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5TG\u0016t\u0017M]5p'\tq\u0014\f\u0006\u0002\u00038\u0006yb/\u001a:jMf\u0014%o\\6fe\"+\u0017\r\u001c;i'R\fG/^:SKN,H\u000e^:\u0015\u001d\u0005=\"QYB\u0002\u0007'\u00199ba\u000f\u0004@!9!q\u0019!A\u0002\t%\u0017!\u00072s_.,'\u000fS3bYRD7\u000b^1ukN\u0014Vm];miN\u0004BA\u0017?\u0003LB1!Q\u001aBl\u0005;tAAa4\u0003T:!\u00111\u0014Bi\u0013\u0005a\u0016b\u0001Bk7\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002Bm\u00057\u0014A\u0001T5ti*\u0019!Q[.\u0011\t\t}'Q \b\u0005\u0005C\u00149P\u0004\u0003\u0003d\nMh\u0002\u0002Bs\u0005ctAAa:\u0003p:!!\u0011\u001eBw\u001d\u0011\tYJa;\n\u0003UL!a\u001d;\n\u0005Y\u0013\u0018B\u00019r\u0013\r\u0011)p\\\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0011IPa?\u0002;\u0005cG/\u001a:Ce>\\WM\u001d%fC2$\bNU3ta>t7/\u001a#bi\u0006T1A!>p\u0013\u0011\u0011yp!\u0001\u00031\t\u0013xn[3s\u0011\u0016\fG\u000e\u001e5Ti\u0006$Xo\u001d*fgVdGO\u0003\u0003\u0003z\nm\bbBB\u0003\u0001\u0002\u00071qA\u0001\u0016Y&4XM\u0011:pW\u0016\u0014\u0018\nZ!oI\u0016\u0003xn\u00195t!!\u0019Iaa\u0004\u0003\u0010\u0005MQBAB\u0006\u0015\r\u0019iaW\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB\t\u0007\u0017\u00111!T1q\u0011\u001d\u0019)\u0002\u0011a\u0001\u0005\u001f\t!DT;n\u0005J|7.\u001a:t/&$\b\u000eS3bYRD7\t[1oO\u0016Dqa!\u0007A\u0001\u0004\u0019Y\"A\nOK^d\u0017\u0010S3bYRD\u0017P\u0011:pW\u0016\u00148\u000f\u0005\u0004\u0004\u001e\r\u001521\u0006\b\u0005\u0007?\u0019\t\u0003E\u0002\u0002\u001cnK1aa\t\\\u0003\u0019\u0001&/\u001a3fM&!1qEB\u0015\u0005\r\u0019V\r\u001e\u0006\u0004\u0007GY\u0006\u0003BB\u0017\u0007oi!aa\f\u000b\t\rE21G\u0001\u0005Y\u0006twM\u0003\u0002\u00046\u0005!!.\u0019<b\u0013\u0011\u0019Ida\f\u0003\u000f%sG/Z4fe\"91Q\b!A\u0002\rm\u0011\u0001\u0006(fo2LH)Z4sC\u0012,GM\u0011:pW\u0016\u00148\u000fC\u0004\u0004B\u0001\u0003\raa\u0007\u0002#\u0011,wM]1eK\u0012\u0014%o\\6fe&#7/A\u000eTk\u000e\u001cWm]:gk2,\u0005p\u00197vg&|gnU2f]\u0006\u0014\u0018n\u001c\t\u0004\u0005s\u0013%aG*vG\u000e,7o\u001d4vY\u0016C8\r\\;tS>t7kY3oCJLwn\u0005\u0002C3R\u00111QI\u0001\rKb\u001cG.^:j_:|\u0005o]\u000b\u0003\u0007#\u0002ba!\b\u0004&\rM\u0003\u0003BB+\u00077j!aa\u0016\u000b\u0007A\u001cIFC\u0002\u0002&ELAa!\u0018\u0004X\t9\u0012\t\u001c;feJ+\u0007\u000f\\5dC\u0016C8\r\\;tS>tw\n]\u0001\u000eKb\u001cG.^:j_:|\u0005o\u001d\u0011\u0002\tQ,7\u000f^\u0001\"CN\u001cXM\u001d;Tk\u000e\u001cWm]:gk2,\u0005p\u00197vg&|gnQ1mY\n\f7m\u001b\u000b\u0005\u0003_\u00199\u0007C\u0004\u0004j\u001d\u0003\raa\u001b\u0002\rI,7/\u001e7u!!\u0011im!\u001c\u0004r\ru\u0014\u0002BB8\u00057\u0014a!R5uQ\u0016\u0014\b\u0003BB:\u0007sj!a!\u001e\u000b\u0007\r]t.\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0019Yh!\u001e\u0003\u0011\u0005\u0003\u0018.\u0012:s_J\u0004BA!\b\u0004\u0000%!1\u0011\u0011B\u0010\u0005q\tE\u000e^3s%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:\u001c(+Z:vYR\f\u0001\u0004^3ti\u0006c\u0017N^3Ce>\\WM]:T]\u0006\u00048\u000f[8uQ\rA%QK\u0001 CN\u001cXM\u001d;Tk\u000e\u001cWm]:gk2,\u0005p\u00197vg&|gNU3tk2$H\u0003CA\u0018\u0007\u0017\u001b9ja'\t\u000f\r5\u0015\n1\u0001\u0004\u0010\u0006y!/Z2fSZ,GMU3tk2$8\u000f\u0005\u0004\u0004\u001e\r\u00152\u0011\u0013\t\u0005\u0007+\u001a\u0019*\u0003\u0003\u0004\u0016\u000e]#\u0001\b\"s_.,'OU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8SKN,H\u000e\u001e\u0005\b\u00073K\u0005\u0019\u0001B\b\u0003A)\u0007\u0010]3di\u0016$'I]8lKJLE\rC\u0004\u0004\u001e&\u0003\raa(\u0002\u001d\u0015D\b/Z2uK\u0012|\u0005\u000fV=qKB!1\u0011UBT\u001d\u0011\u00119ha)\n\t\r\u0015&\u0011P\u0001\f\u000bb\u001cG.^:j_:|\u0005/\u0003\u0003\u0004*\u000e-&AB(q)f\u0004XM\u0003\u0003\u0004&\ne\u0014!\u0005<fe&4\u00170T3ue&\u001cg+\u00197vKRA\u0011qFBY\u0007\u0017\u001c)\u000eC\u0004\u00044*\u0003\ra!.\u0002\u001f5,GO]5dgJ+w-[:uef\u0004Baa.\u0004H6\u00111\u0011\u0018\u0006\u0005\u0007w\u001bi,\u0001\u0003d_J,'\u0002BA*\u0007\u007fSAa!1\u0004D\u00061\u00110Y7nKJT!a!2\u0002\u0007\r|W.\u0003\u0003\u0004J\u000ee&aD'fiJL7m\u001d*fO&\u001cHO]=\t\u000f\r5'\n1\u0001\u0004P\u0006\u0001R.\u001a;sS\u000e\u001c\u0016.\u001c9mK:\u000bW.\u001a\t\u0005\u0007;\u0019\t.\u0003\u0003\u0004T\u000e%\"AB*ue&tw\rC\u0004\u0004X*\u0003\raa\u000b\u0002\u001b\u0015D\b/Z2uK\u00124\u0016\r\\;f)!\tyca7\u0004^\u000e}\u0007bBBZ\u0017\u0002\u00071Q\u0017\u0005\b\u0007\u001b\\\u0005\u0019ABh\u0011\u001d\u00199n\u0013a\u0001\u0007\u001f\fa!\\3ue&\u001cGCBBs\u0007W\u001ci\u000f\u0005\u0003\u00048\u000e\u001d\u0018\u0002BBu\u0007s\u0013a!T3ue&\u001c\u0007bBBZ\u0019\u0002\u00071Q\u0017\u0005\b\u0007\u001bd\u0005\u0019ABh\u0003MY\u0015MZ6b\u0007>tGO]8mY\u0016\u0014H+Z:u!\t\u0011gj\u0005\u0002O3R\u00111\u0011_\u0001\u000bg\u0016$X\u000b]\"mCN\u001c\bf\u0001)\u0004|B!!QGB\u007f\u0013\u0011\u0019yPa\u000e\u0003\u0013\t+gm\u001c:f\u00032d\u0017!\u0004;fCJ$un\u001e8DY\u0006\u001c8\u000fK\u0002R\t\u000b\u0001BA!\u000e\u0005\b%!A\u0011\u0002B\u001c\u0005!\te\r^3s\u00032d\u0007")
public class KafkaControllerTest {
    private volatile KafkaControllerTest$SuccessfulAlterBrokerHealthScenario$ SuccessfulAlterBrokerHealthScenario$module;
    private volatile KafkaControllerTest$SuccessfulExclusionScenario$ SuccessfulExclusionScenario$module;
    private final short alterBrokerHealthRequestVersion = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
    private final Time time = new MockTime();
    private final Option<TierTopicManager> tierTopicManagerOpt = None$.MODULE$;
    private final long initialBrokerEpoch;
    private KafkaConfig config = null;
    private KafkaZkClient zkClient = null;
    private Metrics metrics = null;
    private BrokerInfo initialBrokerInfo = null;
    private DelegationTokenManager tokenManager = null;
    private ClusterLinkFactory.LinkManager clusterLinkManager = null;
    private BrokerFeatures brokerFeatures = null;
    private ZkFinalizedFeatureCache featureCache = null;
    private KafkaController kafkaController = null;
    private DataBalanceManager balancerManagerMock;
    private final int epochZkVersion;
    private ReplicaExclusionCache exclusionCache;

    @AfterAll
    public static void tearDownClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@AfterAll");
    }

    @BeforeAll
    public static void setUpClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@BeforeAll");
    }

    public KafkaControllerTest$SuccessfulAlterBrokerHealthScenario$ SuccessfulAlterBrokerHealthScenario() {
        if (this.SuccessfulAlterBrokerHealthScenario$module == null) {
            this.SuccessfulAlterBrokerHealthScenario$lzycompute$1();
        }
        return this.SuccessfulAlterBrokerHealthScenario$module;
    }

    public KafkaControllerTest$SuccessfulExclusionScenario$ SuccessfulExclusionScenario() {
        if (this.SuccessfulExclusionScenario$module == null) {
            this.SuccessfulExclusionScenario$lzycompute$1();
        }
        return this.SuccessfulExclusionScenario$module;
    }

    public short alterBrokerHealthRequestVersion() {
        return this.alterBrokerHealthRequestVersion;
    }

    public Time time() {
        return this.time;
    }

    public Option<TierTopicManager> tierTopicManagerOpt() {
        return this.tierTopicManagerOpt;
    }

    public long initialBrokerEpoch() {
        return this.initialBrokerEpoch;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(KafkaZkClient x$1) {
        this.zkClient = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public BrokerInfo initialBrokerInfo() {
        return this.initialBrokerInfo;
    }

    public void initialBrokerInfo_$eq(BrokerInfo x$1) {
        this.initialBrokerInfo = x$1;
    }

    public DelegationTokenManager tokenManager() {
        return this.tokenManager;
    }

    public void tokenManager_$eq(DelegationTokenManager x$1) {
        this.tokenManager = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public void clusterLinkManager_$eq(ClusterLinkFactory.LinkManager x$1) {
        this.clusterLinkManager = x$1;
    }

    public BrokerFeatures brokerFeatures() {
        return this.brokerFeatures;
    }

    public void brokerFeatures_$eq(BrokerFeatures x$1) {
        this.brokerFeatures = x$1;
    }

    public ZkFinalizedFeatureCache featureCache() {
        return this.featureCache;
    }

    public void featureCache_$eq(ZkFinalizedFeatureCache x$1) {
        this.featureCache = x$1;
    }

    public KafkaController kafkaController() {
        return this.kafkaController;
    }

    public void kafkaController_$eq(KafkaController x$1) {
        this.kafkaController = x$1;
    }

    public DataBalanceManager balancerManagerMock() {
        return this.balancerManagerMock;
    }

    public void balancerManagerMock_$eq(DataBalanceManager x$1) {
        this.balancerManagerMock = x$1;
    }

    public int epochZkVersion() {
        return this.epochZkVersion;
    }

    public ReplicaExclusionCache exclusionCache() {
        return this.exclusionCache;
    }

    public void exclusionCache_$eq(ReplicaExclusionCache x$1) {
        this.exclusionCache = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:2181");
        props.put(KafkaConfig$.MODULE$.AlterBrokerHealthMaxDemotedBrokersPercentageProp(), "67");
        props.put("confluent.cells.enable", "true");
        props.put("confluent.cells.implicit.creation.enable", "true");
        boolean apply_doLog = true;
        this.config_$eq(new KafkaConfig((java.util.Map)props, apply_doLog));
        this.zkClient_$eq((KafkaZkClient)Mockito.mock(KafkaZkClient.class));
        this.metrics_$eq(new Metrics());
        this.initialBrokerInfo_$eq((BrokerInfo)Mockito.mock(BrokerInfo.class));
        this.tokenManager_$eq((DelegationTokenManager)Mockito.mock(DelegationTokenManager.class));
        this.clusterLinkManager_$eq((ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class));
        this.brokerFeatures_$eq((BrokerFeatures)Mockito.mock(BrokerFeatures.class));
        this.featureCache_$eq((ZkFinalizedFeatureCache)Mockito.mock(ZkFinalizedFeatureCache.class));
        this.balancerManagerMock_$eq((DataBalanceManager)Mockito.mock(DataBalanceManager.class));
        this.exclusionCache_$eq(new ReplicaExclusionCache());
        TestUtils$.MODULE$.clearYammerMetrics();
        KafkaYammerMetrics.defaultRegistry().shutdown();
        this.kafkaController_$eq(new KafkaController(this.config(), this.zkClient(), this.time(), this.metrics(), this.initialBrokerInfo(), this.initialBrokerEpoch(), this.tokenManager(), this.tierTopicManagerOpt(), this.clusterLinkManager(), this.brokerFeatures(), this.featureCache(), this.exclusionCache(), false, (Option)None$.MODULE$, (Option)None$.MODULE$));
        this.kafkaController().dataBalancer_$eq(this.balancerManagerMock());
    }

    @AfterEach
    public void tearDown() {
        if (this.kafkaController().eventManager().thread().isRunning()) {
            this.kafkaController().shutdown();
            return;
        }
    }

    @Test
    public void testAlterReplicaExclusionsCompletesCallbackWithUnknownServerExceptionOnZKException() {
        AlterReplicaExclusionOp exclusionOp = new AlterReplicaExclusionOp(1, "maintenance", ExclusionOp.OpType.SET);
        this.zkClient().setOrCreateReplicaExclusions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(exclusionOp.brokerId(), exclusionOp.reason())})), this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.APIERROR, (String)"replica_exclusions");
        });
        this.kafkaController().processAlterReplicaExclusions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{exclusionOp})), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$1(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.balancerManagerMock()});
    }

    @Test
    public void testAlterReplicaExclusionsReturnsInvalidExclusionOnUnhandledOpType() {
        AlterReplicaExclusionOp unknownOp = new AlterReplicaExclusionOp(1, "maintenance", ExclusionOp.OpType.UNKNOWN);
        this.kafkaController().processAlterReplicaExclusions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{unknownOp})), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$2(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient(), (VerificationMode)Mockito.never())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.balancerManagerMock()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaExclusions() {
        this.kafkaController().replicaExclusionCache().overrideMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusions$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Set expectedPersistedExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(1, "maintenance")}));
        this.zkClient().setOrCreateReplicaExclusions(expectedPersistedExclusions, this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            KafkaControllerTest.$anonfun$testAlterReplicaExclusions$3(x$4);
            return BoxedUnit.UNIT;
        });
        this.SuccessfulExclusionScenario().test();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion() {
        this.kafkaController().replicaExclusionCache().overrideMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Set expectedPersistedExclusions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerReplicaExclusion[]{new BrokerReplicaExclusion(2, "delete")}));
        this.zkClient().setOrCreateReplicaExclusions(expectedPersistedExclusions, this.epochZkVersion());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            KafkaControllerTest.$anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$3(x$5);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set exclusionOps = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{new AlterReplicaExclusionOp(1, "", ExclusionOp.OpType.DELETE), new AlterReplicaExclusionOp(2, "excluded", ExclusionOp.OpType.SET)}));
        this.kafkaController().alterBrokerReplicaExclusions((Set)exclusionOps, (Function1 & Serializable)result -> {
            this.callback$3(result);
            return BoxedUnit.UNIT;
        });
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient(), (VerificationMode)Mockito.never())).setOrCreateReplicaExclusions((scala.collection.immutable.Set)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()));
        ((ClusterBalanceManager)Mockito.verify((Object)this.balancerManagerMock(), (VerificationMode)Mockito.never())).onAlteredExclusions(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{1}))).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{2}))).asJava());
    }

    @Test
    public void testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification() {
        this.kafkaController().replicaExclusionCache().overrideMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"excluded")}))).asJava());
        this.kafkaController().startup();
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
        this.balancerManagerMock().onAlteredExclusions((java.util.Set)ArgumentMatchers.any(), (java.util.Set)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$6 -> {
            throw new Exception("test!");
        });
        this.SuccessfulExclusionScenario().test();
    }

    public void startController() {
        Map brokerEpochs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(1, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(2, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(3, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)3L))}));
        this.kafkaController().controllerContext().setLiveBrokers(brokerEpochs);
        this.kafkaController().startup();
    }

    /*
     * WARNING - void declaration
     */
    public int startControllerWithABrokerWithDegradedComponent(BrokerComponent brokerComponent) {
        Map brokerEpochs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(1, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(2, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(3, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)3L))}));
        this.kafkaController().controllerContext().setLiveBrokers(brokerEpochs);
        int degradedBrokerId = 1;
        this.kafkaController().controllerContext().setDegradedBrokerComponent(degradedBrokerId, ComponentHealthStatus.DEGRADED, new DegradedBrokerComponent("degraded unspecified component of broker for test", brokerComponent.id()));
        this.kafkaController().startup();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$startControllerWithABrokerWithDegradedComponent$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Map expectedBrokerHealthInfo = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)degradedBrokerId)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("degraded unspecified component of broker for test", brokerComponent.id())})))}));
        this.zkClient().setBrokerHealthState(expectedBrokerHealthInfo);
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$7 -> {
            KafkaControllerTest.$anonfun$startControllerWithABrokerWithDegradedComponent$3(x$7);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        return degradedBrokerId;
    }

    public BrokerComponent startControllerWithABrokerWithDegradedComponent$default$1() {
        return BrokerComponent.UNSPECIFIED;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterBrokerHealth() {
        int initiallyDegradedBrokerId = this.startControllerWithABrokerWithDegradedComponent(this.startControllerWithABrokerWithDegradedComponent$default$1());
        Map liveBrokerIdsAndEpochs = this.kafkaController().controllerContext().liveBrokerIdAndEpochs();
        ObjectRef brokerHealthResults = ObjectRef.create((Object)None$.MODULE$);
        int degradedBrokerId = 2;
        this.kafkaController().alterBrokerHealth("degraded unspecified component of broker for test", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId})), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, this.alterBrokerHealthRequestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$4(result, brokerHealthResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((Option)brokerHealthResults.elem).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to get brokerHealthResults");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults((Option<List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>>)((Option)brokerHealthResults.elem), (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        this.kafkaController().alterBrokerHealth("degraded unspecified component of broker for test", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId})), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, false, this.alterBrokerHealthRequestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$4(result, brokerHealthResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!((Option)brokerHealthResults.elem).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"failed to get brokerHealthResults");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults((Option<List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>>)((Option)brokerHealthResults.elem), (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId)}))));
        this.kafkaController().alterBrokerHealth("degraded storage component of broker for test", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId})), BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, false, this.alterBrokerHealthRequestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$4(result, brokerHealthResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!((Option)brokerHealthResults.elem).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"failed to get brokerHealthResults");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults((Option<List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>>)((Option)brokerHealthResults.elem), (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        this.kafkaController().alterBrokerHealth("degraded unspecified component of broker for test", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{initiallyDegradedBrokerId, degradedBrokerId})), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, false, this.alterBrokerHealthRequestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$4(result, brokerHealthResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!((Option)brokerHealthResults.elem).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"failed to get brokerHealthResults");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults((Option<List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>>)((Option)brokerHealthResults.elem), (Map<Object, Object>)liveBrokerIdsAndEpochs, 2, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        this.kafkaController().alterBrokerHealth("degraded storage component of broker for test", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{initiallyDegradedBrokerId, degradedBrokerId})), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, this.alterBrokerHealthRequestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$4(result, brokerHealthResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!((Option)brokerHealthResults.elem).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"failed to get brokerHealthResults");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults((Option<List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>>)((Option)brokerHealthResults.elem), (Map<Object, Object>)liveBrokerIdsAndEpochs, 2, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterBrokerHealthWithMultipleDegradedComponentsOnBroker() {
        this.startController();
        int degradedBrokerId = 1;
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(0));
        Map liveBrokerIdsAndEpochs = this.kafkaController().controllerContext().liveBrokerIdAndEpochs();
        ObjectRef brokerHealthResults = ObjectRef.create((Object)None$.MODULE$);
        this.kafkaController().alterBrokerHealth("degraded unspecified component of broker for test", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId})), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, this.alterBrokerHealthRequestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$5(result, brokerHealthResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((Option)brokerHealthResults.elem).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to get brokerHealthResults");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults((Option<List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>>)((Option)brokerHealthResults.elem), (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        brokerHealthResults.elem = None$.MODULE$;
        this.kafkaController().alterBrokerHealth("degraded storage component of broker for test", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId})), BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, false, this.alterBrokerHealthRequestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$5(result, brokerHealthResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!((Option)brokerHealthResults.elem).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"failed to get brokerHealthResults");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults((Option<List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>>)((Option)brokerHealthResults.elem), (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterBrokerHealthWithMultipleReasonsOnDegradedBroker() {
        int degradedBrokerId = 1;
        this.kafkaController().controllerContext().setDegradedBrokerComponent(degradedBrokerId, ComponentHealthStatus.DEGRADED, new DegradedBrokerComponent("degraded unspecified component for test", BrokerComponent.UNSPECIFIED.id()));
        this.kafkaController().controllerContext().setDegradedBrokerComponent(degradedBrokerId, ComponentHealthStatus.DEGRADED, new DegradedBrokerComponent("degraded unspecified component for test1", BrokerComponent.UNSPECIFIED.id()));
        this.kafkaController().startup();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterBrokerHealthWithMultipleReasonsOnDegradedBroker$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to elect the controller");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        Map liveBrokerIdsAndEpochs = this.kafkaController().controllerContext().liveBrokerIdAndEpochs();
        ObjectRef brokerHealthResults = ObjectRef.create((Object)None$.MODULE$);
        this.kafkaController().alterBrokerHealth("degraded unspecified component for test1", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId})), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, false, this.alterBrokerHealthRequestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$6(result, brokerHealthResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!((Option)brokerHealthResults.elem).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"failed to get brokerHealthResults");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults((Option<List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>>)((Option)brokerHealthResults.elem), (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
        this.kafkaController().alterBrokerHealth("degraded unspecified component for test", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId})), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, false, this.alterBrokerHealthRequestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$6(result, brokerHealthResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(0));
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!((Option)brokerHealthResults.elem).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"failed to get brokerHealthResults");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults((Option<List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>>)((Option)brokerHealthResults.elem), (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterBrokerHealthIfDatabalancerThrows() {
        int initiallyDegradedBrokerId = this.startControllerWithABrokerWithDegradedComponent(this.startControllerWithABrokerWithDegradedComponent$default$1());
        Map liveBrokerIdsAndEpochs = this.kafkaController().controllerContext().liveBrokerIdAndEpochs();
        ObjectRef brokerHealthResults = ObjectRef.create((Object)None$.MODULE$);
        this.balancerManagerMock().onBrokerHealthChange((java.util.Set)ArgumentMatchers.any(), (java.util.Set)ArgumentMatchers.any(), (AliveBrokersMetadata)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$8 -> {
            throw new Exception("test!");
        });
        int degradedBrokerId = 2;
        this.kafkaController().alterBrokerHealth("degrade unspecified component test", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId})), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, true, this.alterBrokerHealthRequestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$7(result, brokerHealthResults);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(2));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!((Option)brokerHealthResults.elem).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"failed to get brokerHealthResults");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults((Option<List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>>)((Option)brokerHealthResults.elem), (Map<Object, Object>)liveBrokerIdsAndEpochs, 1, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId)}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterBrokerHealthWhenDemotingBeyondLimit() {
        int initiallyDegradedBrokerId = this.startControllerWithABrokerWithDegradedComponent(this.startControllerWithABrokerWithDegradedComponent$default$1());
        Map liveBrokerIdsAndEpochs = this.kafkaController().controllerContext().liveBrokerIdAndEpochs();
        ObjectRef brokerHealthResults = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef requestError = ObjectRef.create((Object)None$.MODULE$);
        int degradedBrokerId = 2;
        int demotedBrokerIdBeyondLimit = 3;
        this.kafkaController().alterBrokerHealth("demotion test", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId, demotedBrokerIdBeyondLimit})), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, this.alterBrokerHealthRequestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$8(result, brokerHealthResults, requestError);
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$testAlterBrokerHealthWhenDemotingBeyondLimit$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Request was not handled.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(1));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!((Option)requestError.elem).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Request callback not called, or did not have error.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)Errors.DEMOTION_LIMIT_REACHED, (Object)((Option)requestError.elem).get());
        this.kafkaController().alterBrokerHealth("demotion test", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{degradedBrokerId, demotedBrokerIdBeyondLimit})), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, true, this.alterBrokerHealthRequestVersion(), (Function1 & Serializable)result -> {
            KafkaControllerTest.callback$8(result, brokerHealthResults, requestError);
            return BoxedUnit.UNIT;
        });
        this.kafka$controller$KafkaControllerTest$$verifyMetricValue(KafkaYammerMetrics.defaultRegistry(), "BrokersWithDegradedHealthCount", Predef$.MODULE$.int2Integer(3));
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!((Option)brokerHealthResults.elem).isDefined()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"failed to get brokerHealthResults");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        this.SuccessfulAlterBrokerHealthScenario().verifyBrokerHealthStatusResults((Option<List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>>)((Option)brokerHealthResults.elem), (Map<Object, Object>)liveBrokerIdsAndEpochs, 2, (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(degradedBrokerId), Predef$.MODULE$.int2Integer(demotedBrokerIdBeyondLimit)}))), (scala.collection.immutable.Set<Integer>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(initiallyDegradedBrokerId), Predef$.MODULE$.int2Integer(degradedBrokerId), Predef$.MODULE$.int2Integer(demotedBrokerIdBeyondLimit)}))));
    }

    @Test
    public void testImplicitCellCreations() {
        Broker broker = Broker$.MODULE$.apply(0, (Seq)new .colon.colon((Object)new EndPoint("localhost", 8000, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT), (List)Nil$.MODULE$), (Option)None$.MODULE$, Features.emptySupportedFeatures());
        Broker broker2 = Broker$.MODULE$.apply(1, (Seq)new .colon.colon((Object)new EndPoint("localhost", 8000, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT), (List)Nil$.MODULE$), (Option)None$.MODULE$, Features.emptySupportedFeatures());
        Mockito.when((Object)this.zkClient().getAllBrokerAndEpochsInCluster()).thenAnswer(x$9 -> (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)BoxesRunTime.boxToLong((long)1L))})));
        this.kafkaController().process((ControllerEvent)BrokerChange$.MODULE$);
        HashSet<Integer> brokers = new HashSet<Integer>();
        brokers.add(Predef$.MODULE$.int2Integer(0));
        brokers.add(Predef$.MODULE$.int2Integer(1));
        Assertions.assertEquals((Object)((HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new Cell(0, brokers, CellState.READY, 6, 15))}))), (Object)this.kafkaController().controllerContext().cellIdToCell());
    }

    @Test
    public void testAliveBrokersSnapshot() {
        Map brokerEpochs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(1, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(2, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(3, (Seq)new .colon.colon((Object)((EndPoint)Mockito.mock(EndPoint.class)), (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)3L))}));
        this.kafkaController().controllerContext().setLiveBrokers(brokerEpochs);
        this.exclusionCache().overrideMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"reason")}))).asJava());
        this.kafkaController().controllerContext().setDegradedBrokerComponent(1, ComponentHealthStatus.DEGRADED, new DegradedBrokerComponent("demoted broker for test", BrokerComponent.UNSPECIFIED.id()));
        Assertions.assertEquals((Object)new AliveBrokersSnapshot(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToLong((long)3L))}))).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)2)}))).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava()), (Object)this.kafkaController().aliveBrokersSnapshot());
    }

    public void kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult(scala.collection.immutable.Set<BrokerReplicaExclusionResult> receivedResults, int expectedBrokerId, ExclusionOp.OpType expectedOpType) {
        Option findOpt = receivedResults.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)KafkaControllerTest.$anonfun$assertSuccessfulExclusionResult$1(expectedBrokerId, p)));
        Assertions.assertFalse((boolean)findOpt.isEmpty(), (String)new StringBuilder(34).append("Could not find broker ").append(expectedBrokerId).append(" in results ").append(receivedResults).toString());
        BrokerReplicaExclusionResult exclusion = (BrokerReplicaExclusionResult)findOpt.get();
        Assertions.assertEquals((int)expectedBrokerId, (int)exclusion.brokerId());
        Assertions.assertEquals((Object)expectedOpType, (Object)exclusion.opType());
        Assertions.assertTrue((!exclusion.apiErrorOptional().isPresent() ? 1 : 0) != 0, (String)new StringBuilder(51).append("Expected exclusion for broker ").append(expectedBrokerId).append(" to not have an error").toString());
    }

    public void kafka$controller$KafkaControllerTest$$verifyMetricValue(MetricsRegistry metricsRegistry, String metricSimpleName, Integer expectedValue) {
        AtomicReference lastSeenValue = new AtomicReference();
        long x$4 = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$verifyMetricValue$1(this, metricsRegistry, metricSimpleName, lastSeenValue, expectedValue)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$verifyMetricValue$2(metricSimpleName, expectedValue, lastSeenValue));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), waitUntilTrue_pause));
        }
    }

    public void kafka$controller$KafkaControllerTest$$verifyMetricValue(MetricsRegistry metricsRegistry, String metricSimpleName, String expectedValue) {
        AtomicReference lastSeenValue = new AtomicReference();
        long x$4 = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaControllerTest.$anonfun$verifyMetricValue$3(this, metricsRegistry, metricSimpleName, lastSeenValue, expectedValue)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)KafkaControllerTest.$anonfun$verifyMetricValue$4(metricSimpleName, expectedValue, lastSeenValue));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), waitUntilTrue_pause));
        }
    }

    private Metric metric(MetricsRegistry metricsRegistry, String metricSimpleName) {
        java.util.Map metrics = metricsRegistry.allMetrics();
        MetricName metricName = metrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(metricSimpleName) : metricSimpleName != null);
        }).findFirst().get();
        Assertions.assertEquals((long)1L, (long)metrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(metricSimpleName) : metricSimpleName != null);
        }).count());
        Assertions.assertEquals((Object)"kafka.controller", (Object)metricName.getGroup());
        return (Metric)metrics.get(metricName);
    }

    private final void SuccessfulAlterBrokerHealthScenario$lzycompute$1() {
        synchronized (this) {
            if (this.SuccessfulAlterBrokerHealthScenario$module == null) {
                this.SuccessfulAlterBrokerHealthScenario$module = new KafkaControllerTest$SuccessfulAlterBrokerHealthScenario$(this);
            }
            return;
        }
    }

    private final void SuccessfulExclusionScenario$lzycompute$1() {
        synchronized (this) {
            if (this.SuccessfulExclusionScenario$module == null) {
                this.SuccessfulExclusionScenario$module = new KafkaControllerTest$SuccessfulExclusionScenario$(this);
            }
            return;
        }
    }

    private static final void callback$1(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)error.error());
            return;
        }
        if (result instanceof Right) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Expected an error while processing exclusions");
            return;
        }
        throw new MatchError((Object)result);
    }

    private static final void callback$2(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(65).append("Expected no top-level errors while processing exclusions but got ").append(error).toString());
            return;
        }
        if (result instanceof Right) {
            AlterReplicaExclusionsResult result2 = (AlterReplicaExclusionsResult)((Right)result).value();
            Assertions.assertFalse((boolean)result2.wasSuccessful(), (String)"Expected the exclusion operation to not be successful");
            Assertions.assertEquals((int)1, (int)result2.brokerReplicaExclusionResults().size());
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.INVALID_REPLICA_EXCLUSION})), (Object)((IterableOps)((IterableOps)result2.brokerReplicaExclusionResults().map((Function1 & Serializable)r -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(r.apiErrorOptional())))).filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.isDefined()))).map((Function1 & Serializable)e -> ((ApiError)e.get()).error()));
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusions$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusions$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaExclusions$3(InvocationOnMock x$4) {
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaExclusionsDoesntPersistOnDuplicateExclusion$3(InvocationOnMock x$5) {
    }

    private final void callback$3(Either result) {
        if (result instanceof Left) {
            ApiError error = (ApiError)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(65).append("Expected no top-level errors while processing exclusions but got ").append(error).toString());
            return;
        }
        if (result instanceof Right) {
            AlterReplicaExclusionsResult result2 = (AlterReplicaExclusionsResult)((Right)result).value();
            Assertions.assertTrue((boolean)result2.wasSuccessful(), (String)"Expected the exclusion operation to be successful");
            Assertions.assertEquals((int)2, (int)result2.brokerReplicaExclusionResults().size());
            this.kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult((scala.collection.immutable.Set<BrokerReplicaExclusionResult>)result2.brokerReplicaExclusionResults(), 1, ExclusionOp.OpType.DELETE);
            this.kafka$controller$KafkaControllerTest$$assertSuccessfulExclusionResult((scala.collection.immutable.Set<BrokerReplicaExclusionResult>)result2.brokerReplicaExclusionResults(), 2, ExclusionOp.OpType.SET);
            java.util.Map exclusions = this.kafkaController().replicaExclusionCache().exclusions();
            Assertions.assertEquals((int)1, (int)exclusions.size());
            Assertions.assertTrue((boolean)exclusions.containsKey(BoxesRunTime.boxToInteger((int)1)), (String)"Expected exclusion for broker 1 to be present");
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaExclusionsWorksIfDataBalancerThrowsOnNotification$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ boolean $anonfun$startControllerWithABrokerWithDegradedComponent$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$startControllerWithABrokerWithDegradedComponent$2() {
        return "failed to elect the controller";
    }

    public static final /* synthetic */ void $anonfun$startControllerWithABrokerWithDegradedComponent$3(InvocationOnMock x$7) {
    }

    private static final void callback$4(Either result, ObjectRef brokerHealthResults$1) {
        if (result instanceof Left) {
            List results = (List)((Left)result).value();
            brokerHealthResults$1.elem = new Some((Object)results);
            return;
        }
        if (result instanceof Right) {
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealth$2(ObjectRef brokerHealthResults$1) {
        return ((Option)brokerHealthResults$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealth$3() {
        return "failed to get brokerHealthResults";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealth$5(ObjectRef brokerHealthResults$1) {
        return ((Option)brokerHealthResults$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealth$6() {
        return "failed to get brokerHealthResults";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealth$8(ObjectRef brokerHealthResults$1) {
        return ((Option)brokerHealthResults$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealth$9() {
        return "failed to get brokerHealthResults";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealth$11(ObjectRef brokerHealthResults$1) {
        return ((Option)brokerHealthResults$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealth$12() {
        return "failed to get brokerHealthResults";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealth$14(ObjectRef brokerHealthResults$1) {
        return ((Option)brokerHealthResults$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealth$15() {
        return "failed to get brokerHealthResults";
    }

    private static final void callback$5(Either result, ObjectRef brokerHealthResults$2) {
        if (result instanceof Left) {
            List results = (List)((Left)result).value();
            brokerHealthResults$2.elem = new Some((Object)results);
            return;
        }
        if (result instanceof Right) {
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthWithMultipleDegradedComponentsOnBroker$2(ObjectRef brokerHealthResults$2) {
        return ((Option)brokerHealthResults$2.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealthWithMultipleDegradedComponentsOnBroker$3() {
        return "failed to get brokerHealthResults";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthWithMultipleDegradedComponentsOnBroker$5(ObjectRef brokerHealthResults$2) {
        return ((Option)brokerHealthResults$2.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealthWithMultipleDegradedComponentsOnBroker$6() {
        return "failed to get brokerHealthResults";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthWithMultipleReasonsOnDegradedBroker$1(KafkaControllerTest $this) {
        return $this.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealthWithMultipleReasonsOnDegradedBroker$2() {
        return "failed to elect the controller";
    }

    private static final void callback$6(Either result, ObjectRef brokerHealthResults$3) {
        if (result instanceof Left) {
            List results = (List)((Left)result).value();
            brokerHealthResults$3.elem = new Some((Object)results);
            return;
        }
        if (result instanceof Right) {
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthWithMultipleReasonsOnDegradedBroker$4(ObjectRef brokerHealthResults$3) {
        return ((Option)brokerHealthResults$3.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealthWithMultipleReasonsOnDegradedBroker$5() {
        return "failed to get brokerHealthResults";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthWithMultipleReasonsOnDegradedBroker$7(ObjectRef brokerHealthResults$3) {
        return ((Option)brokerHealthResults$3.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealthWithMultipleReasonsOnDegradedBroker$8() {
        return "failed to get brokerHealthResults";
    }

    private static final void callback$7(Either result, ObjectRef brokerHealthResults$4) {
        if (result instanceof Left) {
            List results = (List)((Left)result).value();
            brokerHealthResults$4.elem = new Some((Object)results);
            return;
        }
        if (result instanceof Right) {
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthIfDatabalancerThrows$3(ObjectRef brokerHealthResults$4) {
        return ((Option)brokerHealthResults$4.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealthIfDatabalancerThrows$4() {
        return "failed to get brokerHealthResults";
    }

    private static final void callback$8(Either result, ObjectRef brokerHealthResults$5, ObjectRef requestError$1) {
        if (result instanceof Left) {
            List results = (List)((Left)result).value();
            brokerHealthResults$5.elem = new Some((Object)results);
            return;
        }
        if (result instanceof Right) {
            ApiError error = (ApiError)((Right)result).value();
            requestError$1.elem = new Some((Object)error.error());
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthWhenDemotingBeyondLimit$2(KafkaControllerTest $this) {
        return $this.kafkaController().eventManager().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealthWhenDemotingBeyondLimit$3() {
        return "Request was not handled.";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthWhenDemotingBeyondLimit$4(ObjectRef requestError$1) {
        return ((Option)requestError$1.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealthWhenDemotingBeyondLimit$5() {
        return "Request callback not called, or did not have error.";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthWhenDemotingBeyondLimit$7(ObjectRef brokerHealthResults$5) {
        return ((Option)brokerHealthResults$5.elem).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealthWhenDemotingBeyondLimit$8() {
        return "failed to get brokerHealthResults";
    }

    public static final /* synthetic */ boolean $anonfun$assertSuccessfulExclusionResult$1(int expectedBrokerId$1, BrokerReplicaExclusionResult p) {
        return p.brokerId() == expectedBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetricValue$1(KafkaControllerTest $this, MetricsRegistry metricsRegistry$1, String metricSimpleName$1, AtomicReference lastSeenValue$1, Integer expectedValue$1) {
        Integer value = (Integer)((Gauge)$this.metric(metricsRegistry$1, metricSimpleName$1)).value();
        lastSeenValue$1.set(value);
        Integer n = expectedValue$1;
        return !(n != null ? !((Object)n).equals(value) : value != null);
    }

    public static final /* synthetic */ String $anonfun$verifyMetricValue$2(String metricSimpleName$1, Integer expectedValue$1, AtomicReference lastSeenValue$1) {
        return new StringBuilder(40).append("Expected metric ").append(metricSimpleName$1).append(" to be ").append(expectedValue$1).append(" but instead was ").append(lastSeenValue$1.get()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetricValue$3(KafkaControllerTest $this, MetricsRegistry metricsRegistry$2, String metricSimpleName$2, AtomicReference lastSeenValue$2, String expectedValue$2) {
        String value = (String)((Gauge)$this.metric(metricsRegistry$2, metricSimpleName$2)).value();
        lastSeenValue$2.set(value);
        String string = expectedValue$2;
        return !(string != null ? !string.equals(value) : value != null);
    }

    public static final /* synthetic */ String $anonfun$verifyMetricValue$4(String metricSimpleName$2, String expectedValue$2, AtomicReference lastSeenValue$2) {
        return new StringBuilder(40).append("Expected metric ").append(metricSimpleName$2).append(" to be ").append(expectedValue$2).append(" but instead was ").append(lastSeenValue$2.get()).toString();
    }

    public KafkaControllerTest() {
        this.initialBrokerEpoch = 0L;
        this.epochZkVersion = 0;
    }
}

