/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import kafka.cluster.Replica;
import kafka.cluster.ReplicaState;
import kafka.cluster.ReplicaTest$;
import kafka.log.MergedLog$;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005v!B\u0013'\u0011\u0003Yc!B\u0017'\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004bB\u001c\u0002\u0005\u0004%\t\u0001\u000f\u0005\u0007y\u0005\u0001\u000b\u0011B\u001d\t\u000fu\n!\u0019!C\u0001}!1!*\u0001Q\u0001\n}BqaS\u0001C\u0002\u0013\u0005A\n\u0003\u0004Q\u0003\u0001\u0006I!\u0014\u0004\u0005[\u0019\u0002\u0011\u000bC\u00036\u0013\u0011\u0005!\u000bC\u0004U\u0013\t\u0007I\u0011A+\t\rqK\u0001\u0015!\u0003W\u0011%i\u0016\u00021AA\u0002\u0013\u0005a\fC\u0005c\u0013\u0001\u0007\t\u0019!C\u0001G\"I\u0011.\u0003a\u0001\u0002\u0003\u0006Ka\u0018\u0005\u0006U&!\ta\u001b\u0005\u0006o&!I\u0001\u001f\u0005\n\u0003#I\u0011\u0013!C\u0005\u0003'Aq!!\u000b\n\t\u0003\tY\u0003C\u0004\u00028%!I!!\u000f\t\u000f\u0005\u001d\u0013\u0002\"\u0003\u0002J!9\u00111L\u0005\u0005\n\u0005u\u0003bBA1\u0013\u0011%\u00111\r\u0005\u0007\u0003OJA\u0011A6\t\r\u0005E\u0014\u0002\"\u0001l\u0011\u0019\t)(\u0003C\u0001W\"1\u0011\u0011P\u0005\u0005\u0002-Da!! \n\t\u0003Y\u0007BBAA\u0013\u0011\u00051\u000e\u0003\u0004\u0002\u0006&!\ta\u001b\u0005\u0007\u0003\u0013KA\u0011A6\t\r\u00055\u0015\u0002\"\u0001l\u0011\u0019\t\t*\u0003C\u0001W\"1\u0011QS\u0005\u0005\u0002-Da!!'\n\t\u0003Y\u0007BBAO\u0013\u0011\u00051.A\u0006SKBd\u0017nY1UKN$(BA\u0014)\u0003\u001d\u0019G.^:uKJT\u0011!K\u0001\u0006W\u000647.Y\u0002\u0001!\ta\u0013!D\u0001'\u0005-\u0011V\r\u001d7jG\u0006$Vm\u001d;\u0014\u0005\u0005y\u0003C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002W\u0005A!I]8lKJLE-F\u0001:!\t\u0001$(\u0003\u0002<c\t\u0019\u0011J\u001c;\u0002\u0013\t\u0013xn[3s\u0013\u0012\u0004\u0013!\u0003)beRLG/[8o+\u0005y\u0004C\u0001!I\u001b\u0005\t%B\u0001\"D\u0003\u0019\u0019w.\\7p]*\u0011\u0011\u0006\u0012\u0006\u0003\u000b\u001a\u000ba!\u00199bG\",'\"A$\u0002\u0007=\u0014x-\u0003\u0002J\u0003\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u0003)beRLG/[8oA\u0005\u0019\"+\u001a9mS\u000e\fG*Y4US6,W*\u0019=NgV\tQ\n\u0005\u00021\u001d&\u0011q*\r\u0002\u0005\u0019>tw-\u0001\u000bSKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5\u000fI\n\u0003\u0013=\"\u0012a\u0015\t\u0003Y%\tA\u0001^5nKV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002ZQ\u0005)Q\u000f^5mg&\u00111\f\u0017\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059!/\u001a9mS\u000e\fW#A0\u0011\u00051\u0002\u0017BA1'\u0005\u001d\u0011V\r\u001d7jG\u0006\f1B]3qY&\u001c\u0017m\u0018\u0013fcR\u0011Am\u001a\t\u0003a\u0015L!AZ\u0019\u0003\tUs\u0017\u000e\u001e\u0005\bQ:\t\t\u00111\u0001`\u0003\rAH%M\u0001\te\u0016\u0004H.[2bA\u0005)1/\u001a;vaR\tA\r\u000b\u0002\u0011[B\u0011a.^\u0007\u0002_*\u0011\u0001/]\u0001\u0004CBL'B\u0001:t\u0003\u001dQW\u000f]5uKJT!\u0001\u001e$\u0002\u000b),h.\u001b;\n\u0005Y|'A\u0003\"fM>\u0014X-R1dQ\u0006\u0011\u0012m]:feR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f)%!\u0017p_?\u0000\u0003\u0007\t9\u0001C\u0003{#\u0001\u0007Q*\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\t\u000bq\f\u0002\u0019A'\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\t\u000by\f\u0002\u0019A'\u0002%1\f7\u000f^\"bk\u001eDG/\u00169US6,Wj\u001d\u0005\u0007\u0003\u0003\t\u0002\u0019A'\u000271\f7\u000f\u001e$fi\u000eDG*Z1eKJdunZ#oI>3gm]3u\u0011\u0019\t)!\u0005a\u0001\u001b\u0006yA.Y:u\r\u0016$8\r\u001b+j[\u0016l5\u000fC\u0005\u0002\nE\u0001\n\u00111\u0001\u0002\f\u0005Y!M]8lKJ,\u0005o\\2i!\u0011\u0001\u0014QB'\n\u0007\u0005=\u0011G\u0001\u0004PaRLwN\\\u0001\u001dCN\u001cXM\u001d;SKBd\u0017nY1Ti\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00137+\t\t)B\u000b\u0003\u0002\f\u0005]1FAA\r!\u0011\tY\"!\n\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r\u0012'\u0001\u0006b]:|G/\u0019;j_:LA!a\n\u0002\u001e\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002?\u0005\u001c8/\u001a:u%\u0016\u0004H.[2b'R\fG/\u001a#pKNtu\u000e^\"iC:<W\rF\u0002e\u0003[A\u0001\"a\f\u0014\t\u0003\u0007\u0011\u0011G\u0001\u0003_B\u0004B\u0001MA\u001aI&\u0019\u0011QG\u0019\u0003\u0011q\u0012\u0017P\\1nKz\n\u0001#\u001e9eCR,g)\u001a;dQN#\u0018\r^3\u0015\u000f5\u000bY$a\u0010\u0002D!1\u0011Q\b\u000bA\u00025\u000b1CZ8mY><XM\u001d$fi\u000eDwJ\u001a4tKRDa!!\u0011\u0015\u0001\u0004i\u0015a\u00054pY2|w/\u001a:Ti\u0006\u0014Ho\u00144gg\u0016$\bBBA#)\u0001\u0007Q*A\bmK\u0006$WM]#oI>3gm]3u\u0003E\u0011Xm]3u%\u0016\u0004H.[2b'R\fG/\u001a\u000b\b\u001b\u0006-\u0013QJA,\u0011\u0019\t)%\u0006a\u0001\u001b\"9\u0011qJ\u000bA\u0002\u0005E\u0013aC5t\u001d\u0016<H*Z1eKJ\u00042\u0001MA*\u0013\r\t)&\r\u0002\b\u0005>|G.Z1o\u0011\u001d\tI&\u0006a\u0001\u0003#\n\u0001#[:G_2dwn^3s\u0013:\u001c\u0016P\\2\u000255\f\u0017PY3SKN,G\u000fT1ti\u000e\u000bWo\u001a5u+B$\u0016.\\3\u0015\u00075\u000by\u0006\u0003\u0004\u0002FY\u0001\r!T\u0001\u000bSN\u001c\u0015-^4iiV\u0003H\u0003BA)\u0003KBa!!\u0012\u0018\u0001\u0004i\u0015\u0001\u0005;fgRLe.\u001b;jC2\u001cF/\u0019;fQ\rA\u00121\u000e\t\u0004]\u00065\u0014bAA8_\n!A+Z:u\u0003Q!Xm\u001d;Va\u0012\fG/\u001a$fi\u000eD7\u000b^1uK\"\u001a\u0011$a\u001b\u0002yQ,7\u000f\u001e*fg\u0016$(+\u001a9mS\u000e\f7\u000b^1uK^CWM\u001c'fC\u0012,'/S:SK\u0016dWm\u0019;fI\u0006sGMU3qY&\u001c\u0017-S:J]NKhn\u0019\u0015\u00045\u0005-\u0014a\u0010;fgR\u0014Vm]3u%\u0016\u0004H.[2b'R\fG/Z,iK:dU-\u00193fe&\u001b(+Z3mK\u000e$X\rZ!oIJ+\u0007\u000f\\5dC&\u001bhj\u001c;J]NKhn\u0019\u0015\u00047\u0005-\u0014!\u0010;fgR\u0014Vm]3u%\u0016\u0004H.[2b'R\fG/Z,iK:tUm\u001e'fC\u0012,'/S:FY\u0016\u001cG/\u001a3B]\u0012\u0014V\r\u001d7jG\u0006L5/\u00138Ts:\u001c\u0007f\u0001\u000f\u0002l\u0005\u0001E/Z:u%\u0016\u001cX\r\u001e*fa2L7-Y*uCR,w\u000b[3o\u001d\u0016<H*Z1eKJL5/\u00127fGR,G-\u00118e%\u0016\u0004H.[2b\u0013Ntu\u000e^%o'ft7\rK\u0002\u001e\u0003W\n\u0011\u0004^3tiJ+7/\u001a;MCN$8)Y;hQR,\u0006\u000fV5nK\"\u001aa$a\u001b\u0002\u000fR,7\u000f\u001e*fg\u0016$H*Y:u\u0007\u0006,x\r\u001b;VaRKW.Z%t\u001d>$(+Z:fi\u00063G/\u001a:MK\u0006$WM]#mK\u000e$X\rZ!oIJ+\u0007\u000f\\5dC:{G/\u00138JgJD3aHA6\u0003\u001d#Xm\u001d;MCN$8)Y;hQR,\u0006\u000fV5nK&\u001bhj\u001c;SKN,Go\u00165f]V\u0003H-\u0019;f\r\u0016$8\r[*uCR,w+\u001b;i'R\fG.\u001a'pO\u0016sGm\u00144gg\u0016$\bf\u0001\u0011\u0002l\u0005AD/Z:u%\u0016\u0004H.[2b'\"|W\u000f\u001c3O_R\u0014UmQ1vO\"$X\u000b],iK:,6/\u001b8h'R\fG.\u001a'pO\u0016sGm\u00144gg\u0016$\bfA\u0011\u0002l\u0005YC/Z:u\u0013N\u001c\u0015-^4iiV\u0003x\u000b[3o%\u0016\u0004H.[2b\u0013N\u001c\u0015-^4iiV\u0003Hk\u001c'pO\u0016sG\rK\u0002#\u0003W\na\u0006^3ti&\u001b8)Y;hQR,\u0006o\u00165f]J+\u0007\u000f\\5dC&\u001bhj\u001c;DCV<\u0007\u000e^+q)>dunZ#oI\"\u001a1%a\u001b\u0002\u0017R,7\u000f^%t\u0007\u0006,x\r\u001b;VaRKW.Z%t\u001d>$\u0018\t\\<bsN\u0014Vm]3u/\",gNR8mY><XM]%t\u0007\u0006,x\r\u001b;VaR{7\u000b^1mK2{w-\u00128e\u001f\u001a47/\u001a;)\u0007\u0011\nY\u0007")
public class ReplicaTest {
    private final MockTime time = new MockTime();
    private Replica replica;

    public static long ReplicaLagTimeMaxMs() {
        return ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs();
    }

    public static TopicPartition Partition() {
        return ReplicaTest$.MODULE$.Partition();
    }

    public static int BrokerId() {
        return ReplicaTest$.MODULE$.BrokerId();
    }

    public MockTime time() {
        return this.time;
    }

    public Replica replica() {
        return this.replica;
    }

    public void replica_$eq(Replica x$1) {
        this.replica = x$1;
    }

    @BeforeEach
    public void setup() {
        this.replica_$eq(new Replica(ReplicaTest$.MODULE$.BrokerId(), ReplicaTest$.MODULE$.Partition()));
    }

    private void assertReplicaState(long logStartOffset, long logEndOffset, long lastCaughtUpTimeMs, long lastFetchLeaderLogEndOffset, long lastFetchTimeMs, Option<Object> brokerEpoch) {
        ReplicaState replicaState = this.replica().stateSnapshot();
        Assertions.assertEquals((long)logStartOffset, (long)replicaState.logStartOffset(), (String)"Unexpected Log Start Offset");
        Assertions.assertEquals((long)logEndOffset, (long)replicaState.logEndOffset(), (String)"Unexpected Log End Offset");
        Assertions.assertEquals((long)lastCaughtUpTimeMs, (long)replicaState.lastCaughtUpTimeMs(), (String)"Unexpected Last Caught Up Time");
        Assertions.assertEquals((long)lastFetchLeaderLogEndOffset, (long)replicaState.lastFetchLeaderLogEndOffset(), (String)"Unexpected Last Fetch Leader Log End Offset");
        Assertions.assertEquals((long)lastFetchTimeMs, (long)replicaState.lastFetchTimeMs(), (String)"Unexpected Last Fetch Time");
        Assertions.assertEquals(brokerEpoch, (Object)replicaState.brokerEpoch(), (String)"Broker Epoch Mismatch");
    }

    private Option<Object> assertReplicaState$default$6() {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L));
    }

    public void assertReplicaStateDoesNotChange(Function0<BoxedUnit> op) {
        ReplicaState previousState = this.replica().stateSnapshot();
        op.apply$mcV$sp();
        this.assertReplicaState(previousState.logStartOffset(), previousState.logEndOffset(), previousState.lastCaughtUpTimeMs(), previousState.lastFetchLeaderLogEndOffset(), previousState.lastFetchTimeMs(), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
    }

    private long updateFetchState(long followerFetchOffset, long followerStartOffset, long leaderEndOffset) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().updateFetchState(new LogOffsetMetadata(followerFetchOffset), followerStartOffset, currentTimeMs, leaderEndOffset, 1L);
        return currentTimeMs;
    }

    private long resetReplicaState(long leaderEndOffset, boolean isNewLeader, boolean isFollowerInSync) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().resetReplicaState(currentTimeMs, leaderEndOffset, isNewLeader, isFollowerInSync);
        return currentTimeMs;
    }

    private long maybeResetLastCaughtUpTime(long leaderEndOffset) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().maybeResetLastCaughtUpTime(currentTimeMs, leaderEndOffset);
        return currentTimeMs;
    }

    private boolean isCaughtUp(long leaderEndOffset) {
        return this.replica().stateSnapshot().isCaughtUp(leaderEndOffset, this.time().milliseconds(), ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs());
    }

    @Test
    public void testInitialState() {
        this.assertReplicaState(MergedLog$.MODULE$.UnknownOffset(), MergedLog$.MODULE$.UnknownOffset(), 0L, 0L, 0L, (Option<Object>)Option$.MODULE$.empty());
    }

    @Test
    public void testUpdateFetchState() {
        long fetchTimeMs1 = this.updateFetchState(5L, 1L, 10L);
        this.assertReplicaState(1L, 5L, 0L, 10L, fetchTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        long fetchTimeMs2 = this.updateFetchState(10L, 2L, 15L);
        this.assertReplicaState(2L, 10L, fetchTimeMs1, 15L, fetchTimeMs2, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        long fetchTimeMs3 = this.updateFetchState(15L, 3L, 15L);
        this.assertReplicaState(3L, 15L, fetchTimeMs3, 15L, fetchTimeMs3, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, false, true);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, false, false);
        this.assertReplicaState(1L, 10L, 0L, 11L, 0L, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, true, true);
        this.assertReplicaState(MergedLog$.MODULE$.UnknownOffset(), MergedLog$.MODULE$.UnknownOffset(), resetTimeMs1, MergedLog$.MODULE$.UnknownOffset(), 0L, (Option<Object>)Option$.MODULE$.empty());
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, true, false);
        this.assertReplicaState(MergedLog$.MODULE$.UnknownOffset(), MergedLog$.MODULE$.UnknownOffset(), 0L, MergedLog$.MODULE$.UnknownOffset(), 0L, (Option<Object>)Option$.MODULE$.empty());
    }

    @Test
    public void testResetLastCaughtUpTime() {
        this.updateFetchState(5L, 1L, 10L);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(15L));
        this.time().sleep(1000L);
        this.updateFetchState(10L, 1L, 15L);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(16L));
        this.time().sleep(1000L);
        this.updateFetchState(16L, 1L, 16L);
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(16L));
        long resetTimeMs1 = this.maybeResetLastCaughtUpTime(17L);
        this.assertReplicaState(1L, 16L, resetTimeMs1, 17L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
    }

    @Test
    public void testResetLastCaughtUpTimeIsNotResetAfterLeaderElectedAndReplicaNotInIsr() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(10L, false, false);
        this.assertReplicaState(1L, 10L, 0L, 10L, 0L, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(11L));
    }

    @Test
    public void testLastCaughtUpTimeIsNotResetWhenUpdateFetchStateWithStaleLogEndOffset() {
        long fetchTimeMs1 = this.updateFetchState(10L, 1L, 10L);
        this.assertReplicaState(1L, 10L, fetchTimeMs1, 10L, fetchTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        this.time().sleep(1000L);
        long resetTimeMs1 = this.maybeResetLastCaughtUpTime(11L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        this.updateFetchState(10L, 1L, 10L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
    }

    @Test
    public void testReplicaShouldNotBeCaughtUpWhenUsingStaleLogEndOffset() {
        long fetchTimeMs1 = this.updateFetchState(0L, 0L, 10L);
        this.assertReplicaState(0L, 0L, 0L, 10L, fetchTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        this.time().sleep(1000L);
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(11L));
        this.assertReplicaStateDoesNotChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeResetLastCaughtUpTime(12L));
        this.updateFetchState(10L, 1L, 10L);
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(12L));
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 10L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsNotCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(5L, 1L, 10L);
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 15L);
        Assertions.assertTrue((boolean)this.isCaughtUp(16L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(16L));
    }

    @Test
    public void testIsCaughtUpTimeIsNotAlwaysResetWhenFollowerIsCaughtUpToStaleLogEndOffset() {
        long fetchTimeMs1 = this.updateFetchState(10L, 1L, 10L);
        this.assertReplicaState(1L, 10L, fetchTimeMs1, 10L, fetchTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        this.time().sleep(1000L);
        long resetTimeMs1 = this.maybeResetLastCaughtUpTime(11L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertTrue((boolean)this.isCaughtUp(11L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() / 2L);
        this.maybeResetLastCaughtUpTime(12L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertTrue((boolean)this.isCaughtUp(12L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() / 2L);
        this.maybeResetLastCaughtUpTime(13L);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertTrue((boolean)this.isCaughtUp(13L));
        this.time().sleep(1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(13L));
    }
}

