/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileStore;
import java.util.Map;
import java.util.Properties;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.DelayedOperations;
import kafka.cluster.ObserverPartitionTest$;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.SegmentDeletionThrottlerConfig;
import kafka.log.TierLogComponents$;
import kafka.server.AlterPartitionManager;
import kafka.server.ConfluentObserverTest;
import kafka.server.ConfluentObserverTest$;
import kafka.server.Defaults$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.tier.TierReplicaManager;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001B\u0011#\u0005\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u0004;\u0001\u0001\u0006I\u0001\u000e\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019\u0001\u0005\u0001)A\u0005{!I\u0011\t\u0001a\u0001\u0002\u0004%\tA\u0011\u0005\n\u0013\u0002\u0001\r\u00111A\u0005\u0002)C\u0011\u0002\u0015\u0001A\u0002\u0003\u0005\u000b\u0015B\"\t\u0013E\u0003\u0001\u0019!a\u0001\n\u0003\u0011\u0006\"C.\u0001\u0001\u0004\u0005\r\u0011\"\u0001]\u0011%q\u0006\u00011A\u0001B\u0003&1\u000bC\u0005`\u0001\u0001\u0007\t\u0019!C\u0001A\"IA\r\u0001a\u0001\u0002\u0004%\t!\u001a\u0005\nO\u0002\u0001\r\u0011!Q!\n\u0005Dq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011\u000e\u0003\u0004n\u0001\u0001\u0006IA\u001b\u0005\b]\u0002\u0011\r\u0011\"\u0001p\u0011\u00191\b\u0001)A\u0005a\"9q\u000f\u0001b\u0001\n\u0003A\bBB@\u0001A\u0003%\u0011\u0010C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001\u0002\u0004!A\u00111\u0002\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011q\u0005\u0001!\u0002\u0013\t\t\u0002C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002,!9\u0011Q\n\u0001\u0005\u0002\u0005-raBA,E!\u0005\u0011\u0011\f\u0004\u0007C\tB\t!a\u0017\t\r9jB\u0011AA/\u0011\u001d\ty&\bC\u0001\u0003CBq!a\u001d\u001e\t\u0003\t)HA\u000bPEN,'O^3s!\u0006\u0014H/\u001b;j_:$Vm\u001d;\u000b\u0005\r\"\u0013aB2mkN$XM\u001d\u0006\u0002K\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001)!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\r\t\u0003c\u0001i\u0011AI\u0001\u0005i&lW-F\u00015!\t)\u0004(D\u00017\u0015\t9D%A\u0003vi&d7/\u0003\u0002:m\tAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\u0005ce>\\WM]%e+\u0005i\u0004CA\u0015?\u0013\ty$FA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u00151|w-T1oC\u001e,'/F\u0001D!\t!u)D\u0001F\u0015\t1E%A\u0002m_\u001eL!\u0001S#\u0003\u00151{w-T1oC\u001e,'/\u0001\bm_\u001el\u0015M\\1hKJ|F%Z9\u0015\u0005-s\u0005CA\u0015M\u0013\ti%F\u0001\u0003V]&$\bbB(\b\u0003\u0003\u0005\raQ\u0001\u0004q\u0012\n\u0014a\u00037pO6\u000bg.Y4fe\u0002\na\u0001^7q\t&\u0014X#A*\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016AA5p\u0015\u0005A\u0016\u0001\u00026bm\u0006L!AW+\u0003\t\u0019KG.Z\u0001\u000bi6\u0004H)\u001b:`I\u0015\fHCA&^\u0011\u001dy%\"!AA\u0002M\u000bq\u0001^7q\t&\u0014\b%A\u0005qCJ$\u0018\u000e^5p]V\t\u0011\r\u0005\u00022E&\u00111M\t\u0002\n!\u0006\u0014H/\u001b;j_:\fQ\u0002]1si&$\u0018n\u001c8`I\u0015\fHCA&g\u0011\u001dyU\"!AA\u0002\u0005\f!\u0002]1si&$\u0018n\u001c8!\u0003=!W\r\\1z\u001fB,'/\u0019;j_:\u001cX#\u00016\u0011\u0005EZ\u0017B\u00017#\u0005E!U\r\\1zK\u0012|\u0005/\u001a:bi&|gn]\u0001\u0011I\u0016d\u0017-_(qKJ\fG/[8og\u0002\nQ\"\\3uC\u0012\fG/Y\"bG\",W#\u00019\u0011\u0005E$X\"\u0001:\u000b\u0005M$\u0013AB:feZ,'/\u0003\u0002ve\niQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fa\"\\3uC\u0012\fG/Y\"bG\",\u0007%A\tpM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oiN,\u0012!\u001f\t\u0003uvl\u0011a\u001f\u0006\u0003yJ\f1b\u00195fG.\u0004x.\u001b8ug&\u0011ap\u001f\u0002\u0012\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R\u001c\u0018AE8gMN,Go\u00115fG.\u0004x.\u001b8ug\u0002\na#\u00197uKJ\u0004\u0016M\u001d;ji&|g\u000eT5ti\u0016tWM]\u000b\u0003\u0003\u000b\u00012!MA\u0004\u0013\r\tIA\t\u0002\u0017\u00032$XM\u001d)beRLG/[8o\u0019&\u001cH/\u001a8fe\u00069\u0012\r\u001c;feB\u000b'\u000f^5uS>tG*[:uK:,'\u000fI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005\rRBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\r\r|W.\\8o\u0015\r)\u00131\u0004\u0006\u0005\u0003;\ty\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003C\t1a\u001c:h\u0013\u0011\t)#!\u0006\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%A\u0003tKR,\b\u000fF\u0001LQ\rI\u0012q\u0006\t\u0005\u0003c\ty$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\r\t\u0007/\u001b\u0006\u0005\u0003s\tY$A\u0004kkBLG/\u001a:\u000b\t\u0005u\u0012qD\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u0003\n\u0019D\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u00045\u0005\u001d\u0003\u0003BA\u0019\u0003\u0013JA!a\u0013\u00024\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001/i\u0016\u001cH\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0017J\\2sK\u0006\u001cXm],ji\"|W\u000f^(cg\u0016\u0014h/\u001a:GKR\u001c\u0007\u000eK\u0002\u001c\u0003#\u0002B!!\r\u0002T%!\u0011QKA\u001a\u0005\u0011!Vm\u001d;\u0002+=\u00137/\u001a:wKJ\u0004\u0016M\u001d;ji&|g\u000eV3tiB\u0011\u0011'H\n\u0003;!\"\"!!\u0017\u0002\u0017M,W\r\u001a'pO\u0012\u000bG/\u0019\u000b\b\u0017\u0006\r\u00141NA8\u0011\u00191u\u00041\u0001\u0002fA\u0019A)a\u001a\n\u0007\u0005%TIA\u0006BEN$(/Y2u\u0019><\u0007BBA7?\u0001\u0007Q(\u0001\u0006ok6\u0014VmY8sINDa!!\u001d \u0001\u0004i\u0014a\u00037fC\u0012,'/\u00129pG\"\f1c\u0019:fCR,Gj\\4Qe>\u0004XM\u001d;jKN$B!a\u001e\u0002\u0004B!\u0011\u0011PA@\u001b\t\tYHC\u0002\u0002~]\u000bA!\u001e;jY&!\u0011\u0011QA>\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003\u000b\u0003\u0003\u0019AAD\u0003%yg/\u001a:sS\u0012,7\u000f\u0005\u0005\u0002\n\u0006]\u0015QTAO\u001d\u0011\tY)a%\u0011\u0007\u00055%&\u0004\u0002\u0002\u0010*\u0019\u0011\u0011\u0013\u0014\u0002\rq\u0012xn\u001c;?\u0013\r\t)JK\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00151\u0014\u0002\u0004\u001b\u0006\u0004(bAAKUA!\u0011\u0011RAP\u0013\u0011\t\t+a'\u0003\rM#(/\u001b8h\u0001")
public final class ObserverPartitionTest {
    private final MockTime time = new MockTime();
    private final int brokerId;
    private LogManager logManager;
    private File tmpDir;
    private Partition partition;
    private final DelayedOperations delayOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private final AlterPartitionListener alterPartitionListener = (AlterPartitionListener)Mockito.mock(AlterPartitionListener.class);
    private final TopicPartition topicPartition = new TopicPartition("test-observer", 0);

    public static Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        return ObserverPartitionTest$.MODULE$.createLogProperties(overrides);
    }

    public static void seedLogData(AbstractLog log, int numRecords, int leaderEpoch) {
        ObserverPartitionTest$.MODULE$.seedLogData(log, numRecords, leaderEpoch);
    }

    public MockTime time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public DelayedOperations delayOperations() {
        return this.delayOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public AlterPartitionListener alterPartitionListener() {
        return this.alterPartitionListener;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @BeforeEach
    public void setup() {
        Properties logProperties = ObserverPartitionTest$.MODULE$.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(2, "replica"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(1, "observer"))))}))));
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        File logDir1 = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.topicPartition().topic(), logProperties);
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)logDir1, (List)Nil$.MODULE$), new LogConfig((Map)logProperties), configRepository, new CleanerConfig(false), this.time(), new Metrics(), new SegmentDeletionThrottlerConfig(){

            public Seq<FileStore> fileStores(Seq<File> logDirs) {
                return (Seq)logDirs.map((Function1 & Serializable)x$32 -> new TestUtils.DeterministicFileStore(TestUtils$.MODULE$.DefaultTotalAvailableBytes(), TestUtils$.MODULE$.DefaultInitialUsableBytes()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fileStores$1(java.io.File )}, serializedLambda);
            }
        }, MetadataVersion.latest(), TierLogComponents$.MODULE$.EMPTY(), 4));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), MetadataVersion.latest(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L, (Time)this.time(), this.alterPartitionListener(), this.delayOperations(), this.metadataCache(), this.logManager(), (Option)new Some(Mockito.mock(TierReplicaManager.class)), (Option)new Some(Mockito.mock(TierStateFetcher.class)), (Option)None$.MODULE$, (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.metadataCache().getBrokerTags(ArgumentMatchers.anyInt())).thenReturn((Object)Predef$.MODULE$.Map().empty());
    }

    @AfterEach
    public void tearDown() {
        this.logManager().shutdown();
        Utils.delete((File)this.tmpDir(), (boolean)false);
    }

    @Test
    public void testHighWatermarkIncreasesWithoutObserverFetch() {
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int followerId = this.brokerId() + 1;
        int observerId = followerId + 1;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(followerId), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(observerId), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(followerId), (List)Nil$.MODULE$))).asJava();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        ObserverPartitionTest$.MODULE$.seedLogData(log, 6, 4);
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topicPartition().topic()).setPartitionIndex(this.topicPartition().partition()).setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setPartitionEpoch(1).setReplicas(replicas).setObservers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(observerId), (List)Nil$.MODULE$)).asJava()).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        this.partition().updateFollowerFetchState((Replica)this.partition().getReplica(observerId).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(58).append("Failed to find replica state for observer ").append(observerId).append(" from partition ").append(this.partition()).toString())), new LogOffsetMetadata(3L), 0L, this.time().milliseconds(), 3L, 1L);
        this.partition().updateFollowerFetchState((Replica)this.partition().getReplica(followerId).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(58).append("Failed to find replica state for follower ").append(followerId).append(" from partition ").append(this.partition()).toString())), new LogOffsetMetadata(5L), 0L, this.time().milliseconds(), 5L, 1L);
        Assertions.assertEquals((long)this.partition().localLogOrException().highWatermark(), (long)5L, (String)"Expect the high watermark to only include followers");
    }

    public ObserverPartitionTest() {
        this.brokerId = 101;
    }
}

