/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileStore;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.cluster.AbstractPartitionTest$;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.SegmentDeletionThrottlerConfig;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.AlterPartitionManager;
import kafka.server.Defaults$;
import kafka.server.MetadataCache;
import kafka.server.ZkAlterPartitionManager;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.tier.TierReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r]r!B(Q\u0011\u0003)f!B,Q\u0011\u0003A\u0006\"B0\u0002\t\u0003\u0001\u0007bB1\u0002\u0005\u0004%\tA\u0019\u0005\u0007M\u0006\u0001\u000b\u0011B2\u0007\t]\u0003\u0006a\u001a\u0005\u0006?\u0016!\t\u0001\u001b\u0005\bC\u0016\u0011\r\u0011\"\u0001c\u0011\u00191W\u0001)A\u0005G\"9!.\u0002b\u0001\n\u0003\u0011\u0007BB6\u0006A\u0003%1\rC\u0004m\u000b\t\u0007I\u0011A7\t\re,\u0001\u0015!\u0003o\u0011\u001dQXA1A\u0005\u0002mDq!!\u0002\u0006A\u0003%A\u0010C\u0006\u0002\b\u0015\u0001\r\u00111A\u0005\u0002\u0005%\u0001bCA\u000e\u000b\u0001\u0007\t\u0019!C\u0001\u0003;A1\"!\u000b\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002\f!Y\u00111F\u0003A\u0002\u0003\u0007I\u0011AA\u0005\u0011-\ti#\u0002a\u0001\u0002\u0004%\t!a\f\t\u0017\u0005MR\u00011A\u0001B\u0003&\u00111\u0002\u0005\f\u0003k)\u0001\u0019!a\u0001\n\u0003\tI\u0001C\u0006\u00028\u0015\u0001\r\u00111A\u0005\u0002\u0005e\u0002bCA\u001f\u000b\u0001\u0007\t\u0011)Q\u0005\u0003\u0017A1\"a\u0010\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002\n!Y\u0011\u0011I\u0003A\u0002\u0003\u0007I\u0011AA\"\u0011-\t9%\u0002a\u0001\u0002\u0003\u0006K!a\u0003\t\u0017\u0005%S\u00011AA\u0002\u0013\u0005\u00111\n\u0005\f\u00033*\u0001\u0019!a\u0001\n\u0003\tY\u0006C\u0006\u0002`\u0015\u0001\r\u0011!Q!\n\u00055\u0003bCA1\u000b\u0001\u0007\t\u0019!C\u0001\u0003GB1\"!!\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0004\"Y\u0011qQ\u0003A\u0002\u0003\u0005\u000b\u0015BA3\u0011-\tI)\u0002a\u0001\u0002\u0004%\t!a#\t\u0017\u0005MU\u00011AA\u0002\u0013\u0005\u0011Q\u0013\u0005\f\u00033+\u0001\u0019!A!B\u0013\ti\tC\u0006\u0002\u001c\u0016\u0001\r\u00111A\u0005\u0002\u0005u\u0005bCAY\u000b\u0001\u0007\t\u0019!C\u0001\u0003gC1\"a.\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002 \"Y\u0011\u0011X\u0003A\u0002\u0003\u0007I\u0011AA^\u0011-\ti-\u0002a\u0001\u0002\u0004%\t!a4\t\u0017\u0005MW\u00011A\u0001B\u0003&\u0011Q\u0018\u0005\n\u0003+,!\u0019!C\u0001\u0003/D\u0001\"a8\u0006A\u0003%\u0011\u0011\u001c\u0005\n\u0003C,!\u0019!C\u0001\u0003GD\u0001\"!<\u0006A\u0003%\u0011Q\u001d\u0005\n\u0003_,!\u0019!C\u0001\u0003cD\u0001\"a@\u0006A\u0003%\u00111\u001f\u0005\f\u0005\u0003)\u0001\u0019!a\u0001\n\u0003\u0011\u0019\u0001C\u0006\u0003\f\u0015\u0001\r\u00111A\u0005\u0002\t5\u0001b\u0003B\t\u000b\u0001\u0007\t\u0011)Q\u0005\u0005\u000bA\u0001Ba\u0005\u0006\u0005\u0004%\t!\u001c\u0005\b\u0005+)\u0001\u0015!\u0003o\u0011%\u00119\"\u0002b\u0001\n\u0003\u0011I\u0002\u0003\u0005\u0003(\u0015\u0001\u000b\u0011\u0002B\u000e\u0011-\u0011I#\u0002a\u0001\u0002\u0004%\t!a\u0013\t\u0017\t-R\u00011AA\u0002\u0013\u0005!Q\u0006\u0005\f\u0005c)\u0001\u0019!A!B\u0013\ti\u0005C\u0005\u00034\u0015\u0011\r\u0011\"\u0001\u00036!A!QH\u0003!\u0002\u0013\u00119\u0004C\u0005\u0003@\u0015\u0011\r\u0011\"\u0001\u0003B!A!\u0011J\u0003!\u0002\u0013\u0011\u0019\u0005C\u0005\u0003L\u0015\u0011\r\u0011\"\u0001\u0003N!A!1L\u0003!\u0002\u0013\u0011y\u0005C\u0005\u0003^\u0015\u0011\r\u0011\"\u0001\u0003`!A!QN\u0003!\u0002\u0013\u0011\t\u0007C\u0006\u0003p\u0015\u0001\r\u00111A\u0005\u0002\u0005u\u0005b\u0003B9\u000b\u0001\u0007\t\u0019!C\u0001\u0005gB1Ba\u001e\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002 \"9!\u0011P\u0003\u0005\u0002\tm\u0004b\u0002BJ\u000b\u0011\u0005!Q\u0013\u0005\n\u0005\u000b,\u0011\u0013!C\u0001\u0005\u000fD\u0011B!8\u0006#\u0003%\tAa8\t\u0013\t\rX!%A\u0005\u0002\t\u0015\bb\u0002BM\u000b\u0011E!\u0011\u001e\u0005\b\u0005W,A\u0011\u0001Bw\u0011\u001d\u0019y!\u0002C\u0001\u0005wBqa!\u0007\u0006\t#\u0019Y\u0002C\u0004\u0004,\u0015!\ta!\f\u0002+\u0005\u00137\u000f\u001e:bGR\u0004\u0016M\u001d;ji&|g\u000eV3ti*\u0011\u0011KU\u0001\bG2,8\u000f^3s\u0015\u0005\u0019\u0016!B6bM.\f7\u0001\u0001\t\u0003-\u0006i\u0011\u0001\u0015\u0002\u0016\u0003\n\u001cHO]1diB\u000b'\u000f^5uS>tG+Z:u'\t\t\u0011\f\u0005\u0002[;6\t1LC\u0001]\u0003\u0015\u00198-\u00197b\u0013\tq6L\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u000b\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002GB\u0011!\fZ\u0005\u0003Kn\u00131!\u00138u\u0003%\u0011'o\\6fe&#\u0007e\u0005\u0002\u00063R\t\u0011\u000e\u0005\u0002W\u000b\u0005y!/Z7pi\u0016\u0014V\r\u001d7jG\u0006LE-\u0001\tsK6|G/\u001a*fa2L7-Y%eA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#\u00018\u0011\u0005=<X\"\u00019\u000b\u0005E\u0014\u0018AB2p[6|gN\u0003\u0002Tg*\u0011A/^\u0001\u0007CB\f7\r[3\u000b\u0003Y\f1a\u001c:h\u0013\tA\bO\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nA\u0001^5nKV\tA\u0010E\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007fJ\u000bQ!\u001e;jYNL1!a\u0001\u007f\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u0002;na\u0012K'/\u0006\u0002\u0002\fA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011AA5p\u0015\t\t)\"\u0001\u0003kCZ\f\u0017\u0002BA\r\u0003\u001f\u0011AAR5mK\u0006QA/\u001c9ESJ|F%Z9\u0015\t\u0005}\u0011Q\u0005\t\u00045\u0006\u0005\u0012bAA\u00127\n!QK\\5u\u0011%\t9\u0003EA\u0001\u0002\u0004\tY!A\u0002yIE\nq\u0001^7q\t&\u0014\b%A\u0004m_\u001e$\u0015N]\u0019\u0002\u00171|w\rR5sc}#S-\u001d\u000b\u0005\u0003?\t\t\u0004C\u0005\u0002(M\t\t\u00111\u0001\u0002\f\u0005AAn\\4ESJ\f\u0004%A\u0004m_\u001e$\u0015N\u001d\u001a\u0002\u00171|w\rR5se}#S-\u001d\u000b\u0005\u0003?\tY\u0004C\u0005\u0002(Y\t\t\u00111\u0001\u0002\f\u0005AAn\\4ESJ\u0014\u0004%A\u0004m_\u001e$\u0015N]\u001a\u0002\u00171|w\rR5sg}#S-\u001d\u000b\u0005\u0003?\t)\u0005C\u0005\u0002(e\t\t\u00111\u0001\u0002\f\u0005AAn\\4ESJ\u001c\u0004%\u0001\u0006m_\u001el\u0015M\\1hKJ,\"!!\u0014\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015S\u0003\rawnZ\u0005\u0005\u0003/\n\tF\u0001\u0006M_\u001el\u0015M\\1hKJ\fa\u0002\\8h\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0005u\u0003\"CA\u00149\u0005\u0005\t\u0019AA'\u0003-awnZ'b]\u0006<WM\u001d\u0011\u0002+\u0005dG/\u001a:QCJ$\u0018\u000e^5p]6\u000bg.Y4feV\u0011\u0011Q\r\t\u0005\u0003O\nYH\u0004\u0003\u0002j\u0005]d\u0002BA6\u0003krA!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004\u0003c\"\u0016A\u0002\u001fs_>$h(C\u0001T\u0013\ty(+C\u0002\u0002zy\f\u0011\u0002V3tiV#\u0018\u000e\\:\n\t\u0005u\u0014q\u0010\u0002\u001a\u001b>\u001c7.\u00117uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'OC\u0002\u0002zy\f\u0011$\u00197uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'o\u0018\u0013fcR!\u0011qDAC\u0011%\t9cHA\u0001\u0002\u0004\t)'\u0001\fbYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:!\u0003Y\tG\u000e^3s!\u0006\u0014H/\u001b;j_:d\u0015n\u001d;f]\u0016\u0014XCAAG!\u0011\t9'a$\n\t\u0005E\u0015q\u0010\u0002\u001b\u001b>\u001c7.\u00117uKJ\u0004\u0016M\u001d;ji&|g\u000eT5ti\u0016tWM]\u0001\u001bC2$XM\u001d)beRLG/[8o\u0019&\u001cH/\u001a8fe~#S-\u001d\u000b\u0005\u0003?\t9\nC\u0005\u0002(\t\n\t\u00111\u0001\u0002\u000e\u00069\u0012\r\u001c;feB\u000b'\u000f^5uS>tG*[:uK:,'\u000fI\u0001\nY><7i\u001c8gS\u001e,\"!a(\u0011\t\u0005\u0005\u0016QV\u0007\u0003\u0003GSA!a\u0015\u0002&*!\u0011qUAU\u0003%Ig\u000e^3s]\u0006d7OC\u0002\u0002,J\fqa\u001d;pe\u0006<W-\u0003\u0003\u00020\u0006\r&!\u0003'pO\u000e{gNZ5h\u00035awnZ\"p]\u001aLwm\u0018\u0013fcR!\u0011qDA[\u0011%\t9#JA\u0001\u0002\u0004\ty*\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002\n\u0001cY8oM&<'+\u001a9pg&$xN]=\u0016\u0005\u0005u\u0006\u0003BA`\u0003\u0013l!!!1\u000b\t\u0005\r\u0017QY\u0001\t[\u0016$\u0018\rZ1uC*\u0019\u0011q\u0019*\u0002\rM,'O^3s\u0013\u0011\tY-!1\u0003)5{7m[\"p]\u001aLwMU3q_NLGo\u001c:z\u0003Q\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018p\u0018\u0013fcR!\u0011qDAi\u0011%\t9\u0003KA\u0001\u0002\u0004\ti,A\td_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0002\n\u0011\u0003Z3mCf,Gm\u00149fe\u0006$\u0018n\u001c8t+\t\tI\u000eE\u0002W\u00037L1!!8Q\u0005E!U\r\\1zK\u0012|\u0005/\u001a:bi&|gn]\u0001\u0013I\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u001c\b%A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003K\u0004B!a:\u0002j6\u0011\u0011QY\u0005\u0005\u0003W\f)MA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003EygMZ:fi\u000eCWmY6q_&tGo]\u000b\u0003\u0003g\u0004B!!>\u0002|6\u0011\u0011q\u001f\u0006\u0005\u0003s\f)-A\u0006dQ\u0016\u001c7\u000e]8j]R\u001c\u0018\u0002BA\u007f\u0003o\u0014\u0011c\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;t\u0003IygMZ:fi\u000eCWmY6q_&tGo\u001d\u0011\u0002\u0013A\f'\u000f^5uS>tWC\u0001B\u0003!\r1&qA\u0005\u0004\u0005\u0013\u0001&!\u0003)beRLG/[8o\u00035\u0001\u0018M\u001d;ji&|gn\u0018\u0013fcR!\u0011q\u0004B\b\u0011%\t9#MA\u0001\u0002\u0004\u0011)!\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\nA\u0003^5fe\u0016$Gk\u001c9jGB\u000b'\u000f^5uS>t\u0017!\u0006;jKJ,G\rV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0017i&,'/\u001a3U_BL7-\u00133QCJ$\u0018\u000e^5p]V\u0011!1\u0004\t\u0005\u0005;\u0011\u0019#\u0004\u0002\u0003 )\u0019!\u0011\u0005*\u0002\tQLWM]\u0005\u0005\u0005K\u0011yB\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u00069B/[3sK\u0012$v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0016i&,'/\u00128bE2,G\rT8h\u001b\u0006t\u0017mZ3s\u0003e!\u0018.\u001a:F]\u0006\u0014G.\u001a3M_\u001el\u0015M\\1hKJ|F%Z9\u0015\t\u0005}!q\u0006\u0005\n\u0003OA\u0014\u0011!a\u0001\u0003\u001b\na\u0003^5fe\u0016s\u0017M\u00197fI2{w-T1oC\u001e,'\u000fI\u0001\u0013i&,'OU3qY&\u001c\u0017-T1oC\u001e,'/\u0006\u0002\u00038A!!Q\u0004B\u001d\u0013\u0011\u0011YDa\b\u0003%QKWM\u001d*fa2L7-Y'b]\u0006<WM]\u0001\u0014i&,'OU3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u0012i&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001cXC\u0001B\"!\u0011\tyE!\u0012\n\t\t\u001d\u0013\u0011\u000b\u0002\u0012)&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001c\u0018A\u0005;jKJdunZ\"p[B|g.\u001a8ug\u0002\nQb\u00197vgR,'\u000fT5oW&#WC\u0001B(!\u0011\u0011\tFa\u0016\u000e\u0005\tM#\u0002\u0002B+\u0003'\tA!\u001e;jY&!!\u0011\fB*\u0005\u0011)V+\u0013#\u0002\u001d\rdWo\u001d;fe2Kgn[%eA\u0005AQ\r_3dkR|'/\u0006\u0002\u0003bA!!1\rB5\u001b\t\u0011)G\u0003\u0003\u0003h\tM\u0013AC2p]\u000e,(O]3oi&!!1\u000eB3\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!C3yK\u000e,Ho\u001c:!\u0003=!\u0018.\u001a:fI2{wmQ8oM&<\u0017a\u0005;jKJ,G\rT8h\u0007>tg-[4`I\u0015\fH\u0003BA\u0010\u0005kB\u0011\"a\nD\u0003\u0003\u0005\r!a(\u0002!QLWM]3e\u0019><7i\u001c8gS\u001e\u0004\u0013!B:fiV\u0004HCAA\u0010Q\r)%q\u0010\t\u0005\u0005\u0003\u0013y)\u0004\u0002\u0003\u0004*!!Q\u0011BD\u0003\r\t\u0007/\u001b\u0006\u0005\u0005\u0013\u0013Y)A\u0004kkBLG/\u001a:\u000b\u0007\t5U/A\u0003kk:LG/\u0003\u0003\u0003\u0012\n\r%A\u0003\"fM>\u0014X-R1dQ\u0006\u0019R.Y6f)&,'/\u001a3QCJ$\u0018\u000e^5p]RA!Q\u0001BL\u0005O\u00139\fC\u0005\u0003\u001a\u001a\u0003\n\u00111\u0001\u0003\u001c\u0006Q\u0012N\u001c;fe\n\u0013xn[3s!J|Go\\2pYZ+'o]5p]B!!Q\u0014BR\u001b\t\u0011yJC\u0002r\u0005CS1!a2s\u0013\u0011\u0011)Ka(\u0003\u001f5+G/\u00193bi\u00064VM]:j_:D\u0011B!+G!\u0003\u0005\rAa+\u0002\u0011i\\7\t\\5f]R\u0004BA!,\u000346\u0011!q\u0016\u0006\u0004\u0005c\u0013\u0016A\u0001>l\u0013\u0011\u0011)La,\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011%\u0011IL\u0012I\u0001\u0002\u0004\u0011Y,A\u0005tG\",G-\u001e7feB!!Q\u0018Ba\u001b\t\u0011yL\u0003\u0003\u0003V\t\u0005\u0016\u0002\u0002Bb\u0005\u007f\u0013abS1gW\u0006\u001c6\r[3ek2,'/A\u000fnC.,G+[3sK\u0012\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011IM\u000b\u0003\u0003\u001c\n-7F\u0001Bg!\u0011\u0011yM!7\u000e\u0005\tE'\u0002\u0002Bj\u0005+\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t]7,\u0001\u0006b]:|G/\u0019;j_:LAAa7\u0003R\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002;5\f7.\u001a+jKJ,G\rU1si&$\u0018n\u001c8%I\u00164\u0017-\u001e7uII*\"A!9+\t\t-&1Z\u0001\u001e[\u0006\\W\rV5fe\u0016$\u0007+\u0019:uSRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u001d\u0016\u0005\u0005w\u0013Y-\u0006\u0002\u0003\u001c\u0006\u00192M]3bi\u0016dun\u001a)s_B,'\u000f^5fgR!!q\u001eB{!\u0011\u0011\tF!=\n\t\tM(1\u000b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002B|\u0017\u0002\u0007!\u0011`\u0001\n_Z,'O]5eKN\u0004\u0002Ba?\u0004\u0004\r%1\u0011\u0002\b\u0005\u0005{\u0014y\u0010E\u0002\u0002nmK1a!\u0001\\\u0003\u0019\u0001&/\u001a3fM&!1QAB\u0004\u0005\ri\u0015\r\u001d\u0006\u0004\u0007\u0003Y\u0006\u0003\u0002B~\u0007\u0017IAa!\u0004\u0004\b\t11\u000b\u001e:j]\u001e\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004\u0019\u000eM\u0001\u0003\u0002BA\u0007+IAaa\u0006\u0003\u0004\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0018g\u0016$X\u000f\u001d)beRLG/[8o/&$\b.T8dWN$bA!\u0002\u0004\u001e\r\u0005\u0002BBB\u0010\u001b\u0002\u00071-A\u0006mK\u0006$WM]#q_\u000eD\u0007bBB\u0012\u001b\u0002\u00071QE\u0001\tSNdU-\u00193feB\u0019!la\n\n\u0007\r%2LA\u0004C_>dW-\u00198\u0002%\u0011,g-Y;mi\n\u0013xn[3s\u000bB|7\r\u001b\u000b\u0005\u0007_\u0019)\u0004E\u0002[\u0007cI1aa\r\\\u0005\u0011auN\\4\t\u000b\u0005t\u0005\u0019A2")
public class AbstractPartitionTest {
    private final int brokerId = AbstractPartitionTest$.MODULE$.brokerId();
    private final int remoteReplicaId = this.brokerId() + 1;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private File logDir3;
    private LogManager logManager;
    private TestUtils.MockAlterPartitionManager alterPartitionManager;
    private TestUtils.MockAlterPartitionListener alterPartitionListener;
    private LogConfig logConfig;
    private MockConfigRepository configRepository;
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;
    private final TopicPartition tieredTopicPartition = new TopicPartition("tiered-test-topic", 0);
    private final TopicIdPartition tieredTopicIdPartition = new TopicIdPartition("tiered-test-topic", UUID.randomUUID(), 0);
    private LogManager tierEnabledLogManager;
    private final TierReplicaManager tierReplicaManager = (TierReplicaManager)Mockito.mock(TierReplicaManager.class);
    private final TierLogComponents tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
    private final UUID clusterLinkId = UUID.randomUUID();
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private LogConfig tieredLogConfig;

    public int brokerId() {
        return this.brokerId;
    }

    public int remoteReplicaId() {
        return this.remoteReplicaId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public File logDir3() {
        return this.logDir3;
    }

    public void logDir3_$eq(File x$1) {
        this.logDir3 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public TestUtils.MockAlterPartitionManager alterPartitionManager() {
        return this.alterPartitionManager;
    }

    public void alterPartitionManager_$eq(TestUtils.MockAlterPartitionManager x$1) {
        this.alterPartitionManager = x$1;
    }

    public TestUtils.MockAlterPartitionListener alterPartitionListener() {
        return this.alterPartitionListener;
    }

    public void alterPartitionListener_$eq(TestUtils.MockAlterPartitionListener x$1) {
        this.alterPartitionListener = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public MockConfigRepository configRepository() {
        return this.configRepository;
    }

    public void configRepository_$eq(MockConfigRepository x$1) {
        this.configRepository = x$1;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition tieredTopicPartition() {
        return this.tieredTopicPartition;
    }

    public TopicIdPartition tieredTopicIdPartition() {
        return this.tieredTopicIdPartition;
    }

    public LogManager tierEnabledLogManager() {
        return this.tierEnabledLogManager;
    }

    public void tierEnabledLogManager_$eq(LogManager x$1) {
        this.tierEnabledLogManager = x$1;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public UUID clusterLinkId() {
        return this.clusterLinkId;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public LogConfig tieredLogConfig() {
        return this.tieredLogConfig;
    }

    public void tieredLogConfig_$eq(LogConfig x$1) {
        this.tieredLogConfig = x$1;
    }

    @BeforeEach
    public void setup() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps));
        this.configRepository_$eq(MockConfigRepository$.MODULE$.forTopic(this.topicPartition().topic(), logProps));
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        .colon.colon x$1 = new .colon.colon((Object)this.logDir1(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$));
        LogConfig x$2 = this.logConfig();
        MockConfigRepository x$3 = this.configRepository();
        CleanerConfig x$4 = new CleanerConfig(false);
        MockTime x$5 = this.time();
        MetadataVersion x$6 = this.interBrokerProtocolVersion();
        Metrics x$7 = new Metrics();
        SegmentDeletionThrottlerConfig x$8 = new SegmentDeletionThrottlerConfig(){

            public Seq<FileStore> fileStores(Seq<File> logDirs) {
                return (Seq)logDirs.map((Function1 & Serializable)x$32 -> new TestUtils.DeterministicFileStore(TestUtils$.MODULE$.DefaultTotalAvailableBytes(), TestUtils$.MODULE$.DefaultInitialUsableBytes()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fileStores$1(java.io.File )}, serializedLambda);
            }
        };
        TierLogComponents x$9 = TierLogComponents$.MODULE$.EMPTY();
        int x$10 = 4;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)x$1, x$2, x$3, x$4, x$5, x$7, x$8, x$6, x$9, x$10));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.alterPartitionManager_$eq(new TestUtils.MockAlterPartitionManager());
        this.alterPartitionListener_$eq(new TestUtils.MockAlterPartitionListener());
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.interBrokerProtocolVersion(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.defaultBrokerEpoch(this.brokerId()), (Time)this.time(), (AlterPartitionListener)this.alterPartitionListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (Option)new Some((Object)this.tierReplicaManager()), (Option)None$.MODULE$, (Option)None$.MODULE$, (AlterPartitionManager)this.alterPartitionManager(), (Option)None$.MODULE$, false, (Option)None$.MODULE$));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
        Properties tieredLogProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.tier.enable"), (Object)"true")}))));
        this.tieredLogConfig_$eq(new LogConfig((Map)tieredLogProps));
        this.logDir3_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        .colon.colon x$11 = new .colon.colon((Object)this.logDir3(), (List)Nil$.MODULE$);
        LogConfig x$12 = this.tieredLogConfig();
        MockConfigRepository x$13 = this.configRepository();
        CleanerConfig x$14 = new CleanerConfig(false);
        MockTime x$15 = this.time();
        TierLogComponents x$16 = new TierLogComponents((Option)None$.MODULE$, (Option)None$.MODULE$, new TierPartitionStateFactory(true, false, true, TierPartitionStateCleanupConfig.EMPTY, false, -1), (Option)None$.MODULE$);
        Metrics x$17 = new Metrics();
        SegmentDeletionThrottlerConfig x$18 = new /* invalid duplicate definition of identical inner class */;
        MetadataVersion x$19 = MetadataVersion.latest();
        int x$20 = 4;
        this.tierEnabledLogManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)x$11, x$12, x$13, x$14, x$15, x$17, x$18, x$19, x$16, x$20));
        this.tierEnabledLogManager().startup((Set)Predef$.MODULE$.Set().empty());
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.tieredTopicPartition()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.metadataCache().getBrokerTags(ArgumentMatchers.anyInt())).thenReturn((Object)Predef$.MODULE$.Map().empty());
    }

    public Partition makeTieredPartition(MetadataVersion interBrokerProtocolVersion, KafkaZkClient zkClient, KafkaScheduler scheduler) {
        TestUtils.MockAlterPartitionManager partitionManager;
        if (interBrokerProtocolVersion.isAtLeast(MetadataVersion.IBP_2_7_IV0)) {
            partitionManager = this.alterPartitionManager();
        } else {
            Predef$.MODULE$.assert(zkClient != null && scheduler != null);
            MockTime apply_time = this.time();
            Object var5_5 = null;
            partitionManager = new ZkAlterPartitionManager((Scheduler)scheduler, (Time)apply_time, zkClient);
        }
        return new Partition(this.tieredTopicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), interBrokerProtocolVersion, this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.defaultBrokerEpoch(this.brokerId()), (Time)this.time(), (AlterPartitionListener)this.alterPartitionListener(), this.delayedOperations(), this.metadataCache(), this.tierEnabledLogManager(), (Option)new Some((Object)this.tierReplicaManager()), (Option)None$.MODULE$, (Option)new Some((Object)this.executor()), (AlterPartitionManager)partitionManager, (Option)None$.MODULE$, false, (Option)None$.MODULE$);
    }

    public MetadataVersion makeTieredPartition$default$1() {
        return MetadataVersion.latest();
    }

    public KafkaZkClient makeTieredPartition$default$2() {
        return null;
    }

    public KafkaScheduler makeTieredPartition$default$3() {
        return null;
    }

    public MetadataVersion interBrokerProtocolVersion() {
        return MetadataVersion.latest();
    }

    public Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(512));
        logProps.put("segment.index.bytes", Predef$.MODULE$.int2Integer(1000));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return logProps.put(k, v);
            }
            throw new MatchError(null);
        });
        return logProps;
    }

    @AfterEach
    public void tearDown() {
        if (this.tmpDir().exists()) {
            this.logManager().shutdown();
            Utils.delete((File)this.tmpDir(), (boolean)false);
            TestUtils$.MODULE$.clearYammerMetrics();
            return;
        }
    }

    public Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader) {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        int controllerEpoch = 0;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        } else {
            Assertions.assertTrue((boolean)this.partition().makeFollower(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.remoteReplicaId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become follower transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
            Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }

    public long defaultBrokerEpoch(int brokerId) {
        return (long)brokerId + 1000L;
    }
}

