/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.protobuf.events.catalog.v1.ClusterLinkMetadata;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kafka.catalog.InMemoryLocalStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InMemoryLocalStoreTest {
    private InMemoryLocalStore store;
    String tenant1 = "lkc-abcde";
    String tenant2 = "lkc-efghi";
    String tenant3 = "lkc-jklmn";
    String topic1 = this.tenant1 + "_my-topic";
    String topic2 = this.tenant1 + "_my-topic2";
    String topic3 = this.tenant2 + "_other-topic";
    String link1 = this.tenant1 + "_my-link";
    String link2 = this.tenant2 + "_my-link2";
    String link3 = this.tenant3 + "_other-link";
    MetadataEvent topicEvent1 = MetadataEvent.newBuilder().setTopicMetadata(TopicMetadata.newBuilder().setTopicName(this.topic1)).build();
    MetadataEvent topicEvent2 = MetadataEvent.newBuilder().setTopicMetadata(TopicMetadata.newBuilder().setTopicName(this.topic2)).build();
    MetadataEvent topicEvent3 = MetadataEvent.newBuilder().setTopicMetadata(TopicMetadata.newBuilder().setTopicName(this.topic3)).build();
    MetadataEvent linkEvent1 = MetadataEvent.newBuilder().setClusterLinkMetadata(ClusterLinkMetadata.newBuilder().setClusterLinkName(this.link1)).build();
    MetadataEvent linkEvent2 = MetadataEvent.newBuilder().setClusterLinkMetadata(ClusterLinkMetadata.newBuilder().setClusterLinkName(this.link2)).build();
    MetadataEvent linkEvent3 = MetadataEvent.newBuilder().setClusterLinkMetadata(ClusterLinkMetadata.newBuilder().setClusterLinkName(this.link3)).build();

    @BeforeEach
    void setup() {
        this.store = new InMemoryLocalStore();
    }

    @Test
    void TestStoreAdd() {
        this.store.addTopicMetadataEvent(this.tenant1, this.topic1, this.topicEvent1);
        this.store.addTopicMetadataEvent(this.tenant2, this.topic3, this.topicEvent3);
        this.store.addClusterLinkMetadataEvent(this.tenant1, this.link1, this.linkEvent1);
        this.store.addClusterLinkMetadataEvent(this.tenant3, this.link3, this.linkEvent3);
        Assertions.assertTrue((boolean)this.store.logicalClusters().contains(this.tenant1));
        Assertions.assertTrue((boolean)this.store.topics(this.tenant1).contains(this.topic1));
        Assertions.assertTrue((boolean)this.store.clusterLinks(this.tenant1).contains(this.link1));
        Assertions.assertEquals((Object)this.topicEvent1, (Object)this.store.topicMetadataEvent(this.topic1));
        Assertions.assertEquals((Object)this.linkEvent1, (Object)this.store.clusterLinkMetadataEvent(this.link1));
        Assertions.assertEquals((int)3, (int)this.store.logicalClusters().size());
        Assertions.assertTrue((boolean)this.store.logicalClusters().contains(this.tenant2));
        Assertions.assertTrue((boolean)this.store.logicalClusters().contains(this.tenant3));
        Assertions.assertTrue((boolean)this.store.topics(this.tenant2).contains(this.topic3));
        Assertions.assertTrue((boolean)this.store.clusterLinks(this.tenant3).contains(this.link3));
        Assertions.assertEquals((Object)this.topicEvent3, (Object)this.store.topicMetadataEvent(this.topic3));
        Assertions.assertEquals((Object)this.linkEvent3, (Object)this.store.clusterLinkMetadataEvent(this.link3));
    }

    @Test
    void TestStoreDelete() {
        this.store.addTopicMetadataEvent(this.tenant1, this.topic1, this.topicEvent1);
        this.store.addTopicMetadataEvent(this.tenant1, this.topic2, this.topicEvent2);
        this.store.addClusterLinkMetadataEvent(this.tenant2, this.link2, this.linkEvent2);
        this.store.addClusterLinkMetadataEvent(this.tenant3, this.link3, this.linkEvent3);
        this.store.removeTopicMetadataEvent(this.tenant1, this.topic1);
        this.store.removeClusterLinkMetadataEvent(this.tenant2, this.link2);
        Assertions.assertEquals((int)2, (int)this.store.logicalClusters().size());
        Assertions.assertEquals((int)1, (int)this.store.topics(this.tenant1).size());
        Assertions.assertEquals((int)1, (int)this.store.clusterLinks(this.tenant3).size());
        Assertions.assertNull((Object)this.store.topicMetadataEvent(this.topic1));
        Assertions.assertNull((Object)this.store.clusterLinkMetadataEvent(this.link2));
        this.store.removeTopicMetadataEvent(this.tenant1, this.topic2);
        this.store.removeClusterLinkMetadataEvent(this.tenant3, this.link3);
        Assertions.assertNull((Object)this.store.topicMetadataEvent(this.topic2));
        Assertions.assertNull((Object)this.store.clusterLinkMetadataEvent(this.link3));
        Assertions.assertTrue((boolean)this.store.logicalClusters().isEmpty());
        Assertions.assertEquals((int)0, (int)this.store.logicalClusters().size());
        Assertions.assertEquals((int)0, (int)this.store.topics(this.tenant1).size());
        Assertions.assertEquals((int)0, (int)this.store.clusterLinks(this.tenant3).size());
    }

    @Test
    void TestStoreAddWithConfigOverride() {
        HashSet<String> configs = new HashSet<String>(Arrays.asList("a", "b", "c"));
        this.store.addTopicMetadataEvent(this.tenant1, this.topic1, this.topicEvent1, configs, Collections.emptySet());
        Set override = this.store.topicConfigOverrides(this.topic1);
        for (String string : configs) {
            Assertions.assertTrue((boolean)override.contains(string));
        }
        HashSet<String> moreConfigs = new HashSet<String>(Arrays.asList("c", "d", "e"));
        this.store.addTopicMetadataEvent(this.tenant1, this.topic1, this.topicEvent1, moreConfigs, Collections.emptySet());
        configs.addAll(moreConfigs);
        for (String config : configs) {
            Assertions.assertTrue((boolean)override.contains(config));
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList("a", "b"));
        HashSet<String> remaining = new HashSet<String>(Arrays.asList("c", "d", "e"));
        this.store.addTopicMetadataEvent(this.tenant1, this.topic1, this.topicEvent1, Collections.emptySet(), hashSet);
        for (String config : remaining) {
            Assertions.assertTrue((boolean)override.contains(config));
        }
        this.store.removeTopicMetadataEvent(this.tenant1, this.topic1);
        Assertions.assertTrue((boolean)this.store.topicConfigOverrides(this.topic1).isEmpty());
    }

    @Test
    void TestStoreClear() {
        this.store.addTopicMetadataEvent(this.tenant1, this.topic1, this.topicEvent1);
        this.store.addTopicMetadataEvent(this.tenant2, this.topic3, this.topicEvent3);
        this.store.addClusterLinkMetadataEvent(this.tenant1, this.link1, this.linkEvent1);
        this.store.addClusterLinkMetadataEvent(this.tenant3, this.link3, this.linkEvent3);
        this.store.clear();
        Assertions.assertEquals((int)0, (int)this.store.logicalClusters().size());
        Assertions.assertEquals((int)0, (int)this.store.topics(this.tenant1).size());
        Assertions.assertEquals((int)0, (int)this.store.topics(this.tenant2).size());
        Assertions.assertEquals((int)0, (int)this.store.clusterLinks(this.tenant1).size());
        Assertions.assertEquals((int)0, (int)this.store.clusterLinks(this.tenant3).size());
    }

    @Test
    void TestStoreInvalidInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.addTopicMetadataEvent("lkc-abc", "topic", MetadataEvent.newBuilder().build()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.addTopicMetadataEvent("lkc-abc", "lkc-cdf_topic", MetadataEvent.newBuilder().build()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.addTopicMetadataEvent("lkc-abc", "lkc-abc-topic", MetadataEvent.newBuilder().build()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.addClusterLinkMetadataEvent("lkc-abc", "link", MetadataEvent.newBuilder().build()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.addClusterLinkMetadataEvent("lkc-abc", "lkc-cdf_link", MetadataEvent.newBuilder().build()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.addClusterLinkMetadataEvent("lkc-abc", "lkc-abc-link", MetadataEvent.newBuilder().build()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.removeTopicMetadataEvent("lkc-abc", "topic"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.removeTopicMetadataEvent("lkc-abc", "lkc-cdf_topic"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.removeTopicMetadataEvent("lkc-abc", "lkc-abc-topic"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.removeClusterLinkMetadataEvent("lkc-abc", "link"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.removeClusterLinkMetadataEvent("lkc-abc", "lkc-cdf_link"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.store.removeClusterLinkMetadataEvent("lkc-abc", "lkc-abc-link"));
        Assertions.assertEquals((int)0, (int)this.store.topics("doesn't exist").size());
        Assertions.assertEquals((int)0, (int)this.store.clusterLinks("doesn't exist").size());
        Assertions.assertNull((Object)this.store.topicMetadataEvent("topic doesn't exist"));
        Assertions.assertNull((Object)this.store.clusterLinkMetadataEvent("topic doesn't exist"));
    }
}

