/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import kafka.catalog.CatalogMetrics;
import kafka.catalog.InMemoryLocalStore;
import kafka.catalog.LocalStore;
import org.apache.kafka.common.metrics.Metrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CatalogMetricsTest {
    Metrics metrics;
    CatalogMetrics catalogMetrics;
    LocalStore localStore;

    @BeforeEach
    void setup() {
        this.metrics = new Metrics();
        this.localStore = new InMemoryLocalStore();
        this.catalogMetrics = new CatalogMetrics(this.metrics, () -> ((LocalStore)this.localStore).size());
    }

    @Test
    void testCatalogMetricsShouldRegisterAndRemove() {
        Assertions.assertNotNull((Object)this.metrics.getSensor("num-delta-event-emit"));
        Assertions.assertNotNull((Object)this.metrics.getSensor("num-snapshot-event-emit"));
        Assertions.assertNotNull((Object)this.metrics.getSensor("num-collector-event-handle-error"));
        Assertions.assertNotNull((Object)this.metrics.metric(this.metrics.metricName("cached-topics-total", "catalog-metrics")));
        Assertions.assertNotNull((Object)this.metrics.metric(this.metrics.metricName("cached-entities-total", "catalog-metrics")));
        Assertions.assertNotNull((Object)this.metrics.metric(this.metrics.metricName("snapshot-emitting-delay-ms", "catalog-metrics")));
        this.catalogMetrics.removeCatalogMetrics();
        Assertions.assertNull((Object)this.metrics.getSensor("num-delta-event-emit"));
        Assertions.assertNull((Object)this.metrics.getSensor("num-snapshot-event-emit"));
        Assertions.assertNull((Object)this.metrics.getSensor("num-collector-event-handle-error"));
        Assertions.assertNull((Object)this.metrics.metric(this.metrics.metricName("cached-topics-total", "catalog-metrics")));
        Assertions.assertNull((Object)this.metrics.metric(this.metrics.metricName("cached-entities-total", "catalog-metrics")));
        Assertions.assertNull((Object)this.metrics.metric(this.metrics.metricName("snapshot-emitting-delay-ms", "catalog-metrics")));
    }

    @Test
    void testLocalStoreSizeMetric() {
        this.localStore.addTopicMetadataEvent("lkc-abc", "lkc-abc_topic1", MetadataEvent.newBuilder().build());
        this.localStore.addTopicMetadataEvent("lkc-abc", "lkc-abc_topic2", MetadataEvent.newBuilder().build());
        this.localStore.addClusterLinkMetadataEvent("lkc-abc", "lkc-abc_link1", MetadataEvent.newBuilder().build());
        this.localStore.addClusterLinkMetadataEvent("lkc-abc", "lkc-abc_link2", MetadataEvent.newBuilder().build());
        Assertions.assertEquals((double)4.0, (double)((Double)this.metrics.metric(this.catalogMetrics.cachedTopicsMetricName).metricValue()));
        Assertions.assertEquals((double)4.0, (double)((Double)this.metrics.metric(this.catalogMetrics.cachedEntitiesMetricName).metricValue()));
        this.localStore.removeTopicMetadataEvent("lkc-abc", "lkc-abc_topic1");
        this.localStore.removeClusterLinkMetadataEvent("lkc-abc", "lkc-abc_link1");
        Assertions.assertEquals((double)2.0, (double)((Double)this.metrics.metric(this.catalogMetrics.cachedTopicsMetricName).metricValue()));
        Assertions.assertEquals((double)2.0, (double)((Double)this.metrics.metric(this.catalogMetrics.cachedEntitiesMetricName).metricValue()));
    }

    @Test
    void testMetricInitialized() {
        Assertions.assertEquals((Object)0L, (Object)this.metrics.metric(this.catalogMetrics.snapshotDelayMsMetricName).metricValue());
    }
}

