/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import kafka.api.Both$;
import kafka.api.EndToEndAuthorizationTest;
import kafka.metrics.BrokerLoad;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Console$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb!\u0002\u0007\u000e\u0003\u0003\u0011\u0002\"B\f\u0001\t\u0003A\u0002\"\u0002\u000e\u0001\t#Z\u0002bB\u0016\u0001\u0005\u0004%\t\u0006\f\u0005\u0007w\u0001\u0001\u000b\u0011B\u0017\t\u000fq\u0002!\u0019!C)Y!1Q\b\u0001Q\u0001\n5BQA\u0010\u0001\u0007\u0012}BQa\u0013\u0001\u0007\u00121CQ!\u0016\u0001\u0005BYCQ!\u001b\u0001\u0005\u0002)Dq!!\u0006\u0001\t\u0003\t9BA\u000fTCNdWI\u001c3U_\u0016sG-Q;uQ>\u0014\u0018N_1uS>tG+Z:u\u0015\tqq\"A\u0002ba&T\u0011\u0001E\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015+5\tQ\"\u0003\u0002\u0017\u001b\tIRI\u001c3U_\u0016sG-Q;uQ>\u0014\u0018N_1uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u0015\u0001\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u00029A\u0011Q$K\u0007\u0002=)\u0011q\u0004I\u0001\u0005CV$\bN\u0003\u0002\"E\u0005A1/Z2ve&$\u0018P\u0003\u0002$I\u000511m\\7n_:T!\u0001E\u0013\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0005\u0003Uy\u0011\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\u0002)M,'O^3s'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t+\u0005i\u0003c\u0001\u00182g5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0003T_6,\u0007C\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u0011)H/\u001b7\u000b\u0003a\nAA[1wC&\u0011!(\u000e\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!F:feZ,'oU1tYB\u0013x\u000e]3si&,7\u000fI\u0001\u0015G2LWM\u001c;TCNd\u0007K]8qKJ$\u0018.Z:\u0002+\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3tA\u0005A2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7\u0016\u0003\u0001\u0003\"!\u0011%\u000f\u0005\t3\u0005CA\"0\u001b\u0005!%BA#\u0012\u0003\u0019a$o\\8u}%\u0011qiL\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002H_\u0005I2.\u00194lCN+'O^3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7t+\u0005i\u0005c\u0001(T\u00016\tqJ\u0003\u0002Q#\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003%>\n!bY8mY\u0016\u001cG/[8o\u0013\t!vJ\u0001\u0003MSN$\u0018!B:fiV\u0003HCA,[!\tq\u0003,\u0003\u0002Z_\t!QK\\5u\u0011\u0015Y\u0016\u00021\u0001]\u0003!!Xm\u001d;J]\u001a|\u0007CA/d\u001b\u0005q&B\u0001\b`\u0015\t\u0001\u0017-A\u0004kkBLG/\u001a:\u000b\u0005\t<\u0013!\u00026v]&$\u0018B\u00013_\u0005!!Vm\u001d;J]\u001a|\u0007FA\u0005g!\tiv-\u0003\u0002i=\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002YQ,7\u000f\u001e+x_\u000e{gn];nKJ\u001cx+\u001b;i\t&4g-\u001a:f]R\u001c\u0016m\u001d7De\u0016$WM\u001c;jC2\u001cHCA,l\u0011\u0015a'\u00021\u0001A\u0003\u0019\tXo\u001c:v[\"\"!B\u001c<x!\tyG/D\u0001q\u0015\t\t(/\u0001\u0005qe>4\u0018\u000eZ3s\u0015\t\u0019x,\u0001\u0004qCJ\fWn]\u0005\u0003kB\u00141BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHF\u0001={C\u0005I\u0018!B6sC\u001a$\u0018%A>\u0002\u0005i\\\u0007F\u0002\u0006~\u0003\u0007\t)\u0001\u0005\u0002\u007f\u007f6\t!/C\u0002\u0002\u0002I\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\u0005\u001d\u0011\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\":!\"a\u0003\u0002\u0012\u0005M\u0001cA/\u0002\u000e%\u0019\u0011q\u00020\u0003\u000fQKW.Z8vi\u0006)a/\u00197vKz\tq\"\u0001\u0017uKN$(I]8lKJdu.\u00193XSRD7i\u001c8oK\u000e$\u0018n\u001c8SK\u0006,H\u000f[3oi&\u001c\u0017\r^5p]R\u0019q+!\u0007\t\u000b1\\\u0001\u0019\u0001!)\u000b-qg/!\b-\u0005aT\bFB\u0006~\u0003\u0007\t)\u0001K\u0004\f\u0003\u0017\t\t\"a\t\u001f\u0003aDsaCA\u0014\u0003#\ti\u0003E\u0002^\u0003SI1!a\u000b_\u0005!!\u0015n]1cY\u0016$\u0017EAA\u0018\u0003)Y5IR+O[E\u0002$G\r")
public abstract class SaslEndToEndAuthorizationTest
extends EndToEndAuthorizationTest {
    private final Some<Properties> serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
    private final Some<Properties> clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_SSL;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    public abstract String kafkaClientSaslMechanism();

    public abstract List<String> kafkaServerSaslMechanisms();

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafkaClientSaslMechanism()), Both$.MODULE$, this.jaasSections$default$4()));
        String clientLoginContext = this.jaasClientLoginModule(this.kafkaClientSaslMechanism(), this.jaasClientLoginModule$default$2());
        this.producerConfig().put("sasl.jaas.config", clientLoginContext);
        this.consumerConfig().put("sasl.jaas.config", clientLoginContext);
        this.adminClientConfig().put("sasl.jaas.config", clientLoginContext);
        this.serverConfig().setProperty("confluent.broker.load.window.size.ms", "1000");
        this.serverConfig().setProperty("confluent.broker.load.num.samples", "1000");
        String superuserLoginContext = this.jaasAdminLoginModule(this.kafkaClientSaslMechanism(), this.jaasAdminLoginModule$default$2());
        this.superuserClientConfig().put("sasl.jaas.config", superuserLoginContext);
        super.setUp(testInfo);
    }

    @Timeout(value=15L)
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testTwoConsumersWithDifferentSaslCredentials(String quorum) {
        String string = quorum;
        String string2 = this.unimplementedquorum();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Console$.MODULE$.err().println(new StringBuilder(31).append("QuorumName : ").append(quorum).append(" is not supported.").toString());
            return;
        }
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer1 = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.consumerConfig().remove("sasl.jaas.config");
        this.consumerConfig().remove("sasl.client.callback.handler.class");
        KafkaConsumer consumer2 = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer1.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer2.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer1, this.numRecords(), 0, this.topic(), this.part(), 10000L);
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer2, 1, 0, this.topic(), this.part(), 10000L);
            Assertions.fail((String)"Expected exception as consumer2 has no access to topic or group");
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            Assertions.assertTrue((boolean)topicAuthorizationException.unauthorizedTopics().contains(this.topic()));
        }
        catch (GroupAuthorizationException e) {
            Assertions.assertEquals((Object)this.group(), (Object)e.groupId());
        }
        this.confirmReauthenticationMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Disabled(value="KCFUN-1022")
    @Timeout(value=120L)
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testBrokerLoadWithConnectionReauthentication(String quorum) {
        String string = quorum;
        String string2 = this.unimplementedquorum();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Console$.MODULE$.err().println(new StringBuilder(31).append("QuorumName : ").append(quorum).append(" is not supported.").toString());
            return;
        }
        this.setReadAndWriteAcls(this.tp());
        int NumProducers = 3 * this.brokers().size();
        ListBuffer list = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), NumProducers).foreach((Function1 & Serializable)x$1 -> SaslEndToEndAuthorizationTest.$anonfun$testBrokerLoadWithConnectionReauthentication$1(this, list, BoxesRunTime.unboxToInt((Object)x$1)));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        long maxTimeToWait = Duration.ofSeconds(30L).toMillis();
        long reauthTime = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(this.serverConfig().getProperty(KafkaConfig$.MODULE$.ConnectionsMaxReauthMsProp())));
        Map prevServiceTimes = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.brokers().foreach((Function1 & Serializable)s -> prevServiceTimes.put((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()), (Object)BoxesRunTime.boxToDouble((double)0.0)));
        ((KafkaBroker)this.brokers().head()).time().sleep(reauthTime);
        for (long timeWaited = 0L; timeWaited <= maxTimeToWait; timeWaited += reauthTime) {
            void var4_4;
            var4_4.foreach((Function1 & Serializable)producer -> {
                this.sendRecords((KafkaProducer<byte[], byte[]>)producer, this.numRecords(), this.tp());
                return BoxedUnit.UNIT;
            });
            TestUtils$.MODULE$.consumeRecords(consumer, this.numRecords() * var4_4.size(), 15000L);
            ((KafkaBroker)this.brokers().head()).time().sleep(reauthTime);
            this.confirmReauthenticationMetrics();
            this.brokers().foreach((Function1 & Serializable)s -> {
                Assertions.assertTrue((boolean)s.socketServer().brokerLoad().isDefined());
                Assertions.assertTrue((boolean)((BrokerLoad)s.socketServer().brokerLoad().get()).weightedAverageTotalServiceLocalTimeMetric().isDefined());
                double totalServiceLocalTime = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)s.socketServer().brokerLoad().get()).weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
                Assertions.assertTrue((totalServiceLocalTime > 0.0 ? 1 : 0) != 0);
                double prevServiceTime = BoxesRunTime.unboxToDouble((Object)prevServiceTimes.apply((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId())));
                Assertions.assertTrue((prevServiceTime == 0.0 || totalServiceLocalTime < (double)5 * prevServiceTime ? 1 : 0) != 0);
                return prevServiceTimes.put((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()), (Object)BoxesRunTime.boxToDouble((double)totalServiceLocalTime));
            });
        }
    }

    public static final /* synthetic */ ListBuffer $anonfun$testBrokerLoadWithConnectionReauthentication$1(SaslEndToEndAuthorizationTest $this, ListBuffer list$1, int x$1) {
        return (ListBuffer)list$1.$plus$eq($this.createProducer($this.createProducer$default$1(), $this.createProducer$default$2(), $this.createProducer$default$3()));
    }
}

