/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.Defaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001\u0002\f\u0018\u0001qAQ!\t\u0001\u0005\u0002\tBQ\u0001\n\u0001\u0005\u0002\u0015BQa\u000f\u0001\u0005\u0002qBQ!\u0014\u0001\u0005\u0002qBQa\u0014\u0001\u0005\u0002qBQ!\u0015\u0001\u0005\u0002qBQa\u0015\u0001\u0005\u0002qBQ!\u0016\u0001\u0005\u0002qBQa\u0016\u0001\u0005\u0002qBQ!\u0017\u0001\u0005\u0002qBQa\u0017\u0001\u0005\u0002qBQ!\u0018\u0001\u0005\nyCQ!\u001e\u0001\u0005\nYDQa\u001f\u0001\u0005\nqDa!a\u0005\u0001\t\u0013a\u0004bBA\u000b\u0001\u0011%\u0011q\u0003\u0005\b\u0003;\u0001A\u0011BA\u0010\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003KA\u0011\"a\u0015\u0001#\u0003%I!!\u0016\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n!I\u0011Q\u0010\u0001\u0012\u0002\u0013%\u0011Q\u000b\u00021\t\u0016dW\r^3PM\u001a\u001cX\r^:D_:\u001cX/\\3s\u000fJ|W\u000f]\"p[6\fg\u000eZ%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005aI\u0012!B1e[&t'\"\u0001\u000e\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\b\t\u0003=}i\u0011aF\u0005\u0003A]\u0011\u0001dQ8ogVlWM]$s_V\u00048i\\7nC:$G+Z:u\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002\u001f\u0001\u00059q-\u001a;Be\u001e\u001cHc\u0001\u00148sA\u0019qE\u000b\u0017\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012Q!\u0011:sCf\u0004\"!\f\u001b\u000f\u00059\u0012\u0004CA\u0018)\u001b\u0005\u0001$BA\u0019\u001c\u0003\u0019a$o\\8u}%\u00111\u0007K\u0001\u0007!J,G-\u001a4\n\u0005U2$AB*ue&twM\u0003\u00024Q!)\u0001H\u0001a\u0001Y\u0005)qM]8va\")!H\u0001a\u0001Y\u0005)Ao\u001c9jG\u0006\tC/Z:u\t\u0016dW\r^3PM\u001a\u001cX\r^:O_:,\u00050[:uS:<wI]8vaR\tQ\b\u0005\u0002(}%\u0011q\b\u000b\u0002\u0005+:LG\u000f\u000b\u0002\u0004\u0003B\u0011!iS\u0007\u0002\u0007*\u0011A)R\u0001\u0004CBL'B\u0001$H\u0003\u001dQW\u000f]5uKJT!\u0001S%\u0002\u000b),h.\u001b;\u000b\u0003)\u000b1a\u001c:h\u0013\ta5I\u0001\u0003UKN$\u0018\u0001\u000f;fgR$U\r\\3uK>3gm]3ug>37\u000b^1cY\u0016\u001cuN\\:v[\u0016\u0014xI]8va^KG\u000f\u001b+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0015\u0003\t\u0005\u000b1\u0007^3ti\u0012+G.\u001a;f\u001f\u001a47/\u001a;t\u001f\u001a\u001cF/\u00192mK\u000e{gn];nKJ<%o\\;q/&$\b\u000eV8qS\u000e|e\u000e\\=)\u0005\u0015\t\u0015a\u0010;fgR$U\r\\3uK>3gm]3ug>37\u000b^1cY\u0016\u001cuN\\:v[\u0016\u0014xI]8va^KG\u000f[+oW:|wO\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0015\u0003\r\u0005\u000b!\b^3ti\u0012+G.\u001a;f\u001f\u001a47/\u001a;t\u001f\u001a\u001cF/\u00192mK\u000e{gn];nKJ<%o\\;q/&$\b.\u00168l]><h\u000eV8qS\u000e|e\u000e\\=)\u0005\u001d\t\u0015a\u000e;fgR$U\r\\3uK>3gm]3ug>3W)\u001c9us\u000e{gn];nKJ<%o\\;q/&$\b\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\t\u0003\u0006\u0011D/Z:u\t\u0016dW\r^3PM\u001a\u001cX\r^:PM\u0016k\u0007\u000f^=D_:\u001cX/\\3s\u000fJ|W\u000f],ji\"$v\u000e]5d\u001f:d\u0017\u0010\u000b\u0002\n\u0003\u0006qD/Z:u\t\u0016dW\r^3PM\u001a\u001cX\r^:PM\u0016k\u0007\u000f^=D_:\u001cX/\\3s\u000fJ|W\u000f],ji\",fn\u001b8po:$v\u000e]5d!\u0006\u0014H/\u001b;j_:D#AC!\u0002sQ,7\u000f\u001e#fY\u0016$Xm\u00144gg\u0016$8o\u00144F[B$\u0018pQ8ogVlWM]$s_V\u0004x+\u001b;i+:\\gn\\<o)>\u0004\u0018nY(oYfD#aC!\u00027Q,7\u000f^,ji\"\u001cF/\u00192mK\u000e{gn];nKJ<%o\\;q)\u0015it,\u00194i\u0011\u0015\u0001G\u00021\u0001-\u0003)Ig\u000e];u)>\u0004\u0018n\u0019\u0005\u0006E2\u0001\raY\u0001\u000fS:\u0004X\u000f\u001e)beRLG/[8o!\t9C-\u0003\u0002fQ\t\u0019\u0011J\u001c;\t\u000b\u001dd\u0001\u0019A2\u0002#\u0015D\b/Z2uK\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0003j\u0019\u0001\u0007!.A\u0007fqB,7\r^3e\u000bJ\u0014xN\u001d\t\u0003WNl\u0011\u0001\u001c\u0006\u0003[:\f\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0006\u0003_B\faaY8n[>t'B\u0001\u000er\u0015\t\u0011\u0018*\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003i2\u0014a!\u0012:s_J\u001c\u0018A\u0007;fgR<\u0016\u000e\u001e5F[B$\u0018pQ8ogVlWM]$s_V\u0004H#B\u001fxqfT\b\"\u00021\u000e\u0001\u0004a\u0003\"\u00022\u000e\u0001\u0004\u0019\u0007\"B4\u000e\u0001\u0004\u0019\u0007\"B5\u000e\u0001\u0004Q\u0017!\u0006;fgR<\u0016\u000e\u001e5D_:\u001cX/\\3s\u000fJ|W\u000f\u001d\u000b\u000b{u\fY!!\u0004\u0002\u0010\u0005E\u0001\"\u0002@\u000f\u0001\u0004y\u0018!E<ji\"\u001cuN\\:v[\u0016\u0014xI]8vaB1q%!\u0001\u0002\u0006uJ1!a\u0001)\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003(\u0003\u000fi\u0014bAA\u0005Q\tAAHY=oC6,g\bC\u0003a\u001d\u0001\u0007A\u0006C\u0003c\u001d\u0001\u00071\rC\u0003h\u001d\u0001\u00071\rC\u0003j\u001d\u0001\u0007!.A\u0007qe>$WoY3SK\u000e|'\u000fZ\u0001\u0018o&$\bn\u0015;bE2,7i\u001c8tk6,'o\u0012:pkB$2!PA\r\u0011!\tY\u0002\u0005CA\u0002\u0005\u0015\u0011\u0001\u00022pIf\fac^5uQ\u0016k\u0007\u000f^=D_:\u001cX/\\3s\u000fJ|W\u000f\u001d\u000b\u0004{\u0005\u0005\u0002\u0002CA\u000e#\u0011\u0005\r!!\u0002\u0002\u001d\r\u0014X-\u0019;f!J|G-^2feR!\u0011qEA !!\tI#a\r\u00028\u0005]RBAA\u0016\u0015\u0011\ti#a\f\u0002\u0011A\u0014x\u000eZ;dKJT1!!\rq\u0003\u001d\u0019G.[3oiNLA!!\u000e\u0002,\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u0004Ba\n\u0016\u0002:A\u0019q%a\u000f\n\u0007\u0005u\u0002F\u0001\u0003CsR,\u0007\"CA!%A\u0005\t\u0019AA\"\u0003\u0019\u0019wN\u001c4jOB!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013\u0001B;uS2T!!!\u0014\u0002\t)\fg/Y\u0005\u0005\u0003#\n9E\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t9F\u000b\u0003\u0002D\u0005e3FAA.!\u0011\ti&a\u001a\u000e\u0005\u0005}#\u0002BA1\u0003G\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0004&\u0001\u0006b]:|G/\u0019;j_:LA!!\u001b\u0002`\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r\u0014X-\u0019;f\u0007>t7/^7feR!\u0011qNA>!!\t\t(a\u001e\u00028\u0005]RBAA:\u0015\u0011\t)(a\f\u0002\u0011\r|gn];nKJLA!!\u001f\u0002t\ti1*\u00194lC\u000e{gn];nKJD\u0011\"!\u0011\u0015!\u0003\u0005\r!a\u0011\u00021\r\u0014X-\u0019;f\u0007>t7/^7fe\u0012\"WMZ1vYR$\u0013\u0007")
public class DeleteOffsetsConsumerGroupCommandIntegrationTest
extends ConsumerGroupCommandTest {
    public String[] getArgs(String group, String topic) {
        return new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete-offsets", "--group", group, "--topic", topic};
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteOffsetsNonExistingGroup() {
        void var4_4;
        String group = "missing.group";
        String topic = "foo:1";
        Tuple2 tuple2 = this.getConsumerGroupService(this.getArgs(group, topic)).deleteOffsets(group, (List)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        Assertions.assertEquals((Object)Errors.GROUP_ID_NOT_FOUND, (Object)var4_4);
    }

    @Test
    public void testDeleteOffsetsOfStableConsumerGroupWithTopicPartition() {
        this.testWithStableConsumerGroup(this.topic(), 0, 0, Errors.GROUP_SUBSCRIBED_TO_TOPIC);
    }

    @Test
    public void testDeleteOffsetsOfStableConsumerGroupWithTopicOnly() {
        this.testWithStableConsumerGroup(this.topic(), -1, 0, Errors.GROUP_SUBSCRIBED_TO_TOPIC);
    }

    @Test
    public void testDeleteOffsetsOfStableConsumerGroupWithUnknownTopicPartition() {
        this.testWithStableConsumerGroup("foobar", 0, 0, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testDeleteOffsetsOfStableConsumerGroupWithUnknownTopicOnly() {
        this.testWithStableConsumerGroup("foobar", -1, -1, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testDeleteOffsetsOfEmptyConsumerGroupWithTopicPartition() {
        this.testWithEmptyConsumerGroup(this.topic(), 0, 0, Errors.NONE);
    }

    @Test
    public void testDeleteOffsetsOfEmptyConsumerGroupWithTopicOnly() {
        this.testWithEmptyConsumerGroup(this.topic(), -1, 0, Errors.NONE);
    }

    @Test
    public void testDeleteOffsetsOfEmptyConsumerGroupWithUnknownTopicPartition() {
        this.testWithEmptyConsumerGroup("foobar", 0, 0, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testDeleteOffsetsOfEmptyConsumerGroupWithUnknownTopicOnly() {
        this.testWithEmptyConsumerGroup("foobar", -1, -1, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    private void testWithStableConsumerGroup(String inputTopic, int inputPartition, int expectedPartition, Errors expectedError) {
        this.produceRecord();
        JFunction0.mcV.sp & Serializable intersect = (JFunction0.mcV.sp & Serializable)() -> {
            void var8_8;
            String topic = inputPartition >= 0 ? new StringBuilder(1).append(inputTopic).append(":").append(inputPartition).toString() : inputTopic;
            Tuple2 tuple2 = this.getConsumerGroupService(this.getArgs(this.group(), topic)).deleteOffsets(this.group(), (List)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Errors topLevelError = (Errors)tuple2._1();
            Map partitions = (Map)tuple2._2();
            TopicPartition tp = new TopicPartition(inputTopic, expectedPartition);
            if (inputPartition >= 0) {
                void var7_7;
                Assertions.assertEquals((Object)expectedError, (Object)var7_7);
            }
            Errors errors = expectedError;
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                Assertions.assertNull((Object)var8_8.apply((Object)tp));
                return;
            }
            Assertions.assertEquals((Object)expectedError.exception(), (Object)((Throwable)var8_8.apply((Object)tp)).getCause());
        };
        this.withStableConsumerGroup((Function0<BoxedUnit>)((Function0)intersect));
    }

    private void testWithEmptyConsumerGroup(String inputTopic, int inputPartition, int expectedPartition, Errors expectedError) {
        this.produceRecord();
        JFunction0.mcV.sp & Serializable intersect = (JFunction0.mcV.sp & Serializable)() -> {
            void var8_8;
            String topic = inputPartition >= 0 ? new StringBuilder(1).append(inputTopic).append(":").append(inputPartition).toString() : inputTopic;
            Tuple2 tuple2 = this.getConsumerGroupService(this.getArgs(this.group(), topic)).deleteOffsets(this.group(), (List)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Errors topLevelError = (Errors)tuple2._1();
            Map partitions = (Map)tuple2._2();
            TopicPartition tp = new TopicPartition(inputTopic, expectedPartition);
            if (inputPartition >= 0) {
                void var7_7;
                Assertions.assertEquals((Object)expectedError, (Object)var7_7);
            }
            Errors errors = expectedError;
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                Assertions.assertNull((Object)var8_8.apply((Object)tp));
                return;
            }
            Assertions.assertEquals((Object)expectedError.exception(), (Object)((Throwable)var8_8.apply((Object)tp)).getCause());
        };
        this.withEmptyConsumerGroup((Function0<BoxedUnit>)((Function0)intersect));
    }

    private void testWithConsumerGroup(Function1<Function0<BoxedUnit>, BoxedUnit> withConsumerGroup, String inputTopic, int inputPartition, int expectedPartition, Errors expectedError) {
        this.produceRecord();
        withConsumerGroup.apply((JFunction0.mcV.sp & Serializable)() -> {
            void var8_8;
            String topic = inputPartition >= 0 ? new StringBuilder(1).append(inputTopic).append(":").append(inputPartition).toString() : inputTopic;
            Tuple2 tuple2 = this.getConsumerGroupService(this.getArgs(this.group(), topic)).deleteOffsets(this.group(), (List)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Errors topLevelError = (Errors)tuple2._1();
            Map partitions = (Map)tuple2._2();
            TopicPartition tp = new TopicPartition(inputTopic, expectedPartition);
            if (inputPartition >= 0) {
                void var7_7;
                Assertions.assertEquals((Object)expectedError, (Object)var7_7);
            }
            Errors errors = expectedError;
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                Assertions.assertNull((Object)var8_8.apply((Object)tp));
                return;
            }
            Assertions.assertEquals((Object)expectedError.exception(), (Object)((Throwable)var8_8.apply((Object)tp)).getCause());
        });
    }

    private void produceRecord() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(new Properties());
        try {
            producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, null)).get();
        }
        finally {
            Utils.closeQuietly(producer, (String)"producer");
        }
    }

    private void withStableConsumerGroup(Function0<BoxedUnit> body) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(new Properties());
        try {
            TestUtils$.MODULE$.subscribeAndWaitForRecords(this.topic(), consumer, 15000L);
            consumer.commitSync();
            body.apply$mcV$sp();
        }
        finally {
            Utils.closeQuietly(consumer, (String)"consumer");
        }
    }

    private void withEmptyConsumerGroup(Function0<BoxedUnit> body) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(new Properties());
        try {
            TestUtils$.MODULE$.subscribeAndWaitForRecords(this.topic(), consumer, 15000L);
            consumer.commitSync();
        }
        finally {
            Utils.closeQuietly(consumer, (String)"consumer");
        }
        body.apply$mcV$sp();
    }

    private KafkaProducer<byte[], byte[]> createProducer(Properties config) {
        config.putIfAbsent("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        config.putIfAbsent("acks", "-1");
        config.putIfAbsent("key.serializer", ByteArraySerializer.class.getName());
        config.putIfAbsent("value.serializer", ByteArraySerializer.class.getName());
        return new KafkaProducer(config);
    }

    private Properties createProducer$default$1() {
        return new Properties();
    }

    private KafkaConsumer<byte[], byte[]> createConsumer(Properties config) {
        config.putIfAbsent("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        config.putIfAbsent("auto.offset.reset", "earliest");
        config.putIfAbsent("group.id", this.group());
        config.putIfAbsent("key.deserializer", ByteArrayDeserializer.class.getName());
        config.putIfAbsent("value.deserializer", ByteArrayDeserializer.class.getName());
        config.putIfAbsent("max.poll.interval.ms", Integer.toString(Integer.MAX_VALUE));
        config.putIfAbsent("session.timeout.ms", Integer.toString(Defaults$.MODULE$.GroupMaxSessionTimeoutMs()));
        return new KafkaConsumer(config);
    }

    private Properties createConsumer$default$1() {
        return new Properties();
    }

    public static final /* synthetic */ Object $anonfun$testWithStableConsumerGroup$1$adapted(DeleteOffsetsConsumerGroupCommandIntegrationTest $this, Function0 body) {
        $this.withStableConsumerGroup((Function0<BoxedUnit>)body);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testWithEmptyConsumerGroup$1$adapted(DeleteOffsetsConsumerGroupCommandIntegrationTest $this, Function0 body) {
        $this.withEmptyConsumerGroup((Function0<BoxedUnit>)body);
        return BoxedUnit.UNIT;
    }
}

