/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier.tools;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.tools.RecoveryTestUtils$;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierPartitionStateFencingTrigger;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005i4A!\u0006\f\u0001?!)a\u0005\u0001C\u0001O!9!\u0006\u0001b\u0001\n\u0013Y\u0003BB\u001f\u0001A\u0003%A\u0006C\u0005?\u0001\u0001\u0007\t\u0019!C\u0005\u007f!I\u0001\n\u0001a\u0001\u0002\u0004%I!\u0013\u0005\n\u001f\u0002\u0001\r\u0011!Q!\n\u0001C\u0011\u0002\u0015\u0001A\u0002\u0003\u0007I\u0011B \t\u0013E\u0003\u0001\u0019!a\u0001\n\u0013\u0011\u0006\"\u0003+\u0001\u0001\u0004\u0005\t\u0015)\u0003A\u0011%)\u0006\u00011AA\u0002\u0013%q\bC\u0005W\u0001\u0001\u0007\t\u0019!C\u0005/\"I\u0011\f\u0001a\u0001\u0002\u0003\u0006K\u0001\u0011\u0005\u00065\u0002!\ta\u0017\u0005\u0006S\u0002!\ta\u0017\u0005\u0006]\u0002!\ta\u0017\u0005\u0006a\u0002!\ta\u0017\u0005\u0006e\u0002!\ta\u0017\u0005\u0006i\u0002!\ta\u0017\u0005\u0006m\u0002!\ta\u0017\u0005\u0006q\u0002!\ta\u0017\u0002%)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR3oG&tw\r\u0016:jO\u001e,'\u000fV3ti*\u0011q\u0003G\u0001\u0006i>|Gn\u001d\u0006\u00033i\tA\u0001^5fe*\u00111\u0004H\u0001\u0006W\u000647.\u0019\u0006\u0002;\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0007\u0001\u0019\"\u0001\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002*\u00015\ta#A\bua&$7\u000fV8CK\u001a+gnY3e+\u0005a\u0003\u0003B\u00173iij\u0011A\f\u0006\u0003_A\n\u0011\"[7nkR\f'\r\\3\u000b\u0005E\u0012\u0013AC2pY2,7\r^5p]&\u00111G\f\u0002\u0004\u001b\u0006\u0004\bCA\u001b9\u001b\u00051$BA\r8\u0015\u0005Y\u0012BA\u001d7\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\"w%\u0011AH\t\u0002\b\u0005>|G.Z1o\u0003A!\b/\u001b3t)>\u0014UMR3oG\u0016$\u0007%A\u000bu_BL7-\u00133QCJ$\u0018\u000e^5p]N4\u0015\u000e\\3\u0016\u0003\u0001\u0003\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u0005%|'\"A#\u0002\t)\fg/Y\u0005\u0003\u000f\n\u0013AAR5mK\u0006IBo\u001c9jG&#\u0007+\u0019:uSRLwN\\:GS2,w\fJ3r)\tQU\n\u0005\u0002\"\u0017&\u0011AJ\t\u0002\u0005+:LG\u000fC\u0004O\u000b\u0005\u0005\t\u0019\u0001!\u0002\u0007a$\u0013'\u0001\fu_BL7-\u00133QCJ$\u0018\u000e^5p]N4\u0015\u000e\\3!\u00039yW\u000f\u001e9vi*\u001bxN\u001c$jY\u0016\f!c\\;uaV$(j]8o\r&dWm\u0018\u0013fcR\u0011!j\u0015\u0005\b\u001d\"\t\t\u00111\u0001A\u0003=yW\u000f\u001e9vi*\u001bxN\u001c$jY\u0016\u0004\u0013A\u00059s_B,'\u000f^5fg\u000e{gN\u001a$jY\u0016\fa\u0003\u001d:pa\u0016\u0014H/[3t\u0007>tgMR5mK~#S-\u001d\u000b\u0003\u0015bCqAT\u0006\u0002\u0002\u0003\u0007\u0001)A\nqe>\u0004XM\u001d;jKN\u001cuN\u001c4GS2,\u0007%A\u0003tKR,\u0006\u000fF\u0001KQ\tiQ\f\u0005\u0002_O6\tqL\u0003\u0002aC\u0006\u0019\u0011\r]5\u000b\u0005\t\u001c\u0017a\u00026va&$XM\u001d\u0006\u0003I\u0016\fQA[;oSRT\u0011AZ\u0001\u0004_J<\u0017B\u00015`\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001)i\u0016\u001cHOR3oG&twmV5uQ\u0016k\u0007\u000f^=U_BL7-\u00133QCJ$\u0018\u000e^5p]\u001aKG.\u001a\u0015\u0003\u001d-\u0004\"A\u00187\n\u00055|&\u0001\u0002+fgR\f\u0011\u0007^3ti\u001a+gnY5oO^KG\u000f\u001b\"bI2Lhi\u001c:nCR$X\r\u001a+pa&\u001c\u0017\n\u001a)beRLG/[8o\r&dW\r\u000b\u0002\u0010W\u00061C/Z:u\r\u0016t7-\u001b8h/&$\bn\\;u'B,7-\u001b4zS:<gI]3fu\u00164E.Y4)\u0005AY\u0017\u0001\t;fgR4UM\\2j]\u001e<\u0016\u000e\u001e5J]Z\fG.\u001b3U_BL7-\u00138qkRD#!E6\u0002IQ,7\u000f\u001e$f]\u000eLgnZ,ji\"LeN^1mS\u0012\u0004\u0016M\u001d;ji&|g.\u00138qkRD#AE6\u0002CQ,7\u000f\u001e$f]\u000eLgnZ,ji\"Le\u000e^3s]\u0006dGk\u001c9jG&s\u0007/\u001e;)\u0005MY\u0017\u0001\t;fgR4UM\\2j]\u001e<\u0016\u000e\u001e5CC\u0012\u0004&o\u001c9feRLWm\u001d$jY\u0016D#\u0001F6")
public class TierPartitionStateFencingTriggerTest {
    private final Map<TopicIdPartition, Object> tpidsToBeFenced = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("the_dark_knight", UUID.randomUUID(), 2)), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("mummy_returns", UUID.randomUUID(), 3)), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("mission_impossible", UUID.randomUUID(), 5)), (Object)BoxesRunTime.boxToBoolean((boolean)true))}));
    private File topicIdPartitionsFile;
    private File outputJsonFile;
    private File propertiesConfFile;

    private Map<TopicIdPartition, Object> tpidsToBeFenced() {
        return this.tpidsToBeFenced;
    }

    private File topicIdPartitionsFile() {
        return this.topicIdPartitionsFile;
    }

    private void topicIdPartitionsFile_$eq(File x$1) {
        this.topicIdPartitionsFile = x$1;
    }

    private File outputJsonFile() {
        return this.outputJsonFile;
    }

    private void outputJsonFile_$eq(File x$1) {
        this.outputJsonFile = x$1;
    }

    private File propertiesConfFile() {
        return this.propertiesConfFile;
    }

    private void propertiesConfFile_$eq(File x$1) {
        this.propertiesConfFile = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.topicIdPartitionsFile_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
        this.outputJsonFile_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
        RecoveryTestUtils$.MODULE$.writeFencingFile(this.topicIdPartitionsFile(), this.tpidsToBeFenced());
        this.propertiesConfFile_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
    }

    @Test
    public void testFencingWithEmptyTopicIdPartitionFile() {
        Utils.mkProperties((java.util.Map)new HashMap<String, String>(null){
            {
                this.put(KafkaConfig$.MODULE$.TierMetadataBootstrapServersProp(), "brokerlist");
                this.put(KafkaConfig$.MODULE$.TierMetadataNamespaceProp(), "");
            }
        }).store(new PrintWriter(this.propertiesConfFile()), "");
        File emptyTopicIdPartitionsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> TierPartitionStateFencingTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), this.propertiesConfFile().getPath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), emptyTopicIdPartitionsFile.getPath(), RecoveryUtils.makeArgument((String)"output.json"), this.outputJsonFile().getPath()}), ClassTag$.MODULE$.apply(ArgumentParserException.class), new Position("TierPartitionStateFencingTriggerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
    }

    @Test
    public void testFencingWithBadlyFormattedTopicIdPartitionFile() {
        File badTopicIdPartitionsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        PrintWriter pw = new PrintWriter(badTopicIdPartitionsFile);
        pw.write(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s,%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"abc", "def"})));
        pw.println();
        pw.close();
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> TierPartitionStateFencingTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), this.propertiesConfFile().getPath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), badTopicIdPartitionsFile.getPath(), RecoveryUtils.makeArgument((String)"output.json"), this.outputJsonFile().getPath()}), ClassTag$.MODULE$.apply(ArgumentParserException.class), new Position("TierPartitionStateFencingTriggerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
    }

    @Test
    public void testFencingWithoutSpecifyingFreezeFlag() {
        File incompleteFencingTriggerInputFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        PrintWriter pw = new PrintWriter(incompleteFencingTriggerInputFile);
        TopicIdPartition partitionToBeFenced = (TopicIdPartition)((Tuple2)this.tpidsToBeFenced().head())._1();
        pw.write(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{partitionToBeFenced.topicId(), partitionToBeFenced.topic(), Integer.toString(partitionToBeFenced.partition())})));
        pw.println();
        pw.close();
        File workingDir = TestUtils.tempDirectory(null, null);
        Utils.mkProperties((java.util.Map)new HashMap<String, String>(null, workingDir){
            {
                this.put("bootstrap.servers", "brokerList");
                this.put("confluent.tier.recovery.working.dir", workingDir$1.getAbsolutePath());
            }
        }).store(new PrintWriter(this.propertiesConfFile()), "");
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> TierPartitionStateFencingTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), this.propertiesConfFile().getPath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), incompleteFencingTriggerInputFile.getPath(), RecoveryUtils.makeArgument((String)"output.json"), this.outputJsonFile().getPath()}), ClassTag$.MODULE$.apply(ArgumentParserException.class), new Position("TierPartitionStateFencingTriggerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        File invalidFencingTriggerInputFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        pw = new PrintWriter(invalidFencingTriggerInputFile);
        pw.write(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s:%s-%s %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{partitionToBeFenced.topicId(), partitionToBeFenced.topic(), Integer.toString(partitionToBeFenced.partition()), "blah"})));
        pw.println();
        pw.close();
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> TierPartitionStateFencingTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), this.propertiesConfFile().getPath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), invalidFencingTriggerInputFile.getPath(), RecoveryUtils.makeArgument((String)"output.json"), this.outputJsonFile().getPath()}), ClassTag$.MODULE$.apply(ArgumentParserException.class), new Position("TierPartitionStateFencingTriggerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
    }

    @Test
    public void testFencingWithInvalidTopicInput() {
        File invalidTopicIdPartitionsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Map invalidTpids = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("joker", UUID.randomUUID(), 7)), (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
        RecoveryTestUtils$.MODULE$.writeFencingFile(invalidTopicIdPartitionsFile, (Map<TopicIdPartition, Object>)invalidTpids);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> TierPartitionStateFencingTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), this.propertiesConfFile().getPath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), invalidTopicIdPartitionsFile.getPath(), RecoveryUtils.makeArgument((String)"output.json"), this.outputJsonFile().getPath()}), ClassTag$.MODULE$.apply(ArgumentParserException.class), new Position("TierPartitionStateFencingTriggerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
    }

    @Test
    public void testFencingWithInvalidPartitionInput() {
        File invalidTopicIdPartitionsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        TopicIdPartition tpId0 = (TopicIdPartition)((Tuple2)this.tpidsToBeFenced().head())._1();
        Map invalidTpids = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(tpId0.topic(), tpId0.topicId(), 13)), (Object)BoxesRunTime.boxToBoolean((boolean)((Tuple2)this.tpidsToBeFenced().head())._2$mcZ$sp()))}));
        RecoveryTestUtils$.MODULE$.writeFencingFile(invalidTopicIdPartitionsFile, (Map<TopicIdPartition, Object>)invalidTpids);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> TierPartitionStateFencingTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), this.propertiesConfFile().getPath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), invalidTopicIdPartitionsFile.getPath(), RecoveryUtils.makeArgument((String)"output.json"), this.outputJsonFile().getPath()}), ClassTag$.MODULE$.apply(ArgumentParserException.class), new Position("TierPartitionStateFencingTriggerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
    }

    @Test
    public void testFencingWithInternalTopicInput() {
        File internalTopicIdPartitionsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Map internalTpids = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("__consumer_offsets", UUID.randomUUID(), 0)), (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
        RecoveryTestUtils$.MODULE$.writeFencingFile(internalTopicIdPartitionsFile, (Map<TopicIdPartition, Object>)internalTpids);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> TierPartitionStateFencingTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), this.propertiesConfFile().getPath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), internalTopicIdPartitionsFile.getPath(), RecoveryUtils.makeArgument((String)"output.json"), this.outputJsonFile().getPath()}), ClassTag$.MODULE$.apply(ArgumentParserException.class), new Position("TierPartitionStateFencingTriggerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
    }

    @Test
    public void testFencingWithBadPropertiesFile() {
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> TierPartitionStateFencingTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), "non-existing-file", RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), this.topicIdPartitionsFile().getPath(), RecoveryUtils.makeArgument((String)"output.json"), this.outputJsonFile().getPath()}), ClassTag$.MODULE$.apply(ArgumentParserException.class), new Position("TierPartitionStateFencingTriggerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> TierPartitionStateFencingTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), this.propertiesConfFile().getPath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), this.topicIdPartitionsFile().getPath(), RecoveryUtils.makeArgument((String)"output.json"), this.outputJsonFile().getPath()}), ClassTag$.MODULE$.apply(ArgumentParserException.class), new Position("TierPartitionStateFencingTriggerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
    }
}

