/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier.snapshot;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.AbstractLog;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.BaseTierStateTest;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001B\u0007\u000f\u0001]AQ\u0001\t\u0001\u0005\u0002\u0005Bq\u0001\n\u0001C\u0002\u0013EQ\u0005\u0003\u00043\u0001\u0001\u0006IA\n\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0011\u0019Y\u0004\u0001)A\u0005k!)A\b\u0001C!{!)1\u000b\u0001C\u0001)\")\u0011\u0010\u0001C\u0005u\"9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0001bBA\u000f\u0001\u0011%\u0011q\u0004\u0005\b\u0003\u0017\u0002A\u0011CA'\u0011\u001d\t)\b\u0001C\t\u0003o\u0012a\u0004V5feB\u000b'\u000f^5uS>t7\u000b^1uKNs\u0017\r]:i_R$Vm\u001d;\u000b\u0005=\u0001\u0012\u0001C:oCB\u001c\bn\u001c;\u000b\u0005E\u0011\u0012\u0001\u0002;jKJT!a\u0005\u000b\u0002\u000b-\fgm[1\u000b\u0003U\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u000e\u00011C\u0001\u0001\u0019!\tIb$D\u0001\u001b\u0015\tYB$A\u0003ti\u0006$XM\u0003\u0002\u0012;)\t1#\u0003\u0002 5\t\t\")Y:f)&,'o\u0015;bi\u0016$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005q\u0011AB3ySR,G-F\u0001'!\t9\u0003'D\u0001)\u0015\tI#&\u0001\u0004bi>l\u0017n\u0019\u0006\u0003W1\n!bY8oGV\u0014(/\u001a8u\u0015\tic&\u0001\u0003vi&d'\"A\u0018\u0002\t)\fg/Y\u0005\u0003c!\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB3ySR,G\rI\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0016\u0003U\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u00121!\u00138u\u00039qW/\u001c)beRLG/[8og\u0002\nQa]3u+B$\"AP!\u0011\u0005Yz\u0014B\u0001!8\u0005\u0011)f.\u001b;\t\u000b\t3\u0001\u0019A\"\u0002\u0011Q,7\u000f^%oM>\u0004\"\u0001R'\u000e\u0003\u0015S!AR$\u0002\u0007\u0005\u0004\u0018N\u0003\u0002I\u0013\u00069!.\u001e9ji\u0016\u0014(B\u0001&L\u0003\u0015QWO\\5u\u0015\u0005a\u0015aA8sO&\u0011a*\u0012\u0002\t)\u0016\u001cH/\u00138g_\"\u0012a\u0001\u0015\t\u0003\tFK!AU#\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0010uKN$H+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f':\f\u0007o\u001d5piR\u0011a(\u0016\u0005\u0006-\u001e\u0001\raV\u0001\u0007cV|'/^7\u0011\u0005a{fBA-^!\tQv'D\u0001\\\u0015\taf#\u0001\u0004=e>|GOP\u0005\u0003=^\na\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011al\u000e\u0015\u0005\u000f\r\\G\u000e\u0005\u0002eS6\tQM\u0003\u0002gO\u0006A\u0001O]8wS\u0012,'O\u0003\u0002i\u000f\u00061\u0001/\u0019:b[NL!A[3\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\tiw.I\u0001o\u0003\tQ8.I\u0001q\u0003\u0015Y'/\u00194uQ\u00119!O^<\u0011\u0005M$X\"A4\n\u0005U<'!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005A\u0018\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\u0006!3m\\7qCJ,7K\\1qg\"|G/\u00118e\r2,8\u000f[3e\rR\u00036+\u00128ue&,7\u000f\u0006\u0003?w\u0006-\u0001\"\u0002?\t\u0001\u0004i\u0018\u0001\u00044uaN4\u0015\u000e\\3QCRD\u0007c\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u00024jY\u0016T1!!\u0002/\u0003\rq\u0017n\\\u0005\u0004\u0003\u0013y(\u0001\u0002)bi\"Da!!\u0004\t\u0001\u0004i\u0018\u0001E:oCB\u001c\bn\u001c;GS2,\u0007+\u0019;i\u0003I!\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\t\u0005M\u0011\u0011\u0004\t\u00043\u0005U\u0011bAA\f5\t\u0011B+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0011\u0019\tY\"\u0003a\u0001k\u0005AA.Z1eKJLE-\u0001\u0004hKRdun\u001a\u000b\u0007\u0003C\t\u0019$!\u000e\u0011\u000bY\n\u0019#a\n\n\u0007\u0005\u0015rG\u0001\u0004PaRLwN\u001c\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011QF\u000f\u0002\u00071|w-\u0003\u0003\u00022\u0005-\"aC!cgR\u0014\u0018m\u0019;M_\u001eDa!a\u0007\u000b\u0001\u0004)\u0004bBA\u001c\u0015\u0001\u0007\u0011\u0011H\u0001\u0003iB\u0004B!a\u000f\u0002H5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0004d_6lwN\u001c\u0006\u0004'\u0005\r#bAA#\u0017\u00061\u0011\r]1dQ\u0016LA!!\u0013\u0002>\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u00073po:dw.\u00193G)B\u001b6K\\1qg\"|GO\u00117pER9Q0a\u0014\u0002`\u0005-\u0004bBA)\u0017\u0001\u0007\u00111K\u0001\t_\nT7\u000b^8sKB!\u0011QKA.\u001b\t\t9FC\u0002\u0002Zq\tQa\u001d;pe\u0016LA!!\u0018\u0002X\tyA+[3s\u001f\nTWm\u0019;Ti>\u0014X\rC\u0004\u0002b-\u0001\r!a\u0019\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007\u0003BA3\u0003Oj\u0011\u0001H\u0005\u0004\u0003Sb\"\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\tig\u0003a\u0001\u0003_\nab\u001d8baNDw\u000e^(cU\u0016\u001cG\u000fE\u0002\u001a\u0003cJ1!a\u001d\u001b\u0005\u00112\u0015\u000e\\3US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,7K\\1qg\"|Go\u00142kK\u000e$\u0018A\b;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cf.\u00199tQ>$h*Y7f)!\tI(a\u001f\u0002~\u0005\u0005\u0005\u0003\u0002\u001c\u0002$]Cq!!\u0017\r\u0001\u0004\t\u0019\u0006\u0003\u0004\u0002\u00001\u0001\raV\u0001\bi>\u0004\u0018nY%e\u0011\u0019\t\u0019\t\u0004a\u0001/\u0006Q1O\\1qg\"|G/\u00133")
public class TierPartitionStateSnapshotTest
extends BaseTierStateTest {
    private final AtomicBoolean exited = new AtomicBoolean(false);
    private final int numPartitions;

    public AtomicBoolean exited() {
        return this.exited;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateMetadataSnapshotsEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierTopicDeleteCheckIntervalMsProp(), "5");
        super.setUp(testInfo);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTierPartitionStateSnapshot(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "4096");
        props.put("confluent.tier.local.hotset.ms", "1");
        int leaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topicName(), this.numPartitions(), 1, props, this.createTopic$default$5(), this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        TopicIdPartition topicIdPartition = (TopicIdPartition)((AbstractLog)this.getLog(leaderId, this.topicPartition()).get()).topicIdPartition().get();
        Uuid topicId = topicIdPartition.kafkaTopicId();
        this.appendMessagesToLeaderAndWaitUntilTiered(leaderId, 2);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierPartitionStateSnapshotTest.$anonfun$testTierPartitionStateSnapshot$1(this, leaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierPartitionStateSnapshotTest.$anonfun$testTierPartitionStateSnapshot$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        UUID snapshotId = this.tierPartitionState(leaderId).lastSnapshotId();
        Predef$.MODULE$.assert(this.tierPartitionState(leaderId).lastSnapshotId() != null, (Function0 & Serializable)() -> "FTPS header should have recorded the timestamp for last snapshot");
        TierObjectStore objStore = (TierObjectStore)((KafkaBroker)this.brokerForId(leaderId).get()).tierObjectStoreOpt().get();
        Option<String> snapshotFullName = this.tierPartitionStateSnapshotName(objStore, topicId.toString(), snapshotId.toString());
        Predef$.MODULE$.assert(snapshotFullName.isDefined(), (Function0 & Serializable)() -> "Snapshot file not present at the object store");
        FileTierPartitionStateSnapshotObject snapshotObject = FileTierPartitionStateSnapshotObject.decodeSnapshotName((String)((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])((String)snapshotFullName.get()).split("/")))).split(new StringBuilder(4).append("_v0.").append(TierObjectStore.FileType.TIER_PARTITION_STATE_METADATA_SNAPSHOT.suffix()).toString())))));
        Path downloadedSnapshotFilePath = this.downloadFTPSSnapshotBlob(objStore, topicIdPartition, snapshotObject);
        String ftpsFileName = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionState(leaderId).dir().list()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)TierPartitionStateSnapshotTest.$anonfun$testTierPartitionStateSnapshot$5(f)))));
        Path ftpsFilePath = Paths.get(this.tierPartitionState(leaderId).dir().getAbsolutePath(), ftpsFileName);
        this.compareSnapshotAndFlushedFTPSEntries(ftpsFilePath, downloadedSnapshotFilePath);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierPartitionStateSnapshotTest.$anonfun$testTierPartitionStateSnapshot$6(this, leaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)TierPartitionStateSnapshotTest.$anonfun$testTierPartitionStateSnapshot$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.deleteTopic(this.topicName(), this.deleteTopic$default$2());
        String snapshotPrefix = new StringBuilder(4).append(TierObjectStore.DataTypePathPrefix.TIER_PARTITION_STATE_METADATA_SNAPSHOT.prefix()).append("/").append(topicId).append("/0/").toString();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 30000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierPartitionStateSnapshotTest.$anonfun$testTierPartitionStateSnapshot$8(objStore, snapshotPrefix)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)TierPartitionStateSnapshotTest.$anonfun$testTierPartitionStateSnapshot$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
    }

    private void compareSnapshotAndFlushedFTPSEntries(Path ftpsFilePath, Path snapshotFilePath) {
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ};
        Object var13_3 = null;
        CheckedFileIO ftpsFileChannel = CheckedFileIO.open((Path)ftpsFilePath, (boolean)false, (OpenOption[])open_options);
        Optional ftpsFileIteratorOpt = FileTierPartitionState.iterator((TopicPartition)this.topicPartition(), (CheckedFileIO)ftpsFileChannel);
        Predef$.MODULE$.assert(ftpsFileIteratorOpt.isPresent());
        FileTierPartitionIterator ftpsFileIterator = (FileTierPartitionIterator)ftpsFileIteratorOpt.get();
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ};
        Object var14_7 = null;
        CheckedFileIO snapshotFileChannel = CheckedFileIO.open((Path)snapshotFilePath, (boolean)false, (OpenOption[])open_options2);
        Optional snapshotFileIteratorOpt = FileTierPartitionState.iterator((TopicPartition)this.topicPartition(), (CheckedFileIO)snapshotFileChannel);
        Predef$.MODULE$.assert(snapshotFileIteratorOpt.isPresent());
        FileTierPartitionIterator snapshotFileIterator = (FileTierPartitionIterator)snapshotFileIteratorOpt.get();
        int count = 0;
        while (ftpsFileIterator.hasNext() && snapshotFileIterator.hasNext()) {
            TierObjectMetadata ftpsFileObjectMetadata = (TierObjectMetadata)ftpsFileIterator.next();
            TierObjectMetadata snapshotFileObjectMetadata = (TierObjectMetadata)snapshotFileIterator.next();
            boolean entriesAreSame = ftpsFileObjectMetadata.equals((Object)snapshotFileObjectMetadata);
            ++count;
            Predef$.MODULE$.assert(TierPartitionStateSnapshotTest.entriesMatched$1(entriesAreSame, snapshotFileIterator, ftpsFileObjectMetadata, snapshotFileObjectMetadata), (Function0 & Serializable)() -> new StringBuilder(88).append("Mismatch between tier metadata entries.\n").append("Entry at mutable file: ").append(ftpsFileObjectMetadata.toString()).append("\n").append("Entry at FTPS snapshot: ").append(snapshotFileObjectMetadata.toString()).toString());
        }
        System.out.println(new StringBuilder(27).append("Number of entries matched: ").append(count).toString());
    }

    public TierPartitionState tierPartitionState(int leaderId) {
        return ((AbstractLog)this.getLog(leaderId, this.topicPartition()).get()).tierPartitionState();
    }

    private Option<AbstractLog> getLog(int leaderId, TopicPartition tp) {
        return ((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(tp);
    }

    public Path downloadFTPSSnapshotBlob(TierObjectStore objStore, TopicIdPartition topicIdPartition, FileTierPartitionStateSnapshotObject snapshotObject) {
        TierObjectStore.TierPartitionStateSnapshotMetadata metadata = new TierObjectStore.TierPartitionStateSnapshotMetadata(topicIdPartition, snapshotObject);
        InputStream stream = null;
        Path tmpFilePath = TestUtils.tempFile((String)"kafka", (String)".tmp").toPath();
        try {
            try {
                stream = objStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, TierObjectStore.FileType.TIER_PARTITION_STATE_METADATA_SNAPSHOT).getInputStream();
                Files.copy(stream, tmpFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception exception) {
                Files.deleteIfExists(tmpFilePath);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return tmpFilePath;
    }

    public Option<String> tierPartitionStateSnapshotName(TierObjectStore store, String topicId, String snapshotId) {
        String snapshotPrefix = new StringBuilder(4).append(TierObjectStore.DataTypePathPrefix.TIER_PARTITION_STATE_METADATA_SNAPSHOT.prefix()).append("/").append(topicId).append("/0/").append(snapshotId).toString();
        None$ snapshotName = None$.MODULE$;
        Iterator iter = store.listObject(snapshotPrefix, false).keySet().iterator();
        if (iter.hasNext()) {
            snapshotName = new Some(iter.next());
        }
        return snapshotName;
    }

    public static final /* synthetic */ boolean $anonfun$testTierPartitionStateSnapshot$1(TierPartitionStateSnapshotTest $this, int leaderId$1) {
        return $this.tierPartitionState(leaderId$1).lastSnapshotTimestampMs() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testTierPartitionStateSnapshot$2() {
        return "Timed out waiting for the first FTPS snapshot to be taken";
    }

    public static final /* synthetic */ boolean $anonfun$testTierPartitionStateSnapshot$5(String f) {
        return f.contains("tierstate") && f.contains("mutable");
    }

    public static final /* synthetic */ boolean $anonfun$testTierPartitionStateSnapshot$6(TierPartitionStateSnapshotTest $this, int leaderId$1) {
        return $this.tierPartitionState(leaderId$1).lastCommittedSnapshotId() != null;
    }

    public static final /* synthetic */ String $anonfun$testTierPartitionStateSnapshot$7() {
        return "Timed out waiting for snapshot Id to be committed";
    }

    public static final /* synthetic */ boolean $anonfun$testTierPartitionStateSnapshot$8(TierObjectStore objStore$1, String snapshotPrefix$1) {
        return objStore$1.listObject(snapshotPrefix$1, false).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTierPartitionStateSnapshot$9() {
        return "Timed out waiting for snapshots to be deleted";
    }

    private static final boolean entriesMatched$1(boolean entriesAreSame, FileTierPartitionIterator snapshotFileIterator, TierObjectMetadata ftpsFileObjectMetadata, TierObjectMetadata snapshotFileObjectMetadata) {
        if (entriesAreSame) {
            return true;
        }
        if (snapshotFileIterator.hasNext()) {
            return false;
        }
        if (ftpsFileObjectMetadata.objectId().equals(snapshotFileObjectMetadata.objectId()) && ftpsFileObjectMetadata.baseOffset() == snapshotFileObjectMetadata.baseOffset() && ftpsFileObjectMetadata.endOffset() == snapshotFileObjectMetadata.endOffset()) {
            TierObjectMetadata.State state = ftpsFileObjectMetadata.state();
            TierObjectMetadata.State state2 = snapshotFileObjectMetadata.state();
            if (state == null ? state2 != null : !state.equals(state2)) {
                return true;
            }
        }
        return false;
    }

    public TierPartitionStateSnapshotTest() {
        this.numPartitions = 1;
    }
}

