/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier.management;

import integration.kafka.tier.management.BackupObjectLifecycleManagerTestUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import kafka.backupRestore.objectLifecycle.serdes.LifecycleManagerState;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.TierLogSegment;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.backupObjectLifecycle.LifecycleManager;
import kafka.tier.backupObjectLifecycle.NameAndId;
import kafka.tier.backupObjectLifecycle.StateManager;
import kafka.tier.backupObjectLifecycle.StateManagerConfig;
import kafka.tier.backupObjectLifecycle.TierTopicReader;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Exit;
import org.joda.time.DateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SortedMap;
import scala.collection.mutable.SortedMap$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001\u0002\u000b\u0016\u0001yAQa\t\u0001\u0005\u0002\u0011BqA\n\u0001C\u0002\u0013\u0005q\u0005\u0003\u00046\u0001\u0001\u0006I\u0001\u000b\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0011\u0019\u0019\u0005\u0001)A\u0005q!9A\t\u0001b\u0001\n\u00039\u0003BB#\u0001A\u0003%\u0001\u0006C\u0004G\u0001\t\u0007I\u0011A\u001c\t\r\u001d\u0003\u0001\u0015!\u00039\u0011\u001dA\u0005A1A\u0005\u0002\u001dBa!\u0013\u0001!\u0002\u0013A\u0003b\u0002&\u0001\u0005\u0004%\ta\u000e\u0005\u0007\u0017\u0002\u0001\u000b\u0011\u0002\u001d\t\u000f1\u0003!\u0019!C\u0001\u001b\"1!\u000b\u0001Q\u0001\n9CQa\u0015\u0001\u0005BQCQ\u0001\u001b\u0001\u0005\u0002%Dq!a\u0005\u0001\t\u0003\t)\u0002C\u0004\u0002$\u0001!\t!!\n\u0003C\t\u000b7m[;q\u001f\nTWm\u0019;MS\u001a,7-_2mK6\u000bg.Y4feR+7\u000f^:\u000b\u0005Y9\u0012AC7b]\u0006<W-\\3oi*\u0011\u0001$G\u0001\u0005i&,'O\u0003\u0002\u001b7\u0005)1.\u00194lC*\tA$A\u0006j]R,wM]1uS>t7\u0001A\n\u0003\u0001}\u0001\"\u0001I\u0011\u000e\u0003UI!AI\u000b\u0003K\t\u000b7m[;q\u001f\nTWm\u0019;MS\u001a,7-_2mK6\u000bg.Y4feR+7\u000f^+uS2\u001c\u0018A\u0002\u001fj]&$h\bF\u0001&!\t\u0001\u0003!A\u0004u_BL7mX\u0019\u0016\u0003!\u0002\"!\u000b\u001a\u000f\u0005)\u0002\u0004CA\u0016/\u001b\u0005a#BA\u0017\u001e\u0003\u0019a$o\\8u})\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\u00051\u0001K]3eK\u001aL!a\r\u001b\u0003\rM#(/\u001b8h\u0015\t\td&\u0001\u0005u_BL7mX\u0019!\u0003\u0011!\boX\u0019\u0016\u0003a\u0002\"!O!\u000e\u0003iR!a\u000f\u001f\u0002\r\r|W.\\8o\u0015\tQRH\u0003\u0002?\u007f\u00051\u0011\r]1dQ\u0016T\u0011\u0001Q\u0001\u0004_J<\u0017B\u0001\";\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQ\u0001\u001e9`c\u0001\nq\u0001^8qS\u000e|&'\u0001\u0005u_BL7m\u0018\u001a!\u0003\u0011!\bo\u0018\u001a\u0002\u000bQ\u0004xL\r\u0011\u0002\u000fQ|\u0007/[2`g\u0005AAo\u001c9jG~\u001b\u0004%\u0001\u0003ua~\u001b\u0014!\u0002;q?N\u0002\u0013!\u00048v[B\u000b'\u000f^5uS>t7/F\u0001O!\ty\u0005+D\u0001/\u0013\t\tfFA\u0002J]R\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0003tKR,\u0006\u000f\u0006\u0002V1B\u0011qJV\u0005\u0003/:\u0012A!\u00168ji\")\u0011\f\u0005a\u00015\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002\\E6\tAL\u0003\u0002^=\u0006\u0019\u0011\r]5\u000b\u0005}\u0003\u0017a\u00026va&$XM\u001d\u0006\u0003C~\nQA[;oSRL!a\u0019/\u0003\u0011Q+7\u000f^%oM>D#\u0001E3\u0011\u0005m3\u0017BA4]\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001-i\u0016\u001cHoU3h[\u0016tGo\u001d+p\u0005\u0016$U\r\\3uK\u0012$v\u000eZ1z\u000f\u0016$8\u000fR3mKR,G\rV8eCf$\"!\u00166\t\u000b-\f\u0002\u0019\u0001\u0015\u0002\rE,xN];nQ\u0011\tR.\u001e<\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018\u0001\u00039s_ZLG-\u001a:\u000b\u0005It\u0016A\u00029be\u0006l7/\u0003\u0002u_\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd#a^=\"\u0003a\f!A_6\"\u0003i\fQa\u001b:bMRDS!\u0005?\u0000\u0003\u0003\u0001\"aW?\n\u0005yd&a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0002q\":\u0011#!\u0002\u0002\u000e\u0005=\u0001\u0003BA\u0004\u0003\u0013i\u0011!]\u0005\u0004\u0003\u0017\t(!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\t\t\"\u0001\r|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|au\f1\u0004^3ti\u000ecUjR3ug\u0006cG\u000eV8qS\u000elU\r^1eCR\fGcA+\u0002\u0018!)1N\u0005a\u0001Q!*!#\\;\u0002\u001c1\u0012q/\u001f\u0015\u0006%q|\u0018q\u0004\u0010\u0002y!:!#!\u0002\u0002\u000e\u0005=\u0011A\b;fgR\u001cE*T\"p]N,X.Z:EK2,G/\u001a3TK\u001elWM\u001c;t)\r)\u0016q\u0005\u0005\u0006WN\u0001\r\u0001\u000b\u0015\u0006'5,\u00181\u0006\u0017\u0003ofDSa\u0005?\u0000\u0003?AsaEA\u0003\u0003\u001b\ty\u0001")
public class BackupObjectLifecycleManagerTests
extends BackupObjectLifecycleManagerTestUtils {
    private final String topic_1;
    private final TopicPartition tp_1 = new TopicPartition(this.topic_1(), 0);
    private final String topic_2;
    private final TopicPartition tp_2 = new TopicPartition(this.topic_2(), 0);
    private final String topic_3;
    private final TopicPartition tp_3 = new TopicPartition(this.topic_3(), 0);
    private final int numPartitions;

    public String topic_1() {
        return this.topic_1;
    }

    public TopicPartition tp_1() {
        return this.tp_1;
    }

    public String topic_2() {
        return this.topic_2;
    }

    public TopicPartition tp_2() {
        return this.tp_2;
    }

    public String topic_3() {
        return this.topic_3;
    }

    public TopicPartition tp_3() {
        return this.tp_3;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.CLMMaxBackupInDaysProp(), "7");
        this.serverConfig().put(KafkaConfig$.MODULE$.CLMTopicRetentionInDaysToBackupInDaysProp(), "0:0,3:3,4:4,5:5,6:6,7:7");
        this._testInfo_$eq(testInfo);
        super.setUp(this._testInfo());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @Timeout(value=120L)
    @ValueSource(strings={"zk", "kraft"})
    public void testSegmentsToBeDeletedTodayGetsDeletedToday(String quorum) {
        LifecycleManager clm = this.lifecycleManager();
        MockInMemoryTierObjectStore mockInMemoryTierObjectStore = (MockInMemoryTierObjectStore)((KafkaBroker)this.brokers().head()).tierObjectStoreOpt().get();
        String x$1 = this.tp_1().topic();
        Properties x$2 = this.topicProps();
        int x$32 = this.createTopic$default$2();
        int x$42 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int topic1LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$1, x$32, x$42, x$2, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_1(), this.brokerForId(topic1LeaderId).toList());
        this.changeTopicConfig("retention.ms", "120000", this.tp_1().topic());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), topic1LeaderId, 1);
        Option leader1Log = ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().getLog(this.tp_1());
        FileTierPartitionState ftps1 = (FileTierPartitionState)((AbstractLog)leader1Log.get()).tierPartitionState();
        ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_1()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader1Log.get()).logEndOffset()))})), (Function1 & Serializable)x$3 -> {
            BackupObjectLifecycleManagerTests.$anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$1(x$3);
            return BoxedUnit.UNIT;
        });
        long l = 500L;
        long waitUntilTrue_waitTimeMs = 600000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerTests.$anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$2(ftps1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerTests.$anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$3(this, leader1Log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        HashSet<UUID> deletedSegmentsTP1 = new HashSet<UUID>();
        deletedSegmentsTP1.addAll(TierTestUtils$.MODULE$.deletedSegments(ftps1, -1L));
        String x$7 = this.tp_2().topic();
        Properties x$8 = this.topicProps();
        int x$9 = this.createTopic$default$2();
        int x$10 = this.createTopic$default$3();
        ListenerName x$11 = this.createTopic$default$5();
        Properties x$12 = this.createTopic$default$6();
        int topic2LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$7, x$9, x$10, x$8, x$11, x$12).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_2(), this.brokerForId(topic2LeaderId).toList());
        this.changeTopicConfig("retention.ms", "259200000", this.tp_2().topic());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_2(), topic2LeaderId, 1);
        Option leader2Log = ((KafkaBroker)this.brokerForId(topic2LeaderId).get()).replicaManager().getLog(this.tp_2());
        FileTierPartitionState ftps2 = (FileTierPartitionState)((AbstractLog)leader2Log.get()).tierPartitionState();
        long curTime = System.currentTimeMillis();
        ((KafkaBroker)this.brokerForId(topic2LeaderId).get()).replicaManager().deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_2()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader2Log.get()).logEndOffset()))})), (Function1 & Serializable)x$4 -> {
            BackupObjectLifecycleManagerTests.$anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$4(x$4);
            return BoxedUnit.UNIT;
        });
        long l2 = 500L;
        long waitUntilTrue_waitTimeMs2 = 60000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerTests.$anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$5(ftps2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)BackupObjectLifecycleManagerTests.$anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        HashSet<UUID> deletedSegmentsTP2 = new HashSet<UUID>();
        deletedSegmentsTP2.addAll(TierTestUtils$.MODULE$.deletedSegments(ftps2, -1L));
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader1Log.get()));
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader2Log.get()));
        clm.manageLifecycleForBackedUpSegments();
        this.checkNonCurrentObjectExistence(deletedSegmentsTP1, (TopicIdPartition)ftps1.topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, false);
        LifecycleManagerState lifecycleManagerState = StateManager.getState((StateManagerConfig)new StateManagerConfig((TierObjectStore)mockInMemoryTierObjectStore, ((KafkaBroker)this.brokers().head()).clusterId(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false)));
        .colon.colon retentionInfoList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 0, -1, false, false), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_2().topic(), 3, -1, false, false), (List)Nil$.MODULE$));
        .colon.colon latestDataFilesInfoList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(curTime, 3), "00000001"), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfoList, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfoList, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState);
        .colon.colon blobMetadata = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.BlobMetadata(this, 3L, new DateTime(curTime + 259200000L).dayOfMonth().get()), (List)Nil$.MODULE$);
        .colon.colon topicMetadataList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.TopicMetadata(this, this.tp_2().topic(), ((TopicIdPartition)((AbstractLog)leader2Log.get()).topicIdPartition().get()).topicId().toString(), 0, TierTestUtils$.MODULE$.deletedSegments(ftps2, -1L), (List<BackupObjectLifecycleManagerTestUtils.BlobMetadata>)blobMetadata), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.BackupObjectsState backupObjectsState = new BackupObjectLifecycleManagerTestUtils.BackupObjectsState(this, (List<BackupObjectLifecycleManagerTestUtils.TopicMetadata>)topicMetadataList);
        this.validateBackupObjectsDeletionState(mockInMemoryTierObjectStore, lifecycleManagerState.latestDataFiles(0).latestFile(), lifecycleManagerState.latestDataFiles(0).date(), backupObjectsState);
        this.checkNonCurrentObjectExistence(deletedSegmentsTP2, (TopicIdPartition)ftps2.topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @Timeout(value=60L)
    @ValueSource(strings={"zk", "kraft"})
    public void testCLMGetsAllTopicMetadata(String quorum) {
        LifecycleManager clm = this.lifecycleManager();
        Properties props = new Properties();
        props.setProperty("retention.ms", "3600000");
        String x$1 = this.topic_1();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int topic1LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$1, x$3, x$4, props, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_1(), this.brokerForId(topic1LeaderId).toList());
        LogManager qual$1 = ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).logManager();
        TopicPartition x$7 = this.tp_1();
        boolean x$8 = qual$1.getLog$default$2();
        Uuid topic1id = (Uuid)((AbstractLog)qual$1.getLog(x$7, x$8).get()).topicId().get();
        props.setProperty("retention.ms", "-1");
        String x$9 = this.topic_2();
        int x$11 = this.createTopic$default$2();
        int x$12 = this.createTopic$default$3();
        ListenerName x$13 = this.createTopic$default$5();
        Properties x$14 = this.createTopic$default$6();
        int topic2LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$9, x$11, x$12, props, x$13, x$14).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_2(), this.brokerForId(topic2LeaderId).toList());
        LogManager qual$2 = ((KafkaBroker)this.brokerForId(topic2LeaderId).get()).logManager();
        TopicPartition x$15 = this.tp_2();
        boolean x$16 = qual$2.getLog$default$2();
        Uuid topic2id = (Uuid)((AbstractLog)qual$2.getLog(x$15, x$16).get()).topicId().get();
        props.setProperty("cleanup.policy", "compact");
        String x$17 = this.topic_3();
        int x$19 = this.createTopic$default$2();
        int x$20 = this.createTopic$default$3();
        ListenerName x$21 = this.createTopic$default$5();
        Properties x$22 = this.createTopic$default$6();
        int topic3LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$17, x$19, x$20, props, x$21, x$22).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_3(), this.brokerForId(topic3LeaderId).toList());
        LogManager qual$3 = ((KafkaBroker)this.brokerForId(topic3LeaderId).get()).logManager();
        TopicPartition x$23 = this.tp_3();
        boolean x$24 = qual$3.getLog$default$2();
        Uuid topic3id = (Uuid)((AbstractLog)qual$3.getLog(x$23, x$24).get()).topicId().get();
        java.util.Map retentionConfigs = clm.getKafkaTopicRetentionMs();
        Assertions.assertTrue((retentionConfigs.size() > 0 ? 1 : 0) != 0);
        NameAndId topic1Info = new NameAndId(this.topic_1(), topic1id);
        NameAndId topic2Info = new NameAndId(this.topic_2(), topic2id);
        Predef$.MODULE$.assert(true);
        Assertions.assertTrue((retentionConfigs.containsKey(topic1Info) && BoxesRunTime.equals(retentionConfigs.get(topic1Info), (Object)BoxesRunTime.boxToInteger((int)3600000)) ? 1 : 0) != 0);
        Assertions.assertTrue((retentionConfigs.containsKey(topic2Info) && BoxesRunTime.equals(retentionConfigs.get(topic2Info), (Object)BoxesRunTime.boxToInteger((int)-1)) ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)retentionConfigs.containsKey(new NameAndId(this.topic_3(), topic3id)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @Timeout(value=60L)
    @ValueSource(strings={"zk", "kraft"})
    public void testCLMConsumesDeletedSegments(String quorum) {
        Properties props = new Properties();
        props.put("segment.bytes", "2048");
        props.put("confluent.tier.local.hotset.ms", "10");
        props.put("confluent.tier.local.hotset.bytes", "0");
        props.put("file.delete.delay.ms", "10");
        String x$1 = this.tp_1().topic();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int leaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$1, x$3, x$4, props, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_1(), this.brokerForId(leaderId).toList());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), leaderId, this.appendMessagesToLeaderAndWaitUntilTiered$default$3());
        long l = 500L;
        long waitUntilTrue_waitTimeMs = 50000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.isHotsetDeleted(this.tp_1(), leaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerTests.$anonfun$testCLMConsumesDeletedSegments$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Option log = ((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(this.tp_1());
        ArrayList tierOffsets = new ArrayList();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.tierMetadataNumPartitionsProp()).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> tierOffsets.add(Predef$.MODULE$.long2Long(0L)));
        SortedMap allTieredSegments = (SortedMap)SortedMap$.MODULE$.apply((Seq)Nil$.MODULE$, (Ordering)Ordering.Long$.MODULE$);
        Iterator tieredSegmentsIter = ((AbstractLog)log.get()).tieredLogSegments();
        while (tieredSegmentsIter.hasNext()) {
            TierLogSegment segment = (TierLogSegment)tieredSegmentsIter.next();
            allTieredSegments.put((Object)BoxesRunTime.boxToLong((long)segment.baseOffset()), (Object)segment);
        }
        LifecycleManager clm = this.lifecycleManager();
        FileTierPartitionState ftps1 = (FileTierPartitionState)((AbstractLog)log.get()).tierPartitionState();
        TierTopicReader tierTopicReader = clm.createTierTopicReader(tierOffsets);
        java.util.List deletedSegmentsAtCLM_1 = tierTopicReader.deletedSegments();
        long[] newTierOffsets = tierTopicReader.currentPositions();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), newTierOffsets.length).foreach((Function1 & Serializable)i -> tierOffsets.set(BoxesRunTime.unboxToInt((Object)i), Predef$.MODULE$.long2Long(newTierOffsets[BoxesRunTime.unboxToInt((Object)i)])));
        tierTopicReader.maybeCloseConsumer();
        Predef$.MODULE$.assert(deletedSegmentsAtCLM_1.isEmpty());
        long newRetentionBytes = ((AbstractLog)log.get()).size() - (this.getSizeOfTieredSegments((AbstractLog)log.get(), 3) + 1L);
        long newStartOffset = ((Tuple2)allTieredSegments.toList().apply(3))._1$mcJ$sp();
        this.changeTopicConfig("retention.bytes", Long.toString(newRetentionBytes), this.tp_1().topic());
        long l2 = 500L;
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerTests.$anonfun$testCLMConsumesDeletedSegments$5(log, newStartOffset)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)BackupObjectLifecycleManagerTests.$anonfun$testCLMConsumesDeletedSegments$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        TierTopicReader tierTopicReader2 = clm.createTierTopicReader(tierOffsets);
        Set<UUID> deletedSegmentsAtTPS = TierTestUtils$.MODULE$.deletedSegments(ftps1, -1L);
        java.util.List deletedSegmentsAtCLM = tierTopicReader2.deletedSegments();
        Predef$.MODULE$.assert(deletedSegmentsAtCLM.size() > 0 && deletedSegmentsAtCLM.size() == deletedSegmentsAtTPS.size());
        Predef$.MODULE$.assert(deletedSegmentsAtCLM.stream().allMatch(s -> deletedSegmentsAtTPS.contains(s.getObjectId())));
        scala.collection.mutable.Set deletedSegments = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set liveSegments = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (Tuple2 segment : allTieredSegments) {
            if (segment._1$mcJ$sp() < newStartOffset) {
                deletedSegments.add((Object)((TierLogSegment)segment._2()).objectId());
                continue;
            }
            liveSegments.add((Object)((TierLogSegment)segment._2()).objectId());
        }
        tierTopicReader = clm.createTierTopicReader(tierOffsets);
        java.util.List deletedSegmentsAtCLM_2 = tierTopicReader.deletedSegments();
        tierTopicReader.maybeCloseConsumer();
        Predef$.MODULE$.assert(deletedSegmentsAtCLM_2.size() > 0);
        deletedSegmentsAtCLM_2.stream().forEach(s -> Predef$.MODULE$.assert(deletedSegments.contains((Object)s.getObjectId())));
        deletedSegmentsAtCLM_2.stream().forEach(s -> Assertions.assertFalse((boolean)liveSegments.contains((Object)s.getObjectId())));
    }

    public static final /* synthetic */ void $anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$1(Map x$3) {
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$2(FileTierPartitionState ftps1$1) {
        return TierTestUtils$.MODULE$.deletedSegments(ftps1$1, -1L).size() >= 1;
    }

    public static final /* synthetic */ String $anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$3(BackupObjectLifecycleManagerTests $this, Option leader1Log$1) {
        return new StringBuilder(39).append("Segments deleted = ").append($this.getDeletedTieredSegments((AbstractLog)leader1Log$1.get()).size()).append(" Expected at-least 1").toString();
    }

    public static final /* synthetic */ void $anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$4(Map x$4) {
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$5(FileTierPartitionState ftps2$1) {
        return TierTestUtils$.MODULE$.deletedSegments(ftps2$1, -1L).size() >= 1;
    }

    public static final /* synthetic */ String $anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$6() {
        return "Leader2 logs aren't deleted after retention bytes change";
    }

    public static final /* synthetic */ String $anonfun$testCLMConsumesDeletedSegments$2() {
        return "Waiting for hot set to reduce";
    }

    public static final /* synthetic */ boolean $anonfun$testCLMConsumesDeletedSegments$5(Option log$1, long newStartOffset$1) {
        return BoxesRunTime.equals(((AbstractLog)log$1.get()).tierPartitionState().startOffset().get(), (Object)BoxesRunTime.boxToLong((long)newStartOffset$1));
    }

    public static final /* synthetic */ String $anonfun$testCLMConsumesDeletedSegments$6() {
        return "Older segments did not delete per new retention size";
    }

    public BackupObjectLifecycleManagerTests() {
        this.topic_1 = "topic-1";
        this.topic_2 = "topic-2";
        this.topic_3 = "topic-3";
        this.numPartitions = 1;
    }
}

