/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier;

import java.io.Serializable;
import java.util.function.Function;
import kafka.tier.backupObjectLifecycle.RetryFramework;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Matchers$;
import org.scalatest.concurrent.Signaler$;
import org.scalatest.concurrent.TimeLimits$;
import org.scalatest.enablers.Timed$;
import org.scalatest.time.Millis$;
import org.scalatest.time.Span$;
import org.scalatest.time.Units;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005!2Aa\u0001\u0003\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/\t!B+[3s)>\u0004\u0018n\u0019*fC\u0012,'\u000fV3tiNT!!\u0002\u0004\u0002\tQLWM\u001d\u0006\u0003\u000f!\tQa[1gW\u0006T\u0011!C\u0001\fS:$Xm\u001a:bi&|gn\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0011Q\u0003A\u0007\u0002\t\u00059B/Z:u%\u0016$(/\u001f$sC6,wo\u001c:l\u000bbLGo\u001d\u000b\u00021A\u0011Q\"G\u0005\u000359\u0011A!\u00168ji\"\u0012!\u0001\b\t\u0003;\u0019j\u0011A\b\u0006\u0003?\u0001\n1!\u00199j\u0015\t\t#%A\u0004kkBLG/\u001a:\u000b\u0005\r\"\u0013!\u00026v]&$(\"A\u0013\u0002\u0007=\u0014x-\u0003\u0002(=\t!A+Z:u\u0001")
public class TierTopicReaderTests {
    @Test
    public void testRetryFrameworkExits() {
        int maxRetries = 3;
        TopicPartition p1 = new TopicPartition("foo", 0);
        TopicPartition p2 = new TopicPartition("foo", 1);
        TopicPartition p3 = new TopicPartition("foo", 2);
        KafkaConsumer consumer = (KafkaConsumer)Mockito.mock(KafkaConsumer.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)consumer.position(p1))).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)consumer.position(p2))).thenThrow(new Throwable[]{new TimeoutException()});
        Mockito.when((Object)BoxesRunTime.boxToLong((long)consumer.position(p3))).thenThrow(new Throwable[]{new TimeoutException()}).thenThrow(new Throwable[]{new TimeoutException()}).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Function<TopicPartition, Long> fn = tp -> Predef$.MODULE$.long2Long(consumer.position(tp));
        TimeLimits$.MODULE$.failAfter(Span$.MODULE$.apply(30000L, (Units)Millis$.MODULE$), (Function0)(JFunction0.mcV.sp & Serializable)() -> Predef$.MODULE$.assert(BoxesRunTime.equals((Object)new RetryFramework(maxRetries).call(fn, (Object)p1), (Object)BoxesRunTime.boxToLong((long)100L))), Signaler$.MODULE$.default(), Prettifier$.MODULE$.default(), new Position("TierTopicReaderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41), Timed$.MODULE$.timed());
        TimeLimits$.MODULE$.failAfter(Span$.MODULE$.apply(30000L, (Units)Millis$.MODULE$), (Function0 & Serializable)() -> Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> (Long)new RetryFramework(maxRetries).call(fn, (Object)p2), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("TierTopicReaderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47)), Signaler$.MODULE$.default(), Prettifier$.MODULE$.default(), new Position("TierTopicReaderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46), Timed$.MODULE$.timed());
        TimeLimits$.MODULE$.failAfter(Span$.MODULE$.apply(30000L, (Units)Millis$.MODULE$), (Function0)(JFunction0.mcV.sp & Serializable)() -> Predef$.MODULE$.assert(BoxesRunTime.equals((Object)new RetryFramework(maxRetries).call(fn, (Object)p3), (Object)BoxesRunTime.boxToLong((long)100L))), Signaler$.MODULE$.default(), Prettifier$.MODULE$.default(), new Position("TierTopicReaderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53), Timed$.MODULE$.timed());
    }
}

