/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.durability.exception.MemoryLimitExceededException;
import kafka.durability.utils.DurabilityOffsetMapUtils$;
import kafka.durability.utils.OffsetInfo;
import kafka.log.AbstractLog;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.LogManager;
import kafka.log.TierLogSegment;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.Throttler;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.SortedMap;
import scala.collection.mutable.SortedMap$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005ug\u0001B\u0010!\u0001\u001dBQa\f\u0001\u0005\u0002ABQa\r\u0001\u0005RQBQa\u000f\u0001\u0005\nqBq\u0001\u0011\u0001C\u0002\u0013%\u0011\t\u0003\u0004K\u0001\u0001\u0006IA\u0011\u0005\b\u0017\u0002\u0011\r\u0011\"\u00035\u0011\u0019a\u0005\u0001)A\u0005k!9Q\n\u0001b\u0001\n\u0013!\u0004B\u0002(\u0001A\u0003%Q\u0007C\u0004P\u0001\u0001\u0007I\u0011\u0002\u001b\t\u000fA\u0003\u0001\u0019!C\u0005#\"1A\u000b\u0001Q!\nUBq!\u0016\u0001C\u0002\u0013%a\u000b\u0003\u0004`\u0001\u0001\u0006Ia\u0016\u0005\u0006A\u0002!I!\u0019\u0005\bs\u0002\u0011\r\u0011\"\u0001{\u0011\u001d\tY\u0001\u0001Q\u0001\nmDq!!\u0004\u0001\t\u0003\ny\u0001\u0003\u0004\u00020\u0001!\t\u0005\u0010\u0005\b\u0003s\u0001A\u0011BA\u001e\u0011\u001d\tI\u0004\u0001C\u0005\u0003\u0003Ba!a\u0015\u0001\t\u0013a\u0004bBA+\u0001\u0011%\u0011q\u000b\u0005\n\u0003G\u0002\u0011\u0013!C\u0005\u0003KBa!a\u001f\u0001\t\u0013a\u0004BBA?\u0001\u0011%A\b\u0003\u0004\u0002\u0000\u0001!I\u0001\u0010\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011\u001d\t)\r\u0001C\u0001\u0003\u000fDq!!5\u0001\t\u0003\t\u0019NA\tPM\u001a\u001cX\r^'ba\u001aKG.\u001a+fgRT!!\t\u0012\u0002\tQLWM\u001d\u0006\u0003G\u0011\nQa[1gW\u0006T\u0011!J\u0001\fS:$Xm\u001a:bi&|gn\u0001\u0001\u0014\u0005\u0001A\u0003CA\u0015.\u001b\u0005Q#BA\u0016-\u0003\r\t\u0007/\u001b\u0006\u0002G%\u0011aF\u000b\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012!\r\t\u0003e\u0001i\u0011\u0001I\u0001\fEJ|7.\u001a:D_VtG/F\u00016!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\rIe\u000e^\u0001\u000eG>tg-[4ve\u0016lunY6\u0015\u0003u\u0002\"A\u000e \n\u0005}:$\u0001B+oSR\fQ\u0001^8qS\u000e,\u0012A\u0011\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bA\u0001\\1oO*\tq)\u0001\u0003kCZ\f\u0017BA%E\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n!\u0002]1si&$\u0018n\u001c8t\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\u0002\u001b5\f\u0007PT;n%\u0016\u001cwN\u001d3t\u00039i\u0017\r\u001f(v[J+7m\u001c:eg\u0002\n!C\\;n!J|G-^2fIJ+7m\u001c:eg\u00061b.^7Qe>$WoY3e%\u0016\u001cwN\u001d3t?\u0012*\u0017\u000f\u0006\u0002>%\"91kCA\u0001\u0002\u0004)\u0014a\u0001=%c\u0005\u0019b.^7Qe>$WoY3e%\u0016\u001cwN\u001d3tA\u0005y\u0001O]8ek\u000e,GMU3d_J$7/F\u0001X!\u0011AV,N\u001b\u000e\u0003eS!AW.\u0002\u000f5,H/\u00192mK*\u0011AlN\u0001\u000bG>dG.Z2uS>t\u0017B\u00010Z\u0005\ri\u0015\r]\u0001\u0011aJ|G-^2fIJ+7m\u001c:eg\u0002\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u000b\u0002EB\u00191m\u001b8\u000f\u0005\u0011LgBA3i\u001b\u00051'BA4'\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u0002ko\u00059\u0001/Y2lC\u001e,\u0017B\u00017n\u0005\r\u0019V-\u001d\u0006\u0003U^\u0002\"a\\<\u000e\u0003AT!!\u001d:\u0002\r\r|W.\\8o\u0015\t\u00193O\u0003\u0002uk\u00061\u0011\r]1dQ\u0016T\u0011A^\u0001\u0004_J<\u0017B\u0001=q\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fa!\u001a=ji\u0016$W#A>\u0011\u0007q\f9!D\u0001~\u0015\tqx0\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003\u0003\t\u0019!\u0001\u0006d_:\u001cWO\u001d:f]RT1!!\u0002G\u0003\u0011)H/\u001b7\n\u0007\u0005%QPA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\bKbLG/\u001a3!\u0003\u0015\u0019X\r^+q)\ri\u0014\u0011\u0003\u0005\b\u0003'\u0011\u0002\u0019AA\u000b\u0003!!Xm\u001d;J]\u001a|\u0007\u0003BA\f\u0003Gi!!!\u0007\u000b\u0007-\nYB\u0003\u0003\u0002\u001e\u0005}\u0011a\u00026va&$XM\u001d\u0006\u0004\u0003C)\u0018!\u00026v]&$\u0018\u0002BA\u0013\u00033\u0011\u0001\u0002V3ti&sgm\u001c\u0015\u0004%\u0005%\u0002\u0003BA\f\u0003WIA!!\f\u0002\u001a\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3aEA\u001a!\u0011\t9\"!\u000e\n\t\u0005]\u0012\u0011\u0004\u0002\n\u0003\u001a$XM]#bG\"\f1\u0003\u001d:pIV\u001cWmS3zK\u0012\u0014VmY8sIN$2!PA\u001f\u0011\u0019\ty\u0004\u0006a\u0001k\u0005Qa.^7SK\u000e|'\u000fZ:\u0015\u0007u\n\u0019\u0005C\u0004\u0002FU\u0001\r!a\u0012\u0002\u0013-,\u0017PV1mk\u0016\u001c\b#B2\u0002J\u00055\u0013bAA&[\n!A*[:u!\u00151\u0014qJ\u001b6\u0013\r\t\tf\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0002G]\f\u0017\u000e^+oi&d7+Z4nK:$8\u000fV5fe\u0016$\u0017I\u001c3D_6\u0004\u0018m\u0019;fI\u0006ya-\u001b7uKJ|eMZ:fi6\u000b\u0007\u000fF\u0002>\u00033B\u0011\"a\u0017\u0018!\u0003\u0005\r!!\u0018\u0002%=4gm]3u\u001b\u0006\u00048+\u001b>f\u0019&l\u0017\u000e\u001e\t\u0004m\u0005}\u0013bAA1o\t!Aj\u001c8h\u0003e1\u0017\u000e\u001c;fe>3gm]3u\u001b\u0006\u0004H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d$\u0006BA/\u0003SZ#!a\u001b\u0011\t\u00055\u0014qO\u0007\u0003\u0003_RA!!\u001d\u0002t\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003k:\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011PA8\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0011G2,\u0017M\\;q)\u0016l\u0007OR5mKN\f1b\u00197fC:,\b\u000fV3ti\u0006ya/\u001a:jMf|eMZ:fi6\u000b\u0007/\u0001\fuKN$xJ\u001a4tKRl\u0015\r\u001d*fiJLWM^1m)\ri\u0014Q\u0011\u0005\b\u0003\u000fc\u0002\u0019AAE\u0003\u0019\tXo\u001c:v[B!\u00111RAJ\u001d\u0011\ti)a$\u0011\u0005\u0015<\u0014bAAIo\u00051\u0001K]3eK\u001aL1!SAK\u0015\r\t\tj\u000e\u0015\b9\u0005e\u0015\u0011VAV!\u0011\tY*!*\u000e\u0005\u0005u%\u0002BAP\u0003C\u000b\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0003G\u000bY\"\u0001\u0004qCJ\fWn]\u0005\u0005\u0003O\u000biJA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003[\u000b\t,\t\u0002\u00020\u0006\u0011!p[\u0011\u0003\u0003g\u000bQa\u001b:bMRDs\u0001HA\\\u0003\u007f\u000b\t\r\u0005\u0003\u0002:\u0006mVBAAQ\u0013\u0011\ti,!)\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAAb\u0003aYH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b'`\u0001\u000ei\u0016\u001cH/T3sO\u00164\u0015\u000e\\3\u0015\u0007u\nI\rC\u0004\u0002\bv\u0001\r!!#)\u000fu\tI*!+\u0002N2\"\u0011QVAYQ\u001di\u0012qWA`\u0003\u0003\fa\u0007Z1D_6\u0004\u0018m\u0019;j_:\u0014VO\\%t\u0003\n|'\u000f^3e\u0013\u001a|eMZ:fi6\u000b\u0007oU5{K\u0016C8-Z3egRCW\rT5nSR$2!PAk\u0011\u001d\t9I\ba\u0001\u0003\u0013CsAHAM\u0003S\u000bI\u000e\f\u0003\u0002.\u0006E\u0006f\u0002\u0010\u00028\u0006}\u0016\u0011\u0019")
public class OffsetMapFileTest
extends IntegrationTestHarness {
    private final String topic;
    private final int partitions;
    private final int maxNumRecords;
    private int numProducedRecords;
    private final Map<Object, Object> producedRecords;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 1;
    }

    private void configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private int maxNumRecords() {
        return this.maxNumRecords;
    }

    private int numProducedRecords() {
        return this.numProducedRecords;
    }

    private void numProducedRecords_$eq(int x$1) {
        this.numProducedRecords = x$1;
    }

    private Map<Object, Object> producedRecords() {
        return this.producedRecords;
    }

    private Seq<TopicPartition> topicPartitions() {
        return package$.MODULE$.Range().apply(0, this.partitions()).map((Function1 & Serializable)p -> OffsetMapFileTest.$anonfun$topicPartitions$1(this, BoxesRunTime.unboxToInt((Object)p)));
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
        this.numProducedRecords_$eq(0);
        this.producedRecords().clear();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.numProducedRecords_$eq(0);
        this.producedRecords().clear();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    private void produceKeyedRecords(int numRecords) {
        Random random = new Random();
        List keyValues = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).toList().map((Function1 & Serializable)i -> OffsetMapFileTest.$anonfun$produceKeyedRecords$1(this, random, BoxesRunTime.unboxToInt((Object)i)));
        this.produceKeyedRecords((List<Tuple2<Object, Object>>)keyValues);
        this.numProducedRecords_$eq(this.numProducedRecords() + numRecords);
    }

    private void produceKeyedRecords(List<Tuple2<Object, Object>> keyValues) {
        try (KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());){
            keyValues.grouped(10).foreach((Function1 & Serializable)group -> group.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int k = x0$1._1$mcI$sp();
                    int v = x0$1._2$mcI$sp();
                    this.producedRecords().put((Object)BoxesRunTime.boxToInteger((int)k), (Object)BoxesRunTime.boxToInteger((int)v));
                    long timestamp = System.currentTimeMillis();
                    return new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(timestamp), (Object)Integer.toString(k).getBytes(StandardCharsets.UTF_8), (Object)Integer.toString(v).getBytes(StandardCharsets.UTF_8));
                }
                throw new MatchError(null);
            }).map((Function1 & Serializable)x$1 -> producer.send(x$1)).map((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS)));
        }
    }

    private void waitUntilSegmentsTieredAndCompacted() {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            OffsetMapFileTest.$anonfun$waitUntilSegmentsTieredAndCompacted$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void filterOffsetMap(long offsetMapSizeLimit) {
        Throttler throttler = new Throttler(100000.0, 100L, true, "throttler", "entries", Time.SYSTEM);
        ByteBuffer readBuffer = ByteBuffer.allocate(0x100000);
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)new MockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            OffsetMapFileTest.$anonfun$filterOffsetMap$1(this, tierObjectStore, throttler, readBuffer, offsetMapSizeLimit, tp);
            return BoxedUnit.UNIT;
        });
    }

    private long filterOffsetMap$default$1() {
        return 5000L;
    }

    private void cleanupTempFiles() {
        new File(".", "mergedFile.tmp").delete();
        new File(".", "newFile.tmp").delete();
    }

    private void cleanupTest() {
        new File(".", "mergedFile").delete();
        new File(".", "combinedFile").delete();
    }

    private void verifyOffsetMap() {
        this.cleanupTempFiles();
        this.cleanupTest();
        BooleanRef first = BooleanRef.create((boolean)true);
        ByteBuffer readBuffer = ByteBuffer.allocate(1024);
        Throttler throttler = new Throttler(100000.0, 100L, true, "throttler", "entries", Time.SYSTEM);
        SortedMap combinedMap = (SortedMap)SortedMap$.MODULE$.apply((Seq)Nil$.MODULE$, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)new MockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            OffsetMapFileTest.$anonfun$verifyOffsetMap$1(this, tierObjectStore, throttler, readBuffer, combinedMap, first, tp);
            return BoxedUnit.UNIT;
        });
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile((scala.collection.SortedMap)combinedMap, Paths.get(".", "combinedFile").toFile(), false);
        Assertions.assertEquals((int)0, (int)DurabilityOffsetMapUtils$.MODULE$.checkCongruentOffsetMapFile(new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), CoreUtils$.MODULE$.toJavaUUID(Uuid.randomUuid()), ((TopicPartition)this.topicPartitions().head()).partition()), new File(".", "combinedFile"), new File(".", "mergedFile")));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testOffsetMapRetrieval(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.createTopic(this.topic(), this.partitions(), 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        this.filterOffsetMap(this.filterOffsetMap$default$1());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMergeFile(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.createTopic(this.topic(), this.partitions(), 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        this.verifyOffsetMap();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void daCompactionRunIsAbortedIfOffsetMapSizeExceedsTheLimit(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.createTopic(this.topic(), this.partitions(), 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        Assertions.assertThrows(MemoryLimitExceededException.class, () -> this.filterOffsetMap(100L));
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(OffsetMapFileTest $this, int p) {
        return new TopicPartition($this.topic(), p);
    }

    public static final /* synthetic */ Tuple2 $anonfun$produceKeyedRecords$1(OffsetMapFileTest $this, Random random$1, int i) {
        return new Tuple2.mcII.sp(random$1.nextInt($this.maxNumRecords() / 10), $this.numProducedRecords() + i);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTieredAndCompacted$3(TierPartitionState tierPartitionState$1, AbstractLog log$1) {
        tierPartitionState$1.flush();
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState$1.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
        return log$1.tierableLogSegments().isEmpty() && tierPartitionState$1.compactDirtyStartOffset() > tierPartitionState$1.endOffset() && tierPartitionState$1.endOffset() == tierPartitionState$1.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTieredAndCompacted$5(AbstractLog log$1, TierPartitionState tierPartitionState$1) {
        return new StringBuilder(168).append("timeout waiting for tiered segments to be compacted.").append(" tierable segments: ").append(log$1.tierableLogSegments()).append(",").append(" local segments ").append(log$1.localLogSegments()).append(",").append(" tiered segments: ").append(CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState$1.segments()).asScala().toList()).append(",").append(" end offset: ").append(tierPartitionState$1.endOffset()).append(",").append(" committed end offset: ").append(tierPartitionState$1.committedEndOffset()).append(",").append(" dirty start offset: ").append(tierPartitionState$1.compactDirtyStartOffset()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$2(TopicPartition tp$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$1, x$2).get();
        TierPartitionState tierPartitionState = log.tierPartitionState();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 90000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!OffsetMapFileTest.$anonfun$waitUntilSegmentsTieredAndCompacted$3(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)OffsetMapFileTest.$anonfun$waitUntilSegmentsTieredAndCompacted$5(log, tierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$1(OffsetMapFileTest $this, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable)broker -> {
            OffsetMapFileTest.$anonfun$waitUntilSegmentsTieredAndCompacted$2(tp, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$filterOffsetMap$3(KafkaBroker broker$1, MockInMemoryTierObjectStore tierObjectStore$1, Throttler throttler$1, ByteBuffer readBuffer$1, CleanedTransactionMetadata transactionMetadata$1, long offsetMapSizeLimit$1, TierLogSegment seg) {
        TierObjectStoreResponse response = ((TierObjectStore)broker$1.tierObjectStoreOpt().getOrElse((Function0 & Serializable)() -> tierObjectStore$1)).getObject((TierObjectStore.ObjectStoreMetadata)seg.metadata(), TierObjectStore.FileType.SEGMENT);
        SortedMap map = DurabilityOffsetMapUtils$.MODULE$.filterKeysAndOffset(throttler$1, response.getInputStream(), readBuffer$1, transactionMetadata$1, seg.endOffset(), offsetMapSizeLimit$1);
        Predef$.MODULE$.assert(map.nonEmpty());
    }

    public static final /* synthetic */ void $anonfun$filterOffsetMap$2(TopicPartition tp$2, MockInMemoryTierObjectStore tierObjectStore$1, Throttler throttler$1, ByteBuffer readBuffer$1, long offsetMapSizeLimit$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        TierPartitionState tierPartitionState = ((AbstractLog)qual$1.getLog(tp$2, x$2).get()).tierPartitionState();
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            OffsetMapFileTest.$anonfun$filterOffsetMap$3(broker, tierObjectStore$1, throttler$1, readBuffer$1, transactionMetadata, offsetMapSizeLimit$1, seg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$filterOffsetMap$1(OffsetMapFileTest $this, MockInMemoryTierObjectStore tierObjectStore$1, Throttler throttler$1, ByteBuffer readBuffer$1, long offsetMapSizeLimit$1, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable)broker -> {
            OffsetMapFileTest.$anonfun$filterOffsetMap$2(tp, tierObjectStore$1, throttler$1, readBuffer$1, offsetMapSizeLimit$1, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyOffsetMap$3(OffsetMapFileTest $this, KafkaBroker broker$2, MockInMemoryTierObjectStore tierObjectStore$2, Throttler throttler$2, ByteBuffer readBuffer$2, CleanedTransactionMetadata transactionMetadata$2, SortedMap combinedMap$1, BooleanRef first$1, TierLogSegment seg) {
        TierObjectStoreResponse response = ((TierObjectStore)broker$2.tierObjectStoreOpt().getOrElse((Function0 & Serializable)() -> tierObjectStore$2)).getObject((TierObjectStore.ObjectStoreMetadata)seg.metadata(), TierObjectStore.FileType.SEGMENT);
        SortedMap map = DurabilityOffsetMapUtils$.MODULE$.filterKeysAndOffset(throttler$2, response.getInputStream(), readBuffer$2, transactionMetadata$2, seg.endOffset(), DurabilityOffsetMapUtils$.MODULE$.filterKeysAndOffset$default$6());
        map.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ByteBuffer k = (ByteBuffer)x0$1._1();
                OffsetInfo v = (OffsetInfo)x0$1._2();
                return combinedMap$1.put((Object)k, (Object)v);
            }
            throw new MatchError(null);
        });
        if (first$1.elem) {
            DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile((scala.collection.SortedMap)map, Paths.get(".", "mergedFile.tmp").toFile(), false);
        } else {
            DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile((scala.collection.SortedMap)map, Paths.get(".", "newFile.tmp").toFile(), false);
            DurabilityOffsetMapUtils$.MODULE$.mergeOffsetMapFile(new File(".", "mergedFile"), new File(".", "newFile.tmp"), new File(".", "mergedFile.tmp"));
            first$1.elem = false;
        }
        new File(".", "mergedFile").delete();
        new File(".", "mergedFile.tmp").renameTo(new File(".", "mergedFile"));
        $this.cleanupTempFiles();
    }

    public static final /* synthetic */ void $anonfun$verifyOffsetMap$2(OffsetMapFileTest $this, TopicPartition tp$3, MockInMemoryTierObjectStore tierObjectStore$2, Throttler throttler$2, ByteBuffer readBuffer$2, SortedMap combinedMap$1, BooleanRef first$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        TierPartitionState tierPartitionState = ((AbstractLog)qual$1.getLog(tp$3, x$2).get()).tierPartitionState();
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            OffsetMapFileTest.$anonfun$verifyOffsetMap$3($this, broker, tierObjectStore$2, throttler$2, readBuffer$2, transactionMetadata, combinedMap$1, first$1, seg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyOffsetMap$1(OffsetMapFileTest $this, MockInMemoryTierObjectStore tierObjectStore$2, Throttler throttler$2, ByteBuffer readBuffer$2, SortedMap combinedMap$1, BooleanRef first$1, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable)broker -> {
            OffsetMapFileTest.$anonfun$verifyOffsetMap$2($this, tp, tierObjectStore$2, throttler$2, readBuffer$2, combinedMap$1, first$1, broker);
            return BoxedUnit.UNIT;
        });
    }

    public OffsetMapFileTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerCompactMinEfficiencyProp(), "0.001");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        this.serverConfig().setProperty("confluent.durability.audit.enable", Boolean.toString(true));
        this.serverConfig().setProperty("confluent.durability.topic.replication.factor", "1");
        this.serverConfig().setProperty("confluent.durability.topic.partition.count", "1");
        this.serverConfig().setProperty("confluent.durability.audit.batch.flush.frequency.ms", "1500");
        this.serverConfig().setProperty("confluent.durability.events.allowed", "OffsetChangeType,EpochChangeType,IsrExpandType,DeleteRecordsType,RetentionChangeType,StartOffsetChangeType,DeletePartitionType,HealthCheckType");
        this.serverConfig().setProperty("confluent.durability.audit.idempotent.producer", Boolean.toString(false));
        this.configureMock();
        this.topic = "test_topic";
        this.partitions = 1;
        this.maxNumRecords = 5000;
        this.numProducedRecords = 0;
        this.producedRecords = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.exited = new AtomicBoolean(false);
    }
}

