/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.availability;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import integration.kafka.availability.BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.availability.AllThreadsStuck$;
import kafka.availability.AnyThreadStuck$;
import kafka.availability.BrokerHealthManager;
import kafka.availability.BrokerHealthStatus;
import kafka.availability.Healthy$;
import kafka.availability.Suspect$;
import kafka.availability.Unhealthy$;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerServer;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.HostedPartition;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.VolatileBooleanRef;

@ScalaSignature(bytes="\u0006\u0005\t\u001dd\u0001\u0002\u0014(\u00019BQA\u000e\u0001\u0005\u0002]BQA\u000f\u0001\u0005Bm2A\u0001\u0014\u0001A\u001b\"A\u0001m\u0001BI\u0002\u0013\u0005\u0011\r\u0003\u0005m\u0007\t\u0005\r\u0011\"\u0001n\u0011!\u00018A!E!B\u0013\u0011\u0007\u0002C9\u0004\u0005#\u0007I\u0011\u0001:\t\u0011Y\u001c!\u00111A\u0005\u0002]D\u0001\"_\u0002\u0003\u0012\u0003\u0006Ka\u001d\u0005\u0006m\r!\tA\u001f\u0005\t\u007f\u000e\t\t\u0011\"\u0001\u0002\u0002!I\u0011qA\u0002\u0012\u0002\u0013\u0005\u0011\u0011\u0002\u0005\n\u0003?\u0019\u0011\u0013!C\u0001\u0003CA\u0011\"!\n\u0004\u0003\u0003%\t%a\n\t\u0013\u0005U2!!A\u0005\u0002\u0005]\u0002\"CA \u0007\u0005\u0005I\u0011AA!\u0011%\tYeAA\u0001\n\u0003\ni\u0005C\u0005\u0002\\\r\t\t\u0011\"\u0001\u0002^!I\u0011qM\u0002\u0002\u0002\u0013\u0005\u0013\u0011\u000e\u0005\n\u0003[\u001a\u0011\u0011!C!\u0003_B\u0011\"!\u001d\u0004\u0003\u0003%\t%a\u001d\t\u0013\u0005U4!!A\u0005B\u0005]t!CA>\u0001\u0005\u0005\t\u0012AA?\r!a\u0005!!A\t\u0002\u0005}\u0004B\u0002\u001c\u0019\t\u0003\t)\nC\u0005\u0002ra\t\t\u0011\"\u0012\u0002t!I\u0011q\u0013\r\u0002\u0002\u0013\u0005\u0015\u0011\u0014\u0005\n\u0003?C\u0012\u0011!CA\u0003CCq!a-\u0001\t\u0003\t)\fC\u0004\u0002f\u0002!\t!a:\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9!\u0011\u0002\u0001\u0005\u0002\t-\u0001b\u0002B\u0014\u0001\u0011\u0005!1\u0002\u0005\b\u0005W\u0001A\u0011\u0001B\u0006\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005\u0017AqAa\r\u0001\t\u0003\u0011)\u0004C\u0004\u0003d\u0001!\tAa\u0003\u0003E\t\u0013xn[3s\u0011\u0016\fG\u000e\u001e5NC:\fw-\u001a:J]R,wM]1uS>tG+Z:u\u0015\tA\u0013&\u0001\u0007bm\u0006LG.\u00192jY&$\u0018P\u0003\u0002+W\u0005)1.\u00194lC*\tA&A\u0006j]R,wM]1uS>t7\u0001A\n\u0003\u0001=\u0002\"\u0001\r\u001b\u000e\u0003ER!AM\u001a\u0002\rM,'O^3s\u0015\u0005Q\u0013BA\u001b2\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u00019!\tI\u0004!D\u0001(\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0002=\u0005B\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t!QK\\5u\u0011\u0015\u0019%\u00011\u0001E\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000bA!\u001e;jY*\t\u0011*\u0001\u0003kCZ\f\u0017BA&G\u0005)\u0001&o\u001c9feRLWm\u001d\u0002#)\"\u0014X-\u00193M_\u000e\fGnQ8v]R,'o\u001d(v[N#XoY6TC6\u0004H.Z:\u0014\t\rq\u0015\u000b\u0016\t\u0003{=K!\u0001\u0015 \u0003\r\u0005s\u0017PU3g!\ti$+\u0003\u0002T}\t9\u0001K]8ek\u000e$\bCA+^\u001d\t16L\u0004\u0002X56\t\u0001L\u0003\u0002Z[\u00051AH]8pizJ\u0011aP\u0005\u00039z\nq\u0001]1dW\u0006<W-\u0003\u0002_?\na1+\u001a:jC2L'0\u00192mK*\u0011ALP\u0001\u0014i\"\u0014X-\u00193M_\u000e\fGnQ8v]R,'o]\u000b\u0002EB\u00111M[\u0007\u0002I*\u0011\u0001&\u001a\u0006\u0003U\u0019T!a\u001a5\u0002\u0013\r|gN\u001a7vK:$(\"A5\u0002\u0005%|\u0017BA6e\u0005M!\u0006N]3bI2{7-\u00197D_VtG/\u001a:t\u0003]!\bN]3bI2{7-\u00197D_VtG/\u001a:t?\u0012*\u0017\u000f\u0006\u0002=]\"9q.BA\u0001\u0002\u0004\u0011\u0017a\u0001=%c\u0005!B\u000f\u001b:fC\u0012dunY1m\u0007>,h\u000e^3sg\u0002\n\u0001B\\;n'R,8m[\u000b\u0002gB\u0011Q\b^\u0005\u0003kz\u0012A\u0001T8oO\u0006aa.^7TiV\u001c7n\u0018\u0013fcR\u0011A\b\u001f\u0005\b_\"\t\t\u00111\u0001t\u0003%qW/\\*uk\u000e\\\u0007\u0005F\u0002|{z\u0004\"\u0001`\u0002\u000e\u0003\u0001AQ\u0001\u0019\u0006A\u0002\tDQ!\u001d\u0006A\u0002M\fAaY8qsR)10a\u0001\u0002\u0006!9\u0001m\u0003I\u0001\u0002\u0004\u0011\u0007bB9\f!\u0003\u0005\ra]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYAK\u0002c\u0003\u001bY#!a\u0004\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033q\u0014AC1o]>$\u0018\r^5p]&!\u0011QDA\n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019CK\u0002t\u0003\u001b\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0015!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018\u0011\u0006!A.\u00198h\u0013\u0011\t\u0019$!\f\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u0004E\u0002>\u0003wI1!!\u0010?\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019%!\u0013\u0011\u0007u\n)%C\u0002\u0002Hy\u00121!\u00118z\u0011!y\u0007#!AA\u0002\u0005e\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\u0003CBA)\u0003/\n\u0019%\u0004\u0002\u0002T)\u0019\u0011Q\u000b \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002Z\u0005M#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0018\u0002fA\u0019Q(!\u0019\n\u0007\u0005\rdHA\u0004C_>dW-\u00198\t\u0011=\u0014\u0012\u0011!a\u0001\u0003\u0007\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011FA6\u0011!y7#!AA\u0002\u0005e\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005e\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002`\u0005e\u0004\u0002C8\u0017\u0003\u0003\u0005\r!a\u0011\u0002EQC'/Z1e\u0019>\u001c\u0017\r\\\"pk:$XM]:Ok6\u001cF/^2l'\u0006l\u0007\u000f\\3t!\ta\bdE\u0003\u0019\u0003\u0003\u000bi\tE\u0004\u0002\u0004\u0006%%m]>\u000e\u0005\u0005\u0015%bAAD}\u00059!/\u001e8uS6,\u0017\u0002BAF\u0003\u000b\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\ty)a%\u000e\u0005\u0005E%BA5I\u0013\rq\u0016\u0011\u0013\u000b\u0003\u0003{\nQ!\u00199qYf$Ra_AN\u0003;CQ\u0001Y\u000eA\u0002\tDQ!]\u000eA\u0002M\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002$\u0006=\u0006#B\u001f\u0002&\u0006%\u0016bAAT}\t1q\n\u001d;j_:\u0004R!PAVENL1!!,?\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011\u0017\u000f\u0002\u0002\u0003\u000710A\u0002yIA\n\u0001CZ5oIN#XoY6UQJ,\u0017\rZ:\u0015\u000fq\n9,!2\u0002b\"9\u0011\u0011X\u000fA\u0002\u0005m\u0016a\u00052s_.,'\u000fS3bYRDW*\u00198bO\u0016\u0014\b\u0003BA_\u0003\u0003l!!a0\u000b\u0005!\u001a\u0014\u0002BAb\u0003\u007f\u00131C\u0011:pW\u0016\u0014\b*Z1mi\"l\u0015M\\1hKJDq!a2\u001e\u0001\u0004\tI-\u0001\u0007uQJ,\u0017\rZ:TiV\u001c7\u000e\u0005\u0005\u0002L\u0006E\u0017Q[An\u001b\t\tiM\u0003\u0003\u0002P\u0006M\u0013aB7vi\u0006\u0014G.Z\u0005\u0005\u0003'\fiMA\u0002NCB\u0004B!a\u000b\u0002X&!\u0011\u0011\\A\u0017\u0005\u0019!\u0006N]3bIB)\u00111ZAow&!\u0011q\\Ag\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\u0005\u0007\u0003Gl\u0002\u0019A:\u0002!9,XnU1na2,7\u000fV8XC&$\u0018a\u00054j]\u0012tU/\u001c+ie\u0016\fGm]*uk\u000e\\G#B>\u0002j\u0006-\bbBAd=\u0001\u0007\u0011\u0011\u001a\u0005\u0007\u0003[t\u0002\u0019A:\u0002\u00159,XnU1na2,7/A\u0006nKR\u0014\u0018n\u0019,bYV,GCBA\u001d\u0003g\u0014)\u0001C\u0004\u0002v~\u0001\r!a>\u0002\u00155,GO]5d)f\u0004X\r\u0005\u0003\u0002z\n\u0005a\u0002BA~\u0003{\u0004\"a\u0016 \n\u0007\u0005}h(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\u0011\u0019AC\u0002\u0002\u0000zBqAa\u0002 \u0001\u0004\t90\u0001\u0003oC6,\u0017!\u0012;fgR\u0014%o\\6fe\"+\u0017\r\u001c;is>sWm\u0015;vG.$\u0006N]3bI\n+HOU3d_Z,'o\u001d\"fM>\u0014XM\u0011:pW\u0016\u0014H)Z3nK\u0012,f\u000e[3bYRD\u0017\u0010F\u0001=Q\r\u0001#q\u0002\t\u0005\u0005#\u0011\u0019#\u0004\u0002\u0003\u0014)!!Q\u0003B\f\u0003\r\t\u0007/\u001b\u0006\u0005\u00053\u0011Y\"A\u0004kkBLG/\u001a:\u000b\t\tu!qD\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0005C\t1a\u001c:h\u0013\u0011\u0011)Ca\u0005\u0003\tQ+7\u000f^\u0001(i\u0016\u001cHO\u0011:pW\u0016\u0014\b*Z1mi\"4uN]2f\u0007>tGO]8mY\u0016$7\u000b[;uI><h\u000eK\u0002\"\u0005\u001f\tA\u0007^3ti\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5Ti\u0006$Xo\u001d+sC:\u001c\u0018\u000e^5p]\u001a\u0013x.\\*vgB,7\r\u001e+p\u0011\u0016\fG\u000e\u001e5zQ\r\u0011#qB\u0001\"i\u0016\u001cH\u000fR=oC6L7mQ8oM&<7/\u00119qY&,G\r\u0015:pa\u0016\u0014H.\u001f\u0015\u0004G\t=\u0011a\u0006;fgR\\%/\u00194u\tft\u0017-\\5d\u0007>tg-[4t)\ra$q\u0007\u0005\b\u0005s!\u0003\u0019AA|\u0003\u0019\tXo\u001c:v[\":AE!\u0010\u0003N\t=\u0003\u0003\u0002B \u0005\u0013j!A!\u0011\u000b\t\t\r#QI\u0001\taJ|g/\u001b3fe*!!q\tB\f\u0003\u0019\u0001\u0018M]1ng&!!1\nB!\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012!\u0011K\u0011\u0003\u0005'\nQa\u001b:bMRDs\u0001\nB,\u0005\u000f\u0011y\u0006\u0005\u0003\u0003Z\tmSB\u0001B#\u0013\u0011\u0011iF!\u0012\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\t\u0002\u0003b\u0005A2\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?\u0002SQ,7\u000f\u001e\"s_.,'\u000fS3bYRDW*\u00198bO\u0016\u0014\b+Y:tK\u0012$v\u000eU1si&$\u0018n\u001c8tQ\r)#q\u0002")
public class BrokerHealthManagerIntegrationTest
extends BaseRequestTest {
    private volatile BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$ ThreadLocalCountersNumStuckSamples$module;

    public BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$ ThreadLocalCountersNumStuckSamples() {
        if (this.ThreadLocalCountersNumStuckSamples$module == null) {
            this.ThreadLocalCountersNumStuckSamples$lzycompute$1();
        }
        return this.ThreadLocalCountersNumStuckSamples$module;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
    }

    public void findStuckThreads(BrokerHealthManager brokerHealthManager, scala.collection.mutable.Map<Thread, ListBuffer<ThreadLocalCountersNumStuckSamples>> threadsStuck, long numSamplesToWait) {
        long currentSamples = brokerHealthManager.totalSamples();
        while (brokerHealthManager.totalSamples() < currentSamples + numSamplesToWait) {
            brokerHealthManager.prevThreadLocalCountersSnapshot().forEach((thread, threadLocalCountersList) -> threadLocalCountersList.forEach(threadLocalCounters -> {
                ObjectRef tlcInMap = ObjectRef.create(null);
                ListBuffer threadLocalCountersNumStuckSamplesList = (ListBuffer)threadsStuck.getOrElseUpdate(thread, (Function0 & Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$));
                threadLocalCountersNumStuckSamplesList.foreach((Function1 & Serializable)threadLocalCountersNumStuckSample -> {
                    BrokerHealthManagerIntegrationTest.$anonfun$findStuckThreads$4(threadLocalCounters, tlcInMap, threadLocalCountersNumStuckSample);
                    return BoxedUnit.UNIT;
                });
                if ((ThreadLocalCountersNumStuckSamples)tlcInMap.elem == null) {
                    tlcInMap.elem = new ThreadLocalCountersNumStuckSamples(this, (ThreadLocalCounters)threadLocalCounters, 0L);
                    threadLocalCountersNumStuckSamplesList.$plus$eq((Object)((ThreadLocalCountersNumStuckSamples)tlcInMap.elem));
                }
                if (threadLocalCounters.numInProgressOps >= 1L) {
                    ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamples = (ThreadLocalCountersNumStuckSamples)tlcInMap.elem;
                    threadLocalCountersNumStuckSamples.numStuck_$eq(threadLocalCountersNumStuckSamples.numStuck() + threadLocalCounters.numInProgressOps);
                    return;
                }
                ((ThreadLocalCountersNumStuckSamples)tlcInMap.elem).numStuck_$eq(0L);
            }));
        }
    }

    public ThreadLocalCountersNumStuckSamples findNumThreadsStuck(scala.collection.mutable.Map<Thread, ListBuffer<ThreadLocalCountersNumStuckSamples>> threadsStuck, long numSamples) {
        ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamplesReturnVal = new ThreadLocalCountersNumStuckSamples(this, null, 0L);
        threadsStuck.foreach((Function1 & Serializable)x0$1 -> {
            BrokerHealthManagerIntegrationTest.$anonfun$findNumThreadsStuck$1(numSamples, threadLocalCountersNumStuckSamplesReturnVal, x0$1);
            return BoxedUnit.UNIT;
        });
        return threadLocalCountersNumStuckSamplesReturnVal;
    }

    public int metricValue(String metricType, String name) {
        return BoxesRunTime.unboxToInt((Object)((Gauge)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManagerIntegrationTest.$anonfun$metricValue$1(name, metricType, x0$1)))).head())._2()).value());
    }

    @Test
    public void testBrokerHealthyOneStuckThreadButRecoversBeforeBrokerDeemedUnhealthy() {
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        AtomicBoolean condVar = new AtomicBoolean(false);
        KafkaServer kafkaServer = (KafkaServer)this.servers().head();
        BrokerHealthManager brokerHealthManager = kafkaServer.brokerHealthManager();
        long currentSamples = brokerHealthManager.totalSamples();
        while (brokerHealthManager.totalSamples() < currentSamples + 5L) {
            BrokerHealthStatus brokerHealthStatus = brokerHealthManager.brokerHealthStatus();
            Healthy$ healthy$ = Healthy$.MODULE$;
            Predef$.MODULE$.assert(brokerHealthStatus != null && brokerHealthStatus.equals(healthy$));
        }
        int numSamplesEngineThreadGroupsStuck = this.metricValue("BrokerHealthManager", "ContiguousSamplesEngineThreadGroupsStuck");
        int numUnhealthySamples = this.metricValue("BrokerHealthManager", "ContiguousUnhealthySamples");
        int numSamplesNoStorageThreadsMakingProgress = this.metricValue("BrokerHealthManager", "ContiguousSamplesNoStorageThreadMakingProgress");
        Predef$.MODULE$.assert(numSamplesEngineThreadGroupsStuck >= 0);
        Predef$.MODULE$.assert(numUnhealthySamples >= 0);
        Predef$.MODULE$.assert(numSamplesNoStorageThreadsMakingProgress >= 0);
        kafkaServer.kafkaScheduler().scheduleOnce("broker-health-test", () -> BrokerHealthManagerIntegrationTest.stuckThreadRunnable$1(lock, condVar, condition));
        scala.collection.mutable.Map threadsStuck = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        brokerHealthManager.totalSamples();
        this.findStuckThreads(brokerHealthManager, (scala.collection.mutable.Map<Thread, ListBuffer<ThreadLocalCountersNumStuckSamples>>)threadsStuck, 5L);
        int numSamplesStorageThreadGroupsStuck = this.metricValue("BrokerHealthManager", "ContiguousSamplesStorageThreadGroupsStuck");
        ThreadLocalCountersNumStuckSamples threadCountersNumStuckCounters = this.findNumThreadsStuck((scala.collection.mutable.Map<Thread, ListBuffer<ThreadLocalCountersNumStuckSamples>>)threadsStuck, 5L);
        ThreadLocalCounters counters = threadCountersNumStuckCounters.threadLocalCounters();
        long totalThreadCountersStuck = threadCountersNumStuckCounters.numStuck();
        lock.lock();
        condVar.set(true);
        condition.signal();
        lock.unlock();
        Predef$.MODULE$.assert(totalThreadCountersStuck >= 1L);
        Predef$.MODULE$.assert(counters != null);
        ThreadLocalCounters.ThreadGroupType threadGroupType = counters.threadGroupType;
        ThreadLocalCounters.ThreadGroupType threadGroupType2 = ThreadLocalCounters.ThreadGroupType.BACKGROUND_THREAD;
        Predef$.MODULE$.assert(!(threadGroupType != null ? !threadGroupType.equals(threadGroupType2) : threadGroupType2 != null));
        Predef$.MODULE$.assert(numSamplesStorageThreadGroupsStuck > 1, (Function0 & Serializable)() -> new StringBuilder(45).append("Num of samples storage thread groups stuck = ").append(numSamplesStorageThreadGroupsStuck).toString());
        BrokerHealthStatus brokerHealthStatus = brokerHealthManager.brokerHealthStatus();
        Healthy$ healthy$ = Healthy$.MODULE$;
        Predef$.MODULE$.assert(brokerHealthStatus != null && brokerHealthStatus.equals(healthy$));
        int brokerHealthStatusMetric = this.metricValue("BrokerHealthManager", "StorageHealthStatus");
        Predef$.MODULE$.assert(brokerHealthStatusMetric == 1);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerHealthForceControlledShutdown() {
        VolatileBooleanRef hasCalledExit = VolatileBooleanRef.create((boolean)false);
        Function2 & Serializable setHaltProcedure_haltProcedure = (Function2 & Serializable)(x$1, x$2) -> BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$1(hasCalledExit, BoxesRunTime.unboxToInt((Object)x$1), x$2);
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var9_2 = null;
        KafkaServer kafkaServer = ((KafkaServer)this.servers().head()).kafkaController().isActive() ? (KafkaServer)((IterableOps)this.servers().tail()).head() : (KafkaServer)this.servers().head();
        BrokerHealthManager brokerHealthManager = kafkaServer.brokerHealthManager();
        long currentSamples = brokerHealthManager.totalSamples();
        while (brokerHealthManager.totalSamples() < currentSamples + (long)brokerHealthManager.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect()) {
            BrokerHealthStatus brokerHealthStatus = brokerHealthManager.brokerHealthStatus();
            Healthy$ healthy$ = Healthy$.MODULE$;
            Predef$.MODULE$.assert(brokerHealthStatus != null && brokerHealthStatus.equals(healthy$));
        }
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerSuspectProp(), "1");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerUnhealthyProp(), "1");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransitionProp(), "0");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransitionProp(), "0");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$3(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$5(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$7(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$9(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        try {
            long l5 = 100L;
            long waitUntilTrue_waitTimeMs5 = 15000L;
            long waitUntilTrue_startTime5 = System.currentTimeMillis();
            while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$11(kafkaServer)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                    Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$12());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
            }
            long l6 = 100L;
            long waitUntilTrue_waitTimeMs6 = 15000L;
            long waitUntilTrue_startTime6 = System.currentTimeMillis();
            while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$13(kafkaServer)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                    Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$14());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
            }
            long l7 = 100L;
            long waitUntilTrue_waitTimeMs7 = 15000L;
            long waitUntilTrue_startTime7 = System.currentTimeMillis();
            while (!hasCalledExit.elem) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs7) {
                    Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$16());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs7), (long)waitUntilTrue_pause));
            }
        }
        finally {
            Exit.resetHaltProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerHealthStatusTransitionFromSuspectToHealthy() {
        KafkaServer kafkaServer = (KafkaServer)this.servers().head();
        BrokerHealthManager brokerHealthManager = kafkaServer.brokerHealthManager();
        long currentSamples = brokerHealthManager.totalSamples();
        while (brokerHealthManager.totalSamples() < currentSamples + (long)brokerHealthManager.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect()) {
            BrokerHealthStatus brokerHealthStatus = brokerHealthManager.brokerHealthStatus();
            Healthy$ healthy$ = Healthy$.MODULE$;
            Predef$.MODULE$.assert(brokerHealthStatus != null && brokerHealthStatus.equals(healthy$));
        }
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerSuspectProp(), "1");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransitionProp(), "0");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerUnhealthyProp(), "50");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$2(this, kafkaServer)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$4(kafkaServer)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicConfigsAppliedProperly() {
        KafkaServer kafkaServer = ((KafkaServer)this.servers().head()).kafkaController().isActive() ? (KafkaServer)((IterableOps)this.servers().tail()).head() : (KafkaServer)this.servers().head();
        BrokerHealthManager brokerHealthManager = kafkaServer.brokerHealthManager();
        Properties props = new Properties();
        Assertions.assertTrue((brokerHealthManager.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy() == 180 ? 1 : 0) != 0, (String)"Default number of unhealthy samples should be 180");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerUnhealthyProp(), "1000");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$2(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((brokerHealthManager.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect() == 30 ? 1 : 0) != 0, (String)"Default number of suspect samples should be 30");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerSuspectProp(), "250");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$5(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((brokerHealthManager.config().brokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransition() == 90 ? 1 : 0) != 0, (String)"Default number of suspect samples percentage should be 90");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransitionProp(), "99");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$8(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((brokerHealthManager.config().brokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransition() == 70 ? 1 : 0) != 0, (String)"Default number of unhealthy samples percentage should be 70");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransitionProp(), "99");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$11(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerStorageRequestHandlerThreadsStuckCriteriaProp(), "AllThreadsStuck");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs5 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$14(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$15());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$16(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$17());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs7 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime7 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$18(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs7) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$19(brokerHealthManager));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs7), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerStorageRequestHandlerThreadsStuckCriteriaProp(), "Disabled");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime8 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$21(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime8 + waitUntilTrue_waitTimeMs8) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$22());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs8), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs9 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime9 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$23(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime9 + waitUntilTrue_waitTimeMs9) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$24());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs9), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerStorageRequestHandlerThreadsStuckCriteriaProp(), "AnyThreadStuck");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime10 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$26(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime10 + waitUntilTrue_waitTimeMs10) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$27());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs10), (long)waitUntilTrue_pause));
        }
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs11 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime11 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$28(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime11 + waitUntilTrue_waitTimeMs11) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$29());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs11), (long)waitUntilTrue_pause));
        }
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime12 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$30(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime12 + waitUntilTrue_waitTimeMs12) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$31(brokerHealthManager));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs12), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerSampleDurationMsProp(), "2000");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l13 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs13 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime13 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$33(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime13 + waitUntilTrue_waitTimeMs13) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$34());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs13), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)brokerHealthManager.config().isBrokerHealthManagerMitigationEnabled(), (String)"Mitigation must be on");
        Assertions.assertTrue((boolean)brokerHealthManager.isMitigationEnabled(), (String)"Mitigation must be on");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerMitigationEnabledProp(), "false");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l14 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs14 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime14 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$36(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime14 + waitUntilTrue_waitTimeMs14) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$37());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs14), (long)waitUntilTrue_pause));
        }
        long l15 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs15 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime15 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$38(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime15 + waitUntilTrue_waitTimeMs15) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$39());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs15), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerStorageRequestHandlerThreadsStuckCriteriaProp(), "");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l16 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs16 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime16 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$41(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime16 + waitUntilTrue_waitTimeMs16) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$42());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs16), (long)waitUntilTrue_pause));
        }
        long l17 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs17 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime17 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$43(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime17 + waitUntilTrue_waitTimeMs17) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$44());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs17), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testKraftDynamicConfigs(String quorum) {
        BrokerServer brokerServer = (BrokerServer)this.brokers().head();
        BrokerHealthManager brokerHealthManager = brokerServer.brokerHealthManager();
        Assertions.assertTrue((boolean)brokerHealthManager.config().isBrokerHealthManagerMitigationEnabled(), (String)"Mitigation must be on");
        Assertions.assertTrue((boolean)brokerHealthManager.isMitigationEnabled(), (String)"Mitigation must be on");
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerMitigationEnabledProp(), "false");
        brokerServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testKraftDynamicConfigs$2(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testKraftDynamicConfigs$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testKraftDynamicConfigs$4(brokerHealthManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testKraftDynamicConfigs$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testBrokerHealthManagerPassedToPartitions() {
        String topic = "topic1";
        int partition = 0;
        int leader = BoxesRunTime.unboxToInt((Object)this.createTopicWithAssignment("topic1", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))), this.createTopicWithAssignment$default$3()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        KafkaServer kafkaServer = (KafkaServer)this.serverForId(leader).get();
        Assertions.assertNotNull((Object)kafkaServer.brokerHealthManager());
        Assertions.assertTrue((boolean)kafkaServer.replicaManager().brokerHealthManager().nonEmpty());
        TopicPartition tp = new TopicPartition(topic, partition);
        HostedPartition hostedPartition = kafkaServer.replicaManager().getPartition(tp);
        Assertions.assertTrue((boolean)(hostedPartition instanceof HostedPartition.Online ? ((HostedPartition.Online)hostedPartition).partition().brokerHealthManagerOpt().nonEmpty() : false));
    }

    private final void ThreadLocalCountersNumStuckSamples$lzycompute$1() {
        synchronized (this) {
            if (this.ThreadLocalCountersNumStuckSamples$module == null) {
                this.ThreadLocalCountersNumStuckSamples$module = new BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$findStuckThreads$4(ThreadLocalCounters threadLocalCounters$1, ObjectRef tlcInMap$1, ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSample) {
        block7: {
            block6: {
                ThreadLocalCounters.MetricComponentType metricComponentType;
                ThreadLocalCounters.MetricComponentType metricComponentType2;
                block5: {
                    metricComponentType2 = threadLocalCountersNumStuckSample.threadLocalCounters().metricComponentType;
                    metricComponentType = threadLocalCounters$1.metricComponentType;
                    if (metricComponentType2 != null) break block5;
                    if (metricComponentType != null) {
                        return;
                    }
                    break block6;
                }
                if (!metricComponentType2.equals(metricComponentType)) break block7;
            }
            tlcInMap$1.elem = threadLocalCountersNumStuckSample;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$findNumThreadsStuck$2(long numSamples$1, ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamplesReturnVal$1, ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamples) {
        if (threadLocalCountersNumStuckSamples.numStuck() >= numSamples$1) {
            threadLocalCountersNumStuckSamplesReturnVal$1.threadLocalCounters_$eq(threadLocalCountersNumStuckSamples.threadLocalCounters());
            threadLocalCountersNumStuckSamplesReturnVal$1.numStuck_$eq(threadLocalCountersNumStuckSamplesReturnVal$1.numStuck() + 1L);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$findNumThreadsStuck$1(long numSamples$1, ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamplesReturnVal$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ((ListBuffer)x0$1._2()).foreach((Function1 & Serializable)threadLocalCountersNumStuckSamples -> {
                BrokerHealthManagerIntegrationTest.$anonfun$findNumThreadsStuck$2(numSamples$1, threadLocalCountersNumStuckSamplesReturnVal$1, threadLocalCountersNumStuckSamples);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$metricValue$1(String name$1, String metricType$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.getName();
            if (!(string != null ? !string.equals(name$1) : name$1 != null)) {
                String string2 = metricName.getType();
                if (!(string2 != null ? !string2.equals(metricType$1) : metricType$1 != null)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testBrokerHealthyOneStuckThreadButRecoversBeforeBrokerDeemedUnhealthy$1(ReentrantLock lock$1, AtomicBoolean condVar$1, Condition condition$1) {
        lock$1.lock();
        while (!condVar$1.get()) {
            condition$1.await();
        }
        lock$1.unlock();
    }

    private static final void stuckThreadRunnable$1(ReentrantLock lock$1, AtomicBoolean condVar$1, Condition condition$1) {
        ThreadCountersManager.wrapIO(() -> {
            BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthyOneStuckThreadButRecoversBeforeBrokerDeemedUnhealthy$1(lock$1, condVar$1, condition$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Nothing$ $anonfun$testBrokerHealthForceControlledShutdown$1(VolatileBooleanRef hasCalledExit$1, int x$1, Option x$2) {
        hasCalledExit$1.elem = true;
        throw new Exception();
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$3(BrokerHealthManager brokerHealthManager$1) {
        return brokerHealthManager$1.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect() == 1;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$4() {
        return "Num Samples is not 1";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$5(BrokerHealthManager brokerHealthManager$1) {
        return brokerHealthManager$1.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy() == 1;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$6() {
        return "Num Samples is not 1";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$7(BrokerHealthManager brokerHealthManager$1) {
        return brokerHealthManager$1.config().brokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransition() == 0;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$8() {
        return "Num Samples is not 0";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$9(BrokerHealthManager brokerHealthManager$1) {
        return brokerHealthManager$1.config().brokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransition() == 0;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$10() {
        return "Num Samples is not 0";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$11(KafkaServer kafkaServer$1) {
        BrokerHealthStatus brokerHealthStatus = kafkaServer$1.brokerHealthManager().brokerHealthStatus();
        Unhealthy$ unhealthy$ = Unhealthy$.MODULE$;
        return brokerHealthStatus != null && brokerHealthStatus.equals(unhealthy$);
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$12() {
        return "Broker is still Healthy";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$13(KafkaServer kafkaServer$1) {
        BrokerState brokerState = kafkaServer$1.brokerState();
        BrokerState brokerState2 = BrokerState.SHUTTING_DOWN;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$14() {
        return "Broker is not undergoing controlled shutdown";
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$16() {
        return "Exit wasn't triggered";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$2(BrokerHealthManagerIntegrationTest $this, KafkaServer kafkaServer$2) {
        BrokerHealthStatus brokerHealthStatus = kafkaServer$2.brokerHealthManager().brokerHealthStatus();
        Suspect$ suspect$ = Suspect$.MODULE$;
        return brokerHealthStatus != null && brokerHealthStatus.equals(suspect$) && $this.metricValue("BrokerHealthManager", "StorageHealthStatus") == 0;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$3() {
        return "Broker is still Healthy";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$4(KafkaServer kafkaServer$2) {
        BrokerHealthStatus brokerHealthStatus = kafkaServer$2.brokerHealthManager().brokerHealthStatus();
        Healthy$ healthy$ = Healthy$.MODULE$;
        return brokerHealthStatus != null && brokerHealthStatus.equals(healthy$);
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$5() {
        return "Broker is still Suspect";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$2(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy() == 1000;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$3() {
        return "Num Samples is not 1000";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$5(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect() == 250;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$6() {
        return "Num Samples is not 250";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$8(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransition() == 99;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$9() {
        return "Num % Samples is not 99";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$11(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransition() == 99;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$12() {
        return "Num % Samples is not 99";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$14(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$15() {
        return "Thread status criteria size is not 3";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$16(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().contains((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$17() {
        return "Request handler thread isn't present";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$18(BrokerHealthManager brokerHealthManager$2) {
        Object object = brokerHealthManager$2.config().storageThreadStatusCriteria().apply((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
        AllThreadsStuck$ allThreadsStuck$ = AllThreadsStuck$.MODULE$;
        return object != null && object.equals(allThreadsStuck$);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$19(BrokerHealthManager brokerHealthManager$2) {
        return new StringBuilder(39).append("Request Handler thread status criteria ").append(brokerHealthManager$2.config().storageThreadStatusCriteria().apply((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$21(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$22() {
        return "Thread status criteria size is not 2";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$23(BrokerHealthManager brokerHealthManager$2) {
        return !brokerHealthManager$2.config().storageThreadStatusCriteria().contains((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$24() {
        return "Request handler thread is still present";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$26(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$27() {
        return "Thread status criteria size is not 3";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$28(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().contains((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$29() {
        return "Request handler thread isn't present";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$30(BrokerHealthManager brokerHealthManager$2) {
        Object object = brokerHealthManager$2.config().storageThreadStatusCriteria().apply((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
        AnyThreadStuck$ anyThreadStuck$ = AnyThreadStuck$.MODULE$;
        return object != null && object.equals(anyThreadStuck$);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$31(BrokerHealthManager brokerHealthManager$2) {
        return new StringBuilder(39).append("Request Handler thread status criteria ").append(brokerHealthManager$2.config().storageThreadStatusCriteria().apply((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$33(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerSampleDurationMs() == 2000;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$34() {
        return "SampleDurationMs is not 2000";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$36(BrokerHealthManager brokerHealthManager$2) {
        return !brokerHealthManager$2.config().isBrokerHealthManagerMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$37() {
        return "Mitigation must be off";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$38(BrokerHealthManager brokerHealthManager$2) {
        return !brokerHealthManager$2.isMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$39() {
        return "Mitigation must be off";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$41(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$42() {
        return "Thread status criteria size is not 3";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$43(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().contains((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$44() {
        return "Request handler thread isn't present";
    }

    public static final /* synthetic */ boolean $anonfun$testKraftDynamicConfigs$2(BrokerHealthManager brokerHealthManager$3) {
        return !brokerHealthManager$3.config().isBrokerHealthManagerMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testKraftDynamicConfigs$3() {
        return "Mitigation must be off";
    }

    public static final /* synthetic */ boolean $anonfun$testKraftDynamicConfigs$4(BrokerHealthManager brokerHealthManager$3) {
        return !brokerHealthManager$3.isMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testKraftDynamicConfigs$5() {
        return "Mitigation must be off";
    }

    public BrokerHealthManagerIntegrationTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerEnabledProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerSampleDurationMsProp(), "100");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerMitigationEnabledProp(), "true");
    }

    public class ThreadLocalCountersNumStuckSamples
    implements Product,
    Serializable {
        private ThreadLocalCounters threadLocalCounters;
        private long numStuck;
        public final /* synthetic */ BrokerHealthManagerIntegrationTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ThreadLocalCounters threadLocalCounters() {
            return this.threadLocalCounters;
        }

        public void threadLocalCounters_$eq(ThreadLocalCounters x$1) {
            this.threadLocalCounters = x$1;
        }

        public long numStuck() {
            return this.numStuck;
        }

        public void numStuck_$eq(long x$1) {
            this.numStuck = x$1;
        }

        public ThreadLocalCountersNumStuckSamples copy(ThreadLocalCounters threadLocalCounters, long numStuck) {
            return new ThreadLocalCountersNumStuckSamples(this.integration$kafka$availability$BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$$$outer(), threadLocalCounters, numStuck);
        }

        public ThreadLocalCounters copy$default$1() {
            return this.threadLocalCounters();
        }

        public long copy$default$2() {
            return this.numStuck();
        }

        public String productPrefix() {
            return "ThreadLocalCountersNumStuckSamples";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.threadLocalCounters();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.numStuck());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ThreadLocalCountersNumStuckSamples;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "threadLocalCounters";
                }
                case 1: {
                    return "numStuck";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.threadLocalCounters())), (int)Statics.longHash((long)this.numStuck())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof ThreadLocalCountersNumStuckSamples && ((ThreadLocalCountersNumStuckSamples)x$1).integration$kafka$availability$BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$$$outer() == this.integration$kafka$availability$BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$$$outer())) break block3;
                    ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamples = (ThreadLocalCountersNumStuckSamples)x$1;
                    if (this.numStuck() != threadLocalCountersNumStuckSamples.numStuck()) break block3;
                    ThreadLocalCounters threadLocalCounters = this.threadLocalCounters();
                    ThreadLocalCounters threadLocalCounters2 = threadLocalCountersNumStuckSamples.threadLocalCounters();
                    if ((threadLocalCounters != null ? !threadLocalCounters.equals(threadLocalCounters2) : threadLocalCounters2 != null) || !threadLocalCountersNumStuckSamples.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ BrokerHealthManagerIntegrationTest integration$kafka$availability$BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$$$outer() {
            return this.$outer;
        }

        public ThreadLocalCountersNumStuckSamples(BrokerHealthManagerIntegrationTest $outer, ThreadLocalCounters threadLocalCounters, long numStuck) {
            this.threadLocalCounters = threadLocalCounters;
            this.numStuck = numStuck;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

