/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.EOFException;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class CoreUtils$ {
    public static final CoreUtils$ MODULE$ = new CoreUtils$();
    private static final Logger logger = Logger$.MODULE$.apply(MODULE$.getClass());

    private Logger logger() {
        return logger;
    }

    public <A, B> A min(Iterable<A> iterable, A ifEmpty, Ordering<B> cmp) {
        if (iterable.isEmpty()) {
            return ifEmpty;
        }
        return (A)iterable.min(cmp);
    }

    public void swallow(Function0<BoxedUnit> action, Logging logging, Level logLevel) {
        try {
            action.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            if (Level.ERROR.equals(logLevel)) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(e.getMessage(), e);
                    return;
                }
            } else if (Level.WARN.equals(logLevel)) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(e.getMessage(), e);
                    return;
                }
            } else if (Level.INFO.equals(logLevel)) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(e.getMessage(), e);
                    return;
                }
            } else if (Level.DEBUG.equals(logLevel)) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(e.getMessage(), e);
                    return;
                }
            } else if (Level.TRACE.equals(logLevel)) {
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(e.getMessage(), e);
                    return;
                }
            } else {
                throw new MatchError((Object)logLevel);
            }
            return;
        }
    }

    public Level swallow$default$3() {
        return Level.WARN;
    }

    public void delete(Seq<String> files) {
        files.foreach((Function1 & Serializable)f -> {
            CoreUtils$.$anonfun$delete$1(f);
            return BoxedUnit.UNIT;
        });
    }

    public void tryAll(Seq<Function0<BoxedUnit>> all) {
        ObjectRef exception = ObjectRef.create(null);
        all.foreach((Function1 & Serializable)element -> {
            CoreUtils$.$anonfun$tryAll$1(exception, element);
            return BoxedUnit.UNIT;
        });
        if ((Throwable)exception.elem != null) {
            throw (Throwable)exception.elem;
        }
    }

    public boolean registerMBean(Object mbean, String name) {
        boolean bl;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mbs) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : mbs
                bl = bl2;
            }
        }
        catch (Exception e) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(25).append("Failed to register Mbean ").append(name).toString(), (Throwable)e);
            }
            bl = false;
        }
        return bl;
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mbs) {
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
            }
            return;
        }
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n = channel.read(buffer);
        switch (n) {
            case -1: {
                throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
            }
        }
        return n;
    }

    public Map<String, String> parseCsvMap(String str) {
        HashMap map = new HashMap();
        if ("".equals(str)) {
            return map;
        }
        Object[] keyVals = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])str.split("\\s*,\\s*")), (Function1 & Serializable)s -> {
            int lio = s.lastIndexOf(":");
            return new Tuple2((Object)s.substring(0, lio).trim(), (Object)s.substring(lio + 1).trim());
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return Predef$.MODULE$.wrapRefArray(keyVals).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Seq<String> parseCsvList(String csvList) {
        if (csvList == null || csvList.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])csvList.split("\\s*,\\s*")), (Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$parseCsvList$1(v))));
    }

    public <T> T createObject(String className, scala.collection.immutable.Seq<Object> args) {
        return (T)Class.forName(className, true, Utils.getContextOrKafkaClassLoader()).getConstructor((Class[])((IterableOnceOps)args.map((Function1 & Serializable)x$1 -> x$1.getClass())).toArray(ClassTag$.MODULE$.apply(Class.class))).newInstance((Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public <T> Iterator<T> circularIterator(Iterable<T> coll) {
        return Iterator$.MODULE$.continually((Function0)(JFunction0.mcI.sp & Serializable)() -> 1).flatMap((Function1 & Serializable)x$2 -> CoreUtils$.$anonfun$circularIterator$2(coll, BoxesRunTime.unboxToInt((Object)x$2)));
    }

    public String replaceSuffix(String s, String oldSuffix, String newSuffix) {
        if (!s.endsWith(oldSuffix)) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Expected string to end with '%s' but string is '%s'"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, s})));
        }
        return new StringBuilder(0).append(s.substring(0, s.length() - oldSuffix.length())).append(newSuffix).toString();
    }

    public int readInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public <T> T inLock(Lock lock, Function0<T> fun) {
        Object object;
        lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    public <T> T inReadLock(ReadWriteLock lock, Function0<T> fun) {
        Object object;
        Lock inLock_lock = lock.readLock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public <T> T inWriteLock(ReadWriteLock lock, Function0<T> fun) {
        Object object;
        Lock inLock_lock = lock.writeLock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public <T> Iterable<T> duplicates(Iterable<T> s) {
        return ((MapOps)s.groupBy((Function1 & Serializable)x -> Predef$.MODULE$.identity(x)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Object k = x0$1._1();
            Iterable l = (Iterable)x0$1._2();
            Tuple2 tuple2 = new Tuple2(k, (Object)BoxesRunTime.boxToInteger((int)l.size()));
            return tuple2;
        }).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$duplicates$3(x0$2)))).keys();
    }

    public Seq<EndPoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        return this.listenerListToEndPoints(listeners, securityProtocolMap, true);
    }

    public Seq<EndPoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap, boolean requireDistinctPorts) {
        Seq seq;
        try {
            seq = (Seq)this.parseCsvList(listeners).map((Function1 & Serializable)x$6 -> EndPoint$.MODULE$.createEndPoint((String)x$6, (Option<Map<ListenerName, SecurityProtocol>>)new Some((Object)securityProtocolMap)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Error creating broker listeners from '").append(listeners).append("': ").append(e.getMessage()).toString(), e);
        }
        Seq endPoints = seq;
        CoreUtils$.validate$1(endPoints, listeners, requireDistinctPorts);
        return endPoints;
    }

    public String generateUuidAsBase64() {
        UUID uuid = UUID.randomUUID();
        return this.uuidToBase64(uuid);
    }

    public String uuidToBase64(UUID uuid) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.getBytesFromUuid(uuid));
    }

    public UUID uuidFromBase64(String str) {
        ByteBuffer bb = ByteBuffer.wrap(Base64.getUrlDecoder().decode(str));
        return new UUID(bb.getLong(), bb.getLong());
    }

    public byte[] getBytesFromUuid(UUID uuid) {
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        return uuidBytes.array();
    }

    public Uuid toKafkaUUID(UUID uuid) {
        return new Uuid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public UUID toJavaUUID(Uuid uuid) {
        return new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public Uuid toKafkaUuidFromJavaUUIDString(String id) {
        return this.toKafkaUUID(UUID.fromString(id));
    }

    public byte[] md5hash(ByteBuffer buf) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(buf.duplicate());
        return md5.digest();
    }

    public String toBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public Properties propsWith(String key, String value) {
        return this.propsWith((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, (Object)value)}));
    }

    /*
     * WARNING - void declaration
     */
    public Properties propsWith(scala.collection.immutable.Seq<Tuple2<String, String>> props) {
        void var2_2;
        Properties properties = new Properties();
        props.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = properties.put(k, v);
            return object;
        });
        return var2_2;
    }

    public <K, V> V atomicGetOrUpdate(scala.collection.concurrent.Map<K, V> map, K key, Function0<V> createValue) {
        Object object;
        Option option = map.get(key);
        if (option instanceof Some) {
            object = ((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            Object value = createValue.apply();
            object = map.putIfAbsent(key, value).getOrElse((Function0 & Serializable)() -> value);
        } else {
            throw new MatchError((Object)option);
        }
        return (V)object;
    }

    public <T, K, B> Map<K, B> groupMapReduce(Iterable<T> elements, Function1<T, K> key, Function1<T, B> f, Function2<B, B, B> reduce) {
        return elements.groupMapReduce(key, f, reduce);
    }

    public static final /* synthetic */ void $anonfun$delete$1(String f) {
        Utils.delete((File)new File(f));
    }

    public static final /* synthetic */ void $anonfun$tryAll$1(ObjectRef exception$1, Function0 element) {
        try {
            element.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            if ((Throwable)exception$1.elem != null) {
                ((Throwable)exception$1.elem).addSuppressed(e);
                return;
            }
            exception$1.elem = e;
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseCsvList$1(String v) {
        return !v.equals("");
    }

    public static final /* synthetic */ Iterable $anonfun$circularIterator$2(Iterable coll$1, int x$2) {
        return (Iterable)coll$1.map((Function1 & Serializable)t -> t);
    }

    public static final /* synthetic */ boolean $anonfun$duplicates$3(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = x0$2._2$mcI$sp() > 1;
        return bl;
    }

    private static final void validate$1(Seq endPoints, String listeners$1, boolean requireDistinctPorts$1) {
        Seq portsExcludingZero = (Seq)((IterableOps)endPoints.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.port()))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 != 0);
        Seq distinctListenerNames = (Seq)((SeqOps)endPoints.map((Function1 & Serializable)x$5 -> x$5.listenerName())).distinct();
        Predef$.MODULE$.require(distinctListenerNames.size() == endPoints.size(), (Function0 & Serializable)() -> new StringBuilder(53).append("Each listener must have a different name, listeners: ").append(listeners$1).toString());
        if (requireDistinctPorts$1) {
            Seq distinctPorts = (Seq)portsExcludingZero.distinct();
            Predef$.MODULE$.require(distinctPorts.size() == portsExcludingZero.size(), (Function0 & Serializable)() -> new StringBuilder(53).append("Each listener must have a different port, listeners: ").append(listeners$1).toString());
        }
    }

    private CoreUtils$() {
    }
}

