/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionUnfreezeLogStartOffset;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.common.RestoreInfo;
import kafka.tier.topic.TierTopic;
import kafka.utils.checksum.CheckedFileIO;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;

public class TierPartitionUnfreezeLogStartOffsetTrigger {
    public static final String UNFREEZE_LOG_START_OFFSET_INPUT = "restore.json";
    public static final String UNFREEZE_LOG_START_OFFSET_INPUT_DOC = "Json input file generated by kafka.tier.tools.TierPartitionStateRestoreTrigger tool. This file contains information about the TierPartitionForceRestore event injected by the TierPartitionStateRestoreTrigger tool and tier partition states' comparison data created earlier by the kafka.tier.tools.TierMetadataComparator tool.";
    public static final String UNFREEZE_LOG_START_OFFSET_OUTPUT = "output.json";
    public static final String UNFREEZE_LOG_START_OFFSET_OUTPUT_DOC = "Path to the output file where information about the TierPartitionUnfreezeLogStartOffset event will be saved.";

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)TierPartitionUnfreezeLogStartOffsetTrigger.class.getName()).defaultHelp(true).description("Provides a command to unfreeze the merged log start offset using a TierPartitionUnfreezeLogStartOffset event.");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("tier.config")}).dest("tier.config").type(String.class).required(true).help("The path to a configuration file containing the required properties");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(UNFREEZE_LOG_START_OFFSET_INPUT)}).dest(UNFREEZE_LOG_START_OFFSET_INPUT).type(String.class).required(true).help(UNFREEZE_LOG_START_OFFSET_INPUT_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(UNFREEZE_LOG_START_OFFSET_OUTPUT)}).dest(UNFREEZE_LOG_START_OFFSET_OUTPUT).type(String.class).required(true).help(UNFREEZE_LOG_START_OFFSET_OUTPUT_DOC);
        return parser;
    }

    private static List<RestoreInfo.RestoreRawOutput> getUnfreezeLogStartOffsetTriggerInput(Path inputJsonFile) {
        if (Files.notExists(inputJsonFile, new LinkOption[0]) || !Files.isRegularFile(inputJsonFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Trigger tool's input file does not exist: " + inputJsonFile);
        }
        try {
            return RestoreInfo.RestoreRawOutput.readJsonFromFile(inputJsonFile);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Couldn't parse provided input JSON", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Incorrect JSON file provided: " + inputJsonFile, e);
        }
    }

    private static TierPartitionUnfreezeLogStartOffset injectState(String tierTopicName, int numTierTopicPartitions, Producer<byte[], byte[]> producer, File file) throws Exception {
        TopicPartition topicPartition = Log.parseTopicPartitionName(file.getParentFile());
        try (CheckedFileIO fileChannel = CheckedFileIO.open(file.toPath(), StandardOpenOption.READ);){
            System.out.printf("Attempting recovery for %s @ %s%n", topicPartition, file);
            Optional<Header> headerOpt = FileTierPartitionState.readHeader(fileChannel);
            if (!headerOpt.isPresent()) {
                throw new Exception("Header is not present for the TierPartitionState supplied");
            }
            Header header = headerOpt.get();
            if (header.status() != TierPartitionStatus.FROZEN_LOG_START_OFFSET) {
                throw new Exception(String.format("Header is not in the expected status: %s Header: %s", new Object[]{TierPartitionStatus.FROZEN_LOG_START_OFFSET, header.toString()}));
            }
            UUID messageUUID = UUID.randomUUID();
            TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), header.topicId(), topicPartition.partition());
            TierPartitionUnfreezeLogStartOffset unfreezeEvent = new TierPartitionUnfreezeLogStartOffset(topicIdPartition, messageUUID);
            RecordMetadata metadata = RecoveryUtils.injectTierTopicEvent(producer, unfreezeEvent, tierTopicName, numTierTopicPartitions);
            System.out.printf("Emitted tier topic recovery event: %s for %s%n", metadata, header);
            TierPartitionUnfreezeLogStartOffset tierPartitionUnfreezeLogStartOffset = unfreezeEvent;
            return tierPartitionUnfreezeLogStartOffset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void injectStateFromRawInput(Properties props, String tierTopicName, File outputFile, List<RestoreInfo.RestoreRawOutput> inputs) throws Exception {
        Producer<byte[], byte[]> producer = null;
        FileOutputStream fos = null;
        try {
            producer = RecoveryUtils.createTierTopicProducer(props, TierPartitionUnfreezeLogStartOffsetTrigger.class.getSimpleName());
            int numTierTopicPartitions = RecoveryUtils.getNumPartitions(producer, tierTopicName);
            ArrayList<RestoreInfo.UnfreezeTriggerOutput> outputs = new ArrayList<RestoreInfo.UnfreezeTriggerOutput>();
            for (RestoreInfo.RestoreRawOutput input : inputs) {
                File file = input.input().path().toFile();
                TierPartitionUnfreezeLogStartOffset event = TierPartitionUnfreezeLogStartOffsetTrigger.injectState(tierTopicName, numTierTopicPartitions, producer, file);
                RestoreInfo.UnfreezeTriggerOutput output = new RestoreInfo.UnfreezeTriggerOutput(input, event.toString());
                outputs.add(output);
            }
            fos = new FileOutputStream(outputFile);
            RestoreInfo.UnfreezeTriggerOutput.writeJsonToFile(outputs, fos);
        }
        finally {
            if (producer != null) {
                producer.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    private static void run(ArgumentParser parser, Namespace args) throws Exception {
        Properties props;
        String propertiesConfFile = args.getString("tier.config").trim();
        try {
            ArrayList allProps = new ArrayList(ProducerConfig.configNames());
            props = Utils.loadProps((String)propertiesConfFile, allProps);
        }
        catch (IOException e) {
            throw new ArgumentParserException(String.format("Can not load properties from file: '%s'", propertiesConfFile), (Throwable)e, parser);
        }
        String bootstrapServers = props.getProperty("bootstrap.servers", "").trim();
        if (bootstrapServers.isEmpty()) {
            throw new ArgumentParserException(String.format("The provided properties conf file: '%s' can not contain empty or absent bootstrap servers as value for the property: '%s'", propertiesConfFile, "bootstrap.servers"), parser);
        }
        String tierTopicNamespace = props.getProperty(KafkaConfig.TierMetadataNamespaceProp(), "");
        String inputFilePath = args.getString(UNFREEZE_LOG_START_OFFSET_INPUT);
        String tierTopicName = TierTopic.topicName(tierTopicNamespace);
        String outputPath = args.getString(UNFREEZE_LOG_START_OFFSET_OUTPUT).trim();
        File outputFile = new File(outputPath);
        if (outputFile.exists() && !outputFile.delete()) {
            throw new IOException("Cannot overwrite existing file at " + outputPath);
        }
        if (!outputFile.createNewFile()) {
            throw new IOException("Could not create output file at path " + outputPath);
        }
        if (inputFilePath != null) {
            List<RestoreInfo.RestoreRawOutput> inputs = TierPartitionUnfreezeLogStartOffsetTrigger.getUnfreezeLogStartOffsetTriggerInput(Paths.get(inputFilePath, new String[0]));
            TierPartitionUnfreezeLogStartOffsetTrigger.injectStateFromRawInput(props, tierTopicName, outputFile, inputs);
        }
    }

    public static void main(String[] args) throws Exception {
        block2: {
            ArgumentParser parser = TierPartitionUnfreezeLogStartOffsetTrigger.createArgParser();
            try {
                TierPartitionUnfreezeLogStartOffsetTrigger.run(parser, parser.parseArgs(args));
            }
            catch (ArgumentParserException e) {
                parser.handleError(e);
                if (e instanceof HelpScreenException) break block2;
                throw e;
            }
        }
    }
}

