/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.UUID;
import kafka.cluster.Partition;
import kafka.common.NoSuchLogSegmentException;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.log.UploadableSegment;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFailedException;
import kafka.tier.exceptions.TierArchiverFatalException;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierArchiverRestoreFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public final class ArchiveTask$
implements Logging {
    public static final ArchiveTask$ MODULE$ = new ArchiveTask$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return ArchiveTask.class.getName();
    }

    public ArchiveTask apply(CancellationContext ctx, TopicIdPartition topicIdPartition, int leaderEpoch, ArchiverMetrics archiverMetrics, int brokerId) {
        return new ArchiveTask(ctx, topicIdPartition, new BeforeLeader(leaderEpoch), archiverMetrics, brokerId);
    }

    public Future<ArchiveTaskState> checkFailedState(FailedState state, TopicIdPartition topicIdPartition, ReplicaManager replicaManager) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> (Product)replicaManager.getLog(topicIdPartition.topicPartition()).map((Function1 & Serializable)log -> {
            int tierEpoch = log.tierPartitionState().tierEpoch();
            int leaderEpoch = state.leaderEpoch();
            if (log.tierPartitionState().status().hasError()) {
                throw new TierArchiverFailedException(topicIdPartition);
            }
            if (tierEpoch > leaderEpoch) {
                throw new TierArchiverFencedException(topicIdPartition, null);
            }
            if (tierEpoch == leaderEpoch) {
                return new BeforeUpload(leaderEpoch);
            }
            if (tierEpoch < leaderEpoch) {
                return new BeforeLeader(leaderEpoch);
            }
            throw new TierArchiverFatalException(new StringBuilder(81).append("attempted to transition from a FailedState for ").append(topicIdPartition).append(" while in non-transitionable state").toString(), null);
        }).getOrElse((Function0 & Serializable)() -> state)));
    }

    public Future<BeforeUpload> establishLeadership(BeforeLeader state, TopicIdPartition topicIdPartition, TierTopicAppender tierTopicAppender, int brokerId, ExecutionContext ec) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(new TierTopicInitLeader(topicIdPartition, state.leaderEpoch(), UUID.randomUUID(), brokerId)))))).flatMap((Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x), ec).map((Function1 & Serializable)result -> {
            if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals(result)) {
                ArchiveTask$ info_this = MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = ArchiveTask$.$anonfun$establishLeadership$4(topicIdPartition);
                    Object var5_4 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
            } else {
                if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals(result)) {
                    throw new TierArchiverFailedException(topicIdPartition);
                }
                if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals(result)) {
                    throw new NotTierablePartitionException(topicIdPartition);
                }
                if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals(result)) {
                    throw new TierArchiverFencedException(topicIdPartition, null);
                }
                if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals(result)) {
                    throw new TierArchiverRestoreFencedException(topicIdPartition);
                }
                throw new TierArchiverFatalException(new StringBuilder(21).append("Unknown AppendResult ").append(result).toString(), null);
            }
            Object var4_3 = null;
            BeforeUpload beforeUpload = new BeforeUpload(state.leaderEpoch());
            return beforeUpload;
        }, ec);
    }

    public Future<ArchiveTaskState> maybeInitiateUpload(BeforeUpload state, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
            if (either instanceof Left) {
                Errors error = (Errors)((Left)either).value();
                throw new TierArchiverFencedException(topicIdPartition, (Throwable)error.exception());
            }
            if (!(either instanceof Right)) throw new MatchError(either);
            Partition partition = (Partition)((Right)either).value();
            if (partition.isUncleanLeader()) {
                throw new TierMetadataRetriableException(new StringBuilder(53).append("Backing off as ").append(topicIdPartition).append(" is undergoing unclean leader recovery").toString());
            }
            Option option = partition.log().flatMap((Function1 & Serializable)log -> {
                if (!log.tierPartitionState().isTieringEnabled()) {
                    throw new NotTierablePartitionException(topicIdPartition);
                }
                if (log.tierPartitionState().tierEpoch() != state.leaderEpoch()) {
                    throw new TierArchiverFencedException(topicIdPartition, null);
                }
                OffsetAndEpoch stateOffset = log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch();
                return log.tierableLogSegments().collectFirst((PartialFunction)new Serializable((AbstractLog)log, stateOffset){
                    private static final long serialVersionUID = 0L;
                    private final AbstractLog log$1;
                    private final OffsetAndEpoch stateOffset$1;

                    public final <A1 extends LogSegment, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object = x1 != null ? new Tuple3((Object)this.log$1, (Object)this.stateOffset$1, x1) : function1.apply(null);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogSegment x1) {
                        boolean bl = x1 != null;
                        return bl;
                    }
                    {
                        this.log$1 = log$1;
                        this.stateOffset$1 = stateOffset$1;
                    }
                });
            });
            if (None$.MODULE$.equals(option)) {
                ArchiveTask$ debug_this = MODULE$;
                if (debug_this.logger().underlying().isDebugEnabled()) {
                    String msgWithLogIdent_msg = ArchiveTask$.$anonfun$maybeInitiateUpload$3(topicIdPartition);
                    Object var22_12 = null;
                    debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
                }
                Object var21_11 = null;
                return Future$.MODULE$.apply((Function0 & Serializable)() -> state, ec);
            }
            if (!(option instanceof Some)) throw new MatchError((Object)option);
            Tuple3 tuple3 = (Tuple3)((Some)option).value();
            if (tuple3 == null) throw new MatchError((Object)option);
            AbstractLog log2 = (AbstractLog)tuple3._1();
            OffsetAndEpoch stateOffset = (OffsetAndEpoch)tuple3._2();
            LogSegment logSegment = (LogSegment)tuple3._3();
            if (log2 == null) throw new MatchError((Object)option);
            if (stateOffset == null) throw new MatchError((Object)option);
            if (logSegment == null) throw new MatchError((Object)option);
            UploadableSegment segment = MODULE$.uploadableSegment(log2, logSegment, topicIdPartition);
            if (log2.isDeleted()) {
                throw new NotTierablePartitionException(topicIdPartition);
            }
            TierObjectStore.OpaqueData opaqueData = (TierObjectStore.OpaqueData)Option$.MODULE$.apply((Object)tierObjectStore.prepPutSegment()).getOrElse((Function0 & Serializable)() -> TierObjectStore.OpaqueData.ZEROED);
            TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, state.leaderEpoch(), UUID.randomUUID(), logSegment.baseOffset(), segment.nextOffset() - 1L, logSegment.largestTimestamp(), logSegment.size(), segment.leaderEpochStateOpt().isDefined(), segment.abortedTxnIndexOpt().isDefined(), segment.producerStateOpt().isDefined(), stateOffset, opaqueData);
            long startTimeMs = time.milliseconds();
            return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(uploadInitiate))))).flatMap((Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x), ec).map((Function1 & Serializable)x0$1 -> {
                if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals(x0$1)) {
                    ArchiveTask$ info_this = MODULE$;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = ArchiveTask$.$anonfun$maybeInitiateUpload$9(uploadInitiate, topicIdPartition, time, startTimeMs);
                        Object var10_8 = null;
                        info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                    }
                } else {
                    if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals(x0$1)) {
                        throw new TierArchiverFailedException(topicIdPartition);
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals(x0$1)) {
                        throw new NotTierablePartitionException(topicIdPartition);
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals(x0$1)) {
                        throw new TierArchiverFencedException(topicIdPartition, null);
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals(x0$1)) {
                        throw new TierArchiverRestoreFencedException(topicIdPartition);
                    }
                    throw new MatchError((Object)x0$1);
                }
                Object var9_7 = null;
                Upload upload = new Upload(state.leaderEpoch(), uploadInitiate, segment);
                return upload;
            }, ec);
        }, ec).flatMap((Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x), ec);
    }

    public Future<AfterUpload> upload(Upload state, TopicIdPartition topicIdPartition, Time time, CancellationContext ctx, TierObjectStore tierObjectStore, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            UploadableSegment uploadableSegment = state.uploadableSegment();
            TierSegmentUploadInitiate uploadInitiate = state.uploadInitiate();
            TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(uploadInitiate.topicIdPartition(), uploadInitiate.objectId(), uploadInitiate.tierEpoch(), uploadInitiate.baseOffset(), uploadableSegment.abortedTxnIndexOpt().isDefined(), uploadableSegment.producerStateOpt().isDefined(), uploadableSegment.leaderEpochStateOpt().isDefined(), state.uploadInitiate().opaqueData());
            return (AfterUpload)package$.MODULE$.blocking((Function0 & Serializable)() -> {
                if (ctx.isCancelled()) {
                    throw new TierArchiverFencedException(topicIdPartition, null);
                }
                long startTimeMs = time.milliseconds();
                try {
                    tierObjectStore.putSegment(metadata, uploadableSegment.logSegmentFile(), uploadableSegment.offsetIndex(), uploadableSegment.timeIndex(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(uploadableSegment.producerStateOpt())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(uploadableSegment.abortedTxnIndexOpt().map((Function1 & Serializable)x$1 -> x$1.duplicate()))), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(uploadableSegment.leaderEpochStateOpt().map((Function1 & Serializable)x$2 -> x$2.duplicate()))));
                }
                catch (Throwable throwable) {
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        if (!MODULE$.segmentFilesExist(state.uploadableSegment())) {
                            throw new ArchiveTask.SegmentDeletedException(new StringBuilder(33).append("Segment ").append(uploadableSegment.logSegmentFile().getAbsolutePath()).append(" of ").append(topicIdPartition).append(" deleted when tiering").toString(), exception);
                        }
                    }
                    throw throwable;
                }
                ArchiveTask$ info_this = MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = ArchiveTask$.$anonfun$upload$5(topicIdPartition, time, startTimeMs);
                    Object var13_12 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
                Object var12_11 = null;
                return new AfterUpload(state.leaderEpoch(), uploadInitiate, state.uploadableSegment().uploadedSize());
            });
        }, ec);
    }

    public Future<BeforeUpload> finalizeUpload(AfterUpload state, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender, Option<Meter> byteRateMetric, ExecutionContext ec) {
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(state.uploadInitiate());
        long startTimeMs = time.milliseconds();
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(uploadComplete))))).flatMap((Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x), ec).map((Function1 & Serializable)x0$1 -> {
            if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals(x0$1)) {
                ArchiveTask$ info_this = MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = ArchiveTask$.$anonfun$finalizeUpload$4(uploadComplete, topicIdPartition, time, startTimeMs);
                    Object var10_8 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
            } else {
                if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals(x0$1)) {
                    throw new TierArchiverFailedException(topicIdPartition);
                }
                if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals(x0$1)) {
                    throw new NotTierablePartitionException(topicIdPartition);
                }
                if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals(x0$1)) {
                    throw new TierArchiverFencedException(topicIdPartition, null);
                }
                if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals(x0$1)) {
                    throw new TierArchiverRestoreFencedException(topicIdPartition);
                }
                throw new MatchError((Object)x0$1);
            }
            Object var9_7 = null;
            byteRateMetric.foreach((Function1 & Serializable)x$3 -> {
                x$3.mark(state.uploadedSize());
                return BoxedUnit.UNIT;
            });
            BeforeUpload beforeUpload = new BeforeUpload(state.leaderEpoch());
            return beforeUpload;
        }, ec);
    }

    public UploadableSegment uploadableSegment(AbstractLog log, LogSegment logSegment, TopicIdPartition topicIdPartition) {
        try {
            return log.createUploadableSegment(logSegment);
        }
        catch (NoSuchLogSegmentException e) {
            throw new ArchiveTask.SegmentDeletedException(new StringBuilder(33).append("Segment ").append(logSegment).append(" of ").append(topicIdPartition).append(" deleted when tiering").toString(), e);
        }
    }

    private boolean segmentFilesExist(UploadableSegment uploadableSegment) {
        return uploadableSegment.allFiles().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.exists()));
    }

    public static final /* synthetic */ String $anonfun$establishLeadership$4(TopicIdPartition topicIdPartition$2) {
        return new StringBuilder(27).append("established leadership for ").append(topicIdPartition$2).toString();
    }

    public static final /* synthetic */ String $anonfun$maybeInitiateUpload$3(TopicIdPartition topicIdPartition$3) {
        return new StringBuilder(78).append("Retrying BeforeUpload for ").append(topicIdPartition$3).append(" as log has moved or no tierable segments were found").toString();
    }

    public static final /* synthetic */ String $anonfun$maybeInitiateUpload$9(TierSegmentUploadInitiate uploadInitiate$1, TopicIdPartition topicIdPartition$3, Time time$2, long startTimeMs$1) {
        return new StringBuilder(21).append("Completed ").append(uploadInitiate$1).append(" for ").append(topicIdPartition$3).append(" in ").append(time$2.milliseconds() - startTimeMs$1).append("ms").toString();
    }

    public static final /* synthetic */ String $anonfun$upload$5(TopicIdPartition topicIdPartition$4, Time time$3, long startTimeMs$2) {
        return new StringBuilder(27).append("Uploaded segment for ").append(topicIdPartition$4).append(" in ").append(time$3.milliseconds() - startTimeMs$2).append("ms").toString();
    }

    public static final /* synthetic */ String $anonfun$finalizeUpload$4(TierSegmentUploadComplete uploadComplete$1, TopicIdPartition topicIdPartition$5, Time time$4, long startTimeMs$3) {
        return new StringBuilder(22).append("Finalized ").append(uploadComplete$1).append(" for ").append(topicIdPartition$5).append(" in ").append(time$4.milliseconds() - startTimeMs$3).append(" ms").toString();
    }

    private ArchiveTask$() {
    }
}

