/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kafka.log.Log;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.state.SegmentState;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.utils.CoreUtils;

public interface TierObjectStore {
    public Backend getBackend();

    public TierObjectStoreResponse getObject(ObjectStoreMetadata var1, FileType var2, Integer var3, Integer var4) throws IOException;

    default public TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, FileType fileType, Integer byteOffsetStart) throws IOException {
        return this.getObject(objectMetadata, fileType, byteOffsetStart, null);
    }

    default public TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, FileType fileType) throws IOException {
        return this.getObject(objectMetadata, fileType, null);
    }

    public OpaqueData prepPutSegment() throws TierObjectStoreRetriableException, IOException;

    public void putObject(ObjectStoreMetadata var1, File var2, FileType var3) throws TierObjectStoreRetriableException, IOException;

    public void putSegment(ObjectMetadata var1, File var2, File var3, File var4, Optional<File> var5, Optional<ByteBuffer> var6, Optional<ByteBuffer> var7) throws TierObjectStoreRetriableException, IOException;

    public void deleteSegment(ObjectMetadata var1) throws IOException;

    public void close();

    public static class TierStateRestoreSnapshotMetadata
    implements ObjectStoreMetadata {
        private static final int CURRENT_KEY_PATH_VERSION = 0;
        private final TopicIdPartition topicIdPartition;
        private final long startOffset;
        private final long endOffset;
        private final String contentHash;
        private final int version = 0;

        public TierStateRestoreSnapshotMetadata(TopicIdPartition topicIdPartition, long startOffset, long endOffset, String contentHash) {
            this.topicIdPartition = topicIdPartition;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.contentHash = contentHash;
        }

        public TierStateRestoreSnapshotMetadata(TierPartitionForceRestore metadata) {
            this(metadata.topicIdPartition(), metadata.startOffset(), metadata.endOffset(), metadata.contentHash());
        }

        public int version() {
            return 0;
        }

        public TopicIdPartition topicIdPartition() {
            return this.topicIdPartition;
        }

        @Override
        public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("metadata_version", Integer.toString(0));
            metadata.put("topic", this.topicIdPartition().topic());
            clusterIdOpt.ifPresent(clusterId -> metadata.put("cluster_id", (String)clusterId));
            brokerIdOpt.ifPresent(brokerId -> metadata.put("broker_id", Integer.toString(brokerId)));
            return metadata;
        }

        @Override
        public OpaqueData opaqueData() {
            return OpaqueData.ZEROED;
        }

        @Override
        public String toPath(String keyPrefix, FileType fileType) {
            return keyPrefix + DataTypePathPrefix.TIER_STATE_RESTORE_SNAPSHOTS.prefix + "/" + this.topicIdPartition().topicIdAsBase64() + "/" + this.topicIdPartition().partition() + "/" + Log.filenamePrefixFromOffset(this.startOffset) + "-" + Log.filenamePrefixFromOffset(this.endOffset) + "_" + this.contentHash + "_v" + 0 + "." + fileType.suffix();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TierStateRestoreSnapshotMetadata that = (TierStateRestoreSnapshotMetadata)o;
            return this.topicIdPartition.equals(that.topicIdPartition) && this.startOffset == that.startOffset && this.endOffset == that.endOffset && this.contentHash.equals(that.contentHash) && 0 == that.version;
        }

        public int hashCode() {
            return Objects.hash(this.topicIdPartition, this.startOffset, this.endOffset, this.contentHash, 0);
        }

        public String toString() {
            return "TierStateRestoreSnapshotMetadata(version=0, topic=" + this.topicIdPartition + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", contentHash=" + this.contentHash + ')';
        }
    }

    public static class ObjectMetadata
    implements ObjectStoreMetadata {
        private static final int CURRENT_KEY_PATH_VERSION = 0;
        private final TopicIdPartition topicIdPartition;
        private final UUID objectId;
        private final int tierEpoch;
        private final long baseOffset;
        private final boolean hasAbortedTxns;
        private final boolean hasProducerState;
        private final boolean hasEpochState;
        private final int version = 0;
        private final OpaqueData opaqueData;

        public ObjectMetadata(TopicIdPartition topicIdPartition, UUID objectId, int tierEpoch, long baseOffset, boolean hasAbortedTxns, boolean hasProducerState, boolean hasEpochState, OpaqueData opaqueData) {
            this.topicIdPartition = topicIdPartition;
            this.objectId = objectId;
            this.tierEpoch = tierEpoch;
            this.baseOffset = baseOffset;
            this.hasAbortedTxns = hasAbortedTxns;
            this.hasProducerState = hasProducerState;
            this.hasEpochState = hasEpochState;
            this.opaqueData = opaqueData;
        }

        public ObjectMetadata(TopicIdPartition topicIdPartition, SegmentState metadata) {
            this(topicIdPartition, metadata.objectId(), metadata.tierEpoch(), metadata.keyBaseOffset(), metadata.hasAbortedTxns(), metadata.hasProducerState(), metadata.hasEpochState(), metadata.opaqueData());
        }

        public TopicIdPartition topicIdPartition() {
            return this.topicIdPartition;
        }

        public UUID objectId() {
            return this.objectId;
        }

        public String objectIdAsBase64() {
            return CoreUtils.uuidToBase64(this.objectId());
        }

        public int tierEpoch() {
            return this.tierEpoch;
        }

        public long baseOffset() {
            return this.baseOffset;
        }

        public boolean hasAbortedTxns() {
            return this.hasAbortedTxns;
        }

        public boolean hasProducerState() {
            return this.hasProducerState;
        }

        public boolean hasEpochState() {
            return this.hasEpochState;
        }

        @Override
        public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("metadata_version", Integer.toString(0));
            metadata.put("topic", this.topicIdPartition().topic());
            clusterIdOpt.ifPresent(clusterId -> metadata.put("cluster_id", (String)clusterId));
            brokerIdOpt.ifPresent(brokerId -> metadata.put("broker_id", Integer.toString(brokerId)));
            return metadata;
        }

        @Override
        public OpaqueData opaqueData() {
            return this.opaqueData;
        }

        @Override
        public String toPath(String keyPrefix, FileType fileType) {
            return keyPrefix + DataTypePathPrefix.TOPIC.prefix + "/" + this.objectIdAsBase64() + "/" + this.topicIdPartition().topicIdAsBase64() + "/" + this.topicIdPartition().partition() + "/" + Log.filenamePrefixFromOffset(this.baseOffset()) + "_" + this.tierEpoch() + "_v" + 0 + "." + fileType.suffix();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectMetadata that = (ObjectMetadata)o;
            return this.tierEpoch == that.tierEpoch && this.baseOffset == that.baseOffset && Objects.equals(this.topicIdPartition, that.topicIdPartition) && Objects.equals(this.objectId, that.objectId) && this.hasAbortedTxns == that.hasAbortedTxns && this.hasProducerState == that.hasProducerState && this.hasEpochState == that.hasEpochState && 0 == that.version;
        }

        public int hashCode() {
            return Objects.hash(this.topicIdPartition, this.objectId, this.tierEpoch, this.baseOffset, this.hasAbortedTxns, this.hasProducerState, this.hasEpochState);
        }

        public String toString() {
            return "ObjectMetadata(topic=" + this.topicIdPartition + ", objectIdAsBase64=" + this.objectIdAsBase64() + ", tierEpoch=" + this.tierEpoch + ", baseOffset=" + this.baseOffset + ", hasAbortedTxns=" + this.hasAbortedTxns + ", hasProducerState=" + this.hasProducerState + ", hasEpochState=" + this.hasEpochState + ')';
        }
    }

    public static interface ObjectStoreMetadata {
        public String toPath(String var1, FileType var2);

        public Map<String, String> objectMetadata(Optional<String> var1, Optional<Integer> var2);

        public OpaqueData opaqueData();
    }

    public static enum Backend {
        AzureBlockBlob("AzureBlockBlob"),
        GCS("GCS"),
        Mock("Mock"),
        S3("S3"),
        Test("Test");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Backend(String name) {
            this.name = name;
        }
    }

    public static enum DataTypePathPrefix {
        TOPIC("0"),
        TIER_STATE_RESTORE_SNAPSHOTS("1"),
        LAST_ACTIVE_ENCRYPTION_KEY("2");

        private final String prefix;

        private DataTypePathPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String prefix() {
            return this.prefix;
        }
    }

    public static final class OpaqueData {
        public static final OpaqueData ZEROED = new OpaqueData(new byte[32]);
        private final byte[] buffer = new byte[32];

        private OpaqueData(byte[] bytes) {
            if (bytes.length > 32) {
                throw new IllegalArgumentException("OpaqueData limited to 32 bytes in length");
            }
            System.arraycopy(bytes, 0, this.buffer, 0, Math.min(this.buffer.length, bytes.length));
        }

        public boolean isEmpty() {
            return this.equals(ZEROED);
        }

        public static OpaqueData fromLongArray(long[] arr) {
            if (arr.length > 4) {
                throw new IllegalArgumentException("Input array must be fit in 32 bytes of space");
            }
            byte[] bytes = new byte[32];
            ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
            int pos = 0;
            for (long elem : arr) {
                bb.putLong(pos, elem);
                pos += 8;
            }
            return new OpaqueData(bytes);
        }

        public static OpaqueData fromByteArray(byte[] arr) {
            if (arr.length > 32) {
                throw new IllegalArgumentException("Input array must be <= 32 bytes");
            }
            byte[] bytes = new byte[32];
            ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
            bb.put(arr);
            return new OpaqueData(bytes);
        }

        public long[] intoLongArray() {
            ByteBuffer bb = ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN);
            long[] ret = new long[]{bb.getLong(0), bb.getLong(8), bb.getLong(16), bb.getLong(24)};
            return ret;
        }

        public byte[] intoByteArray() {
            return (byte[])this.buffer.clone();
        }

        public String toString() {
            return "OpaqueData{len=" + this.buffer.length + ", zeroed=" + this.equals(ZEROED) + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OpaqueData that = (OpaqueData)o;
            return Arrays.equals(this.buffer, that.buffer);
        }

        public int hashCode() {
            return Arrays.hashCode(this.buffer);
        }
    }

    public static enum FileType {
        SEGMENT("segment"),
        OFFSET_INDEX("offset-index"),
        TIMESTAMP_INDEX("timestamp-index"),
        TRANSACTION_INDEX("transaction-index"),
        PRODUCER_STATE("producer-state"),
        EPOCH_STATE("epoch-state"),
        TIER_STATE_SNAPSHOT("tier-state-snapshot");

        private final String suffix;

        public String suffix() {
            return this.suffix;
        }

        private FileType(String suffix) {
            this.suffix = suffix;
        }
    }
}

