/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.aead.AeadConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.encryption.CleartextDataKey;
import kafka.tier.store.encryption.EncryptionKeyManager;
import kafka.tier.store.encryption.KeyContext;
import kafka.tier.store.encryption.KeySha;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

public class MockInMemoryTierObjectStore
implements TierObjectStore,
AutoCloseable {
    public volatile boolean throwExceptionOnSegmentFetch = false;
    public volatile boolean throwExceptionOnTransactionFetch = false;
    private static final ConcurrentHashMap<String, UploadedObject> KEY_TO_BLOB = new ConcurrentHashMap();
    private static final Aead MASTER_KEY;
    private static Map<String, String> wellKnownKeyPathMetadata;
    private final ConcurrentHashMap<TierObjectStore.FileType, Integer> objectCounts = new ConcurrentHashMap();
    private final TierObjectStoreConfig config;
    private final EncryptionKeyManager encryptionKeyManager;

    public MockInMemoryTierObjectStore(Time time, TierObjectStoreConfig config) {
        this(time, null, config);
    }

    public MockInMemoryTierObjectStore(Time time, Metrics metrics, TierObjectStoreConfig config) {
        this.config = config;
        this.encryptionKeyManager = new EncryptionKeyManager(time, metrics, MASTER_KEY, Duration.ofSeconds(1L));
        this.encryptionKeyManager.bindHook(new EncryptionKeyManager.WellKnownKeypathHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeWellKnownPathMetadata(Map<String, String> metadata) {
                Aead aead = MASTER_KEY;
                synchronized (aead) {
                    wellKnownKeyPathMetadata = metadata;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, String> fetchWellKnownPathMetadata() {
                Aead aead = MASTER_KEY;
                synchronized (aead) {
                    return wellKnownKeyPathMetadata;
                }
            }
        });
    }

    public List<String> getStoredKeys() {
        return Collections.list(KEY_TO_BLOB.keys());
    }

    public ConcurrentHashMap<TierObjectStore.FileType, Integer> getObjectCounts() {
        return this.objectCounts;
    }

    private boolean shouldThrow(TierObjectStore.FileType objectFileType) {
        return this.throwExceptionOnSegmentFetch && objectFileType == TierObjectStore.FileType.SEGMENT || this.throwExceptionOnTransactionFetch && objectFileType == TierObjectStore.FileType.TRANSACTION_INDEX;
    }

    @Override
    public TierObjectStore.Backend getBackend() {
        return TierObjectStore.Backend.Mock;
    }

    @Override
    public TierObjectStoreResponse getObject(TierObjectStore.ObjectStoreMetadata objectMetadata, TierObjectStore.FileType objectFileType, Integer byteOffset, Integer byteOffsetEnd) throws IOException {
        if (this.shouldThrow(objectFileType)) {
            throw new IOException("");
        }
        String key = this.keyPath(objectMetadata, objectFileType);
        UploadedObject uploadedObject = KEY_TO_BLOB.get(key);
        if (uploadedObject == null) {
            throw new IOException(String.format("No bytes for key %s", key));
        }
        if (objectFileType.equals((Object)TierObjectStore.FileType.SEGMENT)) {
            if (!objectMetadata.opaqueData().equals(TierObjectStore.OpaqueData.ZEROED)) {
                KeySha keySha = KeySha.fromRawBytes(objectMetadata.opaqueData().intoByteArray());
                KeyContext keyContext = this.encryptionKeyManager.keyContext(keySha);
                if (keyContext == null) {
                    KeySha registeredKeySha = this.encryptionKeyManager.registerKeyFromObjectMetadata(uploadedObject.metadata);
                    if (!registeredKeySha.equals(keySha)) {
                        throw new IllegalStateException("key sha does not match");
                    }
                    keyContext = this.encryptionKeyManager.keyContext(registeredKeySha);
                }
                if (!keyContext.cleartextDataKey.equals(uploadedObject.cleartextDataKey)) {
                    throw new IllegalStateException("decryption failed, decrypted data keys do not match");
                }
            } else if (uploadedObject.encrypted()) {
                throw new IllegalStateException("tried to download an encrypted segment without OpaqueData");
            }
        }
        byte[] blob = uploadedObject.data;
        int start = byteOffset == null ? 0 : byteOffset;
        int end = byteOffsetEnd == null ? blob.length : Math.min(byteOffsetEnd, blob.length);
        int byteBufferSize = end - start;
        ByteBuffer buf = ByteBuffer.allocate(byteBufferSize);
        buf.put(blob, start, byteBufferSize);
        buf.flip();
        return new MockInMemoryTierObjectStoreResponse(new ByteArrayInputStream(blob));
    }

    @Override
    public TierObjectStore.OpaqueData prepPutSegment() throws TierObjectStoreRetriableException {
        KeySha activeKeySha = this.encryptionKeyManager.activeKeySha();
        if (activeKeySha != null) {
            return TierObjectStore.OpaqueData.fromByteArray(activeKeySha.toRawBytes());
        }
        return TierObjectStore.OpaqueData.ZEROED;
    }

    @Override
    public void close() {
    }

    private void incrementObjectCount(TierObjectStore.FileType fileType) {
        this.objectCounts.compute(fileType, (key, integer) -> {
            int n;
            if (integer == null) {
                n = 1;
            } else {
                Integer n2 = integer;
                Integer n3 = integer = Integer.valueOf(integer + 1);
                n = n2;
            }
            return n;
        });
    }

    @Override
    public void putSegment(TierObjectStore.ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) {
        String segmentKeyPath = this.keyPath(objectMetadata, TierObjectStore.FileType.SEGMENT);
        this.writeSegmentFile(segmentKeyPath, segmentData, objectMetadata.opaqueData());
        this.incrementObjectCount(TierObjectStore.FileType.SEGMENT);
        this.writeFileToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.OFFSET_INDEX), offsetIndexData);
        this.incrementObjectCount(TierObjectStore.FileType.OFFSET_INDEX);
        this.writeFileToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.TIMESTAMP_INDEX), timestampIndexData);
        this.incrementObjectCount(TierObjectStore.FileType.TIMESTAMP_INDEX);
        producerStateSnapshotData.ifPresent(data -> {
            this.writeFileToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.PRODUCER_STATE), (File)data);
            this.incrementObjectCount(TierObjectStore.FileType.PRODUCER_STATE);
        });
        transactionIndexData.ifPresent(data -> {
            this.writeBufToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.TRANSACTION_INDEX), (ByteBuffer)data);
            this.incrementObjectCount(TierObjectStore.FileType.TRANSACTION_INDEX);
        });
        if (epochState.isPresent()) {
            this.writeBufToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.EPOCH_STATE), epochState.get());
            this.incrementObjectCount(TierObjectStore.FileType.EPOCH_STATE);
        }
    }

    @Override
    public void putObject(TierObjectStore.ObjectStoreMetadata objectMetadata, File file, TierObjectStore.FileType fileType) {
        String key = this.keyPath(objectMetadata, fileType);
        this.writeFileToArray(key, file);
    }

    @Override
    public void deleteSegment(TierObjectStore.ObjectMetadata objectMetadata) {
        for (TierObjectStore.FileType type : TierObjectStore.FileType.values()) {
            KEY_TO_BLOB.remove(this.keyPath(objectMetadata, type));
        }
    }

    private String keyPath(TierObjectStore.ObjectStoreMetadata objectMetadata, TierObjectStore.FileType fileType) {
        return objectMetadata.toPath("", fileType);
    }

    private void writeSegmentFile(String filePath, File file, TierObjectStore.OpaqueData opaqueData) {
        ByteBuffer buf;
        try (FileChannel sourceChan = FileChannel.open(file.toPath(), new OpenOption[0]);){
            buf = ByteBuffer.allocate((int)sourceChan.size());
            sourceChan.read(buf);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (!opaqueData.equals(TierObjectStore.OpaqueData.ZEROED)) {
            KeySha keySha = KeySha.fromRawBytes(opaqueData.intoByteArray());
            KeyContext keyContext = this.encryptionKeyManager.keyContext(keySha);
            if (keyContext == null) {
                throw new TierObjectStoreFatalException(String.format("no key context on upload for '%s'", keySha));
            }
            KEY_TO_BLOB.put(filePath, new UploadedObject(keyContext.metadata, keyContext.cleartextDataKey, buf.array()));
        } else {
            KEY_TO_BLOB.put(filePath, new UploadedObject(new HashMap(), null, buf.array()));
        }
    }

    private void writeFileToArray(String filePath, File file) {
        try (FileChannel sourceChan = FileChannel.open(file.toPath(), new OpenOption[0]);){
            ByteBuffer buf = ByteBuffer.allocate((int)sourceChan.size());
            sourceChan.read(buf);
            KEY_TO_BLOB.put(filePath, new UploadedObject(new HashMap(), null, buf.array()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeBufToArray(String filePath, ByteBuffer buf) {
        try {
            ByteBufferInputStream inputStream = new ByteBufferInputStream(buf);
            byte[] bs = new byte[buf.limit()];
            Utils.readFully((InputStream)inputStream, (byte[])bs);
            KEY_TO_BLOB.put(filePath, new UploadedObject(new HashMap(), null, bs));
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    static {
        wellKnownKeyPathMetadata = null;
        try {
            AeadConfig.register();
            KeyTemplate keyTemplate = KeyTemplates.get((String)"AES256_GCM_RAW");
            KeysetHandle keySetHandle = KeysetHandle.generateNew((KeyTemplate)keyTemplate);
            MASTER_KEY = (Aead)keySetHandle.getPrimitive(Aead.class);
        }
        catch (GeneralSecurityException e) {
            throw new TierObjectStoreFatalException("failed to initialize Tink", e);
        }
    }

    private static class UploadedObject {
        final HashMap<String, String> metadata;
        final CleartextDataKey cleartextDataKey;
        final byte[] data;

        private UploadedObject(HashMap<String, String> metadata, CleartextDataKey cleartextDataKey, byte[] data) {
            this.metadata = metadata;
            this.cleartextDataKey = cleartextDataKey;
            this.data = data;
        }

        boolean encrypted() {
            return this.cleartextDataKey != null;
        }
    }

    private static class MockInMemoryTierObjectStoreResponse
    implements TierObjectStoreResponse {
        private final InputStream inputStream;

        MockInMemoryTierObjectStoreResponse(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public void close() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

