/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.util.Objects;
import java.util.UUID;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.store.TierObjectStore;

public class SegmentState {
    private final TierObjectMetadata.State state;
    private final UUID objectId;
    private final long keyBaseOffset;
    private final int virtualBaseOffsetDelta;
    private final int endOffsetDelta;
    private final long maxTimestamp;
    private final int size;
    private final int tierEpoch;
    private final boolean hasAbortedTxns;
    private final boolean hasEpochState;
    private final boolean hasProducerState;
    private final int filePosition;
    private final TierObjectStore.OpaqueData opaqueData;

    public SegmentState(TierObjectMetadata metadata, long virtualBaseOffset, long filePosition) {
        this(metadata.tierEpoch(), metadata.objectId(), virtualBaseOffset, metadata.baseOffset(), metadata.endOffset(), metadata.maxTimestamp(), metadata.size(), metadata.state(), metadata.hasEpochState(), metadata.hasAbortedTxns(), metadata.hasProducerState(), metadata.opaqueData(), filePosition);
    }

    public SegmentState(int tierEpoch, UUID objectId, long baseOffset, long keyBaseOffset, long endOffset, long maxTimestamp, int size, TierObjectMetadata.State state, boolean hasEpochState, boolean hasAbortedTxns, boolean hasProducerState, TierObjectStore.OpaqueData opaqueData, long filePosition) {
        if (filePosition > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("We can't support tier-state files larger than 2147483647");
        }
        this.state = state;
        this.objectId = objectId;
        this.keyBaseOffset = keyBaseOffset;
        this.virtualBaseOffsetDelta = (int)(baseOffset - keyBaseOffset);
        this.endOffsetDelta = (int)(endOffset - keyBaseOffset);
        this.maxTimestamp = maxTimestamp;
        this.size = size;
        this.tierEpoch = tierEpoch;
        this.hasAbortedTxns = hasAbortedTxns;
        this.hasEpochState = hasEpochState;
        this.hasProducerState = hasProducerState;
        this.opaqueData = opaqueData;
        this.filePosition = (int)filePosition;
    }

    public long endOffset() {
        return this.keyBaseOffset + (long)this.endOffsetDelta;
    }

    public long baseOffset() {
        return this.keyBaseOffset + (long)this.virtualBaseOffsetDelta;
    }

    public long keyBaseOffset() {
        return this.keyBaseOffset;
    }

    public TierObjectStore.OpaqueData opaqueData() {
        return this.opaqueData;
    }

    public SegmentState updateState(TierObjectMetadata.State updatedState) {
        this.state.canTransitionTo(updatedState);
        return new SegmentState(this.tierEpoch(), this.objectId(), this.baseOffset(), this.keyBaseOffset, this.endOffset(), this.maxTimestamp(), this.size(), updatedState, this.hasEpochState(), this.hasAbortedTxns(), this.hasProducerState(), this.opaqueData, this.filePosition());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentState that = (SegmentState)o;
        return this.tierEpoch() == that.tierEpoch() && this.objectId().equals(that.objectId()) && this.virtualBaseOffsetDelta == that.virtualBaseOffsetDelta && this.keyBaseOffset == that.keyBaseOffset && this.endOffsetDelta == that.endOffsetDelta && this.maxTimestamp() == that.maxTimestamp() && this.size() == that.size() && this.state() == that.state() && this.hasEpochState() == that.hasEpochState() && this.hasAbortedTxns() == that.hasAbortedTxns() && this.hasProducerState() == that.hasProducerState() && this.filePosition() == that.filePosition() && this.opaqueData().equals(that.opaqueData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tierEpoch(), this.objectId(), this.virtualBaseOffsetDelta, this.keyBaseOffset, this.endOffsetDelta, this.maxTimestamp(), this.size(), this.state(), this.hasEpochState(), this.hasAbortedTxns(), this.hasProducerState(), this.filePosition(), this.opaqueData()});
    }

    public String toString() {
        return "SegmentState(state: " + (Object)((Object)this.state()) + ", tierEpoch: " + this.tierEpoch() + ", baseOffset: " + this.baseOffset() + ", keyBaseOffset: " + this.keyBaseOffset + ", endOffset: " + this.endOffset() + ", maxTimestamp: " + this.maxTimestamp() + ", size: " + this.size() + ", hasEpochState: " + this.hasEpochState() + ", hasAbortedTxns: " + this.hasAbortedTxns() + ", hasProducerState: " + this.hasProducerState() + ", filePosition: " + this.filePosition() + "opaqueData: " + this.opaqueData() + ")";
    }

    public TierObjectMetadata.State state() {
        return this.state;
    }

    public UUID objectId() {
        return this.objectId;
    }

    public long maxTimestamp() {
        return this.maxTimestamp;
    }

    public int size() {
        return this.size;
    }

    public int tierEpoch() {
        return this.tierEpoch;
    }

    public boolean hasAbortedTxns() {
        return this.hasAbortedTxns;
    }

    public boolean hasEpochState() {
        return this.hasEpochState;
    }

    public boolean hasProducerState() {
        return this.hasProducerState;
    }

    public int filePosition() {
        return this.filePosition;
    }
}

