/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.MultiChecksumTypeException;
import org.apache.kafka.common.errors.OtherChecksumTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumMigration {
    private static final Logger log = LoggerFactory.getLogger(ChecksumMigration.class);

    public static void maybeMigrateChecksumFormat(Algorithm checksumAlgorithm, short checksumSuperBlockLength, Path path) throws IOException {
        try {
            CheckedFileIO.verifyOnlyValidFileExists(checksumAlgorithm, path);
            log.debug("No migration performed for path: " + path + " as file already in " + checksumAlgorithm.suffix + " format");
        }
        catch (OtherChecksumTypeException e) {
            log.info("Other format file found for path: " + path + " " + e.getMessage());
            CheckedFileIO.migrateFile(ChecksumMigration.previousFormatPath(path), path, checksumSuperBlockLength);
        }
        catch (MultiChecksumTypeException e) {
            log.warn("Multiple format files found for path: " + path + " " + e.getMessage());
            Path oldPath = ChecksumMigration.previousFormatPath(path);
            if (ChecksumMigration.compareTierStateFiles(oldPath, path)) {
                log.warn("Deleting " + oldPath + " format file as it has an older tier epoch / offset than " + path);
                Files.delete(oldPath);
            } else {
                log.warn("Deleting " + path + " format file as it has an older tier epoch / offset than " + oldPath);
                Files.delete(path);
                CheckedFileIO.migrateFile(oldPath, path, checksumSuperBlockLength);
            }
        }
        catch (FileNotFoundException e) {
            log.debug("File not found during migration for path: " + path + " " + e.getMessage());
        }
    }

    public static Path previousFormatPath(Path path) {
        Path prvPath = CheckedFileIO.isValidPath(Algorithm.ADLER, path) ? CheckedFileIO.validPath(Algorithm.NO_CHECKSUM, path) : CheckedFileIO.validPath(Algorithm.ADLER, path);
        return prvPath;
    }

    public static void maybeRemovePreviousFormatPath(Path path) throws IOException {
        Path prvPath = ChecksumMigration.previousFormatPath(path);
        Files.deleteIfExists(prvPath);
    }

    static boolean compareTierStateFiles(Path oldPath, Path newPath) throws IOException {
        CheckedFileIO oldChannel = CheckedFileIO.open(oldPath, true, StandardOpenOption.READ);
        Optional<Header> oldHeaderOpt = FileTierPartitionState.readHeader(oldChannel);
        CheckedFileIO newChannel = CheckedFileIO.open(newPath, true, StandardOpenOption.READ);
        Optional<Header> newHeaderOpt = FileTierPartitionState.readHeader(newChannel);
        if (oldHeaderOpt.isPresent() && newHeaderOpt.isPresent()) {
            Header oldHeader = oldHeaderOpt.get();
            Header newHeader = newHeaderOpt.get();
            if (oldHeader.tierEpoch() != newHeader.tierEpoch()) {
                return newHeader.tierEpoch() > oldHeader.tierEpoch();
            }
            return newHeader.endOffset() >= oldHeader.endOffset();
        }
        if (newHeaderOpt.isPresent()) {
            return true;
        }
        if (oldHeaderOpt.isPresent()) {
            return false;
        }
        throw new KafkaStorageException("Failed to compare tier files oldPath: " + oldPath + " newPath: " + newPath + " as both files do not have a valid header present");
    }
}

