/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.FinalizedFeatureCache;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.MetadataPublisher;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Mv!\u0002\r\u001a\u0011\u0003\u0001c!\u0002\u0012\u001a\u0011\u0003\u0019\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004\"\u0002\u001a\u0002\t\u0003\u0019\u0004\"B-\u0002\t\u0003Qf\u0001\u0002\u0012\u001a\u0001uD!\"a\u0001\u0006\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011)\ti!\u0002B\u0001B\u0003%\u0011q\u0002\u0005\u000b\u0003+)!\u0011!Q\u0001\n\u0005]\u0001BCA\u000f\u000b\t\u0005\t\u0015!\u0003\u0002 !Q\u0011QE\u0003\u0003\u0002\u0003\u0006I!a\n\t\u0015\u0005]RA!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002F\u0015\u0011\t\u0011)A\u0005\u0003\u000fB!\"!\u0014\u0006\u0005\u0003\u0005\u000b\u0011BA(\u0011)\t)&\u0002B\u0001B\u0003%\u0011q\u000b\u0005\u0007a\u0015!\t!a\u0019\t\u0011-,!\u0019!C\u0001\u0003sBq!a\u001f\u0006A\u0003%A\u000eC\u0005\u0002~\u0015\u0001\r\u0011\"\u0001\u0002\u0000!I\u0011qQ\u0003A\u0002\u0013\u0005\u0011\u0011\u0012\u0005\t\u0003++\u0001\u0015)\u0003\u0002\u0002\"9\u0011qS\u0003\u0005B\u0005e\u0005bBAU\u000b\u0011%\u00111\u0016\u0005\b\u0003[+A\u0011BAX\u0003]\u0011%o\\6fe6+G/\u00193bi\u0006\u0004VO\u00197jg\",'O\u0003\u0002\u001b7\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002\u001d;\u000511/\u001a:wKJT\u0011AH\u0001\u0006W\u000647.Y\u0002\u0001!\t\t\u0013!D\u0001\u001a\u0005]\u0011%o\\6fe6+G/\u00193bi\u0006\u0004VO\u00197jg\",'oE\u0002\u0002I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016/\u001b\u0005a#BA\u0017\u001e\u0003\u0015)H/\u001b7t\u0013\tyCFA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\u0001\u0013!D4fiR{\u0007/[2EK2$\u0018\r\u0006\u00035\u0005>#\u0006cA\u00136o%\u0011aG\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005a\u0002U\"A\u001d\u000b\u0005iZ\u0014!B5nC\u001e,'B\u0001\u0010=\u0015\tid(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0005\u0019qN]4\n\u0005\u0005K$A\u0003+pa&\u001cG)\u001a7uC\")1i\u0001a\u0001\t\u0006IAo\u001c9jG:\u000bW.\u001a\t\u0003\u000b2s!A\u0012&\u0011\u0005\u001d3S\"\u0001%\u000b\u0005%{\u0012A\u0002\u001fs_>$h(\u0003\u0002LM\u00051\u0001K]3eK\u001aL!!\u0014(\u0003\rM#(/\u001b8h\u0015\tYe\u0005C\u0003Q\u0007\u0001\u0007\u0011+\u0001\u0005oK^LU.Y4f!\tA$+\u0003\u0002Ts\tiQ*\u001a;bI\u0006$\u0018-S7bO\u0016DQ!V\u0002A\u0002Y\u000bQ\u0001Z3mi\u0006\u0004\"\u0001O,\n\u0005aK$!D'fi\u0006$\u0017\r^1EK2$\u0018-A\ngS:$7\u000b\u001e:bsB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\\U>$\bc\u0001/bI:\u0011Ql\u0018\b\u0003\u000fzK\u0011aJ\u0005\u0003A\u001a\nq\u0001]1dW\u0006<W-\u0003\u0002cG\nA\u0011\n^3sC\ndWM\u0003\u0002aMA\u0011Q\r[\u0007\u0002M*\u0011qmO\u0001\u0007G>lWn\u001c8\n\u0005%4'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006W\u0012\u0001\r\u0001\\\u0001\tEJ|7.\u001a:JIB\u0011Q%\\\u0005\u0003]\u001a\u00121!\u00138u\u0011\u0015\u0001H\u00011\u0001r\u00039qWm\u001e+pa&\u001c7/S7bO\u0016\u0004\"\u0001\u000f:\n\u0005ML$a\u0003+pa&\u001c7/S7bO\u0016DQ!\u001e\u0003A\u0002Y\fA\u0001\\8hgB\u0019A,Y<\u0011\u0005a\\X\"A=\u000b\u0005il\u0012a\u00017pO&\u0011A0\u001f\u0002\f\u0003\n\u001cHO]1di2{wm\u0005\u0003\u0006IyT\u0003CA\u0011\u0000\u0013\r\t\t!\u0007\u0002\u0012\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014\u0018\u0001B2p]\u001a\u0004B!a\u0002\u0002\n5\t1$C\u0002\u0002\fm\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u00042!IA\t\u0013\r\t\u0019\"\u0007\u0002\u0013\u0017J\u000bg\r^'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\u0006m_\u001el\u0015M\\1hKJ\u00042\u0001_A\r\u0013\r\tY\"\u001f\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0005\u0003\u000f\t\t#C\u0002\u0002$m\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\the>,\boQ8pe\u0012Lg.\u0019;peB!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012!B4s_V\u0004(bAA\u0019;\u0005Y1m\\8sI&t\u0017\r^8s\u0013\u0011\t)$a\u000b\u0003!\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\u0018A\u0004;y]\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)!\u0011qHA\u0018\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005\r\u0013Q\b\u0002\u0017)J\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe\u0006Q2\r\\5f]R\fVo\u001c;b\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4feB\u0019\u0011%!\u0013\n\u0007\u0005-\u0013D\u0001\u000eDY&,g\u000e^)v_R\fW*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\u0007gK\u0006$XO]3DC\u000eDW\r\u0005\u0003\u0002\b\u0005E\u0013bAA*7\t)b)\u001b8bY&TX\r\u001a$fCR,(/Z\"bG\",\u0017!\u00063z]\u0006l\u0017nY\"p]\u001aLw\rS1oI2,'o\u001d\t\u0007\u000b\u0006eC)!\u0018\n\u0007\u0005mcJA\u0002NCB\u0004B!a\u0002\u0002`%\u0019\u0011\u0011M\u000e\u0003\u001b\r{gNZ5h\u0011\u0006tG\r\\3s)Q\t)'a\u001a\u0002j\u0005-\u0014QNA8\u0003c\n\u0019(!\u001e\u0002xA\u0011\u0011%\u0002\u0005\b\u0003\u0007y\u0001\u0019AA\u0003\u0011\u001d\tia\u0004a\u0001\u0003\u001fAq!!\u0006\u0010\u0001\u0004\t9\u0002C\u0004\u0002\u001e=\u0001\r!a\b\t\u000f\u0005\u0015r\u00021\u0001\u0002(!9\u0011qG\bA\u0002\u0005e\u0002bBA#\u001f\u0001\u0007\u0011q\t\u0005\b\u0003\u001bz\u0001\u0019AA(\u0011\u001d\t)f\u0004a\u0001\u0003/*\u0012\u0001\\\u0001\nEJ|7.\u001a:JI\u0002\nQb\u00184jeN$\b+\u001e2mSNDWCAAA!\r)\u00131Q\u0005\u0004\u0003\u000b3#a\u0002\"p_2,\u0017M\\\u0001\u0012?\u001aL'o\u001d;Qk\nd\u0017n\u001d5`I\u0015\fH\u0003BAF\u0003#\u00032!JAG\u0013\r\tyI\n\u0002\u0005+:LG\u000fC\u0005\u0002\u0014N\t\t\u00111\u0001\u0002\u0002\u0006\u0019\u0001\u0010J\u0019\u0002\u001d}3\u0017N]:u!V\u0014G.[:iA\u00059\u0001/\u001e2mSNDG\u0003CAF\u00037\u000b)+a*\t\u000f\u0005uU\u00031\u0001\u0002 \u0006Ab.Z<IS\u001eDWm\u001d;NKR\fG-\u0019;b\u001f\u001a47/\u001a;\u0011\u0007\u0015\n\t+C\u0002\u0002$\u001a\u0012A\u0001T8oO\")Q+\u0006a\u0001-\")\u0001+\u0006a\u0001#\u0006\u0011\u0012N\\5uS\u0006d\u0017N_3NC:\fw-\u001a:t)\t\tY)\u0001\u0011gS:L7\u000f[%oSRL\u0017\r\\5{S:<'+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014H\u0003BAF\u0003cCQ\u0001U\fA\u0002E\u0003")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig conf;
    private final KRaftMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final ClientQuotaMetadataManager clientQuotaMetadataManager;
    private final FinalizedFeatureCache featureCache;
    private final Map<String, ConfigHandler> dynamicConfigHandlers;
    private final int brokerId;
    private boolean _firstPublish;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Iterable<TopicPartition> findStrayPartitions(int brokerId, TopicsImage newTopicsImage, Iterable<AbstractLog> logs) {
        return BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, newTopicsImage, logs);
    }

    public static Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, newImage, delta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    @Override
    public void publish(long newHighestMetadataOffset, MetadataDelta delta, MetadataImage newImage) {
        try {
            try {
                this.metadataCache.setImage(newImage);
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Publishing initial metadata at offset ").append(newHighestMetadataOffset).append(".").toString());
                    this.initializeManagers();
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Publishing metadata at offset ").append(newHighestMetadataOffset).append(".").toString());
                }
                Option$.MODULE$.apply((Object)delta.featuresDelta()).foreach((Function1 & Serializable)featuresDelta -> {
                    this.featureCache.update(featuresDelta, newHighestMetadataOffset);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$4(this, newImage, delta, topicsDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.configsDelta()).foreach((Function1 & Serializable)configsDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$17(this, newImage, configsDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.clientQuotasDelta()).foreach((Function1 & Serializable)clientQuotasDelta -> {
                    this.clientQuotaMetadataManager.update(clientQuotasDelta);
                    return BoxedUnit.UNIT;
                });
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager(newImage);
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Error publishing broker metadata at ").append(newHighestMetadataOffset).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                throw t;
            }
        }
        finally {
            this._firstPublish_$eq(false);
        }
    }

    private void initializeManagers() {
        this.logManager.startup(this.metadataCache.getAllTopics((Option<String>)None$.MODULE$));
        this.replicaManager.startup();
        this.groupCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.offsetsTopicPartitions()))), this.groupCoordinator.startup$default$2());
        this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
    }

    private void finishInitializingReplicaManager(MetadataImage newImage) {
        Iterable<TopicPartition> strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(this.brokerId(), newImage.topics(), this.logManager.allLogs());
        if (strayPartitions.nonEmpty()) {
            this.replicaManager.deleteStrayReplicas(strayPartitions);
        }
        this.replicaManager.startHighWatermarkCheckPointThread();
    }

    public static final /* synthetic */ void $anonfun$publish$6(BrokerMetadataPublisher $this, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> $this.groupCoordinator.onResignation(topicPartition.partition(), (Option<Object>)None$.MODULE$));
        changes.leaders().forEach((topicPartition, partitionInfo) -> $this.groupCoordinator.onElection(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> $this.groupCoordinator.onResignation(topicPartition.partition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$publish$11(BrokerMetadataPublisher $this, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> $this.txnCoordinator.onResignation(topicPartition.partition(), (Option<Object>)None$.MODULE$));
        changes.leaders().forEach((topicPartition, partitionInfo) -> $this.txnCoordinator.onElection(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> $this.txnCoordinator.onResignation(topicPartition.partition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$publish$4(BrokerMetadataPublisher $this, MetadataImage newImage$1, MetadataDelta delta$2, TopicsDelta topicsDelta) {
        $this.replicaManager.applyDelta(newImage$1, topicsDelta);
        if (topicsDelta.topicWasDeleted("__consumer_offsets")) {
            topicsDelta.image().getTopic("__consumer_offsets").partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    $this.groupCoordinator.onResignation(Predef$.MODULE$.Integer2int((Integer)entry.getKey()), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                }
            });
        }
        BrokerMetadataPublisher$.MODULE$.getTopicDelta("__consumer_offsets", newImage$1, delta$2).foreach((Function1 & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$publish$6($this, topicDelta);
            return BoxedUnit.UNIT;
        });
        if (topicsDelta.topicWasDeleted("__transaction_state")) {
            topicsDelta.image().getTopic("__transaction_state").partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    $this.txnCoordinator.onResignation(Predef$.MODULE$.Integer2int((Integer)entry.getKey()), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                }
            });
        }
        BrokerMetadataPublisher$.MODULE$.getTopicDelta("__transaction_state", newImage$1, delta$2).foreach((Function1 & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$publish$11($this, topicDelta);
            return BoxedUnit.UNIT;
        });
        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
        topicsDelta.deletedTopicIds().forEach(id2 -> {
            TopicImage topicImage = topicsDelta.image().getTopic(id2);
            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
        });
        if (deletedTopicPartitions.nonEmpty()) {
            $this.groupCoordinator.handleDeletedPartitions((Seq<TopicPartition>)deletedTopicPartitions, RequestLocal$.MODULE$.NoCaching());
        }
    }

    public static final /* synthetic */ void $anonfun$publish$19(BrokerMetadataPublisher $this, MetadataImage newImage$1, ConfigResource configResource$1, String t) {
        String string;
        Properties newProperties = newImage$1.configs().configProperties(configResource$1);
        String string2 = configResource$1.name();
        switch (string2 == null ? 0 : string2.hashCode()) {
            case 0: {
                if ("".equals(string2)) {
                    string = ConfigEntityName$.MODULE$.Default();
                    break;
                }
            }
            default: {
                string = string2;
            }
        }
        ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)t)).processConfigChanges(string, newProperties);
    }

    public static final /* synthetic */ void $anonfun$publish$17(BrokerMetadataPublisher $this, MetadataImage newImage$1, ConfigurationsDelta configsDelta) {
        configsDelta.changes().keySet().forEach(configResource -> {
            ConfigResource.Type type = configResource.type();
            Object object = ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)ConfigType$.MODULE$.Topic()) : (ConfigResource.Type.BROKER.equals(type) ? new Some((Object)ConfigType$.MODULE$.Broker()) : None$.MODULE$);
            object.foreach((Function1 & Serializable)t -> {
                BrokerMetadataPublisher.$anonfun$publish$19($this, newImage$1, configResource, t);
                return BoxedUnit.UNIT;
            });
        });
    }

    public BrokerMetadataPublisher(KafkaConfig conf, KRaftMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, ClientQuotaMetadataManager clientQuotaMetadataManager, FinalizedFeatureCache featureCache, Map<String, ConfigHandler> dynamicConfigHandlers) {
        this.conf = conf;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.clientQuotaMetadataManager = clientQuotaMetadataManager;
        this.featureCache = featureCache;
        this.dynamicConfigHandlers = dynamicConfigHandlers;
        this.logIdent_$eq(new StringBuilder(30).append("[BrokerMetadataPublisher id=").append(conf.nodeId()).append("] ").toString());
        this.brokerId = conf.nodeId();
        this._firstPublish = true;
    }
}

