/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kafka.controller.KafkaController;
import kafka.network.SocketServer;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetadataThread;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.LinkMode;
import kafka.server.link.LinkMode$Source$;
import kafka.server.link.MetadataListener;
import kafka.server.link.RemoteNetworkClient;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.message.ReverseConnectionRequestData;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\rua\u0001B\u001c9\u0001}B\u0011B\u0014\u0001\u0003\u0002\u0003\u0006IaT+\t\u0011Y\u0003!\u0011!Q\u0001\n]C\u0011B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u00175\t\u0011%\u0004!\u0011!Q\u0001\n)D\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\t{\u0002\u0011\t\u0011)A\u0005}\"Q\u0011q\u0001\u0001\u0003\u0002\u0003\u0006I!!\u0003\t\u0015\u0005U\u0001A!A!\u0002\u0013\t9\u0002\u0003\u0006\u0002 \u0001\u0011\t\u0011)A\u0005\u0003CA!\"a\f\u0001\u0005\u0003\u0005\u000b\u0011BA\u0019\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007B\u0011\"a\u0017\u0001\u0005\u0004%I!!\u0018\t\u0011\u0005=\u0004\u0001)A\u0005\u0003?B\u0011\"!\u001d\u0001\u0005\u0004%I!a\u001d\t\u0011\u0005m\u0005\u0001)A\u0005\u0003kB\u0011\"!(\u0001\u0005\u0004%I!a\u001d\t\u0011\u0005}\u0005\u0001)A\u0005\u0003kB1\"!)\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002$\"Y\u0011Q\u0016\u0001A\u0002\u0003\u0007I\u0011BAX\u0011-\tY\f\u0001a\u0001\u0002\u0003\u0006K!!*\t\u0017\u0005\u0015\u0007\u00011AA\u0002\u0013%\u0011q\u0019\u0005\f\u0003'\u0004\u0001\u0019!a\u0001\n\u0013\t)\u000eC\u0006\u0002Z\u0002\u0001\r\u0011!Q!\n\u0005%\u0007bCAo\u0001\u0001\u0007\t\u0019!C\u0005\u0003?D1\"!<\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002p\"Y\u00111\u001f\u0001A\u0002\u0003\u0005\u000b\u0015BAq\u0011%\t9\u0010\u0001a\u0001\n\u0013\tI\u0010C\u0005\u0003\u0004\u0001\u0001\r\u0011\"\u0003\u0003\u0006!A!\u0011\u0002\u0001!B\u0013\tY\u0010C\u0004\u0003\u000e\u0001!\tEa\u0004\t\u0011\tE\u0001\u0001\"\u00119\u0005'AqA!\u000b\u0001\t\u0003\u0012Y\u0003C\u0004\u0003J\u0001!\tEa\u0013\t\u000f\t\u0015\u0005\u0001\"\u0011\u0003\b\"9!Q\u0014\u0001\u0005\n\t}\u0005b\u0002B[\u0001\u0011%!q\u0017\u0005\b\u0005\u007f\u0003A\u0011\tBa\u0011\u001d\u0011i\r\u0001C!\u0005\u001fDqAa7\u0001\t#\u0012y\u0001C\u0004\u0003^\u0002!\tFa\u0004\t\u0011\t}\u0007\u0001\"\u00019\u0005CD\u0001Ba9\u0001\t\u0003A$Q\u001d\u0005\b\u0005O\u0004A\u0011\u0002Bu\u0011\u001d\u0011y\u000f\u0001C\u0005\u0005cDqA!?\u0001\t\u0013\u0011y\u0001C\u0004\u0003|\u0002!IAa\u0004\t\u000f\tu\b\u0001\"\u0003\u0003\u0010!9!q \u0001\u0005\n\t=\u0001bBB\u0001\u0001\u0011%11\u0001\u0005\b\u0007\u0013\u0001A\u0011CB\u0006\u0011\u001d\u0019y\u0001\u0001C!\u0007#Aqaa\u0005\u0001\t\u0003\u001a\t\u0002C\u0007\u0004\u0016\u0001\u0001\n1!A\u0001\n\u0013\u00199\"\u0016\u0005\u000e\u00073\u0001\u0001\u0013aA\u0001\u0002\u0013%11\u00045\u0003E\rcWo\u001d;fe2Kgn[*pkJ\u001cWmQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0015\tI$(\u0001\u0003mS:\\'BA\u001e=\u0003\u0019\u0019XM\u001d<fe*\tQ(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0001Ei\u0013\t\u0003\u0003\nk\u0011\u0001O\u0005\u0003\u0007b\u0012Ad\u00117vgR,'\u000fT5oW\u000e{gN\\3di&|g.T1oC\u001e,'\u000f\u0005\u0002F\u0011:\u0011\u0011IR\u0005\u0003\u000fb\n!c\u00117vgR,'\u000fT5oW\u001a\u000b7\r^8ss&\u0011\u0011J\u0013\u0002\u0018'>,(oY3D_:tWm\u0019;j_:l\u0015M\\1hKJT!a\u0012\u001d\u0011\u0005\u0005c\u0015BA'9\u0005AiU\r^1eCR\fG*[:uK:,'/\u0001\u0005mS:\\G)\u0019;b!\t\u00016+D\u0001R\u0015\t\u0011F(\u0001\u0002{W&\u0011A+\u0015\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC&\u0011aJQ\u0001\u000eS:LG/[1m\u0007>tg-[4\u0011\u0005\u0005C\u0016BA-9\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001\u0014Y>\u001c\u0017\r\u001c'pO&\u001c\u0017\r\\\"mkN$XM\u001d\t\u00039\u0016t!!X2\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001t\u0014A\u0002\u001fs_>$hHC\u0001c\u0003\u0015\u00198-\u00197b\u0013\t!\u0017-\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u0014aa\u0015;sS:<'B\u00013b\u0013\tQ&)A\tdY&,g\u000e^%oi\u0016\u00148-\u001a9u_J\u00042a\u001b7o\u001b\u0005\t\u0017BA7b\u0005\u0019y\u0005\u000f^5p]B\u0011qn^\u0007\u0002a*\u0011\u0011O]\u0001\bG2LWM\u001c;t\u0015\ti4O\u0003\u0002uk\u00061\u0011\r]1dQ\u0016T\u0011A^\u0001\u0004_J<\u0017B\u0001=q\u0005E\u0019E.[3oi&sG/\u001a:dKB$xN]\u0001\b[\u0016$(/[2t!\t\t50\u0003\u0002}q\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003)\u0019wN\u001c;s_2dWM\u001d\t\u0004\u007f\u0006\rQBAA\u0001\u0015\tiH(\u0003\u0003\u0002\u0006\u0005\u0005!aD&bM.\f7i\u001c8ue>dG.\u001a:\u0002\u0019M|7m[3u'\u0016\u0014h/\u001a:\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004=\u0003\u001dqW\r^<pe.LA!a\u0005\u0002\u000e\ta1k\\2lKR\u001cVM\u001d<fe\u0006a!M]8lKJ\u001cuN\u001c4jOB!\u0011\u0011DA\u000e\u001b\u0005Q\u0014bAA\u000fu\tY1*\u00194lC\u000e{gNZ5h\u0003)\u0019XM\u001d<fe&sgm\u001c\t\u0005\u0003G\tY#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003)\tW\u000f\u001e5pe&TXM\u001d\u0006\u0003wILA!!\f\u0002&\t!\u0012)\u001e;i_JL'0\u001a:TKJ4XM]%oM>\fA\u0001^5nKB!\u00111GA\u001f\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012!B;uS2\u001c(bAA\u001ee\u000611m\\7n_:LA!a\u0010\u00026\t!A+[7f\u0003\u0019a\u0014N\\5u}Q1\u0012QIA$\u0003\u0013\nY%!\u0014\u0002P\u0005E\u00131KA+\u0003/\nI\u0006\u0005\u0002B\u0001!)aj\u0003a\u0001\u001f\")ak\u0003a\u0001/\")!l\u0003a\u00017\")\u0011n\u0003a\u0001U\")\u0011p\u0003a\u0001u\")Qp\u0003a\u0001}\"9\u0011qA\u0006A\u0002\u0005%\u0001bBA\u000b\u0017\u0001\u0007\u0011q\u0003\u0005\b\u0003?Y\u0001\u0019AA\u0011\u0011\u001d\tyc\u0003a\u0001\u0003c\tAcY8o]\u0016\u001cG/[8o+B$\u0017\r^3M_\u000e\\WCAA0!\u0011\t\t'a\u001b\u000e\u0005\u0005\r$\u0002BA3\u0003O\nA\u0001\\1oO*\u0011\u0011\u0011N\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002n\u0005\r$AB(cU\u0016\u001cG/A\u000bd_:tWm\u0019;j_:,\u0006\u000fZ1uK2{7m\u001b\u0011\u0002+A,'o]5ti\u0016tGoQ8o]\u0016\u001cG/[8ogV\u0011\u0011Q\u000f\t\t\u0003o\n\t)!\"\u0002\f6\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(\u0001\u0006d_:\u001cWO\u001d:f]RTA!a \u0002h\u0005!Q\u000f^5m\u0013\u0011\t\u0019)!\u001f\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000fE\u0002l\u0003\u000fK1!!#b\u0005\rIe\u000e\u001e\t\u0005\u0003\u001b\u000b9*\u0004\u0002\u0002\u0010*!\u0011\u0011SAJ\u0003!\u0019\u0007.\u00198oK2\u001c(\u0002BAK\u0003O\n1A\\5p\u0013\u0011\tI*a$\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003Y\u0001XM]:jgR,g\u000e^\"p]:,7\r^5p]N\u0004\u0013\u0001G1di&4XMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8og\u0006I\u0012m\u0019;jm\u0016\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\\:!\u0003Qa\u0017N\\6MSN$XM\\3s\u000b:$\u0007o\\5oiV\u0011\u0011Q\u0015\t\u0005\u0003O\u000bI+\u0004\u0002\u0002:%!\u00111VA\u001d\u0005!)e\u000e\u001a9pS:$\u0018\u0001\u00077j].d\u0015n\u001d;f]\u0016\u0014XI\u001c3q_&tGo\u0018\u0013fcR!\u0011\u0011WA\\!\rY\u00171W\u0005\u0004\u0003k\u000b'\u0001B+oSRD\u0011\"!/\u0014\u0003\u0003\u0005\r!!*\u0002\u0007a$\u0013'A\u000bmS:\\G*[:uK:,'/\u00128ea>Lg\u000e\u001e\u0011)\u0007Q\ty\fE\u0002l\u0003\u0003L1!a1b\u0005!1x\u000e\\1uS2,\u0017\u0001\u00057j].d\u0015n\u001d;f]\u0016\u0014h*Y7f+\t\tI\r\u0005\u0003\u0002L\u0006=WBAAg\u0015\u0011\ty!!\u000f\n\t\u0005E\u0017Q\u001a\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0015Y&t7\u000eT5ti\u0016tWM\u001d(b[\u0016|F%Z9\u0015\t\u0005E\u0016q\u001b\u0005\n\u0003s3\u0012\u0011!a\u0001\u0003\u0013\f\u0011\u0003\\5oW2K7\u000f^3oKJt\u0015-\\3!Q\r9\u0012qX\u0001\u000bY>\u001c\u0017\r\\!e[&tWCAAq!\u0011\t\u0019/!;\u000e\u0005\u0005\u0015(bAAta\u0006)\u0011\rZ7j]&!\u00111^As\u00059\u0019uN\u001c4mk\u0016tG/\u00113nS:\fa\u0002\\8dC2\fE-\\5o?\u0012*\u0017\u000f\u0006\u0003\u00022\u0006E\b\"CA]3\u0005\u0005\t\u0019AAq\u0003-awnY1m\u0003\u0012l\u0017N\u001c\u0011)\u0007i\ty,A\nsK6|G/\u001a(fi^|'o[\"mS\u0016tG/\u0006\u0002\u0002|B!1\u000e\\A\u007f!\r\t\u0015q`\u0005\u0004\u0005\u0003A$a\u0005*f[>$XMT3uo>\u00148n\u00117jK:$\u0018a\u0006:f[>$XMT3uo>\u00148n\u00117jK:$x\fJ3r)\u0011\t\tLa\u0002\t\u0013\u0005eF$!AA\u0002\u0005m\u0018\u0001\u0006:f[>$XMT3uo>\u00148n\u00117jK:$\b\u0005K\u0002\u001e\u0003\u007f\u000bqa\u001d;beR,\b\u000f\u0006\u0002\u00022\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0019\t\tL!\u0006\u0003\u001a!1!qC\u0010A\u0002]\u000b\u0011B\\3x\u0007>tg-[4\t\u000f\tmq\u00041\u0001\u0003\u001e\u0005YQ\u000f\u001d3bi\u0016$7*Z=t!\u0015\u0011yB!\n\\\u001b\t\u0011\tCC\u0002\u0003$\u0005\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119C!\t\u0003\u0007M+G/A\tf]\u0006\u0014G.Z\"mkN$XM\u001d'j].$b!!-\u0003.\t]\u0002b\u0002B\u0018A\u0001\u0007!\u0011G\u0001\u000e]\u0016$xo\u001c:l\u00072LWM\u001c;\u0011\u0007\u0005\u0013\u0019$C\u0002\u00036a\u0012\u0001d\u00117vgR,'\u000fT5oW:+Go^8sW\u000ec\u0017.\u001a8u\u0011\u001d\u0011I\u0004\ta\u0001\u0005w\tq\"\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\t\u0005W2\u0014i\u0004\u0005\u0003\u0003@\t\u0015SB\u0001B!\u0015\u0011\u0011\u0019%!:\u0002\u0013%tG/\u001a:oC2\u001c\u0018\u0002\u0002B$\u0005\u0003\u0012A#\u00113nS:lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018AG5oSRL\u0017\r^3SKZ,'o]3D_:tWm\u0019;j_:\u001cHC\u0002B'\u0005W\u0012Y\b\u0005\u0004\u0003P\te#q\f\b\u0005\u0005#\u0012)FD\u0002_\u0005'J\u0011AY\u0005\u0004\u0005/\n\u0017a\u00029bG.\fw-Z\u0005\u0005\u00057\u0012iFA\u0002TKFT1Aa\u0016b!\u0019\t9H!\u0019\u0003f%!!1MA=\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0005\u0003C\u00129'\u0003\u0003\u0003j\u0005\r$\u0001\u0002,pS\u0012DqA!\u001c\"\u0001\u0004\u0011y'A\rj]&$\u0018.\u0019;f\u0007>tg.Z2uS>t'+Z9vKN$\b\u0003\u0002B9\u0005oj!Aa\u001d\u000b\t\tU\u0014\u0011H\u0001\te\u0016\fX/Z:ug&!!\u0011\u0010B:\u0005\u0005Je.\u001b;jCR,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8t%\u0016\fX/Z:u\u0011\u001d\u0011i(\ta\u0001\u0005\u007f\naB]3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0003\u0003r\t\u0005\u0015\u0002\u0002BB\u0005g\u0012aBU3rk\u0016\u001cHoQ8oi\u0016DH/A\np]J+g/\u001a:tK\u000e{gN\\3di&|g\u000e\u0006\u0004\u00022\n%%1\u0013\u0005\b\u0005\u0017\u0013\u0003\u0019\u0001BG\u0003\u001d\u0019\u0007.\u00198oK2\u0004B!a3\u0003\u0010&!!\u0011SAg\u00051Y\u0015MZ6b\u0007\"\fgN\\3m\u0011\u001d\u0011)J\ta\u0001\u0005/\u000b1B]3wKJ\u001cXMT8eKB!\u00111\u001aBM\u0013\u0011\u0011Y*!4\u0003\u0017I+g/\u001a:tK:{G-Z\u0001\u0017M>\u0014x/\u0019:e)>\u001cv.\u001e:dK\n\u0013xn[3sgR1\u0011\u0011\u0017BQ\u0005cCqAa)$\u0001\u0004\u0011)+A\u0006sKF,Xm\u001d;ECR\f\u0007\u0003\u0002BT\u0005[k!A!+\u000b\t\t-\u0016\u0011H\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0011yK!+\u0003K%s\u0017\u000e^5bi\u0016\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\\:SKF,Xm\u001d;ECR\f\u0007b\u0002BZG\u0001\u0007!QJ\u0001\bMV$XO]3t\u0003a\u0019'/Z1uKJ+g/\u001a:tK\u000e{gN\\3di&|gn\u001d\u000b\t\u0003c\u0013ILa/\u0003>\"9!1\u0015\u0013A\u0002\t\u0015\u0006b\u0002B?I\u0001\u0007!q\u0010\u0005\b\u0005g#\u0003\u0019\u0001B'\u00035ygNT3x\u001b\u0016$\u0018\rZ1uCR!\u0011\u0011\u0017Bb\u0011\u001d\u0011)-\na\u0001\u0005\u000f\f!B\\3x\u00072,8\u000f^3s!\u0011\t9K!3\n\t\t-\u0017\u0011\b\u0002\b\u00072,8\u000f^3s\u0003IygnQ8oiJ|G\u000e\\3s\u0007\"\fgnZ3\u0015\t\u0005E&\u0011\u001b\u0005\b\u0005'4\u0003\u0019\u0001Bk\u0003!I7/Q2uSZ,\u0007cA6\u0003X&\u0019!\u0011\\1\u0003\u000f\t{w\u000e\\3b]\u0006Y2\r\\8tKJ+g/\u001a:tK\u000e{gN\\3di&|g.\u00113nS:\fAd\u0019:fCR,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8BI6Lg.A\tde\u0016\fG/\u001a*f[>$X-\u00113nS:$\"!!@\u0002!\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\\!e[&tGCAAq\u0003I)\b\u000fZ1uK2Kgn\u001b'jgR,g.\u001a:\u0015\t\u0005E&1\u001e\u0005\u0007\u0005[\\\u0003\u0019A,\u0002\r\r|gNZ5h\u00031\u0011XM^3sg\u0006dG)\u0019;b+\t\u0011\u0019\u0010\u0005\u0003\u0003(\nU\u0018\u0002\u0002B|\u0005S\u0013ADU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o%\u0016\fX/Z:u\t\u0006$\u0018-A\u0010nCf\u0014Wm\u0011:fCR,\u0007+\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:\fQC]3rk\u0016\u001cH/T3uC\u0012\fG/Y+qI\u0006$X-\u0001\u000edY>\u001cX\rU3sg&\u001cH/\u001a8u\u0007>tg.Z2uS>t7/A\u000fdY>\u001cX-Q2uSZ,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8t\u0003A\u0019xnY6fi\u000eC\u0017M\u001c8fY.+\u0017\u0010\u0006\u0003\u0002\u0006\u000e\u0015\u0001bBB\u0004c\u0001\u0007\u00111R\u0001\u000eg>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0002%\rdwn]3T_\u000e\\W\r^\"iC:tW\r\u001c\u000b\u0005\u0003c\u001bi\u0001C\u0004\u0004\bI\u0002\r!a#\u00023A,'o]5ti\u0016tGoQ8o]\u0016\u001cG/[8o\u0007>,h\u000e^\u000b\u0003\u0003\u000b\u000baC]3wKJ\u001cXmQ8o]\u0016\u001cG/[8o\u0007>,h\u000e^\u0001\u000fgV\u0004XM\u001d\u0013mS:\\G)\u0019;b+\u0005y\u0015!G:va\u0016\u0014H\u0005\\8dC2dunZ5dC2\u001cE.^:uKJ,\u0012a\u0017")
public class ClusterLinkSourceConnectionManager
extends ClusterLinkConnectionManager
implements ClusterLinkFactory.SourceConnectionManager,
MetadataListener {
    private final Option<ClientInterceptor> clientInterceptor;
    private final ClusterLinkMetrics metrics;
    private final KafkaController controller;
    private final SocketServer socketServer;
    private final KafkaConfig brokerConfig;
    private final AuthorizerServerInfo serverInfo;
    private final Time time;
    private final Object connectionUpdateLock;
    private final ConcurrentHashMap<Object, SocketChannel> persistentConnections;
    private final ConcurrentHashMap<Object, SocketChannel> activeReverseConnections;
    private volatile Endpoint linkListenerEndpoint;
    private volatile ListenerName linkListenerName;
    private volatile ConfluentAdmin localAdmin;
    private volatile Option<RemoteNetworkClient> remoteNetworkClient;

    @Override
    public void onMetadataFailure(Exception e) {
        MetadataListener.onMetadataFailure$(this, e);
    }

    private /* synthetic */ ClusterLinkData super$linkData() {
        return super.linkData();
    }

    private /* synthetic */ String super$localLogicalCluster() {
        return super.localLogicalCluster();
    }

    private Object connectionUpdateLock() {
        return this.connectionUpdateLock;
    }

    private ConcurrentHashMap<Object, SocketChannel> persistentConnections() {
        return this.persistentConnections;
    }

    private ConcurrentHashMap<Object, SocketChannel> activeReverseConnections() {
        return this.activeReverseConnections;
    }

    private Endpoint linkListenerEndpoint() {
        return this.linkListenerEndpoint;
    }

    private void linkListenerEndpoint_$eq(Endpoint x$1) {
        this.linkListenerEndpoint = x$1;
    }

    private ListenerName linkListenerName() {
        return this.linkListenerName;
    }

    private void linkListenerName_$eq(ListenerName x$1) {
        this.linkListenerName = x$1;
    }

    private ConfluentAdmin localAdmin() {
        return this.localAdmin;
    }

    private void localAdmin_$eq(ConfluentAdmin x$1) {
        this.localAdmin = x$1;
    }

    private Option<RemoteNetworkClient> remoteNetworkClient() {
        return this.remoteNetworkClient;
    }

    private void remoteNetworkClient_$eq(Option<RemoteNetworkClient> x$1) {
        this.remoteNetworkClient = x$1;
    }

    @Override
    public void startup() {
        block3: {
            block2: {
                LinkMode linkMode = this.currentConfig().linkMode();
                LinkMode$Source$ linkMode$Source$ = LinkMode$Source$.MODULE$;
                if (linkMode == null || !linkMode.equals(linkMode$Source$)) break block2;
                ConnectionMode connectionMode = this.currentConfig().connectionMode();
                ConnectionMode$Outbound$ connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
                if (connectionMode != null && connectionMode.equals(connectionMode$Outbound$)) break block3;
            }
            throw new IllegalStateException("Source connection manager is supported only for source initiated links");
        }
        super.startup();
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        if (updatedKeys.contains((Object)ClusterLinkConfig$.MODULE$.LocalListenerNameProp())) {
            this.updateLinkListener(this.currentConfig());
        }
        super.reconfigure(newConfig, updatedKeys);
        if (updatedKeys.exists((Function1 & Serializable)configName -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfig$.MODULE$.needsConnectionResetOnUpdate(configName)))) {
            this.closeActiveReverseConnections();
        }
    }

    @Override
    public void enableClusterLink(ClusterLinkNetworkClient networkClient, Option<AdminMetadataManager> metadataManager) {
        KafkaClient kafkaClient = networkClient.networkClient();
        if (kafkaClient instanceof NetworkClient) {
            ((NetworkClient)kafkaClient).enableSourceClusterLink(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.reversalData(), (ReverseNode.ReverseCallback)this);
            return;
        }
        ConnectionMode connectionMode = this.currentConfig().connectionMode();
        ConnectionMode$Outbound$ connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
        if (connectionMode == null) {
            return;
        }
        if (connectionMode.equals(connectionMode$Outbound$)) {
            throw new IllegalStateException("Reverse connections are supported only with NetworkClient");
        }
    }

    public Seq<CompletableFuture<Void>> initiateReverseConnections(InitiateReverseConnectionsRequest initiateConnectionRequest, RequestContext requestContext) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Initiate or forward reverse connection request: ").append(initiateConnectionRequest).toString());
        this.ensureReverseConnectionsEnabled();
        InitiateReverseConnectionsRequestData connData = initiateConnectionRequest.data();
        List futures = (List)package$.MODULE$.List().fill(connData.entries().size(), (Function0 & Serializable)() -> new CompletableFuture());
        try {
            String string = connData.sourceClusterId();
            String string2 = super.localLogicalCluster();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new InvalidRequestException(new StringBuilder(67).append("Initiate reverse request for cluster ").append(connData.sourceClusterId()).append(" sent to wrong source cluster ").append(super.localLogicalCluster()).toString());
            }
            if (connData.forwardToBroker()) {
                this.forwardToSourceBrokers(connData, (Seq<CompletableFuture<Void>>)futures);
            } else {
                this.createReverseConnections(connData, requestContext, (Seq<CompletableFuture<Void>>)futures);
            }
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Failing reverse connection request", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            futures.foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.completeExceptionally(e)));
        }
        return futures;
    }

    public void onReverseConnection(KafkaChannel channel2, ReverseNode reverseNode) {
        Optional requestId = reverseNode.requestId();
        int remoteBrokerId = reverseNode.remoteBrokerId();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Destination has successfully reversed channel ").append(channel2).append(" with requestId ").append(requestId).append(" remoteBrokerId ").append(remoteBrokerId).toString());
        this.ensureReverseConnectionsEnabled();
        if (!requestId.isPresent() && !this.controller.isActive()) {
            String errorMessage = new StringBuilder(82).append("Discarding persistent reverse connection since broker ").append(this.brokerConfig.brokerId()).append(" is no longer the controller").toString();
            this.debug((Function0<String>)(Function0 & Serializable)() -> errorMessage);
            throw new NotControllerException(errorMessage);
        }
        SocketChannel socketChannel = channel2.socketChannel();
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.activeReverseConnections().put(BoxesRunTime.boxToInteger((int)System.identityHashCode(socketChannel)), socketChannel);
            if (!requestId.isPresent()) {
                if (Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)remoteBrokerId))).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isConnected()))) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Ignoring persistent connection because a connection already exists for ").append(remoteBrokerId).toString());
                    throw new IllegalStateException(new StringBuilder(41).append("A persistent connection is available for ").append(remoteBrokerId).toString());
                }
                this.persistentConnections().put(BoxesRunTime.boxToInteger((int)remoteBrokerId), socketChannel);
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Created persistent connection to ").append(remoteBrokerId).append(", channel=").append(channel2).toString());
            }
        }
        this.metrics.reverseConnectionCreatedSensor().record();
        ReverseChannel reverseChannel = new ReverseChannel(channel2, reverseNode, channel -> this.closeCallback$1((KafkaChannel)channel, socketChannel, requestId, remoteBrokerId));
        this.socketServer.reverseAndAdd(this.linkListenerName(), reverseChannel);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Added reverse connection ").append(channel2).append(" to source socket server, requestId=").append(requestId).toString());
    }

    private void forwardToSourceBrokers(InitiateReverseConnectionsRequestData requestData, Seq<CompletableFuture<Void>> futures) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Forward initiate reverse connection request from source controller to source brokers: ").append(requestData).toString());
        ConfluentAdmin admin = this.localAdmin();
        scala.collection.immutable.Map resultFutures = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().zip(futures)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)x0$1._1();
            CompletableFuture future = (CompletableFuture)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)entry.initiateRequestId())), (Object)future);
            return tuple2;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().groupBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.sourceBrokerId())).foreach((Function1 & Serializable)x0$2 -> {
            ClusterLinkSourceConnectionManager.$anonfun$forwardToSourceBrokers$4(this, requestData, admin, resultFutures, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private void createReverseConnections(InitiateReverseConnectionsRequestData requestData, RequestContext requestContext, Seq<CompletableFuture<Void>> futures) {
        NetworkClient networkClient = ((RemoteNetworkClient)this.remoteNetworkClient().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Remote client connection manager not available");
        })).networkClient();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Create reverse connections from source brokers to destination brokers: ").append(requestData).toString());
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().zip(futures)).foreach((Function1 & Serializable)x0$1 -> {
            Object object;
            if (x0$1 != null) {
                InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)x0$1._1();
                CompletableFuture future = (CompletableFuture)x0$1._2();
                try {
                    if (entry.sourceBrokerId() == $this.brokerConfig.brokerId() || entry.sourceBrokerId() == -1) {
                        ReverseNode reverseNode = networkClient.reverseConnectionManager().createReversibleConnection(entry.initiateRequestId(), entry.targetBrokerId(), requestContext$1.listenerName, requestContext$1.principal, $this.time.milliseconds());
                        object = reverseNode.future().whenComplete((x0$2, x1$1) -> {
                            if (x1$1 != null) {
                                $this.metrics.sourceReverseConnectionFailedSensor().record();
                                networkClient.requestClusterLinkMetadataUpdate();
                                future.completeExceptionally((Throwable)x1$1);
                                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Failed to reverse connection for ").append(reverseNode).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> x1$1);
                                return;
                            }
                            future.complete(x0$2);
                            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Completed connection reversal for ").append(reverseNode).toString());
                        });
                    } else {
                        object = BoxesRunTime.boxToBoolean((boolean)future.completeExceptionally(new InvalidRequestException(new StringBuilder(49).append("Incorrect source broker id, expected ").append($this.brokerConfig.brokerId()).append(", requested ").append(entry.sourceBrokerId()).toString())));
                    }
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Failed to reverse connection for request ").append(requestData).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    object = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError(null);
            }
            BoxedUnit boxedUnit = object;
            return boxedUnit;
        });
    }

    @Override
    public void onNewMetadata(Cluster newCluster) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Process remote metadata: isActiveController=").append($this.controller.isActive()).append(" remoteController=").append(newCluster.controller()).toString());
        this.maybeCreatePersistentConnection();
        this.updateActiveLinkCount();
    }

    @Override
    public void onControllerChange(boolean isActive) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Process local controller change, isActiveController=").append(isActive).toString());
        if (!isActive) {
            this.closePersistentConnections();
        }
        if (isActive) {
            this.maybeCreatePersistentConnection();
        }
    }

    @Override
    public void closeReverseConnectionAdmin() {
        this.remoteNetworkClient().foreach((Function1 & Serializable)x$7 -> {
            x$7.shutdown();
            return BoxedUnit.UNIT;
        });
        if (this.localAdmin() != null) {
            this.localAdmin().close(Duration.ZERO);
        }
    }

    @Override
    public void createReverseConnectionAdmin() {
        this.localAdmin_$eq(this.createLocalAdmin());
        this.remoteNetworkClient_$eq((Option<RemoteNetworkClient>)new Some((Object)this.createRemoteAdmin()));
        this.maybeCreatePersistentConnection();
    }

    public RemoteNetworkClient createRemoteAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        ClusterLinkMetadata metadata = new ClusterLinkMetadata(this.brokerConfig, super.linkData().linkName(), super.linkData().linkId(), config.linkMode(), Predef$.MODULE$.Long2long(config.metadataRefreshBackoffMs()), Predef$.MODULE$.Long2long(config.metadataMaxAgeMs()));
        java.util.List addresses = ClientUtils.parseAndValidateAddresses(config.bootstrapServers(), (ClientDnsLookup)config.dnsLookup());
        metadata.bootstrap(addresses);
        ClusterLinkMetadataThread metadataRefreshThread = new ClusterLinkMetadataThread(config, (Option<ClusterLinkDestConnectionManager>)None$.MODULE$, metadata, this.metrics.metrics(), this.time);
        metadataRefreshThread.addListener(this);
        metadataRefreshThread.start();
        NetworkClient networkClient = (NetworkClient)metadataRefreshThread.clusterLinkClient().networkClient();
        networkClient.enableSourceClusterLink(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.reversalData(), (ReverseNode.ReverseCallback)this);
        return new RemoteNetworkClient(networkClient, metadataRefreshThread);
    }

    public ConfluentAdmin createLocalAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Creating local admin for reverse connections from source cluster on listener ").append(this.linkListenerEndpoint()).toString());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(this.brokerConfig.originals());
        config.localClientConfigOverrides().forEach((x0$1, x1$1) -> props.put((String)x0$1, x1$1));
        Map adminConfigs = ConfluentConfigs.interBrokerClientConfigs(props, (Endpoint)this.linkListenerEndpoint());
        adminConfigs.remove("metric.reporters");
        adminConfigs.put("client.id", new StringBuilder(38).append("cluster-link-").append(super.linkData().linkName()).append("-local-source-conn-admin-").append(this.brokerConfig.brokerId()).toString());
        config.localClientConfigOverrides().forEach((x0$2, x1$2) -> adminConfigs.put(x0$2, x1$2));
        return (ConfluentAdmin)Admin.create((Map)adminConfigs);
    }

    private void updateLinkListener(ClusterLinkConfig config) {
        this.linkListenerEndpoint_$eq(this.serverInfo.endpoints().stream().filter(x$8 -> {
            Optional optional = x$8.listenerName();
            Optional<String> optional2 = Optional.of(config.localListenerName());
            return !(optional != null ? !((Object)optional).equals(optional2) : optional2 != null);
        }).findFirst().orElseThrow(() -> new InvalidRequestException(new StringBuilder(19).append("Listener ").append(config.localListenerName()).append(" not found").toString())));
        this.linkListenerName_$eq(new ListenerName((String)this.linkListenerEndpoint().listenerName().orElseThrow(() -> new IllegalStateException("Listener name not set"))));
    }

    private ReverseConnectionRequestData reversalData() {
        Endpoint endpoint = this.linkListenerEndpoint();
        return new ReverseConnectionRequestData().setClusterLinkId(this.linkId()).setTargetClusterId((String)super.linkData().clusterId().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Remote cluster id not known");
        })).setSourceClusterId(super.localLogicalCluster()).setSourceBrokerId(this.brokerConfig.brokerId()).setSourceHost(endpoint.host()).setSourcePort(endpoint.port());
    }

    private void maybeCreatePersistentConnection() {
        if (this.controller.isActive()) {
            this.remoteNetworkClient().foreach((Function1 & Serializable)client -> {
                Node remoteController = client.metadataRefreshThread().clusterLinkMetadata().fetch().controller();
                if (remoteController == null || remoteController.id() < 0) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Remote controller not known, request metadata");
                    this.requestMetadataUpdate();
                    return BoxedUnit.UNIT;
                }
                if (!Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)remoteController.id()))).exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isConnected()))) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Creating persistent connection to remote controller ").append(remoteController).toString());
                    InitiateReverseConnectionsRequestData requestData = new InitiateReverseConnectionsRequestData().setClusterLinkId(new Uuid(this.super$linkData().linkId().getMostSignificantBits(), this.super$linkData().linkId().getLeastSignificantBits())).setForwardToBroker(false).setTimeoutMs(Predef$.MODULE$.Integer2int(this.currentConfig().reverseConnectionSetupTimeoutMs())).setSourceClusterId(this.super$localLogicalCluster()).setTargetClusterId((String)this.super$linkData().clusterId().getOrElse((Function0 & Serializable)() -> {
                        throw new IllegalStateException("Remote cluster id not known");
                    })).setEntries(Collections.singletonList(new InitiateReverseConnectionsRequestData.EntryData().setInitiateRequestId(-1).setSourceBrokerId($this.brokerConfig.brokerId()).setTargetBrokerId(remoteController.id())));
                    CompletableFuture future = new CompletableFuture();
                    this.forwardToSourceBrokers(requestData, (Seq<CompletableFuture<Void>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CompletableFuture[]{future}))));
                    return future.whenComplete((x0$1, x1$1) -> {
                        if (x1$1 != null) {
                            this.warn((Function0<String>)(Function0 & Serializable)() -> "Failed to create persistent reverse connection", (Function0<Throwable>)(Function0 & Serializable)() -> x1$1);
                            this.requestMetadataUpdate();
                            return;
                        }
                        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Successfully created persistent connection to ").append(remoteController).toString());
                    });
                }
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Not creating persistent connection, remoteController=").append(remoteController).append(", persistentConnections=").append(this.persistentConnections()).toString());
                return BoxedUnit.UNIT;
            });
        }
    }

    private void requestMetadataUpdate() {
        if (this.isActive()) {
            try {
                this.remoteNetworkClient().foreach((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)ClusterLinkSourceConnectionManager.$anonfun$requestMetadataUpdate$1(x$10)));
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to request metadata refresh", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
        }
    }

    private void closePersistentConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Closing persistent connections");
            this.persistentConnections().values().forEach(socketChannel -> {
                this.closeSocketChannel((SocketChannel)socketChannel);
                if (this.activeReverseConnections().remove(BoxesRunTime.boxToInteger((int)System.identityHashCode(socketChannel))) != null) {
                    $this.metrics.reverseConnectionClosedSensor().record();
                }
            });
            this.persistentConnections().clear();
            return;
        }
    }

    private void closeActiveReverseConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Closing active reverse connections");
            this.activeReverseConnections().values().forEach(socketChannel -> {
                this.closeSocketChannel((SocketChannel)socketChannel);
                $this.metrics.reverseConnectionClosedSensor().record();
            });
            this.activeReverseConnections().clear();
            this.persistentConnections().clear();
            return;
        }
    }

    private int socketChannelKey(SocketChannel socketChannel) {
        return System.identityHashCode(socketChannel);
    }

    public void closeSocketChannel(SocketChannel socketChannel) {
        try {
            socketChannel.close();
            return;
        }
        catch (Exception e) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Failed to close socket channel ").append(socketChannel).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
    }

    @Override
    public int persistentConnectionCount() {
        return this.persistentConnections().size();
    }

    @Override
    public int reverseConnectionCount() {
        return this.activeReverseConnections().size();
    }

    private final void closeCallback$1(KafkaChannel channel, SocketChannel socketChannel$1, Optional requestId$1, int remoteBrokerId$1) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Reverse channel ").append(channel).append(" has been disconnected").toString());
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            boolean bl2;
            if (this.activeReverseConnections().remove(BoxesRunTime.boxToInteger((int)System.identityHashCode(socketChannel$1))) != null) {
                this.metrics.reverseConnectionClosedSensor().record();
            }
            if (!requestId$1.isPresent() && this.persistentConnections().remove(BoxesRunTime.boxToInteger((int)remoteBrokerId$1)) != null) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Removed persistent connection for ").append(remoteBrokerId$1).append(" because channel ").append(channel.id()).append(" was closed").toString());
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        if (bl) {
            this.requestMetadataUpdate();
        }
    }

    public static final /* synthetic */ boolean $anonfun$forwardToSourceBrokers$10(int brokerId$1, scala.collection.immutable.Map resultFutures$1, InitiateReverseConnectionsRequestData.EntryData entry) {
        NetworkException e = new NetworkException(new StringBuilder(39).append("Source broker with id ").append(brokerId$1).append(" is not available").toString());
        return ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)entry.initiateRequestId()))).completeExceptionally((Throwable)e);
    }

    public static final /* synthetic */ void $anonfun$forwardToSourceBrokers$4(ClusterLinkSourceConnectionManager $this, InitiateReverseConnectionsRequestData requestData$1, ConfluentAdmin admin$1, scala.collection.immutable.Map resultFutures$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            int brokerId = x0$2._1$mcI$sp();
            Buffer entries = (Buffer)x0$2._2();
            if (brokerId == -1 || $this.brokerConfig.brokerId() == brokerId || $this.controller.controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)brokerId))) {
                InitiateReverseConnectionsRequestData brokerRequest = new InitiateReverseConnectionsRequestData().setClusterLinkId(requestData$1.clusterLinkId()).setSourceClusterId(requestData$1.sourceClusterId()).setTargetClusterId(requestData$1.targetClusterId()).setForwardToBroker(false).setEntries(CollectionConverters$.MODULE$.BufferHasAsJava(entries).asJava());
                ConfluentAdminUtils.initiateReverseConnections((ConfluentAdmin)admin$1, (InitiateReverseConnectionsRequestData)brokerRequest, (Integer)Predef$.MODULE$.int2Integer(brokerId)).forEach((x0$3, x1$1) -> x1$1.whenComplete((x0$4, x1$2) -> {
                    if (x1$2 != null) {
                        ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x0$3)))).completeExceptionally((Throwable)x1$2);
                        $this.metrics.sourceReverseConnectionFailedSensor().record();
                        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Connection reversal request to local broker failed for requestId=").append(x0$3).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> x1$2);
                        return;
                    }
                    ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x0$3)))).complete(x0$4);
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Completed initiate reversal request for requestId=").append(x0$3).toString());
                }));
                return;
            }
            entries.foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSourceConnectionManager.$anonfun$forwardToSourceBrokers$10(brokerId, resultFutures$1, entry)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$requestMetadataUpdate$1(RemoteNetworkClient x$10) {
        return x$10.metadataRefreshThread().clusterLinkMetadata().requestUpdate();
    }

    public ClusterLinkSourceConnectionManager(ClusterLinkData linkData, ClusterLinkConfig initialConfig, String localLogicalCluster, Option<ClientInterceptor> clientInterceptor, ClusterLinkMetrics metrics, KafkaController controller, SocketServer socketServer, KafkaConfig brokerConfig, AuthorizerServerInfo serverInfo, Time time) {
        this.clientInterceptor = clientInterceptor;
        this.metrics = metrics;
        this.controller = controller;
        this.socketServer = socketServer;
        this.brokerConfig = brokerConfig;
        this.serverInfo = serverInfo;
        this.time = time;
        super(linkData, initialConfig, localLogicalCluster, metrics);
        this.connectionUpdateLock = new Object();
        this.persistentConnections = new ConcurrentHashMap();
        this.activeReverseConnections = new ConcurrentHashMap();
        this.remoteNetworkClient = None$.MODULE$;
        this.logIdent_$eq(new StringBuilder(46).append("[ClusterLinkSourceConnectionManager-").append(super.linkData().linkName()).append("-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        this.updateLinkListener(initialConfig);
    }
}

