/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.Constants$;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.QuotaType;
import kafka.server.QuotaType$ClusterLinkReplication$;
import kafka.server.QuotaType$FollowerReplication$;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.server.SensorAccess;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005Eh\u0001B\u0014)\u00015B\u0001\"\u0011\u0001\u0003\u0006\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u0007\"Aq\t\u0001BC\u0002\u0013%\u0001\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003J\u0011%1\u0006A!b\u0001\n#As\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003Y\u0011!a\u0006A!b\u0001\n\u0013i\u0006\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u000b\u0011\u0004A\u0011A3\t\u000f-\u0004!\u0019!C\u0005Y\"1\u0011\u0010\u0001Q\u0001\n5DqA\u001f\u0001C\u0002\u0013%1\u0010C\u0004\u0002*\u0001\u0001\u000b\u0011\u0002?\t\u0017\u0005-\u0002\u00011AA\u0002\u0013%\u0011Q\u0006\u0005\f\u0003k\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0004C\u0006\u0002D\u0001\u0001\r\u0011!Q!\n\u0005=\u0002\"CA#\u0001\t\u0007I\u0011BA$\u0011!\t)\u0006\u0001Q\u0001\n\u0005%\u0003\"CA,\u0001\t\u0007I\u0011BA-\u0011!\t\t\u0007\u0001Q\u0001\n\u0005m\u0003\"CA2\u0001\t\u0007I\u0011BA3\u0011!\ty\u0007\u0001Q\u0001\n\u0005\u001d\u0004bBA9\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003o\u0002A\u0011BA=\u0011\u001d\ti\b\u0001C!\u0003\u007fBq!a\"\u0001\t\u0003\nI\tC\u0004\u0002\u0016\u0002!\t!a&\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\"9\u0011q\u0016\u0001\u0005\u0002\u0005E\u0006bBAZ\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0003s\u0003A\u0011AA^\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007Dq!!2\u0001\t\u0013\t9\rC\u0004\u0002R\u0002!I!a5\t\u000f\u0005m\u0007\u0001\"\u0011\u0002^\"9\u00111\u001d\u0001\u0005B\u0005E\u0006bBAs\u0001\u0011%\u0011q\u0010\u0005\b\u0003O\u0004A\u0011AAu\u0005]\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'O\u0003\u0002*U\u000511/\u001a:wKJT\u0011aK\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001a\u0006\u000e\u001e?!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fMB\u0011Q\u0007O\u0007\u0002m)\u0011qGK\u0001\u0006kRLGn]\u0005\u0003sY\u0012q\u0001T8hO&tw\r\u0005\u0002<y5\t\u0001&\u0003\u0002>Q\ta!+\u001a9mS\u000e\f\u0017+^8uCB\u00111hP\u0005\u0003\u0001\"\u0012a\u0004R5tWV\u001b\u0018mZ3CCN,G\r\u00165s_R$H.\u001a'jgR,g.\u001a:\u0002\r\r|gNZ5h+\u0005\u0019\u0005CA\u001eE\u0013\t)\u0005FA\u000fSKBd\u0017nY1uS>t\u0017+^8uC6\u000bg.Y4fe\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nq!\\3ue&\u001c7/F\u0001J!\tQ5+D\u0001L\u0015\t9EJ\u0003\u0002N\u001d\u000611m\\7n_:T!aK(\u000b\u0005A\u000b\u0016AB1qC\u000eDWMC\u0001S\u0003\ry'oZ\u0005\u0003).\u0013q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003%\tXo\u001c;b)f\u0004X-F\u0001Y!\tY\u0014,\u0003\u0002[Q\tI\u0011+^8uCRK\b/Z\u0001\u000bcV|G/\u0019+za\u0016\u0004\u0013\u0001\u0002;j[\u0016,\u0012A\u0018\t\u0003?\u0006l\u0011\u0001\u0019\u0006\u0003o1K!A\u00191\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0019<\u0007.\u001b6\u0011\u0005m\u0002\u0001\"B!\n\u0001\u0004\u0019\u0005\"B$\n\u0001\u0004I\u0005\"\u0002,\n\u0001\u0004A\u0006\"\u0002/\n\u0001\u0004q\u0016\u0001\u00027pG.,\u0012!\u001c\t\u0003]^l\u0011a\u001c\u0006\u0003aF\fQ\u0001\\8dWNT!A]:\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002uk\u0006!Q\u000f^5m\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_8\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.\fQ\u0001\\8dW\u0002\n1\u0003\u001e5s_R$H.\u001a3QCJ$\u0018\u000e^5p]N,\u0012\u0001 \t\u0007{z\f\t!a\u0006\u000e\u0003EL!a`9\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002\u0004\u0005Ea\u0002BA\u0003\u0003\u001b\u00012!a\u00021\u001b\t\tIAC\u0002\u0002\f1\na\u0001\u0010:p_Rt\u0014bAA\ba\u00051\u0001K]3eK\u001aLA!a\u0005\u0002\u0016\t11\u000b\u001e:j]\u001eT1!a\u00041!\u0019\tI\"a\b\u0002$5\u0011\u00111\u0004\u0006\u0004\u0003;\u0001\u0014AC2pY2,7\r^5p]&!\u0011\u0011EA\u000e\u0005\r\u0019V-\u001d\t\u0004_\u0005\u0015\u0012bAA\u0014a\t\u0019\u0011J\u001c;\u0002)QD'o\u001c;uY\u0016$\u0007+\u0019:uSRLwN\\:!\u0003\u0015\tXo\u001c;b+\t\ty\u0003E\u0002K\u0003cI1!a\rL\u0005\u0015\tVo\u001c;b\u0003%\tXo\u001c;b?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0005}\u0002cA\u0018\u0002<%\u0019\u0011Q\b\u0019\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u0003z\u0011\u0011!a\u0001\u0003_\t1\u0001\u001f\u00132\u0003\u0019\tXo\u001c;bA\u0005!\u0012\r\u001c7SKBd\u0017nY1t)\"\u0014x\u000e\u001e;mK\u0012,\"!!\u0013\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014r\u0003\u0019\tGo\\7jG&!\u00111KA'\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006)\u0012\r\u001c7SKBd\u0017nY1t)\"\u0014x\u000e\u001e;mK\u0012\u0004\u0013\u0001D:f]N|'/Q2dKN\u001cXCAA.!\rY\u0014QL\u0005\u0004\u0003?B#\u0001D*f]N|'/Q2dKN\u001c\u0018!D:f]N|'/Q2dKN\u001c\b%\u0001\bsCR,W*\u001a;sS\u000et\u0015-\\3\u0016\u0005\u0005\u001d\u0004\u0003BA5\u0003Wj\u0011\u0001T\u0005\u0004\u0003[b%AC'fiJL7MT1nK\u0006y!/\u0019;f\u001b\u0016$(/[2OC6,\u0007%A\u0006va\u0012\fG/Z)v_R\fG\u0003BA\u001d\u0003kBq!a\u000b\u0018\u0001\u0004\ty#A\u0007e_V\u0003H-\u0019;f#V|G/\u0019\u000b\u0005\u0003s\tY\bC\u0004\u0002,a\u0001\r!a\f\u0002\u001f%\u001c\u0018+^8uC\u0016C8-Z3eK\u0012,\"!!!\u0011\u0007=\n\u0019)C\u0002\u0002\u0006B\u0012qAQ8pY\u0016\fg.A\u0006jgRC'o\u001c;uY\u0016$G\u0003BAA\u0003\u0017Cq!!$\u001b\u0001\u0004\ty)\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005%\u0014\u0011S\u0005\u0004\u0003'c%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0007e\u0016\u001cwN\u001d3\u0015\t\u0005e\u0012\u0011\u0014\u0005\b\u00037[\u0002\u0019AAO\u0003\u00151\u0018\r\\;f!\ry\u0013qT\u0005\u0004\u0003C\u0003$\u0001\u0002'p]\u001e\fQ\"\\1sWRC'o\u001c;uY\u0016$GCBA\u001d\u0003O\u000bY\u000bC\u0004\u0002*r\u0001\r!!\u0001\u0002\u000bQ|\u0007/[2\t\u000f\u00055F\u00041\u0001\u0002\u0018\u0005Q\u0001/\u0019:uSRLwN\\:\u0002'5\f'o\u001b\"s_.,'\u000f\u00165s_R$H.\u001a3\u0015\u0005\u0005e\u0012A\u0004:f[>4X\r\u00165s_R$H.\u001a\u000b\u0005\u0003s\t9\fC\u0004\u0002*z\u0001\r!!\u0001\u0002)I,Wn\u001c<f\u0005J|7.\u001a:UQJ|G\u000f\u001e7f)\u0011\tI$!0\t\u000f\u0005}v\u00041\u0001\u0002\u0002\u0006i!/Z:fiRC'o\u001c;uY\u0016\f!\"\u001e9qKJ\u0014u.\u001e8e+\t\ti*\u0001\u000bhKR\fVo\u001c;b\u001b\u0016$(/[2D_:4\u0017n\u001a\u000b\u0005\u0003\u0013\fy\rE\u0002K\u0003\u0017L1!!4L\u00051iU\r\u001e:jG\u000e{gNZ5h\u0011\u001d\tY#\ta\u0001\u0003_\taa]3og>\u0014HCAAk!\rQ\u0015q[\u0005\u0004\u00033\\%AB*f]N|'/\u0001\niC:$G.\u001a#jg.\u001c\u0006/Y2f\u0019><H\u0003BA\u001d\u0003?Dq!!9$\u0001\u0004\ti*\u0001\rdCB\u0004X\rZ)v_R\f\u0017J\u001c\"zi\u0016\u001c\b+\u001a:TK\u000e\f\u0001\u0004[1oI2,G)[:l'B\f7-\u001a*fG>4XM]3e\u0003EA\u0017m\u001d#jg.$\u0006N]8ui2LgnZ\u0001\u0014O\u0016$(I]8lKJ\fVo\u001c;b\u0019&l\u0017\u000e^\u000b\u0003\u0003W\u00042aLAw\u0013\r\ty\u000f\r\u0002\u0007\t>,(\r\\3")
public class ReplicationQuotaManager
implements Logging,
ReplicaQuota,
DiskUsageBasedThrottleListener {
    private final ReplicationQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType quotaType;
    private final Time time;
    private final ReentrantReadWriteLock lock;
    private final ConcurrentHashMap<String, Seq<Object>> throttledPartitions;
    private Quota quota;
    private final AtomicBoolean allReplicasThrottled;
    private final SensorAccess sensorAccess;
    private final MetricName rateMetricName;
    private AtomicReference<Option<Object>> lastSignalledQuotaOptRef;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public AtomicReference<Option<Object>> lastSignalledQuotaOptRef() {
        return this.lastSignalledQuotaOptRef;
    }

    @Override
    public void kafka$server$DiskUsageBasedThrottleListener$_setter_$lastSignalledQuotaOptRef_$eq(AtomicReference<Option<Object>> x$1) {
        this.lastSignalledQuotaOptRef = x$1;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ReplicationQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @Override
    public QuotaType quotaType() {
        return this.quotaType;
    }

    private Time time() {
        return this.time;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ConcurrentHashMap<String, Seq<Object>> throttledPartitions() {
        return this.throttledPartitions;
    }

    private Quota quota() {
        return this.quota;
    }

    private void quota_$eq(Quota x$1) {
        this.quota = x$1;
    }

    private AtomicBoolean allReplicasThrottled() {
        return this.allReplicasThrottled;
    }

    private SensorAccess sensorAccess() {
        return this.sensorAccess;
    }

    private MetricName rateMetricName() {
        return this.rateMetricName;
    }

    public void updateQuota(Quota quota) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("updateQuota requested for ").append(this.quotaType()).append(" from ").append(this.quota()).append(" to ").append(quota).toString());
        if (this.hasDiskThrottling() && this.lastSignalledQuotaOptRef().get().isDefined()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Can't update replication throttle since disk throttling is currently active!");
            return;
        }
        this.doUpdateQuota(quota);
    }

    private void doUpdateQuota(Quota quota) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            ReplicationQuotaManager.$anonfun$doUpdateQuota$1(this, quota);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    @Override
    public boolean isQuotaExceeded() {
        try {
            this.sensor().checkQuotas();
        }
        catch (QuotaViolationException qve) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(44).append(this.quotaType()).append(": Quota violated for sensor (").append(this.sensor().name()).append("), metric: (").append(qve.metric().metricName()).append("), ").toString()).append(new StringBuilder(27).append("metric-value: (").append(qve.value()).append("), bound: (").append(qve.bound()).append(")").toString()).toString());
            return true;
        }
        return false;
    }

    @Override
    public boolean isThrottled(TopicPartition topicPartition) {
        Seq<Object> partitions = this.throttledPartitions().get(topicPartition.topic());
        if (partitions == null || partitions.isEmpty()) {
            return this.allReplicasThrottled().get();
        }
        return partitions == Constants$.MODULE$.AllReplicas() || partitions.contains((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
    }

    @Override
    public void record(long value) {
        this.sensor().record((double)value, this.time().milliseconds(), false);
    }

    public void markThrottled(String topic, Seq<Object> partitions) {
        this.throttledPartitions().put(topic, partitions);
    }

    public void markBrokerThrottled() {
        this.allReplicasThrottled().set(true);
    }

    public void removeThrottle(String topic) {
        this.throttledPartitions().remove(topic);
    }

    public void removeBrokerThrottle(boolean resetThrottle) {
        boolean throttleEnabled = resetThrottle ? this.config().allReplicasThrottled() : false;
        this.allReplicasThrottled().set(throttleEnabled);
    }

    public long upperBound() {
        long l;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            l = ReplicationQuotaManager.$anonfun$upperBound$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return l;
    }

    private MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    private Sensor sensor() {
        return this.sensorAccess().getOrCreate(this.quotaType().toString(), ReplicationQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable)sensor -> {
            sensor.add(this.rateMetricName(), (MeasurableStat)new SimpleRate(), this.getQuotaMetricConfig(this.quota()));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void handleDiskSpaceLow(long cappedQuotaInBytesPerSec) {
        if (this.hasDiskThrottling()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Updating {} quota (due to low disk) to: {}", new Object[]{this.quotaType(), BoxesRunTime.boxToLong((long)cappedQuotaInBytesPerSec)});
            }
            double upperBound_upperBound = cappedQuotaInBytesPerSec;
            this.doUpdateQuota(new Quota(upperBound_upperBound, true));
            this.markBrokerThrottled();
        }
    }

    @Override
    public void handleDiskSpaceRecovered() {
        if (this.hasDiskThrottling()) {
            long resetQuota = this.config().quotaBytesPerSecond();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Resetting {} quota (due to low disk) to: {}", new Object[]{this.quotaType(), BoxesRunTime.boxToLong((long)resetQuota)});
            }
            double upperBound_upperBound = resetQuota;
            this.doUpdateQuota(new Quota(upperBound_upperBound, true));
            this.removeBrokerThrottle(true);
        }
    }

    private boolean hasDiskThrottling() {
        block3: {
            block2: {
                QuotaType quotaType = this.quotaType();
                QuotaType$FollowerReplication$ quotaType$FollowerReplication$ = QuotaType$FollowerReplication$.MODULE$;
                if (quotaType != null && quotaType.equals(quotaType$FollowerReplication$)) break block2;
                QuotaType quotaType2 = this.quotaType();
                QuotaType$ClusterLinkReplication$ quotaType$ClusterLinkReplication$ = QuotaType$ClusterLinkReplication$.MODULE$;
                if (quotaType2 == null || !quotaType2.equals(quotaType$ClusterLinkReplication$)) break block3;
            }
            return true;
        }
        return false;
    }

    public double getBrokerQuotaLimit() {
        return this.quota().bound();
    }

    public static final /* synthetic */ void $anonfun$doUpdateQuota$1(ReplicationQuotaManager $this, Quota quota$2) {
        $this.quota_$eq(quota$2);
        KafkaMetric metric = (KafkaMetric)$this.metrics().metrics().get($this.rateMetricName());
        if (metric != null) {
            metric.config($this.getQuotaMetricConfig(quota$2));
        }
    }

    public static final /* synthetic */ long $anonfun$upperBound$1(ReplicationQuotaManager $this) {
        if ($this.quota() != null) {
            return (long)$this.quota().bound();
        }
        return Long.MAX_VALUE;
    }

    public ReplicationQuotaManager(ReplicationQuotaManagerConfig config, Metrics metrics, QuotaType quotaType, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.quotaType = quotaType;
        this.time = time;
        DiskUsageBasedThrottleListener.$init$(this);
        this.lock = new ReentrantReadWriteLock();
        this.throttledPartitions = new ConcurrentHashMap();
        this.allReplicasThrottled = new AtomicBoolean(config.allReplicasThrottled());
        this.sensorAccess = new SensorAccess(this.lock(), metrics);
        this.rateMetricName = metrics.metricName("byte-rate", quotaType.toString(), new StringBuilder(23).append("Tracking byte-rate for ").append(quotaType).toString());
        double upperBound_upperBound = config.quotaBytesPerSecond();
        this.updateQuota(new Quota(upperBound_upperBound, true));
        Statics.releaseFence();
    }
}

