/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.EvictableKey;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc\u0001\u0002\u000f\u001e\u0001\tB\u0001\"\u000e\u0001\u0003\u0006\u0004%IA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001BC\u0002\u0013%A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001d9\u0005\u00011A\u0005\nqBq\u0001\u0013\u0001A\u0002\u0013%\u0011\n\u0003\u0004P\u0001\u0001\u0006K!\u0010\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019i\u0006\u0001)A\u0005%\"9a\f\u0001b\u0001\n\u0013y\u0006B\u00024\u0001A\u0003%\u0001\rC\u0004h\u0001\t\u0007I\u0011B0\t\r!\u0004\u0001\u0015!\u0003a\u0011!I\u0007A1A\u0005\u0002uQ\u0007B\u0002<\u0001A\u0003%1\u000e\u0003\u0005x\u0001\t\u0007I\u0011A\u000fk\u0011\u0019A\b\u0001)A\u0005W\")\u0011\u0010\u0001C\u0001u\"1\u0011\u0011\u0001\u0001\u0005\u0002YBa!a\u0001\u0001\t\u0003a\u0004bBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u0002B\u0001!\t!a\u0012\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\t\tb)\u001a;dQN+7o]5p]\u000e\u000b7\r[3\u000b\u0005yy\u0012AB:feZ,'OC\u0001!\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u0012*_A\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0017\u000e\u0003-R!\u0001L\u0010\u0002\u000bU$\u0018\u000e\\:\n\u00059Z#a\u0002'pO\u001eLgn\u001a\t\u0003aMj\u0011!\r\u0006\u0003e}\tq!\\3ue&\u001c7/\u0003\u00025c\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u00155\f\u00070\u00128ue&,7/F\u00018!\t!\u0003(\u0003\u0002:K\t\u0019\u0011J\u001c;\u0002\u00175\f\u00070\u00128ue&,7\u000fI\u0001\u000bKZL7\r^5p]6\u001bX#A\u001f\u0011\u0005\u0011r\u0014BA &\u0005\u0011auN\\4\u0002\u0017\u00154\u0018n\u0019;j_:l5\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r+e\t\u0005\u0002E\u00015\tQ\u0004C\u00036\u000b\u0001\u0007q\u0007C\u0003<\u000b\u0001\u0007Q(A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u0001\u0012]Vl\u0007+\u0019:uSRLwN\\:`I\u0015\fHC\u0001&N!\t!3*\u0003\u0002MK\t!QK\\5u\u0011\u001dqu!!AA\u0002u\n1\u0001\u001f\u00132\u00039qW/\u001c)beRLG/[8og\u0002\n\u0001b]3tg&|gn]\u000b\u0002%B!1\u000bW\u001c[\u001b\u0005!&BA+W\u0003\u0011)H/\u001b7\u000b\u0003]\u000bAA[1wC&\u0011\u0011\f\u0016\u0002\u000e\u0019&t7.\u001a3ICNDW*\u00199\u0011\u0005\u0011[\u0016B\u0001/\u001e\u000511U\r^2i'\u0016\u001c8/[8o\u0003%\u0019Xm]:j_:\u001c\b%\u0001\bfm&\u001cG/\u00192mK\nK\u0018\t\u001c7\u0016\u0003\u0001\u0004BaU1d5&\u0011!\r\u0016\u0002\b)J,W-T1q!\t!E-\u0003\u0002f;\taQI^5di\u0006\u0014G.Z&fs\u0006yQM^5di\u0006\u0014G.\u001a\"z\u00032d\u0007%A\u000bfm&\u001cG/\u00192mK\nK\bK]5wS2,w-\u001a3\u0002-\u00154\u0018n\u0019;bE2,')\u001f)sSZLG.Z4fI\u0002\na\"\u001a<jGRLwN\\:NKR,'/F\u0001l!\taG/D\u0001n\u0015\tqw.\u0001\u0003d_J,'B\u0001\u001aq\u0015\t\t(/\u0001\u0004zC6lWM\u001d\u0006\u0002g\u0006\u00191m\\7\n\u0005Ul'!B'fi\u0016\u0014\u0018aD3wS\u000e$\u0018n\u001c8t\u001b\u0016$XM\u001d\u0011\u00027\u0005\u001cG/\u001b<f'\u0016\u001c8/[8o\u000bZL7\r^5p]NlU\r^3s\u0003q\t7\r^5wKN+7o]5p]\u00163\u0018n\u0019;j_:\u001cX*\u001a;fe\u0002\n1aZ3u)\tYh\u0010E\u0002%yjK!!`\u0013\u0003\r=\u0003H/[8o\u0011\u0015y8\u00031\u00018\u0003%\u0019Xm]:j_:LE-\u0001\u0003tSj,\u0017a\u0004;pi\u0006d\u0007+\u0019:uSRLwN\\:\u0002\u00199,woU3tg&|g.\u00133\u0015\u0003]\n!#\\1zE\u0016\u001c%/Z1uKN+7o]5p]RIq'!\u0004\u0002\u0012\u0005m\u0011Q\u0004\u0005\u0007\u0003\u001f9\u0002\u0019A\u001f\u0002\u00079|w\u000fC\u0004\u0002\u0014]\u0001\r!!\u0006\u0002\u0015A\u0014\u0018N^5mK\u001e,G\rE\u0002%\u0003/I1!!\u0007&\u0005\u001d\u0011un\u001c7fC:Da!!\u0001\u0018\u0001\u00049\u0004bBA\u0010/\u0001\u0007\u0011\u0011E\u0001\u0011GJ,\u0017\r^3QCJ$\u0018\u000e^5p]N\u0004R\u0001JA\u0012\u0003OI1!!\n&\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0003\u0002*\u0005=bb\u0001#\u0002,%\u0019\u0011QF\u000f\u0002\u0019\u0019+Go\u00195TKN\u001c\u0018n\u001c8\n\t\u0005E\u00121\u0007\u0002\n\u0007\u0006\u001b\u0005*R0N\u0003BS1!!\f\u001e\u0003!!(/_#wS\u000e$H\u0003CA\u000b\u0003s\tY$a\u0010\t\u000f\u0005M\u0001\u00041\u0001\u0002\u0016!1\u0011Q\b\rA\u0002\r\f1a[3z\u0011\u0019\ty\u0001\u0007a\u0001{\u00051!/Z7pm\u0016$2a_A#\u0011\u0015y\u0018\u00041\u00018)\rY\u0018\u0011\n\u0005\u0007\u0003\u0017R\u0002\u0019\u0001.\u0002\u000fM,7o]5p]\u0006)Ao\\;dQR)!*!\u0015\u0002T!1\u00111J\u000eA\u0002iCa!a\u0004\u001c\u0001\u0004i\u0004")
public class FetchSessionCache
implements KafkaMetricsGroup {
    private final int maxEntries;
    private final long evictionMs;
    private long numPartitions;
    private final LinkedHashMap<Object, FetchSession> sessions;
    private final TreeMap<EvictableKey, FetchSession> evictableByAll;
    private final TreeMap<EvictableKey, FetchSession> evictableByPrivileged;
    private final Meter evictionsMeter;
    private final Meter activeSessionEvictionsMeter;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int maxEntries() {
        return this.maxEntries;
    }

    private long evictionMs() {
        return this.evictionMs;
    }

    private long numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(long x$1) {
        this.numPartitions = x$1;
    }

    private LinkedHashMap<Object, FetchSession> sessions() {
        return this.sessions;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByAll() {
        return this.evictableByAll;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByPrivileged() {
        return this.evictableByPrivileged;
    }

    public Meter evictionsMeter() {
        return this.evictionsMeter;
    }

    public Meter activeSessionEvictionsMeter() {
        return this.activeSessionEvictionsMeter;
    }

    public synchronized Option<FetchSession> get(int sessionId) {
        return Option$.MODULE$.apply((Object)this.sessions().get(BoxesRunTime.boxToInteger((int)sessionId)));
    }

    public synchronized int size() {
        return this.sessions().size();
    }

    public synchronized long totalPartitions() {
        return this.numPartitions();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int newSessionId() {
        void var1_1;
        int id;
        do {
            id = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        } while (this.sessions().containsKey(BoxesRunTime.boxToInteger((int)id)) || id == 0);
        return (int)var1_1;
    }

    public synchronized int maybeCreateSession(long now, boolean privileged, int size, Function0<ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata>> createPartitions) {
        if (this.sessions().size() < this.maxEntries() || this.tryEvict(privileged, new EvictableKey(privileged, size, 0), now)) {
            ImplicitLinkedHashCollection partitionMap = (ImplicitLinkedHashCollection)createPartitions.apply();
            FetchSession session = new FetchSession(this.newSessionId(), privileged, (ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata>)partitionMap, now, now, FetchMetadata.nextEpoch((int)0));
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Created fetch session ").append(session.toString()).toString());
            this.touch(session, now);
            return session.id();
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("No fetch session created for privileged=").append(privileged).append(", size=").append(size).append(".").toString());
        return 0;
    }

    public synchronized boolean tryEvict(boolean privileged, EvictableKey key, long now) {
        Iterator<Map.Entry<Object, FetchSession>> sessionIterator = this.sessions().entrySet().iterator();
        if (!sessionIterator.hasNext()) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "There are no cache entries to evict.");
            return false;
        }
        FetchSession lastUsedSession = sessionIterator.next().getValue();
        if (now - lastUsedSession.lastUsedMs() > this.evictionMs()) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Evicting stale FetchSession ").append(lastUsedSession.id()).append(".").toString());
            this.remove(lastUsedSession);
            this.evictionsMeter().mark();
            return true;
        }
        if (privileged) {
            return this.evictEntry$1(key, this.evictableByPrivileged());
        }
        return this.evictEntry$1(key, this.evictableByAll());
    }

    public synchronized Option<FetchSession> remove(int sessionId) {
        Option<FetchSession> option;
        Option<FetchSession> option2 = this.get(sessionId);
        if (None$.MODULE$.equals(option2)) {
            option = None$.MODULE$;
        } else if (option2 instanceof Some) {
            FetchSession session = (FetchSession)((Some)option2).value();
            option = this.remove(session);
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Option<FetchSession> remove(FetchSession session) {
        synchronized (session) {
            void var3_3;
            EvictableKey evictableKey = session.evictableKey();
            if (!session.privileged()) {
                this.evictableByAll().remove(evictableKey);
            }
            this.evictableByPrivileged().remove(evictableKey);
            Option removeResult = Option$.MODULE$.apply(this.sessions().remove(BoxesRunTime.boxToInteger((int)session.id())));
            if (removeResult.isDefined()) {
                session.close();
                this.numPartitions_$eq(this.numPartitions() - (long)session.cachedSize());
            }
            return var3_3;
        }
    }

    public synchronized void touch(FetchSession session, long now) {
        synchronized (session) {
            this.sessions().remove(BoxesRunTime.boxToInteger((int)session.id()));
            session.lastUsedMs_$eq(now);
            this.sessions().put(BoxesRunTime.boxToInteger((int)session.id()), session);
            int oldSize = session.cachedSize();
            if (oldSize != -1) {
                EvictableKey oldEvictableKey = session.evictableKey();
                this.evictableByPrivileged().remove(oldEvictableKey);
                this.evictableByAll().remove(oldEvictableKey);
                this.numPartitions_$eq(this.numPartitions() - (long)oldSize);
            }
            session.cachedSize_$eq(session.size());
            EvictableKey newEvictableKey = session.evictableKey();
            if (!session.privileged() || now - session.creationMs() > this.evictionMs()) {
                this.evictableByPrivileged().put(newEvictableKey, session);
            }
            if (!session.privileged() && now - session.creationMs() > this.evictionMs()) {
                this.evictableByAll().put(newEvictableKey, session);
            }
            this.numPartitions_$eq(this.numPartitions() + (long)session.cachedSize());
            return;
        }
    }

    public final /* synthetic */ int kafka$server$FetchSessionCache$$$anonfun$new$1() {
        return this.size();
    }

    public final /* synthetic */ long kafka$server$FetchSessionCache$$$anonfun$new$2() {
        return this.totalPartitions();
    }

    private final boolean evictEntry$1(EvictableKey key, TreeMap map) {
        Map.Entry evictableEntry = map.firstEntry();
        if (evictableEntry == null) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "No evictable entries found.");
            return false;
        }
        if (key.compareTo((EvictableKey)evictableEntry.getKey()) < 0) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("Can't evict ").append(evictableEntry.getKey()).append(" with ").append(key.toString()).toString());
            return false;
        }
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Evicting ").append(evictableEntry.getKey()).append(" with ").append(key.toString()).append(".").toString());
        this.remove((FetchSession)evictableEntry.getValue());
        this.evictionsMeter().mark();
        this.activeSessionEvictionsMeter().mark();
        return true;
    }

    public FetchSessionCache(int maxEntries, long evictionMs) {
        this.maxEntries = maxEntries;
        this.evictionMs = evictionMs;
        this.numPartitions = 0L;
        this.sessions = new LinkedHashMap();
        this.evictableByAll = new TreeMap();
        this.evictableByPrivileged = new TreeMap();
        this.removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSIONS(), this.removeMetric$default$2());
        this.newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSIONS(), new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public final int value() {
                FetchSessionCache fetchSessionCache = this.$outer;
                if (fetchSessionCache == null) {
                    throw null;
                }
                return fetchSessionCache.size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED(), this.removeMetric$default$2());
        this.newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED(), new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public final long value() {
                FetchSessionCache fetchSessionCache = this.$outer;
                if (fetchSessionCache == null) {
                    throw null;
                }
                return fetchSessionCache.totalPartitions();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.removeMetric(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), this.removeMetric$default$2());
        this.evictionsMeter = this.newMeter(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), FetchSession$.MODULE$.EVICTIONS(), TimeUnit.SECONDS, (Map<String, String>)Predef$.MODULE$.Map().empty());
        this.removeMetric(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_ACTIVE_SESSION_EVICTIONS_PER_SEC(), this.removeMetric$default$2());
        this.activeSessionEvictionsMeter = this.newMeter(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_ACTIVE_SESSION_EVICTIONS_PER_SEC(), FetchSession$.MODULE$.EVICTIONS(), TimeUnit.SECONDS, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }
}

