/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Properties;
import kafka.server.BrokerMetadataCheckpoint$;
import kafka.server.RawMetaProperties;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u00059<Q\u0001D\u0007\t\u0002I1Q\u0001F\u0007\t\u0002UAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005\u0002\u00152A\u0001F\u0007\u0001\t\"AQ\t\u0002BC\u0002\u0013\u0005a\t\u0003\u0005P\t\t\u0005\t\u0015!\u0003H\u0011\u0015\u0011C\u0001\"\u0001Q\u0011\u001d\u0019FA1A\u0005\nQCaa\u0017\u0003!\u0002\u0013)\u0006\"\u0002/\u0005\t\u0003i\u0006\"B5\u0005\t\u0003Q\u0017\u0001\u0007\"s_.,'/T3uC\u0012\fG/Y\"iK\u000e\\\u0007o\\5oi*\u0011abD\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003A\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\u0014\u00035\tQB\u0001\rCe>\\WM]'fi\u0006$\u0017\r^1DQ\u0016\u001c7\u000e]8j]R\u001c2!\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0011Q\u0004I\u0007\u0002=)\u0011qdD\u0001\u0006kRLGn]\u0005\u0003Cy\u0011q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002%\u0005yr-\u001a;Ce>\\WM]'fi\u0006$\u0017\r^1B]\u0012|eM\u001a7j]\u0016$\u0015N]:\u0015\u0007\u0019jt\b\u0005\u0003\u0018O%b\u0013B\u0001\u0015\u0019\u0005\u0019!V\u000f\u001d7feA\u00111CK\u0005\u0003W5\u0011\u0011CU1x\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t!\ri\u0003GM\u0007\u0002])\u0011q\u0006G\u0001\u000bG>dG.Z2uS>t\u0017BA\u0019/\u0005\r\u0019V-\u001d\t\u0003gir!\u0001\u000e\u001d\u0011\u0005UBR\"\u0001\u001c\u000b\u0005]\n\u0012A\u0002\u001fs_>$h(\u0003\u0002:1\u00051\u0001K]3eK\u001aL!a\u000f\u001f\u0003\rM#(/\u001b8h\u0015\tI\u0004\u0004C\u0003?\u0007\u0001\u0007A&A\u0004m_\u001e$\u0015N]:\t\u000b\u0001\u001b\u0001\u0019A!\u0002\u001b%<gn\u001c:f\u001b&\u001c8/\u001b8h!\t9\")\u0003\u0002D1\t9!i\\8mK\u0006t7c\u0001\u0003\u00179\u0005!a-\u001b7f+\u00059\u0005C\u0001%N\u001b\u0005I%B\u0001&L\u0003\tIwNC\u0001M\u0003\u0011Q\u0017M^1\n\u00059K%\u0001\u0002$jY\u0016\fQAZ5mK\u0002\"\"!\u0015*\u0011\u0005M!\u0001\"B#\b\u0001\u00049\u0015\u0001\u00027pG.,\u0012!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031.\u000bA\u0001\\1oO&\u0011!l\u0016\u0002\u0007\u001f\nTWm\u0019;\u0002\u000b1|7m\u001b\u0011\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005y\u000b\u0007CA\f`\u0013\t\u0001\u0007D\u0001\u0003V]&$\b\"\u00022\u000b\u0001\u0004\u0019\u0017A\u00039s_B,'\u000f^5fgB\u0011AmZ\u0007\u0002K*\u0011amS\u0001\u0005kRLG.\u0003\u0002iK\nQ\u0001K]8qKJ$\u0018.Z:\u0002\tI,\u0017\r\u001a\u000b\u0002WB\u0019q\u0003\\2\n\u00055D\"AB(qi&|g\u000e")
public class BrokerMetadataCheckpoint
implements Logging {
    private final File file;
    private final Object lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<RawMetaProperties, Seq<String>> getBrokerMetadataAndOfflineDirs(Seq<String> logDirs, boolean ignoreMissing) {
        return BrokerMetadataCheckpoint$.MODULE$.getBrokerMetadataAndOfflineDirs(logDirs, ignoreMissing);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    private Object lock() {
        return this.lock;
    }

    public void write(Properties properties) {
        Object object = this.lock();
        synchronized (object) {
            this.liftedTree1$1(properties);
            return;
        }
    }

    public Option<Properties> read() {
        Files.deleteIfExists(new File(new StringBuilder(4).append(this.file().getPath()).append(".tmp").toString()).toPath());
        String absolutePath = this.file().getAbsolutePath();
        Object object = this.lock();
        synchronized (object) {
            Option option = this.liftedTree2$1(absolutePath);
            return option;
        }
    }

    private final /* synthetic */ void liftedTree1$1(Properties properties$1) {
        try {
            File temp = new File(new StringBuilder(4).append(this.file().getAbsolutePath()).append(".tmp").toString());
            FileOutputStream fileOutputStream = new FileOutputStream(temp);
            try {
                properties$1.store(fileOutputStream, "");
                fileOutputStream.flush();
                fileOutputStream.getFD().sync();
            }
            finally {
                Utils.closeQuietly((AutoCloseable)fileOutputStream, (String)temp.getName());
            }
            Utils.atomicMoveWithFallback((Path)temp.toPath(), (Path)this.file().toPath(), (boolean)false);
        }
        catch (IOException ie) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to write meta.properties due to", (Function0<Throwable>)(Function0 & Serializable)() -> ie);
            throw ie;
        }
    }

    private final /* synthetic */ Option liftedTree2$1(String absolutePath$1) {
        try {
            return new Some((Object)Utils.loadProps((String)absolutePath$1, null));
        }
        catch (NoSuchFileException noSuchFileException) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("No meta.properties file under dir ").append(absolutePath$1).toString());
            return None$.MODULE$;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Failed to read meta.properties file under dir ").append(absolutePath$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            throw e;
        }
    }

    public BrokerMetadataCheckpoint(File file) {
        this.file = file;
        this.lock = new Object();
    }
}

