/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetchConnectionsMode$Isolated$;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherPool;
import kafka.server.FetcherPool$;
import kafka.server.FetcherPool$Default$;
import kafka.server.FetcherPool$InSync$;
import kafka.server.FetcherTag;
import kafka.server.InitialFetchState;
import kafka.server.PartitionFetchState;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tMc!B\u0016-\u0003\u0003\t\u0004\u0002C#\u0001\u0005\u000b\u0007I\u0011\u0001$\t\u0011I\u0003!\u0011!Q\u0001\n\u001dC\u0001b\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t)\u0002\u0011\t\u0011)A\u0005+\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011!!\u0007A!A!\u0002\u0013)\u0007\"B6\u0001\t\u0003a\u0007\"C@\u0001\u0005\u0004%\t\u0001LA\u0001\u0011!\t)\u0002\u0001Q\u0001\n\u0005\r\u0001\"CA\f\u0001\t\u0007I\u0011CA\r\u0011!\tY\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0017\u0001\u0001\u0007I\u0011BA\u0018\u0011%\t\t\u0004\u0001a\u0001\n\u0013\t\u0019\u0004C\u0004\u0002@\u0001\u0001\u000b\u0015B+\t\u0013\u0005\u0005\u0003A1A\u0005\u0012\u0005\r\u0003bBA#\u0001\u0001\u0006I!\u0017\u0005\n\u0003\u000f\u0002!\u0019!C\u0001\u0003\u0013B\u0001\"!\u0015\u0001A\u0003%\u00111\n\u0005\n\u0003'\u0002!\u0019!C\u0005\u0003+B\u0001\"!\u0018\u0001A\u0003%\u0011q\u000b\u0005\t\u0003?\u0002A\u0011\u0001\u0017\u0002b!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004\u0002CA:\u0001\u0011\u0005A&a\f\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x!A\u0011Q\u0010\u0001\u0005\u00021\ny\b\u0003\u0005\u0002\u001e\u0002!\t\u0001LAP\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!a.\u0001\r\u0003\tI\fC\u0004\u0002Z\u0002!\t!a7\t\u000f\u0005-\b\u0001\"\u0001\u0002n\"9\u0011\u0011\u001f\u0001\u0005\u0012\u0005M\bbBA\u007f\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0005+AqA!\t\u0001\t\u0003\t\t\u0007C\u0004\u0003$\u0001!\t!!\u0019\b\u0013\t\u0015B&!A\t\u0002\t\u001db\u0001C\u0016-\u0003\u0003E\tA!\u000b\t\r-<C\u0011\u0001B\u0016\u0011%\u0011icJI\u0001\n\u0003\u0011y\u0003C\u0005\u0003J\u001d\n\n\u0011\"\u0001\u0003L\t1\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'O\u0003\u0002.]\u000511/\u001a:wKJT\u0011aL\u0001\u0006W\u000647.Y\u0002\u0001+\t\u0011\u0004o\u0005\u0003\u0001gez\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$AB!osJ+g\r\u0005\u0002;{5\t1H\u0003\u0002=]\u0005)Q\u000f^5mg&\u0011ah\u000f\u0002\b\u0019><w-\u001b8h!\t\u00015)D\u0001B\u0015\t\u0011e&A\u0004nKR\u0014\u0018nY:\n\u0005\u0011\u000b%!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006!a.Y7f+\u00059\u0005C\u0001%P\u001d\tIU\n\u0005\u0002Kk5\t1J\u0003\u0002Ma\u00051AH]8pizJ!AT\u001b\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0016K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001dV\nQA\\1nK\u0002\n\u0001b\u00197jK:$\u0018\nZ\u0001\f]Vlg)\u001a;dQ\u0016\u00148\u000f\u0005\u00025-&\u0011q+\u000e\u0002\u0004\u0013:$\u0018!\u00034fi\u000eDWj\u001c3f!\tQ6,D\u0001-\u0013\taFF\u0001\u000bGKR\u001c\u0007nQ8o]\u0016\u001cG/[8og6{G-Z\u0001\ng\u000eDW\rZ;mKJ\u00042\u0001N0b\u0013\t\u0001WG\u0001\u0004PaRLwN\u001c\t\u0003u\tL!aY\u001e\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018aD3yiJ\fW*\u001a;sS\u000e$\u0016mZ:\u0011\t\u0019LwiR\u0007\u0002O*\u0011\u0001.N\u0001\u000bG>dG.Z2uS>t\u0017B\u00016h\u0005\ri\u0015\r]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f5L(p\u001f?~}B\u0019!\f\u00018\u0011\u0005=\u0004H\u0002\u0001\u0003\u0006c\u0002\u0011\rA\u001d\u0002\u0002)F\u00111O\u001e\t\u0003iQL!!^\u001b\u0003\u000f9{G\u000f[5oOB\u0011!l^\u0005\u0003q2\u0012Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rC\u0003F\u0011\u0001\u0007q\tC\u0003T\u0011\u0001\u0007q\tC\u0003U\u0011\u0001\u0007Q\u000bC\u0003Y\u0011\u0001\u0007\u0011\fC\u0004^\u0011A\u0005\t\u0019\u00010\t\u000f\u0011D\u0001\u0013!a\u0001K\u0006\u0001b-\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012l\u0015\r]\u000b\u0003\u0003\u0007\u0001r!!\u0002\u0002\f\u0005=a.\u0004\u0002\u0002\b)\u0019\u0011\u0011B4\u0002\u000f5,H/\u00192mK&!\u0011QBA\u0004\u0005\u001dA\u0015m\u001d5NCB\u00042AWA\t\u0013\r\t\u0019\u0002\f\u0002\u000b\r\u0016$8\r[3s)\u0006<\u0017!\u00054fi\u000eDWM\u001d+ie\u0016\fG-T1qA\u0005!An\\2l+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\t1\fgn\u001a\u0006\u0003\u0003K\tAA[1wC&!\u0011\u0011FA\u0010\u0005\u0019y%M[3di\u0006)An\\2lA\u0005!b.^7GKR\u001c\u0007.\u001a:t!\u0016\u0014(I]8lKJ,\u0012!V\u0001\u0019]Vlg)\u001a;dQ\u0016\u00148\u000fU3s\u0005J|7.\u001a:`I\u0015\fH\u0003BA\u001b\u0003w\u00012\u0001NA\u001c\u0013\r\tI$\u000e\u0002\u0005+:LG\u000f\u0003\u0005\u0002>9\t\t\u00111\u0001V\u0003\rAH%M\u0001\u0016]Vlg)\u001a;dQ\u0016\u00148\u000fU3s\u0005J|7.\u001a:!\u0003m\u0011X\r\u001d7jG\u00064U\r^2i\u0007>tg.Z2uS>t7/T8eKV\t\u0011,\u0001\u000fsKBd\u0017nY1GKR\u001c\u0007nQ8o]\u0016\u001cG/[8og6{G-\u001a\u0011\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001cXCAA&!\rQ\u0016QJ\u0005\u0004\u0003\u001fb#\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003E1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fI\u0001\u0005i\u0006<7/\u0006\u0002\u0002XA)a-[A-\u000fB!\u0011QDA.\u0013\r\u0001\u0016qD\u0001\u0006i\u0006<7\u000fI\u0001\u001dGJ,\u0017\r^3TKB\f'/\u0019;f\r\u0016$8\r[3s\u001b\u0016$(/[2t)\t\t)$\u0001\u0007nS:4U\r^2i%\u0006$X\r\u0006\u0003\u0002h\u00055\u0004c\u0001\u001b\u0002j%\u0019\u00111N\u001b\u0003\r\u0011{WO\u00197f\u0011\u001d\tyg\u0006a\u0001\u0003c\n!BZ3uG\",'/T1q!\u00151\u0017.a\u0004o\u0003=!W-\u00193UQJ,\u0017\rZ\"pk:$\u0018\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\u0011\t)$!\u001f\t\r\u0005m\u0014\u00041\u0001V\u0003\u001dqWm^*ju\u0016\f!bZ3u\r\u0016$8\r[3s)\u0011\t\t)a!\u0011\u0007Qzf\u000eC\u0004\u0002\u0006j\u0001\r!a\"\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011\u0011RAM\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015AB2p[6|gNC\u00020\u0003#SA!a%\u0002\u0016\u00061\u0011\r]1dQ\u0016T!!a&\u0002\u0007=\u0014x-\u0003\u0003\u0002\u001c\u0006-%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\rO\u0016$h)\u001a;dQ\u0016\u0014\u0018\n\u001a\u000b\u0004+\u0006\u0005\u0006bBAC7\u0001\u0007\u0011qQ\u0001\u001c[\u0006\u00148\u000eU1si&$\u0018n\u001c8t\r>\u0014HK];oG\u0006$\u0018n\u001c8\u0015\u0011\u0005U\u0012qUAV\u0003[Ca!!+\u001d\u0001\u0004)\u0016\u0001\u00032s_.,'/\u00133\t\u000f\u0005\u0015E\u00041\u0001\u0002\b\"9\u0011q\u0016\u000fA\u0002\u0005E\u0016\u0001\u0005;sk:\u001c\u0017\r^5p]>3gm]3u!\r!\u00141W\u0005\u0004\u0003k+$\u0001\u0002'p]\u001e\f1c\u0019:fCR,g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012$rA\\A^\u0003\u007f\u000by\r\u0003\u0004\u0002>v\u0001\r!V\u0001\nM\u0016$8\r[3s\u0013\u0012Dq!!1\u001e\u0001\u0004\t\u0019-\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0003\u0002F\u0006-WBAAd\u0015\r\tIML\u0001\bG2,8\u000f^3s\u0013\u0011\ti-a2\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi\"9\u0011\u0011[\u000fA\u0002\u0005M\u0017a\u00034fi\u000eDWM\u001d)p_2\u00042AWAk\u0013\r\t9\u000e\f\u0002\f\r\u0016$8\r[3s!>|G.A\fbI\u00124U\r^2iKJ4uN\u001d)beRLG/[8ogR1\u0011QGAo\u0003SDq!a8\u001f\u0001\u0004\t\t/A\nqCJ$\u0018\u000e^5p]\u0006sGm\u00144gg\u0016$8\u000f\u0005\u0004gS\u0006\u001d\u00151\u001d\t\u00045\u0006\u0015\u0018bAAtY\t\t\u0012J\\5uS\u0006dg)\u001a;dQN#\u0018\r^3\t\u000f\u0005Eg\u00041\u0001\u0002T\u0006\u0011\u0012\r\u001a3GC&dW\r\u001a)beRLG/[8o)\u0011\t)$a<\t\u000f\u0005\u0015u\u00041\u0001\u0002\b\u0006a\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$vNR3uG\",'\u000f\u00165sK\u0006$GCBA\u001b\u0003k\fI\u0010\u0003\u0004\u0002x\u0002\u0002\rA\\\u0001\u000eM\u0016$8\r[3s)\"\u0014X-\u00193\t\u000f\u0005m\b\u00051\u0001\u0002b\u00061\u0012N\\5uS\u0006dwJ\u001a4tKR\fe\u000eZ#q_\u000eD7/\u0001\u000fnCf\u0014W-T5he\u0006$X-\u00138Ts:\u001c\u0007+\u0019:uSRLwN\\:\u0002'Q|\u0017J\\5uS\u0006dg)\u001a;dQN#\u0018\r^3\u0015\r\u0005\u0005(1\u0001B\u0004\u0011\u0019\u0011)A\ta\u0001m\u00069a-\u001a;dQ\u0016\u0014\bb\u0002B\u0005E\u0001\u0007!1B\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fgB1a-[AD\u0005\u001b\u00012A\u0017B\b\u0013\r\u0011\t\u0002\f\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/Z\u0001\u001be\u0016lwN^3GKR\u001c\u0007.\u001a:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0005\u0017\u00119\u0002C\u0004\u0003\u001a\r\u0002\rAa\u0007\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0003g\u0005;\t9)C\u0002\u0003 \u001d\u00141aU3u\u0003i\u0019\b.\u001e;e_^t\u0017\n\u001a7f\r\u0016$8\r[3s)\"\u0014X-\u00193t\u0003A\u0019Gn\\:f\u00032dg)\u001a;dQ\u0016\u00148/\u0001\fBEN$(/Y2u\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s!\tQve\u0005\u0002(gQ\u0011!qE\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\t\tE\"qI\u000b\u0003\u0005gQ3A\u0018B\u001bW\t\u00119\u0004\u0005\u0003\u0003:\t\rSB\u0001B\u001e\u0015\u0011\u0011iDa\u0010\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B!k\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015#1\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!B9*\u0005\u0004\u0011\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0003\u0003N\tESC\u0001B(U\r)'Q\u0007\u0003\u0006c*\u0012\rA\u001d")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements KafkaMetricsGroup {
    private final String name;
    private final HashMap<FetcherTag, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final FetchConnectionsMode replicaFetchConnectionsMode;
    private final FailedPartitions failedPartitions;
    private final Map<String, String> tags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T extends AbstractFetcherThread> Map<String, String> $lessinit$greater$default$6() {
        return (Map)scala.collection.Map$.MODULE$.empty();
    }

    public static <T extends AbstractFetcherThread> Option<Scheduler> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public HashMap<FetcherTag, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    public Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public FetchConnectionsMode replicaFetchConnectionsMode() {
        return this.replicaFetchConnectionsMode;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private Map<String, String> tags() {
        return this.tags;
    }

    public void createSeparateFetcherMetrics() {
        FetcherPool$.MODULE$.values().foreach((Function1 & Serializable)fetcherPool -> this.newGauge("MinFetchRate", new Gauge<Object>(this, fetcherPool){
            private final /* synthetic */ AbstractFetcherManager $outer;
            private final FetcherPool fetcherPool$1;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$createSeparateFetcherMetrics$2(this.fetcherPool$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetcherPool$1 = fetcherPool$1;
            }
        }, (Map<String, String>)((Map)this.tags().$plus$plus((IterableOnce)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FetcherPool"), (Object)fetcherPool.name())}))))));
    }

    private double minFetchRate(Map<FetcherTag, T> fetcherMap) {
        double headRate = BoxesRunTime.unboxToDouble((Object)fetcherMap.values().headOption().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$minFetchRate$1(x$1))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
        return BoxesRunTime.unboxToDouble((Object)fetcherMap.values().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable)(curMinAll, fetcherThread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThread.fetcherStats().requestRate().oneMinuteRate()))));
    }

    public int deadThreadCount() {
        Object object = this.lock();
        synchronized (object) {
            int n = this.fetcherThreadMap().values().count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isThreadFailed()));
            return n;
        }
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            Option option = this.fetcherThreadMap().values().find((Function1 & Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
            return option;
        }
    }

    public int getFetcherId(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            int n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
            return n;
        }
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            FetcherPool$.MODULE$.values().foreach((Function1 & Serializable)fetcherPool -> {
                AbstractFetcherManager.$anonfun$markPartitionsForTruncation$1(this, brokerId, fetcherId, topicPartition, truncationOffset, fetcherPool);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2, FetcherPool var3);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets, FetcherPool fetcherPool) {
        Object object = this.lock();
        synchronized (object) {
            partitionAndOffsets.groupBy((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)x0$1._2();
                BrokerAndFetcherId brokerAndFetcherId = new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                return brokerAndFetcherId;
            }).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$3 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, fetcherPool, x$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void addFailedPartition(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            this.failedPartitions().add(topicPartition);
            return;
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, InitialFetchState> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Added fetcher ").append(fetcherThread.name()).append(" to broker ").append(fetcherThread.sourceBroker().id()).append(" for partitions ").append(initialOffsetAndEpochs).toString());
    }

    public void maybeMigrateInSyncPartitions() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable)x$4 -> {
                AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$2(this, x$4);
                return BoxedUnit.UNIT;
            });
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    private Map<TopicPartition, InitialFetchState> toInitialFetchState(AbstractFetcherThread fetcher, Map<TopicPartition, PartitionFetchState> partitionStates) {
        return (Map)partitionStates.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new InitialFetchState(fetcher.sourceBroker(), fetchState.currentLeaderEpoch(), fetchState.fetchOffset()));
            return tuple2;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Map<TopicPartition, PartitionFetchState> removeFetcherForPartitions(Set<TopicPartition> partitions) {
        void var2_2;
        scala.collection.mutable.Map fetchStates = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable)fetcher -> (scala.collection.mutable.Map)fetchStates.$plus$plus$eq(fetcher.removePartitions(partitions)));
            this.failedPartitions().removeAll(partitions);
        }
        if (partitions.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
        }
        return var2_2;
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable)x$5 -> {
                BoxedUnit boxedUnit;
                if (x$5 != null) {
                    FetcherTag key = (FetcherTag)x$5._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)x$5._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        boxedUnit = keysToBeRemoved.$plus$eq((Object)key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError(null);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((IterableOnce)keysToBeRemoved);
            return;
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$4 != null))).foreach((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$6)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$5 != null))).foreach((Function1 & Serializable)x$7 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$7);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$new$2(long curMaxLagAll, AbstractFetcherThread fetcherThread) {
        long maxLagThread = BoxesRunTime.unboxToLong((Object)fetcherThread.fetcherLagStats().stats().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(curMaxLagThread, lagMetrics) -> BoxesRunTime.boxToLong((long)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)curMaxLagThread), lagMetrics.lag()))));
        return package$.MODULE$.max(curMaxLagAll, maxLagThread);
    }

    public final /* synthetic */ long kafka$server$AbstractFetcherManager$$$anonfun$new$1() {
        return BoxesRunTime.unboxToLong((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$2(BoxesRunTime.unboxToLong((Object)curMaxLagAll), fetcherThread))));
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$new$4() {
        return this.minFetchRate((Map<FetcherTag, T>)this.fetcherThreadMap());
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$5() {
        return this.failedPartitions().size();
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$6() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$new$7(AbstractFetcherManager $this, Scheduler s) {
        JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> $this.maybeMigrateInSyncPartitions();
        long x$5 = s.schedule$default$3();
        s.schedule("migrate-in-sync-partitions-thread", (Function0<BoxedUnit>)x$2, x$5, 1000L, TimeUnit.MILLISECONDS);
        $this.createSeparateFetcherMetrics();
    }

    public static final /* synthetic */ boolean $anonfun$createSeparateFetcherMetrics$3(FetcherPool fetcherPool$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        FetcherPool fetcherPool = ((FetcherTag)x0$1._1()).fetcherPool();
        boolean bl = !(fetcherPool != null ? !fetcherPool.equals(fetcherPool$1) : fetcherPool$1 != null);
        return bl;
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$createSeparateFetcherMetrics$2(FetcherPool fetcherPool$1) {
        return this.minFetchRate((Map)this.fetcherThreadMap().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$createSeparateFetcherMetrics$3(fetcherPool$1, x0$1))));
    }

    public static final /* synthetic */ double $anonfun$minFetchRate$1(AbstractFetcherThread x$1) {
        return x$1.fetcherStats().requestRate().oneMinuteRate();
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(AbstractFetcherManager $this, int newSize$1, FetcherTag id, AbstractFetcherThread thread) {
        Map<TopicPartition, PartitionFetchState> partitionStates = $this.removeFetcherForPartitions(thread.partitions());
        if (id.fetcherId() >= newSize$1) {
            thread.shutdown();
        }
        Map fetchStates = (Map)partitionStates.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            PartitionFetchState currentFetchState = (PartitionFetchState)x0$1._2();
            InitialFetchState initialFetchState = new InitialFetchState(thread.sourceBroker(), currentFetchState.currentLeaderEpoch(), currentFetchState.fetchOffset());
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)initialFetchState);
            return tuple2;
        });
        $this.addFetcherForPartitions((Map<TopicPartition, InitialFetchState>)fetchStates, id.fetcherPool());
    }

    private final void migratePartitions$1(int newSize) {
        this.fetcherThreadMap().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(id, thread) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(this, newSize, id, thread);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    public static final /* synthetic */ void $anonfun$markPartitionsForTruncation$1(AbstractFetcherManager $this, int brokerId$1, int fetcherId$1, TopicPartition topicPartition$2, long truncationOffset$1, FetcherPool fetcherPool) {
        FetcherTag fetcherTag = new FetcherTag(brokerId$1, fetcherId$1, fetcherPool);
        $this.fetcherThreadMap().get((Object)fetcherTag).foreach((Function1 & Serializable)thread -> {
            thread.markPartitionsForTruncation(topicPartition$2, truncationOffset$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, FetcherTag fetcherTag) {
        void var3_3;
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker(), fetcherTag.fetcherPool());
        this.fetcherThreadMap().put((Object)fetcherTag, fetcherThread);
        ((Thread)fetcherThread).start();
        return var3_3;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, FetcherPool fetcherPool$2, Tuple2 x$3) {
        block6: {
            if (x$3 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)x$3._1();
            initialFetchOffsets = (Map)x$3._2();
            fetcherTag = new FetcherTag(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId(), fetcherPool$2);
            var7_6 = false;
            var8_7 = null;
            var9_8 = $this.fetcherThreadMap().get((Object)fetcherTag);
            if (!(var9_8 instanceof Some)) ** GOTO lbl-1000
            var7_6 = true;
            var8_7 = (Some)var9_8;
            currentFetcherThread = (AbstractFetcherThread)var8_7.value();
            v0 = currentFetcherThread.sourceBroker();
            var11_10 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var11_10) == false : var11_10 != null)) {
                var3_11 = currentFetcherThread;
            } else if (var7_6) {
                ((AbstractFetcherThread)var8_7.value()).shutdown();
                var3_11 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else if (None$.MODULE$.equals(var9_8)) {
                var3_11 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else {
                throw new MatchError((Object)var9_8);
            }
            $this.addPartitionsToFetcherThread(var3_11, (Map<TopicPartition, InitialFetchState>)initialFetchOffsets);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeMigrateInSyncPartitions$3(Tuple2 x0$1) {
        FetcherLagMetrics lagMetrics;
        if (x0$1 == null || (lagMetrics = (FetcherLagMetrics)x0$1._2()) == null) {
            throw new MatchError((Object)x0$1);
        }
        boolean bl = lagMetrics.lag() == 0L;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$maybeMigrateInSyncPartitions$2(AbstractFetcherManager $this, Tuple2 x$4) {
        if (x$4 != null) {
            FetcherTag tag = (FetcherTag)x$4._1();
            AbstractFetcherThread fetcher = (AbstractFetcherThread)x$4._2();
            FetcherPool fetcherPool = tag.fetcherPool();
            FetcherPool$Default$ fetcherPool$Default$ = FetcherPool$Default$.MODULE$;
            if (fetcherPool == null) {
                return;
            }
            if (fetcherPool.equals(fetcherPool$Default$)) {
                scala.collection.immutable.Set inSyncPartitions = ((IterableOnceOps)((IterableOps)fetcher.fetcherLagStats().stats().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$3(x0$1)))).map((Function1 & Serializable)x0$2 -> {
                    void var1_1;
                    if (x0$2 == null) {
                        throw new MatchError(null);
                    }
                    TopicPartition topicPartition = (TopicPartition)x0$2._1();
                    return var1_1;
                })).toSet();
                Map<TopicPartition, PartitionFetchState> partitionStates = fetcher.removePartitions((Set<TopicPartition>)inSyncPartitions);
                Map<TopicPartition, InitialFetchState> fetchStates = $this.toInitialFetchState(fetcher, partitionStates);
                $this.addFetcherForPartitions(fetchStates, FetcherPool$InSync$.MODULE$);
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Moved ").append(partitionStates.size()).append(" partitions from ").append(FetcherPool$Default$.MODULE$).append(" to ").append(FetcherPool$InSync$.MODULE$).append(" for ").append(tag).toString());
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$6) {
        if (x$6 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((AbstractFetcherThread)x$6._2()).initiateShutdown();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$7) {
        if (x$7 != null) {
            ((AbstractFetcherThread)x$7._2()).shutdown();
            return;
        }
        throw new MatchError(null);
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers, FetchConnectionsMode fetchMode, Option<Scheduler> scheduler, Map<String, String> extraMetricTags) {
        BoxedUnit boxedUnit;
        this.name = name;
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.replicaFetchConnectionsMode = fetchMode;
        this.failedPartitions = new FailedPartitions();
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.tags = (Map)((MapOps)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))).$plus$plus(extraMetricTags);
        this.newGauge("MaxLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final long value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("MinFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("FailedPartitionsCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$5();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                AbstractFetcherManager abstractFetcherManager = this.$outer;
                if (abstractFetcherManager == null) {
                    throw null;
                }
                return abstractFetcherManager.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        FetchConnectionsMode fetchConnectionsMode = this.replicaFetchConnectionsMode();
        FetchConnectionsMode$Isolated$ fetchConnectionsMode$Isolated$ = FetchConnectionsMode$Isolated$.MODULE$;
        if (fetchConnectionsMode != null && fetchConnectionsMode.equals(fetchConnectionsMode$Isolated$)) {
            scheduler.foreach((Function1 & Serializable)s -> {
                AbstractFetcherManager.$anonfun$new$7(this, s);
                return BoxedUnit.UNIT;
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally((Object)boxedUnit);
    }
}

