/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Optional;
import kafka.api.ApiVersion;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin$RaftLeader$;
import kafka.log.LogAppendInfo;
import kafka.log.LogOffsetSnapshot;
import kafka.log.SnapshotGenerated$;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.SegmentPosition;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.ControlRecordUtils;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.MapOps;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0005g\u0001\u0002\u001a4\u0005aB\u0001\"\u0015\u0001\u0003\u0006\u0004%\tA\u0015\u0005\t1\u0002\u0011\t\u0011)A\u0005'\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003c\u0011!)\u0007A!A!\u0002\u00131\u0007\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011\u0002@\t\u0015\u0005\u0015\u0001A!A!\u0002\u0013\t9\u0001C\u0004\u0002\u0010\u0001!I!!\u0005\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBA2\u0001\u0011\u0005\u0013Q\r\u0005\b\u0003S\u0002A\u0011BA6\u0011\u001d\t)\b\u0001C!\u0003oBq!!\u001f\u0001\t\u0003\nY\bC\u0004\u0002\u0000\u0001!\t%!!\t\u000f\u00055\u0002\u0001\"\u0011\u0002\n\"9\u00111\u0012\u0001\u0005B\u00055\u0005bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003G\u0003A\u0011IAS\u0011\u001d\tI\u000b\u0001C!\u0003WCq!!-\u0001\t\u0003\n\t\tC\u0004\u00024\u0002!\t%!.\t\u000f\u0005]\u0006\u0001\"\u0011\u0002\n\"1Q\u0010\u0001C!\u0003sCq!a/\u0001\t\u0003\ni\fC\u0004\u0002F\u0002!\t%a2\t\u000f\u0005}\u0007\u0001\"\u0011\u0002b\"9\u0011Q\u001d\u0001\u0005B\u0005\u001d\bbBAz\u0001\u0011\u0005\u0013Q\u001f\u0005\b\u0003o\u0004A\u0011IA}\u0011\u001d\ti\u0010\u0001C!\u0003sDq!a@\u0001\t\u0003\u0012\t\u0001C\u0004\u0003\u0006\u0001!\tEa\u0002\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!Q\u0006\u0001\u0005\n\t=\u0002b\u0002B\u001b\u0001\u0011\u0005\u00131\u0014\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0011\u001d\u0011)\u0005\u0001C\u0005\u00037CqAa\u0012\u0001\t\u0013\tY\nC\u0004\u0003J\u0001!IAa\u0013\t\u000f\tE\u0003\u0001\"\u0003\u0003T!9!\u0011\f\u0001\u0005B\u0005U\u0006\u0002\u0003B.\u0001\u0011\u00051'a\u001e\b\u000f\tu3\u0007#\u0001\u0003`\u00191!g\rE\u0001\u0005CBq!a\u0004.\t\u0003\u0011I\u0007C\u0004\u0003l5\"\tA!\u001c\t\u000f\t]U\u0006\"\u0003\u0003\u001a\"9!QT\u0017\u0005\n\t}%\u0001E&bM.\fW*\u001a;bI\u0006$\u0018\rT8h\u0015\t!T'\u0001\u0003sC\u001a$(\"\u0001\u001c\u0002\u000b-\fgm[1\u0004\u0001M!\u0001!O!L!\tQt(D\u0001<\u0015\taT(\u0001\u0003mC:<'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012aa\u00142kK\u000e$\bC\u0001\"J\u001b\u0005\u0019%B\u0001\u001bE\u0015\t1TI\u0003\u0002G\u000f\u00061\u0011\r]1dQ\u0016T\u0011\u0001S\u0001\u0004_J<\u0017B\u0001&D\u00055\u0011V\r\u001d7jG\u0006$X\r\u001a'pOB\u0011AjT\u0007\u0002\u001b*\u0011a*N\u0001\u0006kRLGn]\u0005\u0003!6\u0013q\u0001T8hO&tw-A\u0002m_\u001e,\u0012a\u0015\t\u0003)Zk\u0011!\u0016\u0006\u0003#VJ!aV+\u0003\u0017\u0005\u00137\u000f\u001e:bGRdunZ\u0001\u0005Y><\u0007%\u0001\u0003uS6,\u0007CA.`\u001b\u0005a&B\u0001(^\u0015\tqF)\u0001\u0004d_6lwN\\\u0005\u0003Ar\u0013A\u0001V5nK\u0006I1o\u00195fIVdWM\u001d\t\u0003\u0019\u000eL!\u0001Z'\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018!C:oCB\u001c\bn\u001c;t!\u00119g\u000e]:\u000e\u0003!T!!\u001b6\u0002\u000f5,H/\u00192mK*\u00111\u000e\\\u0001\u000bG>dG.Z2uS>t'\"A7\u0002\u000bM\u001c\u0017\r\\1\n\u0005=D'a\u0002+sK\u0016l\u0015\r\u001d\t\u0003\u0005FL!A]\"\u0003\u001d=3gm]3u\u0003:$W\t]8dQB\u0019A/^<\u000e\u00031L!A\u001e7\u0003\r=\u0003H/[8o!\tA80D\u0001z\u0015\tQH)\u0001\u0005t]\u0006\u00048\u000f[8u\u0013\ta\u0018PA\u000bGS2,'+Y<T]\u0006\u00048\u000f[8u%\u0016\fG-\u001a:\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u0019q0!\u0001\u000e\u0003uK1!a\u0001^\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\faaY8oM&<\u0007\u0003BA\u0005\u0003\u0017i\u0011aM\u0005\u0004\u0003\u001b\u0019$!E'fi\u0006$\u0017\r^1M_\u001e\u001cuN\u001c4jO\u00061A(\u001b8jiz\"b\"a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0003;\ty\u0002E\u0002\u0002\n\u0001AQ!\u0015\u0005A\u0002MCQ!\u0017\u0005A\u0002iCQ!\u0019\u0005A\u0002\tDQ!\u001a\u0005A\u0002\u0019DQ! \u0005A\u0002yDq!!\u0002\t\u0001\u0004\t9!\u0001\u0003sK\u0006$GCBA\u0013\u0003W\t)\u0004E\u0002C\u0003OI1!!\u000bD\u00051aun\u001a$fi\u000eD\u0017J\u001c4p\u0011\u001d\ti#\u0003a\u0001\u0003_\t1b\u001d;beR|eMZ:fiB\u0019A/!\r\n\u0007\u0005MBN\u0001\u0003M_:<\u0007bBA\u001c\u0013\u0001\u0007\u0011\u0011H\u0001\u000ee\u0016\fG-S:pY\u0006$\u0018n\u001c8\u0011\u0007\t\u000bY$C\u0002\u0002>\r\u0013\u0011\"S:pY\u0006$\u0018n\u001c8\u0002\u001d\u0005\u0004\b/\u001a8e\u0003NdU-\u00193feR1\u00111IA%\u00033\u00022AQA#\u0013\r\t9e\u0011\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000f\u0005-#\u00021\u0001\u0002N\u00059!/Z2pe\u0012\u001c\b\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005MS,\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003/\n\tFA\u0004SK\u000e|'\u000fZ:\t\u000f\u0005m#\u00021\u0001\u0002^\u0005)Q\r]8dQB\u0019A/a\u0018\n\u0007\u0005\u0005DNA\u0002J]R\f\u0001#\u00199qK:$\u0017i\u001d$pY2|w/\u001a:\u0015\t\u0005\r\u0013q\r\u0005\b\u0003\u0017Z\u0001\u0019AA'\u0003uA\u0017M\u001c3mK\u0006sGmQ8om\u0016\u0014H\u000fT8h\u0003B\u0004XM\u001c3J]\u001a|G\u0003BA\"\u0003[Bq!a\u001c\r\u0001\u0004\t\t(\u0001\u0006baB,g\u000eZ%oM>\u00042\u0001VA:\u0013\r\t9%V\u0001\u0011Y\u0006\u001cHOR3uG\",G-\u00129pG\"$\"!!\u0018\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000eF\u0002q\u0003{Bq!a\u0017\u000f\u0001\u0004\ti&A\u0005f]\u0012|eMZ:fiR\u0011\u00111\u0011\t\u0004\u0005\u0006\u0015\u0015bAAD\u0007\n\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0015\u0005\u0005=\u0012A\u0003;sk:\u001c\u0017\r^3U_R!\u0011qRAK!\r!\u0018\u0011S\u0005\u0004\u0003'c'\u0001B+oSRDq!a&\u0012\u0001\u0004\ty#\u0001\u0004pM\u001a\u001cX\r^\u0001\u0019iJ,hnY1uKR{G*\u0019;fgR\u001cf.\u00199tQ>$HCAAO!\r!\u0018qT\u0005\u0004\u0003Cc'a\u0002\"p_2,\u0017M\\\u0001\u0016S:LG/[1mSj,G*Z1eKJ,\u0005o\\2i)\u0011\ty)a*\t\u000f\u0005m3\u00031\u0001\u0002^\u0005\u0019R\u000f\u001d3bi\u0016D\u0015n\u001a5XCR,'/\\1sWR!\u0011qRAW\u0011\u001d\ty\u000b\u0006a\u0001\u0003\u0007\u000bab\u001c4gg\u0016$X*\u001a;bI\u0006$\u0018-A\u0007iS\u001eDw+\u0019;fe6\f'o[\u0001\u0006M2,8\u000f\u001b\u000b\u0003\u0003\u001f\u000b\u0011\u0003\\1ti\u001acWo\u001d5fI>3gm]3u)\u0005q\u0018a\u0002;pa&\u001c\u0017\n\u001a\u000b\u0003\u0003\u007f\u00032a`Aa\u0013\r\t\u0019-\u0018\u0002\u0005+VLG-A\tde\u0016\fG/\u001a(foNs\u0017\r]:i_R$B!!3\u0002\\B1\u00111ZAi\u0003+l!!!4\u000b\u0007\u0005=W(\u0001\u0003vi&d\u0017\u0002BAj\u0003\u001b\u0014\u0001b\u00149uS>t\u0017\r\u001c\t\u0004q\u0006]\u0017bAAms\n\t\"+Y<T]\u0006\u00048\u000f[8u/JLG/\u001a:\t\r\u0005u'\u00041\u0001q\u0003)\u0019h.\u00199tQ>$\u0018\nZ\u0001\u000egR|'/Z*oCB\u001c\bn\u001c;\u0015\t\u0005%\u00171\u001d\u0005\u0007\u0003;\\\u0002\u0019\u00019\u0002\u0019I,\u0017\rZ*oCB\u001c\bn\u001c;\u0015\t\u0005%\u0018\u0011\u001f\t\u0007\u0003\u0017\f\t.a;\u0011\u0007a\fi/C\u0002\u0002pf\u0014\u0011CU1x':\f\u0007o\u001d5piJ+\u0017\rZ3s\u0011\u0019\ti\u000e\ba\u0001a\u0006qA.\u0019;fgR\u001cf.\u00199tQ>$HCAAu\u0003Aa\u0017\r^3tiNs\u0017\r]:i_RLE\r\u0006\u0002\u0002|B)\u00111ZAia\u0006\u0011R-\u0019:mS\u0016\u001cHo\u00158baNDw\u000e^%e\u0003Aygn\u00158baNDw\u000e\u001e$s_j,g\u000e\u0006\u0003\u0002\u0010\n\r\u0001BBAoA\u0001\u0007\u0001/\u0001\u000beK2,G/\u001a\"fM>\u0014Xm\u00158baNDw\u000e\u001e\u000b\u0005\u0003;\u0013I\u0001\u0003\u0004\u0002^\u0006\u0002\r\u0001]\u0001\u0012Y>\fGm\u00158baNDw\u000e^*ju\u0016\u001cHC\u0001B\b!\u0019\u0011\tB!\t\u0003(9!!1\u0003B\u000f\u001d\u0011\u0011)Ba\u0007\u000e\u0005\t]!b\u0001B\ro\u00051AH]8pizJ\u0011!\\\u0005\u0004\u0005?a\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005G\u0011)CA\u0002TKFT1Aa\bm!\u0019!(\u0011\u00069\u00020%\u0019!1\u00067\u0003\rQ+\b\u000f\\33\u0003U\u0011X-\u00193T]\u0006\u00048\u000f[8u)&lWm\u001d;b[B$BA!\r\u00034A!A/^A\u0018\u0011\u0019\tin\ta\u0001a\u0006QQ.Y=cK\u000ecW-\u00198\u0002\u001d\rdW-\u00198T]\u0006\u00048\u000f[8ugR!\u0011Q\u0014B\u001e\u0011\u001d\u0011i$\na\u0001\u0005\u007f\t\u0011\u0002\u001d:fI&\u001c\u0017\r^3\u0011\rQ\u0014\t\u0005]AO\u0013\r\u0011\u0019\u0005\u001c\u0002\n\rVt7\r^5p]F\n\u0011d\u00197fC:\u001cf.\u00199tQ>$8OU3uK:$\u0018n\u001c8Ng\u0006Y2\r\\3b]Ns\u0017\r]:i_R\u001c(+\u001a;f]RLwN\\*ju\u0016\fQCZ8sO\u0016$8K\\1qg\"|Go\u001d\"fM>\u0014X\rF\u0002g\u0005\u001bBaAa\u0014)\u0001\u0004\u0001\u0018A\u00057pON#\u0018M\u001d;T]\u0006\u00048\u000f[8u\u0013\u0012\fqB]3n_Z,7K\\1qg\"|Go\u001d\u000b\u0005\u0003\u001f\u0013)\u0006\u0003\u0004\u0003X%\u0002\rAZ\u0001\u0011Kb\u0004\u0018N]3e':\f\u0007o\u001d5piN\fQa\u00197pg\u0016\fQb\u001d8baNDw\u000e^\"pk:$\u0018\u0001E&bM.\fW*\u001a;bI\u0006$\u0018\rT8h!\r\tI!L\n\u0004[\t\r\u0004c\u0001;\u0003f%\u0019!q\r7\u0003\r\u0005s\u0017PU3g)\t\u0011y&A\u0003baBd\u0017\u0010\u0006\t\u0002\u0014\t=$\u0011\u000fB:\u0005\u0007\u0013)Ia%\u0003\u0016\")Qp\fa\u0001}\"9\u00111X\u0018A\u0002\u0005}\u0006b\u0002B;_\u0001\u0007!qO\u0001\bI\u0006$\u0018\rR5s!\u0011\u0011IHa \u000e\u0005\tm$b\u0001B?{\u0005\u0011\u0011n\\\u0005\u0005\u0005\u0003\u0013YH\u0001\u0003GS2,\u0007\"B-0\u0001\u0004Q\u0006b\u0002BD_\u0001\u0007!\u0011R\u0001\b[\u0016$(/[2t!\u0011\u0011YIa$\u000e\u0005\t5%b\u0001BD;&!!\u0011\u0013BG\u0005\u001diU\r\u001e:jGNDQ!Y\u0018A\u0002\tDq!!\u00020\u0001\u0004\t9!\u0001\tsK\u000e|g/\u001a:T]\u0006\u00048\u000f[8ugR\u0019aMa'\t\u000bE\u0003\u0004\u0019A*\u0002'\u0011,G.\u001a;f':\f\u0007o\u001d5pi\u001aKG.Z:\u0015\u0011\t\u0005&q\u0015B^\u0005{\u0003R\u0001\u001eBR\u0003\u001fK1A!*m\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u0003*F\u0002\rAa+\u0002\r1|w\rR5s!\u0011\u0011iKa.\u000e\u0005\t=&\u0002\u0002BY\u0005g\u000bAAZ5mK*\u0019!QW\u001f\u0002\u00079Lw.\u0003\u0003\u0003:\n=&\u0001\u0002)bi\"DaAa\u00162\u0001\u00041\u0007B\u0002B`c\u0001\u00071*A\u0004m_\u001e<\u0017N\\4")
public final class KafkaMetadataLog
implements ReplicatedLog,
Logging {
    private final AbstractLog log;
    private final Time time;
    private final Scheduler scheduler;
    private final TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots;
    private final TopicPartition topicPartition;
    private final MetadataLogConfig config;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Metrics metrics, Scheduler scheduler, MetadataLogConfig config) {
        return KafkaMetadataLog$.MODULE$.apply(topicPartition, topicId, dataDir, time, metrics, scheduler, config);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ValidOffsetAndEpoch validateOffsetAndEpoch(long x$1, int x$2) {
        return super.validateOffsetAndEpoch(x$1, x$2);
    }

    public long truncateToEndOffset(OffsetAndEpoch x$1) {
        return super.truncateToEndOffset(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AbstractLog log() {
        return this.log;
    }

    public LogFetchInfo read(long startOffset, Isolation readIsolation) {
        Product product;
        if (Isolation.COMMITTED.equals(readIsolation)) {
            product = FetchHighWatermark$.MODULE$;
        } else if (Isolation.UNCOMMITTED.equals(readIsolation)) {
            product = FetchLogEnd$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unhandled read isolation ").append(readIsolation).toString());
        }
        AbstractFetchDataInfo abstractFetchDataInfo = this.log().read(startOffset, this.config.maxFetchSizeInBytes(), (FetchIsolation)product, true, false);
        if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
            throw new IllegalStateException("Raft log should not have fetched tiered data");
        }
        FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
        return new LogFetchInfo(fetchDataInfo.records(), new org.apache.kafka.raft.LogOffsetMetadata(fetchDataInfo.fetchOffsetMetadata().messageOffset(), Optional.of(new SegmentPosition(fetchDataInfo.fetchOffsetMetadata().segmentBaseOffset(), fetchDataInfo.fetchOffsetMetadata().relativePositionInSegment()))));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsLeader(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        MemoryRecords x$1 = (MemoryRecords)records;
        AppendOrigin$RaftLeader$ x$3 = AppendOrigin$RaftLeader$.MODULE$;
        RequestLocal x$4 = RequestLocal$.MODULE$.NoCaching();
        ApiVersion x$5 = this.log().appendAsLeader$default$4();
        return this.handleAndConvertLogAppendInfo(this.log().appendAsLeader(x$1, epoch, x$3, x$5, x$4));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsFollower(Records records) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log().appendAsFollower((MemoryRecords)records));
    }

    private org.apache.kafka.raft.LogAppendInfo handleAndConvertLogAppendInfo(LogAppendInfo appendInfo) {
        Option<LogOffsetMetadata> option = appendInfo.firstOffset();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new KafkaException(new StringBuilder(28).append("Append failed unexpectedly: ").append(appendInfo.errorMessage()).toString());
            }
            throw new MatchError(option);
        }
        LogOffsetMetadata firstOffset = (LogOffsetMetadata)((Some)option).value();
        org.apache.kafka.raft.LogAppendInfo logAppendInfo = new org.apache.kafka.raft.LogAppendInfo(firstOffset.messageOffset(), appendInfo.lastOffset());
        return logAppendInfo;
    }

    public int lastFetchedEpoch() {
        return BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)this.latestSnapshotId().map(snapshotId -> BoxesRunTime.boxToInteger((int)KafkaMetadataLog.$anonfun$lastFetchedEpoch$2(this, snapshotId))).orElse(BoxesRunTime.boxToInteger((int)0)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.earliestSnapshotId()));
        Option<kafka.server.OffsetAndEpoch> option2 = this.log().endOffsetForEpoch(epoch);
        Tuple2 tuple2 = new Tuple2(option2, (Object)option);
        if (option2 instanceof Some) {
            kafka.server.OffsetAndEpoch offsetAndEpoch = (kafka.server.OffsetAndEpoch)((Some)option2).value();
            if (option instanceof Some) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
                if (offsetAndEpoch.offset() == snapshotId.offset && offsetAndEpoch.leaderEpoch() == epoch) {
                    return new OffsetAndEpoch(snapshotId.offset, snapshotId.epoch);
                }
            }
        }
        if (option2 instanceof Some) {
            kafka.server.OffsetAndEpoch offsetAndEpoch = (kafka.server.OffsetAndEpoch)((Some)option2).value();
            return new OffsetAndEpoch(offsetAndEpoch.offset(), offsetAndEpoch.leaderEpoch());
        }
        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)tuple2);
        return new OffsetAndEpoch(this.endOffset().offset, this.lastFetchedEpoch());
    }

    public org.apache.kafka.raft.LogOffsetMetadata endOffset() {
        LogOffsetMetadata endOffsetMetadata = this.log().logEndOffsetMetadata();
        return new org.apache.kafka.raft.LogOffsetMetadata(endOffsetMetadata.messageOffset(), Optional.of(new SegmentPosition(endOffsetMetadata.segmentBaseOffset(), endOffsetMetadata.relativePositionInSegment())));
    }

    public long startOffset() {
        return this.log().localLogStartOffset();
    }

    public void truncateTo(long offset) {
        if (offset < this.highWatermark().offset) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(47).append("Attempt to truncate to offset ").append(offset).append(", which is below ").toString()).append(new StringBuilder(27).append("the current high watermark ").append(this.highWatermark().offset).toString()).toString());
        }
        this.log().truncateTo(offset);
    }

    /*
     * Unable to fully structure code
     */
    public boolean truncateToLatestSnapshot() {
        latestEpoch = BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$truncateToLatestSnapshot$1(), ()I)()));
        var2_2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
        if (!(var2_2 instanceof Some)) ** GOTO lbl-1000
        snapshotId = (OffsetAndEpoch)((Some)var2_2).value();
        if (snapshotId.epoch > latestEpoch || snapshotId.epoch == latestEpoch && snapshotId.offset > this.endOffset().offset) {
            this.log().truncateFullyAndStartAt(snapshotId.offset);
            var4_4 = this.snapshots;
            synchronized (var4_4) {
                var6_5 = this.forgetSnapshotsBefore(snapshotId);
                var5_6 = true;
            }
            var8_7 = var6_5;
            var7_8 = var5_6;
        } else lbl-1000:
        // 2 sources

        {
            var8_7 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            var7_8 = false;
        }
        this.removeSnapshots(var8_7);
        return var7_8;
    }

    public void initializeLeaderEpoch(int epoch) {
        this.log().maybeAssignEpochStartOffset(epoch, this.log().logEndOffset());
    }

    public void updateHighWatermark(org.apache.kafka.raft.LogOffsetMetadata offsetMetadata) {
        OffsetMetadata segmentPosition;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(offsetMetadata.metadata));
        if (option instanceof Some && (segmentPosition = (OffsetMetadata)((Some)option).value()) instanceof SegmentPosition) {
            SegmentPosition segmentPosition2 = (SegmentPosition)segmentPosition;
            this.log().updateHighWatermark(new LogOffsetMetadata(offsetMetadata.offset, segmentPosition2.baseOffset(), segmentPosition2.relativePosition()));
            return;
        }
        this.log().updateHighWatermark(offsetMetadata.offset);
    }

    /*
     * WARNING - void declaration
     */
    public org.apache.kafka.raft.LogOffsetMetadata highWatermark() {
        void var2_2;
        LogOffsetSnapshot logOffsetSnapshot = this.log().fetchOffsetSnapshot();
        if (logOffsetSnapshot == null) {
            throw new MatchError(null);
        }
        LogOffsetMetadata hwm = logOffsetSnapshot.highWatermark();
        Optional segmentPosition = var2_2.messageOffsetOnly() ? Optional.of(new SegmentPosition(var2_2.segmentBaseOffset(), var2_2.relativePositionInSegment())) : Optional.empty();
        return new org.apache.kafka.raft.LogOffsetMetadata(var2_2.messageOffset(), segmentPosition);
    }

    public void flush() {
        this.log().flush();
    }

    public long lastFlushedOffset() {
        return this.log().recoveryPoint();
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Uuid topicId() {
        return (Uuid)this.log().topicId().get();
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        if (snapshotId.offset < this.startOffset()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$createNewSnapshot$1(this, snapshotId);
                Object var6_2 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Optional.empty();
        }
        long highWatermarkOffset = this.highWatermark().offset;
        if (snapshotId.offset > highWatermarkOffset) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Cannot create a snapshot with an id (").append(snapshotId).append(") greater than the high-watermark (").append(highWatermarkOffset).append(")").toString());
        }
        ValidOffsetAndEpoch validOffsetAndEpoch = this.validateOffsetAndEpoch(snapshotId.offset, snapshotId.epoch);
        ValidOffsetAndEpoch.Kind kind = validOffsetAndEpoch.kind();
        ValidOffsetAndEpoch.Kind kind2 = ValidOffsetAndEpoch.Kind.VALID;
        if (kind == null ? kind2 != null : !kind.equals(kind2)) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Snapshot id (").append(snapshotId).append(") is not valid according to the log: ").append(validOffsetAndEpoch).toString());
        }
        return this.storeSnapshot(snapshotId);
    }

    public Optional<RawSnapshotWriter> storeSnapshot(OffsetAndEpoch snapshotId) {
        if (this.snapshots.contains((Object)snapshotId)) {
            return Optional.empty();
        }
        return Optional.of(FileRawSnapshotWriter.create((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId, Optional.of(this)));
    }

    /*
     * Unable to fully structure code
     */
    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        var3_2 = this.snapshots;
        synchronized (var3_2) {
            block8: {
                block7: {
                    var5_3 = false;
                    var6_4 = null;
                    var7_5 = this.snapshots.get((Object)snapshotId);
                    if (!None$.MODULE$.equals(var7_5)) break block7;
                    var2_6 = None$.MODULE$;
                    break block8;
                }
                if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
                var5_3 = true;
                var6_4 = (Some)var7_5;
                var8_7 = (Option)var6_4.value();
                if (None$.MODULE$.equals(var8_7)) {
                    var2_6 = this.liftedTree1$1(snapshotId);
                } else if (var5_3) {
                    var2_6 = (Option)var6_4.value();
                } else {
                    throw new MatchError((Object)var7_5);
                }
            }
            var4_8 = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)var2_6));
            return var4_8;
        }
    }

    public Optional<RawSnapshotReader> latestSnapshot() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional<RawSnapshotReader> optional = this.latestSnapshotId().flatMap(snapshotId -> this.readSnapshot((OffsetAndEpoch)snapshotId));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.lastOption().map((Function1 & Serializable)x0$1 -> {
                void var1_1;
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
                return var1_1;
            })));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> earliestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.headOption().map((Function1 & Serializable)x0$1 -> {
                void var1_1;
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
                return var1_1;
            })));
            return optional;
        }
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            this.snapshots.put((Object)snapshotId, (Object)None$.MODULE$);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            var3_3 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
            if (!(var3_3 instanceof Some)) ** GOTO lbl-1000
            latestSnapshotId = (OffsetAndEpoch)((Some)var3_3).value();
            if (this.snapshots.contains((Object)snapshotId) && this.startOffset() < snapshotId.offset && snapshotId.offset <= latestSnapshotId.offset && this.log().maybeIncrementLogStartOffset(snapshotId.offset, SnapshotGenerated$.MODULE$)) {
                this.log().deleteOldSegments();
                var6_5 = this.forgetSnapshotsBefore(snapshotId);
                var5_6 = true;
            } else lbl-1000:
            // 2 sources

            {
                var6_5 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                var5_6 = false;
            }
        }
        this.removeSnapshots(var6_5);
        return var5_6;
    }

    private Seq<Tuple2<OffsetAndEpoch, Object>> loadSnapshotSizes() {
        return (Seq)this.snapshots.keys().toSeq().flatMap((Function1 & Serializable)snapshotId -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot((OffsetAndEpoch)snapshotId))).map((Function1 & Serializable)reader -> new Tuple2(snapshotId, (Object)BoxesRunTime.boxToLong((long)reader.sizeInBytes()))));
    }

    private Option<Object> readSnapshotTimestamp(OffsetAndEpoch snapshotId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot(snapshotId))).flatMap((Function1 & Serializable)reader -> {
            RecordBatch firstBatch = (RecordBatch)reader.records().batchIterator().next();
            CloseableIterator records = firstBatch.streamingIterator((BufferSupplier)new BufferSupplier.GrowableBufferSupplier());
            if (firstBatch.isControlBatch()) {
                SnapshotHeaderRecord header = ControlRecordUtils.deserializedSnapshotHeaderRecord((Record)((Record)records.next()));
                return new Some((Object)BoxesRunTime.boxToLong((long)header.lastContainedLogTimestamp()));
            }
            if (this.logger().underlying().isWarnEnabled()) {
                String string;
                String string2 = string = "Did not find control record at beginning of snapshot";
                string = null;
                String msgWithLogIdent_msg = string2;
                Object var5_6 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return None$.MODULE$;
        });
    }

    public boolean maybeClean() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            boolean didClean = false;
            boolean bl = (didClean |= this.cleanSnapshotsRetentionSize()) | this.cleanSnapshotsRetentionMs();
            return bl;
        }
    }

    private boolean cleanSnapshots(Function1<OffsetAndEpoch, Object> predicate) {
        if (this.snapshots.size() < 2) {
            return false;
        }
        BooleanRef didClean = BooleanRef.create((boolean)false);
        this.snapshots.keys().toSeq().sliding(2).toSeq().takeWhile((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog.$anonfun$cleanSnapshots$1(this, predicate, didClean, x0$1)));
        return didClean.elem;
    }

    private boolean cleanSnapshotsRetentionMs() {
        boolean bl;
        if (this.config.retentionMillis() < 0L) {
            return false;
        }
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)this.shouldClean$1(snapshotId));
        if (this.snapshots.size() < 2) {
            bl = false;
        } else {
            BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
            this.snapshots.keys().toSeq().sliding(2).toSeq().takeWhile((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog.$anonfun$cleanSnapshots$1(this, predicate, didClean, x0$1)));
            bl = cleanSnapshots_didClean.elem;
        }
        return bl;
    }

    private boolean cleanSnapshotsRetentionSize() {
        boolean bl;
        if (this.config.retentionMaxBytes() < 0L) {
            return false;
        }
        Map snapshotSizes = this.loadSnapshotSizes().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        LongRef snapshotTotalSize = LongRef.create((long)BoxesRunTime.unboxToLong((Object)snapshotSizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)this.shouldClean$2(snapshotId, snapshotSizes, snapshotTotalSize));
        if (this.snapshots.size() < 2) {
            bl = false;
        } else {
            BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
            this.snapshots.keys().toSeq().sliding(2).toSeq().takeWhile((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog.$anonfun$cleanSnapshots$1(this, predicate, didClean, x0$1)));
            bl = cleanSnapshots_didClean.elem;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> forgetSnapshotsBefore(OffsetAndEpoch logStartSnapshotId) {
        void var2_2;
        TreeMap expiredSnapshots = (TreeMap)((MapOps)this.snapshots.until((Object)logStartSnapshotId)).clone();
        this.snapshots.$minus$minus$eq((IterableOnce)expiredSnapshots.keys());
        return var2_2;
    }

    private void removeSnapshots(TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots) {
        expiredSnapshots.foreach((Function1 & Serializable)x0$1 -> {
            KafkaMetadataLog.$anonfun$removeSnapshots$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        if (expiredSnapshots.nonEmpty()) {
            this.scheduler.schedule("delete-snapshot-files", KafkaMetadataLog$.MODULE$.kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(this.log().dir().toPath(), expiredSnapshots, this), this.config.fileDeleteDelayMs(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
        }
    }

    public void close() {
        this.log().close();
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            ((IterableOnceOps)this.snapshots.values().flatten(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
            this.snapshots.clear();
            return;
        }
    }

    public int snapshotCount() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            int n = this.snapshots.size();
            return n;
        }
    }

    public static final /* synthetic */ int $anonfun$lastFetchedEpoch$2(KafkaMetadataLog $this, OffsetAndEpoch snapshotId) {
        long logEndOffset = $this.endOffset().offset;
        if (snapshotId.offset == $this.startOffset() && snapshotId.offset == logEndOffset) {
            return snapshotId.epoch;
        }
        throw new KafkaException(new StringBuilder(0).append(new StringBuilder(64).append("Log doesn't have a last fetch epoch and there is a snapshot (").append(snapshotId).append("). ").toString()).append(new StringBuilder(68).append("Expected the snapshot's end offset to match the log's end offset (").append(logEndOffset).append(") ").toString()).append(new StringBuilder(27).append("and the log start offset (").append($this.startOffset()).append(")").toString()).toString());
    }

    public static final /* synthetic */ int $anonfun$truncateToLatestSnapshot$1() {
        return 0;
    }

    public static final /* synthetic */ String $anonfun$createNewSnapshot$1(KafkaMetadataLog $this, OffsetAndEpoch snapshotId$1) {
        return new StringBuilder(72).append("Cannot create a snapshot with an id (").append(snapshotId$1).append(") less than the log start offset (").append($this.startOffset()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$readSnapshot$1(OffsetAndEpoch snapshotId$2, Path path$1) {
        return new StringBuilder(47).append("Couldn't read ").append(snapshotId$2).append("; expected to find snapshot file ").append(path$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Option liftedTree1$1(OffsetAndEpoch snapshotId$2) {
        try {
            void var2_2;
            Some snapshotReader = new Some((Object)FileRawSnapshotReader.open((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2));
            this.snapshots.put((Object)snapshotId$2, (Object)snapshotReader);
            return var2_2;
        }
        catch (NoSuchFileException noSuchFileException) {
            Path path = Snapshots.snapshotPath((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2);
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$readSnapshot$1(snapshotId$2, path);
                Object var4_4 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.snapshots.remove((Object)snapshotId$2);
            return None$.MODULE$;
        }
    }

    public static final /* synthetic */ String $anonfun$readSnapshotTimestamp$2() {
        return "Did not find control record at beginning of snapshot";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$cleanSnapshots$1(KafkaMetadataLog $this, Function1 predicate$1, BooleanRef didClean$1, Seq x0$1) {
        if (x0$1 == null) return false;
        SeqOps seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1);
        if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return false;
        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return false;
        OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        if (snapshot == null) return false;
        if (nextSnapshot == null) return false;
        if (!BoxesRunTime.unboxToBoolean((Object)predicate$1.apply((Object)snapshot))) return false;
        if (!$this.deleteBeforeSnapshot(nextSnapshot)) return false;
        didClean$1.elem = true;
        return true;
    }

    private final boolean shouldClean$1(OffsetAndEpoch snapshotId) {
        long now = this.time.milliseconds();
        return this.readSnapshotTimestamp(snapshotId).exists((Function1)(JFunction1.mcZJ.sp & Serializable)timestamp -> now - timestamp > $this.config.retentionMillis());
    }

    private final boolean shouldClean$2(OffsetAndEpoch snapshotId, Map snapshotSizes$1, LongRef snapshotTotalSize$1) {
        return snapshotSizes$1.get((Object)snapshotId).exists((Function1)(JFunction1.mcZJ.sp & Serializable)snapshotSize -> {
            if (this.log().size() + snapshotTotalSize$1.elem > $this.config.retentionMaxBytes()) {
                snapshotTotalSize$1.elem -= snapshotSize;
                return true;
            }
            return false;
        });
    }

    public static final /* synthetic */ String $anonfun$removeSnapshots$2(OffsetAndEpoch snapshotId$4) {
        return new StringBuilder(30).append("Marking snapshot ").append(snapshotId$4).append(" for deletion").toString();
    }

    public static final /* synthetic */ void $anonfun$removeSnapshots$1(KafkaMetadataLog $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
            if ($this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$removeSnapshots$2(snapshotId);
                Object var3_3 = null;
                $this.logger().underlying().info(Logging.msgWithLogIdent$($this, msgWithLogIdent_msg));
            }
            Snapshots.markForDelete((Path)$this.log().dir().toPath(), (OffsetAndEpoch)snapshotId);
            return;
        }
        throw new MatchError(null);
    }

    public KafkaMetadataLog(AbstractLog log, Time time, Scheduler scheduler, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots, TopicPartition topicPartition, MetadataLogConfig config) {
        this.log = log;
        this.time = time;
        this.scheduler = scheduler;
        this.snapshots = snapshots;
        this.topicPartition = topicPartition;
        this.config = config;
        this.logIdent_$eq(new StringBuilder(34).append("[MetadataLog partition=").append(topicPartition).append(", nodeId=").append(config.nodeId()).append("] ").toString());
    }
}

