/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.yammer.metrics.core.Histogram;
import java.io.File;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import kafka.log.AbstractLog;
import kafka.log.Defaults$;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.MergedLog;
import kafka.log.NoOpLogOffsetsListener$;
import kafka.log.TierLogComponents;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.MetadataLogConfig;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.Snapshots;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class KafkaMetadataLog$ {
    public static final KafkaMetadataLog$ MODULE$ = new KafkaMetadataLog$();

    public KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Metrics metrics, Scheduler scheduler, MetadataLogConfig config) {
        NoOpLogOffsetsListener$ noOpLogOffsetsListener$;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Integer.toString(config.maxBatchSizeInBytes()));
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), BoxesRunTime.boxToInteger((int)config.logSegmentBytes()));
        props.put(LogConfig$.MODULE$.SegmentMsProp(), BoxesRunTime.boxToLong((long)config.logSegmentMillis()));
        props.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.FileDeleteDelayMs()));
        LogConfig$.MODULE$.validateValues(props);
        LogConfig defaultLogConfig = new LogConfig(props, LogConfig$.MODULE$.apply$default$2());
        if (config.logSegmentBytes() < config.logSegmentMinBytes()) {
            throw new InvalidConfigurationException(new StringBuilder(18).append("Cannot set ").append(KafkaConfig$.MODULE$.MetadataLogSegmentBytesProp()).append(" below ").append(config.logSegmentMinBytes()).toString());
        }
        BrokerTopicStats x$6 = new BrokerTopicStats();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(5);
        Some x$13 = new Some((Object)topicId);
        None$ x$15 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        NoOpLogOffsetsListener$ noOpLogOffsetsListener$2 = noOpLogOffsetsListener$ = NoOpLogOffsetsListener$.MODULE$;
        noOpLogOffsetsListener$ = null;
        NoOpLogOffsetsListener$ x$17 = noOpLogOffsetsListener$2;
        MergedLog log = Log$.MODULE$.apply(dataDir, defaultLogConfig, 0L, 0L, scheduler, x$6, metrics, time, Integer.MAX_VALUE, Integer.MAX_VALUE, x$11, (Option<TierLogComponents>)x$15, false, (Option<Uuid>)x$13, true, x$17, (Option<Histogram>)x$16);
        KafkaMetadataLog metadataLog = new KafkaMetadataLog(log, time, scheduler, this.recoverSnapshots(log), topicPartition, config);
        if (config.logSegmentMinBytes() != 0x800000 && metadataLog.logger().underlying().isErrorEnabled()) {
            String msgWithLogIdent_msg = KafkaMetadataLog$.$anonfun$apply$1();
            Object var19_19 = null;
            metadataLog.logger().underlying().error(Logging.msgWithLogIdent$(metadataLog, msgWithLogIdent_msg));
        }
        metadataLog.truncateToLatestSnapshot();
        return metadataLog;
    }

    /*
     * WARNING - void declaration
     */
    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> recoverSnapshots(AbstractLog log) {
        void var2_2;
        TreeMap snapshots = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        try (DirectoryStream<Path> filesInDir = Files.newDirectoryStream(log.dir().toPath());){
            filesInDir.forEach(path -> Snapshots.parse((Path)path).ifPresent(snapshotPath -> {
                if (snapshotPath.partial || snapshotPath.deleted || snapshotPath.snapshotId.offset < log.logStartOffset()) {
                    Files.deleteIfExists(snapshotPath.path);
                    return;
                }
                snapshots.put((Object)snapshotPath.snapshotId, (Object)None$.MODULE$);
            }));
        }
        return var2_2;
    }

    public Function0<BoxedUnit> kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(Path logDir, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots, Logging logging) {
        return (JFunction0.mcV.sp & Serializable)() -> expiredSnapshots.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog$.$anonfun$deleteSnapshotFiles$2(logging, logDir, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$apply$1() {
        return new StringBuilder(0).append(new StringBuilder(51).append("Overriding ").append(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp()).append(" is only supported for testing. Setting ").toString()).append("this value too low may lead to an inability to write batches of metadata records.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$deleteSnapshotFiles$2(Logging logging$1, Path logDir$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
        ((Option)x0$1._2()).foreach((Function1 & Serializable)reader -> {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> reader.close(), logging$1, Level.WARN);
            return BoxedUnit.UNIT;
        });
        boolean bl = Snapshots.deleteIfExists((Path)logDir$1, (OffsetAndEpoch)snapshotId);
        return bl;
    }

    private KafkaMetadataLog$() {
    }
}

