/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionQuotas$;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.TooManyConnectionsException;
import kafka.server.ProcessorQueueSizePercentiles$;
import kafka.server.QueueSizePercentiles;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\ruf!\u0002,X\u0001e[\u0006\u0002\u00034\u0001\u0005\u000b\u0007I\u0011\u00015\t\u0011=\u0004!\u0011!Q\u0001\n%D\u0001\u0002\u001d\u0001\u0003\u0002\u0004%\t!\u001d\u0005\tq\u0002\u0011\t\u0019!C\u0001s\"Aq\u0010\u0001B\u0001B\u0003&!\u000fC\u0005\u0002\n\u0001\u0011)\u0019!C\u0001c\"I\u00111\u0002\u0001\u0003\u0002\u0003\u0006IA\u001d\u0005\n\u0003\u001b\u0001!\u0011!Q\u0001\nID!\"a\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\t\u0011%\u0019\u0007A!A!\u0002\u0013\t9\u0002\u0003\u0006\u00020\u0001\u0011\t\u0011)A\u0005\u0003cA!\"a\u0012\u0001\u0005\u0003\u0005\u000b\u0011BA%\u0011)\t)\u0006\u0001B\u0001B\u0003%\u0011\u0011\u0007\u0005\b\u0003/\u0002A\u0011AA-\u0011%\ty\u0007\u0001b\u0001\n\u0013\t\t\b\u0003\u0005\u0002\b\u0002\u0001\u000b\u0011BA:\u0011%\tI\t\u0001b\u0001\n\u0003\tY\t\u0003\u0005\u0002\u0014\u0002\u0001\u000b\u0011BAG\u0011%\t)\n\u0001b\u0001\n\u0013\t9\n\u0003\u0005\u00020\u0002\u0001\u000b\u0011BAM\u0011%\t\t\f\u0001b\u0001\n\u0013\t\u0019\f\u0003\u0005\u0002J\u0002\u0001\u000b\u0011BA[\u0011%\tY\r\u0001b\u0001\n\u0013\ti\r\u0003\u0005\u0002f\u0002\u0001\u000b\u0011BAh\u0011%\t9\u000f\u0001b\u0001\n\u0013\ti\r\u0003\u0005\u0002j\u0002\u0001\u000b\u0011BAh\u0011%\tY\u000f\u0001b\u0001\n\u0013\ti\u000f\u0003\u0005\u0002v\u0002\u0001\u000b\u0011BAx\u0011)\t9\u0010\u0001b\u0001\n\u00039\u0016Q\u001e\u0005\t\u0003s\u0004\u0001\u0015!\u0003\u0002p\"A\u00111 \u0001A\u0002\u0013%\u0011\u000fC\u0005\u0002~\u0002\u0001\r\u0011\"\u0003\u0002\u0000\"9!1\u0001\u0001!B\u0013\u0011\bB\u0003B\u0003\u0001\t\u0007I\u0011A,\u0003\b!A!q\u001a\u0001!\u0002\u0013\u0011I\u0001C\u0005\u0003R\u0002\u0001\r\u0011\"\u0003\u0003J!I!1\u001b\u0001A\u0002\u0013%!Q\u001b\u0005\t\u00053\u0004\u0001\u0015)\u0003\u0003L\u00199!1\u0003\u0001A/\nU\u0001B\u0003B\u001eO\tU\r\u0011\"\u0001\u0003>!Q!QI\u0014\u0003\u0012\u0003\u0006IAa\u0010\t\u0015\t\u001dsE!f\u0001\n\u0003\u0011I\u0005\u0003\u0006\u0003R\u001d\u0012\t\u0012)A\u0005\u0005\u0017Bq!a\u0016(\t\u0003\u0011\u0019\u0006C\u0004\u0003Z\u001d\"\tEa\u0017\t\u0013\t\u0005t%!A\u0005\u0002\t\r\u0004\"\u0003B5OE\u0005I\u0011\u0001B6\u0011%\u0011\tiJI\u0001\n\u0003\u0011\u0019\tC\u0005\u0003\b\u001e\n\t\u0011\"\u0011\u0003\n\"A!QS\u0014\u0002\u0002\u0013\u0005\u0011\u000fC\u0005\u0003\u0018\u001e\n\t\u0011\"\u0001\u0003\u001a\"I!1U\u0014\u0002\u0002\u0013\u0005#Q\u0015\u0005\n\u0005_;\u0013\u0011!C\u0001\u0005cC\u0011Ba/(\u0003\u0003%\tE!0\t\u0013\t\u0005w%!A\u0005B\t\r\u0007\"\u0003BcO\u0005\u0005I\u0011\tBd\u0011%\u0011ImJA\u0001\n\u0003\u0012Ym\u0002\u0006\u0003\\\u0002\t\t\u0011#\u0001X\u0005;4!Ba\u0005\u0001\u0003\u0003E\ta\u0016Bp\u0011\u001d\t9f\u000fC\u0001\u0005oD\u0011B!2<\u0003\u0003%)Ea2\t\u0013\te8(!A\u0005\u0002\nm\b\"CB\u0001w\u0005\u0005I\u0011QB\u0002\u0011!\u0019)\u0002\u0001C\u0001/\u000e]\u0001\u0002CB\u0014\u0001\u0011\u0005qk!\u000b\t\u000f\r\u001d\u0002\u0001\"\u0003\u0004.!A1\u0011\b\u0001\u0005\u0002]\u001bY\u0004C\u0004\u0004L\u0001!\te!\u0014\t\u000f\r=\u0003\u0001\"\u0011\u0004N!91\u0011\u000b\u0001\u0005\u0002\r5\u0003bBB*\u0001\u0011%1Q\u000b\u0005\t\u0007/\u0002A\u0011A,\u0004Z!91\u0011\u000e\u0001\u0005\n\r-\u0004bBB;\u0001\u0011%1Q\n\u0005\b\u0007o\u0002A\u0011BB=\u0011\u001d\u00199\t\u0001C\u0005\u0007\u001bBqa!#\u0001\t\u0013\u0019i\u0005C\u0004\u0004\f\u0002!Ia!$\t\u000f\r}\u0005\u0001\"\u0003\u0004\"\"911\u0015\u0001\u0005\n\r\u0005\u0006bBBS\u0001\u0011\u00051QJ\u0004\u000b\u0007_;\u0016\u0011!E\u00013\u000eEf!\u0003,X\u0003\u0003E\t!WBZ\u0011\u001d\t9f\u0015C\u0001\u0007kC\u0011ba.T#\u0003%\ta!/\u0003\u0011\u0005\u001b7-\u001a9u_JT!\u0001W-\u0002\u000f9,Go^8sW*\t!,A\u0003lC\u001a\\\u0017mE\u0002\u00019\u0002\u0004\"!\u00180\u000e\u0003]K!aX,\u0003)\u0005\u00137\u000f\u001e:bGR\u001cVM\u001d<feRC'/Z1e!\t\tG-D\u0001c\u0015\t\u0019\u0017,A\u0004nKR\u0014\u0018nY:\n\u0005\u0015\u0014'!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006AQM\u001c3Q_&tGo\u0001\u0001\u0016\u0003%\u0004\"A[7\u000e\u0003-T!\u0001\\-\u0002\u000f\rdWo\u001d;fe&\u0011an\u001b\u0002\t\u000b:$\u0007k\\5oi\u0006IQM\u001c3Q_&tG\u000fI\u0001\u000fg\u0016tGMQ;gM\u0016\u00148+\u001b>f+\u0005\u0011\bCA:w\u001b\u0005!(\"A;\u0002\u000bM\u001c\u0017\r\\1\n\u0005]$(aA%oi\u0006\u00112/\u001a8e\u0005V4g-\u001a:TSj,w\fJ3r)\tQX\u0010\u0005\u0002tw&\u0011A\u0010\u001e\u0002\u0005+:LG\u000fC\u0004\u007f\t\u0005\u0005\t\u0019\u0001:\u0002\u0007a$\u0013'A\btK:$')\u001e4gKJ\u001c\u0016N_3!Q\r)\u00111\u0001\t\u0004g\u0006\u0015\u0011bAA\u0004i\nAao\u001c7bi&dW-\u0001\bsK\u000e4()\u001e4gKJ\u001c\u0016N_3\u0002\u001fI,7M\u001e\"vM\u001a,'oU5{K\u0002\naA\\8eK&#\u0017\u0001E2p]:,7\r^5p]F+x\u000e^1t!\ri\u00161C\u0005\u0004\u0003+9&\u0001E\"p]:,7\r^5p]F+x\u000e^1t!\u0011\tI\"a\u000b\u000e\u0005\u0005m!bA2\u0002\u001e)!\u0011qDA\u0011\u0003\u0019\u0019w.\\7p]*\u0019!,a\t\u000b\t\u0005\u0015\u0012qE\u0001\u0007CB\f7\r[3\u000b\u0005\u0005%\u0012aA8sO&!\u0011QFA\u000e\u0005\u001diU\r\u001e:jGN\fA\"\\3ue&\u001c\u0007K]3gSb\u0004B!a\r\u0002B9!\u0011QGA\u001f!\r\t9\u0004^\u0007\u0003\u0003sQ1!a\u000fh\u0003\u0019a$o\\8u}%\u0019\u0011q\b;\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019%!\u0012\u0003\rM#(/\u001b8h\u0015\r\ty\u0004^\u0001\u0005i&lW\r\u0005\u0003\u0002L\u0005ESBAA'\u0015\u0011\ty%!\b\u0002\u000bU$\u0018\u000e\\:\n\t\u0005M\u0013Q\n\u0002\u0005)&lW-A\u0005m_\u001e\u0004&/\u001a4jq\u00061A(\u001b8jiz\"B#a\u0017\u0002^\u0005}\u0013\u0011MA2\u0003K\n9'!\u001b\u0002l\u00055\u0004CA/\u0001\u0011\u00151g\u00021\u0001j\u0011\u0015\u0001h\u00021\u0001s\u0011\u0019\tIA\u0004a\u0001e\"1\u0011Q\u0002\bA\u0002IDq!a\u0004\u000f\u0001\u0004\t\t\u0002\u0003\u0004d\u001d\u0001\u0007\u0011q\u0003\u0005\b\u0003_q\u0001\u0019AA\u0019\u0011\u001d\t9E\u0004a\u0001\u0003\u0013B\u0011\"!\u0016\u000f!\u0003\u0005\r!!\r\u0002\u00179LwnU3mK\u000e$xN]\u000b\u0003\u0003g\u0002B!!\u001e\u0002\u00046\u0011\u0011q\u000f\u0006\u0005\u0003s\nY(\u0001\u0005dQ\u0006tg.\u001a7t\u0015\u0011\ti(a \u0002\u00079LwN\u0003\u0002\u0002\u0002\u0006!!.\u0019<b\u0013\u0011\t))a\u001e\u0003\u0011M+G.Z2u_J\fAB\\5p'\u0016dWm\u0019;pe\u0002\nQb]3sm\u0016\u00148\t[1o]\u0016dWCAAG!\u0011\t)(a$\n\t\u0005E\u0015q\u000f\u0002\u0014'\u0016\u0014h/\u001a:T_\u000e\\W\r^\"iC:tW\r\\\u0001\u000fg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7!\u0003)\u0001(o\\2fgN|'o]\u000b\u0003\u00033\u0003b!a'\u0002&\u0006%VBAAO\u0015\u0011\ty*!)\u0002\u000f5,H/\u00192mK*\u0019\u00111\u0015;\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002(\u0006u%aC!se\u0006L()\u001e4gKJ\u00042!XAV\u0013\r\tik\u0016\u0002\n!J|7-Z:t_J\f1\u0002\u001d:pG\u0016\u001c8o\u001c:tA\u0005\t\u0002O]8dKN\u001cxN]:Ti\u0006\u0014H/\u001a3\u0016\u0005\u0005U\u0006\u0003BA\\\u0003\u000bl!!!/\u000b\t\u0005m\u0016QX\u0001\u0007CR|W.[2\u000b\t\u0005}\u0016\u0011Y\u0001\u000bG>t7-\u001e:sK:$(\u0002BAb\u0003\u007f\nA!\u001e;jY&!\u0011qYA]\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006\u0011\u0002O]8dKN\u001cxN]:Ti\u0006\u0014H/\u001a3!\u0003M\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3s+\t\ty\r\u0005\u0003\u0002R\u0006\u0005XBAAj\u0015\u0011\t).a6\u0002\t\r|'/\u001a\u0006\u0004G\u0006e'\u0002BAn\u0003;\fa!_1n[\u0016\u0014(BAAp\u0003\r\u0019w.\\\u0005\u0005\u0003G\f\u0019NA\u0003NKR,'/\u0001\u000bcY>\u001c7.\u001a3QKJ\u001cWM\u001c;NKR,'\u000fI\u0001\u0015C\u000e\u001cW\r\u001d;CCR\u001c\u0007\u000eV5nK6+G/\u001a:\u0002+\u0005\u001c7-\u001a9u\u0005\u0006$8\r\u001b+j[\u0016lU\r^3sA\u0005ab.\u001a;x_J\\G\u000b\u001b:fC\u0012\u001c8)\u00199bG&$\u0018pU3og>\u0014XCAAx!\u0011\tI\"!=\n\t\u0005M\u00181\u0004\u0002\u0007'\u0016t7o\u001c:\u0002;9,Go^8sWRC'/Z1eg\u000e\u000b\u0007/Y2jif\u001cVM\\:pe\u0002\n\u0001\u0004\u001d:pG\u0016\u001c8o\u001c:Rk\u0016,XmU5{KN+gn]8s\u0003e\u0001(o\\2fgN|'/U;fk\u0016\u001c\u0016N_3TK:\u001cxN\u001d\u0011\u0002+\r,(O]3oiB\u0013xnY3tg>\u0014\u0018J\u001c3fq\u0006I2-\u001e:sK:$\bK]8dKN\u001cxN]%oI\u0016Dx\fJ3r)\rQ(\u0011\u0001\u0005\b}\u0002\n\t\u00111\u0001s\u0003Y\u0019WO\u001d:f]R\u0004&o\\2fgN|'/\u00138eKb\u0004\u0013\u0001\u0005;ie>$H\u000f\\3e'>\u001c7.\u001a;t+\t\u0011I\u0001\u0005\u0004\u0002\u001c\n-!qB\u0005\u0005\u0005\u001b\tiJA\u0007Qe&|'/\u001b;z#V,W/\u001a\t\u0004\u0005#9S\"\u0001\u0001\u0003%\u0011+G.Y=fI\u000ecwn]3T_\u000e\\W\r^\n\nO\t]!Q\u0004B\u0018\u0005k\u00012a\u001dB\r\u0013\r\u0011Y\u0002\u001e\u0002\u0007\u0003:L(+\u001a4\u0011\r\t}!\u0011\u0006B\b\u001d\u0011\u0011\tC!\n\u000f\t\u0005]\"1E\u0005\u0002k&\u0019!q\u0005;\u0002\u000fA\f7m[1hK&!!1\u0006B\u0017\u0005\u001dy%\u000fZ3sK\u0012T1Aa\nu!\r\u0019(\u0011G\u0005\u0004\u0005g!(a\u0002)s_\u0012,8\r\u001e\t\u0005\u0005?\u00119$\u0003\u0003\u0003:\t5\"\u0001D*fe&\fG.\u001b>bE2,\u0017AB:pG.,G/\u0006\u0002\u0003@A!\u0011Q\u000fB!\u0013\u0011\u0011\u0019%a\u001e\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003\u001d\u0019xnY6fi\u0002\n\u0011#\u001a8e)\"\u0014x\u000e\u001e;mKRKW.Z't+\t\u0011Y\u0005E\u0002t\u0005\u001bJ1Aa\u0014u\u0005\u0011auN\\4\u0002%\u0015tG\r\u00165s_R$H.\u001a+j[\u0016l5\u000f\t\u000b\u0007\u0005\u001f\u0011)Fa\u0016\t\u000f\tmB\u00061\u0001\u0003@!9!q\t\u0017A\u0002\t-\u0013aB2p[B\f'/\u001a\u000b\u0004e\nu\u0003b\u0002B0[\u0001\u0007!qB\u0001\u0005i\"\fG/\u0001\u0003d_BLHC\u0002B\b\u0005K\u00129\u0007C\u0005\u0003<9\u0002\n\u00111\u0001\u0003@!I!q\t\u0018\u0011\u0002\u0003\u0007!1J\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iG\u000b\u0003\u0003@\t=4F\u0001B9!\u0011\u0011\u0019H! \u000e\u0005\tU$\u0002\u0002B<\u0005s\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tmD/\u0001\u0006b]:|G/\u0019;j_:LAAa \u0003v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0011\u0016\u0005\u0005\u0017\u0012y'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u0017\u0003BA!$\u0003\u00146\u0011!q\u0012\u0006\u0005\u0005#\u000by(\u0001\u0003mC:<\u0017\u0002BA\"\u0005\u001f\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\u001c\n\u0005\u0006cA:\u0003\u001e&\u0019!q\u0014;\u0003\u0007\u0005s\u0017\u0010C\u0004\u007fg\u0005\u0005\t\u0019\u0001:\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa*\u0011\r\t%&1\u0016BN\u001b\t\t\t+\u0003\u0003\u0003.\u0006\u0005&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa-\u0003:B\u00191O!.\n\u0007\t]FOA\u0004C_>dW-\u00198\t\u0011y,\u0014\u0011!a\u0001\u00057\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!1\u0012B`\u0011\u001dqh'!AA\u0002I\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002e\u0006AAo\\*ue&tw\r\u0006\u0002\u0003\f\u00061Q-];bYN$BAa-\u0003N\"Aa0OA\u0001\u0002\u0004\u0011Y*A\tuQJ|G\u000f\u001e7fIN{7m[3ug\u0002\n1\u0004\\1ti\n\u000b7m\u001b9sKN\u001cXO]3DQ\u0016\u001c7\u000eV5nK6\u001b\u0018a\b7bgR\u0014\u0015mY6qe\u0016\u001c8/\u001e:f\u0007\",7m\u001b+j[\u0016l5o\u0018\u0013fcR\u0019!Pa6\t\u0011y,\u0013\u0011!a\u0001\u0005\u0017\nA\u0004\\1ti\n\u000b7m\u001b9sKN\u001cXO]3DQ\u0016\u001c7\u000eV5nK6\u001b\b%\u0001\nEK2\f\u00170\u001a3DY>\u001cXmU8dW\u0016$\bc\u0001B\twM)1H!9\u0003nBQ!1\u001dBu\u0005\u007f\u0011YEa\u0004\u000e\u0005\t\u0015(b\u0001Bti\u00069!/\u001e8uS6,\u0017\u0002\u0002Bv\u0005K\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u0011yO!>\u000e\u0005\tE(\u0002\u0002Bz\u0003\u007f\n!![8\n\t\te\"\u0011\u001f\u000b\u0003\u0005;\fQ!\u00199qYf$bAa\u0004\u0003~\n}\bb\u0002B\u001e}\u0001\u0007!q\b\u0005\b\u0005\u000fr\u0004\u0019\u0001B&\u0003\u001d)h.\u00199qYf$Ba!\u0002\u0004\u0012A)1oa\u0002\u0004\f%\u00191\u0011\u0002;\u0003\r=\u0003H/[8o!\u001d\u00198Q\u0002B \u0005\u0017J1aa\u0004u\u0005\u0019!V\u000f\u001d7fe!I11C \u0002\u0002\u0003\u0007!qB\u0001\u0004q\u0012\u0002\u0014!D1eIB\u0013xnY3tg>\u00148\u000fF\u0003{\u00073\u0019\u0019\u0003C\u0004\u0004\u001c\u0001\u0003\ra!\b\u0002\u001b9,w\u000f\u0015:pG\u0016\u001c8o\u001c:t!\u0019\tYja\b\u0002*&!1\u0011EAO\u0005\u0019\u0011UO\u001a4fe\"91Q\u0005!A\u0002\u0005E\u0012!\u00069s_\u000e,7o]8s)\"\u0014X-\u00193Qe\u00164\u0017\u000e_\u0001\u0010gR\f'\u000f\u001e)s_\u000e,7o]8sgR\u0019!pa\u000b\t\u000f\r\u0015\u0012\t1\u0001\u00022Q)!pa\f\u00048!9\u0011Q\u0013\"A\u0002\rE\u0002C\u0002BU\u0007g\tI+\u0003\u0003\u00046\u0005\u0005&aA*fc\"91Q\u0005\"A\u0002\u0005E\u0012\u0001\u0005:f[>4X\r\u0015:pG\u0016\u001c8o\u001c:t)\u0015Q8QHB!\u0011\u0019\u0019yd\u0011a\u0001e\u0006Y!/Z7pm\u0016\u001cu.\u001e8u\u0011\u001d\u0019\u0019e\u0011a\u0001\u0007\u000b\naB]3rk\u0016\u001cHo\u00115b]:,G\u000eE\u0002^\u0007\u000fJ1a!\u0013X\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0015\u0003i\fQ\"Y<bSR\u001c\u0006.\u001e;e_^t\u0017a\u0001:v]\u0006ia.\u001a=u!J|7-Z:t_J,\"!!+\u0002\u001bI,g/\u001a:tK\u0006sG-\u00113e)\rQ81\f\u0005\b\u0007;B\u0005\u0019AB0\u00039\u0011XM^3sg\u0016\u001c\u0005.\u00198oK2\u0004Ba!\u0019\u0004f5\u001111\r\u0006\u00041\u0006u\u0011\u0002BB4\u0007G\u0012aBU3wKJ\u001cXm\u00115b]:,G.\u0001\tpa\u0016t7+\u001a:wKJ\u001cvnY6fiR1\u0011QRB7\u0007cBqaa\u001cJ\u0001\u0004\t\t$\u0001\u0003i_N$\bBBB:\u0013\u0002\u0007!/\u0001\u0003q_J$\u0018\u0001F1dG\u0016\u0004HOT3x\u0007>tg.Z2uS>t7/\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\u0005\u0007w\u001ai\bE\u0003t\u0007\u000f\u0011y\u0004C\u0004\u0004\u0000-\u0003\ra!!\u0002\u0007-,\u0017\u0010\u0005\u0003\u0002v\r\r\u0015\u0002BBC\u0003o\u0012AbU3mK\u000e$\u0018n\u001c8LKf\f\u0011d\u00197pg\u0016$\u0006N]8ui2,GmQ8o]\u0016\u001cG/[8og\u0006AR.Y=cK\u0006#'.^:u\u0019&\u001cH/\u001a8feF+x\u000e^1\u0002'\u0005\u001c8/[4o\u001d\u0016<8i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0015\tM6qRBJ\u0007/\u001bY\nC\u0004\u0004\u0012:\u0003\rAa\u0010\u0002\u001bM|7m[3u\u0007\"\fgN\\3m\u0011\u001d\u0019)J\u0014a\u0001\u0003S\u000b\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\t\u000f\ree\n1\u0001\u00034\u0006AQ.Y=CY>\u001c7\u000eC\u0004\u0004\u001e:\u0003\rAa\u0013\u0002\u001dM$\u0018M\u001d;US6,g*\u00198pg\u0006\u00113M]3bi\u0016tU\r^<pe.$\u0006N]3bIN\u001c\u0015\r]1dSRL8+\u001a8t_J$\"!a<\u0002=\r\u0014X-\u0019;f!J|7-Z:t_J\fV/Z;f'&TXmU3og>\u0014\u0018AB<bW\u0016,\b\u000fK\u0002R\u0007S\u0003BA!$\u0004,&!1Q\u0016BH\u0005!ye/\u001a:sS\u0012,\u0017\u0001C!dG\u0016\u0004Ho\u001c:\u0011\u0005u\u001b6cA*\u0003\u0018Q\u00111\u0011W\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\rm&\u0006BA\u0019\u0005_\u0002")
public class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final EndPoint endPoint;
    private volatile int sendBufferSize;
    private final int recvBufferSize;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Metrics metrics;
    private final String metricPrefix;
    private final Time time;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final AtomicBoolean processorsStarted;
    private final Meter blockedPercentMeter;
    private final Meter acceptBatchTimeMeter;
    private final Sensor networkThreadsCapacitySensor;
    private final Sensor processorQueueSizeSensor;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;
    private long lastBackpressureCheckTimeMs;

    public static String $lessinit$greater$default$9() {
        return "";
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public void sendBufferSize_$eq(int x$1) {
        this.sendBufferSize = x$1;
    }

    public int recvBufferSize() {
        return this.recvBufferSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    private ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private AtomicBoolean processorsStarted() {
        return this.processorsStarted;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private Meter acceptBatchTimeMeter() {
        return this.acceptBatchTimeMeter;
    }

    private Sensor networkThreadsCapacitySensor() {
        return this.networkThreadsCapacitySensor;
    }

    public Sensor processorQueueSizeSensor() {
        return this.processorQueueSizeSensor;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    private long lastBackpressureCheckTimeMs() {
        return this.lastBackpressureCheckTimeMs;
    }

    private void lastBackpressureCheckTimeMs_$eq(long x$1) {
        this.lastBackpressureCheckTimeMs = x$1;
    }

    public synchronized void addProcessors(Buffer<Processor> newProcessors, String processorThreadPrefix) {
        this.processors().$plus$plus$eq(newProcessors);
        if (this.processorsStarted().get()) {
            this.startProcessors((Seq<Processor>)newProcessors, processorThreadPrefix);
        }
        this.networkThreadsCapacitySensor().record(100.0 * (double)this.processors().size());
    }

    public synchronized void startProcessors(String processorThreadPrefix) {
        if (!this.processorsStarted().getAndSet(true)) {
            this.startProcessors((Seq<Processor>)this.processors(), processorThreadPrefix);
        }
    }

    private synchronized void startProcessors(Seq<Processor> processors, String processorThreadPrefix) {
        processors.foreach((Function1 & Serializable)processor -> {
            Acceptor.$anonfun$startProcessors$1(this, processorThreadPrefix, processor);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeProcessors(int removeCount, RequestChannel requestChannel) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable)x$22 -> {
            x$22.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)x$23 -> {
            x$23.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)processor -> {
            requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
        this.networkThreadsCapacitySensor().record(100.0 * (double)this.processors().size());
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$24 -> {
                x$24.initiateShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$25 -> {
                x$25.awaitShutdown();
                return BoxedUnit.UNIT;
            });
        }
        this.removeMetric(new StringBuilder(22).append(this.metricPrefix).append("AcceptorBlockedPercent").toString(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)this.endPoint().listenerName().value())}))));
        this.removeMetric(new StringBuilder(20).append(this.metricPrefix).append("AcceptBatchTimeNanos").toString(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)this.endPoint().listenerName().value())}))));
        this.metrics.removeSensor(this.networkThreadsCapacitySensor().name());
        this.metrics.removeSensor(this.processorQueueSizeSensor().name());
    }

    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                    this.maybeAdjustListenerQuota();
                }
                catch (ControlThrowable controlThrowable) {
                    throw controlThrowable;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.throttledSockets().foreach((Function1 & Serializable)throttledSocket -> {
                this.closeSocket(throttledSocket.socket());
                return BoxedUnit.UNIT;
            });
            this.throttledSockets().clear();
            this.shutdownComplete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Processor nextProcessor() {
        void var1_1;
        this.currentProcessorIndex_$eq(this.currentProcessorIndex() % this.processors().length());
        Processor processor = (Processor)this.processors().apply(this.currentProcessorIndex());
        this.currentProcessorIndex_$eq(this.currentProcessorIndex() + 1);
        return var1_1;
    }

    public void reverseAndAdd(ReverseChannel reverseChannel) {
        this.connectionQuotas.inc(this.endPoint().listenerName(), reverseChannel.channel().socketAddress(), this.blockedPercentMeter());
        this.nextProcessor().reverseAndAdd(reverseChannel);
    }

    private ServerSocketChannel openServerSocket(String host, int port) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (this.recvBufferSize() != -1) {
            serverChannel.socket().setReceiveBufferSize(this.recvBufferSize());
        }
        try {
            serverChannel.socket().bind(socketAddress);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            long startNanos = this.time.nanoseconds();
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.isRunning()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
            this.acceptBatchTimeMeter().mark(this.time.nanoseconds() - startNanos);
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas.inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            socketChannel.configureBlocking(false);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setKeepAlive(true);
            if (this.sendBufferSize() != -1) {
                socketChannel.socket().setSendBufferSize(this.sendBufferSize());
            }
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$26)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            this.closeSocket(closingSocket.socket());
        }
    }

    private void maybeAdjustListenerQuota() {
        long timeMs = this.time.milliseconds();
        if (this.lastBackpressureCheckTimeMs() + ConnectionQuotas$.MODULE$.ConnectionBackpressureCheckIntervalMs() < timeMs) {
            this.connectionQuotas.maybeAdjustListenerQuota(this.endPoint().listenerName());
            this.lastBackpressureCheckTimeMs_$eq(timeMs);
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock, long startTimeNanos) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter(), startTimeNanos, this.processorQueueSizeSensor())) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(28).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").toString()).append(new StringBuilder(32).append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").toString()).append(new StringBuilder(39).append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").toString()).append(new StringBuilder(39).append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString()).toString());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Sensor createNetworkThreadsCapacitySensor() {
        void var2_2;
        void add_stat;
        void add_metricName;
        String listenerName = this.endPoint().listenerName().value();
        Sensor networkThreadsCapacitySensor = this.metrics.sensor(new StringBuilder(30).append("TotalNetworkThreadsPercentage-").append(listenerName).toString());
        Value value = new Value();
        MetricName metricName = ThreadUsageMetrics$.MODULE$.networkThreadPoolCapacityMetricName(this.metrics, listenerName);
        if (networkThreadsCapacitySensor == null) {
            throw null;
        }
        networkThreadsCapacitySensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Sensor createProcessorQueueSizeSensor() {
        void var2_2;
        void add_stat;
        void createPercentiles_tags;
        void createPercentiles_metricNamePrefix;
        void createPercentiles_queueSize;
        void createPercentiles_metrics;
        Percentiles percentiles;
        String listenerName = this.endPoint().listenerName().value();
        Sensor processorQueueSizeSensor = this.metrics.sensor(new StringBuilder(19).append("ProcessorQueueSize-").append(listenerName).toString());
        Map map = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)listenerName)}));
        String string = this.metricPrefix;
        int n = Processor$.MODULE$.ConnectionQueueSize();
        Metrics metrics = this.metrics;
        ProcessorQueueSizePercentiles$ createPercentiles_this = ProcessorQueueSizePercentiles$.MODULE$;
        Percentiles percentiles2 = percentiles = QueueSizePercentiles.createPercentiles$(createPercentiles_this, (Metrics)createPercentiles_metrics, (int)createPercentiles_queueSize, (String)createPercentiles_metricNamePrefix, (Map)createPercentiles_tags);
        Object var3_7 = null;
        metrics = null;
        string = null;
        map = null;
        percentiles = null;
        Percentiles percentiles3 = percentiles2;
        if (processorQueueSizeSensor == null) {
            throw null;
        }
        processorQueueSizeSensor.add((CompoundStat)add_stat, null);
        return var2_2;
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$startProcessors$1(Acceptor $this, String processorThreadPrefix$1, Processor processor) {
        String nonDaemon_name = new StringBuilder(25).append(processorThreadPrefix$1).append("-kafka-network-thread-").append($this.nodeId).append("-").append($this.endPoint().listenerName()).append("-").append($this.endPoint().securityProtocol()).append("-").append(processor.id()).toString();
        Object var3_3 = null;
        new KafkaThread(nonDaemon_name, (Runnable)processor, false).start();
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        long connectionAcceptTimeNanos = $this.time.nanoseconds();
        while (!$this.assignNewConnection(socketChannel, processor = $this.nextProcessor(), --retriesLeft == 0, connectionAcceptTimeNanos)) {
        }
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$26) {
        return x$26.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(EndPoint endPoint, int sendBufferSize, int recvBufferSize, int nodeId, ConnectionQuotas connectionQuotas, Metrics metrics, String metricPrefix, Time time, String logPrefix) {
        this.endPoint = endPoint;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.metrics = metrics;
        this.metricPrefix = metricPrefix;
        this.time = time;
        super(connectionQuotas);
        this.logIdent_$eq(logPrefix);
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port());
        this.processors = new ArrayBuffer();
        this.processorsStarted = new AtomicBoolean();
        this.blockedPercentMeter = this.newMeter(new StringBuilder(22).append(metricPrefix).append("AcceptorBlockedPercent").toString(), "blocked time", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.acceptBatchTimeMeter = this.newMeter(new StringBuilder(20).append(metricPrefix).append("AcceptBatchTimeNanos").toString(), "processing and blocked time for a batch of new connections", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.networkThreadsCapacitySensor = this.createNetworkThreadsCapacitySensor();
        this.processorQueueSizeSensor = this.createProcessorQueueSizeSensor();
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.lastBackpressureCheckTimeMs = time.milliseconds();
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "socket";
                }
                case 1: {
                    return "endThrottleTimeMs";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof DelayedCloseSocket)) return false;
            if (((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() != this.kafka$network$Acceptor$DelayedCloseSocket$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
            if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) return false;
            SocketChannel socketChannel = this.socket();
            SocketChannel socketChannel2 = delayedCloseSocket.socket();
            if (socketChannel == null) {
                if (socketChannel2 != null) {
                    return false;
                }
            } else if (!socketChannel.equals(socketChannel2)) return false;
            if (!delayedCloseSocket.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

