/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import kafka.metrics.AuthenticationLocalTime$;
import kafka.metrics.BrokerLoad$;
import kafka.metrics.BrokerLoadConfig;
import kafka.metrics.BrokerLoadConfig$;
import kafka.metrics.HandshakeLocalTime$;
import kafka.metrics.RequestLocalTime$;
import kafka.metrics.SelectorRegisterTime$;
import kafka.metrics.SelectorServiceMetric;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.ExponentialWeightedAvg;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r%c\u0001B1c\u0001\u001dD\u0011b\u0019\u0001\u0003\u0002\u0003\u0006I!a\u0003\t\u0015\u0005U\u0001A!A!\u0002\u0013\t9\u0002\u0003\u0006\u0002$\u0001\u0011\t\u0011)A\u0005\u0003KAq!!\u000f\u0001\t\u0003\tY\u0004\u0003\u0006\u0002H\u0001\u0001\r\u0011\"\u0001e\u0003\u0013B!\"!\u0015\u0001\u0001\u0004%\t\u0001ZA*\u0011!\ty\u0006\u0001Q!\n\u0005-\u0003BCA1\u0001\t\u0007I\u0011\u00013\u0002d!A\u00111\u000e\u0001!\u0002\u0013\t)\u0007C\u0005\u0002n\u0001\u0011\r\u0011\"\u0003\u0002p!A\u0011q\u000f\u0001!\u0002\u0013\t\t\bC\u0005\u0002z\u0001\u0011\r\u0011\"\u0003\u0002|!A\u0011\u0011\u0014\u0001!\u0002\u0013\ti\b\u0003\u0006\u0002\u001c\u0002\u0011\r\u0011\"\u0001e\u0003;C\u0001\"a4\u0001A\u0003%\u0011q\u0014\u0005\n\u0003#\u0004\u0001\u0019!C\u0005\u0003'D\u0011\"a7\u0001\u0001\u0004%I!!8\t\u0011\u0005\u0005\b\u0001)Q\u0005\u0003+D\u0011\"a9\u0001\u0001\u0004%I!!:\t\u0013\u00055\b\u00011A\u0005\n\u0005=\b\u0002CAz\u0001\u0001\u0006K!a:\t\u000f\u0005U\b\u0001\"\u0003\u0002T\"9\u0011q\u001f\u0001\u0005\n\u0005\u0015\b\"CA}\u0001\t\u0007I\u0011BA~\u0011!\u0011\u0019\u0001\u0001Q\u0001\n\u0005u\b\"\u0003B\u0003\u0001\t\u0007I\u0011BAs\u0011!\u00119\u0001\u0001Q\u0001\n\u0005\u001d\b\"\u0003B\u0005\u0001\t\u0007I\u0011BA~\u0011!\u0011Y\u0001\u0001Q\u0001\n\u0005u\b\"\u0003B\u0007\u0001\t\u0007I\u0011BAs\u0011!\u0011y\u0001\u0001Q\u0001\n\u0005\u001d\b\"\u0003B\t\u0001\t\u0007I\u0011BA~\u0011!\u0011\u0019\u0002\u0001Q\u0001\n\u0005u\b\"\u0003B\u000b\u0001\t\u0007I\u0011BAs\u0011!\u00119\u0002\u0001Q\u0001\n\u0005\u001d\b\"\u0003B\r\u0001\t\u0007I\u0011BA~\u0011!\u0011Y\u0002\u0001Q\u0001\n\u0005u\b\"\u0003B\u000f\u0001\t\u0007I\u0011BAs\u0011!\u0011y\u0002\u0001Q\u0001\n\u0005\u001d\bb\u0002B\u0011\u0001\u0011\u0005!1\u0005\u0005\b\u0005S\u0001A\u0011\u0001B\u0016\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005WAqA!\r\u0001\t\u0003\u0011Y\u0003C\u0004\u00034\u0001!\tAa\u000b\t\u000f\tU\u0002\u0001\"\u0001\u0003,!9!q\u0007\u0001\u0005\n\te\u0002b\u0002B\u001f\u0001\u0011\u0005!q\b\u0005\b\u0005\u0017\u0002A\u0011\u0001B'\u0011\u001d\u0011Y\u0006\u0001C\u0005\u0005;BqAa\u0019\u0001\t\u0013\u0011)\u0007C\u0004\u0003v\u0001!\tAa\u001e\u0007\r\te\u0004\u0001\u0002B>\u0011\u001d\tI\u0004\u000eC\u0001\u0005\u0013C\u0011Ba$5\u0005\u0004%IA!%\t\u0011\tME\u0007)A\u0005\u0005_BqA!&5\t\u0013\u00119\nC\u0004\u0003$R\"IA!*\t\u000f\tmF\u0007\"\u0011\u0003>\"9!Q\u0019\u0001\u0005B\t\u001d\u0007b\u0002Bj\u0001\u0011\u0005#Q[\u0004\b\u0005?\u0014\u0007\u0012\u0001Bq\r\u0019\t'\r#\u0001\u0003d\"9\u0011\u0011\b \u0005\u0002\t\u0015\bb\u0002Bt}\u0011\u0005!\u0011\u001e\u0005\n\u0005ct\u0014\u0013!C\u0001\u0005gD\u0011b!\u0003?\u0005\u0004%\taa\u0003\t\u0011\r5a\b)A\u0005\u0003\u001bC\u0011ba\u0004?\u0005\u0004%Iaa\u0003\t\u0011\rEa\b)A\u0005\u0003\u001bC\u0011ba\u0005?\u0005\u0004%Iaa\u0003\t\u0011\rUa\b)A\u0005\u0003\u001bC\u0011ba\u0006?\u0005\u0004%Iaa\u0003\t\u0011\rea\b)A\u0005\u0003\u001bC\u0011ba\u0007?\u0005\u0004%Iaa\u0003\t\u0011\rua\b)A\u0005\u0003\u001bC\u0011ba\b?\u0005\u0004%Iaa\u0003\t\u0011\r\u0005b\b)A\u0005\u0003\u001bC\u0011ba\t?\u0005\u0004%Iaa\u0003\t\u0011\r\u0015b\b)A\u0005\u0003\u001bC\u0011ba\n?\u0005\u0004%Iaa\u0003\t\u0011\r%b\b)A\u0005\u0003\u001bC\u0011ba\u000b?\u0005\u0004%Iaa\u0003\t\u0011\r5b\b)A\u0005\u0003\u001bC\u0011ba\f?\u0005\u0004%Iaa\u0003\t\u0011\rEb\b)A\u0005\u0003\u001bC\u0011ba\r?\u0005\u0004%Iaa\u0003\t\u0011\rUb\b)A\u0005\u0003\u001bC\u0011ba\u000e?\u0005\u0004%Iaa\u0003\t\u0011\reb\b)A\u0005\u0003\u001bC\u0011ba\u000f?\u0005\u0004%Iaa\u0003\t\u0011\rub\b)A\u0005\u0003\u001bC\u0011ba\u0010?\u0005\u0004%Iaa\u0003\t\u0011\r\u0005c\b)A\u0005\u0003\u001bC\u0011ba\u0011?\u0005\u0004%Iaa\u0003\t\u0011\r\u0015c\b)A\u0005\u0003\u001bC\u0011ba\u0012?#\u0003%\tAa=\u0003\u0015\t\u0013xn[3s\u0019>\fGM\u0003\u0002dI\u00069Q.\u001a;sS\u000e\u001c(\"A3\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u001b8u!\tIG.D\u0001k\u0015\u0005Y\u0017!B:dC2\f\u0017BA7k\u0005\u0019\te.\u001f*fMB\u0011qN]\u0007\u0002a*\u0011\u0011\u000fZ\u0001\u0006kRLGn]\u0005\u0003gB\u0014q\u0001T8hO&tw\rE\u0002v\u0003\u000bq1A^A\u0001\u001b\u00059(B\u0001=z\u0003\u001dqW\r^<pe.T!A_>\u0002\r\r|W.\\8o\u0015\t)GP\u0003\u0002~}\u00061\u0011\r]1dQ\u0016T\u0011a`\u0001\u0004_J<\u0017bAA\u0002o\u0006A1+\u001a7fGR|'/\u0003\u0003\u0002\b\u0005%!AE(o\u001d\u0016<XI^3oi2K7\u000f^3oKJT1!a\u0001x!\u0011\ti!!\u0005\u000e\u0005\u0005=!BA2z\u0013\u0011\t\u0019\"a\u0004\u0003\u000f5+GO]5dg\u000611m\u001c8gS\u001e\u0004B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;!\u0017AB:feZ,'/\u0003\u0003\u0002\"\u0005m!aC&bM.\f7i\u001c8gS\u001e\f1#\\;mi&$VM\\1oi6+G/\u00193bi\u0006\u0004R![A\u0014\u0003WI1!!\u000bk\u0005\u0019y\u0005\u000f^5p]B!\u0011QFA\u001b\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012aC7vYRLG/\u001a8b]RT1!!\b|\u0013\u0011\t9$a\f\u0003'5+H\u000e^5UK:\fg\u000e^'fi\u0006$\u0017\r^1\u0002\rqJg.\u001b;?)!\ti$!\u0011\u0002D\u0005\u0015\u0003cAA \u00015\t!\r\u0003\u0004d\t\u0001\u0007\u00111\u0002\u0005\b\u0003+!\u0001\u0019AA\f\u0011%\t\u0019\u0003\u0002I\u0001\u0002\u0004\t)#\u0001\tce>\\WM\u001d'pC\u0012\u001cuN\u001c4jOV\u0011\u00111\n\t\u0005\u0003\u007f\ti%C\u0002\u0002P\t\u0014\u0001C\u0011:pW\u0016\u0014Hj\\1e\u0007>tg-[4\u0002)\t\u0014xn[3s\u0019>\fGmQ8oM&<w\fJ3r)\u0011\t)&a\u0017\u0011\u0007%\f9&C\u0002\u0002Z)\u0014A!\u00168ji\"I\u0011Q\f\u0004\u0002\u0002\u0003\u0007\u00111J\u0001\u0004q\u0012\n\u0014!\u00052s_.,'\u000fT8bI\u000e{gNZ5hA\u0005aQ.\u001a;sS\u000e\u001cuN\u001c4jOV\u0011\u0011Q\r\t\u0005\u0003\u001b\t9'\u0003\u0003\u0002j\u0005=!\u0001D'fiJL7mQ8oM&<\u0017!D7fiJL7mQ8oM&<\u0007%A\nj]R,'O\u0011:pW\u0016\u0014H*[:uK:,'/\u0006\u0002\u0002rA\u0019a/a\u001d\n\u0007\u0005UtO\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\u000bj]R,'O\u0011:pW\u0016\u0014H*[:uK:,'\u000fI\u0001\u0019[VdG/\u001b+f]\u0006tG\u000fT5ti\u0016tWM\u001d(b[\u0016\u001cXCAA?!\u0019\ty(!#\u0002\u000e6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))\u0001\u0003vi&d'BAAD\u0003\u0011Q\u0017M^1\n\t\u0005-\u0015\u0011\u0011\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0010\u0006UUBAAI\u0015\u0011\t\u0019*!\"\u0002\t1\fgnZ\u0005\u0005\u0003/\u000b\tJ\u0001\u0004TiJLgnZ\u0001\u001a[VdG/\u001b+f]\u0006tG\u000fT5ti\u0016tWM\u001d(b[\u0016\u001c\b%\u0001\ftK2,7\r^8s'\u0016\u0014h/[2f\u001b\u0016$(/[2t+\t\ty\n\u0005\u0005\u0002\"\u0006=\u0016QWA^\u001d\u0011\t\u0019+a+\u0011\u0007\u0005\u0015&.\u0004\u0002\u0002(*\u0019\u0011\u0011\u00164\u0002\rq\u0012xn\u001c;?\u0013\r\tiK[\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00161\u0017\u0002\u0004\u001b\u0006\u0004(bAAWUB!\u0011qHA\\\u0013\r\tIL\u0019\u0002\u0016'\u0016dWm\u0019;peN+'O^5dK6+GO]5d!\u0019\ti,a1\u0002H6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\f\t)\u0001\u0006d_:\u001cWO\u001d:f]RLA!!2\u0002@\n\u00192i\u001c9z\u001f:<&/\u001b;f\u0003J\u0014\u0018-_*fiB!\u0011\u0011ZAf\u001b\u0005I\u0018bAAgs\n1Q*\u001a;sS\u000e\fqc]3mK\u000e$xN]*feZL7-Z'fiJL7m\u001d\u0011\u0002\u00135,GO]5d)\u0006<WCAAk!!\t\t+a,\u0002X\u0006]\u0007\u0003BAQ\u00033LA!a&\u00024\u0006iQ.\u001a;sS\u000e$\u0016mZ0%KF$B!!\u0016\u0002`\"I\u0011QL\t\u0002\u0002\u0003\u0007\u0011Q[\u0001\u000b[\u0016$(/[2UC\u001e\u0004\u0013AC7fiJL7MT1nKV\u0011\u0011q\u001d\t\u0005\u0003\u0013\fI/C\u0002\u0002lf\u0014!\"T3ue&\u001cg*Y7f\u00039iW\r\u001e:jG:\u000bW.Z0%KF$B!!\u0016\u0002r\"I\u0011Q\f\u000b\u0002\u0002\u0003\u0007\u0011q]\u0001\f[\u0016$(/[2OC6,\u0007%A\nce>\\WM\u001d'pC\u0012lU\r\u001e:jGR\u000bw-A\u000ece>\\WM\u001d'pC\u0012\u0004VM]2f]RlU\r\u001e:jG:\u000bW.Z\u0001\u001ci>$\u0018\r\\*feZL7-\u001a'pG\u0006dG+[7f'\u0016t7o\u001c:\u0016\u0005\u0005u\b\u0003BA\u0007\u0003\u007fLAA!\u0001\u0002\u0010\t11+\u001a8t_J\fA\u0004^8uC2\u001cVM\u001d<jG\u0016dunY1m)&lWmU3og>\u0014\b%\u0001\u0018xK&<\u0007\u000e^3e\u0003Z,'/Y4f)>$\u0018\r\\*feZL7-\u001a'pG\u0006dG+[7f\u001b\u0016$(/[2OC6,\u0017aL<fS\u001eDG/\u001a3Bm\u0016\u0014\u0018mZ3U_R\fGnU3sm&\u001cW\rT8dC2$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013\u0001J3yi\u0016\u0014h.\u00197OKR<xN]6UQJ,\u0017\rZ%eY\u0016\u0014\u0016\r^5p'\u0016t7o\u001c:\u0002K\u0015DH/\u001a:oC2tU\r^<pe.$\u0006N]3bI&#G.\u001a*bi&|7+\u001a8t_J\u0004\u0013aN<fS\u001eDG/\u001a3Bm\u0016\u0014\u0018mZ3FqR,'O\\1m\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193JI2,'+\u0019;j_6+GO]5d\u001d\u0006lW-\u0001\u001dxK&<\u0007\u000e^3e\u0003Z,'/Y4f\u000bb$XM\u001d8bY:+Go^8sWRC'/Z1e\u0013\u0012dWMU1uS>lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002OI,\u0007\u000f\\5dCRLwN\u001c(fi^|'o\u001b+ie\u0016\fG-\u00133mKJ\u000bG/[8TK:\u001cxN]\u0001)e\u0016\u0004H.[2bi&|gNT3uo>\u00148\u000e\u00165sK\u0006$\u0017\n\u001a7f%\u0006$\u0018n\\*f]N|'\u000fI\u0001;o\u0016Lw\r\u001b;fI\u00063XM]1hKJ+\u0007\u000f\\5dCRLwN\u001c(fi^|'o\u001b+ie\u0016\fG-\u00133mKJ\u000bG/[8NKR\u0014\u0018n\u0019(b[\u0016\f1h^3jO\"$X\rZ!wKJ\fw-\u001a*fa2L7-\u0019;j_:tU\r^<pe.$\u0006N]3bI&#G.\u001a*bi&|W*\u001a;sS\u000et\u0015-\\3!\u0003\r\u0012X-];fgRD\u0015M\u001c3mKJ$\u0006N]3bI&#G.\u001a*bi&|7+\u001a8t_J\fAE]3rk\u0016\u001cH\u000fS1oI2,'\u000f\u00165sK\u0006$\u0017\n\u001a7f%\u0006$\u0018n\\*f]N|'\u000fI\u00017o\u0016Lw\r\u001b;fI\u00063XM]1hKJ+\u0017/^3ti\"\u000bg\u000e\u001a7feRC'/Z1e\u0013\u0012dWMU1uS>lU\r\u001e:jG:\u000bW.Z\u00018o\u0016Lw\r\u001b;fI\u00063XM]1hKJ+\u0017/^3ti\"\u000bg\u000e\u001a7feRC'/Z1e\u0013\u0012dWMU1uS>lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002\u0019U\u0004H-\u0019;f\u0007>tg-[4\u0015\t\u0005U#Q\u0005\u0005\b\u0005OA\u0003\u0019AA\f\u0003%qWm^\"p]\u001aLw-A\fce>\\WM\u001d'pC\u0012\u0004VM]2f]RlU\r\u001e:jGV\u0011!Q\u0006\t\u0006S\u0006\u001d\u0012qY\u0001+o\u0016Lw\r\u001b;fI\u00063XM]1hKR{G/\u00197TKJ4\u0018nY3M_\u000e\fG\u000eV5nK6+GO]5d\u0003M:X-[4ii\u0016$\u0017I^3sC\u001e,W\t\u001f;fe:\fGNT3uo>\u00148\u000e\u00165sK\u0006$\u0017\n\u001a7f%\u0006$\u0018n\\'fiJL7-\u0001\u001cxK&<\u0007\u000e^3e\u0003Z,'/Y4f%\u0016\u0004H.[2bi&|gNT3uo>\u00148\u000e\u00165sK\u0006$\u0017\n\u001a7f%\u0006$\u0018n\\'fiJL7-\u0001\u001axK&<\u0007\u000e^3e\u0003Z,'/Y4f%\u0016\fX/Z:u\u0011\u0006tG\r\\3s)\"\u0014X-\u00193JI2,'+\u0019;j_6+GO]5d\u0003%9W\r^'fiJL7\r\u0006\u0003\u0003.\tm\u0002bBAr]\u0001\u0007\u0011q]\u0001\u0010[>t\u0017\u000e^8s'\u0016dWm\u0019;peR!\u0011Q\u000bB!\u0011\u001d\u0011\u0019e\fa\u0001\u0005\u000b\n\u0001b]3mK\u000e$xN\u001d\t\u0004m\n\u001d\u0013b\u0001B%o\nA1+\u001a7fGR|'/\u0001\fsK\u000e|'\u000f\u001a*fcV,7\u000f\u001e+j[\u0016t\u0015M\\8t)\u0019\t)Fa\u0014\u0003R!9!1\t\u0019A\u0002\t\u0015\u0003b\u0002B*a\u0001\u0007!QK\u0001\ni&lWMT1o_N\u00042!\u001bB,\u0013\r\u0011IF\u001b\u0002\u0005\u0019>tw-A\rsK\u000e|'\u000fZ\"p]:,7\r^5p]RKW.\u001a(b]>\u001cH\u0003BA+\u0005?BqA!\u00192\u0001\u0004\u0011)&\u0001\ru_R\fGnQ8o]\u0016\u001cG/[8o)&lWMT1o_N\faC]3d_J$G\u000b\u001b:fC\u0012\u001c\u0018\n\u001a7f%\u0006$\u0018n\u001c\u000b\u0007\u0003+\u00129Ga\u001b\t\u000f\t%$\u00071\u0001\u0002X\u0006aA.[:uK:,'OT1nK\"9!Q\u000e\u001aA\u0002\t=\u0014!C5eY\u0016\u0014\u0016\r^5p!\rI'\u0011O\u0005\u0004\u0005gR'A\u0002#pk\ndW-A\u0003dY>\u001cX\r\u0006\u0002\u0002V\ty!I]8lKJdu.\u00193HCV<WmE\u00035\u0005{\u0012\u0019\t\u0005\u0003\u0002\u0010\n}\u0014\u0002\u0002BA\u0003#\u0013aa\u00142kK\u000e$\bCBA\u0007\u0005\u000b\u0013y'\u0003\u0003\u0003\b\u0006=!!B$bk\u001e,GC\u0001BF!\r\u0011i\tN\u0007\u0002\u0001\u00051aj\u001c'pC\u0012,\"Aa\u001c\u0002\u000f9{Gj\\1eA\u00051q/Z5hQR$BA!'\u0003 B9\u0011Na'\u0003p\t=\u0014b\u0001BOU\n1A+\u001e9mKJBqA!)9\u0001\u0004\u0011y'A\u0001y\u0003-q\u0017M\\!xCJ,W*\u001b8\u0015\t\t=$q\u0015\u0005\b\u0005SK\u0004\u0019\u0001BV\u0003\u0005!\bC\u0002BW\u0005o\u0013yG\u0004\u0003\u00030\nMf\u0002BAS\u0005cK\u0011a[\u0005\u0004\u0005kS\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\u0013ILC\u0002\u00036*\fQA^1mk\u0016$bAa\u001c\u0003@\n\u0005\u0007bBA\u000bu\u0001\u0007\u0011Q\r\u0005\b\u0005\u0007T\u0004\u0019\u0001B+\u0003\rqwn^\u0001\u0013]>$\u0018NZ=P]\u000e{gN\\3di&|g\u000e\u0006\u0003\u0002V\t%\u0007b\u0002Bfw\u0001\u0007!QZ\u0001\bG\"\fgN\\3m!\r1(qZ\u0005\u0004\u0005#<(\u0001D&bM.\f7\t[1o]\u0016d\u0017a\u00058pi&4\u0017p\u00148UQJ,\u0017\rZ+tC\u001e,GCBA+\u0005/\u0014I\u000eC\u0004\u0003jq\u0002\r!a6\t\u000f\t5D\b1\u0001\u0003\\B!\u0011q\u0012Bo\u0013\u0011\u0011\u0019(!%\u0002\u0015\t\u0013xn[3s\u0019>\fG\rE\u0002\u0002@y\u001a\"A\u00105\u0015\u0005\t\u0005\u0018!B1qa2LH\u0003CA\u001f\u0005W\u0014iOa<\t\r\r\u0004\u0005\u0019AA\u0006\u0011\u001d\t)\u0002\u0011a\u0001\u0003/A\u0011\"a\tA!\u0003\u0005\r!!\n\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM*\"A!>+\t\u0005\u0015\"q_\u0016\u0003\u0005s\u0004BAa?\u0004\u00065\u0011!Q \u0006\u0005\u0005\u007f\u001c\t!A\u0005v]\u000eDWmY6fI*\u001911\u00016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\b\tu(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)\"I]8lKJdu.\u00193NKR\u0014\u0018nY$s_V\u0004XCAAG\u0003Y\u0011%o\\6fe2{\u0017\rZ'fiJL7m\u0012:pkB\u0004\u0013a\u0007\"s_.,'\u000fT8bIB+'oY3oi6+GO]5d\u001d\u0006lW-\u0001\u000fCe>\\WM\u001d'pC\u0012\u0004VM]2f]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002E\t\u0013xn[3s\u0019>\fG\rU3sG\u0016tG/T3ue&\u001cG)Z:de&\u0004H/[8o\u0003\r\u0012%o\\6fe2{\u0017\r\u001a)fe\u000e,g\u000e^'fiJL7\rR3tGJL\u0007\u000f^5p]\u0002\n!dU3sm&\u001cW\rT8dC2$\u0016.\\3TK:\u001cxN\u001d(b[\u0016\f1dU3sm&\u001cW\rT8dC2$\u0016.\\3TK:\u001cxN\u001d(b[\u0016\u0004\u0013AG*feZL7-\u001a'pG\u0006dG+[7f\u001b\u0016$(/[2OC6,\u0017aG*feZL7-\u001a'pG\u0006dG+[7f\u001b\u0016$(/[2OC6,\u0007%A\u0011TKJ4\u0018nY3M_\u000e\fG\u000eV5nK6+GO]5d\t\u0016\u001c8M]5qi&|g.\u0001\u0012TKJ4\u0018nY3M_\u000e\fG\u000eV5nK6+GO]5d\t\u0016\u001c8M]5qi&|g\u000eI\u0001)\u000bb$XM\u001d8bY:+Go^8sWRC'/Z1e\u0013\u0012dWMU1uS>\u001cVM\\:pe:\u000bW.Z\u0001*\u000bb$XM\u001d8bY:+Go^8sWRC'/Z1e\u0013\u0012dWMU1uS>\u001cVM\\:pe:\u000bW.\u001a\u0011\u0002Q\u0015CH/\u001a:oC2tU\r^<pe.$\u0006N]3bI&#G.\u001a*bi&|W*\u001a;sS\u000et\u0015-\\3\u0002S\u0015CH/\u001a:oC2tU\r^<pe.$\u0006N]3bI&#G.\u001a*bi&|W*\u001a;sS\u000et\u0015-\\3!\u0003=*\u0005\u0010^3s]\u0006dg*\u001a;x_J\\G\u000b\u001b:fC\u0012LE\r\\3SCRLw.T3ue&\u001cG)Z:de&\u0004H/[8o\u0003A*\u0005\u0010^3s]\u0006dg*\u001a;x_J\\G\u000b\u001b:fC\u0012LE\r\\3SCRLw.T3ue&\u001cG)Z:de&\u0004H/[8oA\u0005Y#+\u001a9mS\u000e\fG/[8o\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193JI2,'+\u0019;j_N+gn]8s\u001d\u0006lW-\u0001\u0017SKBd\u0017nY1uS>tg*\u001a;x_J\\G\u000b\u001b:fC\u0012LE\r\\3SCRLwnU3og>\u0014h*Y7fA\u0005Y#+\u001a9mS\u000e\fG/[8o\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193JI2,'+\u0019;j_6+GO]5d\u001d\u0006lW-\u0001\u0017SKBd\u0017nY1uS>tg*\u001a;x_J\\G\u000b\u001b:fC\u0012LE\r\\3SCRLw.T3ue&\u001cg*Y7fA\u0005\u0011$+\u001a9mS\u000e\fG/[8o\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193JI2,'+\u0019;j_6+GO]5d\t\u0016\u001c8M]5qi&|g.A\u001aSKBd\u0017nY1uS>tg*\u001a;x_J\\G\u000b\u001b:fC\u0012LE\r\\3SCRLw.T3ue&\u001cG)Z:de&\u0004H/[8oA\u00059#+Z9vKN$\b*\u00198eY\u0016\u0014H\u000b\u001b:fC\u0012LE\r\\3SCRLwnU3og>\u0014h*Y7f\u0003!\u0012V-];fgRD\u0015M\u001c3mKJ$\u0006N]3bI&#G.\u001a*bi&|7+\u001a8t_Jt\u0015-\\3!\u0003\u001d\u0012V-];fgRD\u0015M\u001c3mKJ$\u0006N]3bI&#G.\u001a*bi&|W*\u001a;sS\u000et\u0015-\\3\u0002QI+\u0017/^3ti\"\u000bg\u000e\u001a7feRC'/Z1e\u0013\u0012dWMU1uS>lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002]I+\u0017/^3ti\"\u000bg\u000e\u001a7feRC'/Z1e\u0013\u0012dWMU1uS>lU\r\u001e:jG\u0012+7o\u0019:jaRLwN\\\u00010%\u0016\fX/Z:u\u0011\u0006tG\r\\3s)\"\u0014X-\u00193JI2,'+\u0019;j_6+GO]5d\t\u0016\u001c8M]5qi&|g\u000eI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a")
public class BrokerLoad
implements Logging,
Selector.OnNewEventListener {
    private final Metrics metrics;
    private final Option<MultiTenantMetadata> multiTenantMetadata;
    private BrokerLoadConfig brokerLoadConfig;
    private final MetricConfig metricConfig;
    private final ListenerName interBrokerListener;
    private final java.util.List<String> multiTenantListenerNames;
    private final Map<SelectorServiceMetric, CopyOnWriteArraySet<Metric>> selectorServiceMetrics;
    private Map<String, String> metricTag;
    private MetricName metricName;
    private final Sensor totalServiceLocalTimeSensor;
    private final MetricName weightedAverageTotalServiceLocalTimeMetricName;
    private final Sensor externalNetworkThreadIdleRatioSensor;
    private final MetricName weightedAverageExternalNetworkThreadIdleRatioMetricName;
    private final Sensor replicationNetworkThreadIdleRatioSensor;
    private final MetricName weightedAverageReplicationNetworkThreadIdleRatioMetricName;
    private final Sensor requestHandlerThreadIdleRatioSensor;
    private final MetricName weightedAverageRequestHandlerThreadIdleRatioMetricName;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<MultiTenantMetadata> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public static String BrokerLoadMetricGroup() {
        return BrokerLoad$.MODULE$.BrokerLoadMetricGroup();
    }

    public static Option<MultiTenantMetadata> apply$default$3() {
        return None$.MODULE$;
    }

    public static BrokerLoad apply(Metrics metrics, KafkaConfig config, Option<MultiTenantMetadata> multiTenantMetadata) {
        return new BrokerLoad(metrics, config, multiTenantMetadata);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public BrokerLoadConfig brokerLoadConfig() {
        return this.brokerLoadConfig;
    }

    public void brokerLoadConfig_$eq(BrokerLoadConfig x$1) {
        this.brokerLoadConfig = x$1;
    }

    public MetricConfig metricConfig() {
        return this.metricConfig;
    }

    private ListenerName interBrokerListener() {
        return this.interBrokerListener;
    }

    private java.util.List<String> multiTenantListenerNames() {
        return this.multiTenantListenerNames;
    }

    public Map<SelectorServiceMetric, CopyOnWriteArraySet<Metric>> selectorServiceMetrics() {
        return this.selectorServiceMetrics;
    }

    private Map<String, String> metricTag() {
        return this.metricTag;
    }

    private void metricTag_$eq(Map<String, String> x$1) {
        this.metricTag = x$1;
    }

    private MetricName metricName() {
        return this.metricName;
    }

    private void metricName_$eq(MetricName x$1) {
        this.metricName = x$1;
    }

    private Map<String, String> brokerLoadMetricTag() {
        if (this.multiTenantMetadata.isDefined() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((MultiTenantMetadata)this.multiTenantMetadata.get()).dedicatedLogicalClusterId()))) {
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)((MultiTenantMetadata)this.multiTenantMetadata.get()).dedicatedLogicalClusterId())}));
        }
        return Predef$.MODULE$.Map().empty();
    }

    private MetricName brokerLoadPercentMetricName() {
        if (!this.brokerLoadMetricTag().equals(this.metricTag())) {
            this.metrics.removeMetric(this.metricName());
            this.metricTag_$eq(this.brokerLoadMetricTag());
            this.metricName_$eq(new MetricName(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$BrokerLoadPercentMetricName(), BrokerLoad$.MODULE$.BrokerLoadMetricGroup(), BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$BrokerLoadPercentMetricDescription(), CollectionConverters$.MODULE$.MapHasAsJava(this.metricTag()).asJava()));
            if (!this.metrics.metrics().containsKey(this.metricName())) {
                this.metrics.addMetric(this.metricName(), (MetricValueProvider)new BrokerLoadGauge());
            }
        }
        return this.metricName();
    }

    private Sensor totalServiceLocalTimeSensor() {
        return this.totalServiceLocalTimeSensor;
    }

    private MetricName weightedAverageTotalServiceLocalTimeMetricName() {
        return this.weightedAverageTotalServiceLocalTimeMetricName;
    }

    private Sensor externalNetworkThreadIdleRatioSensor() {
        return this.externalNetworkThreadIdleRatioSensor;
    }

    private MetricName weightedAverageExternalNetworkThreadIdleRatioMetricName() {
        return this.weightedAverageExternalNetworkThreadIdleRatioMetricName;
    }

    private Sensor replicationNetworkThreadIdleRatioSensor() {
        return this.replicationNetworkThreadIdleRatioSensor;
    }

    private MetricName weightedAverageReplicationNetworkThreadIdleRatioMetricName() {
        return this.weightedAverageReplicationNetworkThreadIdleRatioMetricName;
    }

    private Sensor requestHandlerThreadIdleRatioSensor() {
        return this.requestHandlerThreadIdleRatioSensor;
    }

    private MetricName weightedAverageRequestHandlerThreadIdleRatioMetricName() {
        return this.weightedAverageRequestHandlerThreadIdleRatioMetricName;
    }

    public void updateConfig(KafkaConfig newConfig) {
        this.brokerLoadConfig_$eq(new BrokerLoadConfig(this.brokerLoadConfig().sampleWindowSize(), this.brokerLoadConfig().numSamples(), Predef$.MODULE$.Double2double(newConfig.brokerLoadAverageServiceRequestTimeMs()), Predef$.MODULE$.Double2double(newConfig.brokerLoadWorkloadCoefficient())));
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Updated broker load config to ").append(this.brokerLoadConfig()).toString());
    }

    public Option<Metric> brokerLoadPercentMetric() {
        return this.getMetric(this.brokerLoadPercentMetricName());
    }

    public Option<Metric> weightedAverageTotalServiceLocalTimeMetric() {
        return this.getMetric(this.weightedAverageTotalServiceLocalTimeMetricName());
    }

    public Option<Metric> weightedAverageExternalNetworkThreadIdleRatioMetric() {
        return this.getMetric(this.weightedAverageExternalNetworkThreadIdleRatioMetricName());
    }

    public Option<Metric> weightedAverageReplicationNetworkThreadIdleRatioMetric() {
        return this.getMetric(this.weightedAverageReplicationNetworkThreadIdleRatioMetricName());
    }

    public Option<Metric> weightedAverageRequestHandlerThreadIdleRatioMetric() {
        return this.getMetric(this.weightedAverageRequestHandlerThreadIdleRatioMetricName());
    }

    private Option<Metric> getMetric(MetricName metricName) {
        KafkaMetric metric = this.metrics.metric(metricName);
        if (metric != null) {
            return new Some((Object)metric);
        }
        return None$.MODULE$;
    }

    public void monitorSelector(Selector selector) {
        this.selectorServiceMetrics().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$1 -> {
            BrokerLoad.$anonfun$monitorSelector$2(this, selector, x$1);
            return BoxedUnit.UNIT;
        });
        selector.registerOnNewEventListener((Selector.OnNewEventListener)this);
    }

    public void recordRequestTimeNanos(Selector selector, long timeNanos) {
        RequestLocalTime$.MODULE$.sensor(selector).record((double)timeNanos);
        this.totalServiceLocalTimeSensor().record((double)timeNanos);
    }

    private void recordConnectionTimeNanos(long totalConnectionTimeNanos) {
        this.totalServiceLocalTimeSensor().record((double)totalConnectionTimeNanos);
    }

    private void recordThreadsIdleRatio(String listenerName, double idleRatio) {
        if (listenerName != null) {
            if (this.multiTenantListenerNames().contains(listenerName)) {
                this.externalNetworkThreadIdleRatioSensor().record(idleRatio);
                return;
            }
            if (listenerName.equals(this.interBrokerListener().value())) {
                this.replicationNetworkThreadIdleRatioSensor().record(idleRatio);
                return;
            }
            if (listenerName.equals("REQUEST")) {
                this.requestHandlerThreadIdleRatioSensor().record(idleRatio);
                return;
            }
        }
    }

    public void close() {
        this.metrics.removeSensor(this.totalServiceLocalTimeSensor().name());
        this.metrics.removeSensor(this.externalNetworkThreadIdleRatioSensor().name());
        this.metrics.removeSensor(this.replicationNetworkThreadIdleRatioSensor().name());
        this.metrics.removeSensor(this.requestHandlerThreadIdleRatioSensor().name());
        if (this.brokerLoadPercentMetric().isDefined()) {
            this.metrics.removeMetric(this.brokerLoadPercentMetricName());
        }
    }

    public void notifyOnConnection(KafkaChannel channel) {
        this.recordConnectionTimeNanos(channel.metrics().computeConnectionLocalServiceTimeNanos());
    }

    public void notifyOnThreadUsage(String listenerName, Double idleRatio) {
        this.recordThreadsIdleRatio(listenerName, Predef$.MODULE$.Double2double(idleRatio));
    }

    public static final /* synthetic */ void $anonfun$monitorSelector$2(BrokerLoad $this, Selector selector$1, Tuple2 x$1) {
        if (x$1 != null) {
            SelectorServiceMetric serviceMetric = (SelectorServiceMetric)x$1._1();
            CopyOnWriteArraySet metricsSet = (CopyOnWriteArraySet)x$1._2();
            serviceMetric.create(selector$1, $this.metrics, $this.metricConfig(), (MeasurableStat)new ExponentialWeightedAvg($this.brokerLoadConfig().weightedAvgAlpha())).foreach((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)metricsSet.add(metric)));
            return;
        }
        throw new MatchError(null);
    }

    public BrokerLoad(Metrics metrics, KafkaConfig config, Option<MultiTenantMetadata> multiTenantMetadata) {
        this.metrics = metrics;
        this.multiTenantMetadata = multiTenantMetadata;
        this.brokerLoadConfig = BrokerLoadConfig$.MODULE$.apply(config);
        this.metricConfig = new MetricConfig().samples(this.brokerLoadConfig().numSamples()).timeWindow(this.brokerLoadConfig().sampleWindowSize().toMillis(), TimeUnit.MILLISECONDS);
        this.interBrokerListener = config.interBrokerListenerName();
        this.multiTenantListenerNames = ConfluentConfigs.multitenantListenerNames((AbstractConfig)config, (ListenerName)this.interBrokerListener());
        this.selectorServiceMetrics = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SelectorRegisterTime$.MODULE$, new CopyOnWriteArraySet()), new Tuple2((Object)HandshakeLocalTime$.MODULE$, new CopyOnWriteArraySet()), new Tuple2((Object)AuthenticationLocalTime$.MODULE$, new CopyOnWriteArraySet()), new Tuple2((Object)RequestLocalTime$.MODULE$, new CopyOnWriteArraySet())}));
        this.metricTag = this.brokerLoadMetricTag();
        MetricName metricName = new MetricName(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$BrokerLoadPercentMetricName(), BrokerLoad$.MODULE$.BrokerLoadMetricGroup(), BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$BrokerLoadPercentMetricDescription(), CollectionConverters$.MODULE$.MapHasAsJava(this.metricTag()).asJava());
        if (!metrics.metrics().containsKey(metricName)) {
            metrics.addMetric(metricName, (MetricValueProvider)new BrokerLoadGauge());
        }
        this.metricName = metricName;
        this.totalServiceLocalTimeSensor = metrics.sensor(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ServiceLocalTimeSensorName());
        MetricName metricName2 = new MetricName(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ServiceLocalTimeMetricName(), BrokerLoad$.MODULE$.BrokerLoadMetricGroup(), BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ServiceLocalTimeMetricDescription(), Collections.emptyMap());
        if (!metrics.metrics().containsKey(metricName2)) {
            this.totalServiceLocalTimeSensor().add(metricName2, (MeasurableStat)new ExponentialWeightedAvg(this.brokerLoadConfig().weightedAvgAlpha()), this.metricConfig());
        }
        this.weightedAverageTotalServiceLocalTimeMetricName = metricName2;
        this.externalNetworkThreadIdleRatioSensor = metrics.sensor(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ExternalNetworkThreadIdleRatioSensorName());
        MetricName metricName3 = new MetricName(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ExternalNetworkThreadIdleRatioMetricName(), BrokerLoad$.MODULE$.BrokerLoadMetricGroup(), BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ExternalNetworkThreadIdleRatioMetricDescription(), Collections.emptyMap());
        if (!metrics.metrics().containsKey(metricName3)) {
            this.externalNetworkThreadIdleRatioSensor().add(metricName3, (MeasurableStat)new ExponentialWeightedAvg(this.brokerLoadConfig().weightedAvgAlpha()), this.metricConfig());
        }
        this.weightedAverageExternalNetworkThreadIdleRatioMetricName = metricName3;
        this.replicationNetworkThreadIdleRatioSensor = metrics.sensor(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ReplicationNetworkThreadIdleRatioSensorName());
        MetricName metricName4 = new MetricName(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ReplicationNetworkThreadIdleRatioMetricName(), BrokerLoad$.MODULE$.BrokerLoadMetricGroup(), BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ReplicationNetworkThreadIdleRatioMetricDescription(), Collections.emptyMap());
        if (!metrics.metrics().containsKey(metricName4)) {
            this.replicationNetworkThreadIdleRatioSensor().add(metricName4, (MeasurableStat)new ExponentialWeightedAvg(this.brokerLoadConfig().weightedAvgAlpha()), this.metricConfig());
        }
        this.weightedAverageReplicationNetworkThreadIdleRatioMetricName = metricName4;
        this.requestHandlerThreadIdleRatioSensor = metrics.sensor(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$RequestHandlerThreadIdleRatioSensorName());
        MetricName metricName5 = new MetricName(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$RequestHandlerThreadIdleRatioMetricName(), BrokerLoad$.MODULE$.BrokerLoadMetricGroup(), BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$RequestHandlerThreadIdleRatioMetricDescription(), Collections.emptyMap());
        if (!metrics.metrics().containsKey(metricName5)) {
            this.requestHandlerThreadIdleRatioSensor().add(metricName5, (MeasurableStat)new ExponentialWeightedAvg(this.brokerLoadConfig().weightedAvgAlpha()), this.metricConfig());
        }
        this.weightedAverageRequestHandlerThreadIdleRatioMetricName = metricName5;
    }

    private class BrokerLoadGauge
    implements Gauge<Object> {
        private final double NoLoad;

        private double NoLoad() {
            return this.NoLoad;
        }

        private Tuple2<Object, Object> weight(double x) {
            if (x <= 0.15) {
                return new Tuple2.mcDD.sp(1.0, 0.0);
            }
            if (x <= 0.35) {
                return new Tuple2.mcDD.sp((double)-5 * x + 1.75, (double)5 * x - 0.75);
            }
            return new Tuple2.mcDD.sp(0.0, 1.0);
        }

        private double nanAwareMin(List<Object> t) {
            return BoxesRunTime.unboxToDouble((Object)t.minBy((Function1)(JFunction1.mcDD.sp & Serializable)x -> {
                if (Double.isNaN(x)) {
                    return Double.POSITIVE_INFINITY;
                }
                return x;
            }, (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        }

        /*
         * WARNING - void declaration
         */
        public double value(MetricConfig config, long now) {
            void var29_18;
            void var27_17;
            Option<Metric> externalIdleRatioMetric = this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().weightedAverageExternalNetworkThreadIdleRatioMetric();
            Option<Metric> replicationIdleRatioMetric = this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().weightedAverageReplicationNetworkThreadIdleRatioMetric();
            Option<Metric> requestIdleRatioMetric = this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().weightedAverageRequestHandlerThreadIdleRatioMetric();
            if (externalIdleRatioMetric == null || replicationIdleRatioMetric == null || requestIdleRatioMetric == null) {
                if (this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().logger().underlying().isErrorEnabled()) {
                    this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().logger().underlying().error("Cannot compute broker load because of a null idle ratio metric");
                }
                return Double.NaN;
            }
            double externalIdleRatio = BoxesRunTime.unboxToDouble((Object)((Metric)externalIdleRatioMetric.get()).metricValue());
            double replicationIdleRatio = BoxesRunTime.unboxToDouble((Object)((Metric)replicationIdleRatioMetric.get()).metricValue());
            double requestIdleRatio = BoxesRunTime.unboxToDouble((Object)((Metric)requestIdleRatioMetric.get()).metricValue());
            double minThreadIdleRatio = !Double.isNaN(externalIdleRatio) || !Double.isNaN(replicationIdleRatio) || !Double.isNaN(requestIdleRatio) ? this.nanAwareMin((List<Object>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{externalIdleRatio, replicationIdleRatio, requestIdleRatio})))) : Double.NaN;
            double lowLoad = !Double.isNaN(minThreadIdleRatio) ? 1.0 - minThreadIdleRatio : this.NoLoad();
            Option<Metric> etMetric = this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().weightedAverageTotalServiceLocalTimeMetric();
            if (etMetric == null) {
                if (this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().logger().underlying().isErrorEnabled()) {
                    this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().logger().underlying().error("Cannot compute broker load because of a null weighted average service time metric");
                }
                return Double.NaN;
            }
            double et = BoxesRunTime.unboxToDouble((Object)((Metric)etMetric.get()).metricValue());
            double es = this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().brokerLoadConfig().averageServiceRequestTime() * 1000000.0;
            double serviceLoad = !Double.isNaN(et) && et > es ? (et - es) / (this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().brokerLoadConfig().workloadCoefficient() * es) : this.NoLoad();
            double highLoad = serviceLoad / (1.0 + serviceLoad);
            Tuple2<Object, Object> tuple2 = this.weight(lowLoad);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            double a = tuple2._1$mcD$sp();
            double b = tuple2._2$mcD$sp();
            return (double)(var27_17 * lowLoad + var29_18 * highLoad);
        }

        public /* synthetic */ BrokerLoad kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer() {
            return BrokerLoad.this;
        }

        public BrokerLoadGauge() {
            if (BrokerLoad.this == null) {
                throw null;
            }
            this.NoLoad = 0.0;
        }
    }
}

