/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import kafka.log.AbortedTransactionMetadata;
import kafka.log.AbortedTxn;
import kafka.log.TransactionIndex;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0005}4Q\u0001E\t\u0001#UAQ\u0001\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013%!\u0005\u0003\u0004/\u0001\u0001\u0006Ia\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0011\u00199\u0004\u0001)A\u0005c!9\u0001\b\u0001b\u0001\n\u0013I\u0004B\u0002!\u0001A\u0003%!\bC\u0004B\u0001\u0001\u0007I\u0011\u0001\"\t\u000f%\u0003\u0001\u0019!C\u0001\u0015\"1\u0001\u000b\u0001Q!\n\rCQ!\u0015\u0001\u0005\u0002ICQ\u0001\u0019\u0001\u0005\u0002\u0005DQ\u0001\u001e\u0001\u0005\nUDQ\u0001\u001f\u0001\u0005\u0002eDQ\u0001 \u0001\u0005\u0002u\u0014!d\u00117fC:,G\r\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006T!AE\n\u0002\u00071|wMC\u0001\u0015\u0003\u0015Y\u0017MZ6b'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tq\u0004\u0005\u0002!\u00015\t\u0011#\u0001\u000bp]\u001e|\u0017N\\4D_6l\u0017\u000e\u001e;fIRChn]\u000b\u0002GA\u0019A%K\u0016\u000e\u0003\u0015R!AJ\u0014\u0002\u000f5,H/\u00192mK*\u0011\u0001\u0006G\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0016&\u0005\r\u0019V\r\u001e\t\u0003/1J!!\f\r\u0003\t1{gnZ\u0001\u0016_:<w.\u001b8h\u0007>lW.\u001b;uK\u0012$\u0006P\\:!\u0003IygnZ8j]\u001e\f%m\u001c:uK\u0012$\u0006P\\:\u0016\u0003E\u0002B\u0001\n\u001a,i%\u00111'\n\u0002\u0004\u001b\u0006\u0004\bC\u0001\u00116\u0013\t1\u0014C\u0001\u000eBE>\u0014H/\u001a3Ue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018-A\np]\u001e|\u0017N\\4BE>\u0014H/\u001a3Uq:\u001c\b%A\nbE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t7/F\u0001;!\r!3(P\u0005\u0003y\u0015\u0012Q\u0002\u0015:j_JLG/_)vKV,\u0007C\u0001\u0011?\u0013\ty\u0014C\u0001\u0006BE>\u0014H/\u001a3Uq:\fA#\u00192peR,G\r\u0016:b]N\f7\r^5p]N\u0004\u0013\u0001D2mK\u0006tW\rZ%oI\u0016DX#A\"\u0011\u0007]!e)\u0003\u0002F1\t1q\n\u001d;j_:\u0004\"\u0001I$\n\u0005!\u000b\"\u0001\u0005+sC:\u001c\u0018m\u0019;j_:Le\u000eZ3y\u0003A\u0019G.Z1oK\u0012Le\u000eZ3y?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011q\u0003T\u0005\u0003\u001bb\u0011A!\u00168ji\"9q*CA\u0001\u0002\u0004\u0019\u0015a\u0001=%c\u0005i1\r\\3b]\u0016$\u0017J\u001c3fq\u0002\na#\u00193e\u0003\n|'\u000f^3e)J\fgn]1di&|gn\u001d\u000b\u0003\u0017NCQ\u0001O\u0006A\u0002Q\u00032!V/>\u001d\t16L\u0004\u0002X56\t\u0001L\u0003\u0002Z;\u00051AH]8pizJ\u0011!G\u0005\u00039b\tq\u0001]1dW\u0006<W-\u0003\u0002_?\n!A*[:u\u0015\ta\u0006$\u0001\np]\u000e{g\u000e\u001e:pY\n\u000bGo\u00195SK\u0006$GC\u00012f!\t92-\u0003\u0002e1\t9!i\\8mK\u0006t\u0007\"\u00024\r\u0001\u00049\u0017\u0001D2p]R\u0014x\u000e\u001c\"bi\u000eD\u0007C\u00015s\u001b\u0005I'B\u00016l\u0003\u0019\u0011XmY8sI*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005Qq'BA8q\u0003\u0019\t\u0007/Y2iK*\t\u0011/A\u0002pe\u001eL!a]5\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r[\u0001\u0017G>t7/^7f\u0003\n|'\u000f^3e)bt7/\u00169U_R\u00111J\u001e\u0005\u0006o6\u0001\raK\u0001\u0007_\u001a47/\u001a;\u0002\u0017=t')\u0019;dQJ+\u0017\r\u001a\u000b\u0003EjDQa\u001f\bA\u0002\u001d\fQAY1uG\"\fqb\u001c8CCR\u001c\u0007NU3uC&tW\r\u001a\u000b\u0003\u0017zDQa_\bA\u0002\u001d\u0004")
public class CleanedTransactionMetadata {
    private final Set<Object> ongoingCommittedTxns = (Set)Set$.MODULE$.empty();
    private final Map<Object, AbortedTransactionMetadata> ongoingAbortedTxns = (Map)Map$.MODULE$.empty();
    private final PriorityQueue<AbortedTxn> abortedTransactions = PriorityQueue$.MODULE$.empty(Ordering.reverse$((Ordering)new Ordering<AbortedTxn>(null){

        public Some tryCompare(Object x, Object y) {
            return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lteq(Object x, Object y) {
            return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gteq(Object x, Object y) {
            return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lt(Object x, Object y) {
            return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gt(Object x, Object y) {
            return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
        }

        public boolean equiv(Object x, Object y) {
            return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
        }

        public Object max(Object x, Object y) {
            return Ordering.max$((Ordering)this, (Object)x, (Object)y);
        }

        public Object min(Object x, Object y) {
            return Ordering.min$((Ordering)this, (Object)x, (Object)y);
        }

        public Ordering<AbortedTxn> reverse() {
            return Ordering.reverse$((Ordering)this);
        }

        public boolean isReverseOf(Ordering<?> other) {
            return Ordering.isReverseOf$((Ordering)this, other);
        }

        public <U> Ordering<U> on(Function1<U, AbortedTxn> f) {
            return Ordering.on$((Ordering)this, f);
        }

        public Ordering<AbortedTxn> orElse(Ordering<AbortedTxn> other) {
            return Ordering.orElse$((Ordering)this, other);
        }

        public <S> Ordering<AbortedTxn> orElseBy(Function1<AbortedTxn, S> f, Ordering<S> ord) {
            return Ordering.orElseBy$((Ordering)this, f, ord);
        }

        public Ordering.OrderingOps mkOrderingOps(Object lhs) {
            return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
        }

        public int compare(AbortedTxn x, AbortedTxn y) {
            return new RichLong(Predef$.MODULE$.longWrapper(x.firstOffset())).compare((Object)BoxesRunTime.boxToLong((long)y.firstOffset()));
        }
        {
            PartialOrdering.$init$((PartialOrdering)this);
            Ordering.$init$((Ordering)this);
        }
    }));
    private Option<TransactionIndex> cleanedIndex = None$.MODULE$;

    private Set<Object> ongoingCommittedTxns() {
        return this.ongoingCommittedTxns;
    }

    private Map<Object, AbortedTransactionMetadata> ongoingAbortedTxns() {
        return this.ongoingAbortedTxns;
    }

    private PriorityQueue<AbortedTxn> abortedTransactions() {
        return this.abortedTransactions;
    }

    public Option<TransactionIndex> cleanedIndex() {
        return this.cleanedIndex;
    }

    public void cleanedIndex_$eq(Option<TransactionIndex> x$1) {
        this.cleanedIndex = x$1;
    }

    public void addAbortedTransactions(List<AbortedTxn> abortedTransactions) {
        this.abortedTransactions().$plus$plus$eq(abortedTransactions);
    }

    public boolean onControlBatchRead(RecordBatch controlBatch) {
        this.consumeAbortedTxnsUpTo(controlBatch.lastOffset());
        Iterator controlRecordIterator = controlBatch.iterator();
        if (controlRecordIterator.hasNext()) {
            boolean bl;
            ControlRecordType controlType = ControlRecordType.parse((ByteBuffer)((Record)controlRecordIterator.next()).key());
            long producerId = controlBatch.producerId();
            if (ControlRecordType.ABORT.equals(controlType)) {
                boolean bl2;
                AbortedTransactionMetadata abortedTxnMetadata;
                Option option = this.ongoingAbortedTxns().remove((Object)BoxesRunTime.boxToLong((long)producerId));
                if (option instanceof Some && (abortedTxnMetadata = (AbortedTransactionMetadata)((Some)option).value()).lastRetainedBatchOffset().isDefined()) {
                    this.cleanedIndex().foreach((Function1 & Serializable)x$20 -> {
                        x$20.append(abortedTxnMetadata.abortedTxn());
                        return BoxedUnit.UNIT;
                    });
                    bl2 = false;
                } else {
                    bl2 = true;
                }
                bl = bl2;
            } else {
                bl = ControlRecordType.COMMIT.equals(controlType) ? !this.ongoingCommittedTxns().remove((Object)BoxesRunTime.boxToLong((long)producerId)) : false;
            }
            return bl;
        }
        return true;
    }

    private void consumeAbortedTxnsUpTo(long offset) {
        while (this.abortedTransactions().headOption().exists((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)CleanedTransactionMetadata.$anonfun$consumeAbortedTxnsUpTo$1(offset, x$21)))) {
            AbortedTxn abortedTxn = (AbortedTxn)this.abortedTransactions().dequeue();
            this.ongoingAbortedTxns().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)abortedTxn.producerId()), (Function0 & Serializable)() -> new AbortedTransactionMetadata(abortedTxn));
        }
    }

    public boolean onBatchRead(RecordBatch batch) {
        this.consumeAbortedTxnsUpTo(batch.lastOffset());
        if (batch.isTransactional()) {
            return this.ongoingAbortedTxns().contains((Object)BoxesRunTime.boxToLong((long)batch.producerId()));
        }
        return false;
    }

    public void onBatchRetained(RecordBatch batch) {
        if (batch.isTransactional() && !batch.isControlBatch()) {
            long producerId = batch.producerId();
            Option option = this.ongoingAbortedTxns().get((Object)BoxesRunTime.boxToLong((long)producerId));
            if (option instanceof Some) {
                ((AbortedTransactionMetadata)((Some)option).value()).lastRetainedBatchOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())));
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.ongoingCommittedTxns().$plus$eq((Object)BoxesRunTime.boxToLong((long)producerId));
                return;
            }
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ boolean $anonfun$consumeAbortedTxnsUpTo$1(long offset$2, AbortedTxn x$21) {
        return x$21.firstOffset() <= offset$2;
    }
}

