/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db.serdes;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kafka.durability.db.serdes.Header;
import kafka.durability.db.serdes.TopicInfo;

public final class Database
extends Table {
    public static Database getRootAsDatabase(ByteBuffer _bb) {
        return Database.getRootAsDatabase(_bb, new Database());
    }

    public static Database getRootAsDatabase(ByteBuffer _bb, Database obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public Database __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public Header header() {
        return this.header(new Header());
    }

    public Header header(Header obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public TopicInfo topics(int j) {
        return this.topics(new TopicInfo(), j);
    }

    public TopicInfo topics(TopicInfo obj, int j) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int topicsLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public static int createDatabase(FlatBufferBuilder builder, int headerOffset, int topicsOffset) {
        builder.startObject(2);
        Database.addTopics(builder, topicsOffset);
        Database.addHeader(builder, headerOffset);
        return Database.endDatabase(builder);
    }

    public static void startDatabase(FlatBufferBuilder builder) {
        builder.startObject(2);
    }

    public static void addHeader(FlatBufferBuilder builder, int headerOffset) {
        builder.addOffset(0, headerOffset, 0);
    }

    public static void addTopics(FlatBufferBuilder builder, int topicsOffset) {
        builder.addOffset(1, topicsOffset, 0);
    }

    public static int createTopicsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startTopicsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endDatabase(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }

    public static void finishDatabaseBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedDatabaseBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }
}

