/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.durability.db.DbHeader;
import kafka.durability.db.DbStatus$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.TopicState;
import kafka.durability.db.TopicState$;
import kafka.durability.db.serdes.Database;
import kafka.durability.db.serdes.Header;
import kafka.durability.exceptions.DurabilityDBNotReadyException;
import kafka.durability.exceptions.DurabilityObjectNotFoundException;
import org.apache.kafka.common.TopicPartition;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t}daB\u000e\u001d!\u0003\r\ta\t\u0005\u0006U\u0001!\ta\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0011!!\u0004A1A\u0005\u0002q\u0001\u0004\u0002C\u001b\u0001\u0001\u0004%\t\u0001\b\u001c\t\u0011\r\u0003\u0001\u0019!C\u00019\u0011C\u0001b\u0012\u0001C\u0002\u0013\u0005a\u0004\u0013\u0005\u0007?\u00021\tA\b1\t\u000fU\u0004!\u0019!D\u0001m\"Iq\u0010\u0001a\u0001\u000e#a\u0012\u0011\u0001\u0005\u000b\u0003\u0013\u0001\u0001\u0019!D\t9\u0005-\u0001BBA\b\u0001\u0019\u00051\u0006\u0003\u0005\u0002P\u0001!\t\u0001HA)\u0011\u0019\t\u0019\u0007\u0001D\u0001W!9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0004bBAU\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003\u0013\u0004A\u0011AAf\u0011\u001d\ty\r\u0001C\u0001\u0003#Dq!!?\u0001\t\u0013\tY\u0010\u0003\u0005\u0003\u0012\u0001!\t\u0002\bB\n\u0011!\u0011\t\u0003\u0001C\t9\t\r\u0002b\u0002B\u0015\u0001\u0011\u0005!1\u0006\u0005\b\u0005g\u0001A\u0011\u0001B\u001b\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005OBqAa\u001b\u0001\r\u0003q\u0002\rC\u0004\u0003n\u00011\tAa\u001c\t\r\tE\u0004\u0001\"\u0001,\u0005\u001d!%\r\u0016:bSRT!!\b\u0010\u0002\u0005\u0011\u0014'BA\u0010!\u0003)!WO]1cS2LG/\u001f\u0006\u0002C\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001%!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fM\u00061A%\u001b8ji\u0012\"\u0012\u0001\f\t\u0003K5J!A\f\u0014\u0003\tUs\u0017\u000e^\u0001\u0016\t\n{&)\u0016$G\u000bJ{\u0016JT%U?2+ej\u0012+I+\u0005\t\u0004CA\u00133\u0013\t\u0019dEA\u0002J]R\fq\u0005R+S\u0003\nKE*\u0013+Z?\u00163VI\u0014+T?R{\u0005+S\"`!\u0006\u0013F+\u0013+J\u001f:{6iT+O)\u000611\u000f^1ukN,\u0012a\u000e\t\u0003qqr!!\u000f\u001e\u000e\u0003qI!a\u000f\u000f\u0002\u0011\u0011\u00137\u000b^1ukNL!!\u0010 \u0003\u0011\u0011\u00137\u000b^1ukNT!a\u000f\u000f)\u0005\u0011\u0001\u0005CA\u0013B\u0013\t\u0011eE\u0001\u0005w_2\fG/\u001b7f\u0003)\u0019H/\u0019;vg~#S-\u001d\u000b\u0003Y\u0015CqAR\u0003\u0002\u0002\u0003\u0007q'A\u0002yIE\n1\u0002^8qS\u000e\u001cF/\u0019;fgV\t\u0011\n\u0005\u0003K\u001fFcV\"A&\u000b\u00051k\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u001d\u001a\n!bY8mY\u0016\u001cG/[8o\u0013\t\u00016JA\u0004ICNDW*\u00199\u0011\u0005IKfBA*X!\t!f%D\u0001V\u0015\t1&%\u0001\u0004=e>|GOP\u0005\u00031\u001a\na\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001L\n\t\u0003suK!A\u0018\u000f\u0003\u0015Q{\u0007/[2Ti\u0006$X-\u0001\u000ehKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001chi\u001c:Bk\u0012LG/F\u0001b!\r\u0011wM\u001b\b\u0003G\u0016t!\u0001\u00163\n\u0003\u001dJ!A\u001a\u0014\u0002\u000fA\f7m[1hK&\u0011\u0001.\u001b\u0002\u0004'\u0016\f(B\u00014'!\tY7/D\u0001m\u0015\tig.\u0001\u0004d_6lwN\u001c\u0006\u0003C=T!\u0001]9\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0018aA8sO&\u0011A\u000f\u001c\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\r!\u0017N]\u000b\u0002oB\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\u0003S>T\u0011\u0001`\u0001\u0005U\u00064\u0018-\u0003\u0002\u007fs\n!a)\u001b7f\u0003\u0019AW-\u00193feV\u0011\u00111\u0001\t\u0004s\u0005\u0015\u0011bAA\u00049\tAAI\u0019%fC\u0012,'/\u0001\u0006iK\u0006$WM]0%KF$2\u0001LA\u0007\u0011!1%\"!AA\u0002\u0005\r\u0011AC2iK\u000e\\\u0007o\\5oi\"*1\"a\u0005\u0002 A)Q%!\u0006\u0002\u001a%\u0019\u0011q\u0003\u0014\u0003\rQD'o\\<t!\rA\u00181D\u0005\u0004\u0003;I(aC%P\u000bb\u001cW\r\u001d;j_:\fdAH)\u0002\"\u00055\u0013'C\u0012\u0002$\u0005-\u00121IA\u0017+\u0011\t)#a\n\u0016\u0003E#q!!\u000b#\u0005\u0004\t\u0019DA\u0001U\u0013\u0011\ti#a\f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\t\tDJ\u0001\u0007i\"\u0014xn^:\u0012\t\u0005U\u00121\b\t\u0004K\u0005]\u0012bAA\u001dM\t9aj\u001c;iS:<\u0007\u0003BA\u001f\u0003\u007fq!!J3\n\u0007\u0005\u0005\u0013NA\u0005UQJ|w/\u00192mKFJ1%!\u0012\u0002H\u0005%\u0013\u0011\u0007\b\u0004K\u0005\u001d\u0013bAA\u0019ME*!%\n\u0014\u0002L\t)1oY1mCF\u001aa%!\u0007\u0002\u001bI,7m\u001c<fe\"+\u0017\rZ3s)\u0011\t\u0019!a\u0015\t\u000f\u0005UC\u00021\u0001\u0002X\u0005\u0019\u0001\u000e\u001a:\u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018\u001d\u0003\u0019\u0019XM\u001d3fg&!\u0011\u0011MA.\u0005\u0019AU-\u00193fe\u00069!/Z2pm\u0016\u0014\b&B\u0007\u0002\u0014\u0005\u001d\u0014G\u0002\u0010R\u0003S\ny'M\u0005$\u0003G\tY#a\u001b\u0002.EJ1%!\u0012\u0002H\u00055\u0014\u0011G\u0019\u0006E\u00152\u00131J\u0019\u0004M\u0005e\u0011AE<ji\"\u0014V-\u00193j]\u0016\u001c8o\u00115fG.,B!!\u001e\u0002|Q!\u0011qOAC!\u0011\tI(a\u001f\r\u0001\u00119\u0011\u0011\u0006\bC\u0002\u0005u\u0014\u0003BA\u001b\u0003\u007f\u00022!JAA\u0013\r\t\u0019I\n\u0002\u0004\u0003:L\b\u0002CAD\u001d\u0011\u0005\r!!#\u0002\u0007\u0019,h\u000eE\u0003&\u0003\u0017\u000b9(C\u0002\u0002\u000e\u001a\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0015\u0006\u001d\u0005E\u0015q\u0014\t\u0006K\u0005U\u00111\u0013\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u0014\u0010\u0002\u0015\u0015D8-\u001a9uS>t7/\u0003\u0003\u0002\u001e\u0006]%!\b#ve\u0006\u0014\u0017\u000e\\5us\u0012\u0013ej\u001c;SK\u0006$\u00170\u0012=dKB$\u0018n\u001c82\ry\t\u0016\u0011UATc%\u0019\u00131EA\u0016\u0003G\u000bi#M\u0005$\u0003\u000b\n9%!*\u00022E*!%\n\u0014\u0002LE\u001aa%a%\u0002'\u0019,Go\u00195QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\t\u00055\u0016\u0011\u0018\t\u0006K\u0005=\u00161W\u0005\u0004\u0003c3#AB(qi&|g\u000eE\u0002:\u0003kK1!a.\u001d\u00059\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016Da!a/\u0010\u0001\u0004Q\u0017AA5eQ\u0015y\u0011\u0011SA`c\u0019q\u0012+!1\u0002HFJ1%a\t\u0002,\u0005\r\u0017QF\u0019\nG\u0005\u0015\u0013qIAc\u0003c\tTAI\u0013'\u0003\u0017\n4AJAJ\u0003=!W\r\\3uKB\u000b'\u000f^5uS>tGc\u0001\u0017\u0002N\"1\u00111\u0018\tA\u0002)\fA\"\u00193e!\u0006\u0014H/\u001b;j_:$b!!,\u0002T\u0006U\u0007BBA^#\u0001\u0007!\u000eC\u0004\u0002XF\u0001\r!a-\u0002\u000bM$\u0018\r^3)\u000bE\tY.a9\u0011\u000b\u0015\n)\"!8\u0011\t\u0005U\u0015q\\\u0005\u0005\u0003C\f9JA\u0011EkJ\f'-\u001b7jif|%M[3di:{GOR8v]\u0012,\u0005pY3qi&|g.\r\u0004\u001f#\u0006\u0015\u00181^\u0019\nG\u0005\r\u00121FAt\u0003[\t\u0014bIA#\u0003\u000f\nI/!\r2\u000b\t*c%a\u00132\u0007\u0019\ni\u000eK\u0003\u0012\u0003#\u000by/\r\u0004\u001f#\u0006E\u0018q_\u0019\nG\u0005\r\u00121FAz\u0003[\t\u0014bIA#\u0003\u000f\n)0!\r2\u000b\t*c%a\u00132\u0007\u0019\n\u0019*\u0001\u0005bI\u0012$v\u000e]5d)\u0019\ti0a@\u0003\u0004A!Q%a,]\u0011\u0019\u0011\tA\u0005a\u0001#\u0006)Ao\u001c9jG\"1\u0011q\u001b\nA\u0002qCSAEAI\u0005\u000f\tdAH)\u0003\n\t=\u0011'C\u0012\u0002$\u0005-\"1BA\u0017c%\u0019\u0013QIA$\u0005\u001b\t\t$M\u0003#K\u0019\nY%M\u0002'\u0003'\u000b\u0011b]3sS\u0006d\u0017N_3\u0015\u0005\tU\u0001\u0003\u0002B\f\u0005;i!A!\u0007\u000b\u0007\tm10A\u0002oS>LAAa\b\u0003\u001a\tQ!)\u001f;f\u0005V4g-\u001a:\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004Y\t\u0015\u0002b\u0002B\u0014)\u0001\u0007!QC\u0001\u0007EV4g-\u001a:\u0002\u0011%\u001cxJ\u001c7j]\u0016,\"A!\f\u0011\u0007\u0015\u0012y#C\u0002\u00032\u0019\u0012qAQ8pY\u0016\fg.\u0001\u0013va\u0012\fG/\u001a#ve\u0006\u0014\u0017\u000e\\5usR{\u0007/[2QCJ$\u0018\u000e^5p]>3gm]3u)\u0015a#q\u0007B\u001e\u0011\u0019\u0011ID\u0006a\u0001c\u0005I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0005{1\u0002\u0019\u0001B \u0003\u0019ygMZ:fiB\u0019QE!\u0011\n\u0007\t\rcE\u0001\u0003M_:<\u0007&\u0002\f\u0003H\t=\u0003#B\u0013\u0002\u0016\t%\u0003c\u00012\u0003L%\u0019!QJ5\u00033%sG-\u001a=PkR|eMQ8v]\u0012\u001cX\t_2faRLwN\\\u0019\u0007=E\u0013\tFa\u00162\u0013\r\n\u0019#a\u000b\u0003T\u00055\u0012'C\u0012\u0002F\u0005\u001d#QKA\u0019c\u0015\u0011SEJA&c\r1#\u0011\n\u0015\u0006-\u0005E%1L\u0019\u0007=E\u0013iFa\u00192\u0013\r\n\u0019#a\u000b\u0003`\u00055\u0012'C\u0012\u0002F\u0005\u001d#\u0011MA\u0019c\u0015\u0011SEJA&c\r1\u00131S\u0001#O\u0016$H)\u001e:bE&d\u0017\u000e^=U_BL7\rU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:\u0016\u0005\t%\u0004\u0003\u00022h\u0005\u007f\t\u0001cZ3u\u00032d\u0007+\u0019:uSRLwN\\:\u0002!\u0019,Go\u00195U_BL7m\u0015;bi\u0016\u001cH#A%\u0002\u000b\rdwn]3)\u000bi\t\u0019B!\u001e2\ry\t&q\u000fB?c%\u0019\u00131EA\u0016\u0005s\ni#M\u0005$\u0003\u000b\n9Ea\u001f\u00022E*!%\n\u0014\u0002LE\u001aa%!\u0007")
public interface DbTrait {
    public void kafka$durability$db$DbTrait$_setter_$kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH_$eq(int var1);

    public void kafka$durability$db$DbTrait$_setter_$DURABILITY_EVENTS_TOPIC_PARTITION_COUNT_$eq(int var1);

    public void kafka$durability$db$DbTrait$_setter_$topicStates_$eq(HashMap<String, TopicState> var1);

    public int kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH();

    public int DURABILITY_EVENTS_TOPIC_PARTITION_COUNT();

    public Enumeration.Value status();

    public void status_$eq(Enumeration.Value var1);

    public HashMap<String, TopicState> topicStates();

    public Seq<TopicPartition> getTopicPartitionsForAudit();

    public File dir();

    public DbHeader header();

    public void header_$eq(DbHeader var1);

    public void checkpoint() throws IOException;

    public static /* synthetic */ DbHeader recoverHeader$(DbTrait $this, Header hdr) {
        return $this.recoverHeader(hdr);
    }

    default public DbHeader recoverHeader(Header hdr) {
        long[] committedOffsets = (long[])Array$.MODULE$.fill(this.DURABILITY_EVENTS_TOPIC_PARTITION_COUNT(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), hdr.durabilityPartitionsOffsetsLength()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ii -> {
            committedOffsets$1[ii] = hdr.durabilityPartitionsOffsets(ii);
        });
        return new DbHeader(hdr.version(), hdr.durabilityRunId(), committedOffsets);
    }

    public void recover() throws IOException;

    private <T> T withReadinessCheck(Function0<T> fun) throws DurabilityDBNotReadyException {
        Enumeration.Value value = this.status();
        Enumeration.Value value2 = DbStatus$.MODULE$.Online();
        if (value2 != null ? !value2.equals(value) : value != null) {
            throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
        }
        Object object = fun.apply();
        return (T)object;
    }

    public static /* synthetic */ Option fetchPartitionState$(DbTrait $this, TopicPartition id) {
        return $this.fetchPartitionState(id);
    }

    default public Option<PartitionState> fetchPartitionState(TopicPartition id) throws DurabilityDBNotReadyException {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$fetchPartitionState$1(this, id);
            Option option2 = option;
            return option2;
        }
    }

    public static /* synthetic */ void deletePartition$(DbTrait $this, TopicPartition id) {
        $this.deletePartition(id);
    }

    default public void deletePartition(TopicPartition id) {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            DbTrait.$anonfun$deletePartition$1(this, id);
            return;
        }
    }

    public static /* synthetic */ Option addPartition$(DbTrait $this, TopicPartition id, PartitionState state) {
        return $this.addPartition(id, state);
    }

    default public Option<PartitionState> addPartition(TopicPartition id, PartitionState state) throws DurabilityDBNotReadyException, DurabilityObjectNotFoundException {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$addPartition$1(this, id, state);
            Option option2 = option;
            return option2;
        }
    }

    private Option<TopicState> addTopic(String topic, TopicState state) throws DurabilityDBNotReadyException {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Option option = DbTrait.$anonfun$addTopic$1(this, topic, state);
            Option option2 = option;
            return option2;
        }
    }

    public static /* synthetic */ ByteBuffer serialize$(DbTrait $this) {
        return $this.serialize();
    }

    default public ByteBuffer serialize() {
        FlatBufferBuilder builder = new FlatBufferBuilder(this.kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH()).forceDefaults(true);
        Iterable topicIdx = (Iterable)this.topicStates().values().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.serialize(builder)));
        int topicOffsets = Database.createTopicsVector(builder, (int[])topicIdx.toArray((ClassTag)ClassTag$.MODULE$.Int()));
        int hdrOffset = this.header().serialize(builder);
        int end = Database.createDatabase(builder, hdrOffset, topicOffsets);
        builder.finish(end);
        return Database.getRootAsDatabase(builder.dataBuffer()).getByteBuffer().duplicate();
    }

    public static /* synthetic */ void deserialize$(DbTrait $this, ByteBuffer buffer) {
        $this.deserialize(buffer);
    }

    default public void deserialize(ByteBuffer buffer) {
        Database database = Database.getRootAsDatabase(buffer);
        Header hdr = database.header();
        this.header_$eq(this.recoverHeader(hdr));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), database.topicsLength()).foreach((Function1 & Serializable)i -> DbTrait.$anonfun$deserialize$1(this, database, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static /* synthetic */ boolean isOnline$(DbTrait $this) {
        return $this.isOnline();
    }

    default public boolean isOnline() {
        Enumeration.Value value = this.status();
        Enumeration.Value value2 = DbStatus$.MODULE$.Online();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static /* synthetic */ void updateDurabilityTopicPartitionOffset$(DbTrait $this, int partition, long offset) {
        $this.updateDurabilityTopicPartitionOffset(partition, offset);
    }

    default public void updateDurabilityTopicPartitionOffset(int partition, long offset) throws DurabilityDBNotReadyException, IndexOutOfBoundsException {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            this.header().offsets()[partition] = offset;
            return;
        }
    }

    public static /* synthetic */ Seq getDurabilityTopicPartitionOffsets$(DbTrait $this) {
        return $this.getDurabilityTopicPartitionOffsets();
    }

    default public Seq<Object> getDurabilityTopicPartitionOffsets() {
        synchronized (this) {
            Enumeration.Value value = this.status();
            Enumeration.Value value2 = DbStatus$.MODULE$.Online();
            if (value2 != null ? !value2.equals(value) : value != null) {
                throw new DurabilityDBNotReadyException(new StringBuilder(31).append("DurabilityDB is not yet ready: ").append(this.status()).toString());
            }
            Seq seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.longArrayOps(this.header().offsets()));
            Seq seq2 = seq;
            return seq2;
        }
    }

    public Seq<TopicPartition> getAllPartitions();

    public HashMap<String, TopicState> fetchTopicStates();

    public static /* synthetic */ void close$(DbTrait $this) {
        $this.close();
    }

    default public void close() throws IOException {
        this.checkpoint();
    }

    public static /* synthetic */ Option $anonfun$fetchPartitionState$1(DbTrait $this, TopicPartition id$1) {
        None$ none$;
        TopicState s;
        Option option = $this.topicStates().get((Object)id$1.topic());
        if (option instanceof Some && (s = (TopicState)((Some)option).value()) != null) {
            none$ = s.partitions().get((Object)BoxesRunTime.boxToInteger((int)id$1.partition()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    public static /* synthetic */ Object $anonfun$deletePartition$1(DbTrait $this, TopicPartition id$2) {
        None$ none$;
        TopicState s;
        Option option = $this.topicStates().get((Object)id$2.topic());
        if (option instanceof Some && (s = (TopicState)((Some)option).value()) != null) {
            s.partitions().remove((Object)BoxesRunTime.boxToInteger((int)id$2.partition()));
            none$ = s.partitions().isEmpty() ? $this.topicStates().remove((Object)id$2.topic()) : BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Option $anonfun$addPartition$1(DbTrait $this, TopicPartition id$3, PartitionState state$1) {
        if (!$this.topicStates().contains((Object)id$3.topic())) {
            void apply_partitions;
            HashMap hashMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            String apply_topic = id$3.topic();
            Object var3_4 = null;
            hashMap = null;
            $this.addTopic(id$3.topic(), new TopicState(apply_topic, (HashMap<Object, PartitionState>)apply_partitions));
            return ((TopicState)$this.topicStates().apply((Object)id$3.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$3.partition()), (Object)state$1);
        }
        return ((TopicState)$this.topicStates().apply((Object)id$3.topic())).partitions().put((Object)BoxesRunTime.boxToInteger((int)id$3.partition()), (Object)state$1);
    }

    public static /* synthetic */ Option $anonfun$addTopic$1(DbTrait $this, String topic$1, TopicState state$2) {
        return $this.topicStates().put((Object)topic$1, (Object)state$2);
    }

    public static /* synthetic */ Option $anonfun$deserialize$1(DbTrait $this, Database database$1, int i) {
        TopicState topicState = TopicState$.MODULE$.apply(database$1.topics(i));
        return $this.topicStates().put((Object)topicState.topic(), (Object)topicState);
    }

    public static void $init$(DbTrait $this) {
        $this.kafka$durability$db$DbTrait$_setter_$kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH_$eq(0x100000);
        $this.kafka$durability$db$DbTrait$_setter_$DURABILITY_EVENTS_TOPIC_PARTITION_COUNT_$eq(50);
        $this.status_$eq(DbStatus$.MODULE$.Init());
        $this.kafka$durability$db$DbTrait$_setter_$topicStates_$eq((HashMap<String, TopicState>)((HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }
}

