/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001\u0002\n\u0014\u0001aA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011!I\u0004A!A!\u0002\u0013Q\u0004\"B\u001f\u0001\t\u0003q\u0004bB#\u0001\u0005\u0004%IA\u0012\u0005\u0007\u001b\u0002\u0001\u000b\u0011B$\t\u000b9\u0003A\u0011I(\t\u000f!\u0004\u0011\u0013!C\u0001S\")A\u000f\u0001C\u0005k\")!\u0010\u0001C\u0005w\"9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003g\u0002A\u0011BA;\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013Cq!!%\u0001\t\u0013\t\u0019JA\u000b[WJ+\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\u000b\u0005Q)\u0012AC2p]R\u0014x\u000e\u001c7fe*\ta#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001IR\u0004\u0005\u0002\u001b75\t1#\u0003\u0002\u001d'\t\u0019\"+\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oKB\u0011a$I\u0007\u0002?)\u0011\u0001%F\u0001\u0006kRLGn]\u0005\u0003E}\u0011q\u0001T8hO&tw-\u0001\u0004d_:4\u0017n\u001a\t\u0003K!j\u0011A\n\u0006\u0003OU\taa]3sm\u0016\u0014\u0018BA\u0015'\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000f\u0005\u0002\u001bY%\u0011Qf\u0005\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014\u0018!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011!\u0004M\u0005\u0003cM\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0003!Q8n\u00117jK:$\bC\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0016\u0003\tQ8.\u0003\u00029k\ti1*\u00194lCj[7\t\\5f]R\fAdY8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\u0005\u0002\u001bw%\u0011Ah\u0005\u0002\u001d\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i\u0003\u0019a\u0014N\\5u}Q1q\bQ!C\u0007\u0012\u0003\"A\u0007\u0001\t\u000b\r2\u0001\u0019\u0001\u0013\t\u000b)2\u0001\u0019A\u0016\t\u000b92\u0001\u0019A\u0018\t\u000bI2\u0001\u0019A\u001a\t\u000be2\u0001\u0019\u0001\u001e\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0003\u001d\u0003\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u00131!\u00138u\u00035\u0019wN\u001c;s_2dWM]%eA\u0005\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)\u0011\u00016KX2\u0011\u0005!\u000b\u0016B\u0001*J\u0005\u0011)f.\u001b;\t\u000bQK\u0001\u0019A+\u0002\u0011I,\u0007\u000f\\5dCN\u00042AV-\\\u001b\u00059&B\u0001-J\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00035^\u00131aU3r!\tQB,\u0003\u0002^'\t\u0019\u0002+\u0019:uSRLwN\\!oIJ+\u0007\u000f\\5dC\")q,\u0003a\u0001A\u0006YA/\u0019:hKR\u001cF/\u0019;f!\tQ\u0012-\u0003\u0002c'\ta!+\u001a9mS\u000e\f7\u000b^1uK\"9A-\u0003I\u0001\u0002\u0004)\u0017aE2p]R\f\u0017N\\:BY2\u0014V\r\u001d7jG\u0006\u001c\bC\u0001%g\u0013\t9\u0017JA\u0004C_>dW-\u00198\u00029!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\t!N\u000b\u0002fW.\nA\u000e\u0005\u0002ne6\taN\u0003\u0002pa\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003c&\u000b!\"\u00198o_R\fG/[8o\u0013\t\u0019hNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fA\u0003Z8IC:$G.Z*uCR,7\t[1oO\u0016\u001cH\u0003\u0002)wqfDQa^\u0006A\u0002\u001d\u000b\u0011B]3qY&\u001c\u0017-\u00133\t\u000bQ[\u0001\u0019A+\t\u000b}[\u0001\u0019\u00011\u0002+I,Wn\u001c<f%\u0016\u0004H.[2bg\u001a\u0013x.\\%teR)A0a\u000b\u0002.A9Q0!\u0003\u0002\u0010\u0005\u0015bb\u0001@\u0002\u0006A\u0011q0S\u0007\u0003\u0003\u0003Q1!a\u0001\u0018\u0003\u0019a$o\\8u}%\u0019\u0011qA%\u0002\rA\u0013X\rZ3g\u0013\u0011\tY!!\u0004\u0003\u00075\u000b\u0007OC\u0002\u0002\b%\u0003B!!\u0005\u0002\"5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0004d_6lwN\u001c\u0006\u0004-\u0005e!\u0002BA\u000e\u0003;\ta!\u00199bG\",'BAA\u0010\u0003\ry'oZ\u0005\u0005\u0003G\t\u0019B\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0007i\t9#C\u0002\u0002*M\u00111\u0004T3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007\"B<\r\u0001\u00049\u0005bBA\u0018\u0019\u0001\u0007\u0011\u0011G\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b\u0003\u0002,Z\u0003\u001f\tq\u0003Z8SK6|g/\u001a*fa2L7-Y:Ge>l\u0017j\u001d:\u0015\r\u0005]\u0012qKA-!\u001dA\u0015\u0011HA\u001f\u0003cI1!a\u000fJ\u0005\u0019!V\u000f\u001d7feA9Q0!\u0003\u0002\u0010\u0005}\u0002\u0003CA!\u0003\u0017\n\t&!\n\u000f\t\u0005\r\u0013q\t\b\u0004\u007f\u0006\u0015\u0013\"\u0001&\n\u0007\u0005%\u0013*A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0013q\n\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\u0005%\u0013\n\u0005\u0003\u0002B\u0005M\u0013\u0002BA+\u0003\u001f\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\t\u000b]l\u0001\u0019A$\t\u000f\u0005=R\u00021\u0001\u00022\u0005ir-\u001a;U_BL7\rU1si&$\u0018n\u001c8Ti\u0006$Xm\u001d$s_6T6\u000e\u0006\u0003\u0002`\u0005E\u0004c\u0002%\u0002:\u0005\u0005\u0014\u0011\u0007\t\b{\u0006%\u0011qBA2!!\t\t%a\u0013\u0002R\u0005\u0015\u0004\u0003BA4\u0003[j!!!\u001b\u000b\u0007\u0005-T#A\u0002ba&LA!a\u001c\u0002j\taA*Z1eKJ\fe\u000eZ%te\"9\u0011q\u0006\bA\u0002\u0005E\u0012a\u00067pON+8mY3tg\u001a,H\u000e\u0016:b]NLG/[8o)-\u0001\u0016qOA>\u0003{\n\t)!\"\t\r\u0005et\u00021\u0001,\u0003\u0019awnZ4fe\")qo\u0004a\u0001\u000f\"9\u0011qP\bA\u0002\u0005=\u0011!\u00039beRLG/[8o\u0011\u0019\t\u0019i\u0004a\u0001A\u0006I1-\u001e:s'R\fG/\u001a\u0005\u0006?>\u0001\r\u0001Y\u0001\u0015Y><\u0017J\u001c<bY&$GK]1og&$\u0018n\u001c8\u0015\u000bA\u000bY)a$\t\r\u00055\u0005\u00031\u0001\\\u0003\u001d\u0011X\r\u001d7jG\u0006DQa\u0018\tA\u0002\u0001\fA\u0003\\8h\r\u0006LG.\u001a3Ti\u0006$Xm\u00115b]\u001e,G#\u0003)\u0002\u0016\u0006]\u0015\u0011TAN\u0011\u0019\ti)\u0005a\u00017\"1\u00111Q\tA\u0002\u0001DQaX\tA\u0002\u0001Dq!!(\u0012\u0001\u0004\ty*A\u0001u!\u0011\t\t%!)\n\t\u0005\r\u0016q\n\u0002\n)\"\u0014xn^1cY\u0016\u0004")
public class ZkReplicaStateMachine
extends ReplicaStateMachine {
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final KafkaZkClient zkClient;
    private final ControllerBrokerRequestBatch controllerBrokerRequestBatch;
    private final int controllerId;

    private int controllerId() {
        return this.controllerId;
    }

    @Override
    public void handleStateChanges(Seq<PartitionAndReplica> replicas2, ReplicaState targetState, boolean containsAllReplicas) {
        if (replicas2.nonEmpty()) {
            try {
                this.controllerBrokerRequestBatch.newBatch();
                replicas2.groupBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.replica())).foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(replicaId, replicas) -> {
                    ZkReplicaStateMachine.$anonfun$handleStateChanges$2(this, containsAllReplicas, targetState, BoxesRunTime.unboxToInt((Object)replicaId), replicas);
                    return BoxedUnit.UNIT;
                }, arg_0, arg_1));
                this.controllerBrokerRequestBatch.sendRequestsToBrokers(this.controllerContext.epoch());
                return;
            }
            catch (ControllerMovedException e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Controller moved to another broker when moving some replicas to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Error while moving some replicas to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
        }
    }

    @Override
    public boolean handleStateChanges$default$3() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void doHandleStateChanges(int replicaId, Seq<PartitionAndReplica> replicas, ReplicaState targetState) {
        void var7_7;
        void var8_8;
        StateChangeLogger stateLogger = this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch());
        boolean traceEnabled = stateLogger.isTraceEnabled();
        replicas.foreach((Function1 & Serializable)replica -> {
            this.controllerContext.putReplicaStateIfNotExists(replica, NonExistentReplica$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Tuple2<Seq<PartitionAndReplica>, Seq<PartitionAndReplica>> tuple2 = this.controllerContext.checkValidReplicaStateChange(replicas, targetState);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq validReplicas = (Seq)tuple2._1();
        Seq invalidReplicas = (Seq)tuple2._2();
        var8_8.foreach((Function1 & Serializable)replica -> {
            this.logInvalidTransition(replica, targetState);
            return BoxedUnit.UNIT;
        });
        if (NewReplica$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$3(this, replicaId, traceEnabled, stateLogger, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (OnlineReplica$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$4(this, replicaId, traceEnabled, stateLogger, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (OfflineReplica$.MODULE$.equals(targetState)) {
            void var11_11;
            void var10_10;
            var7_7.foreach((Function1 & Serializable)replica -> {
                this.controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{replicaId}))), replica.topicPartition(), false);
                return BoxedUnit.UNIT;
            });
            Tuple2 tuple22 = var7_7.partition((Function1 & Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)ZkReplicaStateMachine.$anonfun$doHandleStateChanges$8(this, replica)));
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Seq replicasWithLeadershipInfo = (Seq)tuple22._1();
            Seq replicasWithoutLeadershipInfo = (Seq)tuple22._2();
            scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> updatedLeaderIsrAndControllerEpochs = this.removeReplicasFromIsr(replicaId, (Seq<TopicPartition>)((Seq)var10_10.map((Function1 & Serializable)x$5 -> x$5.topicPartition())));
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partition, leaderIsrAndControllerEpoch) -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$10(this, stateLogger, replicaId, traceEnabled, partition, leaderIsrAndControllerEpoch);
                return BoxedUnit.UNIT;
            };
            updatedLeaderIsrAndControllerEpochs.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
            Object var13_13 = null;
            var11_11.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$13(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (ReplicaDeletionStarted$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$14(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (ReplicaDeletionIneligible$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$15(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (ReplicaDeletionSuccessful$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$16(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (NonExistentReplica$.MODULE$.equals(targetState)) {
            var7_7.foreach((Function1 & Serializable)replica -> {
                ZkReplicaStateMachine.$anonfun$doHandleStateChanges$17(this, traceEnabled, stateLogger, replicaId, replica);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)targetState);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> removeReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        ObjectRef results = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        Seq<TopicPartition> remaining = partitions;
        while (remaining.nonEmpty()) {
            void var6_6;
            void var7_7;
            Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderIsrAndControllerEpoch>>, Seq<TopicPartition>> tuple2 = this.doRemoveReplicasFromIsr(replicaId, remaining);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            scala.collection.immutable.Map finishedRemoval = (scala.collection.immutable.Map)tuple2._1();
            Seq removalsToRetry = (Seq)tuple2._2();
            remaining = var7_7;
            var6_6.foreach((Function1 & Serializable)x0$1 -> {
                ZkReplicaStateMachine.$anonfun$removeReplicasFromIsr$1(this, replicaId, results, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return (scala.collection.immutable.Map)results.elem;
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderIsrAndControllerEpoch>>, Seq<TopicPartition>> doRemoveReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        void var12_12;
        void var11_11;
        void var8_8;
        void var5_5;
        void var7_7;
        void var4_4;
        Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> tuple2 = this.getTopicPartitionStatesFromZk(partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Map leaderAndIsrs = (scala.collection.immutable.Map)tuple2._1();
        Seq partitionsWithNoLeaderAndIsrInZk = (Seq)tuple2._2();
        Tuple2 tuple22 = var4_4.partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$1(replicaId, x0$1)));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Map leaderAndIsrsWithReplica = (scala.collection.immutable.Map)tuple22._1();
        scala.collection.immutable.Map leaderAndIsrsWithoutReplica = (scala.collection.immutable.Map)tuple22._2();
        scala.collection.immutable.Map adjustedLeaderAndIsrs = (scala.collection.immutable.Map)var7_7.flatMap((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$2._1();
            Option option = ((Either)x0$2._2()).toOption().map((Function1 & Serializable)leaderAndIsr -> {
                int newLeader = replicaId == leaderAndIsr.leader() ? LeaderAndIsr$.MODULE$.NoLeader() : leaderAndIsr.leader();
                List adjustedIsr = leaderAndIsr.isr().size() == 1 ? leaderAndIsr.isr() : leaderAndIsr.isr().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$10 -> x$10 != replicaId);
                boolean isUnclean = newLeader == LeaderAndIsr$.MODULE$.NoLeader() ? false : leaderAndIsr.isUnclean();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderAndIsr.newLeaderAndIsr(newLeader, (List<Object>)adjustedIsr, isUnclean));
            });
            return option;
        });
        KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.controllerContext.epoch(), this.controllerContext.epochZkVersion());
        if (updateLeaderAndIsrResult == null) {
            throw new MatchError(null);
        }
        Map<TopicPartition, Either<Exception, LeaderAndIsr>> finishedPartitions = updateLeaderAndIsrResult.finishedPartitions();
        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
        scala.collection.immutable.Map exceptionsForPartitionsWithNoLeaderAndIsrInZk = var5_5.iterator().flatMap((Function1 & Serializable)partition -> {
            if (!$this.controllerContext.isTopicQueuedUpForDeletion(partition.topic())) {
                StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(26).append(new StringBuilder(75).append("Failed to change state of replica ").append(replicaId).append(" for partition ").append(partition).append(" since the leader and isr ").toString()).append("path in zookeeper is empty").toString());
                return Option$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), (Object)package$.MODULE$.Left().apply((Object)exception)));
            }
            return None$.MODULE$;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map leaderIsrAndControllerEpochs = (scala.collection.immutable.Map)((MapOps)var8_8.$plus$plus((IterableOnce)var11_11)).map((Function1 & Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$3._1();
            Either result = (Either)x0$3._2();
            Tuple2 tuple2 = new Tuple2((Object)partition, (Object)result.map((Function1 & Serializable)leaderAndIsr -> {
                void var3_3;
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch((LeaderAndIsr)leaderAndIsr, $this.controllerContext.epoch());
                $this.controllerContext.putPartitionLeadershipInfo(partition, leaderIsrAndControllerEpoch);
                return var3_3;
            }));
            return tuple2;
        });
        return new Tuple2((Object)leaderIsrAndControllerEpochs.$plus$plus((IterableOnce)exceptionsForPartitionsWithNoLeaderAndIsrInZk), (Object)var12_12);
    }

    private Tuple2<scala.collection.immutable.Map<TopicPartition, Either<Exception, LeaderAndIsr>>, Seq<TopicPartition>> getTopicPartitionStatesFromZk(Seq<TopicPartition> partitions) {
        Seq<GetDataResponse> seq;
        try {
            seq = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception e) {
            return new Tuple2((Object)partitions.iterator().map((Function1 & Serializable)x$12 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$12), (Object)package$.MODULE$.Left().apply((Object)e))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Seq$.MODULE$.empty());
        }
        Seq<GetDataResponse> getDataResponses = seq;
        Buffer partitionsWithNoLeaderAndIsrInZk = (Buffer)Buffer$.MODULE$.empty();
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        getDataResponses.foreach((Function1 & Serializable)getDataResponse -> {
            ZkReplicaStateMachine.$anonfun$getTopicPartitionStatesFromZk$2(this, partitionsWithNoLeaderAndIsrInZk, result, getDataResponse);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)result.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)partitionsWithNoLeaderAndIsrInZk);
    }

    private void logSuccessfulTransition(StateChangeLogger logger, int replicaId, TopicPartition partition, ReplicaState currState, ReplicaState targetState) {
        logger.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Changed state of replica ").append(replicaId).append(" for partition ").append(partition).append(" from ").append(currState).append(" to ").append(targetState).toString());
    }

    private void logInvalidTransition(PartitionAndReplica replica, ReplicaState targetState) {
        ReplicaState currState = this.controllerContext.replicaState(replica);
        IllegalStateException e = new IllegalStateException(new StringBuilder(0).append(new StringBuilder(27).append("Replica ").append(replica).append(" should be in the ").append(targetState.validPreviousStates().mkString(",")).append(" ").toString()).append(new StringBuilder(55).append("states before moving to ").append(targetState).append(" state. Instead it is in ").append(currState).append(" state").toString()).toString());
        this.logFailedStateChange(replica, currState, targetState, e);
    }

    private void logFailedStateChange(PartitionAndReplica replica, ReplicaState currState, ReplicaState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(54).append("Controller ").append(this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" initiated state change of replica ").append(replica.replica()).append(" ").toString()).append(new StringBuilder(31).append("for partition ").append(replica.topicPartition()).append(" from ").append(currState).append(" to ").append(targetState).append(" failed").toString()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
    }

    public static final /* synthetic */ void $anonfun$handleStateChanges$2(ZkReplicaStateMachine $this, boolean containsAllReplicas$1, ReplicaState targetState$1, int replicaId, Seq replicas) {
        if (containsAllReplicas$1) {
            $this.controllerBrokerRequestBatch.setContainsAllReplicas((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{replicaId}))));
        }
        $this.doHandleStateChanges(replicaId, (Seq<PartitionAndReplica>)replicas, targetState$1);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$3(ZkReplicaStateMachine $this, int replicaId$1, boolean traceEnabled$1, StateChangeLogger stateLogger$1, PartitionAndReplica replica) {
        TopicPartition partition = replica.topicPartition();
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        Option<LeaderIsrAndControllerEpoch> option = $this.controllerContext.partitionLeadershipInfo(partition);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
            if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == replicaId$1) {
                StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(101).append("Replica ").append(replicaId$1).append(" for partition ").append(partition).append(" cannot be moved to NewReplica state as it is being requested to become leader").toString());
                $this.logFailedStateChange(replica, currentState, OfflineReplica$.MODULE$, exception);
                return;
            }
            $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{replicaId$1}))), replica.topicPartition(), leaderIsrAndControllerEpoch, $this.controllerContext.partitionFullReplicaAssignment(replica.topicPartition()), true);
            if (traceEnabled$1) {
                $this.logSuccessfulTransition(stateLogger$1, replicaId$1, partition, currentState, NewReplica$.MODULE$);
            }
            $this.controllerContext.putReplicaState(replica, NewReplica$.MODULE$);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (traceEnabled$1) {
                $this.logSuccessfulTransition(stateLogger$1, replicaId$1, partition, currentState, NewReplica$.MODULE$);
            }
            $this.controllerContext.putReplicaState(replica, NewReplica$.MODULE$);
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$4(ZkReplicaStateMachine $this, int replicaId$1, boolean traceEnabled$1, StateChangeLogger stateLogger$1, PartitionAndReplica replica) {
        TopicPartition partition = replica.topicPartition();
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (NewReplica$.MODULE$.equals(currentState)) {
            ReplicaAssignment assignment = $this.controllerContext.partitionFullReplicaAssignment(partition);
            if (!assignment.replicas().contains((Object)BoxesRunTime.boxToInteger((int)replicaId$1))) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Adding replica (").append(replicaId$1).append(") that is not part of the assignment ").append(assignment).toString());
                ReplicaAssignment newAssignment = assignment.copy((Seq<Object>)((Seq)assignment.replicas().$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaId$1))), assignment.copy$default$2(), assignment.copy$default$3(), assignment.copy$default$4(), assignment.copy$default$5());
                $this.controllerContext.updatePartitionFullReplicaAssignment(partition, newAssignment);
            }
        } else if (!$this.controllerContext.isTopicQueuedUpForDeletion(partition.topic())) {
            Option<LeaderIsrAndControllerEpoch> option = $this.controllerContext.partitionLeadershipInfo(partition);
            if (option instanceof Some) {
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{replicaId$1}))), replica.topicPartition(), leaderIsrAndControllerEpoch, $this.controllerContext.partitionFullReplicaAssignment(partition), false);
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
        } else {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("OnlineReplica is in deleting state ").append(partition).append(". Not adding it to the LeaderAndIsrRequest").toString());
        }
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, partition, currentState, OnlineReplica$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, OnlineReplica$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$8(ZkReplicaStateMachine $this, PartitionAndReplica replica) {
        return $this.controllerContext.partitionLeadershipInfo(replica.topicPartition()).isDefined();
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$10(ZkReplicaStateMachine $this, StateChangeLogger stateLogger$1, int replicaId$1, boolean traceEnabled$1, TopicPartition partition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch) {
        stateLogger$1.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(91).append("Partition ").append(partition).append(" state changed to ").append(leaderIsrAndControllerEpoch).append(" after removing replica ").append(replicaId$1).append(" from the ISR as part of transition to ").append(OfflineReplica$.MODULE$).toString());
        if (!$this.controllerContext.isTopicQueuedUpForDeletion(partition.topic())) {
            Seq recipients = (Seq)$this.controllerContext.partitionReplicaAssignment(partition).filterNot((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 == replicaId$1);
            $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)recipients, partition, leaderIsrAndControllerEpoch, $this.controllerContext.partitionFullReplicaAssignment(partition), false);
        }
        PartitionAndReplica replica = new PartitionAndReplica(partition, replicaId$1);
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, partition, currentState, OfflineReplica$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, OfflineReplica$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$13(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, OfflineReplica$.MODULE$);
        }
        $this.controllerBrokerRequestBatch.addUpdateMetadataRequestForBrokers((Seq<Object>)$this.controllerContext.liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{replica.topicPartition()}))));
        $this.controllerContext.putReplicaState(replica, OfflineReplica$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$14(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionStarted$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, ReplicaDeletionStarted$.MODULE$);
        $this.controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{replicaId$1}))), replica.topicPartition(), true);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$15(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionIneligible$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, ReplicaDeletionIneligible$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$16(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, ReplicaDeletionSuccessful$.MODULE$);
        }
        $this.controllerContext.putReplicaState(replica, ReplicaDeletionSuccessful$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$17(ZkReplicaStateMachine $this, boolean traceEnabled$1, StateChangeLogger stateLogger$1, int replicaId$1, PartitionAndReplica replica) {
        ReplicaState currentState = $this.controllerContext.replicaState(replica);
        ReplicaAssignment newAssignedReplicas = $this.controllerContext.partitionFullReplicaAssignment(replica.topicPartition()).removeReplica(replica.replica());
        $this.controllerContext.updatePartitionFullReplicaAssignment(replica.topicPartition(), newAssignedReplicas);
        if (traceEnabled$1) {
            $this.logSuccessfulTransition(stateLogger$1, replicaId$1, replica.topicPartition(), currentState, NonExistentReplica$.MODULE$);
        }
        $this.controllerContext.removeReplicaState(replica);
    }

    public static final /* synthetic */ void $anonfun$removeReplicasFromIsr$1(ZkReplicaStateMachine $this, int replicaId$2, ObjectRef results$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            Either either = (Either)x0$1._2();
            if (either instanceof Left) {
                Exception e = (Exception)((Left)either).value();
                PartitionAndReplica replica = new PartitionAndReplica(partition, replicaId$2);
                ReplicaState currentState = $this.controllerContext.replicaState(replica);
                $this.logFailedStateChange(replica, currentState, OfflineReplica$.MODULE$, e);
                return;
            }
        }
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            Either either = (Either)x0$1._2();
            if (either instanceof Right) {
                LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)((Right)either).value();
                results$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)results$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndEpoch));
                return;
            }
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveReplicasFromIsr$2(int replicaId$3, LeaderAndIsr leaderAndIsr) {
        return leaderAndIsr.isr().contains((Object)BoxesRunTime.boxToInteger((int)replicaId$3));
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveReplicasFromIsr$1(int replicaId$3, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = BoxesRunTime.unboxToBoolean((Object)((Either)x0$1._2()).map((Function1 & Serializable)leaderAndIsr -> BoxesRunTime.boxToBoolean((boolean)ZkReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$2(replicaId$3, leaderAndIsr))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getTopicPartitionStatesFromZk$2(ZkReplicaStateMachine $this, Buffer partitionsWithNoLeaderAndIsrInZk$1, scala.collection.mutable.Map result$1, GetDataResponse getDataResponse) {
        TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
        KeeperException.Code code = getDataResponse.resultCode();
        KeeperException.Code code2 = KeeperException.Code.OK;
        if (!(code != null ? !code.equals(code2) : code2 != null)) {
            Option<LeaderIsrAndControllerEpoch> option = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
            if (None$.MODULE$.equals(option)) {
                partitionsWithNoLeaderAndIsrInZk$1.$plus$eq((Object)partition);
                return;
            }
            if (option instanceof Some) {
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
                if (leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch()) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(96).append("Leader and isr path written by another controller. This probably ").append(new StringBuilder(73).append("means the current controller with epoch ").append($this.controllerContext.epoch()).append(" went through a soft failure and ").toString()).append(new StringBuilder(53).append("another controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(". Aborting ").toString()).append("state change by this controller").toString());
                    result$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)package$.MODULE$.Left().apply((Object)exception)));
                    return;
                }
                result$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)package$.MODULE$.Right().apply((Object)leaderIsrAndControllerEpoch.leaderAndIsr())));
                return;
            }
            throw new MatchError(option);
        }
        KeeperException.Code code3 = getDataResponse.resultCode();
        KeeperException.Code code4 = KeeperException.Code.NONODE;
        if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
            partitionsWithNoLeaderAndIsrInZk$1.$plus$eq((Object)partition);
            return;
        }
        result$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)package$.MODULE$.Left().apply(getDataResponse.resultException().get())));
    }

    public ZkReplicaStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.stateChangeLogger = stateChangeLogger;
        this.controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        super(controllerContext);
        this.controllerId = config.brokerId();
        this.logIdent_$eq(new StringBuilder(36).append("[ReplicaStateMachine controllerId=").append(this.controllerId()).append("] ").toString());
    }
}

