/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.controller.ControllerContext;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaState;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000593Q\u0001C\u0005\u0002\u00029A\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\u0006A\u0001!\t!\t\u0005\u0006I\u0001!\t!\n\u0005\u0006S\u0001!\t!\n\u0005\u0006U\u0001!I!\n\u0005\u0006W\u00011\t\u0001\f\u0005\b\u0005\u0002\t\n\u0011\"\u0001D\u0005M\u0011V\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0015\tQ1\"\u0001\u0006d_:$(o\u001c7mKJT\u0011\u0001D\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001q\"\u0006\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005YIR\"A\f\u000b\u0005aY\u0011!B;uS2\u001c\u0018B\u0001\u000e\u0018\u0005\u001daunZ4j]\u001e\f\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u!\tib$D\u0001\n\u0013\ty\u0012BA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\fa\u0001P5oSRtDC\u0001\u0012$!\ti\u0002\u0001C\u0003\u001c\u0005\u0001\u0007A$A\u0004ti\u0006\u0014H/\u001e9\u0015\u0003\u0019\u0002\"\u0001E\u0014\n\u0005!\n\"\u0001B+oSR\f\u0001b\u001d5vi\u0012|wO\\\u0001\u0017S:LG/[1mSj,'+\u001a9mS\u000e\f7\u000b^1uK\u0006\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)\u00111S\u0006O\u001f\t\u000b92\u0001\u0019A\u0018\u0002\u0011I,\u0007\u000f\\5dCN\u00042\u0001M\u001a6\u001b\u0005\t$B\u0001\u001a\u0012\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003iE\u00121aU3r!\tib'\u0003\u00028\u0013\t\u0019\u0002+\u0019:uSRLwN\\!oIJ+\u0007\u000f\\5dC\")\u0011H\u0002a\u0001u\u0005YA/\u0019:hKR\u001cF/\u0019;f!\ti2(\u0003\u0002=\u0013\ta!+\u001a9mS\u000e\f7\u000b^1uK\"9aH\u0002I\u0001\u0002\u0004y\u0014aE2p]R\f\u0017N\\:BY2\u0014V\r\u001d7jG\u0006\u001c\bC\u0001\tA\u0013\t\t\u0015CA\u0004C_>dW-\u00198\u00029!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\tAI\u000b\u0002@\u000b.\na\t\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u0017F\t!\"\u00198o_R\fG/[8o\u0013\ti\u0005JA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public abstract class ReplicaStateMachine
implements Logging {
    private final ControllerContext controllerContext;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public void startup() {
        void var3_3;
        void var2_2;
        this.info((Function0<String>)(Function0 & Serializable)() -> "Initializing replica state");
        this.initializeReplicaState();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Triggering online replica state changes");
        Tuple2<Set<PartitionAndReplica>, Set<PartitionAndReplica>> tuple2 = this.controllerContext.onlineAndOfflineReplicas();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Set onlineReplicas = (Set)tuple2._1();
        Set offlineReplicas = (Set)tuple2._2();
        this.handleStateChanges((Seq<PartitionAndReplica>)var2_2.toSeq(), OnlineReplica$.MODULE$, true);
        this.info((Function0<String>)(Function0 & Serializable)() -> "Triggering offline replica state changes");
        this.handleStateChanges((Seq<PartitionAndReplica>)var3_3.toSeq(), OfflineReplica$.MODULE$, this.handleStateChanges$default$3());
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Started replica state machine with initial state -> ").append($this.controllerContext.replicaStates()).toString());
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Stopped replica state machine");
    }

    private void initializeReplicaState() {
        this.controllerContext.allPartitions().foreach((Function1 & Serializable)partition -> {
            ReplicaStateMachine.$anonfun$initializeReplicaState$1(this, partition);
            return BoxedUnit.UNIT;
        });
    }

    public abstract void handleStateChanges(Seq<PartitionAndReplica> var1, ReplicaState var2, boolean var3);

    public boolean handleStateChanges$default$3() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$initializeReplicaState$1(ReplicaStateMachine $this, TopicPartition partition) {
        $this.controllerContext.partitionReplicaAssignment(partition).foreach((Function1)(JFunction1.mcVI.sp & Serializable)replicaId -> {
            PartitionAndReplica partitionAndReplica = new PartitionAndReplica(partition, replicaId);
            if ($this.controllerContext.isReplicaOnline(replicaId, partition, $this.controllerContext.isReplicaOnline$default$3())) {
                $this.controllerContext.putReplicaState(partitionAndReplica, OnlineReplica$.MODULE$);
                return;
            }
            $this.controllerContext.putReplicaState(partitionAndReplica, ReplicaDeletionIneligible$.MODULE$);
        });
    }

    public ReplicaStateMachine(ControllerContext controllerContext) {
        this.controllerContext = controllerContext;
    }
}

