/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin.balancer;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import joptsimple.OptionSpec;
import kafka.admin.balancer.ClusterRebalanceCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerStatusDescription;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;
import org.apache.kafka.clients.admin.EvenClusterLoadStatusDescription;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxedUnit;

public final class ClusterRebalanceCommand$
implements Logging {
    public static final ClusterRebalanceCommand$ MODULE$ = new ClusterRebalanceCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        block19: {
            int exitCode = 0;
            None$ clientOpt = None$.MODULE$;
            try {
                try {
                    ClusterRebalanceCommandOptions opts = new ClusterRebalanceCommandOptions(args);
                    opts.checkArgs();
                    clientOpt = new Some((Object)this.createAdminClient(opts));
                    if (opts.options().has((OptionSpec)opts.statusOpt())) {
                        try {
                            ClusterRebalanceCommand$.MODULE$.describeBalancerStatus((ConfluentAdmin)clientOpt.get());
                            break block19;
                        }
                        catch (ApiException runBalancerCommand_e) {
                            if (runBalancerCommand_e instanceof TimeoutException) {
                                throw new AdminCommandFailedException("Timed out waiting for the balancer status", runBalancerCommand_e);
                            }
                            if (runBalancerCommand_e instanceof ClusterAuthorizationException) {
                                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)runBalancerCommand_e;
                                throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), runBalancerCommand_e);
                            }
                            if (runBalancerCommand_e instanceof BalancerOfflineException) {
                                BalancerOfflineException balancerOfflineException = (BalancerOfflineException)runBalancerCommand_e;
                                throw new AdminCommandFailedException(balancerOfflineException.getMessage(), (Throwable)balancerOfflineException);
                            }
                            throw runBalancerCommand_e;
                        }
                        catch (Throwable runBalancerCommand_e) {
                            Predef$.MODULE$.println((Object)"Error while issuing the balancer status request");
                            throw runBalancerCommand_e;
                        }
                    }
                    if (!opts.options().has((OptionSpec)opts.describeOpt())) break block19;
                    try {
                        ClusterRebalanceCommand$.MODULE$.describeAnyUnevenLoadTask((ConfluentAdmin)clientOpt.get());
                    }
                    catch (ApiException runBalancerCommand_e) {
                        if (runBalancerCommand_e instanceof TimeoutException) {
                            throw new AdminCommandFailedException("Timed out waiting for the balancer status", runBalancerCommand_e);
                        }
                        if (runBalancerCommand_e instanceof ClusterAuthorizationException) {
                            ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)runBalancerCommand_e;
                            throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), runBalancerCommand_e);
                        }
                        if (runBalancerCommand_e instanceof BalancerOfflineException) {
                            BalancerOfflineException balancerOfflineException = (BalancerOfflineException)runBalancerCommand_e;
                            throw new AdminCommandFailedException(balancerOfflineException.getMessage(), (Throwable)balancerOfflineException);
                        }
                        throw runBalancerCommand_e;
                    }
                    catch (Throwable runBalancerCommand_e) {
                        Predef$.MODULE$.println((Object)"Error while issuing the balancer status request");
                        throw runBalancerCommand_e;
                    }
                }
                catch (Throwable e) {
                    Predef$.MODULE$.println((Object)new StringBuilder(78).append("Unexpected error while running the kafka-rebalance-cluster command-line tool: ").append(e.getMessage()).toString());
                    if (this.logger().underlying().isErrorEnabled()) {
                        String string;
                        String string2 = string = Utils.stackTrace((Throwable)e);
                        string = null;
                        String msgWithLogIdent_msg = string2;
                        Object var15_15 = null;
                        this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                    }
                    exitCode = 1;
                }
            }
            finally {
                clientOpt.foreach((Function1 & Serializable)x$1 -> {
                    x$1.close();
                    return BoxedUnit.UNIT;
                });
                Exit.exit((int)exitCode, null);
            }
        }
    }

    public void runBalancerCommand(ClusterRebalanceCommandOptions opts, ConfluentAdmin client, Function1<ConfluentAdmin, BoxedUnit> adminOperation) {
        try {
            adminOperation.apply((Object)client);
            return;
        }
        catch (ApiException e) {
            if (e instanceof TimeoutException) {
                throw new AdminCommandFailedException("Timed out waiting for the balancer status", e);
            }
            if (e instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)e;
                throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), e);
            }
            if (e instanceof BalancerOfflineException) {
                BalancerOfflineException balancerOfflineException = (BalancerOfflineException)e;
                throw new AdminCommandFailedException(balancerOfflineException.getMessage(), (Throwable)balancerOfflineException);
            }
            throw e;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)"Error while issuing the balancer status request");
            throw e;
        }
    }

    public void describeBalancerStatus(ConfluentAdmin client) {
        String lineSeparator = new StringBuilder(2).append(System.lineSeparator()).append("  ").toString();
        BalancerStatusDescription balancerStatusDescription = (BalancerStatusDescription)client.describeBalancerStatus().description().get();
        String balancerStatusString = new StringBuilder(17).append("Balancer status: ").append(balancerStatusDescription.balancerStatus()).toString();
        if (balancerStatusDescription.balancerOperationError().isPresent()) {
            balancerStatusString = new StringBuilder(0).append(balancerStatusString).append(String.valueOf(lineSeparator)).toString();
            balancerStatusString = new StringBuilder(0).append(balancerStatusString).append(new StringBuilder(2).append(((BalancerOperationError)balancerStatusDescription.balancerOperationError().get()).exception().getClass().getName()).append(": ").append(((BalancerOperationError)balancerStatusDescription.balancerOperationError().get()).errorMessage()).toString()).toString();
        }
        Predef$.MODULE$.println((Object)balancerStatusString);
    }

    public void describeAnyUnevenLoadTask(ConfluentAdmin client) {
        String lineSeparator = new StringBuilder(2).append(System.lineSeparator()).append("  ").toString();
        EvenClusterLoadStatusDescription balancerUnevenLoadTaskDescription = (EvenClusterLoadStatusDescription)client.describeEvenClusterLoadStatus().description().get();
        EvenClusterLoadStatus currentBalancerUnevenLoadStatus = balancerUnevenLoadTaskDescription.currentEvenClusterLoadStatus();
        boolean processedError = false;
        String unevenLoadTaskDescriptionString = new StringBuilder(27).append("Uneven load balance status:").append(lineSeparator).toString();
        unevenLoadTaskDescriptionString = new StringBuilder(0).append(unevenLoadTaskDescriptionString).append(new StringBuilder(9).append("Current: ").append(currentBalancerUnevenLoadStatus).toString()).toString();
        if (currentBalancerUnevenLoadStatus.equals((Object)EvenClusterLoadStatus.BALANCING_FAILED)) {
            unevenLoadTaskDescriptionString = new StringBuilder(0).append(unevenLoadTaskDescriptionString).append(new StringBuilder(2).append(lineSeparator).append(((BalancerOperationError)balancerUnevenLoadTaskDescription.evenClusterLoadError().get()).exception().getClass().getName()).append(": ").append(((BalancerOperationError)balancerUnevenLoadTaskDescription.evenClusterLoadError().get()).errorMessage()).toString()).toString();
            processedError = true;
        }
        if (this.shouldDisplayPreviousUnevenLoadStatus(currentBalancerUnevenLoadStatus)) {
            unevenLoadTaskDescriptionString = new StringBuilder(0).append(unevenLoadTaskDescriptionString).append(new StringBuilder(18).append(lineSeparator).append("Last Update Time: ").append(ClientUtils.utcDateFor((long)balancerUnevenLoadTaskDescription.currentStatusLastUpdatetimeMs())).toString()).toString();
        }
        if (balancerUnevenLoadTaskDescription.previousEvenClusterLoadStatus() != null) {
            unevenLoadTaskDescriptionString = new StringBuilder(0).append(unevenLoadTaskDescriptionString).append(new StringBuilder(10).append(lineSeparator).append("Previous: ").append(balancerUnevenLoadTaskDescription.previousEvenClusterLoadStatus()).toString()).toString();
            if (!processedError && balancerUnevenLoadTaskDescription.previousEvenClusterLoadStatus().equals((Object)EvenClusterLoadStatus.BALANCING_FAILED)) {
                unevenLoadTaskDescriptionString = new StringBuilder(0).append(unevenLoadTaskDescriptionString).append(new StringBuilder(2).append(lineSeparator).append(((BalancerOperationError)balancerUnevenLoadTaskDescription.evenClusterLoadError().get()).exception().getClass().getName()).append(": ").append(((BalancerOperationError)balancerUnevenLoadTaskDescription.evenClusterLoadError().get()).errorMessage()).toString()).toString();
            }
            EvenClusterLoadStatus shouldDisplayUnevenLoadStatusUpdateTime_evenClusterLoadStatus = balancerUnevenLoadTaskDescription.previousEvenClusterLoadStatus();
            Object var7_7 = null;
            if (this.shouldDisplayPreviousUnevenLoadStatus(shouldDisplayUnevenLoadStatusUpdateTime_evenClusterLoadStatus)) {
                unevenLoadTaskDescriptionString = new StringBuilder(0).append(unevenLoadTaskDescriptionString).append(new StringBuilder(18).append(lineSeparator).append("Last Update Time: ").append(ClientUtils.utcDateFor((long)balancerUnevenLoadTaskDescription.previousStatusLastUpdatetimeMs())).toString()).toString();
            }
        }
        Predef$.MODULE$.println((Object)unevenLoadTaskDescriptionString);
    }

    private boolean eligibleToDisplayError(EvenClusterLoadStatus evenClusterLoadStatus) {
        return evenClusterLoadStatus.equals((Object)EvenClusterLoadStatus.BALANCING_FAILED);
    }

    public boolean shouldDisplayPreviousUnevenLoadStatus(EvenClusterLoadStatus evenClusterLoadStatus) {
        return !evenClusterLoadStatus.equals((Object)EvenClusterLoadStatus.DISABLED) && !evenClusterLoadStatus.equals((Object)EvenClusterLoadStatus.STARTING);
    }

    private boolean shouldDisplayUnevenLoadStatusUpdateTime(EvenClusterLoadStatus evenClusterLoadStatus) {
        return this.shouldDisplayPreviousUnevenLoadStatus(evenClusterLoadStatus);
    }

    private ConfluentAdmin createAdminClient(ClusterRebalanceCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt())), null) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options().valueOf(opts.bootstrapServer()));
        return (ConfluentAdmin)Admin.create((Properties)props);
    }

    public static final /* synthetic */ String $anonfun$main$3(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    private ClusterRebalanceCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(ConfluentAdmin client) {
        ClusterRebalanceCommand$.MODULE$.describeBalancerStatus(client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$main$2$adapted(ConfluentAdmin client) {
        ClusterRebalanceCommand$.MODULE$.describeAnyUnevenLoadTask(client);
        return BoxedUnit.UNIT;
    }
}

